//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsaas

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// Client contains the methods for the SaaS group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	internal *arm.Client
}

// NewClient creates a new instance of Client with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*Client, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &Client{
		internal: cl,
	}
	return client, nil
}

// BeginCreateResource - Creates a SaaS resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
//   - parameters - Parameters supplied to the create saas operation.
//   - options - ClientBeginCreateResourceOptions contains the optional parameters for the Client.BeginCreateResource method.
func (client *Client) BeginCreateResource(ctx context.Context, parameters ResourceCreation, options *ClientBeginCreateResourceOptions) (*runtime.Poller[ClientCreateResourceResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createResource(ctx, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientCreateResourceResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientCreateResourceResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateResource - Creates a SaaS resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
func (client *Client) createResource(ctx context.Context, parameters ResourceCreation, options *ClientBeginCreateResourceOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginCreateResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createResourceCreateRequest(ctx, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createResourceCreateRequest creates the CreateResource request.
func (client *Client) createResourceCreateRequest(ctx context.Context, parameters ResourceCreation, options *ClientBeginCreateResourceOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.SaaS/saasresources"
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-03-01-beta")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the specified SaaS.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
//   - resourceID - The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
//   - parameters - Parameters supplied to delete saas operation.
//   - options - ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
func (client *Client) BeginDelete(ctx context.Context, resourceID string, parameters DeleteOptions, options *ClientBeginDeleteOptions) (*runtime.Poller[ClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceID, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the specified SaaS.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
func (client *Client) deleteOperation(ctx context.Context, resourceID string, parameters DeleteOptions, options *ClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceID, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *Client) deleteCreateRequest(ctx context.Context, resourceID string, parameters DeleteOptions, options *ClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.SaaS/saasresources/{resourceId}"
	if resourceID == "" {
		return nil, errors.New("parameter resourceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", url.PathEscape(resourceID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-03-01-beta")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// GetResource - Gets information about the specified SaaS.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
//   - resourceID - The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
//   - options - ClientGetResourceOptions contains the optional parameters for the Client.GetResource method.
func (client *Client) GetResource(ctx context.Context, resourceID string, options *ClientGetResourceOptions) (ClientGetResourceResponse, error) {
	var err error
	const operationName = "Client.GetResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getResourceCreateRequest(ctx, resourceID, options)
	if err != nil {
		return ClientGetResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetResourceResponse{}, err
	}
	resp, err := client.getResourceHandleResponse(httpResp)
	return resp, err
}

// getResourceCreateRequest creates the GetResource request.
func (client *Client) getResourceCreateRequest(ctx context.Context, resourceID string, options *ClientGetResourceOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.SaaS/saasresources/{resourceId}"
	if resourceID == "" {
		return nil, errors.New("parameter resourceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", url.PathEscape(resourceID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-03-01-beta")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourceHandleResponse handles the GetResource response.
func (client *Client) getResourceHandleResponse(resp *http.Response) (ClientGetResourceResponse, error) {
	result := ClientGetResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Resource); err != nil {
		return ClientGetResourceResponse{}, err
	}
	return result, nil
}

// BeginUpdateResource - Updates a SaaS resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
//   - resourceID - The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
//   - parameters - Parameters supplied to the update saas operation.
//   - options - ClientBeginUpdateResourceOptions contains the optional parameters for the Client.BeginUpdateResource method.
func (client *Client) BeginUpdateResource(ctx context.Context, resourceID string, parameters ResourceCreation, options *ClientBeginUpdateResourceOptions) (*runtime.Poller[ClientUpdateResourceResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateResource(ctx, resourceID, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientUpdateResourceResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientUpdateResourceResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateResource - Updates a SaaS resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
func (client *Client) updateResource(ctx context.Context, resourceID string, parameters ResourceCreation, options *ClientBeginUpdateResourceOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginUpdateResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateResourceCreateRequest(ctx, resourceID, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateResourceCreateRequest creates the UpdateResource request.
func (client *Client) updateResourceCreateRequest(ctx context.Context, resourceID string, parameters ResourceCreation, options *ClientBeginUpdateResourceOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.SaaS/saasresources/{resourceId}"
	if resourceID == "" {
		return nil, errors.New("parameter resourceID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", url.PathEscape(resourceID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-03-01-beta")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
