//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkcloud_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_ListBySubscription.json
func ExampleBareMetalMachinesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewBareMetalMachinesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BareMetalMachineList = armnetworkcloud.BareMetalMachineList{
		// 	Value: []*armnetworkcloud.BareMetalMachine{
		// 		{
		// 			Name: to.Ptr("bareMetalMachineName"),
		// 			Type: to.Ptr("Microsoft.NetworkCloud/bareMetalMachines"),
		// 			ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
		// 			SystemData: &armnetworkcloud.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
		// 				CreatedBy: to.Ptr("identityA"),
		// 				CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("identityB"),
		// 				LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("location"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("myvalue1"),
		// 				"key2": to.Ptr("myvalue2"),
		// 			},
		// 			ExtendedLocation: &armnetworkcloud.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
		// 				Type: to.Ptr("CustomLocation"),
		// 			},
		// 			Properties: &armnetworkcloud.BareMetalMachineProperties{
		// 				AssociatedResourceIDs: []*string{
		// 					to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName")},
		// 					BmcConnectionString: to.Ptr("bmcconnectionstring"),
		// 					BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
		// 						Username: to.Ptr("bmcuser"),
		// 					},
		// 					BmcMacAddress: to.Ptr("00:00:4f:00:57:00"),
		// 					BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
		// 					ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
		// 					CordonStatus: to.Ptr(armnetworkcloud.BareMetalMachineCordonStatusUncordoned),
		// 					DetailedStatus: to.Ptr(armnetworkcloud.BareMetalMachineDetailedStatusAvailable),
		// 					DetailedStatusMessage: to.Ptr("DetailedStatusMessage"),
		// 					HardwareInventory: &armnetworkcloud.HardwareInventory{
		// 						AdditionalHostInformation: to.Ptr("Machine specific information..."),
		// 						Interfaces: []*armnetworkcloud.HardwareInventoryNetworkInterface{
		// 							{
		// 								Name: to.Ptr("networkInterfaceName"),
		// 								LinkStatus: to.Ptr("Up"),
		// 								MacAddress: to.Ptr("2C:54:91:88:C9:E3"),
		// 								NetworkInterfaceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkDevices/networkDeviceName/networkInterfaces/networkInterfaceName"),
		// 						}},
		// 					},
		// 					HardwareValidationStatus: &armnetworkcloud.HardwareValidationStatus{
		// 						LastValidationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-30T13:27:03.008Z"); return t}()),
		// 						Result: to.Ptr(armnetworkcloud.BareMetalMachineHardwareValidationResultPass),
		// 					},
		// 					KubernetesNodeName: to.Ptr("node01"),
		// 					KubernetesVersion: to.Ptr("1.21"),
		// 					MachineDetails: to.Ptr("User-provided machine details."),
		// 					MachineName: to.Ptr("r01c001"),
		// 					MachineSKUID: to.Ptr("684E-3B16-399E"),
		// 					OamIPv4Address: to.Ptr("192.0.2.1"),
		// 					OamIPv6Address: to.Ptr("0:0:0:0:0:FFFF:7F00:0001"),
		// 					OSImage: to.Ptr("v20220805e"),
		// 					PowerState: to.Ptr(armnetworkcloud.BareMetalMachinePowerStateOn),
		// 					ProvisioningState: to.Ptr(armnetworkcloud.BareMetalMachineProvisioningStateSucceeded),
		// 					RackID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
		// 					RackSlot: to.Ptr[int64](1),
		// 					ReadyState: to.Ptr(armnetworkcloud.BareMetalMachineReadyStateTrue),
		// 					SerialNumber: to.Ptr("BM1219XXX"),
		// 					ServiceTag: to.Ptr("ST1219XXX"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_ListByResourceGroup.json
func ExampleBareMetalMachinesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewBareMetalMachinesClient().NewListByResourceGroupPager("resourceGroupName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.BareMetalMachineList = armnetworkcloud.BareMetalMachineList{
		// 	Value: []*armnetworkcloud.BareMetalMachine{
		// 		{
		// 			Name: to.Ptr("bareMetalMachineName"),
		// 			Type: to.Ptr("Microsoft.NetworkCloud/bareMetalMachines"),
		// 			ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
		// 			SystemData: &armnetworkcloud.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
		// 				CreatedBy: to.Ptr("identityA"),
		// 				CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("identityB"),
		// 				LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("location"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("myvalue1"),
		// 				"key2": to.Ptr("myvalue2"),
		// 			},
		// 			ExtendedLocation: &armnetworkcloud.ExtendedLocation{
		// 				Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
		// 				Type: to.Ptr("CustomLocation"),
		// 			},
		// 			Properties: &armnetworkcloud.BareMetalMachineProperties{
		// 				AssociatedResourceIDs: []*string{
		// 					to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName")},
		// 					BmcConnectionString: to.Ptr("bmcconnectionstring"),
		// 					BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
		// 						Username: to.Ptr("bmcuser"),
		// 					},
		// 					BmcMacAddress: to.Ptr("00:00:4f:00:57:00"),
		// 					BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
		// 					ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
		// 					CordonStatus: to.Ptr(armnetworkcloud.BareMetalMachineCordonStatusUncordoned),
		// 					DetailedStatus: to.Ptr(armnetworkcloud.BareMetalMachineDetailedStatusAvailable),
		// 					DetailedStatusMessage: to.Ptr("DetailedStatusMessage"),
		// 					HardwareInventory: &armnetworkcloud.HardwareInventory{
		// 						AdditionalHostInformation: to.Ptr("Machine specific information..."),
		// 						Interfaces: []*armnetworkcloud.HardwareInventoryNetworkInterface{
		// 							{
		// 								Name: to.Ptr("networkInterfaceName"),
		// 								LinkStatus: to.Ptr("Up"),
		// 								MacAddress: to.Ptr("2C:54:91:88:C9:E3"),
		// 								NetworkInterfaceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkDevices/networkDeviceName/networkInterfaces/networkInterfaceName"),
		// 						}},
		// 					},
		// 					HardwareValidationStatus: &armnetworkcloud.HardwareValidationStatus{
		// 						LastValidationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-30T13:27:03.008Z"); return t}()),
		// 						Result: to.Ptr(armnetworkcloud.BareMetalMachineHardwareValidationResultPass),
		// 					},
		// 					KubernetesNodeName: to.Ptr("node01"),
		// 					KubernetesVersion: to.Ptr("1.21"),
		// 					MachineDetails: to.Ptr("User-provided machine details."),
		// 					MachineName: to.Ptr("r01c001"),
		// 					MachineSKUID: to.Ptr("684E-3B16-399E"),
		// 					OamIPv4Address: to.Ptr("192.0.2.1"),
		// 					OamIPv6Address: to.Ptr("0:0:0:0:0:FFFF:7F00:0001"),
		// 					OSImage: to.Ptr("v20220805e"),
		// 					PowerState: to.Ptr(armnetworkcloud.BareMetalMachinePowerStateOn),
		// 					ProvisioningState: to.Ptr(armnetworkcloud.BareMetalMachineProvisioningStateSucceeded),
		// 					RackID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
		// 					RackSlot: to.Ptr[int64](1),
		// 					ReadyState: to.Ptr(armnetworkcloud.BareMetalMachineReadyStateTrue),
		// 					SerialNumber: to.Ptr("BM1219XXX"),
		// 					ServiceTag: to.Ptr("ST1219XXX"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Get.json
func ExampleBareMetalMachinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBareMetalMachinesClient().Get(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BareMetalMachine = armnetworkcloud.BareMetalMachine{
	// 	Name: to.Ptr("bareMetalMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/bareMetalMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.BareMetalMachineProperties{
	// 		AssociatedResourceIDs: []*string{
	// 			to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName")},
	// 			BmcConnectionString: to.Ptr("bmcconnectionstring"),
	// 			BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
	// 				Username: to.Ptr("bmcuser"),
	// 			},
	// 			BmcMacAddress: to.Ptr("00:00:4f:00:57:00"),
	// 			BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
	// 			ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 			CordonStatus: to.Ptr(armnetworkcloud.BareMetalMachineCordonStatusUncordoned),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.BareMetalMachineDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("DetailedStatusMessage"),
	// 			HardwareInventory: &armnetworkcloud.HardwareInventory{
	// 				AdditionalHostInformation: to.Ptr("Machine specific information..."),
	// 				Interfaces: []*armnetworkcloud.HardwareInventoryNetworkInterface{
	// 					{
	// 						Name: to.Ptr("networkInterfaceName"),
	// 						LinkStatus: to.Ptr("Up"),
	// 						MacAddress: to.Ptr("2C:54:91:88:C9:E3"),
	// 						NetworkInterfaceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkDevices/networkDeviceName/networkInterfaces/networkInterfaceName"),
	// 				}},
	// 			},
	// 			HardwareValidationStatus: &armnetworkcloud.HardwareValidationStatus{
	// 				LastValidationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-30T13:27:03.008Z"); return t}()),
	// 				Result: to.Ptr(armnetworkcloud.BareMetalMachineHardwareValidationResultPass),
	// 			},
	// 			KubernetesNodeName: to.Ptr("node01"),
	// 			KubernetesVersion: to.Ptr("1.21"),
	// 			MachineDetails: to.Ptr("User-provided machine details."),
	// 			MachineName: to.Ptr("r01c001"),
	// 			MachineSKUID: to.Ptr("684E-3B16-399E"),
	// 			OamIPv4Address: to.Ptr("192.0.2.1"),
	// 			OamIPv6Address: to.Ptr("0:0:0:0:0:FFFF:7F00:0001"),
	// 			OSImage: to.Ptr("v20220805e"),
	// 			PowerState: to.Ptr(armnetworkcloud.BareMetalMachinePowerStateOn),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.BareMetalMachineProvisioningStateSucceeded),
	// 			RackID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 			RackSlot: to.Ptr[int64](1),
	// 			ReadyState: to.Ptr(armnetworkcloud.BareMetalMachineReadyStateTrue),
	// 			SerialNumber: to.Ptr("BM1219XXX"),
	// 			ServiceTag: to.Ptr("ST1219XXX"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Create.json
func ExampleBareMetalMachinesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginCreateOrUpdate(ctx, "resourceGroupName", "bareMetalMachineName", armnetworkcloud.BareMetalMachine{
		Location: to.Ptr("location"),
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
		ExtendedLocation: &armnetworkcloud.ExtendedLocation{
			Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
			Type: to.Ptr("CustomLocation"),
		},
		Properties: &armnetworkcloud.BareMetalMachineProperties{
			BmcConnectionString: to.Ptr("bmcconnectionstring"),
			BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
				Password: to.Ptr("{password}"),
				Username: to.Ptr("bmcuser"),
			},
			BmcMacAddress:  to.Ptr("00:00:4f:00:57:00"),
			BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
			MachineDetails: to.Ptr("User-provided machine details."),
			MachineName:    to.Ptr("r01c001"),
			MachineSKUID:   to.Ptr("684E-3B16-399E"),
			RackID:         to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
			RackSlot:       to.Ptr[int64](1),
			SerialNumber:   to.Ptr("BM1219XXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BareMetalMachine = armnetworkcloud.BareMetalMachine{
	// 	Name: to.Ptr("bareMetalMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/bareMetalMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.BareMetalMachineProperties{
	// 		AssociatedResourceIDs: []*string{
	// 			to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName")},
	// 			BmcConnectionString: to.Ptr("bmcconnectionstring"),
	// 			BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
	// 				Username: to.Ptr("bmcuser"),
	// 			},
	// 			BmcMacAddress: to.Ptr("00:00:4f:00:57:00"),
	// 			BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
	// 			ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 			CordonStatus: to.Ptr(armnetworkcloud.BareMetalMachineCordonStatusUncordoned),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.BareMetalMachineDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("DetailedStatusMessage"),
	// 			HardwareInventory: &armnetworkcloud.HardwareInventory{
	// 				AdditionalHostInformation: to.Ptr("Machine specific information..."),
	// 				Interfaces: []*armnetworkcloud.HardwareInventoryNetworkInterface{
	// 					{
	// 						Name: to.Ptr("networkInterfaceName"),
	// 						LinkStatus: to.Ptr("Up"),
	// 						MacAddress: to.Ptr("2C:54:91:88:C9:E3"),
	// 						NetworkInterfaceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkDevices/networkDeviceName/networkInterfaces/networkInterfaceName"),
	// 				}},
	// 			},
	// 			HardwareValidationStatus: &armnetworkcloud.HardwareValidationStatus{
	// 				LastValidationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-30T13:27:03.008Z"); return t}()),
	// 				Result: to.Ptr(armnetworkcloud.BareMetalMachineHardwareValidationResultPass),
	// 			},
	// 			KubernetesNodeName: to.Ptr("node01"),
	// 			KubernetesVersion: to.Ptr("1.21"),
	// 			MachineDetails: to.Ptr("User-provided machine details."),
	// 			MachineName: to.Ptr("r01c001"),
	// 			MachineSKUID: to.Ptr("684E-3B16-399E"),
	// 			OamIPv4Address: to.Ptr("192.0.2.1"),
	// 			OamIPv6Address: to.Ptr("0:0:0:0:0:FFFF:7F00:0001"),
	// 			OSImage: to.Ptr("v20220805e"),
	// 			PowerState: to.Ptr(armnetworkcloud.BareMetalMachinePowerStateOn),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.BareMetalMachineProvisioningStateSucceeded),
	// 			RackID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 			RackSlot: to.Ptr[int64](1),
	// 			ReadyState: to.Ptr(armnetworkcloud.BareMetalMachineReadyStateTrue),
	// 			SerialNumber: to.Ptr("BM1219XXX"),
	// 			ServiceTag: to.Ptr("ST1219XXX"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Delete.json
func ExampleBareMetalMachinesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginDelete(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Patch.json
func ExampleBareMetalMachinesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginUpdate(ctx, "resourceGroupName", "bareMetalMachineName", armnetworkcloud.BareMetalMachinePatchParameters{
		Properties: &armnetworkcloud.BareMetalMachinePatchProperties{
			MachineDetails: to.Ptr("machinedetails"),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("myvalue1"),
			"key2": to.Ptr("myvalue2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BareMetalMachine = armnetworkcloud.BareMetalMachine{
	// 	Name: to.Ptr("bareMetalMachineName"),
	// 	Type: to.Ptr("Microsoft.NetworkCloud/bareMetalMachines"),
	// 	ID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/bareMetalMachines/bareMetalMachineName"),
	// 	SystemData: &armnetworkcloud.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:27:03.008Z"); return t}()),
	// 		CreatedBy: to.Ptr("identityA"),
	// 		CreatedByType: to.Ptr(armnetworkcloud.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-22T13:29:03.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("identityB"),
	// 		LastModifiedByType: to.Ptr(armnetworkcloud.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("location"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("myvalue1"),
	// 		"key2": to.Ptr("myvalue2"),
	// 	},
	// 	ExtendedLocation: &armnetworkcloud.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
	// 		Type: to.Ptr("CustomLocation"),
	// 	},
	// 	Properties: &armnetworkcloud.BareMetalMachineProperties{
	// 		AssociatedResourceIDs: []*string{
	// 			to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/virtualMachines/virtualMachineName")},
	// 			BmcConnectionString: to.Ptr("bmcconnectionstring"),
	// 			BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
	// 				Username: to.Ptr("bmcuser"),
	// 			},
	// 			BmcMacAddress: to.Ptr("00:00:4f:00:57:00"),
	// 			BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
	// 			ClusterID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/clusters/clusterName"),
	// 			CordonStatus: to.Ptr(armnetworkcloud.BareMetalMachineCordonStatusUncordoned),
	// 			DetailedStatus: to.Ptr(armnetworkcloud.BareMetalMachineDetailedStatusAvailable),
	// 			DetailedStatusMessage: to.Ptr("DetailedStatusMessage"),
	// 			HardwareInventory: &armnetworkcloud.HardwareInventory{
	// 				AdditionalHostInformation: to.Ptr("Machine specific information..."),
	// 				Interfaces: []*armnetworkcloud.HardwareInventoryNetworkInterface{
	// 					{
	// 						Name: to.Ptr("networkInterfaceName"),
	// 						LinkStatus: to.Ptr("Up"),
	// 						MacAddress: to.Ptr("2C:54:91:88:C9:E3"),
	// 						NetworkInterfaceID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkDevices/networkDeviceName/networkInterfaces/networkInterfaceName"),
	// 				}},
	// 			},
	// 			HardwareValidationStatus: &armnetworkcloud.HardwareValidationStatus{
	// 				LastValidationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-30T13:27:03.008Z"); return t}()),
	// 				Result: to.Ptr(armnetworkcloud.BareMetalMachineHardwareValidationResultPass),
	// 			},
	// 			KubernetesNodeName: to.Ptr("node01"),
	// 			KubernetesVersion: to.Ptr("1.21"),
	// 			MachineDetails: to.Ptr("User-provided machine details."),
	// 			MachineName: to.Ptr("r01c001"),
	// 			MachineSKUID: to.Ptr("684E-3B16-399E"),
	// 			OamIPv4Address: to.Ptr("192.0.2.1"),
	// 			OamIPv6Address: to.Ptr("0:0:0:0:0:FFFF:7F00:0001"),
	// 			OSImage: to.Ptr("v20220805e"),
	// 			PowerState: to.Ptr(armnetworkcloud.BareMetalMachinePowerStateOn),
	// 			ProvisioningState: to.Ptr(armnetworkcloud.BareMetalMachineProvisioningStateSucceeded),
	// 			RackID: to.Ptr("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
	// 			RackSlot: to.Ptr[int64](1),
	// 			ReadyState: to.Ptr(armnetworkcloud.BareMetalMachineReadyStateTrue),
	// 			SerialNumber: to.Ptr("BM1219XXX"),
	// 			ServiceTag: to.Ptr("ST1219XXX"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Cordon.json
func ExampleBareMetalMachinesClient_BeginCordon() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginCordon(ctx, "resourceGroupName", "bareMetalMachineName", &armnetworkcloud.BareMetalMachinesClientBeginCordonOptions{BareMetalMachineCordonParameters: &armnetworkcloud.BareMetalMachineCordonParameters{
		Evacuate: to.Ptr(armnetworkcloud.BareMetalMachineEvacuateTrue),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_PowerOff.json
func ExampleBareMetalMachinesClient_BeginPowerOff() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginPowerOff(ctx, "resourceGroupName", "bareMetalMachineName", &armnetworkcloud.BareMetalMachinesClientBeginPowerOffOptions{BareMetalMachinePowerOffParameters: &armnetworkcloud.BareMetalMachinePowerOffParameters{
		SkipShutdown: to.Ptr(armnetworkcloud.BareMetalMachineSkipShutdownTrue),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Reimage.json
func ExampleBareMetalMachinesClient_BeginReimage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginReimage(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Replace.json
func ExampleBareMetalMachinesClient_BeginReplace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginReplace(ctx, "resourceGroupName", "bareMetalMachineName", &armnetworkcloud.BareMetalMachinesClientBeginReplaceOptions{BareMetalMachineReplaceParameters: &armnetworkcloud.BareMetalMachineReplaceParameters{
		BmcCredentials: &armnetworkcloud.AdministrativeCredentials{
			Password: to.Ptr("{password}"),
			Username: to.Ptr("bmcuser"),
		},
		BmcMacAddress:  to.Ptr("00:00:4f:00:57:ad"),
		BootMacAddress: to.Ptr("00:00:4e:00:58:af"),
		MachineName:    to.Ptr("name"),
		SerialNumber:   to.Ptr("BM1219XXX"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Restart.json
func ExampleBareMetalMachinesClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginRestart(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_RunCommand.json
func ExampleBareMetalMachinesClient_BeginRunCommand() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginRunCommand(ctx, "resourceGroupName", "bareMetalMachineName", armnetworkcloud.BareMetalMachineRunCommandParameters{
		Arguments: []*string{
			to.Ptr("--argument1"),
			to.Ptr("argument2")},
		LimitTimeSeconds: to.Ptr[int64](60),
		Script:           to.Ptr("cHdkCg=="),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_RunDataExtracts.json
func ExampleBareMetalMachinesClient_BeginRunDataExtracts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginRunDataExtracts(ctx, "resourceGroupName", "bareMetalMachineName", armnetworkcloud.BareMetalMachineRunDataExtractsParameters{
		LimitTimeSeconds: to.Ptr[int64](60),
		Commands: []*armnetworkcloud.BareMetalMachineCommandSpecification{
			{
				Arguments: []*string{
					to.Ptr("SysInfo"),
					to.Ptr("TTYLog")},
				Command: to.Ptr("hardware-support-data-collection"),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_RunReadCommands.json
func ExampleBareMetalMachinesClient_BeginRunReadCommands() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginRunReadCommands(ctx, "resourceGroupName", "bareMetalMachineName", armnetworkcloud.BareMetalMachineRunReadCommandsParameters{
		LimitTimeSeconds: to.Ptr[int64](60),
		Commands: []*armnetworkcloud.BareMetalMachineCommandSpecification{
			{
				Arguments: []*string{
					to.Ptr("pods"),
					to.Ptr("-A")},
				Command: to.Ptr("kubectl get"),
			},
			{
				Arguments: []*string{
					to.Ptr("192.168.0.99"),
					to.Ptr("-c"),
					to.Ptr("3")},
				Command: to.Ptr("ping"),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Start.json
func ExampleBareMetalMachinesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginStart(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/networkcloud/resource-manager/Microsoft.NetworkCloud/stable/2023-07-01/examples/BareMetalMachines_Uncordon.json
func ExampleBareMetalMachinesClient_BeginUncordon() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkcloud.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewBareMetalMachinesClient().BeginUncordon(ctx, "resourceGroupName", "bareMetalMachineName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
