//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmobilenetwork.ClientFactory type.
type ServerFactory struct {
	AttachedDataNetworksServer           AttachedDataNetworksServer
	DataNetworksServer                   DataNetworksServer
	DiagnosticsPackagesServer            DiagnosticsPackagesServer
	MobileNetworksServer                 MobileNetworksServer
	OperationsServer                     OperationsServer
	PacketCapturesServer                 PacketCapturesServer
	PacketCoreControlPlaneVersionsServer PacketCoreControlPlaneVersionsServer
	PacketCoreControlPlanesServer        PacketCoreControlPlanesServer
	PacketCoreDataPlanesServer           PacketCoreDataPlanesServer
	ServicesServer                       ServicesServer
	SimGroupsServer                      SimGroupsServer
	SimPoliciesServer                    SimPoliciesServer
	SimsServer                           SimsServer
	SitesServer                          SitesServer
	SlicesServer                         SlicesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmobilenetwork.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmobilenetwork.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                    *ServerFactory
	trMu                                   sync.Mutex
	trAttachedDataNetworksServer           *AttachedDataNetworksServerTransport
	trDataNetworksServer                   *DataNetworksServerTransport
	trDiagnosticsPackagesServer            *DiagnosticsPackagesServerTransport
	trMobileNetworksServer                 *MobileNetworksServerTransport
	trOperationsServer                     *OperationsServerTransport
	trPacketCapturesServer                 *PacketCapturesServerTransport
	trPacketCoreControlPlaneVersionsServer *PacketCoreControlPlaneVersionsServerTransport
	trPacketCoreControlPlanesServer        *PacketCoreControlPlanesServerTransport
	trPacketCoreDataPlanesServer           *PacketCoreDataPlanesServerTransport
	trServicesServer                       *ServicesServerTransport
	trSimGroupsServer                      *SimGroupsServerTransport
	trSimPoliciesServer                    *SimPoliciesServerTransport
	trSimsServer                           *SimsServerTransport
	trSitesServer                          *SitesServerTransport
	trSlicesServer                         *SlicesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AttachedDataNetworksClient":
		initServer(s, &s.trAttachedDataNetworksServer, func() *AttachedDataNetworksServerTransport {
			return NewAttachedDataNetworksServerTransport(&s.srv.AttachedDataNetworksServer)
		})
		resp, err = s.trAttachedDataNetworksServer.Do(req)
	case "DataNetworksClient":
		initServer(s, &s.trDataNetworksServer, func() *DataNetworksServerTransport { return NewDataNetworksServerTransport(&s.srv.DataNetworksServer) })
		resp, err = s.trDataNetworksServer.Do(req)
	case "DiagnosticsPackagesClient":
		initServer(s, &s.trDiagnosticsPackagesServer, func() *DiagnosticsPackagesServerTransport {
			return NewDiagnosticsPackagesServerTransport(&s.srv.DiagnosticsPackagesServer)
		})
		resp, err = s.trDiagnosticsPackagesServer.Do(req)
	case "MobileNetworksClient":
		initServer(s, &s.trMobileNetworksServer, func() *MobileNetworksServerTransport {
			return NewMobileNetworksServerTransport(&s.srv.MobileNetworksServer)
		})
		resp, err = s.trMobileNetworksServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PacketCapturesClient":
		initServer(s, &s.trPacketCapturesServer, func() *PacketCapturesServerTransport {
			return NewPacketCapturesServerTransport(&s.srv.PacketCapturesServer)
		})
		resp, err = s.trPacketCapturesServer.Do(req)
	case "PacketCoreControlPlaneVersionsClient":
		initServer(s, &s.trPacketCoreControlPlaneVersionsServer, func() *PacketCoreControlPlaneVersionsServerTransport {
			return NewPacketCoreControlPlaneVersionsServerTransport(&s.srv.PacketCoreControlPlaneVersionsServer)
		})
		resp, err = s.trPacketCoreControlPlaneVersionsServer.Do(req)
	case "PacketCoreControlPlanesClient":
		initServer(s, &s.trPacketCoreControlPlanesServer, func() *PacketCoreControlPlanesServerTransport {
			return NewPacketCoreControlPlanesServerTransport(&s.srv.PacketCoreControlPlanesServer)
		})
		resp, err = s.trPacketCoreControlPlanesServer.Do(req)
	case "PacketCoreDataPlanesClient":
		initServer(s, &s.trPacketCoreDataPlanesServer, func() *PacketCoreDataPlanesServerTransport {
			return NewPacketCoreDataPlanesServerTransport(&s.srv.PacketCoreDataPlanesServer)
		})
		resp, err = s.trPacketCoreDataPlanesServer.Do(req)
	case "ServicesClient":
		initServer(s, &s.trServicesServer, func() *ServicesServerTransport { return NewServicesServerTransport(&s.srv.ServicesServer) })
		resp, err = s.trServicesServer.Do(req)
	case "SimGroupsClient":
		initServer(s, &s.trSimGroupsServer, func() *SimGroupsServerTransport { return NewSimGroupsServerTransport(&s.srv.SimGroupsServer) })
		resp, err = s.trSimGroupsServer.Do(req)
	case "SimPoliciesClient":
		initServer(s, &s.trSimPoliciesServer, func() *SimPoliciesServerTransport { return NewSimPoliciesServerTransport(&s.srv.SimPoliciesServer) })
		resp, err = s.trSimPoliciesServer.Do(req)
	case "SimsClient":
		initServer(s, &s.trSimsServer, func() *SimsServerTransport { return NewSimsServerTransport(&s.srv.SimsServer) })
		resp, err = s.trSimsServer.Do(req)
	case "SitesClient":
		initServer(s, &s.trSitesServer, func() *SitesServerTransport { return NewSitesServerTransport(&s.srv.SitesServer) })
		resp, err = s.trSitesServer.Do(req)
	case "SlicesClient":
		initServer(s, &s.trSlicesServer, func() *SlicesServerTransport { return NewSlicesServerTransport(&s.srv.SlicesServer) })
		resp, err = s.trSlicesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
