//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	"net/http"
	"net/url"
	"regexp"
)

// JobDefinitionsServer is a fake server for instances of the armhybriddatamanager.JobDefinitionsClient type.
type JobDefinitionsServer struct {
	// BeginCreateOrUpdate is the fake for method JobDefinitionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, dataServiceName string, jobDefinitionName string, resourceGroupName string, dataManagerName string, jobDefinition armhybriddatamanager.JobDefinition, options *armhybriddatamanager.JobDefinitionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method JobDefinitionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, dataServiceName string, jobDefinitionName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobDefinitionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JobDefinitionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, dataServiceName string, jobDefinitionName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobDefinitionsClientGetOptions) (resp azfake.Responder[armhybriddatamanager.JobDefinitionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataManagerPager is the fake for method JobDefinitionsClient.NewListByDataManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataManagerPager func(resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobDefinitionsClientListByDataManagerOptions) (resp azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataManagerResponse])

	// NewListByDataServicePager is the fake for method JobDefinitionsClient.NewListByDataServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataServicePager func(dataServiceName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.JobDefinitionsClientListByDataServiceOptions) (resp azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataServiceResponse])

	// BeginRun is the fake for method JobDefinitionsClient.BeginRun
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginRun func(ctx context.Context, dataServiceName string, jobDefinitionName string, resourceGroupName string, dataManagerName string, runParameters armhybriddatamanager.RunParameters, options *armhybriddatamanager.JobDefinitionsClientBeginRunOptions) (resp azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientRunResponse], errResp azfake.ErrorResponder)
}

// NewJobDefinitionsServerTransport creates a new instance of JobDefinitionsServerTransport with the provided implementation.
// The returned JobDefinitionsServerTransport instance is connected to an instance of armhybriddatamanager.JobDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJobDefinitionsServerTransport(srv *JobDefinitionsServer) *JobDefinitionsServerTransport {
	return &JobDefinitionsServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientDeleteResponse]](),
		newListByDataManagerPager: newTracker[azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataManagerResponse]](),
		newListByDataServicePager: newTracker[azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataServiceResponse]](),
		beginRun:                  newTracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientRunResponse]](),
	}
}

// JobDefinitionsServerTransport connects instances of armhybriddatamanager.JobDefinitionsClient to instances of JobDefinitionsServer.
// Don't use this type directly, use NewJobDefinitionsServerTransport instead.
type JobDefinitionsServerTransport struct {
	srv                       *JobDefinitionsServer
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientDeleteResponse]]
	newListByDataManagerPager *tracker[azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataManagerResponse]]
	newListByDataServicePager *tracker[azfake.PagerResponder[armhybriddatamanager.JobDefinitionsClientListByDataServiceResponse]]
	beginRun                  *tracker[azfake.PollerResponder[armhybriddatamanager.JobDefinitionsClientRunResponse]]
}

// Do implements the policy.Transporter interface for JobDefinitionsServerTransport.
func (j *JobDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JobDefinitionsClient.BeginCreateOrUpdate":
		resp, err = j.dispatchBeginCreateOrUpdate(req)
	case "JobDefinitionsClient.BeginDelete":
		resp, err = j.dispatchBeginDelete(req)
	case "JobDefinitionsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JobDefinitionsClient.NewListByDataManagerPager":
		resp, err = j.dispatchNewListByDataManagerPager(req)
	case "JobDefinitionsClient.NewListByDataServicePager":
		resp, err = j.dispatchNewListByDataServicePager(req)
	case "JobDefinitionsClient.BeginRun":
		resp, err = j.dispatchBeginRun(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := j.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybriddatamanager.JobDefinition](req)
		if err != nil {
			return nil, err
		}
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginCreateOrUpdate(req.Context(), dataServiceNameParam, jobDefinitionNameParam, resourceGroupNameParam, dataManagerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		j.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		j.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		j.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if j.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := j.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginDelete(req.Context(), dataServiceNameParam, jobDefinitionNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		j.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		j.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		j.beginDelete.remove(req)
	}

	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
	if err != nil {
		return nil, err
	}
	jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), dataServiceNameParam, jobDefinitionNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchNewListByDataManagerPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByDataManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataManagerPager not implemented")}
	}
	newListByDataManagerPager := j.newListByDataManagerPager.get(req)
	if newListByDataManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.JobDefinitionsClientListByDataManagerOptions
		if filterParam != nil {
			options = &armhybriddatamanager.JobDefinitionsClientListByDataManagerOptions{
				Filter: filterParam,
			}
		}
		resp := j.srv.NewListByDataManagerPager(resourceGroupNameParam, dataManagerNameParam, options)
		newListByDataManagerPager = &resp
		j.newListByDataManagerPager.add(req, newListByDataManagerPager)
		server.PagerResponderInjectNextLinks(newListByDataManagerPager, req, func(page *armhybriddatamanager.JobDefinitionsClientListByDataManagerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByDataManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataManagerPager) {
		j.newListByDataManagerPager.remove(req)
	}
	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchNewListByDataServicePager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByDataServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataServicePager not implemented")}
	}
	newListByDataServicePager := j.newListByDataServicePager.get(req)
	if newListByDataServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.JobDefinitionsClientListByDataServiceOptions
		if filterParam != nil {
			options = &armhybriddatamanager.JobDefinitionsClientListByDataServiceOptions{
				Filter: filterParam,
			}
		}
		resp := j.srv.NewListByDataServicePager(dataServiceNameParam, resourceGroupNameParam, dataManagerNameParam, options)
		newListByDataServicePager = &resp
		j.newListByDataServicePager.add(req, newListByDataServicePager)
		server.PagerResponderInjectNextLinks(newListByDataServicePager, req, func(page *armhybriddatamanager.JobDefinitionsClientListByDataServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByDataServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataServicePager) {
		j.newListByDataServicePager.remove(req)
	}
	return resp, nil
}

func (j *JobDefinitionsServerTransport) dispatchBeginRun(req *http.Request) (*http.Response, error) {
	if j.srv.BeginRun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRun not implemented")}
	}
	beginRun := j.beginRun.get(req)
	if beginRun == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataServices/(?P<dataServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobDefinitions/(?P<jobDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/run`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybriddatamanager.RunParameters](req)
		if err != nil {
			return nil, err
		}
		dataServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataServiceName")])
		if err != nil {
			return nil, err
		}
		jobDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobDefinitionName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := j.srv.BeginRun(req.Context(), dataServiceNameParam, jobDefinitionNameParam, resourceGroupNameParam, dataManagerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRun = &respr
		j.beginRun.add(req, beginRun)
	}

	resp, err := server.PollerResponderNext(beginRun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		j.beginRun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRun) {
		j.beginRun.remove(req)
	}

	return resp, nil
}
