//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// PublishedBlueprintsServer is a fake server for instances of the armblueprint.PublishedBlueprintsClient type.
type PublishedBlueprintsServer struct {
	// Create is the fake for method PublishedBlueprintsClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, resourceScope string, blueprintName string, versionID string, options *armblueprint.PublishedBlueprintsClientCreateOptions) (resp azfake.Responder[armblueprint.PublishedBlueprintsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PublishedBlueprintsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceScope string, blueprintName string, versionID string, options *armblueprint.PublishedBlueprintsClientDeleteOptions) (resp azfake.Responder[armblueprint.PublishedBlueprintsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PublishedBlueprintsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceScope string, blueprintName string, versionID string, options *armblueprint.PublishedBlueprintsClientGetOptions) (resp azfake.Responder[armblueprint.PublishedBlueprintsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PublishedBlueprintsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, blueprintName string, options *armblueprint.PublishedBlueprintsClientListOptions) (resp azfake.PagerResponder[armblueprint.PublishedBlueprintsClientListResponse])
}

// NewPublishedBlueprintsServerTransport creates a new instance of PublishedBlueprintsServerTransport with the provided implementation.
// The returned PublishedBlueprintsServerTransport instance is connected to an instance of armblueprint.PublishedBlueprintsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPublishedBlueprintsServerTransport(srv *PublishedBlueprintsServer) *PublishedBlueprintsServerTransport {
	return &PublishedBlueprintsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armblueprint.PublishedBlueprintsClientListResponse]](),
	}
}

// PublishedBlueprintsServerTransport connects instances of armblueprint.PublishedBlueprintsClient to instances of PublishedBlueprintsServer.
// Don't use this type directly, use NewPublishedBlueprintsServerTransport instead.
type PublishedBlueprintsServerTransport struct {
	srv          *PublishedBlueprintsServer
	newListPager *tracker[azfake.PagerResponder[armblueprint.PublishedBlueprintsClientListResponse]]
}

// Do implements the policy.Transporter interface for PublishedBlueprintsServerTransport.
func (p *PublishedBlueprintsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PublishedBlueprintsClient.Create":
		resp, err = p.dispatchCreate(req)
	case "PublishedBlueprintsClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PublishedBlueprintsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PublishedBlueprintsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PublishedBlueprintsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if p.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblueprint.PublishedBlueprint](req)
	if err != nil {
		return nil, err
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
	if err != nil {
		return nil, err
	}
	var options *armblueprint.PublishedBlueprintsClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armblueprint.PublishedBlueprintsClientCreateOptions{
			PublishedBlueprint: &body,
		}
	}
	respr, errRespr := p.srv.Create(req.Context(), resourceScopeParam, blueprintNameParam, versionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublishedBlueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublishedBlueprintsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), resourceScopeParam, blueprintNameParam, versionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublishedBlueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublishedBlueprintsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceScopeParam, blueprintNameParam, versionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublishedBlueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublishedBlueprintsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceScopeParam, blueprintNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblueprint.PublishedBlueprintsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
