//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappconfiguration_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appconfiguration/armappconfiguration/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/ConfigurationStoresGetKeyValue.json
func ExampleKeyValuesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKeyValuesClient().Get(ctx, "myResourceGroup", "contoso", "myKey$myLabel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KeyValue = armappconfiguration.KeyValue{
	// 	Name: to.Ptr("myKey$myLabel"),
	// 	Type: to.Ptr("Microsoft.AppConfiguration/configurationStores/keyValues"),
	// 	ID: to.Ptr("/subscriptions/c80fb759-c965-4c6a-9110-9b2b2d038882/resourceGroups/myResourceGroup/providers/Microsoft.AppConfiguration/configurationStores/contoso/keyValues/myKey$myLabel"),
	// 	Properties: &armappconfiguration.KeyValueProperties{
	// 		ContentType: to.Ptr(""),
	// 		ETag: to.Ptr("IhDxoa8VkXxPsYsemBlxvV0d5fp"),
	// 		Key: to.Ptr("myKey"),
	// 		Label: to.Ptr("myLabel"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:42:24.000Z"); return t}()),
	// 		Locked: to.Ptr(false),
	// 		Tags: map[string]*string{
	// 			"tag1": to.Ptr("tagValue1"),
	// 			"tag2": to.Ptr("tagValue2"),
	// 		},
	// 		Value: to.Ptr("myValue"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/ConfigurationStoresCreateKeyValue.json
func ExampleKeyValuesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKeyValuesClient().CreateOrUpdate(ctx, "myResourceGroup", "contoso", "myKey$myLabel", &armappconfiguration.KeyValuesClientCreateOrUpdateOptions{KeyValueParameters: &armappconfiguration.KeyValue{
		Properties: &armappconfiguration.KeyValueProperties{
			Tags: map[string]*string{
				"tag1": to.Ptr("tagValue1"),
				"tag2": to.Ptr("tagValue2"),
			},
			Value: to.Ptr("myValue"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KeyValue = armappconfiguration.KeyValue{
	// 	Name: to.Ptr("myKey$myLabel"),
	// 	Type: to.Ptr("Microsoft.AppConfiguration/configurationStores/keyValues"),
	// 	ID: to.Ptr("/subscriptions/c80fb759-c965-4c6a-9110-9b2b2d038882/resourceGroups/myResourceGroup/providers/Microsoft.AppConfiguration/configurationStores/contoso/keyValues/myKey$myLabel"),
	// 	Properties: &armappconfiguration.KeyValueProperties{
	// 		ContentType: to.Ptr(""),
	// 		ETag: to.Ptr("IhDxoa8VkXxPsYsemBlxvV0d5fp"),
	// 		Key: to.Ptr("myKey"),
	// 		Label: to.Ptr("myLabel"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:42:24.000Z"); return t}()),
	// 		Locked: to.Ptr(false),
	// 		Tags: map[string]*string{
	// 			"tag1": to.Ptr("tagValue1"),
	// 			"tag2": to.Ptr("tagValue2"),
	// 		},
	// 		Value: to.Ptr("myValue"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/appconfiguration/resource-manager/Microsoft.AppConfiguration/stable/2023-03-01/examples/ConfigurationStoresDeleteKeyValue.json
func ExampleKeyValuesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewKeyValuesClient().BeginDelete(ctx, "myResourceGroup", "contoso", "myKey$myLabel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
