/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.xml.security.stax.securityToken;

import java.security.Key;

import org.w3c.dom.Element;

import org.apache.xml.security.exceptions.XMLSecurityException;

/**
 * @author $Author: coheigea $
 * @version $Revision: 1720201 $ $Date: 2015-12-15 18:13:17 +0100 (Tue, 15 Dec 2015) $
 */
public interface OutboundSecurityToken extends SecurityToken {

    /**
     * Returns the processor responsible for this token
     *
     * @return the processor responsible for this token
     */
    Object getProcessor();

    /**
     * Returns the secret key
     *
     * @return The key
     * @throws XMLSecurityException if the key can't be loaded
     */
    Key getSecretKey(String algorithmURI) throws XMLSecurityException;

    void addWrappedToken(OutboundSecurityToken securityToken);

    Element getCustomTokenReference();

}
