// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1beta1/grafeas/grafeas.proto

package grafeas

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	attestation "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/attestation"
	build "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/build"
	common "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/common"
	deployment "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/deployment"
	discovery "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/discovery"
	image "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/image"
	_package "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/package"
	provenance "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/provenance"
	vulnerability "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/vulnerability"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An instance of an analysis type that has been found on a resource.
type Occurrence struct {
	// Output only. The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The resource for which the occurrence applies.
	Resource *Resource `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Immutable. The analysis note associated with this occurrence, in
	// the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be
	// used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName,proto3" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the occurrence details are
	// specified. This field can be used as a filter in list requests.
	Kind common.NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1beta1.NoteKind" json:"kind,omitempty"`
	// A description of actions that can be taken to remedy the note.
	Remediation string `protobuf:"bytes,5,opt,name=remediation,proto3" json:"remediation,omitempty"`
	// Output only. The time this occurrence was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this occurrence was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Immutable. Describes the details of the note kind found on this
	// resource.
	//
	// Types that are valid to be assigned to Details:
	//	*Occurrence_Vulnerability
	//	*Occurrence_Build
	//	*Occurrence_DerivedImage
	//	*Occurrence_Installation
	//	*Occurrence_Deployment
	//	*Occurrence_Discovered
	//	*Occurrence_Attestation
	Details              isOccurrence_Details `protobuf_oneof:"details"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Occurrence) Reset()         { *m = Occurrence{} }
func (m *Occurrence) String() string { return proto.CompactTextString(m) }
func (*Occurrence) ProtoMessage()    {}
func (*Occurrence) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{0}
}

func (m *Occurrence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Occurrence.Unmarshal(m, b)
}
func (m *Occurrence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Occurrence.Marshal(b, m, deterministic)
}
func (m *Occurrence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Occurrence.Merge(m, src)
}
func (m *Occurrence) XXX_Size() int {
	return xxx_messageInfo_Occurrence.Size(m)
}
func (m *Occurrence) XXX_DiscardUnknown() {
	xxx_messageInfo_Occurrence.DiscardUnknown(m)
}

var xxx_messageInfo_Occurrence proto.InternalMessageInfo

func (m *Occurrence) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Occurrence) GetResource() *Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *Occurrence) GetNoteName() string {
	if m != nil {
		return m.NoteName
	}
	return ""
}

func (m *Occurrence) GetKind() common.NoteKind {
	if m != nil {
		return m.Kind
	}
	return common.NoteKind_NOTE_KIND_UNSPECIFIED
}

func (m *Occurrence) GetRemediation() string {
	if m != nil {
		return m.Remediation
	}
	return ""
}

func (m *Occurrence) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Occurrence) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_Vulnerability struct {
	Vulnerability *vulnerability.Details `protobuf:"bytes,8,opt,name=vulnerability,proto3,oneof"`
}

type Occurrence_Build struct {
	Build *build.Details `protobuf:"bytes,9,opt,name=build,proto3,oneof"`
}

type Occurrence_DerivedImage struct {
	DerivedImage *image.Details `protobuf:"bytes,10,opt,name=derived_image,json=derivedImage,proto3,oneof"`
}

type Occurrence_Installation struct {
	Installation *_package.Details `protobuf:"bytes,11,opt,name=installation,proto3,oneof"`
}

type Occurrence_Deployment struct {
	Deployment *deployment.Details `protobuf:"bytes,12,opt,name=deployment,proto3,oneof"`
}

type Occurrence_Discovered struct {
	Discovered *discovery.Details `protobuf:"bytes,13,opt,name=discovered,proto3,oneof"`
}

type Occurrence_Attestation struct {
	Attestation *attestation.Details `protobuf:"bytes,14,opt,name=attestation,proto3,oneof"`
}

func (*Occurrence_Vulnerability) isOccurrence_Details() {}

func (*Occurrence_Build) isOccurrence_Details() {}

func (*Occurrence_DerivedImage) isOccurrence_Details() {}

func (*Occurrence_Installation) isOccurrence_Details() {}

func (*Occurrence_Deployment) isOccurrence_Details() {}

func (*Occurrence_Discovered) isOccurrence_Details() {}

func (*Occurrence_Attestation) isOccurrence_Details() {}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Occurrence) GetVulnerability() *vulnerability.Details {
	if x, ok := m.GetDetails().(*Occurrence_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (m *Occurrence) GetBuild() *build.Details {
	if x, ok := m.GetDetails().(*Occurrence_Build); ok {
		return x.Build
	}
	return nil
}

func (m *Occurrence) GetDerivedImage() *image.Details {
	if x, ok := m.GetDetails().(*Occurrence_DerivedImage); ok {
		return x.DerivedImage
	}
	return nil
}

func (m *Occurrence) GetInstallation() *_package.Details {
	if x, ok := m.GetDetails().(*Occurrence_Installation); ok {
		return x.Installation
	}
	return nil
}

func (m *Occurrence) GetDeployment() *deployment.Details {
	if x, ok := m.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *Occurrence) GetDiscovered() *discovery.Details {
	if x, ok := m.GetDetails().(*Occurrence_Discovered); ok {
		return x.Discovered
	}
	return nil
}

func (m *Occurrence) GetAttestation() *attestation.Details {
	if x, ok := m.GetDetails().(*Occurrence_Attestation); ok {
		return x.Attestation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Occurrence) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Occurrence_Vulnerability)(nil),
		(*Occurrence_Build)(nil),
		(*Occurrence_DerivedImage)(nil),
		(*Occurrence_Installation)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovered)(nil),
		(*Occurrence_Attestation)(nil),
	}
}

// An entity that can have metadata. For example, a Docker image.
type Resource struct {
	// The name of the resource. For example, the name of a Docker image -
	// "Debian".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The unique URI of the resource. For example,
	// `https://gcr.io/project/image@sha256:foo` for a Docker image.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// The hash of the resource content. For example, the Docker digest.
	ContentHash          *provenance.Hash `protobuf:"bytes,3,opt,name=content_hash,json=contentHash,proto3" json:"content_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Resource) Reset()         { *m = Resource{} }
func (m *Resource) String() string { return proto.CompactTextString(m) }
func (*Resource) ProtoMessage()    {}
func (*Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{1}
}

func (m *Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resource.Unmarshal(m, b)
}
func (m *Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resource.Marshal(b, m, deterministic)
}
func (m *Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resource.Merge(m, src)
}
func (m *Resource) XXX_Size() int {
	return xxx_messageInfo_Resource.Size(m)
}
func (m *Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_Resource proto.InternalMessageInfo

func (m *Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Resource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Resource) GetContentHash() *provenance.Hash {
	if m != nil {
		return m.ContentHash
	}
	return nil
}

// A type of analysis that can be done for a resource.
type Note struct {
	// Output only. The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A one sentence description of this note.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this note.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. The type of analysis. This field can be used as a filter in
	// list requests.
	Kind common.NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1beta1.NoteKind" json:"kind,omitempty"`
	// URLs associated with this note.
	RelatedUrl []*common.RelatedUrl `protobuf:"bytes,5,rep,name=related_url,json=relatedUrl,proto3" json:"related_url,omitempty"`
	// Time of expiration for this note. Empty if note does not expire.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Other notes related to this note.
	RelatedNoteNames []string `protobuf:"bytes,9,rep,name=related_note_names,json=relatedNoteNames,proto3" json:"related_note_names,omitempty"`
	// Required. Immutable. The type of analysis this note represents.
	//
	// Types that are valid to be assigned to Type:
	//	*Note_Vulnerability
	//	*Note_Build
	//	*Note_BaseImage
	//	*Note_Package
	//	*Note_Deployable
	//	*Note_Discovery
	//	*Note_AttestationAuthority
	Type                 isNote_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Note) Reset()         { *m = Note{} }
func (m *Note) String() string { return proto.CompactTextString(m) }
func (*Note) ProtoMessage()    {}
func (*Note) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{2}
}

func (m *Note) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Note.Unmarshal(m, b)
}
func (m *Note) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Note.Marshal(b, m, deterministic)
}
func (m *Note) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Note.Merge(m, src)
}
func (m *Note) XXX_Size() int {
	return xxx_messageInfo_Note.Size(m)
}
func (m *Note) XXX_DiscardUnknown() {
	xxx_messageInfo_Note.DiscardUnknown(m)
}

var xxx_messageInfo_Note proto.InternalMessageInfo

func (m *Note) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Note) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Note) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Note) GetKind() common.NoteKind {
	if m != nil {
		return m.Kind
	}
	return common.NoteKind_NOTE_KIND_UNSPECIFIED
}

func (m *Note) GetRelatedUrl() []*common.RelatedUrl {
	if m != nil {
		return m.RelatedUrl
	}
	return nil
}

func (m *Note) GetExpirationTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *Note) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Note) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Note) GetRelatedNoteNames() []string {
	if m != nil {
		return m.RelatedNoteNames
	}
	return nil
}

type isNote_Type interface {
	isNote_Type()
}

type Note_Vulnerability struct {
	Vulnerability *vulnerability.Vulnerability `protobuf:"bytes,10,opt,name=vulnerability,proto3,oneof"`
}

type Note_Build struct {
	Build *build.Build `protobuf:"bytes,11,opt,name=build,proto3,oneof"`
}

type Note_BaseImage struct {
	BaseImage *image.Basis `protobuf:"bytes,12,opt,name=base_image,json=baseImage,proto3,oneof"`
}

type Note_Package struct {
	Package *_package.Package `protobuf:"bytes,13,opt,name=package,proto3,oneof"`
}

type Note_Deployable struct {
	Deployable *deployment.Deployable `protobuf:"bytes,14,opt,name=deployable,proto3,oneof"`
}

type Note_Discovery struct {
	Discovery *discovery.Discovery `protobuf:"bytes,15,opt,name=discovery,proto3,oneof"`
}

type Note_AttestationAuthority struct {
	AttestationAuthority *attestation.Authority `protobuf:"bytes,16,opt,name=attestation_authority,json=attestationAuthority,proto3,oneof"`
}

func (*Note_Vulnerability) isNote_Type() {}

func (*Note_Build) isNote_Type() {}

func (*Note_BaseImage) isNote_Type() {}

func (*Note_Package) isNote_Type() {}

func (*Note_Deployable) isNote_Type() {}

func (*Note_Discovery) isNote_Type() {}

func (*Note_AttestationAuthority) isNote_Type() {}

func (m *Note) GetType() isNote_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Note) GetVulnerability() *vulnerability.Vulnerability {
	if x, ok := m.GetType().(*Note_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (m *Note) GetBuild() *build.Build {
	if x, ok := m.GetType().(*Note_Build); ok {
		return x.Build
	}
	return nil
}

func (m *Note) GetBaseImage() *image.Basis {
	if x, ok := m.GetType().(*Note_BaseImage); ok {
		return x.BaseImage
	}
	return nil
}

func (m *Note) GetPackage() *_package.Package {
	if x, ok := m.GetType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (m *Note) GetDeployable() *deployment.Deployable {
	if x, ok := m.GetType().(*Note_Deployable); ok {
		return x.Deployable
	}
	return nil
}

func (m *Note) GetDiscovery() *discovery.Discovery {
	if x, ok := m.GetType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (m *Note) GetAttestationAuthority() *attestation.Authority {
	if x, ok := m.GetType().(*Note_AttestationAuthority); ok {
		return x.AttestationAuthority
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Note) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Note_Vulnerability)(nil),
		(*Note_Build)(nil),
		(*Note_BaseImage)(nil),
		(*Note_Package)(nil),
		(*Note_Deployable)(nil),
		(*Note_Discovery)(nil),
		(*Note_AttestationAuthority)(nil),
	}
}

// Request to get an occurrence.
type GetOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOccurrenceRequest) Reset()         { *m = GetOccurrenceRequest{} }
func (m *GetOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*GetOccurrenceRequest) ProtoMessage()    {}
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{3}
}

func (m *GetOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOccurrenceRequest.Unmarshal(m, b)
}
func (m *GetOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *GetOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOccurrenceRequest.Merge(m, src)
}
func (m *GetOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_GetOccurrenceRequest.Size(m)
}
func (m *GetOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOccurrenceRequest proto.InternalMessageInfo

func (m *GetOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	// The name of the project to list occurrences for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOccurrencesRequest) Reset()         { *m = ListOccurrencesRequest{} }
func (m *ListOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*ListOccurrencesRequest) ProtoMessage()    {}
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{4}
}

func (m *ListOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOccurrencesRequest.Unmarshal(m, b)
}
func (m *ListOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *ListOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOccurrencesRequest.Merge(m, src)
}
func (m *ListOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_ListOccurrencesRequest.Size(m)
}
func (m *ListOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListOccurrencesRequest proto.InternalMessageInfo

func (m *ListOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing occurrences.
type ListOccurrencesResponse struct {
	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOccurrencesResponse) Reset()         { *m = ListOccurrencesResponse{} }
func (m *ListOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*ListOccurrencesResponse) ProtoMessage()    {}
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{5}
}

func (m *ListOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOccurrencesResponse.Unmarshal(m, b)
}
func (m *ListOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *ListOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOccurrencesResponse.Merge(m, src)
}
func (m *ListOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_ListOccurrencesResponse.Size(m)
}
func (m *ListOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOccurrencesResponse proto.InternalMessageInfo

func (m *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a occurrence.
type DeleteOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteOccurrenceRequest) Reset()         { *m = DeleteOccurrenceRequest{} }
func (m *DeleteOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteOccurrenceRequest) ProtoMessage()    {}
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{6}
}

func (m *DeleteOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteOccurrenceRequest.Unmarshal(m, b)
}
func (m *DeleteOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteOccurrenceRequest.Merge(m, src)
}
func (m *DeleteOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteOccurrenceRequest.Size(m)
}
func (m *DeleteOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteOccurrenceRequest proto.InternalMessageInfo

func (m *DeleteOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to create a new occurrence.
type CreateOccurrenceRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrence is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrence to create.
	Occurrence           *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateOccurrenceRequest) Reset()         { *m = CreateOccurrenceRequest{} }
func (m *CreateOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateOccurrenceRequest) ProtoMessage()    {}
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{7}
}

func (m *CreateOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateOccurrenceRequest.Unmarshal(m, b)
}
func (m *CreateOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *CreateOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateOccurrenceRequest.Merge(m, src)
}
func (m *CreateOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateOccurrenceRequest.Size(m)
}
func (m *CreateOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateOccurrenceRequest proto.InternalMessageInfo

func (m *CreateOccurrenceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

// Request to update an occurrence.
type UpdateOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateOccurrenceRequest) Reset()         { *m = UpdateOccurrenceRequest{} }
func (m *UpdateOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateOccurrenceRequest) ProtoMessage()    {}
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{8}
}

func (m *UpdateOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateOccurrenceRequest.Unmarshal(m, b)
}
func (m *UpdateOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateOccurrenceRequest.Merge(m, src)
}
func (m *UpdateOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateOccurrenceRequest.Size(m)
}
func (m *UpdateOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateOccurrenceRequest proto.InternalMessageInfo

func (m *UpdateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

func (m *UpdateOccurrenceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to get a note.
type GetNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNoteRequest) Reset()         { *m = GetNoteRequest{} }
func (m *GetNoteRequest) String() string { return proto.CompactTextString(m) }
func (*GetNoteRequest) ProtoMessage()    {}
func (*GetNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{9}
}

func (m *GetNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNoteRequest.Unmarshal(m, b)
}
func (m *GetNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNoteRequest.Marshal(b, m, deterministic)
}
func (m *GetNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNoteRequest.Merge(m, src)
}
func (m *GetNoteRequest) XXX_Size() int {
	return xxx_messageInfo_GetNoteRequest.Size(m)
}
func (m *GetNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNoteRequest proto.InternalMessageInfo

func (m *GetNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to get the note to which the specified occurrence is attached.
type GetOccurrenceNoteRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOccurrenceNoteRequest) Reset()         { *m = GetOccurrenceNoteRequest{} }
func (m *GetOccurrenceNoteRequest) String() string { return proto.CompactTextString(m) }
func (*GetOccurrenceNoteRequest) ProtoMessage()    {}
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{10}
}

func (m *GetOccurrenceNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Unmarshal(m, b)
}
func (m *GetOccurrenceNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Marshal(b, m, deterministic)
}
func (m *GetOccurrenceNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOccurrenceNoteRequest.Merge(m, src)
}
func (m *GetOccurrenceNoteRequest) XXX_Size() int {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Size(m)
}
func (m *GetOccurrenceNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOccurrenceNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOccurrenceNoteRequest proto.InternalMessageInfo

func (m *GetOccurrenceNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	// The name of the project to list notes for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of notes to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotesRequest) Reset()         { *m = ListNotesRequest{} }
func (m *ListNotesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNotesRequest) ProtoMessage()    {}
func (*ListNotesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{11}
}

func (m *ListNotesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotesRequest.Unmarshal(m, b)
}
func (m *ListNotesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotesRequest.Marshal(b, m, deterministic)
}
func (m *ListNotesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotesRequest.Merge(m, src)
}
func (m *ListNotesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNotesRequest.Size(m)
}
func (m *ListNotesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotesRequest proto.InternalMessageInfo

func (m *ListNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNotesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNotesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNotesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing notes.
type ListNotesResponse struct {
	// The notes requested.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotesResponse) Reset()         { *m = ListNotesResponse{} }
func (m *ListNotesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNotesResponse) ProtoMessage()    {}
func (*ListNotesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{12}
}

func (m *ListNotesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotesResponse.Unmarshal(m, b)
}
func (m *ListNotesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotesResponse.Marshal(b, m, deterministic)
}
func (m *ListNotesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotesResponse.Merge(m, src)
}
func (m *ListNotesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNotesResponse.Size(m)
}
func (m *ListNotesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotesResponse proto.InternalMessageInfo

func (m *ListNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *ListNotesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a note.
type DeleteNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNoteRequest) Reset()         { *m = DeleteNoteRequest{} }
func (m *DeleteNoteRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNoteRequest) ProtoMessage()    {}
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{13}
}

func (m *DeleteNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNoteRequest.Unmarshal(m, b)
}
func (m *DeleteNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNoteRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNoteRequest.Merge(m, src)
}
func (m *DeleteNoteRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNoteRequest.Size(m)
}
func (m *DeleteNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNoteRequest proto.InternalMessageInfo

func (m *DeleteNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to create a new note.
type CreateNoteRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the note is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId,proto3" json:"note_id,omitempty"`
	// The note to create.
	Note                 *Note    `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNoteRequest) Reset()         { *m = CreateNoteRequest{} }
func (m *CreateNoteRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNoteRequest) ProtoMessage()    {}
func (*CreateNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{14}
}

func (m *CreateNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNoteRequest.Unmarshal(m, b)
}
func (m *CreateNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNoteRequest.Marshal(b, m, deterministic)
}
func (m *CreateNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNoteRequest.Merge(m, src)
}
func (m *CreateNoteRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNoteRequest.Size(m)
}
func (m *CreateNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNoteRequest proto.InternalMessageInfo

func (m *CreateNoteRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNoteRequest) GetNoteId() string {
	if m != nil {
		return m.NoteId
	}
	return ""
}

func (m *CreateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

// Request to update a note.
type UpdateNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note,proto3" json:"note,omitempty"`
	// The fields to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateNoteRequest) Reset()         { *m = UpdateNoteRequest{} }
func (m *UpdateNoteRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNoteRequest) ProtoMessage()    {}
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{15}
}

func (m *UpdateNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNoteRequest.Unmarshal(m, b)
}
func (m *UpdateNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNoteRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNoteRequest.Merge(m, src)
}
func (m *UpdateNoteRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNoteRequest.Size(m)
}
func (m *UpdateNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNoteRequest proto.InternalMessageInfo

func (m *UpdateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

func (m *UpdateNoteRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to list occurrences for a note.
type ListNoteOccurrencesRequest struct {
	// The name of the note to list occurrences for in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNoteOccurrencesRequest) Reset()         { *m = ListNoteOccurrencesRequest{} }
func (m *ListNoteOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesRequest) ProtoMessage()    {}
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{16}
}

func (m *ListNoteOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Unmarshal(m, b)
}
func (m *ListNoteOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *ListNoteOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNoteOccurrencesRequest.Merge(m, src)
}
func (m *ListNoteOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Size(m)
}
func (m *ListNoteOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNoteOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNoteOccurrencesRequest proto.InternalMessageInfo

func (m *ListNoteOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNoteOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing occurrences for a note.
type ListNoteOccurrencesResponse struct {
	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNoteOccurrencesResponse) Reset()         { *m = ListNoteOccurrencesResponse{} }
func (m *ListNoteOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesResponse) ProtoMessage()    {}
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{17}
}

func (m *ListNoteOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Unmarshal(m, b)
}
func (m *ListNoteOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *ListNoteOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNoteOccurrencesResponse.Merge(m, src)
}
func (m *ListNoteOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Size(m)
}
func (m *ListNoteOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNoteOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNoteOccurrencesResponse proto.InternalMessageInfo

func (m *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to create notes in batch.
type BatchCreateNotesRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the notes are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The notes to create.
	Notes                map[string]*Note `protobuf:"bytes,2,rep,name=notes,proto3" json:"notes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BatchCreateNotesRequest) Reset()         { *m = BatchCreateNotesRequest{} }
func (m *BatchCreateNotesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateNotesRequest) ProtoMessage()    {}
func (*BatchCreateNotesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{18}
}

func (m *BatchCreateNotesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateNotesRequest.Unmarshal(m, b)
}
func (m *BatchCreateNotesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateNotesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateNotesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateNotesRequest.Merge(m, src)
}
func (m *BatchCreateNotesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateNotesRequest.Size(m)
}
func (m *BatchCreateNotesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateNotesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateNotesRequest proto.InternalMessageInfo

func (m *BatchCreateNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateNotesRequest) GetNotes() map[string]*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

// Response for creating notes in batch.
type BatchCreateNotesResponse struct {
	// The notes that were created.
	Notes                []*Note  `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateNotesResponse) Reset()         { *m = BatchCreateNotesResponse{} }
func (m *BatchCreateNotesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchCreateNotesResponse) ProtoMessage()    {}
func (*BatchCreateNotesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{19}
}

func (m *BatchCreateNotesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateNotesResponse.Unmarshal(m, b)
}
func (m *BatchCreateNotesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateNotesResponse.Marshal(b, m, deterministic)
}
func (m *BatchCreateNotesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateNotesResponse.Merge(m, src)
}
func (m *BatchCreateNotesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchCreateNotesResponse.Size(m)
}
func (m *BatchCreateNotesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateNotesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateNotesResponse proto.InternalMessageInfo

func (m *BatchCreateNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

// Request to create occurrences in batch.
type BatchCreateOccurrencesRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrences are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrences to create.
	Occurrences          []*Occurrence `protobuf:"bytes,2,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchCreateOccurrencesRequest) Reset()         { *m = BatchCreateOccurrencesRequest{} }
func (m *BatchCreateOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateOccurrencesRequest) ProtoMessage()    {}
func (*BatchCreateOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{20}
}

func (m *BatchCreateOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Unmarshal(m, b)
}
func (m *BatchCreateOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateOccurrencesRequest.Merge(m, src)
}
func (m *BatchCreateOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Size(m)
}
func (m *BatchCreateOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateOccurrencesRequest proto.InternalMessageInfo

func (m *BatchCreateOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateOccurrencesRequest) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

// Response for creating occurrences in batch.
type BatchCreateOccurrencesResponse struct {
	// The occurrences that were created.
	Occurrences          []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchCreateOccurrencesResponse) Reset()         { *m = BatchCreateOccurrencesResponse{} }
func (m *BatchCreateOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchCreateOccurrencesResponse) ProtoMessage()    {}
func (*BatchCreateOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{21}
}

func (m *BatchCreateOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Unmarshal(m, b)
}
func (m *BatchCreateOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *BatchCreateOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateOccurrencesResponse.Merge(m, src)
}
func (m *BatchCreateOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Size(m)
}
func (m *BatchCreateOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateOccurrencesResponse proto.InternalMessageInfo

func (m *BatchCreateOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

// Request to get a vulnerability summary for some set of occurrences.
type GetVulnerabilityOccurrencesSummaryRequest struct {
	// The name of the project to get a vulnerability summary for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetVulnerabilityOccurrencesSummaryRequest) Reset() {
	*m = GetVulnerabilityOccurrencesSummaryRequest{}
}
func (m *GetVulnerabilityOccurrencesSummaryRequest) String() string { return proto.CompactTextString(m) }
func (*GetVulnerabilityOccurrencesSummaryRequest) ProtoMessage()    {}
func (*GetVulnerabilityOccurrencesSummaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{22}
}

func (m *GetVulnerabilityOccurrencesSummaryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest.Unmarshal(m, b)
}
func (m *GetVulnerabilityOccurrencesSummaryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest.Marshal(b, m, deterministic)
}
func (m *GetVulnerabilityOccurrencesSummaryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest.Merge(m, src)
}
func (m *GetVulnerabilityOccurrencesSummaryRequest) XXX_Size() int {
	return xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest.Size(m)
}
func (m *GetVulnerabilityOccurrencesSummaryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetVulnerabilityOccurrencesSummaryRequest proto.InternalMessageInfo

func (m *GetVulnerabilityOccurrencesSummaryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GetVulnerabilityOccurrencesSummaryRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A summary of how many vulnerability occurrences there are per resource and
// severity type.
type VulnerabilityOccurrencesSummary struct {
	// A listing by resource of the number of fixable and total vulnerabilities.
	Counts               []*VulnerabilityOccurrencesSummary_FixableTotalByDigest `protobuf:"bytes,1,rep,name=counts,proto3" json:"counts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *VulnerabilityOccurrencesSummary) Reset()         { *m = VulnerabilityOccurrencesSummary{} }
func (m *VulnerabilityOccurrencesSummary) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityOccurrencesSummary) ProtoMessage()    {}
func (*VulnerabilityOccurrencesSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{23}
}

func (m *VulnerabilityOccurrencesSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary.Unmarshal(m, b)
}
func (m *VulnerabilityOccurrencesSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary.Marshal(b, m, deterministic)
}
func (m *VulnerabilityOccurrencesSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityOccurrencesSummary.Merge(m, src)
}
func (m *VulnerabilityOccurrencesSummary) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary.Size(m)
}
func (m *VulnerabilityOccurrencesSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityOccurrencesSummary.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityOccurrencesSummary proto.InternalMessageInfo

func (m *VulnerabilityOccurrencesSummary) GetCounts() []*VulnerabilityOccurrencesSummary_FixableTotalByDigest {
	if m != nil {
		return m.Counts
	}
	return nil
}

// Per resource and severity counts of fixable and total vulnerabilities.
type VulnerabilityOccurrencesSummary_FixableTotalByDigest struct {
	// The affected resource.
	Resource *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The severity for this count. SEVERITY_UNSPECIFIED indicates total across
	// all severities.
	Severity vulnerability.Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// The number of fixable vulnerabilities associated with this resource.
	FixableCount int64 `protobuf:"varint,3,opt,name=fixable_count,json=fixableCount,proto3" json:"fixable_count,omitempty"`
	// The total number of vulnerabilities associated with this resource.
	TotalCount           int64    `protobuf:"varint,4,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) Reset() {
	*m = VulnerabilityOccurrencesSummary_FixableTotalByDigest{}
}
func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) String() string {
	return proto.CompactTextString(m)
}
func (*VulnerabilityOccurrencesSummary_FixableTotalByDigest) ProtoMessage() {}
func (*VulnerabilityOccurrencesSummary_FixableTotalByDigest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5865e5de1898162a, []int{23, 0}
}

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest.Unmarshal(m, b)
}
func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest.Marshal(b, m, deterministic)
}
func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest.Merge(m, src)
}
func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest.Size(m)
}
func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityOccurrencesSummary_FixableTotalByDigest proto.InternalMessageInfo

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetResource() *Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetSeverity() vulnerability.Severity {
	if m != nil {
		return m.Severity
	}
	return vulnerability.Severity_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetFixableCount() int64 {
	if m != nil {
		return m.FixableCount
	}
	return 0
}

func (m *VulnerabilityOccurrencesSummary_FixableTotalByDigest) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Occurrence)(nil), "grafeas.v1beta1.Occurrence")
	proto.RegisterType((*Resource)(nil), "grafeas.v1beta1.Resource")
	proto.RegisterType((*Note)(nil), "grafeas.v1beta1.Note")
	proto.RegisterType((*GetOccurrenceRequest)(nil), "grafeas.v1beta1.GetOccurrenceRequest")
	proto.RegisterType((*ListOccurrencesRequest)(nil), "grafeas.v1beta1.ListOccurrencesRequest")
	proto.RegisterType((*ListOccurrencesResponse)(nil), "grafeas.v1beta1.ListOccurrencesResponse")
	proto.RegisterType((*DeleteOccurrenceRequest)(nil), "grafeas.v1beta1.DeleteOccurrenceRequest")
	proto.RegisterType((*CreateOccurrenceRequest)(nil), "grafeas.v1beta1.CreateOccurrenceRequest")
	proto.RegisterType((*UpdateOccurrenceRequest)(nil), "grafeas.v1beta1.UpdateOccurrenceRequest")
	proto.RegisterType((*GetNoteRequest)(nil), "grafeas.v1beta1.GetNoteRequest")
	proto.RegisterType((*GetOccurrenceNoteRequest)(nil), "grafeas.v1beta1.GetOccurrenceNoteRequest")
	proto.RegisterType((*ListNotesRequest)(nil), "grafeas.v1beta1.ListNotesRequest")
	proto.RegisterType((*ListNotesResponse)(nil), "grafeas.v1beta1.ListNotesResponse")
	proto.RegisterType((*DeleteNoteRequest)(nil), "grafeas.v1beta1.DeleteNoteRequest")
	proto.RegisterType((*CreateNoteRequest)(nil), "grafeas.v1beta1.CreateNoteRequest")
	proto.RegisterType((*UpdateNoteRequest)(nil), "grafeas.v1beta1.UpdateNoteRequest")
	proto.RegisterType((*ListNoteOccurrencesRequest)(nil), "grafeas.v1beta1.ListNoteOccurrencesRequest")
	proto.RegisterType((*ListNoteOccurrencesResponse)(nil), "grafeas.v1beta1.ListNoteOccurrencesResponse")
	proto.RegisterType((*BatchCreateNotesRequest)(nil), "grafeas.v1beta1.BatchCreateNotesRequest")
	proto.RegisterMapType((map[string]*Note)(nil), "grafeas.v1beta1.BatchCreateNotesRequest.NotesEntry")
	proto.RegisterType((*BatchCreateNotesResponse)(nil), "grafeas.v1beta1.BatchCreateNotesResponse")
	proto.RegisterType((*BatchCreateOccurrencesRequest)(nil), "grafeas.v1beta1.BatchCreateOccurrencesRequest")
	proto.RegisterType((*BatchCreateOccurrencesResponse)(nil), "grafeas.v1beta1.BatchCreateOccurrencesResponse")
	proto.RegisterType((*GetVulnerabilityOccurrencesSummaryRequest)(nil), "grafeas.v1beta1.GetVulnerabilityOccurrencesSummaryRequest")
	proto.RegisterType((*VulnerabilityOccurrencesSummary)(nil), "grafeas.v1beta1.VulnerabilityOccurrencesSummary")
	proto.RegisterType((*VulnerabilityOccurrencesSummary_FixableTotalByDigest)(nil), "grafeas.v1beta1.VulnerabilityOccurrencesSummary.FixableTotalByDigest")
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1beta1/grafeas/grafeas.proto", fileDescriptor_5865e5de1898162a)
}

var fileDescriptor_5865e5de1898162a = []byte{
	// 1974 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x5b, 0x6f, 0xdb, 0xc8,
	0x15, 0x0e, 0xe5, 0xab, 0x8e, 0x7c, 0x9d, 0x66, 0x63, 0x55, 0xd9, 0xdd, 0xa8, 0xdc, 0x34, 0x6b,
	0x3b, 0x89, 0x98, 0x38, 0xdb, 0xa0, 0xeb, 0xc4, 0x08, 0xe2, 0x4b, 0xec, 0x60, 0x5b, 0x6f, 0xc0,
	0x78, 0x17, 0x45, 0x8b, 0x85, 0x30, 0x26, 0xc7, 0x12, 0x6b, 0x8a, 0x64, 0xc9, 0x91, 0x12, 0x6d,
	0xb1, 0x8b, 0xa2, 0x48, 0xfb, 0x56, 0xf4, 0xa1, 0x40, 0xdb, 0xe7, 0x7d, 0x69, 0x7f, 0x42, 0xd1,
	0x9f, 0x50, 0xb4, 0x2f, 0xed, 0x4b, 0x8b, 0xbe, 0xf6, 0x87, 0x14, 0x73, 0xa1, 0x38, 0x12, 0x49,
	0x8b, 0x4a, 0x7a, 0x79, 0xb1, 0x86, 0xc3, 0x73, 0xbe, 0x39, 0x73, 0xe6, 0x7c, 0xdf, 0x1c, 0xc9,
	0xf0, 0xa8, 0xe5, 0xfb, 0x2d, 0x97, 0x18, 0x36, 0xe9, 0x51, 0xdf, 0x77, 0x23, 0xc3, 0xf2, 0x3d,
	0x8a, 0x1d, 0x8f, 0x84, 0xd8, 0xc3, 0x6e, 0x3f, 0x72, 0x22, 0xa3, 0x77, 0xf7, 0x94, 0x50, 0x7c,
	0xd7, 0x68, 0x85, 0xf8, 0x8c, 0xe0, 0x28, 0xfe, 0x6c, 0x04, 0xa1, 0x4f, 0x7d, 0xb4, 0x1c, 0x3f,
	0x4a, 0xb3, 0xda, 0xdb, 0x12, 0x11, 0x07, 0x8e, 0x81, 0x3d, 0xcf, 0xa7, 0x98, 0x3a, 0xbe, 0x27,
	0xcd, 0x6b, 0x6b, 0xca, 0x5b, 0xcb, 0x75, 0x88, 0x47, 0xe5, 0x8b, 0xc3, 0xe2, 0x81, 0x60, 0x4a,
	0x49, 0x24, 0x60, 0xd5, 0xb1, 0x04, 0x7a, 0x50, 0x1c, 0xe8, 0xb4, 0xeb, 0xb8, 0xb6, 0xf8, 0x2b,
	0x9d, 0x77, 0x8a, 0x3b, 0x5b, 0x7e, 0xa7, 0xe3, 0x7b, 0xf2, 0x43, 0xba, 0x1f, 0x14, 0x77, 0xb7,
	0x49, 0xe0, 0xfa, 0xfd, 0x0e, 0xf1, 0xa8, 0x32, 0x94, 0x30, 0x7b, 0x13, 0xc0, 0x38, 0x91, 0xe5,
	0xf7, 0x48, 0xd8, 0x4f, 0x46, 0x93, 0xe7, 0xc1, 0xe9, 0xe0, 0x16, 0x11, 0x7f, 0xa5, 0xf3, 0x04,
	0x65, 0x11, 0x60, 0xeb, 0x9c, 0xb9, 0xcb, 0xcf, 0xc9, 0x33, 0x11, 0x84, 0x7e, 0x8f, 0x78, 0xd8,
	0xb3, 0x88, 0x32, 0x94, 0x30, 0x1f, 0x15, 0x87, 0xe9, 0x75, 0x5d, 0x36, 0x7d, 0xea, 0xb8, 0x0e,
	0xed, 0x0f, 0x3f, 0x49, 0xb0, 0xab, 0x12, 0x8c, 0x3f, 0x9d, 0x76, 0xcf, 0x0c, 0xd2, 0x09, 0x06,
	0x2f, 0xeb, 0xa3, 0x2f, 0xcf, 0x1c, 0xe2, 0xda, 0xcd, 0x0e, 0x8e, 0xce, 0xa5, 0xc5, 0xb5, 0x51,
	0x0b, 0xea, 0x74, 0x58, 0xed, 0x75, 0x02, 0x61, 0xa0, 0xff, 0x61, 0x16, 0xe0, 0x63, 0xcb, 0xea,
	0x86, 0x21, 0xf1, 0x2c, 0x82, 0x10, 0x4c, 0x7b, 0xb8, 0x43, 0xaa, 0x5a, 0x5d, 0x5b, 0x2f, 0x9b,
	0x7c, 0x8c, 0xbe, 0x05, 0xf3, 0x21, 0x89, 0xfc, 0x6e, 0x68, 0x91, 0x6a, 0xa9, 0xae, 0xad, 0x57,
	0xb6, 0xbe, 0xde, 0x18, 0x21, 0x50, 0xc3, 0x94, 0x06, 0xe6, 0xc0, 0x14, 0x5d, 0x85, 0xb2, 0xe7,
	0x53, 0xd2, 0xe4, 0x78, 0x53, 0x1c, 0x6f, 0x9e, 0x4d, 0x1c, 0x33, 0xcc, 0xdb, 0x30, 0x7d, 0xee,
	0x78, 0x76, 0x75, 0xba, 0xae, 0xad, 0x2f, 0x65, 0xe0, 0x1d, 0xfb, 0x94, 0x7c, 0xe4, 0x78, 0xb6,
	0xc9, 0xcd, 0x50, 0x1d, 0x2a, 0x21, 0xe9, 0x10, 0xdb, 0xe1, 0xa4, 0xa9, 0xce, 0x70, 0x34, 0x75,
	0x0a, 0x3d, 0x80, 0x8a, 0x15, 0x12, 0x4c, 0x49, 0x93, 0xed, 0xb0, 0x3a, 0xcb, 0xe3, 0xac, 0x35,
	0xc4, 0xf6, 0x1b, 0xf1, 0xf6, 0x1b, 0x27, 0xf1, 0xf6, 0x4d, 0x10, 0xe6, 0x6c, 0x82, 0x39, 0x77,
	0x03, 0x7b, 0xe0, 0x3c, 0x37, 0xde, 0x59, 0x98, 0x73, 0xe7, 0x63, 0x58, 0x1c, 0x3a, 0xb8, 0xea,
	0x3c, 0x77, 0xbf, 0x91, 0xda, 0xd3, 0xf0, 0xf1, 0xee, 0x13, 0x8a, 0x1d, 0x37, 0x3a, 0xba, 0x64,
	0x0e, 0xbb, 0xa3, 0xfb, 0x30, 0xc3, 0xd9, 0x5d, 0x2d, 0x73, 0x9c, 0x77, 0x53, 0x38, 0x82, 0xfb,
	0x89, 0xbf, 0x30, 0x47, 0x07, 0xb0, 0x68, 0x93, 0xd0, 0xe9, 0x11, 0xbb, 0xc9, 0x59, 0x51, 0x85,
	0x1c, 0x7f, 0xc1, 0x99, 0xc4, 0x7f, 0x41, 0xba, 0x3d, 0x65, 0xf3, 0xe8, 0x09, 0x2c, 0x38, 0x5e,
	0x44, 0xb1, 0xeb, 0x8a, 0x5c, 0x57, 0x38, 0x4a, 0x3d, 0x85, 0x12, 0x53, 0x47, 0xc1, 0x51, 0xfd,
	0xd0, 0x01, 0x40, 0xa2, 0x11, 0xd5, 0x05, 0x8e, 0xf2, 0x5e, 0x0a, 0x45, 0x91, 0x91, 0x04, 0x48,
	0x71, 0x44, 0xfb, 0x00, 0xb1, 0x48, 0x10, 0xbb, 0xba, 0xc8, 0x61, 0xf4, 0x34, 0xcc, 0x40, 0x47,
	0x54, 0x94, 0x81, 0x1f, 0x3a, 0x82, 0x8a, 0x22, 0xba, 0xd5, 0x25, 0x0e, 0x73, 0x3d, 0x05, 0xa3,
	0x0a, 0x73, 0x02, 0xa4, 0xba, 0xee, 0x96, 0x61, 0xce, 0x16, 0x6f, 0xf4, 0x2e, 0xcc, 0xc7, 0x65,
	0x9f, 0xc9, 0x9b, 0x15, 0x98, 0xea, 0x86, 0x0e, 0xa7, 0x4c, 0xd9, 0x64, 0x43, 0xb4, 0x07, 0x0b,
	0x4c, 0x0b, 0x88, 0x47, 0x9b, 0x6d, 0x1c, 0xb5, 0x39, 0x2b, 0x32, 0x73, 0x9b, 0x48, 0xca, 0x11,
	0x8e, 0xda, 0x66, 0x45, 0x7a, 0xb1, 0x07, 0xfd, 0xcf, 0x73, 0x30, 0xcd, 0xe8, 0x91, 0xb9, 0xe6,
	0x4d, 0x58, 0x8d, 0xda, 0x7e, 0x48, 0x9b, 0x36, 0x89, 0xac, 0xd0, 0x09, 0xf8, 0x76, 0x45, 0x04,
	0x2b, 0xfc, 0xc5, 0x7e, 0x32, 0x8f, 0x36, 0x60, 0xc5, 0xf5, 0xbd, 0xd6, 0x90, 0xad, 0x20, 0xea,
	0x32, 0x9b, 0x57, 0x4d, 0x27, 0xe4, 0xeb, 0x43, 0xc6, 0x57, 0x17, 0x53, 0x62, 0x37, 0xbb, 0xa1,
	0x5b, 0x9d, 0xa9, 0x4f, 0xad, 0x57, 0xb6, 0xae, 0x66, 0xa8, 0x06, 0xb7, 0xf9, 0x24, 0x74, 0x4d,
	0x08, 0x07, 0x63, 0xb4, 0x07, 0xcb, 0xe4, 0x65, 0xe0, 0x84, 0x3c, 0xe3, 0x45, 0xf9, 0xbc, 0x94,
	0xb8, 0xc4, 0x9c, 0x56, 0x05, 0x61, 0xee, 0x4d, 0x04, 0x61, 0x7e, 0x22, 0x41, 0xb8, 0x05, 0x28,
	0xde, 0xfc, 0x40, 0x00, 0xa3, 0x6a, 0xb9, 0x3e, 0xc5, 0x0e, 0x41, 0xbe, 0x39, 0x96, 0x42, 0x18,
	0xa1, 0x93, 0x51, 0xf9, 0x10, 0xb4, 0xbd, 0x35, 0x46, 0x3e, 0x3e, 0x55, 0x9f, 0xd2, 0x22, 0xf2,
	0x41, 0x2c, 0x22, 0x82, 0xbe, 0x6f, 0xe7, 0x88, 0xc8, 0x2e, 0xfb, 0x9b, 0x48, 0xc8, 0x0e, 0xc0,
	0x29, 0x8e, 0x88, 0xd4, 0x8f, 0x85, 0x1c, 0x57, 0xa1, 0x1f, 0xbb, 0x38, 0x72, 0x18, 0x3b, 0xca,
	0xcc, 0x43, 0x48, 0xc7, 0x43, 0x98, 0x93, 0xaa, 0x20, 0x89, 0x9a, 0xaf, 0x1a, 0xcf, 0xc4, 0xe7,
	0xd1, 0x25, 0x33, 0x76, 0x41, 0x47, 0xb1, 0x60, 0xe0, 0x53, 0x97, 0x48, 0x8a, 0xde, 0xb8, 0x58,
	0x30, 0x62, 0xeb, 0x44, 0x33, 0xd8, 0x13, 0xda, 0x87, 0xf2, 0x40, 0x10, 0xaa, 0xcb, 0x39, 0x5c,
	0x57, 0x24, 0x23, 0x1e, 0xb1, 0xdd, 0x0c, 0xa6, 0xd1, 0x67, 0xf0, 0x96, 0x42, 0xfc, 0x26, 0xee,
	0xd2, 0xb6, 0x1f, 0xb2, 0x03, 0x5a, 0xc9, 0x09, 0x4d, 0x55, 0x8f, 0xc7, 0xb1, 0xf5, 0xd1, 0x25,
	0xf3, 0xb2, 0xf2, 0x62, 0x30, 0xbf, 0x3b, 0x0b, 0xd3, 0xb4, 0x1f, 0x10, 0x7d, 0x13, 0x2e, 0x1f,
	0x12, 0x9a, 0x5c, 0xc1, 0x26, 0xf9, 0x51, 0x97, 0x44, 0x34, 0x8b, 0xdd, 0xfa, 0x2b, 0x0d, 0xae,
	0x7c, 0xc7, 0x89, 0x14, 0xeb, 0x28, 0x36, 0xbf, 0x02, 0xb3, 0x01, 0x0e, 0x99, 0xd4, 0x0a, 0x07,
	0xf9, 0xc4, 0xe6, 0xcf, 0x1c, 0x97, 0x92, 0x50, 0xaa, 0x80, 0x7c, 0x62, 0xb7, 0x73, 0x80, 0x5b,
	0xa4, 0x19, 0x39, 0x9f, 0x8b, 0xdb, 0x79, 0xc6, 0x9c, 0x67, 0x13, 0xcf, 0x9d, 0xcf, 0x09, 0x7a,
	0x07, 0x80, 0xbf, 0xa4, 0xfe, 0x39, 0xf1, 0x38, 0xe7, 0xcb, 0x26, 0x37, 0x3f, 0x61, 0x13, 0xfa,
	0x4f, 0x34, 0x58, 0x4b, 0x85, 0x11, 0x05, 0xbe, 0x17, 0x11, 0xb4, 0x03, 0x15, 0x3f, 0x99, 0xae,
	0x6a, 0x39, 0xcc, 0x57, 0xf6, 0xab, 0xda, 0xa3, 0x1b, 0xb0, 0xec, 0x91, 0x97, 0xb4, 0xa9, 0x2c,
	0x2f, 0xe2, 0x5e, 0x64, 0xd3, 0xcf, 0x06, 0x21, 0xdc, 0x86, 0xb5, 0x7d, 0xe2, 0x12, 0x4a, 0x8a,
	0x25, 0xce, 0x83, 0xb5, 0x3d, 0xce, 0xee, 0xb4, 0x79, 0x5e, 0xe2, 0x1e, 0x00, 0x24, 0x81, 0xc9,
	0xbe, 0xe7, 0xc2, 0x7d, 0x28, 0xe6, 0xfa, 0xef, 0x34, 0x58, 0xfb, 0x84, 0x2b, 0x42, 0xa1, 0xf8,
	0xde, 0x68, 0x31, 0x45, 0xac, 0x58, 0xe3, 0x27, 0x2f, 0x95, 0xb4, 0x58, 0x3d, 0x61, 0xbd, 0xe1,
	0x77, 0x71, 0x74, 0x1e, 0x8b, 0x15, 0x1b, 0xeb, 0xd7, 0x61, 0xe9, 0x90, 0x50, 0x26, 0x47, 0x17,
	0xe5, 0xaf, 0x01, 0xd5, 0xa1, 0x22, 0x1d, 0x67, 0xff, 0x25, 0xac, 0xb0, 0x02, 0x61, 0x66, 0xff,
	0x97, 0x0a, 0x6d, 0xc3, 0xaa, 0xb2, 0xbe, 0x2c, 0xcd, 0x9b, 0x30, 0xc3, 0xf4, 0x38, 0x2e, 0xca,
	0xb7, 0x32, 0x2f, 0x31, 0x53, 0xd8, 0x14, 0x2e, 0xc4, 0xf7, 0x61, 0x55, 0x14, 0xe2, 0xb8, 0x94,
	0xf8, 0xb0, 0x2a, 0x4a, 0x50, 0x35, 0xcc, 0xcb, 0xc9, 0x1a, 0xcc, 0xf1, 0xab, 0xc3, 0xb1, 0xe3,
	0xa4, 0xb0, 0xc7, 0xa7, 0x36, 0xda, 0x80, 0x69, 0x36, 0x92, 0x87, 0x9c, 0xb3, 0x05, 0x6e, 0xa2,
	0xff, 0x52, 0x83, 0x55, 0x51, 0x83, 0x63, 0x42, 0x1b, 0x80, 0x96, 0xc6, 0x82, 0xbe, 0x59, 0xad,
	0xbd, 0xd2, 0xa0, 0x16, 0x1f, 0x4b, 0x86, 0x84, 0x65, 0x85, 0xf6, 0xdf, 0x28, 0x8e, 0x57, 0x1a,
	0x5c, 0xcd, 0x0c, 0xe3, 0x7f, 0x2b, 0x61, 0x7f, 0xd1, 0x60, 0x6d, 0x17, 0x53, 0xab, 0x9d, 0x94,
	0xc5, 0x58, 0xae, 0x3c, 0x8d, 0x4b, 0xb8, 0xc4, 0x83, 0xba, 0x97, 0x0a, 0x2a, 0x07, 0x90, 0x1f,
	0x61, 0x74, 0xe0, 0xd1, 0xb0, 0x2f, 0x0b, 0xbc, 0xf6, 0x31, 0x40, 0x32, 0xc9, 0x7a, 0xd5, 0x73,
	0xd2, 0x97, 0xab, 0xb1, 0x21, 0x63, 0x4b, 0x0f, 0xbb, 0xdd, 0x31, 0x55, 0x21, 0x6c, 0xb6, 0x4b,
	0xdf, 0xd6, 0xf4, 0x43, 0xa8, 0xa6, 0x57, 0x7f, 0x0d, 0xea, 0xe9, 0x3d, 0x78, 0x47, 0x01, 0x9a,
	0xe0, 0xae, 0x1b, 0x39, 0xb8, 0xd2, 0x64, 0x07, 0xa7, 0x37, 0xe1, 0xdd, 0xbc, 0x75, 0xff, 0x23,
	0x95, 0xa1, 0xff, 0x00, 0x36, 0x0e, 0x09, 0x1d, 0xea, 0xdc, 0x94, 0x55, 0x9e, 0x77, 0x3b, 0x1d,
	0x1c, 0xf6, 0x5f, 0x53, 0x2e, 0xf5, 0x7f, 0x96, 0xe0, 0xda, 0x18, 0x68, 0xf4, 0x19, 0xcc, 0x5a,
	0x7e, 0xd7, 0xa3, 0x71, 0xe8, 0x07, 0xa9, 0xd0, 0xc7, 0x20, 0x34, 0x9e, 0x38, 0x2f, 0x59, 0x8b,
	0x75, 0xe2, 0x53, 0xec, 0xee, 0xf6, 0xf7, 0x9d, 0x16, 0x89, 0xa8, 0x29, 0x41, 0x6b, 0x7f, 0xd7,
	0xe0, 0x72, 0x96, 0xc1, 0xd0, 0x2f, 0x08, 0x5a, 0xf1, 0x5f, 0x10, 0xf6, 0x60, 0x3e, 0x22, 0x3d,
	0xc2, 0x9b, 0xae, 0x12, 0xff, 0xe2, 0xf1, 0xfe, 0x98, 0xae, 0xf8, 0xb9, 0x34, 0x37, 0x07, 0x8e,
	0xe8, 0x3d, 0x58, 0x3c, 0x13, 0x31, 0x35, 0x79, 0x98, 0x5c, 0x2d, 0xa6, 0xcc, 0x05, 0x39, 0xb9,
	0xc7, 0xe6, 0xd0, 0x35, 0xa8, 0x50, 0x16, 0xb1, 0x34, 0x99, 0xe6, 0x26, 0xc0, 0xa7, 0xb8, 0xc1,
	0xd6, 0x6f, 0x11, 0x2c, 0x1d, 0x8a, 0xa5, 0x3f, 0xbd, 0xbb, 0xcb, 0x56, 0x46, 0x3f, 0xd3, 0x60,
	0x71, 0xe8, 0x52, 0x44, 0xdf, 0x4c, 0x45, 0x97, 0xd5, 0xd9, 0xd5, 0x2e, 0x2a, 0x18, 0xfd, 0xce,
	0x4f, 0xff, 0xf6, 0xaf, 0x5f, 0x95, 0x36, 0xd1, 0xfa, 0xe0, 0x37, 0xa2, 0x1f, 0x33, 0x21, 0xdc,
	0x09, 0x42, 0xff, 0x87, 0xc4, 0xa2, 0x91, 0xb1, 0x69, 0x28, 0x25, 0x65, 0x6c, 0x7e, 0x81, 0x7e,
	0xad, 0xc1, 0xf2, 0x48, 0x37, 0x86, 0xd2, 0x79, 0xca, 0x6e, 0x1b, 0x6b, 0xeb, 0xe3, 0x0d, 0x45,
	0xed, 0x67, 0x05, 0x26, 0x2a, 0x52, 0x09, 0xed, 0x0b, 0x35, 0x36, 0xf4, 0x73, 0x0d, 0x56, 0x46,
	0x9b, 0x34, 0x94, 0x5e, 0x30, 0xa7, 0x8f, 0xab, 0x5d, 0x49, 0xdd, 0x2a, 0x07, 0x9d, 0x80, 0xf6,
	0xe3, 0x40, 0x36, 0x8b, 0x67, 0xe8, 0x37, 0x1a, 0xac, 0x8c, 0x92, 0x3a, 0x23, 0x90, 0x9c, 0x0e,
	0xf1, 0xe2, 0xf3, 0x7a, 0xc8, 0xa3, 0xb9, 0xaf, 0x17, 0x4e, 0xcb, 0xb6, 0xda, 0xba, 0xfd, 0x51,
	0x83, 0x2b, 0xd9, 0x9a, 0x83, 0x1a, 0x17, 0x69, 0x7b, 0xc6, 0x49, 0x1a, 0x85, 0xed, 0xe5, 0x81,
	0x3e, 0xe2, 0x91, 0x7f, 0xa8, 0x7f, 0x50, 0x38, 0xf2, 0xd3, 0x04, 0x70, 0x5b, 0xdb, 0xe4, 0x69,
	0x1d, 0x6d, 0x72, 0x33, 0xd2, 0x9a, 0xd3, 0x07, 0x17, 0x4a, 0xeb, 0x56, 0xe1, 0x43, 0x1e, 0x4a,
	0xeb, 0x2f, 0x34, 0x58, 0x4d, 0xf5, 0xab, 0x68, 0xe3, 0x62, 0x7a, 0x2a, 0x5d, 0x52, 0x2d, 0xfb,
	0x82, 0xd2, 0xef, 0xf3, 0xa8, 0xee, 0xa0, 0x46, 0xd1, 0xa8, 0x0c, 0xd1, 0x4c, 0x76, 0x60, 0x4e,
	0x36, 0xd9, 0xe8, 0x5a, 0x56, 0x10, 0x05, 0x96, 0xde, 0xe4, 0x4b, 0x5f, 0x47, 0x7a, 0xfe, 0xd2,
	0x7c, 0x2d, 0x56, 0xef, 0x5f, 0x42, 0x79, 0xd0, 0xfd, 0xa2, 0x6f, 0x64, 0x32, 0x5c, 0x6d, 0x0e,
	0x6a, 0xfa, 0x45, 0x26, 0xb2, 0x5a, 0x32, 0xd6, 0xcf, 0xa8, 0x16, 0xb1, 0x5d, 0x0a, 0x90, 0xf4,
	0xc4, 0x48, 0xcf, 0x61, 0xbc, 0xba, 0xe9, 0x3c, 0xae, 0xcb, 0x55, 0x37, 0x8b, 0xec, 0xba, 0x0f,
	0x90, 0xb4, 0x1e, 0x19, 0xab, 0xa6, 0xba, 0xef, 0xbc, 0x54, 0x4b, 0x81, 0xd1, 0x0b, 0x6c, 0x75,
	0x5b, 0x74, 0xc5, 0x5f, 0x69, 0xb0, 0x32, 0xda, 0xfb, 0x64, 0x30, 0x21, 0xa7, 0x39, 0xab, 0x6d,
	0x14, 0xb0, 0x94, 0xc7, 0xf0, 0x21, 0x8f, 0xed, 0x9e, 0xde, 0x28, 0x10, 0xdb, 0x08, 0x5d, 0xfb,
	0x00, 0xc9, 0xd7, 0x81, 0x8c, 0xfc, 0xa4, 0xbe, 0x2b, 0x8c, 0xc9, 0xcf, 0x56, 0x81, 0x43, 0x91,
	0xf9, 0xf9, 0xbd, 0x06, 0x5f, 0xcb, 0xe8, 0xb8, 0xd1, 0xcd, 0xdc, 0xc2, 0xcb, 0x10, 0xb8, 0x5b,
	0xc5, 0x8c, 0x65, 0xa2, 0x0a, 0x50, 0x35, 0x0e, 0x72, 0xe8, 0xd2, 0xfa, 0x87, 0x06, 0xfa, 0xf8,
	0x26, 0x0d, 0x6d, 0x67, 0xd1, 0xb8, 0x58, 0x67, 0x57, 0xbb, 0x33, 0x69, 0xd7, 0xa5, 0x1f, 0xf0,
	0xcd, 0x3c, 0x42, 0x3b, 0x85, 0xa5, 0x7a, 0xa8, 0x2d, 0x92, 0x30, 0xb5, 0x93, 0x3f, 0x3d, 0xae,
	0xa7, 0xfe, 0x17, 0x25, 0x99, 0x87, 0x03, 0x27, 0x6a, 0x58, 0x7e, 0xe7, 0xaf, 0x8f, 0x1b, 0x6d,
	0x4a, 0x83, 0x68, 0xdb, 0x30, 0x5e, 0xbc, 0x78, 0x31, 0xf2, 0xd2, 0xc0, 0x5d, 0xda, 0x36, 0x2c,
	0xd7, 0xef, 0xda, 0xb7, 0x03, 0x17, 0xd3, 0x33, 0x3f, 0xec, 0xec, 0xf6, 0x00, 0x39, 0xfe, 0xe8,
	0x96, 0x9e, 0x69, 0xdf, 0xff, 0x9e, 0xa4, 0x74, 0xcb, 0x77, 0xb1, 0xd7, 0x6a, 0xf8, 0x61, 0xcb,
	0x68, 0x11, 0x8f, 0x13, 0xdc, 0x48, 0x60, 0x27, 0xf8, 0x27, 0xee, 0x03, 0xf9, 0xf9, 0x55, 0x69,
	0xea, 0xd0, 0x7c, 0x7c, 0x3a, 0xcb, 0xa1, 0xee, 0xfd, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x1c, 0xa5,
	0x1c, 0x5a, 0x0e, 0x1e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GrafeasV1Beta1Client is the client API for GrafeasV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GrafeasV1Beta1Client interface {
	// Gets the specified occurrence.
	GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Gets the specified note.
	GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnerabilityOccurrencesSummary(ctx context.Context, in *GetVulnerabilityOccurrencesSummaryRequest, opts ...grpc.CallOption) (*VulnerabilityOccurrencesSummary, error)
}

type grafeasV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewGrafeasV1Beta1Client(cc grpc.ClientConnInterface) GrafeasV1Beta1Client {
	return &grafeasV1Beta1Client{cc}
}

func (c *grafeasV1Beta1Client) GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/GetOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error) {
	out := new(ListOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/ListOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/DeleteOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/CreateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error) {
	out := new(BatchCreateOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/BatchCreateOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/UpdateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/GetOccurrenceNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/GetNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error) {
	out := new(ListNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/ListNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/DeleteNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/CreateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error) {
	out := new(BatchCreateNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/BatchCreateNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/UpdateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error) {
	out := new(ListNoteOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/ListNoteOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasV1Beta1Client) GetVulnerabilityOccurrencesSummary(ctx context.Context, in *GetVulnerabilityOccurrencesSummaryRequest, opts ...grpc.CallOption) (*VulnerabilityOccurrencesSummary, error) {
	out := new(VulnerabilityOccurrencesSummary)
	err := c.cc.Invoke(ctx, "/grafeas.v1beta1.GrafeasV1Beta1/GetVulnerabilityOccurrencesSummary", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GrafeasV1Beta1Server is the server API for GrafeasV1Beta1 service.
type GrafeasV1Beta1Server interface {
	// Gets the specified occurrence.
	GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(context.Context, *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error)
	// Gets the specified note.
	GetNote(context.Context, *GetNoteRequest) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(context.Context, *DeleteNoteRequest) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(context.Context, *CreateNoteRequest) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(context.Context, *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnerabilityOccurrencesSummary(context.Context, *GetVulnerabilityOccurrencesSummaryRequest) (*VulnerabilityOccurrencesSummary, error)
}

// UnimplementedGrafeasV1Beta1Server can be embedded to have forward compatible implementations.
type UnimplementedGrafeasV1Beta1Server struct {
}

func (*UnimplementedGrafeasV1Beta1Server) GetOccurrence(ctx context.Context, req *GetOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrence not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) ListOccurrences(ctx context.Context, req *ListOccurrencesRequest) (*ListOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOccurrences not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) DeleteOccurrence(ctx context.Context, req *DeleteOccurrenceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOccurrence not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) CreateOccurrence(ctx context.Context, req *CreateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOccurrence not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) BatchCreateOccurrences(ctx context.Context, req *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateOccurrences not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) UpdateOccurrence(ctx context.Context, req *UpdateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOccurrence not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) GetOccurrenceNote(ctx context.Context, req *GetOccurrenceNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrenceNote not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) GetNote(ctx context.Context, req *GetNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNote not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) ListNotes(ctx context.Context, req *ListNotesRequest) (*ListNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotes not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) DeleteNote(ctx context.Context, req *DeleteNoteRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNote not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) CreateNote(ctx context.Context, req *CreateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNote not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) BatchCreateNotes(ctx context.Context, req *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateNotes not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) UpdateNote(ctx context.Context, req *UpdateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNote not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) ListNoteOccurrences(ctx context.Context, req *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNoteOccurrences not implemented")
}
func (*UnimplementedGrafeasV1Beta1Server) GetVulnerabilityOccurrencesSummary(ctx context.Context, req *GetVulnerabilityOccurrencesSummaryRequest) (*VulnerabilityOccurrencesSummary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVulnerabilityOccurrencesSummary not implemented")
}

func RegisterGrafeasV1Beta1Server(s *grpc.Server, srv GrafeasV1Beta1Server) {
	s.RegisterService(&_GrafeasV1Beta1_serviceDesc, srv)
}

func _GrafeasV1Beta1_GetOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).GetOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/GetOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).GetOccurrence(ctx, req.(*GetOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_ListOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).ListOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/ListOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).ListOccurrences(ctx, req.(*ListOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_DeleteOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).DeleteOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/DeleteOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).DeleteOccurrence(ctx, req.(*DeleteOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_CreateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).CreateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/CreateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).CreateOccurrence(ctx, req.(*CreateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_BatchCreateOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).BatchCreateOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/BatchCreateOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).BatchCreateOccurrences(ctx, req.(*BatchCreateOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_UpdateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).UpdateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/UpdateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).UpdateOccurrence(ctx, req.(*UpdateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_GetOccurrenceNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).GetOccurrenceNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/GetOccurrenceNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).GetOccurrenceNote(ctx, req.(*GetOccurrenceNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_GetNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).GetNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/GetNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).GetNote(ctx, req.(*GetNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_ListNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).ListNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/ListNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).ListNotes(ctx, req.(*ListNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_DeleteNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).DeleteNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/DeleteNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).DeleteNote(ctx, req.(*DeleteNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_CreateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).CreateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/CreateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).CreateNote(ctx, req.(*CreateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_BatchCreateNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).BatchCreateNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/BatchCreateNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).BatchCreateNotes(ctx, req.(*BatchCreateNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_UpdateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).UpdateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/UpdateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).UpdateNote(ctx, req.(*UpdateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_ListNoteOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNoteOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).ListNoteOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/ListNoteOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).ListNoteOccurrences(ctx, req.(*ListNoteOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GrafeasV1Beta1_GetVulnerabilityOccurrencesSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVulnerabilityOccurrencesSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasV1Beta1Server).GetVulnerabilityOccurrencesSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1beta1.GrafeasV1Beta1/GetVulnerabilityOccurrencesSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasV1Beta1Server).GetVulnerabilityOccurrencesSummary(ctx, req.(*GetVulnerabilityOccurrencesSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GrafeasV1Beta1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grafeas.v1beta1.GrafeasV1Beta1",
	HandlerType: (*GrafeasV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOccurrence",
			Handler:    _GrafeasV1Beta1_GetOccurrence_Handler,
		},
		{
			MethodName: "ListOccurrences",
			Handler:    _GrafeasV1Beta1_ListOccurrences_Handler,
		},
		{
			MethodName: "DeleteOccurrence",
			Handler:    _GrafeasV1Beta1_DeleteOccurrence_Handler,
		},
		{
			MethodName: "CreateOccurrence",
			Handler:    _GrafeasV1Beta1_CreateOccurrence_Handler,
		},
		{
			MethodName: "BatchCreateOccurrences",
			Handler:    _GrafeasV1Beta1_BatchCreateOccurrences_Handler,
		},
		{
			MethodName: "UpdateOccurrence",
			Handler:    _GrafeasV1Beta1_UpdateOccurrence_Handler,
		},
		{
			MethodName: "GetOccurrenceNote",
			Handler:    _GrafeasV1Beta1_GetOccurrenceNote_Handler,
		},
		{
			MethodName: "GetNote",
			Handler:    _GrafeasV1Beta1_GetNote_Handler,
		},
		{
			MethodName: "ListNotes",
			Handler:    _GrafeasV1Beta1_ListNotes_Handler,
		},
		{
			MethodName: "DeleteNote",
			Handler:    _GrafeasV1Beta1_DeleteNote_Handler,
		},
		{
			MethodName: "CreateNote",
			Handler:    _GrafeasV1Beta1_CreateNote_Handler,
		},
		{
			MethodName: "BatchCreateNotes",
			Handler:    _GrafeasV1Beta1_BatchCreateNotes_Handler,
		},
		{
			MethodName: "UpdateNote",
			Handler:    _GrafeasV1Beta1_UpdateNote_Handler,
		},
		{
			MethodName: "ListNoteOccurrences",
			Handler:    _GrafeasV1Beta1_ListNoteOccurrences_Handler,
		},
		{
			MethodName: "GetVulnerabilityOccurrencesSummary",
			Handler:    _GrafeasV1Beta1_GetVulnerabilityOccurrencesSummary_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/containeranalysis/v1beta1/grafeas/grafeas.proto",
}
