package streamanalytics

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.1.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CompatibilityLevel enumerates the values for compatibility level.
type CompatibilityLevel string

const (
	// OneFullStopZero specifies the one full stop zero state for compatibility
	// level.
	OneFullStopZero CompatibilityLevel = "1.0"
)

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// UTF8 specifies the utf8 state for encoding.
	UTF8 Encoding = "UTF8"
)

// EventsOutOfOrderPolicy enumerates the values for events out of order policy.
type EventsOutOfOrderPolicy string

const (
	// Adjust specifies the adjust state for events out of order policy.
	Adjust EventsOutOfOrderPolicy = "Adjust"
	// Drop specifies the drop state for events out of order policy.
	Drop EventsOutOfOrderPolicy = "Drop"
)

// JSONOutputSerializationFormat enumerates the values for json output
// serialization format.
type JSONOutputSerializationFormat string

const (
	// Array specifies the array state for json output serialization format.
	Array JSONOutputSerializationFormat = "Array"
	// LineSeparated specifies the line separated state for json output
	// serialization format.
	LineSeparated JSONOutputSerializationFormat = "LineSeparated"
)

// OutputErrorPolicy enumerates the values for output error policy.
type OutputErrorPolicy string

const (
	// OutputErrorPolicyDrop specifies the output error policy drop state for
	// output error policy.
	OutputErrorPolicyDrop OutputErrorPolicy = "Drop"
	// OutputErrorPolicyStop specifies the output error policy stop state for
	// output error policy.
	OutputErrorPolicyStop OutputErrorPolicy = "Stop"
)

// OutputStartMode enumerates the values for output start mode.
type OutputStartMode string

const (
	// CustomTime specifies the custom time state for output start mode.
	CustomTime OutputStartMode = "CustomTime"
	// JobStartTime specifies the job start time state for output start mode.
	JobStartTime OutputStartMode = "JobStartTime"
	// LastOutputEventTime specifies the last output event time state for
	// output start mode.
	LastOutputEventTime OutputStartMode = "LastOutputEventTime"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// UdfType enumerates the values for udf type.
type UdfType string

const (
	// Scalar specifies the scalar state for udf type.
	Scalar UdfType = "Scalar"
)

// AvroSerialization is describes how data from an input is serialized or how
// data is serialized when written to an output in Avro format.
type AvroSerialization struct {
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBinding is the binding to an Azure
// Machine Learning web service.
type AzureMachineLearningWebServiceFunctionBinding struct {
	*AzureMachineLearningWebServiceFunctionBindingProperties `json:"properties,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingProperties is the binding
// properties associated with an Azure Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingProperties struct {
	Endpoint  *string                                       `json:"endpoint,omitempty"`
	APIKey    *string                                       `json:"apiKey,omitempty"`
	Inputs    *AzureMachineLearningWebServiceInputs         `json:"inputs,omitempty"`
	Outputs   *[]AzureMachineLearningWebServiceOutputColumn `json:"outputs,omitempty"`
	BatchSize *int32                                        `json:"batchSize,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties is the
// binding retrieval properties associated with an Azure Machine learning web
// service.
type AzureMachineLearningWebServiceFunctionBindingRetrievalProperties struct {
	ExecuteEndpoint *string `json:"executeEndpoint,omitempty"`
	UdfType         UdfType `json:"udfType,omitempty"`
}

// AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is
// the parameters needed to retrieve the default function definition for an
// Azure Machine Learning web service function.
type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct {
	*AzureMachineLearningWebServiceFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// AzureMachineLearningWebServiceInputColumn is describes an input column for
// the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputColumn struct {
	Name     *string `json:"name,omitempty"`
	DataType *string `json:"dataType,omitempty"`
	MapTo    *int32  `json:"mapTo,omitempty"`
}

// AzureMachineLearningWebServiceInputs is the inputs for the Azure Machine
// Learning web service endpoint.
type AzureMachineLearningWebServiceInputs struct {
	Name        *string                                      `json:"name,omitempty"`
	ColumnNames *[]AzureMachineLearningWebServiceInputColumn `json:"columnNames,omitempty"`
}

// AzureMachineLearningWebServiceOutputColumn is describes an output column for
// the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceOutputColumn struct {
	Name     *string `json:"name,omitempty"`
	DataType *string `json:"dataType,omitempty"`
}

// AzureSQLDatabaseDataSourceProperties is the properties that are associated
// with an Azure SQL database data source.
type AzureSQLDatabaseDataSourceProperties struct {
	Server   *string `json:"server,omitempty"`
	Database *string `json:"database,omitempty"`
	User     *string `json:"user,omitempty"`
	Password *string `json:"password,omitempty"`
	Table    *string `json:"table,omitempty"`
}

// AzureSQLDatabaseOutputDataSource is describes an Azure SQL database output
// data source.
type AzureSQLDatabaseOutputDataSource struct {
	*AzureSQLDatabaseOutputDataSourceProperties `json:"properties,omitempty"`
}

// AzureSQLDatabaseOutputDataSourceProperties is the properties that are
// associated with an Azure SQL database output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	Server   *string `json:"server,omitempty"`
	Database *string `json:"database,omitempty"`
	User     *string `json:"user,omitempty"`
	Password *string `json:"password,omitempty"`
	Table    *string `json:"table,omitempty"`
}

// AzureTableOutputDataSource is describes an Azure Table data source.
type AzureTableOutputDataSource struct {
	*AzureTableOutputDataSourceProperties `json:"properties,omitempty"`
}

// AzureTableOutputDataSourceProperties is the properties that are associated
// with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	AccountName     *string   `json:"accountName,omitempty"`
	AccountKey      *string   `json:"accountKey,omitempty"`
	Table           *string   `json:"table,omitempty"`
	PartitionKey    *string   `json:"partitionKey,omitempty"`
	RowKey          *string   `json:"rowKey,omitempty"`
	ColumnsToRemove *[]string `json:"columnsToRemove,omitempty"`
	BatchSize       *int32    `json:"batchSize,omitempty"`
}

// BlobDataSourceProperties is the properties that are associated with a blob
// data source.
type BlobDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobOutputDataSource is describes a blob output data source.
type BlobOutputDataSource struct {
	*BlobOutputDataSourceProperties `json:"properties,omitempty"`
}

// BlobOutputDataSourceProperties is the properties that are associated with a
// blob output.
type BlobOutputDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobReferenceInputDataSource is describes a blob input data source that
// contains reference data.
type BlobReferenceInputDataSource struct {
	*BlobReferenceInputDataSourceProperties `json:"properties,omitempty"`
}

// BlobReferenceInputDataSourceProperties is the properties that are associated
// with a blob input containing reference data.
type BlobReferenceInputDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobStreamInputDataSource is describes a blob input data source that
// contains stream data.
type BlobStreamInputDataSource struct {
	*BlobStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// BlobStreamInputDataSourceProperties is the properties that are associated
// with a blob input containing stream data.
type BlobStreamInputDataSourceProperties struct {
	StorageAccounts      *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container            *string           `json:"container,omitempty"`
	PathPattern          *string           `json:"pathPattern,omitempty"`
	DateFormat           *string           `json:"dateFormat,omitempty"`
	TimeFormat           *string           `json:"timeFormat,omitempty"`
	SourcePartitionCount *int32            `json:"sourcePartitionCount,omitempty"`
}

// CsvSerialization is describes how data from an input is serialized or how
// data is serialized when written to an output in CSV format.
type CsvSerialization struct {
	*CsvSerializationProperties `json:"properties,omitempty"`
}

// CsvSerializationProperties is the properties that are associated with the
// CSV serialization type.
type CsvSerializationProperties struct {
	FieldDelimiter *string  `json:"fieldDelimiter,omitempty"`
	Encoding       Encoding `json:"encoding,omitempty"`
}

// DiagnosticCondition is condition applicable to the resource, or to the job
// overall, that warrant customer attention.
type DiagnosticCondition struct {
	Since   *string `json:"since,omitempty"`
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Diagnostics is describes conditions applicable to the Input, Output, or the
// job overall, that warrant customer attention.
type Diagnostics struct {
	Conditions *[]DiagnosticCondition `json:"conditions,omitempty"`
}

// DocumentDbOutputDataSource is describes a DocumentDB data source.
type DocumentDbOutputDataSource struct {
	*DocumentDbOutputDataSourceProperties `json:"properties,omitempty"`
}

// DocumentDbOutputDataSourceProperties is the properties that are associated
// with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	AccountID             *string `json:"accountId,omitempty"`
	AccountKey            *string `json:"accountKey,omitempty"`
	Database              *string `json:"database,omitempty"`
	CollectionNamePattern *string `json:"collectionNamePattern,omitempty"`
	PartitionKey          *string `json:"partitionKey,omitempty"`
	DocumentID            *string `json:"documentId,omitempty"`
}

// ErrorResponse is describes the error that occurred.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// EventHubDataSourceProperties is the common properties that are associated
// with Event Hub data sources.
type EventHubDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
}

// EventHubOutputDataSource is describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	*EventHubOutputDataSourceProperties `json:"properties,omitempty"`
}

// EventHubOutputDataSourceProperties is the properties that are associated
// with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
	PartitionKey           *string `json:"partitionKey,omitempty"`
}

// EventHubStreamInputDataSource is describes an Event Hub input data source
// that contains stream data.
type EventHubStreamInputDataSource struct {
	*EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// EventHubStreamInputDataSourceProperties is the properties that are
// associated with a Event Hub input containing stream data.
type EventHubStreamInputDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
	ConsumerGroupName      *string `json:"consumerGroupName,omitempty"`
}

// Function is a function object, containing all information associated with
// the named function. All functions are contained under a streaming job.
type Function struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Properties        *FunctionProperties `json:"properties,omitempty"`
}

// FunctionBinding is the physical binding of the function. For example, in the
// Azure Machine Learning web service’s case, this describes the endpoint.
type FunctionBinding struct {
}

// FunctionInput is describes one input parameter of a function.
type FunctionInput struct {
	DataType                 *string `json:"dataType,omitempty"`
	IsConfigurationParameter *bool   `json:"isConfigurationParameter,omitempty"`
}

// FunctionListResult is object containing a list of functions under a
// streaming job.
type FunctionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Function `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// FunctionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FunctionListResult) FunctionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FunctionOutput is describes the output of a function.
type FunctionOutput struct {
	DataType *string `json:"dataType,omitempty"`
}

// FunctionProperties is the properties that are associated with a function.
type FunctionProperties struct {
	Etag *string `json:"etag,omitempty"`
}

// FunctionRetrieveDefaultDefinitionParameters is parameters used to specify
// the type of function to retrieve the default definition for.
type FunctionRetrieveDefaultDefinitionParameters struct {
}

// Input is an input object, containing all information associated with the
// named input. All inputs are contained under a streaming job.
type Input struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Properties        *InputProperties `json:"properties,omitempty"`
}

// InputListResult is object containing a list of inputs under a streaming job.
type InputListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Input `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// InputListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InputListResult) InputListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InputProperties is the properties that are associated with an input.
type InputProperties struct {
	Serialization *Serialization `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics   `json:"diagnostics,omitempty"`
	Etag          *string        `json:"etag,omitempty"`
}

// IoTHubStreamInputDataSource is describes an IoT Hub input data source that
// contains stream data.
type IoTHubStreamInputDataSource struct {
	*IoTHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// IoTHubStreamInputDataSourceProperties is the properties that are associated
// with a IoT Hub input containing stream data.
type IoTHubStreamInputDataSourceProperties struct {
	IotHubNamespace        *string `json:"iotHubNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	ConsumerGroupName      *string `json:"consumerGroupName,omitempty"`
	Endpoint               *string `json:"endpoint,omitempty"`
}

// JavaScriptFunctionBinding is the binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	*JavaScriptFunctionBindingProperties `json:"properties,omitempty"`
}

// JavaScriptFunctionBindingProperties is the binding properties associated
// with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	Script *string `json:"script,omitempty"`
}

// JavaScriptFunctionBindingRetrievalProperties is the binding retrieval
// properties associated with a JavaScript function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	Script  *string `json:"script,omitempty"`
	UdfType UdfType `json:"udfType,omitempty"`
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters is the parameters
// needed to retrieve the default function definition for a JavaScript
// function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	*JavaScriptFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// JSONSerialization is describes how data from an input is serialized or how
// data is serialized when written to an output in JSON format.
type JSONSerialization struct {
	*JSONSerializationProperties `json:"properties,omitempty"`
}

// JSONSerializationProperties is the properties that are associated with the
// JSON serialization type.
type JSONSerializationProperties struct {
	Encoding Encoding                      `json:"encoding,omitempty"`
	Format   JSONOutputSerializationFormat `json:"format,omitempty"`
}

// Operation is a Stream Analytics REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is contains the localized display information for this
// particular operation / action.
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult is result of the request to list Stream Analytics
// operations. It contains a list of operations and a URL link to get the next
// set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Output is an output object, containing all information associated with the
// named output. All outputs are contained under a streaming job.
type Output struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*OutputProperties `json:"properties,omitempty"`
}

// OutputDataSource is describes the data source that output will be written
// to.
type OutputDataSource struct {
}

// OutputListResult is object containing a list of outputs under a streaming
// job.
type OutputListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Output `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// OutputListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OutputListResult) OutputListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OutputProperties is the properties that are associated with an output.
type OutputProperties struct {
	Datasource    *OutputDataSource `json:"datasource,omitempty"`
	Serialization *Serialization    `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics      `json:"diagnostics,omitempty"`
	Etag          *string           `json:"etag,omitempty"`
}

// ReferenceInputDataSource is describes an input data source that contains
// reference data.
type ReferenceInputDataSource struct {
}

// ReferenceInputProperties is the properties that are associated with an input
// containing reference data.
type ReferenceInputProperties struct {
	Serialization *Serialization            `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics              `json:"diagnostics,omitempty"`
	Etag          *string                   `json:"etag,omitempty"`
	Datasource    *ReferenceInputDataSource `json:"datasource,omitempty"`
}

// Resource is the base resource model definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceTestStatus is describes the status of the test operation along with
// error information, if applicable.
type ResourceTestStatus struct {
	autorest.Response `json:"-"`
	Status            *string        `json:"status,omitempty"`
	Error             *ErrorResponse `json:"error,omitempty"`
}

// ScalarFunctionConfiguration is describes the configuration of the scalar
// function.
type ScalarFunctionConfiguration struct {
	Inputs  *[]FunctionInput `json:"inputs,omitempty"`
	Output  *FunctionOutput  `json:"output,omitempty"`
	Binding *FunctionBinding `json:"binding,omitempty"`
}

// ScalarFunctionProperties is the properties that are associated with a scalar
// function.
type ScalarFunctionProperties struct {
	Etag                         *string `json:"etag,omitempty"`
	*ScalarFunctionConfiguration `json:"properties,omitempty"`
}

// Serialization is describes how data from an input is serialized or how data
// is serialized when written to an output.
type Serialization struct {
}

// ServiceBusDataSourceProperties is the common properties that are associated
// with Service Bus data sources (Queues, Topics, Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
}

// ServiceBusQueueOutputDataSource is describes a Service Bus Queue data
// source.
type ServiceBusQueueOutputDataSource struct {
	*ServiceBusQueueOutputDataSourceProperties `json:"properties,omitempty"`
}

// ServiceBusQueueOutputDataSourceProperties is the properties that are
// associated with a Service Bus Queue output.
type ServiceBusQueueOutputDataSourceProperties struct {
	ServiceBusNamespace    *string   `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string   `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string   `json:"sharedAccessPolicyKey,omitempty"`
	QueueName              *string   `json:"queueName,omitempty"`
	PropertyColumns        *[]string `json:"propertyColumns,omitempty"`
}

// ServiceBusTopicOutputDataSource is describes a Service Bus Topic data
// source.
type ServiceBusTopicOutputDataSource struct {
	*ServiceBusTopicOutputDataSourceProperties `json:"properties,omitempty"`
}

// ServiceBusTopicOutputDataSourceProperties is the properties that are
// associated with a Service Bus Topic output.
type ServiceBusTopicOutputDataSourceProperties struct {
	ServiceBusNamespace    *string   `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string   `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string   `json:"sharedAccessPolicyKey,omitempty"`
	TopicName              *string   `json:"topicName,omitempty"`
	PropertyColumns        *[]string `json:"propertyColumns,omitempty"`
}

// Sku is the properties that are associated with a SKU.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
}

// StartStreamingJobParameters is parameters supplied to the Start Streaming
// Job operation.
type StartStreamingJobParameters struct {
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	OutputStartTime *date.Time      `json:"outputStartTime,omitempty"`
}

// StorageAccount is the properties that are associated with an Azure Storage
// account
type StorageAccount struct {
	AccountName *string `json:"accountName,omitempty"`
	AccountKey  *string `json:"accountKey,omitempty"`
}

// StreamingJob is a streamng job object, containing all information associated
// with the named streaming job.
type StreamingJob struct {
	autorest.Response       `json:"-"`
	ID                      *string             `json:"id,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*StreamingJobProperties `json:"properties,omitempty"`
}

// StreamingJobListResult is object containing a list of streaming jobs.
type StreamingJobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]StreamingJob `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// StreamingJobListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StreamingJobListResult) StreamingJobListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StreamingJobProperties is the properties that are associated with a
// streaming job.
type StreamingJobProperties struct {
	Sku                                *Sku                   `json:"sku,omitempty"`
	JobID                              *string                `json:"jobId,omitempty"`
	ProvisioningState                  *string                `json:"provisioningState,omitempty"`
	JobState                           *string                `json:"jobState,omitempty"`
	OutputStartMode                    OutputStartMode        `json:"outputStartMode,omitempty"`
	OutputStartTime                    *date.Time             `json:"outputStartTime,omitempty"`
	LastOutputEventTime                *date.Time             `json:"lastOutputEventTime,omitempty"`
	EventsOutOfOrderPolicy             EventsOutOfOrderPolicy `json:"eventsOutOfOrderPolicy,omitempty"`
	OutputErrorPolicy                  OutputErrorPolicy      `json:"outputErrorPolicy,omitempty"`
	EventsOutOfOrderMaxDelayInSeconds  *int32                 `json:"eventsOutOfOrderMaxDelayInSeconds,omitempty"`
	EventsLateArrivalMaxDelayInSeconds *int32                 `json:"eventsLateArrivalMaxDelayInSeconds,omitempty"`
	DataLocale                         *string                `json:"dataLocale,omitempty"`
	CompatibilityLevel                 CompatibilityLevel     `json:"compatibilityLevel,omitempty"`
	CreatedDate                        *date.Time             `json:"createdDate,omitempty"`
	Inputs                             *[]Input               `json:"inputs,omitempty"`
	Transformation                     *Transformation        `json:"transformation,omitempty"`
	Outputs                            *[]Output              `json:"outputs,omitempty"`
	Functions                          *[]Function            `json:"functions,omitempty"`
	Etag                               *string                `json:"etag,omitempty"`
}

// StreamInputDataSource is describes an input data source that contains stream
// data.
type StreamInputDataSource struct {
}

// StreamInputProperties is the properties that are associated with an input
// containing stream data.
type StreamInputProperties struct {
	Serialization *Serialization         `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics           `json:"diagnostics,omitempty"`
	Etag          *string                `json:"etag,omitempty"`
	Datasource    *StreamInputDataSource `json:"datasource,omitempty"`
}

// SubResource is the base sub-resource model definition.
type SubResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// SubscriptionQuota is describes the current quota for the subscription.
type SubscriptionQuota struct {
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*SubscriptionQuotaProperties `json:"properties,omitempty"`
}

// SubscriptionQuotaProperties is describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	MaxCount     *int32 `json:"maxCount,omitempty"`
	CurrentCount *int32 `json:"currentCount,omitempty"`
}

// SubscriptionQuotasListResult is result of the GetQuotas operation. It
// contains a list of quotas for the subscription in a particular region.
type SubscriptionQuotasListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SubscriptionQuota `json:"value,omitempty"`
}

// Transformation is a transformation object, containing all information
// associated with the named transformation. All transformations are contained
// under a streaming job.
type Transformation struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*TransformationProperties `json:"properties,omitempty"`
}

// TransformationProperties is the properties that are associated with a
// transformation.
type TransformationProperties struct {
	StreamingUnits *int32  `json:"streamingUnits,omitempty"`
	Query          *string `json:"query,omitempty"`
	Etag           *string `json:"etag,omitempty"`
}
