package WebService::Mattermost::V4::API::Object::Reaction;

# ABSTRACT: A reaction item.

use Moo;
use Types::Standard qw(InstanceOf Maybe Str);

use WebService::Mattermost::Helper::Alias 'view';

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::BelongingToPost
    WebService::Mattermost::V4::API::Object::Role::BelongingToUser
    WebService::Mattermost::V4::API::Object::Role::CreatedAt
);

################################################################################

has emoji_name => (is => 'ro', isa => Maybe[Str],                      lazy => 1, builder => 1);
has emoji      => (is => 'ro', isa => Maybe[InstanceOf[view 'Emoji']], lazy => 1, builder => 1);

################################################################################

sub _build_emoji_name { shift->raw_data->{emoji_name} }

sub _build_emoji {
    my $self = shift;

    return unless $self->emoji_name;
    return $self->api->emoji->get_by_name($self->emoji_name)->item;
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Reaction - A reaction item.

=head1 VERSION

version 0.25

=head1 DESCRIPTION

Details a Mattermost reaction object.

=head2 ATTRIBUTES

=over 4

=item C<emoji_name>

The name of the emoji attached to the post.

=item C<emoji>

Related L<WebService::Mattermost::V4::API::Object::Emoji> object.

=back

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToPost>

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToUser>

=item L<WebService::Mattermost::V4::API::Object::Role::CreatedAt>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
