package WordList::EN::PersonName::PopularBabyName::US::SSA::1950::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"shortest_word_len",2,"avg_word_len",6.012,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"num_words",1000,"num_words_contain_nonword_chars",0,"longest_word_len",10); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1950 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1950::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1950 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1950::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1950::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1950::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 6.012 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Linda
Mary
Patricia
Barbara
Susan
Nancy
Deborah
Sandra
Carol
Kathleen
Sharon
Karen
Donna
Brenda
Margaret
Diane
Pamela
Janet
Shirley
Carolyn
Judith
Janice
Cynthia
Elizabeth
Judy
Betty
Joyce
Christine
Cheryl
Gloria
Beverly
Martha
Bonnie
Catherine
Dorothy
Rebecca
Marilyn
Kathy
Jane
Joan
Peggy
Gail
Virginia
Connie
Ann
Kathryn
Diana
Jean
Ruth
Helen
Frances
Wanda
Phyllis
Paula
Jacqueline
Rita
Alice
Katherine
Debra
Elaine
Vicki
Sherry
Laura
Jo
Theresa
Ellen
Joanne
Marsha
Rose
Sheila
Suzanne
Marie
Maria
Doris
Cathy
Lynn
Marcia
Sally
Darlene
Charlotte
Teresa
Denise
Lois
Anne
Constance
Evelyn
Glenda
Sarah
Maureen
Dianne
Eileen
Irene
Anna
Victoria
Jeanne
Roberta
Sylvia
Joann
Anita
Sue
Rosemary
Charlene
Geraldine
Norma
Lorraine
Annie
Lynda
Vickie
Louise
Yvonne
Julie
Marlene
Gwendolyn
Wendy
Valerie
Juanita
Patsy
Jennifer
Julia
Loretta
Marjorie
Stephanie
Kay
Colleen
Rhonda
Claudia
Terry
Michele
Delores
Ruby
Jeanette
Arlene
Gayle
Leslie
Mildred
Janis
June
Vivian
Dolores
Carole
Jill
Andrea
Regina
Annette
Sheryl
Josephine
Sara
Angela
Robin
Edith
Paulette
Lynne
Georgia
Emma
Rosa
Lillian
Edna
Audrey
Joy
Carla
Penny
Esther
Pauline
Janie
Christina
Jacquelyn
Jan
Renee
Priscilla
Shelley
Wilma
Candace
Belinda
Michelle
Eva
Ethel
Beth
Clara
Yolanda
Lucille
Bonita
Gladys
Grace
Margie
Cindy
Carmen
Thelma
Dianna
Rachel
Florence
Dawn
Marianne
Bertha
Laurie
Bobbie
Marion
Veronica
Ella
Eleanor
Maryann
Willie
Lillie
Emily
Billie
Lana
Bernice
Lucy
Toni
Jackie
Beatrice
Faye
Marian
Maxine
Kristine
Vicky
Becky
Ida
Amy
Hazel
Lisa
Debbie
Melinda
Lydia
Francine
Nora
Stella
Vera
Terri
Rosie
Mona
Monica
Alma
Bernadette
Claire
Ramona
Myra
Melanie
Nina
Iris
Melissa
Carrie
Shelia
Susie
Jessie
Harriet
Trudy
Mattie
Dana
Cecilia
Marguerite
Patty
Dora
Deanna
Betsy
Irma
Jeannette
Caroline
Minnie
Rosalie
Antoinette
Rosemarie
Deloris
Dale
Miriam
Johnnie
Holly
Velma
Lee
Lynette
Bessie
Naomi
Lucinda
Melody
Jeannie
Olivia
Alicia
Cecelia
Candice
Nadine
Cathleen
Madeline
Laurel
Nellie
Doreen
Geneva
Agnes
Mae
Jennie
Cora
Tina
Ernestine
Verna
Patti
Elsie
Dixie
Hilda
Roxanne
Leona
Marla
Marcella
Gale
Susanne
Ginger
Guadalupe
Penelope
Hattie
Cassandra
Kathie
Lena
Lola
Viola
Della
Margo
Gertrude
Alberta
Laverne
Glenna
Jayne
Karla
Pearl
Rosalind
Jenny
Darla
Molly
Therese
Janette
Noreen
Flora
Gretchen
Cheri
Erma
Eunice
Olga
Margarita
Shari
Fannie
Celeste
Daisy
Sherrie
Lula
Eloise
Rochelle
Violet
Sandy
Lora
Patrice
Corinne
Unknown
Saundra
Helene
Celia
Katie
Roseann
Sharron
Adrienne
Claudette
Amelia
Rosetta
Gay
Bettye
Camille
Christy
Diann
Joanna
Kerry
Sallie
Sondra
Hope
Ada
Sherri
Jamie
Mamie
Lorna
Polly
Henrietta
Myrtle
Bette
Faith
Gwen
Ilene
Myrna
Kimberly
Maggie
Marta
Leah
Pat
Bettie
Freda
Frankie
Adele
Jody
Lenora
Lauren
Rosanne
Lou
Sheri
Cherie
Earnestine
Delia
Jessica
Estella
April
Melba
Jeri
Natalie
Genevieve
Tamara
Shannon
Marilynn
Amanda
Dona
Fay
Ruthie
Nelda
Katharine
Rena
Teri
Jeanie
Kaye
Nanette
Isabel
Reba
Karin
Nona
Kristin
Mable
Tanya
Alison
Jerry
Jolene
Lila
Eugenia
Inez
Coleen
Rosalyn
Sonja
Debora
Earlene
Gracie
Shelly
Robyn
Sonia
Maryanne
Carlene
Muriel
Janine
Robbie
Dee
Ladonna
Terrie
Cathryn
Crystal
Jeannine
Ronda
Yvette
Rae
Marva
Sadie
Essie
Antonia
Heather
Althea
Dorothea
Blanche
Jana
Lorene
Ollie
Meredith
Ava
Winifred
Jewel
Christie
Rosalinda
Merry
Nettie
Lenore
Etta
Beulah
Bernadine
Eula
Kim
Beverley
Kristina
Lavonne
Rhoda
Janelle
Roseanna
Jimmie
Candy
Roslyn
Ora
Angelina
Ina
Lela
Marietta
Clare
Dolly
Jeanine
Marylou
Lynnette
Elena
Maryellen
Pearlie
Georgette
Sharlene
Tommie
Willa
Francis
Jannie
Lesley
Delois
Lupe
Daphne
Harriett
James
Suzan
Dinah
Madelyn
Shelby
Heidi
Josie
Nola
Cherry
Nita
Addie
Angie
Earline
Johanna
Lizzie
Nikki
Queen
Clarice
Leola
Sharyn
Cathie
Julianne
Estelle
Gayla
Jacque
Gilda
Sherrill
Dorthy
Alexis
Consuelo
Elvira
Pam
Fern
Mabel
Roseanne
Kitty
Bridget
Mari
Patrica
Elva
Malinda
Ana
Arleen
Rene
Karon
Edwina
Jewell
Marcy
Chris
Helena
Rosanna
Melva
Suzette
Aurora
Ola
Mollie
Valorie
Cheryle
Debby
Lottie
Mickey
Eddie
Barbra
Iva
Mavis
Roxie
Alyce
Lucia
Sybil
Corrine
Sonya
Cornelia
Karyn
Opal
Dena
Ronnie
Joe
Nan
Valarie
Robert
Sydney
Colette
Karol
Randy
Alfreda
Jerri
Cecile
Katrina
Leanne
Blanca
Kathrine
Benita
Portia
Freddie
Jacalyn
Randi
Retha
Charleen
Elisabeth
Elise
Juana
Josefina
Lori
Madeleine
Effie
Gina
Pamala
Margery
May
Millie
Alana
Aleta
Carmela
Celestine
Cinda
Elnora
Lyn
Peggie
Frieda
Loraine
Marlys
Dian
Madonna
Carlotta
Freida
John
Mercedes
Michael
Katheryn
Maryjane
Tracy
Ester
Alta
Judi
Valeria
Caryn
Ophelia
Caren
Darleen
Dollie
Roxann
Sherryl
Leila
Reva
Esperanza
Kristi
Louella
Leigh
Reta
Caryl
Daryl
Hannah
Leanna
Aileen
Letha
Sharman
Ivy
Kathi
Virgie
Carmella
Dottie
Jacklyn
Janell
Kristen
Nanci
Shirlene
Allison
Angeline
Annmarie
Nell
Vickey
Cleo
Gaye
Leann
Camilla
Doretha
Felicia
Neva
Charles
Debrah
Elsa
Gerry
Tonya
Charmaine
Deanne
Imogene
Deidre
Ruthann
Avis
Lea
Roxanna
Sharen
Twila
Oralia
Vikki
Beryl
Deirdre
Denice
Goldie
Marilee
Susanna
Minerva
Elma
Greta
Carleen
Catharine
Merle
Vonda
Luann
Matilda
Carolann
Luanne
Lilly
Louisa
Mariann
Nedra
Vernell
Corliss
Evangeline
Georgianna
Ingrid
Jocelyn
Leta
Odessa
Elouise
Lorena
Lily
Clementine
David
Lucretia
Dorene
Erlinda
Ila
Kathaleen
Laureen
Angelita
Concetta
Lonnie
Rosella
Tana
Carroll
Delilah
Margret
Cassie
Lona
Petra
Winnie
Bobby
Lauretta
Sanjuanita
Callie
Darcy
Georgina
Deena
Luella
Marina
Mindy
Marleen
William
Manuela
Ronna
Shauna
Charla
Glinda
Maryjo
Meryl
Suellen
Joellen
Nannette
Wilhelmina
Adela
Eliza
Graciela
Jacquline
Justine
Bennie
Judie
Zelma
Kathlene
Winona
Corine
Georgene
Libby
Pattie
Florine
Kristie
Letitia
Wilda
Alexandra
Bethany
Cathrine
Deana
Elida
Shawn
Erica
Lindsay
Rosario
Sophie
Suzann
Elisa
Jacquelin
Jonnie
Rosita
Ardith
Maribeth
Ofelia
Susann
Mickie
Renae
Abigail
Adeline
Treva
Jerrie
Krista
Lelia
Rachelle
Rhea
Rona
Annetta
Danna
Dina
George
Leticia
Marcie
Martina
Raquel
Toby
Estela
Evangelina
Hilary
Janna
Kristy
Pansy
Rosalee
Sophia
Bonny
Carolynn
Eve
Linnea
Marybeth
Aida
Elyse
Kate
Cathey
Claudine
Donita
Harriette
Juliana
Karan
Larry
Sanjuana
Nicki
Sherilyn
Twyla
Carolina
Delphine
Kris
Lorrie
Theodora
Herlinda
Isabelle
Adrian
Charlie
Kathlyn
Kyle
Lessie
Lizabeth
Millicent
Selma
Tara
Georgiana
Hester
Mitzi
Nancie
Zelda
Annabelle
Mimi
Olive
Phoebe
Silvia
Francisca
Rebekah
Rowena
Sammie
Terese
Belva
Fran
Gearldine
Juliette
Kelly
Lorine
Margot
Pamella
Veda
Danielle
Jerilyn
Melodie
Richard
Aurelia
Magdalena
Margarett
Aline
Candis
Delma
Donnie
Juliet
Mara
Phillis
Tammy
Vernice
Alene
Cristina
Juliann
Pennie
Enid
Glynda
Karolyn
Kendra
Nicolette
Norene
Roselyn
Socorro
Clarissa
Geri
Marianna
Merrie
Nannie
Rosann
Vanessa
Vonnie
Allie
Sheron
Shirlee
Charolette
Debbra
Dorinda
Joycelyn
Lavon
Lindy
Lucile
Nicole
Shellie
Velda
Zella
Annamarie
Ernestina
Jannette
Jeanetta
Jenifer
Leora
Luz
Marjory
Marlyn
Norine
Rachael
Sandi
Albertha
Amber
Elinor
Flossie
Jodie
Lourdes
Stacey
Carmelita
Cheryll
Cordelia
Darline
Elissa
Geralyn
Jaclyn
Janey
Marty
Tracey
Carrol
Emilie
Evon
Kathyrn
Leslee
Lolita
Maude
Regenia
Thea
Evonne
Janeen
Noel
Susana
