/* use `make test` to run the test */
/* This code is generated by author/make-test-cases.pl    */
/* DO *NOT* EDIT IT DIRECTRY       */

#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <math.h>
#include "picotest.h"
#include "geohex3.h"

void xy2hex (void);
void code2hex (void);
void code2xy (void);
void coord2hex (void);
void coord2xy (void);
void code2coords (void);

int main (void) {
  subtest("XY2HEX(geohex_get_zone_by_coordinate)",        xy2hex);
  subtest("code2HEX(geohex_get_zone_by_code)",            code2hex);
  subtest("code2XY(geohex_get_zone_by_code)",             code2xy);
  subtest("coord2HEX(geohex_get_zone_by_location)",       coord2hex);
  subtest("coord2XY(geohex_get_coordinate_by_location)",  coord2xy);
  subtest("code2coords(geohex_get_hex_polygon)",          code2coords);
  return done_testing();
}

static inline bool cmp_num (const long double got, const long double expected) {
  const static long double diff = 0.000000000001L;
  return got == expected || (expected - diff < got && got < expected + diff);
}

static inline void str_is (const char* got, const char* expected, const char* msg) {
  const bool ok = strcmp(got, expected) == 0;
  ok(ok);
  if (!ok) note("%s: expected: %s, but got: %s", msg, expected, got);
}

static inline void location_is (const geohex_location_t got, const geohex_location_t expected, const char* msg) {
  const bool ok = cmp_num(got.lat, expected.lat) && cmp_num(got.lng, expected.lng);
  ok(ok);
  if (!ok) note("%s: expected: lat:%Lf,lng:%Lf, but got: lat:%Lf,lng:%Lf", msg, expected.lat, expected.lng, got.lat, got.lng);
}

static inline void coordinate_is (const geohex_coordinate_t got, const geohex_coordinate_t expected, const char* msg) {
  const bool ok = got.x == expected.x && got.y == expected.y;
  ok(ok);
  if (!ok) note("%s: expected: x:%lld,y:%lld, but got: x:%lld,y:%lld", msg, expected.x, expected.y, got.x, got.y);
}

void xy2hex (void) {
  // verify
  ok(geohex_verify_code("XM") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EX2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aZ2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI76") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU06") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU13") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH32") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK51") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL60") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ18") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU88") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb17") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb34") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb86") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK63") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO42") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK02") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD31") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE73") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO84") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB61") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YF58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX15") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO045") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO056") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO077") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV778") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU570") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU868") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK468") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY443") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY004") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb526") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI440") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU026") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU630") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ580") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY864") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV385") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX355") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD744") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO808") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO474") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO073") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB648") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG168") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7541") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0532") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO3203") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU6235") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7172") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ0737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb0200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb8608") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI2651") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC2121") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7871") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4212") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4362") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OX2538") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY5663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OG6663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV8518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3246") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1825") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TR1202") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4054") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA5685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4881") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6270") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80373") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO08354") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU31135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU45042") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ35087") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK06445") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb80457") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH80422") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI74753") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI80240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU01265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU86344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY77334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY15454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04170") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS68342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM78145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM48257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03156") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ47685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40654") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI71873") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX40264") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA44552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD47117") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK51615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK71615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO38458") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO58484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV553581") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI802417") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI750110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO018862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053505") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO074664") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ351822") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU412420") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU708101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK847038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH501658") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI842644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI836575") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU316588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU175485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb711277") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY728344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA016372") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU408880") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM442337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS387785") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX037037") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ173676") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV321726") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC828583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI713375") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD080050") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX817100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA712478") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK166315") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK873482") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO433402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO586342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb335332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8032788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7714524") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0514686") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0517300") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732687") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732768") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4031833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8072131") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8255485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3800810") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1624776") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7464515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb5316746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4033527") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4540858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4351804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8387484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0706771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4884047") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8251271") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0565644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY8320288") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3556486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ8016814") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1746604") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6242083") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM5643552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6303820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM7851800") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0345653") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6306347") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8827707") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4253332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8776718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PF2148656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4587731") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4335020") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV5843218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0682573") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8100870") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4424804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE6100113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK5027217") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7070414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO6240542") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO7775738") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO5821675") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3371862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV54870250") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV78253862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57758513") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI75600226") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05603615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07152160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU41063674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU72201265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34762511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb38241503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK48511367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI32042116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI71565064") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH45442518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY33228746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA03278283") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU42174351") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU47122108") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM32230826") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56301016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS61272751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60832123") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU63124187") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03173236") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38755703") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ57757416") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fc51504013") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OW22586402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC52458806") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV20852101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX46486040") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA62754057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD28367162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK05722747") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK83151057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO31130720") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO51331450") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33488116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV804240512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI708565326") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI754848748") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO055580431") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053480025") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO073506567") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ347013544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU413474586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU354580674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK474555348") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb484868583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH147081657") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI730641802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI576514101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY041035522") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY537117080") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA402570238") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU058877078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU832828267") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ382714446") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ028668414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS383657231") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM602176827") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM482452815") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX033123366") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI860616105") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX114077466") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV355072242") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG413103084") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA486483578") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX426174078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX747576237") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK184816376") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO310523631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO423806423") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb303856635") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO815178640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV1700305142") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV5482764471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7560068257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5263615540") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7265571616") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7505181555") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5736546251") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0273028158") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0536546500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0716764500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4016113514") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4827777232") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU7445272188") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1777354303") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3420476772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4334484641") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH5856584625") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1730824803") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI7234521114") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU3851424320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8152020110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0426257051") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4244664644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7353226324") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3444432334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8136543688") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8831183154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6206841033") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM0565771230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4863207510") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0330807788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6054354111") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1548687734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ7555070851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI7581576564") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1535370770") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV7031782060") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6431665682") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX1617612856") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX7255422107") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA7323011017") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK0130411728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK8071386820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4434206021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3372146218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV57264048634") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57246068382") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05443747884") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07200264504") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34837816828") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU18781747622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU47467037811") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb05827021141") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK72311284586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH51383310718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47416263465") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI87045185255") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU07002763476") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU85663663436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU84201138888") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62147032100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM30178015132") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60054311737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM44560457183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56456700534") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03131786872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ16386410216") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78178446320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX13217487787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40163034106") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX41314430862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA47238521110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK11857485652") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK43222807032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO03574622544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO54114446763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33540877533") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV803254745602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI803456424553") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053652024200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053654462750") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO071704644727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CY281612610161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU181655132036") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU832016181016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("FY636801583240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK446658243285") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH058068815001") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI410587505268") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI871735246286") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU460311054340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU533828300764") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY313181386161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY803527038734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA043284261600") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ060785824214") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS625060382624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM317558565378") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL822458403751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP251226173262") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI745463230145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU681285781273") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV352321156833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA412658306821") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX413323833627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD023073480358") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK570232153327") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK800808780528") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO328348003525") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO563763855337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337212207184") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8046354823266") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5803560714155") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482706175341") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482731186381") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485035421662") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485060618642") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485068654767") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712537663424") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712564265481") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4501241604860") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8407181150325") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3061211527483") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4625116215430") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7250326542858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4221515066426") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4421818162227") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8724851414563") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4074815410453") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8810462030471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0414822216031") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4236836048713") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7001555744550") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4117607703260") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6246856326218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL5887834871345") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0066438378463") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4537105130820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8337351073052") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1135780670728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4163853373183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4034808877353") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4726354081160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD0853382488383") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK2756770452053") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7434850466772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO0846631354832") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4805277813220") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3356324634667") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80717180121576") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56436210413512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56773820550701") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI80611150250021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05167224507116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05405867244763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170215584802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170226100057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170227640163") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU16473602511456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU40673078217161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ31831222362536") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb31200035818717") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK44243402806508") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY01571576207503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY56733420402656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH84065825033010") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI50342481388451") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI78081171860100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU30541311610415") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU44828780263624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA07571045254517") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS38383877824230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM31385143063872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL82447011727335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP22503400845082") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ13526267300787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78437338044154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU68880348017456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV13411223332736") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX38226176387034") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA35122807551718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD32858648748733") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK18678460283758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK35253726505866") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO35083224064751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO45177603556405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563401287846") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563422636071") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801644720107680") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801672224571144") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV752066087034602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI584051202811030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053702425073344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053474671871414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048672464801367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048680771383421") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ312460160330640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU482446631807432") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU443120677000135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK486263022716030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb563137601173436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH405610617770460") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI428447007470857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI714676472576137") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU430846555413857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU455868523435074") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM314886135481601") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624076167125758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL828827023882162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP252183615213788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY441655876848342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY450583438341310") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA007023204648554") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI754343508378851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX153284780083552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ541437131806627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV081012647253500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA162768706170274") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX538661552510561") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD475537206875044") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK573170435224014") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK720137660817775") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO078855632751174") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO448407012467243") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO801157747467437") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337184418811744") == GEOHEX3_VERIFY_RESULT_SUCCESS);

  // xy2hex
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(5L, -2L), 0).code, "XM", "x:5,y:-2,level:0: XM");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(0L, 0L), 0).code, "OY", "x:0,y:0,level:0: OY");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5L, 4L), 0).code, "GI", "x:-5,y:4,level:0: GI");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(5L, -4L), 0).code, "QU", "x:5,y:-4,level:0: QU");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4L, 5L), 0).code, "QU", "x:-4,y:5,level:0: QU");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5L, 3L), 0).code, "GH", "x:-5,y:3,level:0: GH");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10L, -1L), 0).code, "EU", "x:-10,y:-1,level:0: EU");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5L, -11L), 0).code, "CI", "x:-5,y:-11,level:0: CI");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10L, -6L), 0).code, "BV", "x:-10,y:-6,level:0: BV");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5L, 0L), 0).code, "Fb", "x:-5,y:0,level:0: Fb");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2L, 6L), 0).code, "SV", "x:2,y:6,level:0: SV");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3L, 12L), 0).code, "TO", "x:3,y:12,level:0: TO");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2L, 11L), 0).code, "TK", "x:2,y:11,level:0: TK");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6L, 8L), 0).code, "bD", "x:6,y:8,level:0: bD");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8L, 2L), 0).code, "ZA", "x:8,y:2,level:0: ZA");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6L, 5L), 0).code, "aX", "x:6,y:5,level:0: aX");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3L, 1L), 0).code, "PZ", "x:3,y:1,level:0: PZ");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1L, -4L), 0).code, "OK", "x:-1,y:-4,level:0: OK");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-18L, -16L), 1).code, "CZ3", "x:-18,y:-16,level:1: CZ3");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-14L, -32L), 1).code, "CI8", "x:-14,y:-32,level:1: CI8");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-37L, -10L), 1).code, "DO0", "x:-37,y:-10,level:1: DO0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-28L, -2L), 1).code, "EX2", "x:-28,y:-2,level:1: EX2");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4L, -30L), 1).code, "EU1", "x:-4,y:-30,level:1: EU1");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3L, -12L), 1).code, "OK4", "x:-3,y:-12,level:1: OK4");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-15L, 11L), 1).code, "GI3", "x:-15,y:11,level:1: GI3");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11L, -15L), 1).code, "GI1", "x:11,y:-15,level:1: GI1");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-13L, 14L), 1).code, "QU0", "x:-13,y:14,level:1: QU0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-11L, 15L), 1).code, "QU7", "x:-11,y:15,level:1: QU7");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-14L, 10L), 1).code, "GH8", "x:-14,y:10,level:1: GH8");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1L, -1L), 1).code, "OY0", "x:-1,y:-1,level:1: OY0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-15L, -1L), 1).code, "Fb3", "x:-15,y:-1,level:1: Fb3");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(15L, -6L), 1).code, "XM4", "x:15,y:-6,level:1: XM4");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8L, 2L), 1).code, "PZ0", "x:8,y:2,level:1: PZ0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7L, 20L), 1).code, "SW6", "x:7,y:20,level:1: SW6");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6L, 17L), 1).code, "SV3", "x:6,y:17,level:1: SV3");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(17L, 14L), 1).code, "aX0", "x:17,y:14,level:1: aX0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(19L, 16L), 1).code, "aX8", "x:19,y:16,level:1: aX8");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(17L, 22L), 1).code, "aZ2", "x:17,y:22,level:1: aZ2");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(9L, 36L), 1).code, "TO4", "x:9,y:36,level:1: TO4");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(34L, 8L), 1).code, "aB6", "x:34,y:8,level:1: aB6");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(32L, 6L), 1).code, "TK1", "x:32,y:6,level:1: TK1");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6L, 32L), 1).code, "TK3", "x:6,y:32,level:1: TK3");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(24L, 6L), 1).code, "ZA4", "x:24,y:6,level:1: ZA4");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4L, 5L), 1).code, "PA0", "x:-4,y:5,level:1: PA0");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-29L, -17L), 1).code, "BV8", "x:-29,y:-17,level:1: BV8");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-41L, -100L), 2).code, "CI76", "x:-41,y:-100,level:2: CI76");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-45L, -95L), 2).code, "CI55", "x:-45,y:-95,level:2: CI55");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-110L, -30L), 2).code, "DO07", "x:-110,y:-30,level:2: DO07");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-30L, -110L), 2).code, "DO05", "x:-30,y:-110,level:2: DO05");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-92L, -13L), 2).code, "EU06", "x:-92,y:-13,level:2: EU06");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-12L, -91L), 2).code, "EU13", "x:-12,y:-91,level:2: EU13");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-46L, 25L), 2).code, "GH32", "x:-46,y:25,level:2: GH32");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10L, -33L), 2).code, "OK51", "x:-10,y:-33,level:2: OK51");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-44L, 36L), 2).code, "GI47", "x:-44,y:36,level:2: GI47");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(36L, -43L), 2).code, "GI53", "x:36,y:-43,level:2: GI53");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-38L, 43L), 2).code, "QU08", "x:-38,y:43,level:2: QU08");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-35L, 40L), 2).code, "OC58", "x:-35,y:40,level:2: OC58");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(47L, -31L), 2).code, "XL60", "x:47,y:-31,level:2: XL60");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(46L, -16L), 2).code, "XM56", "x:46,y:-16,level:2: XM56");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(38L, -20L), 2).code, "PS62", "x:38,y:-20,level:2: PS62");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(51L, -13L), 2).code, "XX03", "x:51,y:-13,level:2: XX03");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(28L, 7L), 2).code, "PZ38", "x:28,y:7,level:2: PZ38");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(24L, 6L), 2).code, "PZ04", "x:24,y:6,level:2: PZ04");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(25L, 10L), 2).code, "PZ18", "x:25,y:10,level:2: PZ18");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5L, -5L), 2).code, "OU88", "x:-5,y:-5,level:2: OU88");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(0L, 2L), 2).code, "OY53", "x:0,y:2,level:2: OY53");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-12L, 15L), 2).code, "PA04", "x:-12,y:15,level:2: PA04");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-47L, 0L), 2).code, "Fb17", "x:-47,y:0,level:2: Fb17");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-45L, -3L), 2).code, "Fb34", "x:-45,y:-3,level:2: Fb34");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-41L, 2L), 2).code, "Fb86", "x:-41,y:2,level:2: Fb86");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-44L, 31L), 2).code, "GH58", "x:-44,y:31,level:2: GH58");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(21L, 95L), 2).code, "TK63", "x:21,y:95,level:2: TK63");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(25L, 105L), 2).code, "TO07", "x:25,y:105,level:2: TO07");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(107L, 28L), 2).code, "TO42", "x:107,y:28,level:2: TO42");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(95L, 16L), 2).code, "TK02", "x:95,y:16,level:2: TK02");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(53L, 69L), 2).code, "bD31", "x:53,y:69,level:2: bD31");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(57L, 80L), 2).code, "bE73", "x:57,y:80,level:2: bE73");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(90L, 50L), 2).code, "bb33", "x:90,y:50,level:2: bb33");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(30L, 111L), 2).code, "TO84", "x:30,y:111,level:2: TO84");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(28L, 108L), 2).code, "TO47", "x:28,y:108,level:2: TO47");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(101L, 24L), 2).code, "aB61", "x:101,y:24,level:2: aB61");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(70L, 16L), 2).code, "ZA08", "x:70,y:16,level:2: ZA08");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(54L, 49L), 2).code, "aX55", "x:54,y:49,level:2: aX55");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(51L, 42L), 2).code, "aX04", "x:51,y:42,level:2: aX04");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(55L, 40L), 2).code, "YF58", "x:55,y:40,level:2: YF58");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(17L, 53L), 2).code, "SV40", "x:17,y:53,level:2: SV40");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3L, 46L), 2).code, "RX15", "x:-3,y:46,level:2: RX15");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10L, -10L), 2).code, "OU40", "x:-10,y:-10,level:2: OU40");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-89L, -52L), 2).code, "BV56", "x:-89,y:-52,level:2: BV56");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-124L, -297L), 3).code, "CI771", "x:-124,y:-297,level:3: CI771");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-90L, -332L), 3).code, "DO045", "x:-90,y:-332,level:3: DO045");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-89L, -331L), 3).code, "DO056", "x:-89,y:-331,level:3: DO056");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-329L, -90L), 3).code, "DO077", "x:-329,y:-90,level:3: DO077");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-257L, -161L), 3).code, "BV778", "x:-257,y:-161,level:3: BV778");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-266L, -155L), 3).code, "BV568", "x:-266,y:-155,level:3: BV568");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-162L, -146L), 3).code, "CZ335", "x:-162,y:-146,level:3: CZ335");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-25L, -262L), 3).code, "EU570", "x:-25,y:-262,level:3: EU570");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-257L, -20L), 3).code, "EU868", "x:-257,y:-20,level:3: EU868");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-23L, -110L), 3).code, "OK468", "x:-23,y:-110,level:3: OK468");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(0L, -1L), 3).code, "OY443", "x:0,y:-1,level:3: OY443");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-12L, -12L), 3).code, "OY004", "x:-12,y:-12,level:3: OY004");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-137L, 11L), 3).code, "Fb526", "x:-137,y:11,level:3: Fb526");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-131L, 94L), 3).code, "GH588", "x:-131,y:94,level:3: GH588");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-136L, 107L), 3).code, "GI440", "x:-136,y:107,level:3: GI440");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-130L, 103L), 3).code, "GI622", "x:-130,y:103,level:3: GI622");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-109L, 125L), 3).code, "QU340", "x:-109,y:125,level:3: QU340");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(124L, -115L), 3).code, "QU026", "x:124,y:-115,level:3: QU026");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(135L, -51L), 3).code, "XM454", "x:135,y:-51,level:3: XM454");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(114L, -60L), 3).code, "PS624", "x:114,y:-60,level:3: PS624");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(154L, -38L), 3).code, "XX038", "x:154,y:-38,level:3: XX038");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(143L, -40L), 3).code, "XU630", "x:143,y:-40,level:3: XU630");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(80L, 19L), 3).code, "PZ342", "x:80,y:19,level:3: PZ342");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(83L, 38L), 3).code, "PZ580", "x:83,y:38,level:3: PZ580");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12L, 6L), 3).code, "OY864", "x:12,y:6,level:3: OY864");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-9L, 1L), 3).code, "OY145", "x:-9,y:1,level:3: OY145");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-37L, 43L), 3).code, "PA032", "x:-37,y:43,level:3: PA032");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-44L, 112L), 3).code, "OI758", "x:-44,y:112,level:3: OI758");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(52L, 166L), 3).code, "SV428", "x:52,y:166,level:3: SV428");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(57L, 157L), 3).code, "SV385", "x:57,y:157,level:3: SV385");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(162L, 130L), 3).code, "aX355", "x:162,y:130,level:3: aX355");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(166L, 142L), 3).code, "aX568", "x:166,y:142,level:3: aX568");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(171L, 216L), 3).code, "bD744", "x:171,y:216,level:3: bD744");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(159L, 226L), 3).code, "bD515", "x:159,y:226,level:3: bD515");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(271L, 150L), 3).code, "bb337", "x:271,y:150,level:3: bb337");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(88L, 331L), 3).code, "TO808", "x:88,y:331,level:3: TO808");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(322L, 85L), 3).code, "TO428", "x:322,y:85,level:3: TO428");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(84L, 324L), 3).code, "TO474", "x:84,y:324,level:3: TO474");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(75L, 314L), 3).code, "TO073", "x:75,y:314,level:3: TO073");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(307L, 73L), 3).code, "aB648", "x:307,y:73,level:3: aB648");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(184L, 52L), 3).code, "YG168", "x:184,y:52,level:3: YG168");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-787L, -477L), 4).code, "BV7511", "x:-787,y:-477,level:4: BV7511");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-784L, -477L), 4).code, "BV7541", "x:-784,y:-477,level:4: BV7541");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-271L, -992L), 4).code, "DO0532", "x:-271,y:-992,level:4: DO0532");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-984L, -265L), 4).code, "DO3203", "x:-984,y:-265,level:4: DO3203");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-792L, -101L), 4).code, "EU6235", "x:-792,y:-101,level:4: EU6235");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-111L, -806L), 4).code, "EU1425", "x:-111,y:-806,level:4: EU1425");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-61L, -323L), 4).code, "OK7172", "x:-61,y:-323,level:4: OK7172");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-503L, -435L), 4).code, "CZ0737", "x:-503,y:-435,level:4: CZ0737");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-445L, -22L), 4).code, "Fb0200", "x:-445,y:-22,level:4: Fb0200");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-371L, 16L), 4).code, "Fb8608", "x:-371,y:16,level:4: Fb8608");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-408L, 241L), 4).code, "GH4405", "x:-408,y:241,level:4: GH4405");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(305L, -384L), 4).code, "GI2651", "x:305,y:-384,level:4: GI2651");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-364L, 354L), 4).code, "OC2121", "x:-364,y:354,level:4: OC2121");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-286L, 414L), 4).code, "QU7871", "x:-286,y:414,level:4: QU7871");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(392L, -314L), 4).code, "QU4212", "x:392,y:-314,level:4: QU4212");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-79L, -335L), 4).code, "OK4362", "x:-79,y:-335,level:4: OK4362");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-26L, -47L), 4).code, "OX2538", "x:-26,y:-47,level:4: OX2538");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12L, 14L), 4).code, "OY5663", "x:12,y:14,level:4: OY5663");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-123L, 122L), 4).code, "OG6663", "x:-123,y:122,level:4: OG6663");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(224L, 42L), 4).code, "PZ0631", "x:224,y:42,level:4: PZ0631");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(187L, 523L), 4).code, "SV8518", "x:187,y:523,level:4: SV8518");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(154L, 872L), 4).code, "TK3246", "x:154,y:872,level:4: TK3246");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(870L, 175L), 4).code, "TK1825", "x:870,y:175,level:4: TK1825");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(925L, 219L), 4).code, "aB6727", "x:925,y:219,level:4: aB6727");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(284L, 979L), 4).code, "TR1202", "x:284,y:979,level:4: TR1202");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(477L, 642L), 4).code, "bD4054", "x:477,y:642,level:4: bD4054");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(490L, 407L), 4).code, "aX4486", "x:490,y:407,level:4: aX4486");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(660L, 184L), 4).code, "ZA5685", "x:660,y:184,level:4: ZA5685");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(416L, -150L), 4).code, "XM4881", "x:416,y:-150,level:4: XM4881");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(428L, -119L), 4).code, "XU6302", "x:428,y:-119,level:4: XU6302");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(460L, -120L), 4).code, "XX0337", "x:460,y:-120,level:4: XX0337");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(429L, -185L), 4).code, "XM6425", "x:429,y:-185,level:4: XM6425");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(344L, -181L), 4).code, "PS6270", "x:344,y:-181,level:4: PS6270");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2380L, -1415L), 5).code, "BV80302", "x:-2380,y:-1415,level:5: BV80302");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2373L, -1414L), 5).code, "BV80373", "x:-2373,y:-1414,level:5: BV80373");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2970L, -789L), 5).code, "DO08354", "x:-2970,y:-789,level:5: DO08354");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-800L, -2966L), 5).code, "DO05758", "x:-800,y:-2966,level:5: DO05758");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2466L, -326L), 5).code, "EU31135", "x:-2466,y:-326,level:5: EU31135");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-253L, -2411L), 5).code, "EU45042", "x:-253,y:-2411,level:5: EU45042");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1463L, -1275L), 5).code, "CZ35087", "x:-1463,y:-1275,level:5: CZ35087");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-297L, -1079L), 5).code, "OK06445", "x:-297,y:-1079,level:5: OK06445");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1160L, 57L), 5).code, "Fb80457", "x:-1160,y:57,level:5: Fb80457");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1165L, 787L), 5).code, "GH80422", "x:-1165,y:787,level:5: GH80422");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1125L, 974L), 5).code, "GI74753", "x:-1125,y:974,level:5: GI74753");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1016L, -1153L), 5).code, "GI80240", "x:1016,y:-1153,level:5: GI80240");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1101L, -1046L), 5).code, "QU01265", "x:1101,y:-1046,level:5: QU01265");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-864L, 1260L), 5).code, "QU86344", "x:-864,y:1260,level:5: QU86344");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(108L, -12L), 5).code, "OY77334", "x:108,y:-12,level:5: OY77334");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-81L, 30L), 5).code, "OY15454", "x:-81,y:30,level:5: OY15454");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-331L, 404L), 5).code, "PA04170", "x:-331,y:404,level:5: PA04170");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1014L, -541L), 5).code, "PS62113", "x:1014,y:-541,level:5: PS62113");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1079L, -548L), 5).code, "PS68342", "x:1079,y:-548,level:5: PS68342");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1314L, -458L), 5).code, "XM78145", "x:1314,y:-458,level:5: XM78145");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1234L, -447L), 5).code, "XM48257", "x:1234,y:-447,level:5: XM48257");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1369L, -349L), 5).code, "XX03156", "x:1369,y:-349,level:5: XX03156");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(768L, 238L), 5).code, "PZ47685", "x:768,y:238,level:5: PZ47685");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(468L, 1425L), 5).code, "SV40654", "x:468,y:1425,level:5: SV40654");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-420L, 980L), 5).code, "OI71873", "x:-420,y:980,level:5: OI71873");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1425L, 1194L), 5).code, "aX40264", "x:1425,y:1194,level:5: aX40264");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1943L, 499L), 5).code, "ZA44552", "x:1943,y:499,level:5: ZA44552");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1474L, 1944L), 5).code, "bD47117", "x:1474,y:1944,level:5: bD47117");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2652L, 559L), 5).code, "TK51615", "x:2652,y:559,level:5: TK51615");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(546L, 2665L), 5).code, "TK71615", "x:546,y:2665,level:5: TK71615");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(757L, 2866L), 5).code, "TO38458", "x:757,y:2866,level:5: TO38458");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2946L, 840L), 5).code, "TO58484", "x:2946,y:840,level:5: TO58484");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7288L, -4065L), 6).code, "BV553581", "x:-7288,y:-4065,level:6: BV553581");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3512L, -7830L), 6).code, "CI802417", "x:-3512,y:-7830,level:6: CI802417");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3442L, -7966L), 6).code, "CI750110", "x:-3442,y:-7966,level:6: CI750110");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2473L, -8957L), 6).code, "DO018862", "x:-2473,y:-8957,level:6: DO018862");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2433L, -8930L), 6).code, "DO053505", "x:-2433,y:-8930,level:6: DO053505");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-8898L, -2442L), 6).code, "DO074664", "x:-8898,y:-2442,level:6: DO074664");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4396L, -3794L), 6).code, "CZ351822", "x:-4396,y:-3794,level:6: CZ351822");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-841L, -7261L), 6).code, "EU412420", "x:-841,y:-7261,level:6: EU412420");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7114L, -786L), 6).code, "EU708101", "x:-7114,y:-786,level:6: EU708101");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-467L, -2684L), 6).code, "OK847038", "x:-467,y:-2684,level:6: OK847038");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3743L, 2344L), 6).code, "GH501658", "x:-3743,y:2344,level:6: GH501658");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3141L, -3384L), 6).code, "GI842644", "x:3141,y:-3384,level:6: GI842644");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3372L, 3061L), 6).code, "GI836575", "x:-3372,y:3061,level:6: GI836575");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2966L, 3388L), 6).code, "QU316588", "x:-2966,y:3388,level:6: QU316588");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3486L, -2885L), 6).code, "QU175485", "x:3486,y:-2885,level:6: QU175485");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3515L, 9L), 6).code, "Fb711277", "x:-3515,y:9,level:6: Fb711277");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(189L, 99L), 6).code, "OY728344", "x:189,y:99,level:6: OY728344");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1024L, 1180L), 6).code, "PA016372", "x:-1024,y:1180,level:6: PA016372");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2959L, 3602L), 6).code, "QU408880", "x:-2959,y:3602,level:6: QU408880");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3619L, -1443L), 6).code, "XM442337", "x:3619,y:-1443,level:6: XM442337");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3036L, -1616L), 6).code, "PS387785", "x:3036,y:-1616,level:6: PS387785");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4150L, -1065L), 6).code, "XX037037", "x:4150,y:-1065,level:6: XX037037");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2038L, 692L), 6).code, "PZ173676", "x:2038,y:692,level:6: PZ173676");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1357L, 4214L), 6).code, "SV321726", "x:1357,y:4214,level:6: SV321726");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-537L, 3278L), 6).code, "PC828583", "x:-537,y:3278,level:6: PC828583");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1293L, 2881L), 6).code, "OI713375", "x:-1293,y:2881,level:6: OI713375");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4175L, 5636L), 6).code, "bD080050", "x:4175,y:5636,level:6: bD080050");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4550L, 3884L), 6).code, "aX817100", "x:4550,y:3884,level:6: aX817100");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(5971L, 1486L), 6).code, "ZA712478", "x:5971,y:1486,level:6: ZA712478");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7881L, 1342L), 6).code, "TK166315", "x:7881,y:1342,level:6: TK166315");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1784L, 8239L), 6).code, "TK873482", "x:1784,y:8239,level:6: TK873482");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2183L, 8638L), 6).code, "TO433402", "x:2183,y:8638,level:6: TO433402");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8855L, 2476L), 6).code, "TO586342", "x:8855,y:2476,level:6: TO586342");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7289L, 4066L), 6).code, "bb335332", "x:7289,y:4066,level:6: bb335332");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-21398L, -12686L), 7).code, "BV8032788", "x:-21398,y:-12686,level:7: BV8032788");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10047L, -24045L), 7).code, "CI7714524", "x:-10047,y:-24045,level:7: CI7714524");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7358L, -26737L), 7).code, "DO0514686", "x:-7358,y:-26737,level:7: DO0514686");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7348L, -26743L), 7).code, "DO0517300", "x:-7348,y:-26743,level:7: DO0517300");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-26744L, -7350L), 7).code, "DO0732687", "x:-26744,y:-7350,level:7: DO0732687");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-26744L, -7346L), 7).code, "DO0732768", "x:-26744,y:-7346,level:7: DO0732768");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-22131L, -2506L), 7).code, "EU4031833", "x:-22131,y:-2506,level:7: EU4031833");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-21340L, -1677L), 7).code, "EU8072131", "x:-21340,y:-1677,level:7: EU8072131");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1698L, -20786L), 7).code, "EU8255485", "x:-1698,y:-20786,level:7: EU8255485");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-12982L, -11521L), 7).code, "CZ3800810", "x:-12982,y:-11521,level:7: CZ3800810");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2741L, -8911L), 7).code, "OK1624776", "x:-2741,y:-8911,level:7: OK1624776");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1380L, -8819L), 7).code, "OK7464515", "x:-1380,y:-8819,level:7: OK7464515");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10979L, 458L), 7).code, "Fb5316746", "x:-10979,y:458,level:7: Fb5316746");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-11180L, -339L), 7).code, "Fb4033527", "x:-11180,y:-339,level:7: Fb4033527");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10952L, 6790L), 7).code, "GH4540858", "x:-10952,y:6790,level:7: GH4540858");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10956L, 8592L), 7).code, "GI4351804", "x:-10956,y:8592,level:7: GI4351804");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-10095L, 9318L), 7).code, "GI8387484", "x:-10095,y:9318,level:7: GI8387484");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-9277L, 10098L), 7).code, "QU0706771", "x:-9277,y:10098,level:7: QU0706771");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-8432L, 11250L), 7).code, "QU4884047", "x:-8432,y:11250,level:7: QU4884047");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11387L, -7686L), 7).code, "QU8251271", "x:11387,y:-7686,level:7: QU8251271");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2826L, 3825L), 7).code, "PA0565644", "x:-2826,y:3825,level:7: PA0565644");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(616L, 553L), 7).code, "OY8320288", "x:616,y:553,level:7: OY8320288");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(31L, -430L), 7).code, "OY3556486", "x:31,y:-430,level:7: OY3556486");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6999L, 2655L), 7).code, "PZ8016814", "x:6999,y:2655,level:7: PZ8016814");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6108L, 2148L), 7).code, "PZ1746604", "x:6108,y:2148,level:7: PZ1746604");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(9201L, -4840L), 7).code, "PS6242083", "x:9201,y:-4840,level:7: PS6242083");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11177L, -3902L), 7).code, "XM5643552", "x:11177,y:-3902,level:7: XM5643552");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11588L, -3256L), 7).code, "XU6303820", "x:11588,y:-3256,level:7: XU6303820");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11885L, -4045L), 7).code, "XM7851800", "x:11885,y:-4045,level:7: XM7851800");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12402L, -3139L), 7).code, "XX0345653", "x:12402,y:-3139,level:7: XX0345653");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11611L, -5463L), 7).code, "XM6306347", "x:11611,y:-5463,level:7: XM6306347");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(11860L, -7698L), 7).code, "QU8827707", "x:11860,y:-7698,level:7: QU8827707");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6317L, 2473L), 7).code, "PZ4253332", "x:6317,y:2473,level:7: PZ4253332");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3287L, 9451L), 7).code, "OI8776718", "x:-3287,y:9451,level:7: OI8776718");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-935L, 9497L), 7).code, "PF2148656", "x:-935,y:9497,level:7: PF2148656");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(17612L, 4695L), 7).code, "ZA4587731", "x:17612,y:4695,level:7: ZA4587731");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4361L, 12818L), 7).code, "SV4335020", "x:4361,y:12818,level:7: SV4335020");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4606L, 14077L), 7).code, "SV5843218", "x:4606,y:14077,level:7: SV5843218");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12693L, 10079L), 7).code, "aX0682573", "x:12693,y:10079,level:7: aX0682573");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(13511L, 11564L), 7).code, "aX8100870", "x:13511,y:11564,level:7: aX8100870");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(13047L, 17583L), 7).code, "bD4424804", "x:13047,y:17583,level:7: bD4424804");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(13488L, 18845L), 7).code, "bE6100113", "x:13488,y:18845,level:7: bE6100113");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(23749L, 4950L), 7).code, "TK5027217", "x:23749,y:4950,level:7: TK5027217");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4911L, 23787L), 7).code, "TK7070414", "x:4911,y:23787,level:7: TK7070414");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7019L, 25741L), 7).code, "TO6240542", "x:7019,y:25741,level:7: TO6240542");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7624L, 26269L), 7).code, "TO7775738", "x:7624,y:26269,level:7: TO7775738");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(26391L, 7606L), 7).code, "TO5821675", "x:26391,y:7606,level:7: TO5821675");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(21935L, 12157L), 7).code, "bb3371862", "x:21935,y:12157,level:7: bb3371862");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-65323L, -36952L), 8).code, "BV54870250", "x:-65323,y:-36952,level:8: BV54870250");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-62926L, -38333L), 8).code, "BV78253862", "x:-62926,y:-38333,level:8: BV78253862");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-31809L, -69868L), 8).code, "CI57758513", "x:-31809,y:-69868,level:8: CI57758513");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-30494L, -71782L), 8).code, "CI75600226", "x:-30494,y:-71782,level:8: CI75600226");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-21702L, -80549L), 8).code, "DO05603615", "x:-21702,y:-80549,level:8: DO05603615");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-80467L, -21766L), 8).code, "DO07152160", "x:-80467,y:-21766,level:8: DO07152160");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7440L, -65970L), 8).code, "EU41063674", "x:-7440,y:-65970,level:8: EU41063674");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-64509L, -5663L), 8).code, "EU72201265", "x:-64509,y:-5663,level:8: EU72201265");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-39073L, -35037L), 8).code, "CZ34762511", "x:-39073,y:-35037,level:8: CZ34762511");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-32349L, -1210L), 8).code, "Fb38241503", "x:-32349,y:-1210,level:8: Fb38241503");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5936L, -25284L), 8).code, "OK48511367", "x:-5936,y:-25284,level:8: OK48511367");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-33815L, 24569L), 8).code, "GI32042116", "x:-33815,y:24569,level:8: GI32042116");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-31272L, 26421L), 8).code, "GI71565064", "x:-31272,y:26421,level:8: GI71565064");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-32834L, 20449L), 8).code, "GH45442518", "x:-32834,y:20449,level:8: GH45442518");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-287L, -2566L), 8).code, "OY33228746", "x:-287,y:-2566,level:8: OY33228746");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-8889L, 10487L), 8).code, "PA03278283", "x:-8889,y:10487,level:8: PA03278283");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(31913L, -25521L), 8).code, "QU42174351", "x:31913,y:-25521,level:8: QU42174351");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-25877L, 32911L), 8).code, "QU47122108", "x:-25877,y:32911,level:8: QU47122108");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(31813L, -14434L), 8).code, "XM32230826", "x:31813,y:-14434,level:8: XM32230826");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(33415L, -11998L), 8).code, "XM56301016", "x:33415,y:-11998,level:8: XM56301016");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(27521L, -15036L), 8).code, "PS61272751", "x:27521,y:-15036,level:8: PS61272751");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(34467L, -15847L), 8).code, "XM60832123", "x:34467,y:-15847,level:8: XM60832123");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(34663L, -9393L), 8).code, "XU63124187", "x:34663,y:-9393,level:8: XU63124187");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(37009L, -9499L), 8).code, "XX03173236", "x:37009,y:-9499,level:8: XX03173236");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(20661L, 5207L), 8).code, "PZ38755703", "x:20661,y:5207,level:8: PZ38755703");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(20680L, 8828L), 8).code, "PZ57757416", "x:20680,y:8828,level:8: PZ57757416");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-33627L, 8900L), 8).code, "Fc51504013", "x:-33627,y:8900,level:8: Fc51504013");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-9373L, 9772L), 8).code, "OW22586402", "x:-9373,y:9772,level:8: OW22586402");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7256L, 29273L), 8).code, "PC52458806", "x:-7256,y:29273,level:8: PC52458806");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(10409L, 41172L), 8).code, "SV20852101", "x:10409,y:41172,level:8: SV20852101");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(40193L, 32120L), 8).code, "aX46486040", "x:40193,y:32120,level:8: aX46486040");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(54181L, 11739L), 8).code, "ZA62754057", "x:54181,y:11739,level:8: ZA62754057");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(38009L, 55078L), 8).code, "bD28367162", "x:38009,y:55078,level:8: bD28367162");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(70129L, 11772L), 8).code, "TK05722747", "x:70129,y:11772,level:8: TK05722747");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(15031L, 73704L), 8).code, "TK83151057", "x:15031,y:73704,level:8: TK83151057");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(18689L, 76439L), 8).code, "TO31130720", "x:18689,y:76439,level:8: TO31130720");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(77975L, 21548L), 8).code, "TO51331450", "x:77975,y:21548,level:8: TO51331450");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(65707L, 36557L), 8).code, "bb33488116", "x:65707,y:36557,level:8: bb33488116");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-192730L, -113498L), 9).code, "BV804240512", "x:-192730,y:-113498,level:9: BV804240512");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-93233L, -217789L), 9).code, "CI708565326", "x:-93233,y:-217789,level:9: CI708565326");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-91574L, -214055L), 9).code, "CI754848748", "x:-91574,y:-214055,level:9: CI754848748");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-65557L, -239547L), 9).code, "DO055580431", "x:-65557,y:-239547,level:9: DO055580431");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-65568L, -241250L), 9).code, "DO053480025", "x:-65568,y:-241250,level:9: DO053480025");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-240620L, -66198L), 9).code, "DO073506567", "x:-240620,y:-66198,level:9: DO073506567");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-117693L, -105237L), 9).code, "CZ347013544", "x:-117693,y:-105237,level:9: CZ347013544");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-21785L, -197548L), 9).code, "EU413474586", "x:-21785,y:-197548,level:9: EU413474586");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-196764L, -23769L), 9).code, "EU354580674", "x:-196764,y:-23769,level:9: EU354580674");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-17495L, -78389L), 9).code, "OK474555348", "x:-17495,y:-78389,level:9: OK474555348");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-95874L, 2387L), 9).code, "Fb484868583", "x:-95874,y:2387,level:9: Fb484868583");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-104426L, 58881L), 9).code, "GH147081657", "x:-104426,y:58881,level:9: GH147081657");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-92362L, 75580L), 9).code, "GI730641802", "x:-92362,y:75580,level:9: GI730641802");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(81554L, -92343L), 9).code, "GI576514101", "x:81554,y:-92343,level:9: GI576514101");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7537L, -6845L), 9).code, "OY041035522", "x:-7537,y:-6845,level:9: OY041035522");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(425L, 4367L), 9).code, "OY537117080", "x:425,y:4367,level:9: OY537117080");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-22553L, 38131L), 9).code, "PA402570238", "x:-22553,y:38131,level:9: PA402570238");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(92929L, -82142L), 9).code, "QU058877078", "x:92929,y:-82142,level:9: QU058877078");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-72716L, 103875L), 9).code, "QU832828267", "x:-72716,y:103875,level:9: QU832828267");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(60670L, 16037L), 9).code, "PZ382714446", "x:60670,y:16037,level:9: PZ382714446");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(51378L, 15741L), 9).code, "PZ028668414", "x:51378,y:15741,level:9: PZ028668414");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(81179L, -44625L), 9).code, "PS383657231", "x:81179,y:-44625,level:9: PS383657231");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(101932L, -47400L), 9).code, "XM602176827", "x:101932,y:-47400,level:9: XM602176827");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(99852L, -36332L), 9).code, "XM482452815", "x:99852,y:-36332,level:9: XM482452815");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(111217L, -29119L), 9).code, "XX033123366", "x:111217,y:-29119,level:9: XX033123366");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-31170L, 82105L), 9).code, "OI860616105", "x:-31170,y:82105,level:9: OI860616105");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-8879L, 98168L), 9).code, "RX114077466", "x:-8879,y:98168,level:9: RX114077466");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(39167L, 114247L), 9).code, "SV355072242", "x:39167,y:114247,level:9: SV355072242");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(135264L, 38523L), 9).code, "YG413103084", "x:135264,y:38523,level:9: YG413103084");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(160465L, 40888L), 9).code, "ZA486483578", "x:160465,y:40888,level:9: ZA486483578");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(116473L, 99865L), 9).code, "aX426174078", "x:116473,y:99865,level:9: aX426174078");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(125488L, 98637L), 9).code, "aX747576237", "x:125488,y:98637,level:9: aX747576237");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(212332L, 41759L), 9).code, "TK184816376", "x:212332,y:41759,level:9: TK184816376");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(56060L, 229191L), 9).code, "TO310523631", "x:56060,y:229191,level:9: TO310523631");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(234195L, 60644L), 9).code, "TO423806423", "x:234195,y:60644,level:9: TO423806423");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(194922L, 108907L), 9).code, "bb303856635", "x:194922,y:108907,level:9: bb303856635");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(240443L, 66356L), 9).code, "TO815178640", "x:240443,y:66356,level:9: TO815178640");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(101969L, 351082L), 10).code, "SV1700305142", "x:101969,y:351082,level:10: SV1700305142");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-588706L, -331776L), 10).code, "BV5482764471", "x:-588706,y:-331776,level:10: BV5482764471");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-569492L, -350934L), 10).code, "BV7560068257", "x:-569492,y:-350934,level:10: BV7560068257");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-299458L, -626419L), 10).code, "CI5263615540", "x:-299458,y:-626419,level:10: CI5263615540");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-279875L, -644203L), 10).code, "CI7265571616", "x:-279875,y:-644203,level:10: CI7265571616");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-277938L, -644342L), 10).code, "CI7505181555", "x:-277938,y:-644342,level:10: CI7505181555");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-287938L, -632544L), 10).code, "CI5736546251", "x:-287938,y:-632544,level:10: CI5736546251");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-201509L, -722570L), 10).code, "DO0273028158", "x:-201509,y:-722570,level:10: DO0273028158");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-196078L, -724405L), 10).code, "DO0536546500", "x:-196078,y:-724405,level:10: DO0536546500");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-722848L, -197635L), 10).code, "DO0716764500", "x:-722848,y:-197635,level:10: DO0716764500");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-67395L, -597798L), 10).code, "EU4016113514", "x:-67395,y:-597798,level:10: EU4016113514");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-53605L, -581735L), 10).code, "EU4827777232", "x:-53605,y:-581735,level:10: EU4827777232");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-571001L, -58046L), 10).code, "EU7445272188", "x:-571001,y:-58046,level:10: EU7445272188");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-69258L, -236371L), 10).code, "OK1777354303", "x:-69258,y:-236371,level:10: OK1777354303");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-357091L, -313496L), 10).code, "CZ3420476772", "x:-357091,y:-313496,level:10: CZ3420476772");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-295156L, -8676L), 10).code, "Fb4334484641", "x:-295156,y:-8676,level:10: Fb4334484641");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-287868L, 205168L), 10).code, "GH5856584625", "x:-287868,y:205168,level:10: GH5856584625");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(222513L, -297832L), 10).code, "GI1730824803", "x:222513,y:-297832,level:10: GI1730824803");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-282243L, 240894L), 10).code, "GI7234521114", "x:-282243,y:240894,level:10: GI7234521114");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-230449L, 284384L), 10).code, "QU3851424320", "x:-230449,y:284384,level:10: QU3851424320");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(307274L, -213787L), 10).code, "QU8152020110", "x:307274,y:-213787,level:10: QU8152020110");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-80416L, 100191L), 10).code, "PA0426257051", "x:-80416,y:100191,level:10: PA0426257051");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-6228L, 6228L), 10).code, "OY4244664644", "x:-6228,y:6228,level:10: OY4244664644");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(19383L, -4812L), 10).code, "OY7353226324", "x:19383,y:-4812,level:10: OY7353226324");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-27L, -19749L), 10).code, "OY3444432334", "x:-27,y:-19749,level:10: OY3444432334");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(309109L, -219218L), 10).code, "QU8136543688", "x:309109,y:-219218,level:10: QU8136543688");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-210852L, 319359L), 10).code, "QU8831183154", "x:-210852,y:319359,level:10: QU8831183154");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(248067L, -133906L), 10).code, "PS6206841033", "x:248067,y:-133906,level:10: PS6206841033");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(278036L, -132673L), 10).code, "XM0565771230", "x:278036,y:-132673,level:10: XM0565771230");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(303692L, -114283L), 10).code, "XM4863207510", "x:303692,y:-114283,level:10: XM4863207510");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(334084L, -88043L), 10).code, "XX0330807788", "x:334084,y:-88043,level:10: XX0330807788");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(308354L, -142317L), 10).code, "XM6054354111", "x:308354,y:-142317,level:10: XM6054354111");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(158553L, 66174L), 10).code, "PZ1548687734", "x:158553,y:66174,level:10: PZ1548687734");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(196649L, 68268L), 10).code, "PZ7555070851", "x:196649,y:68268,level:10: PZ7555070851");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-96846L, 245166L), 10).code, "OI7581576564", "x:-96846,y:245166,level:10: OI7581576564");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-19618L, 300077L), 10).code, "RX1535370770", "x:-19618,y:300077,level:10: RX1535370770");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(130781L, 345641L), 10).code, "SV7031782060", "x:130781,y:345641,level:10: SV7031782060");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(137387L, 391171L), 10).code, "SW6431665682", "x:137387,y:391171,level:10: SW6431665682");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(339859L, 288479L), 10).code, "aX1617612856", "x:339859,y:288479,level:10: aX1617612856");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(367297L, 304827L), 10).code, "aX7255422107", "x:367297,y:304827,level:10: aX7255422107");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(489526L, 112743L), 10).code, "ZA7323011017", "x:489526,y:112743,level:10: ZA7323011017");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(622465L, 95503L), 10).code, "TK0130411728", "x:622465,y:95503,level:10: TK0130411728");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(132791L, 662483L), 10).code, "TK8071386820", "x:132791,y:662483,level:10: TK8071386820");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(176837L, 706530L), 10).code, "TO4434206021", "x:176837,y:706530,level:10: TO4434206021");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(591721L, 328762L), 10).code, "bb3372146218", "x:591721,y:328762,level:10: bb3372146218");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1756368L, -999687L), 11).code, "BV57264048634", "x:-1756368,y:-999687,level:11: BV57264048634");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-872017L, -1884038L), 11).code, "CI57246068382", "x:-872017,y:-1884038,level:11: CI57246068382");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-590208L, -2165847L), 11).code, "DO05443747884", "x:-590208,y:-2165847,level:11: DO05443747884");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2175911L, -590930L), 11).code, "DO04773823048", "x:-2175911,y:-590930,level:11: DO04773823048");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2175911L, -590930L), 11).code, "DO04773823048", "x:-2175911,y:-590930,level:11: DO04773823048");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2174772L, -586677L), 11).code, "DO07200264504", "x:-2174772,y:-586677,level:11: DO07200264504");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1055396L, -940181L), 11).code, "CZ34837816828", "x:-1055396,y:-940181,level:11: CZ34837816828");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-208219L, -1749605L), 11).code, "EU18781747622", "x:-208219,y:-1749605,level:11: EU18781747622");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1749082L, -179649L), 11).code, "EU47467037811", "x:-1749082,y:-179649,level:11: EU47467037811");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-940042L, -30780L), 11).code, "Fb05827021141", "x:-940042,y:-30780,level:11: Fb05827021141");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-140855L, -695131L), 11).code, "OK72311284586", "x:-140855,y:-695131,level:11: OK72311284586");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-903332L, 585118L), 11).code, "GH51383310718", "x:-903332,y:585118,level:11: GH51383310718");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-867669L, 707992L), 11).code, "GI47416263465", "x:-867669,y:707992,level:11: GI47416263465");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-813735L, 761926L), 11).code, "GI87045185255", "x:-813735,y:761926,level:11: GI87045185255");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-757103L, 818558L), 11).code, "QU07002763476", "x:-757103,y:818558,level:11: QU07002763476");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(953857L, -639688L), 11).code, "QU85663663436", "x:953857,y:-639688,level:11: QU85663663436");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(935104L, -645206L), 11).code, "QU84201138888", "x:935104,y:-645206,level:11: QU84201138888");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(741839L, -393961L), 11).code, "PS62147032100", "x:741839,y:-393961,level:11: PS62147032100");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(862073L, -432515L), 11).code, "XM30178015132", "x:862073,y:-432515,level:11: XM30178015132");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(918442L, -437646L), 11).code, "XM60054311737", "x:918442,y:-437646,level:11: XM60054311737");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(887214L, -350566L), 11).code, "XM44560457183", "x:887214,y:-350566,level:11: XM44560457183");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(906282L, -313572L), 11).code, "XM56456700534", "x:906282,y:-313572,level:11: XM56456700534");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(996905L, -258002L), 11).code, "XX03131786872", "x:996905,y:-258002,level:11: XX03131786872");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(494872L, 152342L), 11).code, "PZ16386410216", "x:494872,y:152342,level:11: PZ16386410216");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-279184L, 728966L), 11).code, "OI78178446320", "x:-279184,y:728966,level:11: OI78178446320");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-66947L, 872697L), 11).code, "RX13217487787", "x:-66947,y:872697,level:11: RX13217487787");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(329983L, 1039955L), 11).code, "SV40163034106", "x:329983,y:1039955,level:11: SV40163034106");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1040996L, 879073L), 11).code, "aX41314430862", "x:1040996,y:879073,level:11: aX41314430862");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1430906L, 359720L), 11).code, "ZA47238521110", "x:1430906,y:359720,level:11: ZA47238521110");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1877264L, 363145L), 11).code, "TK11857485652", "x:1877264,y:363145,level:11: TK11857485652");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(344996L, 1938562L), 11).code, "TK43222807032", "x:344996,y:1938562,level:11: TK43222807032");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(474714L, 2053467L), 11).code, "TO03574622544", "x:474714,y:2053467,level:11: TO03574622544");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2117055L, 590459L), 11).code, "TO54114446763", "x:2117055,y:590459,level:11: TO54114446763");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1771092L, 990230L), 11).code, "bb33540877533", "x:1771092,y:990230,level:11: bb33540877533");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5202625L, -3081467L), 12).code, "BV803254745602", "x:-5202625,y:-3081467,level:12: BV803254745602");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2538459L, -5745886L), 12).code, "CI803456424553", "x:-2538459,y:-5745886,level:12: CI803456424553");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1765975L, -6518875L), 12).code, "DO053652024200", "x:-1765975,y:-6518875,level:12: DO053652024200");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1764847L, -6519499L), 12).code, "DO053654462750", "x:-1764847,y:-6519499,level:12: DO053654462750");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-6510449L, -1773897L), 12).code, "DO071704644727", "x:-6510449,y:-1773897,level:12: DO071704644727");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-3322654L, -2958555L), 12).code, "CY281612610161", "x:-3322654,y:-2958555,level:12: CY281612610161");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-662939L, -5259073L), 12).code, "EU181655132036", "x:-662939,y:-5259073,level:12: EU181655132036");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5165165L, -400879L), 12).code, "EU832016181016", "x:-5165165,y:-400879,level:12: EU832016181016");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2988100L, -251200L), 12).code, "FY636801583240", "x:-2988100,y:-251200,level:12: FY636801583240");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-504717L, -2148863L), 12).code, "OK446658243285", "x:-504717,y:-2148863,level:12: OK446658243285");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2818165L, 1488147L), 12).code, "GH058068815001", "x:-2818165,y:1488147,level:12: GH058068815001");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2049862L, -2667944L), 12).code, "GI410587505268", "x:2049862,y:-2667944,level:12: GI410587505268");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2434352L, 2301680L), 12).code, "GI871735246286", "x:-2434352,y:2301680,level:12: GI871735246286");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2089558L, 2571740L), 12).code, "QU460311054340", "x:-2089558,y:2571740,level:12: QU460311054340");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2662212L, -2018226L), 12).code, "QU533828300764", "x:2662212,y:-2018226,level:12: QU533828300764");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-64051L, -194835L), 12).code, "OY313181386161", "x:-64051,y:-194835,level:12: OY313181386161");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(116433L, 106863L), 12).code, "OY803527038734", "x:116433,y:106863,level:12: OY803527038734");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-713146L, 874949L), 12).code, "PA043284261600", "x:-713146,y:874949,level:12: PA043284261600");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1465440L, 278811L), 12).code, "PZ060785824214", "x:1465440,y:278811,level:12: PZ060785824214");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2238819L, -1170915L), 12).code, "PS625060382624", "x:2238819,y:-1170915,level:12: PS625060382624");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2618653L, -1230371L), 12).code, "XM317558565378", "x:2618653,y:-1230371,level:12: XM317558565378");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2756276L, -1335633L), 12).code, "XL822458403751", "x:2756276,y:-1335633,level:12: XL822458403751");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2983628L, -818687L), 12).code, "XP251226173262", "x:2983628,y:-818687,level:12: XP251226173262");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-883827L, 2142667L), 12).code, "OI745463230145", "x:-883827,y:2142667,level:12: OI745463230145");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-319011L, 2548673L), 12).code, "RU681285781273", "x:-319011,y:2548673,level:12: RU681285781273");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1040076L, 3085916L), 12).code, "SV352321156833", "x:1040076,y:3085916,level:12: SV352321156833");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4180037L, 1078581L), 12).code, "ZA412658306821", "x:4180037,y:1078581,level:12: ZA412658306821");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3127660L, 2632548L), 12).code, "aX413323833627", "x:3127660,y:2632548,level:12: aX413323833627");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(2948131L, 4106506L), 12).code, "bD023073480358", "x:2948131,y:4106506,level:12: bD023073480358");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(5877682L, 1225497L), 12).code, "TK570232153327", "x:5877682,y:1225497,level:12: TK570232153327");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1166695L, 5949436L), 12).code, "TK800808780528", "x:1166695,y:5949436,level:12: TK800808780528");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(1555359L, 6272707L), 12).code, "TO328348003525", "x:1555359,y:6272707,level:12: TO328348003525");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6445333L, 1690161L), 12).code, "TO563763855337", "x:6445333,y:1690161,level:12: TO563763855337");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(5324313L, 2959905L), 12).code, "bb337212207184", "x:5324313,y:2959905,level:12: bb337212207184");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-15569096L, -9235399L), 13).code, "BV8046354823266", "x:-15569096,y:-9235399,level:13: BV8046354823266");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7851906L, -16904048L), 13).code, "CI5803560714155", "x:-7851906,y:-16904048,level:13: CI5803560714155");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5270104L, -19587483L), 13).code, "DO0482706175341", "x:-5270104,y:-19587483,level:13: DO0482706175341");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5269345L, -19586724L), 13).code, "DO0482731186381", "x:-5269345,y:-19586724,level:13: DO0482731186381");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5262019L, -19592534L), 13).code, "DO0485035421662", "x:-5262019,y:-19592534,level:13: DO0485035421662");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5260267L, -19594286L), 13).code, "DO0485060618642", "x:-5260267,y:-19594286,level:13: DO0485060618642");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5258750L, -19592769L), 13).code, "DO0485068654767", "x:-5258750,y:-19592769,level:13: DO0485068654767");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-19563852L, -5290701L), 13).code, "DO0712537663424", "x:-19563852,y:-5290701,level:13: DO0712537663424");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-19562875L, -5290161L), 13).code, "DO0712564265481", "x:-19562875,y:-5290161,level:13: DO0712564265481");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1680172L, -15818890L), 13).code, "EU4501241604860", "x:-1680172,y:-15818890,level:13: EU4501241604860");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-15456531L, -1119695L), 13).code, "EU8407181150325", "x:-15456531,y:-1119695,level:13: EU8407181150325");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-9713247L, -8732365L), 13).code, "CZ3061211527483", "x:-9713247,y:-8732365,level:13: CZ3061211527483");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7861861L, -98878L), 13).code, "Fb4625116215430", "x:-7861861,y:-98878,level:13: Fb4625116215430");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-1261187L, -6165599L), 13).code, "OK7250326542858", "x:-1261187,y:-6165599,level:13: OK7250326542858");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-8229818L, 5026106L), 13).code, "GH4221515066426", "x:-8229818,y:5026106,level:13: GH4221515066426");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6303463L, -7905318L), 13).code, "GI4421818162227", "x:6303463,y:-7905318,level:13: GI4421818162227");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7316322L, 6976535L), 13).code, "GI8724851414563", "x:-7316322,y:6976535,level:13: GI8724851414563");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-6491124L, 7801733L), 13).code, "QU4074815410453", "x:-6491124,y:7801733,level:13: QU4074815410453");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8602661L, -5690196L), 13).code, "QU8810462030471", "x:8602661,y:-5690196,level:13: QU8810462030471");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2181475L, 2666886L), 13).code, "PA0414822216031", "x:-2181475,y:2666886,level:13: PA0414822216031");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-150384L, 101843L), 13).code, "OY4236836048713", "x:-150384,y:101843,level:13: OY4236836048713");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(275804L, -226708L), 13).code, "OY7001555744550", "x:275804,y:-226708,level:13: OY7001555744550");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7760360L, -3197497L), 13).code, "XM4117607703260", "x:7760360,y:-3197497,level:13: XM4117607703260");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(6758494L, -3554783L), 13).code, "PS6246856326218", "x:6758494,y:-3554783,level:13: PS6246856326218");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8234352L, -4010723L), 13).code, "XL5887834871345", "x:8234352,y:-4010723,level:13: XL5887834871345");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(8936922L, -2383321L), 13).code, "XX0066438378463", "x:8936922,y:-2383321,level:13: XX0066438378463");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4793639L, 1710866L), 13).code, "PZ4537105130820", "x:4793639,y:1710866,level:13: PZ4537105130820");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2638423L, 6667888L), 13).code, "OI8337351073052", "x:-2638423,y:6667888,level:13: OI8337351073052");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-700265L, 7933441L), 13).code, "RX1135780670728", "x:-700265,y:7933441,level:13: RX1135780670728");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3077184L, 9494957L), 13).code, "SV4163853373183", "x:3077184,y:9494957,level:13: SV4163853373183");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(9394245L, 7740758L), 13).code, "aX4034808877353", "x:9394245,y:7740758,level:13: aX4034808877353");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12892169L, 3223472L), 13).code, "ZA4726354081160", "x:12892169,y:3223472,level:13: ZA4726354081160");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(9213213L, 12436112L), 13).code, "bD0853382488383", "x:9213213,y:12436112,level:13: bD0853382488383");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(17210925L, 3758825L), 13).code, "TK2756770452053", "x:17210925,y:3758825,level:13: TK2756770452053");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(3726038L, 17486416L), 13).code, "TK7434850466772", "x:3726038,y:17486416,level:13: TK7434850466772");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(4454198L, 18748996L), 13).code, "TO0846631354832", "x:4454198,y:18748996,level:13: TO0846631354832");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(19246478L, 4927538L), 13).code, "TO4805277813220", "x:19246478,y:4927538,level:13: TO4805277813220");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(15960982L, 8892006L), 13).code, "bb3356324634667", "x:15960982,y:8892006,level:13: bb3356324634667");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-46634477L, -27633385L), 14).code, "BV80717180121576", "x:-46634477,y:-27633385,level:14: BV80717180121576");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-23373283L, -51622694L), 14).code, "CI56436210413512", "x:-23373283,y:-51622694,level:14: CI56436210413512");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-23143585L, -51561147L), 14).code, "CI56773820550701", "x:-23143585,y:-51561147,level:14: CI56773820550701");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-22761121L, -51725175L), 14).code, "CI80611150250021", "x:-22761121,y:-51725175,level:14: CI80611150250021");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-16050458L, -58508650L), 14).code, "DO05167224507116", "x:-16050458,y:-58508650,level:14: DO05167224507116");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-15993033L, -58493263L), 14).code, "DO05405867244763", "x:-15993033,y:-58493263,level:14: DO05405867244763");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-58604953L, -15955292L), 14).code, "DO07170215584802", "x:-58604953,y:-15955292,level:14: DO07170215584802");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-58604669L, -15955008L), 14).code, "DO07170226100057", "x:-58604669,y:-15955008,level:14: DO07170226100057");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-58604100L, -15954439L), 14).code, "DO07170227640163", "x:-58604100,y:-15954439,level:14: DO07170227640163");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5783264L, -48388588L), 14).code, "EU16473602511456", "x:-5783264,y:-48388588,level:14: EU16473602511456");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-48128884L, -5516832L), 14).code, "EU40673078217161", "x:-48128884,y:-5516832,level:14: EU40673078217161");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-29081213L, -25381885L), 14).code, "CZ31831222362536", "x:-29081213,y:-25381885,level:14: CZ31831222362536");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-24708530L, -1503657L), 14).code, "Fb31200035818717", "x:-24708530,y:-1503657,level:14: Fb31200035818717");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4962845L, -18975728L), 14).code, "OK44243402806508", "x:-4962845,y:-18975728,level:14: OK44243402806508");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2083782L, -1411177L), 14).code, "OY01571576207503", "x:-2083782,y:-1411177,level:14: OY01571576207503");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(705574L, 985547L), 14).code, "OY56733420402656", "x:705574,y:985547,level:14: OY56733420402656");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-22434502L, 15735833L), 14).code, "GH84065825033010", "x:-22434502,y:15735833,level:14: GH84065825033010");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(18582317L, -23007372L), 14).code, "GI50342481388451", "x:18582317,y:-23007372,level:14: GI50342481388451");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-21931681L, 19545350L), 14).code, "GI78081171860100", "x:-21931681,y:19545350,level:14: GI78081171860100");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-19685784L, 21959398L), 14).code, "QU30541311610415", "x:-19685784,y:21959398,level:14: QU30541311610415");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(24060489L, -18874410L), 14).code, "QU44828780263624", "x:24060489,y:-18874410,level:14: QU44828780263624");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-5813291L, 8143263L), 14).code, "PA07571045254517", "x:-5813291,y:8143263,level:14: PA07571045254517");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(19731995L, -10759711L), 14).code, "PS38383877824230", "x:19731995,y:-10759711,level:14: PS38383877824230");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(23435741L, -11259746L), 14).code, "XM31385143063872", "x:23435741,y:-11259746,level:14: XM31385143063872");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(24988122L, -12229634L), 14).code, "XL82447011727335", "x:24988122,y:-12229634,level:14: XL82447011727335");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(26510321L, -7344410L), 14).code, "XP22503400845082", "x:26510321,y:-7344410,level:14: XP22503400845082");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(12711478L, 4472067L), 14).code, "PZ13526267300787", "x:12711478,y:4472067,level:14: PZ13526267300787");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-7420014L, 19596009L), 14).code, "OI78437338044154", "x:-7420014,y:19596009,level:14: OI78437338044154");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-2440259L, 23062403L), 14).code, "RU68880348017456", "x:-2440259,y:23062403,level:14: RU68880348017456");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(7884118L, 28174091L), 14).code, "SV13411223332736", "x:7884118,y:28174091,level:14: SV13411223332736");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(29009196L, 23067573L), 14).code, "aX38226176387034", "x:29009196,y:23067573,level:14: aX38226176387034");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(38012956L, 8586487L), 14).code, "ZA35122807551718", "x:38012956,y:8586487,level:14: ZA35122807551718");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(28370772L, 37450940L), 14).code, "bD32858648748733", "x:28370772,y:37450940,level:14: bD32858648748733");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(51806962L, 9937300L), 14).code, "TK18678460283758", "x:51806962,y:9937300,level:14: TK18678460283758");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(9393826L, 51767942L), 14).code, "TK35253726505866", "x:9393826,y:51767942,level:14: TK35253726505866");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(14221907L, 56203392L), 14).code, "TO35083224064751", "x:14221907,y:56203392,level:14: TO35083224064751");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(57301611L, 14871166L), 14).code, "TO45177603556405", "x:57301611,y:14871166,level:14: TO45177603556405");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(47885698L, 26668610L), 14).code, "bb33563401287846", "x:47885698,y:26668610,level:14: bb33563401287846");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(47886086L, 26673021L), 14).code, "bb33563422636071", "x:47886086,y:26673021,level:14: bb33563422636071");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-140651359L, -83080573L), 15).code, "BV801644720107680", "x:-140651359,y:-83080573,level:15: BV801644720107680");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-140624055L, -83053269L), 15).code, "BV801672224571144", "x:-140624055,y:-83053269,level:15: BV801672224571144");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-139339840L, -84228266L), 15).code, "BV752066087034602", "x:-139339840,y:-84228266,level:15: BV752066087034602");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-70356394L, -151573450L), 15).code, "CI584051202811030", "x:-70356394,y:-151573450,level:15: CI584051202811030");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-47733624L, -175943700L), 15).code, "DO053702425073344", "x:-47733624,y:-175943700,level:15: DO053702425073344");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-47762328L, -175913289L), 15).code, "DO053474671871414", "x:-47762328,y:-175913289,level:15: DO053474671871414");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-176219573L, -47457750L), 15).code, "DO048672464801367", "x:-176219573,y:-47457750,level:15: DO048672464801367");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-176213803L, -47436216L), 15).code, "DO048680771383421", "x:-176213803,y:-47436216,level:15: DO048680771383421");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-88184962L, -76078072L), 15).code, "CZ312460160330640", "x:-88184962,y:-76078072,level:15: CZ312460160330640");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-13260322L, -141391577L), 15).code, "EU482446631807432", "x:-13260322,y:-141391577,level:15: EU482446631807432");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-143735832L, -14847896L), 15).code, "EU443120677000135", "x:-143735832,y:-14847896,level:15: EU443120677000135");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-12350539L, -56238016L), 15).code, "OK486263022716030", "x:-12350539,y:-56238016,level:15: OK486263022716030");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-70304192L, 2589377L), 15).code, "Fb563137601173436", "x:-70304192,y:2589377,level:15: Fb563137601173436");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-73235041L, 41780417L), 15).code, "GH405610617770460", "x:-73235041,y:41780417,level:15: GH405610617770460");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(56344474L, -69627534L), 15).code, "GI428447007470857", "x:56344474,y:-69627534,level:15: GI428447007470857");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-68298452L, 57199740L), 15).code, "GI714676472576137", "x:-68298452,y:57199740,level:15: GI714676472576137");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-57730310L, 69785697L), 15).code, "QU430846555413857", "x:-57730310,y:69785697,level:15: QU430846555413857");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(71998221L, -55124127L), 15).code, "QU455868523435074", "x:71998221,y:-55124127,level:15: QU455868523435074");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(70399589L, -33265659L), 15).code, "XM314886135481601", "x:70399589,y:-33265659,level:15: XM314886135481601");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(60481900L, -32085365L), 15).code, "PS624076167125758", "x:60481900,y:-32085365,level:15: PS624076167125758");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(75593945L, -35906546L), 15).code, "XL828827023882162", "x:75593945,y:-35906546,level:15: XL828827023882162");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(80664997L, -21755327L), 15).code, "XP252183615213788", "x:80664997,y:-21755327,level:15: XP252183615213788");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-344548L, -92321L), 15).code, "OY441655876848342", "x:-344548,y:-92321,level:15: OY441655876848342");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-471694L, 1277684L), 15).code, "OY450583438341310", "x:-471694,y:1277684,level:15: OY450583438341310");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-20439432L, 22186911L), 15).code, "PA007023204648554", "x:-20439432,y:22186911,level:15: PA007023204648554");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-23916187L, 58798020L), 15).code, "OI754343508378851", "x:-23916187,y:58798020,level:15: OI754343508378851");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(-4893211L, 73044895L), 15).code, "RX153284780083552", "x:-4893211,y:73044895,level:15: RX153284780083552");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(42527869L, 19070769L), 15).code, "PZ541437131806627", "x:42527869,y:19070769,level:15: PZ541437131806627");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(24728891L, 82741073L), 15).code, "SV081012647253500", "x:24728891,y:82741073,level:15: SV081012647253500");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(111331956L, 27592632L), 15).code, "ZA162768706170274", "x:111331956,y:27592632,level:15: ZA162768706170274");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(86840561L, 75238125L), 15).code, "aX538661552510561", "x:86840561,y:75238125,level:15: aX538661552510561");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(87699744L, 115444701L), 15).code, "bD475537206875044", "x:87699744,y:115444701,level:15: bD475537206875044");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(159294183L, 32928516L), 15).code, "TK573170435224014", "x:159294183,y:32928516,level:15: TK573170435224014");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(31205775L, 158832577L), 15).code, "TK720137660817775", "x:31205775,y:158832577,level:15: TK720137660817775");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(40572705L, 168183297L), 15).code, "TO078855632751174", "x:40572705,y:168183297,level:15: TO078855632751174");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(43529418L, 172653371L), 15).code, "TO448407012467243", "x:43529418,y:172653371,level:15: TO448407012467243");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(174694024L, 46294332L), 15).code, "TO801157747467437", "x:174694024,y:46294332,level:15: TO801157747467437");
  str_is(geohex_get_zone_by_coordinate(geohex_coordinate(143901099L, 79776171L), 15).code, "bb337184418811744", "x:143901099,y:79776171,level:15: bb337184418811744");
}

void code2hex (void) {
  // verify
  ok(geohex_verify_code("XM") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EX2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aZ2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI76") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU06") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU13") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH32") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK51") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL60") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ18") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU88") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb17") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb34") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb86") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK63") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO42") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK02") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD31") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE73") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO84") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB61") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YF58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX15") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO045") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO056") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO077") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV778") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU570") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU868") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK468") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY443") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY004") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb526") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI440") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU026") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU630") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ580") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY864") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV385") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX355") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD744") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO808") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO474") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO073") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB648") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG168") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7541") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0532") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO3203") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU6235") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7172") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ0737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb0200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb8608") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI2651") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC2121") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7871") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4212") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4362") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OX2538") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY5663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OG6663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV8518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3246") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1825") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TR1202") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4054") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA5685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4881") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6270") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80373") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO08354") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU31135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU45042") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ35087") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK06445") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb80457") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH80422") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI74753") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI80240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU01265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU86344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY77334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY15454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04170") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS68342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM78145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM48257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03156") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ47685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40654") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI71873") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX40264") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA44552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD47117") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK51615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK71615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO38458") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO58484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV553581") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI802417") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI750110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO018862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053505") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO074664") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ351822") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU412420") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU708101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK847038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH501658") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI842644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI836575") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU316588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU175485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb711277") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY728344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA016372") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU408880") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM442337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS387785") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX037037") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ173676") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV321726") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC828583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI713375") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD080050") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX817100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA712478") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK166315") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK873482") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO433402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO586342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb335332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8032788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7714524") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0514686") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0517300") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732687") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732768") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4031833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8072131") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8255485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3800810") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1624776") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7464515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb5316746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4033527") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4540858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4351804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8387484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0706771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4884047") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8251271") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0565644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY8320288") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3556486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ8016814") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1746604") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6242083") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM5643552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6303820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM7851800") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0345653") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6306347") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8827707") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4253332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8776718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PF2148656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4587731") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4335020") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV5843218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0682573") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8100870") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4424804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE6100113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK5027217") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7070414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO6240542") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO7775738") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO5821675") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3371862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV54870250") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV78253862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57758513") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI75600226") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05603615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07152160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU41063674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU72201265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34762511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb38241503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK48511367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI32042116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI71565064") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH45442518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY33228746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA03278283") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU42174351") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU47122108") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM32230826") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56301016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS61272751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60832123") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU63124187") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03173236") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38755703") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ57757416") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fc51504013") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OW22586402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC52458806") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV20852101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX46486040") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA62754057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD28367162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK05722747") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK83151057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO31130720") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO51331450") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33488116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV804240512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI708565326") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI754848748") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO055580431") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053480025") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO073506567") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ347013544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU413474586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU354580674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK474555348") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb484868583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH147081657") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI730641802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI576514101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY041035522") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY537117080") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA402570238") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU058877078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU832828267") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ382714446") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ028668414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS383657231") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM602176827") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM482452815") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX033123366") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI860616105") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX114077466") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV355072242") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG413103084") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA486483578") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX426174078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX747576237") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK184816376") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO310523631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO423806423") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb303856635") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO815178640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV1700305142") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV5482764471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7560068257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5263615540") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7265571616") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7505181555") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5736546251") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0273028158") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0536546500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0716764500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4016113514") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4827777232") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU7445272188") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1777354303") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3420476772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4334484641") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH5856584625") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1730824803") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI7234521114") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU3851424320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8152020110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0426257051") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4244664644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7353226324") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3444432334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8136543688") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8831183154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6206841033") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM0565771230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4863207510") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0330807788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6054354111") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1548687734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ7555070851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI7581576564") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1535370770") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV7031782060") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6431665682") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX1617612856") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX7255422107") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA7323011017") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK0130411728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK8071386820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4434206021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3372146218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV57264048634") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57246068382") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05443747884") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07200264504") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34837816828") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU18781747622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU47467037811") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb05827021141") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK72311284586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH51383310718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47416263465") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI87045185255") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU07002763476") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU85663663436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU84201138888") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62147032100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM30178015132") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60054311737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM44560457183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56456700534") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03131786872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ16386410216") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78178446320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX13217487787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40163034106") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX41314430862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA47238521110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK11857485652") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK43222807032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO03574622544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO54114446763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33540877533") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV803254745602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI803456424553") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053652024200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053654462750") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO071704644727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CY281612610161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU181655132036") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU832016181016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("FY636801583240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK446658243285") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH058068815001") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI410587505268") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI871735246286") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU460311054340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU533828300764") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY313181386161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY803527038734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA043284261600") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ060785824214") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS625060382624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM317558565378") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL822458403751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP251226173262") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI745463230145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU681285781273") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV352321156833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA412658306821") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX413323833627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD023073480358") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK570232153327") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK800808780528") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO328348003525") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO563763855337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337212207184") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8046354823266") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5803560714155") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482706175341") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482731186381") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485035421662") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485060618642") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485068654767") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712537663424") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712564265481") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4501241604860") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8407181150325") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3061211527483") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4625116215430") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7250326542858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4221515066426") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4421818162227") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8724851414563") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4074815410453") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8810462030471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0414822216031") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4236836048713") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7001555744550") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4117607703260") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6246856326218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL5887834871345") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0066438378463") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4537105130820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8337351073052") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1135780670728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4163853373183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4034808877353") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4726354081160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD0853382488383") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK2756770452053") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7434850466772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO0846631354832") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4805277813220") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3356324634667") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80717180121576") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56436210413512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56773820550701") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI80611150250021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05167224507116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05405867244763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170215584802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170226100057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170227640163") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU16473602511456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU40673078217161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ31831222362536") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb31200035818717") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK44243402806508") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY01571576207503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY56733420402656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH84065825033010") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI50342481388451") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI78081171860100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU30541311610415") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU44828780263624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA07571045254517") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS38383877824230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM31385143063872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL82447011727335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP22503400845082") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ13526267300787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78437338044154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU68880348017456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV13411223332736") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX38226176387034") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA35122807551718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD32858648748733") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK18678460283758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK35253726505866") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO35083224064751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO45177603556405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563401287846") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563422636071") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801644720107680") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801672224571144") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV752066087034602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI584051202811030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053702425073344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053474671871414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048672464801367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048680771383421") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ312460160330640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU482446631807432") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU443120677000135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK486263022716030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb563137601173436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH405610617770460") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI428447007470857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI714676472576137") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU430846555413857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU455868523435074") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM314886135481601") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624076167125758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL828827023882162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP252183615213788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY441655876848342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY450583438341310") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA007023204648554") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI754343508378851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX153284780083552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ541437131806627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV081012647253500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA162768706170274") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX538661552510561") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD475537206875044") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK573170435224014") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK720137660817775") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO078855632751174") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO448407012467243") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO801157747467437") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337184418811744") == GEOHEX3_VERIFY_RESULT_SUCCESS);

  // code2hex
  location_is(geohex_get_zone_by_code("XM").location, geohex_location(32.7050565948485L, 140.0L), "XM: lat:32.7050565948485,lng:140");
  location_is(geohex_get_zone_by_code("OY").location, geohex_location(0.0L, 0.0L), "OY: lat:0,lng:0");
  location_is(geohex_get_zone_by_code("GI").location, geohex_location(-11.4696249513643L, -180.0L), "GI: lat:-11.4696249513643,lng:-180");
  location_is(geohex_get_zone_by_code("QU").location, geohex_location(11.4696249513643L, -180.0L), "QU: lat:11.4696249513643,lng:-180");
  location_is(geohex_get_zone_by_code("GH").location, geohex_location(-22.4929492879726L, -160.0L), "GH: lat:-22.4929492879726,lng:-160");
  location_is(geohex_get_zone_by_code("EU").location, geohex_location(-77.564295156692L, -180.0L), "EU: lat:-77.564295156692,lng:-180");
  location_is(geohex_get_zone_by_code("CI").location, geohex_location(-85.4445925866875L, 120.0L), "CI: lat:-85.4445925866875,lng:120");
  location_is(geohex_get_zone_by_code("BV").location, geohex_location(-85.4445925866875L, -80.0L), "BV: lat:-85.4445925866875,lng:-80");
  location_is(geohex_get_zone_by_code("Fb").location, geohex_location(-49.8887630323615L, -100.0L), "Fb: lat:-49.8887630323615,lng:-100");
  location_is(geohex_get_zone_by_code("SV").location, geohex_location(67.4423781033328L, -80.0L), "SV: lat:67.4423781033328,lng:-80");
  location_is(geohex_get_zone_by_code("TO").location, geohex_location(84.4289312717818L, -180.0L), "TO: lat:84.4289312717818,lng:-180");
  location_is(geohex_get_zone_by_code("TK").location, geohex_location(81.6715381665136L, -180.0L), "TK: lat:81.6715381665136,lng:-180");
  location_is(geohex_get_zone_by_code("bD").location, geohex_location(83.1877023714706L, -40.0L), "bD: lat:83.1877023714706,lng:-40");
  location_is(geohex_get_zone_by_code("ZA").location, geohex_location(74.8171611748047L, 120.0L), "ZA: lat:74.8171611748047,lng:120");
  location_is(geohex_get_zone_by_code("aX").location, geohex_location(77.564295156692L, 20.0L), "aX: lat:77.564295156692,lng:20");
  location_is(geohex_get_zone_by_code("PZ").location, geohex_location(41.8706764000141L, 40.0L), "PZ: lat:41.8706764000141,lng:40");
  location_is(geohex_get_zone_by_code("OK").location, geohex_location(-49.8887630323615L, 60.0L), "OK: lat:-49.8887630323615,lng:60");
  location_is(geohex_get_zone_by_code("CZ3").location, geohex_location(-78.3665252517046L, -13.3333333333333L), "CZ3: lat:-78.3665252517046,lng:-13.3333333333333");
  location_is(geohex_get_zone_by_code("CI8").location, geohex_location(-84.7903734685558L, 120.0L), "CI8: lat:-84.7903734685558,lng:120");
  location_is(geohex_get_zone_by_code("DO0").location, geohex_location(-85.1284264049787L, -180.0L), "DO0: lat:-85.1284264049787,lng:-180");
  location_is(geohex_get_zone_by_code("EX2").location, geohex_location(-74.8171611748047L, -173.333333333333L), "EX2: lat:-74.8171611748047,lng:-173.333333333333");
  location_is(geohex_get_zone_by_code("EU1").location, geohex_location(-78.3665252517046L, 173.333333333333L), "EU1: lat:-78.3665252517046,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("OK4").location, geohex_location(-49.8887630323615L, 60.0L), "OK4: lat:-49.8887630323615,lng:60");
  location_is(geohex_get_zone_by_code("GI3").location, geohex_location(-15.2140034644785L, -173.333333333333L), "GI3: lat:-15.2140034644785,lng:-173.333333333333");
  location_is(geohex_get_zone_by_code("GI1").location, geohex_location(-15.2140034644785L, 173.333333333333L), "GI1: lat:-15.2140034644785,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("QU0").location, geohex_location(3.8461100614417L, -180.0L), "QU0: lat:3.8461100614417,lng:-180");
  location_is(geohex_get_zone_by_code("QU7").location, geohex_location(15.2140034644785L, -173.333333333333L), "QU7: lat:15.2140034644785,lng:-173.333333333333");
  location_is(geohex_get_zone_by_code("GH8").location, geohex_location(-15.2140034644785L, -160.0L), "GH8: lat:-15.2140034644785,lng:-160");
  location_is(geohex_get_zone_by_code("OY0").location, geohex_location(-7.67494760129784L, 0.0L), "OY0: lat:-7.67494760129784,lng:0");
  location_is(geohex_get_zone_by_code("Fb3").location, geohex_location(-52.3052216727475L, -93.3333333333333L), "Fb3: lat:-52.3052216727475,lng:-93.3333333333333");
  location_is(geohex_get_zone_by_code("XM4").location, geohex_location(32.7050565948485L, 140.0L), "XM4: lat:32.7050565948485,lng:140");
  location_is(geohex_get_zone_by_code("PZ0").location, geohex_location(35.8841275913257L, 40.0L), "PZ0: lat:35.8841275913257,lng:40");
  location_is(geohex_get_zone_by_code("SW6").location, geohex_location(71.4806668681882L, -86.6666666666667L), "SW6: lat:71.4806668681882,lng:-86.6666666666667");
  location_is(geohex_get_zone_by_code("SV3").location, geohex_location(65.9192675132544L, -73.3333333333333L), "SV3: lat:65.9192675132544,lng:-73.3333333333333");
  location_is(geohex_get_zone_by_code("aX0").location, geohex_location(75.7931846054884L, 20.0L), "aX0: lat:75.7931846054884,lng:20");
  location_is(geohex_get_zone_by_code("aX8").location, geohex_location(79.1176717673541L, 20.0L), "aX8: lat:79.1176717673541,lng:20");
  location_is(geohex_get_zone_by_code("aZ2").location, geohex_location(81.6715381665137L, -33.3333333333333L), "aZ2: lat:81.6715381665137,lng:-33.3333333333333");
  location_is(geohex_get_zone_by_code("TO4").location, geohex_location(84.4289312717818L, -180.0L), "TO4: lat:84.4289312717818,lng:-180");
  location_is(geohex_get_zone_by_code("aB6").location, geohex_location(83.1877023714706L, 173.333333333333L), "aB6: lat:83.1877023714706,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("TK1").location, geohex_location(81.0950821454213L, 173.333333333333L), "TK1: lat:81.0950821454213,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("TK3").location, geohex_location(81.0950821454213L, -173.333333333333L), "TK3: lat:81.0950821454213,lng:-173.333333333333");
  location_is(geohex_get_zone_by_code("ZA4").location, geohex_location(74.8171611748047L, 120.0L), "ZA4: lat:74.8171611748047,lng:120");
  location_is(geohex_get_zone_by_code("PA0").location, geohex_location(3.84611006144169L, -60.0L), "PA0: lat:3.84611006144169,lng:-60");
  location_is(geohex_get_zone_by_code("BV8").location, geohex_location(-84.7903734685558L, -80.0L), "BV8: lat:-84.7903734685558,lng:-80");
  location_is(geohex_get_zone_by_code("CI76").location, geohex_location(-85.1284264049787L, 131.111111111111L), "CI76: lat:-85.1284264049787,lng:131.111111111111");
  location_is(geohex_get_zone_by_code("CI55").location, geohex_location(-85.0182461528016L, 111.111111111111L), "CI55: lat:-85.0182461528016,lng:111.111111111111");
  location_is(geohex_get_zone_by_code("DO07").location, geohex_location(-85.0182461528016L, -177.777777777778L), "DO07: lat:-85.0182461528016,lng:-177.777777777778");
  location_is(geohex_get_zone_by_code("DO05").location, geohex_location(-85.0182461528016L, 177.777777777778L), "DO05: lat:-85.0182461528016,lng:177.777777777778");
  location_is(geohex_get_zone_by_code("EU06").location, geohex_location(-79.117671767354L, -175.555555555556L), "EU06: lat:-79.117671767354,lng:-175.555555555556");
  location_is(geohex_get_zone_by_code("EU13").location, geohex_location(-78.6224251800772L, 175.555555555556L), "EU13: lat:-78.6224251800772,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("GH32").location, geohex_location(-26.0016268633643L, -157.777777777778L), "GH32: lat:-26.0016268633643,lng:-157.777777777778");
  location_is(geohex_get_zone_by_code("OK51").location, geohex_location(-48.2071571029478L, 51.1111111111111L), "OK51: lat:-48.2071571029478,lng:51.1111111111111");
  location_is(geohex_get_zone_by_code("GI47").location, geohex_location(-10.2095434727833L, -177.777777777778L), "GI47: lat:-10.2095434727833,lng:-177.777777777778");
  location_is(geohex_get_zone_by_code("GI53").location, geohex_location(-8.94445133154766L, 175.555555555556L), "GI53: lat:-8.94445133154766,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("QU08").location, geohex_location(6.40164208700373L, -180.0L), "QU08: lat:6.40164208700373,lng:-180");
  location_is(geohex_get_zone_by_code("OC58").location, geohex_location(6.40164208700372L, -166.666666666667L), "OC58: lat:6.40164208700372,lng:-166.666666666667");
  location_is(geohex_get_zone_by_code("XL60").location, geohex_location(20.1024169233546L, 173.333333333333L), "XL60: lat:20.1024169233546,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("XM56").location, geohex_location(35.8841275913258L, 137.777777777778L), "XM56: lat:35.8841275913258,lng:137.777777777778");
  location_is(geohex_get_zone_by_code("PS62").location, geohex_location(22.4929492879726L, 128.888888888889L), "PS62: lat:22.4929492879726,lng:128.888888888889");
  location_is(geohex_get_zone_by_code("XX03").location, geohex_location(43.7528403384023L, 142.222222222222L), "XX03: lat:43.7528403384023,lng:142.222222222222");
  location_is(geohex_get_zone_by_code("PZ38").location, geohex_location(40.9081556333403L, 46.6666666666667L), "PZ38: lat:40.9081556333403,lng:46.6666666666667");
  location_is(geohex_get_zone_by_code("PZ04").location, geohex_location(35.8841275913257L, 40.0L), "PZ04: lat:35.8841275913257,lng:40");
  location_is(geohex_get_zone_by_code("PZ18").location, geohex_location(40.9081556333403L, 33.3333333333333L), "PZ18: lat:40.9081556333403,lng:33.3333333333333");
  location_is(geohex_get_zone_by_code("OU88").location, geohex_location(-12.724108773261L, 0.0L), "OU88: lat:-12.724108773261,lng:0");
  location_is(geohex_get_zone_by_code("OY53").location, geohex_location(2.5651438499496L, -4.44444444444444L), "OY53: lat:2.5651438499496,lng:-4.44444444444444");
  location_is(geohex_get_zone_by_code("PA04").location, geohex_location(3.8461100614417L, -60.0L), "PA04: lat:3.8461100614417,lng:-60");
  location_is(geohex_get_zone_by_code("Fb17").location, geohex_location(-51.5137582931173L, -104.444444444444L), "Fb17: lat:-51.5137582931173,lng:-104.444444444444");
  location_is(geohex_get_zone_by_code("Fb34").location, geohex_location(-52.3052216727475L, -93.3333333333333L), "Fb34: lat:-52.3052216727475,lng:-93.3333333333333");
  location_is(geohex_get_zone_by_code("Fb86").location, geohex_location(-44.6724113934194L, -95.5555555555556L), "Fb86: lat:-44.6724113934194,lng:-95.5555555555556");
  location_is(geohex_get_zone_by_code("GH58").location, geohex_location(-16.4483118659619L, -166.666666666667L), "GH58: lat:-16.4483118659619,lng:-166.666666666667");
  location_is(geohex_get_zone_by_code("TK63").location, geohex_location(81.4836247115026L, -164.444444444444L), "TK63: lat:81.4836247115026,lng:-164.444444444444");
  location_is(geohex_get_zone_by_code("TO07").location, geohex_location(83.7701501008722L, -177.777777777778L), "TO07: lat:83.7701501008722,lng:-177.777777777778");
  location_is(geohex_get_zone_by_code("TO42").location, geohex_location(84.4289312717818L, 175.555555555556L), "TO42: lat:84.4289312717818,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("TK02").location, geohex_location(80.4790708574883L, 175.555555555556L), "TK02: lat:80.4790708574883,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("bD31").location, geohex_location(82.5510811105676L, -35.5555555555555L), "bD31: lat:82.5510811105676,lng:-35.5555555555555");
  location_is(geohex_get_zone_by_code("bE73").location, geohex_location(84.672568573839L, -51.1111111111111L), "bE73: lat:84.672568573839,lng:-51.1111111111111");
  location_is(geohex_get_zone_by_code("bb33").location, geohex_location(85.0182461528016L, 88.8888888888889L), "bb33: lat:85.0182461528016,lng:88.8888888888889");
  location_is(geohex_get_zone_by_code("TO84").location, geohex_location(85.1284264049787L, -180.0L), "TO84: lat:85.1284264049787,lng:-180");
  location_is(geohex_get_zone_by_code("TO47").location, geohex_location(84.5521076214116L, -177.777777777778L), "TO47: lat:84.5521076214116,lng:-177.777777777778");
  location_is(geohex_get_zone_by_code("aB61").location, geohex_location(83.0338122616632L, 171.111111111111L), "aB61: lat:83.0338122616632,lng:171.111111111111");
  location_is(geohex_get_zone_by_code("ZA08").location, geohex_location(73.4134223884459L, 120.0L), "ZA08: lat:73.4134223884459,lng:120");
  location_is(geohex_get_zone_by_code("aX55").location, geohex_location(78.6224251800772L, 11.1111111111111L), "aX55: lat:78.6224251800772,lng:11.1111111111111");
  location_is(geohex_get_zone_by_code("aX04").location, geohex_location(75.7931846054884L, 20.0L), "aX04: lat:75.7931846054884,lng:20");
  location_is(geohex_get_zone_by_code("YF58").location, geohex_location(76.4094526930952L, 33.3333333333333L), "YF58: lat:76.4094526930952,lng:33.3333333333333");
  location_is(geohex_get_zone_by_code("SV40").location, geohex_location(66.4374399424699L, -80.0L), "SV40: lat:66.4374399424699,lng:-80");
  location_is(geohex_get_zone_by_code("RX15").location, geohex_location(48.2071571029478L, -108.888888888889L), "RX15: lat:48.2071571029478,lng:-108.888888888889");
  location_is(geohex_get_zone_by_code("OU40").location, geohex_location(-24.8428896902851L, 0.0L), "OU40: lat:-24.8428896902851,lng:0");
  location_is(geohex_get_zone_by_code("BV56").location, geohex_location(-85.1284264049787L, -82.2222222222222L), "BV56: lat:-85.1284264049787,lng:-82.2222222222222");
  location_is(geohex_get_zone_by_code("CI771").location, geohex_location(-85.055246359875L, 128.148148148148L), "CI771: lat:-85.055246359875,lng:128.148148148148");
  location_is(geohex_get_zone_by_code("DO045").location, geohex_location(-85.0919724386031L, 179.259259259259L), "DO045: lat:-85.0919724386031,lng:179.259259259259");
  location_is(geohex_get_zone_by_code("DO056").location, geohex_location(-85.0182461528016L, 179.259259259259L), "DO056: lat:-85.0182461528016,lng:179.259259259259");
  location_is(geohex_get_zone_by_code("DO077").location, geohex_location(-84.9809697867981L, -177.037037037037L), "DO077: lat:-84.9809697867981,lng:-177.037037037037");
  location_is(geohex_get_zone_by_code("BV778").location, geohex_location(-84.9434152165899L, -71.1111111111111L), "BV778: lat:-84.9434152165899,lng:-71.1111111111111");
  location_is(geohex_get_zone_by_code("BV568").location, geohex_location(-85.055246359875L, -82.2222222222222L), "BV568: lat:-85.055246359875,lng:-82.2222222222222");
  location_is(geohex_get_zone_by_code("CZ335").location, geohex_location(-78.5377483715364L, -11.8518518518519L), "CZ335: lat:-78.5377483715364,lng:-11.8518518518519");
  location_is(geohex_get_zone_by_code("EU570").location, geohex_location(-76.6089889314605L, 175.555555555556L), "EU570: lat:-76.6089889314605,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("EU868").location, geohex_location(-75.5817404649569L, -175.555555555556L), "EU868: lat:-75.5817404649569,lng:-175.555555555556");
  location_is(geohex_get_zone_by_code("OK468").location, geohex_location(-49.3345448501638L, 64.4444444444445L), "OK468: lat:-49.3345448501638,lng:64.4444444444445");
  location_is(geohex_get_zone_by_code("OY443").location, geohex_location(-0.427662894935065L, 0.740740740740741L), "OY443: lat:-0.427662894935065,lng:0.740740740740741");
  location_is(geohex_get_zone_by_code("OY004").location, geohex_location(-10.2095434727833L, 0.0L), "OY004: lat:-10.2095434727833,lng:0");
  location_is(geohex_get_zone_by_code("Fb526").location, geohex_location(-47.3449700820465L, -109.62962962963L), "Fb526: lat:-47.3449700820465,lng:-109.62962962963");
  location_is(geohex_get_zone_by_code("GH588").location, geohex_location(-15.6262741560122L, -166.666666666667L), "GH588: lat:-15.6262741560122,lng:-166.666666666667");
  location_is(geohex_get_zone_by_code("GI440").location, geohex_location(-12.3066051591638L, -180.0L), "GI440: lat:-12.3066051591638,lng:-180");
  location_is(geohex_get_zone_by_code("GI622").location, geohex_location(-11.4696249513643L, -172.592592592593L), "GI622: lat:-11.4696249513643,lng:-172.592592592593");
  location_is(geohex_get_zone_by_code("QU340").location, geohex_location(6.82646163717905L, -173.333333333333L), "QU340: lat:6.82646163717905,lng:-173.333333333333");
  location_is(geohex_get_zone_by_code("QU026").location, geohex_location(3.84611006144169L, 177.037037037037L), "QU026: lat:3.84611006144169,lng:177.037037037037");
  location_is(geohex_get_zone_by_code("XM454").location, geohex_location(33.7780865480893L, 137.777777777778L), "XM454: lat:33.7780865480893,lng:137.777777777778");
  location_is(geohex_get_zone_by_code("PS624").location, geohex_location(22.4929492879726L, 128.888888888889L), "PS624: lat:22.4929492879726,lng:128.888888888889");
  location_is(geohex_get_zone_by_code("XX038").location, geohex_location(44.3674832423129L, 142.222222222222L), "XX038: lat:44.3674832423129,lng:142.222222222222");
  location_is(geohex_get_zone_by_code("XU630").location, geohex_location(40.2585722649131L, 135.555555555556L), "XU630: lat:40.2585722649131,lng:135.555555555556");
  location_is(geohex_get_zone_by_code("PZ342").location, geohex_location(38.9405407349711L, 45.1851851851852L), "PZ342: lat:38.9405407349711,lng:45.1851851851852");
  location_is(geohex_get_zone_by_code("PZ580").location, geohex_location(45.8761640952879L, 33.3333333333333L), "PZ580: lat:45.8761640952879,lng:33.3333333333333");
  location_is(geohex_get_zone_by_code("OY864").location, geohex_location(7.67494760129786L, 4.44444444444444L), "OY864: lat:7.67494760129786,lng:4.44444444444444");
  location_is(geohex_get_zone_by_code("OY145").location, geohex_location(-3.41930349159571L, -7.40740740740741L), "OY145: lat:-3.41930349159571,lng:-7.40740740740741");
  location_is(geohex_get_zone_by_code("PA032").location, geohex_location(2.56514384994961L, -59.2592592592593L), "PA032: lat:2.56514384994961,lng:-59.2592592592593");
  location_is(geohex_get_zone_by_code("OI758").location, geohex_location(27.9075323430044L, -115.555555555556L), "OI758: lat:27.9075323430044,lng:-115.555555555556");
  location_is(geohex_get_zone_by_code("SV428").location, geohex_location(67.7682415504757L, -84.4444444444445L), "SV428: lat:67.7682415504757,lng:-84.4444444444445");
  location_is(geohex_get_zone_by_code("SV385").location, geohex_location(67.1119911384732L, -74.0740740740741L), "SV385: lat:67.1119911384732,lng:-74.0740740740741");
  location_is(geohex_get_zone_by_code("aX355").location, geohex_location(77.0953290532401L, 23.7037037037037L), "aX355: lat:77.0953290532401,lng:23.7037037037037");
  location_is(geohex_get_zone_by_code("aX568").location, geohex_location(78.5377483715365L, 17.7777777777778L), "aX568: lat:78.5377483715365,lng:17.7777777777778");
  location_is(geohex_get_zone_by_code("bD744").location, geohex_location(83.6293613243906L, -33.3333333333333L), "bD744: lat:83.6293613243906,lng:-33.3333333333333");
  location_is(geohex_get_zone_by_code("bD515").location, geohex_location(83.5337463003993L, -49.6296296296296L), "bD515: lat:83.5337463003993,lng:-49.6296296296296");
  location_is(geohex_get_zone_by_code("bb337").location, geohex_location(85.055246359875L, 89.6296296296297L), "bb337: lat:85.055246359875,lng:89.6296296296297");
  location_is(geohex_get_zone_by_code("TO808").location, geohex_location(84.9809697867981L, -180.0L), "TO808: lat:84.9809697867981,lng:-180");
  location_is(geohex_get_zone_by_code("TO428").location, geohex_location(84.5113535162066L, 175.555555555556L), "TO428: lat:84.5113535162066,lng:175.555555555556");
  location_is(geohex_get_zone_by_code("TO474").location, geohex_location(84.5521076214116L, -177.777777777778L), "TO474: lat:84.5521076214116,lng:-177.777777777778");
  location_is(geohex_get_zone_by_code("TO073").location, geohex_location(83.7235682563837L, -177.037037037037L), "TO073: lat:83.7235682563837,lng:-177.037037037037");
  location_is(geohex_get_zone_by_code("aB648").location, geohex_location(83.2884112693828L, 173.333333333333L), "aB648: lat:83.2884112693828,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("YG168").location, geohex_location(70.5059021145644L, 97.7777777777778L), "YG168: lat:70.5059021145644,lng:97.7777777777778");
  location_is(geohex_get_zone_by_code("BV7511").location, geohex_location(-85.0675187449682L, -76.5432098765432L), "BV7511: lat:-85.0675187449682,lng:-76.5432098765432");
  location_is(geohex_get_zone_by_code("BV7541").location, geohex_location(-85.0306101389078L, -75.8024691358025L), "BV7541: lat:-85.0306101389078,lng:-75.8024691358025");
  location_is(geohex_get_zone_by_code("DO0532").location, geohex_location(-85.055246359875L, 178.024691358025L), "DO0532: lat:-85.055246359875,lng:178.024691358025");
  location_is(geohex_get_zone_by_code("DO3203").location, geohex_location(-84.8802004327088L, -177.530864197531L), "DO3203: lat:-84.8802004327088,lng:-177.530864197531");
  location_is(geohex_get_zone_by_code("EU6235").location, geohex_location(-77.6255431823326L, -170.617283950617L), "EU6235: lat:-77.6255431823326,lng:-170.617283950617");
  location_is(geohex_get_zone_by_code("EU1425").location, geohex_location(-78.3377438281995L, 171.604938271605L), "EU1425: lat:-78.3377438281995,lng:171.604938271605");
  location_is(geohex_get_zone_by_code("OK7172").location, geohex_location(-47.9213497363355L, 64.6913580246913L), "OK7172: lat:-47.9213497363355,lng:64.6913580246913");
  location_is(geohex_get_zone_by_code("CZ0737").location, geohex_location(-78.9276577201097L, -16.7901234567901L), "CZ0737: lat:-78.9276577201097,lng:-16.7901234567901");
  location_is(geohex_get_zone_by_code("Fb0200").location, geohex_location(-55.2519836552773L, -104.444444444444L), "Fb0200: lat:-55.2519836552773,lng:-104.444444444444");
  location_is(geohex_get_zone_by_code("Fb8608").location, geohex_location(-45.0764996106517L, -95.5555555555556L), "Fb8608: lat:-45.0764996106517,lng:-95.5555555555556");
  location_is(geohex_get_zone_by_code("GH4405").location, geohex_location(-23.149924898842L, -160.246913580247L), "GH4405: lat:-23.149924898842,lng:-160.246913580247");
  location_is(geohex_get_zone_by_code("GI2651").location, geohex_location(-11.1900701265807L, 170.123456790123L), "GI2651: lat:-11.1900701265807,lng:170.123456790123");
  location_is(geohex_get_zone_by_code("OC2121").location, geohex_location(-1.42540916199354L, -177.283950617284L), "OC2121: lat:-1.42540916199354,lng:-177.283950617284");
  location_is(geohex_get_zone_by_code("QU7871").location, geohex_location(17.9462662786556L, -172.83950617284L), "QU7871: lat:17.9462662786556,lng:-172.83950617284");
  location_is(geohex_get_zone_by_code("QU4212").location, geohex_location(11.0501910292264L, 174.320987654321L), "QU4212: lat:11.0501910292264,lng:174.320987654321");
  location_is(geohex_get_zone_by_code("OK4362").location, geohex_location(-50.7083005615114L, 63.2098765432099L), "OK4362: lat:-50.7083005615114,lng:63.2098765432099");
  location_is(geohex_get_zone_by_code("OX2538").location, geohex_location(-10.3498108112696L, 5.18518518518519L), "OX2538: lat:-10.3498108112696,lng:5.18518518518519");
  location_is(geohex_get_zone_by_code("OY5663").location, geohex_location(3.7038637783779L, -0.493827160493828L), "OY5663: lat:3.7038637783779,lng:-0.493827160493828");
  location_is(geohex_get_zone_by_code("OG6663").location, geohex_location(-0.142555474941371L, -60.4938271604938L), "OG6663: lat:-0.142555474941371,lng:-60.4938271604938");
  location_is(geohex_get_zone_by_code("PZ0631").location, geohex_location(35.4207859134104L, 44.9382716049383L), "PZ0631: lat:35.4207859134104,lng:44.9382716049383");
  location_is(geohex_get_zone_by_code("SV8518").location, geohex_location(70.6008236675529L, -82.962962962963L), "SV8518: lat:70.6008236675529,lng:-82.962962962963");
  location_is(geohex_get_zone_by_code("TK3246").location, geohex_location(81.0950821454213L, -177.283950617284L), "TK3246: lat:81.0950821454213,lng:-177.283950617284");
  location_is(geohex_get_zone_by_code("TK1825").location, geohex_location(81.5047101156331L, 171.604938271605L), "TK1825: lat:81.5047101156331,lng:171.604938271605");
  location_is(geohex_get_zone_by_code("aB6727").location, geohex_location(83.3547258092653L, 174.320987654321L), "aB6727: lat:83.3547258092653,lng:174.320987654321");
  location_is(geohex_get_zone_by_code("TR1202").location, geohex_location(85.055246359875L, -171.604938271605L), "TR1202: lat:85.055246359875,lng:-171.604938271605");
  location_is(geohex_get_zone_by_code("bD4054").location, geohex_location(82.9293019627422L, -40.7407407407407L), "bD4054: lat:82.9293019627422,lng:-40.7407407407407");
  location_is(geohex_get_zone_by_code("aX4486").location, geohex_location(77.747149679606L, 20.4938271604938L), "aX4486: lat:77.747149679606,lng:20.4938271604938");
  location_is(geohex_get_zone_by_code("ZA5685").location, geohex_location(76.0360327020615L, 117.530864197531L), "ZA5685: lat:76.0360327020615,lng:117.530864197531");
  location_is(geohex_get_zone_by_code("XM4881").location, geohex_location(35.4207859134104L, 139.753086419753L), "XM4881: lat:35.4207859134104,lng:139.753086419753");
  location_is(geohex_get_zone_by_code("XU6302").location, geohex_location(40.2585722649131L, 135.061728395062L), "XU6302: lat:40.2585722649131,lng:135.061728395062");
  location_is(geohex_get_zone_by_code("XX0337").location, geohex_location(43.5465417115035L, 143.20987654321L), "XX0337: lat:43.5465417115035,lng:143.20987654321");
  location_is(geohex_get_zone_by_code("XM6425").location, geohex_location(32.8249312089186L, 151.604938271605L), "XM6425: lat:32.8249312089186,lng:151.604938271605");
  location_is(geohex_get_zone_by_code("PS6270").location, geohex_location(22.6245974406222L, 129.62962962963L), "PS6270: lat:22.6245974406222,lng:129.62962962963");
  location_is(geohex_get_zone_by_code("BV80302").location, geohex_location(-85.0797607463223L, -79.4238683127572L), "BV80302: lat:-85.0797607463223,lng:-79.4238683127572");
  location_is(geohex_get_zone_by_code("BV80373").location, geohex_location(-85.0470478530043L, -78.9300411522634L), "BV80373: lat:-85.0470478530043,lng:-78.9300411522634");
  location_is(geohex_get_zone_by_code("DO08354").location, geohex_location(-84.9308348477316L, -179.506172839506L), "DO08354: lat:-84.9308348477316,lng:-179.506172839506");
  location_is(geohex_get_zone_by_code("DO05758").location, geohex_location(-84.9601406144117L, 178.271604938272L), "DO05758: lat:-84.9601406144117,lng:178.271604938272");
  location_is(geohex_get_zone_by_code("EU31135").location, geohex_location(-78.7250810999821L, -176.131687242798L), "EU31135: lat:-78.7250810999821,lng:-176.131687242798");
  location_is(geohex_get_zone_by_code("EU45042").location, geohex_location(-77.4718632770568L, 177.61316872428L), "EU45042: lat:-77.4718632770568,lng:177.61316872428");
  location_is(geohex_get_zone_by_code("CZ35087").location, geohex_location(-78.2122108191318L, -15.4732510288066L), "CZ35087: lat:-78.2122108191318,lng:-15.4732510288066");
  location_is(geohex_get_zone_by_code("OK06445").location, geohex_location(-54.5690976325026L, 64.3621399176955L), "OK06445: lat:-54.5690976325026,lng:64.3621399176955");
  location_is(geohex_get_zone_by_code("Fb80457").location, geohex_location(-46.3373956350873L, -100.164609053498L), "Fb80457: lat:-46.3373956350873,lng:-100.164609053498");
  location_is(geohex_get_zone_by_code("GH80422").location, geohex_location(-17.6748198317407L, -160.658436213992L), "GH80422: lat:-17.6748198317407,lng:-160.658436213992");
  location_is(geohex_get_zone_by_code("GI74753").location, geohex_location(-7.15661756163309L, -172.75720164609L), "GI74753: lat:-7.15661756163309,lng:-172.75720164609");
  location_is(geohex_get_zone_by_code("GI80240").location, geohex_location(-6.49607781033386L, 178.518518518518L), "GI80240: lat:-6.49607781033386,lng:178.518518518518");
  location_is(geohex_get_zone_by_code("QU01265").location, geohex_location(2.61261388974431L, 176.707818930041L), "QU01265: lat:2.61261388974431,lng:176.707818930041");
  location_is(geohex_get_zone_by_code("QU86344").location, geohex_location(18.4879061162228L, -174.814814814815L), "QU86344: lat:18.4879061162228,lng:-174.814814814815");
  location_is(geohex_get_zone_by_code("OY77334").location, geohex_location(4.55696797874602L, 9.87654320987654L), "OY77334: lat:4.55696797874602,lng:9.87654320987654");
  location_is(geohex_get_zone_by_code("OY15454").location, geohex_location(-2.42272328851834L, -9.1358024691358L), "OY15454: lat:-2.42272328851834,lng:-9.1358024691358");
  location_is(geohex_get_zone_by_code("PA04170").location, geohex_location(3.46673626074913L, -60.4938271604938L), "PA04170: lat:3.46673626074913,lng:-60.4938271604938");
  location_is(geohex_get_zone_by_code("PS62113").location, geohex_location(21.921032689852L, 127.98353909465L), "PS62113: lat:21.921032689852,lng:127.98353909465");
  location_is(geohex_get_zone_by_code("PS68342").location, geohex_location(24.4541915572933L, 133.909465020576L), "PS68342: lat:24.4541915572933,lng:133.909465020576");
  location_is(geohex_get_zone_by_code("XM78145").location, geohex_location(37.6351858644021L, 145.843621399177L), "XM78145: lat:37.6351858644021,lng:145.843621399177");
  location_is(geohex_get_zone_by_code("XM48257").location, geohex_location(34.9937011179371L, 138.353909465021L), "XM48257: lat:34.9937011179371,lng:138.353909465021");
  location_is(geohex_get_zone_by_code("XX03156").location, geohex_location(43.5465417115035L, 141.399176954732L), "XX03156: lat:43.5465417115035,lng:141.399176954732");
  location_is(geohex_get_zone_by_code("PZ47685").location, geohex_location(43.0624236158088L, 43.6213991769547L), "PZ47685: lat:43.0624236158088,lng:43.6213991769547");
  location_is(geohex_get_zone_by_code("SV40654").location, geohex_location(66.4943616312731L, -78.7654320987654L), "SV40654: lat:66.4943616312731,lng:-78.7654320987654");
  location_is(geohex_get_zone_by_code("OI71873").location, geohex_location(25.7022859273215L, -115.22633744856L), "OI71873: lat:25.7022859273215,lng:-115.22633744856");
  location_is(geohex_get_zone_by_code("aX40264").location, geohex_location(76.9994701395296L, 19.0123456790124L), "aX40264: lat:76.9994701395296,lng:19.0123456790124");
  location_is(geohex_get_zone_by_code("ZA44552").location, geohex_location(74.9657874374313L, 118.847736625514L), "ZA44552: lat:74.9657874374313,lng:118.847736625514");
  location_is(geohex_get_zone_by_code("bD47117").location, geohex_location(83.2772949786223L, -38.6831275720165L), "bD47117: lat:83.2772949786223,lng:-38.6831275720165");
  location_is(geohex_get_zone_by_code("TK51615").location, geohex_location(82.0219205989575L, 172.263374485597L), "TK51615: lat:82.0219205989575,lng:172.263374485597");
  location_is(geohex_get_zone_by_code("TK71615").location, geohex_location(82.0219205989575L, -174.40329218107L), "TK71615: lat:82.0219205989575,lng:-174.40329218107");
  location_is(geohex_get_zone_by_code("TO38458").location, geohex_location(84.3265156597377L, -173.58024691358L), "TO38458: lat:84.3265156597377,lng:-173.58024691358");
  location_is(geohex_get_zone_by_code("TO58484").location, geohex_location(85.0429435161968L, 173.333333333333L), "TO58484: lat:85.0429435161968,lng:173.333333333333");
  location_is(geohex_get_zone_by_code("BV553581").location, geohex_location(-85.0360954143169L, -88.4224965706447L), "BV553581: lat:-85.0360954143169,lng:-88.4224965706447");
  location_is(geohex_get_zone_by_code("CI802417").location, geohex_location(-85.020996354334L, 118.463648834019L), "CI802417: lat:-85.020996354334,lng:118.463648834019");
  location_is(geohex_get_zone_by_code("CI750110").location, geohex_location(-85.1109083358255L, 124.115226337449L), "CI750110: lat:-85.1109083358255,lng:124.115226337449");
  location_is(geohex_get_zone_by_code("DO018862").location, geohex_location(-85.1405176040458L, 177.887517146776L), "DO018862: lat:-85.1405176040458,lng:177.887517146776");
  location_is(geohex_get_zone_by_code("DO053505").location, geohex_location(-85.049782194126L, 178.244170096022L), "DO053505: lat:-85.049782194126,lng:178.244170096022");
  location_is(geohex_get_zone_by_code("DO074664").location, geohex_location(-85.0182461528016L, -177.119341563786L), "DO074664: lat:-85.0182461528016,lng:-177.119341563786");
  location_is(geohex_get_zone_by_code("CZ351822").location, geohex_location(-78.1342985749577L, -16.5157750342936L), "CZ351822: lat:-78.1342985749577,lng:-16.5157750342936");
  location_is(geohex_get_zone_by_code("EU412420").location, geohex_location(-77.8442540286679L, 176.131687242798L), "EU412420: lat:-77.8442540286679,lng:176.131687242798");
  location_is(geohex_get_zone_by_code("EU708101").location, geohex_location(-77.1518061167366L, -173.60768175583L), "EU708101: lat:-77.1518061167366,lng:-173.60768175583");
  location_is(geohex_get_zone_by_code("OK847038").location, geohex_location(-44.5822286864963L, 60.8230452674897L), "OK847038: lat:-44.5822286864963,lng:60.8230452674897");
  location_is(geohex_get_zone_by_code("GH501658").location, geohex_location(-21.6268443575399L, -166.995884773663L), "GH501658: lat:-21.6268443575399,lng:-166.995884773663");
  location_is(geohex_get_zone_by_code("GI842644").location, geohex_location(-3.84611006144169L, 179.012345679012L), "GI842644: lat:-3.84611006144169,lng:179.012345679012");
  location_is(geohex_get_zone_by_code("GI836575").location, geohex_location(-4.9200310051179L, -176.488340192044L), "GI836575: lat:-4.9200310051179,lng:-176.488340192044");
  location_is(geohex_get_zone_by_code("QU316588").location, geohex_location(6.66916376446729L, -174.320987654321L), "QU316588: lat:6.66916376446729,lng:-174.320987654321");
  location_is(geohex_get_zone_by_code("QU175485").location, geohex_location(9.47604969238701L, 174.787379972565L), "QU175485: lat:9.47604969238701,lng:174.787379972565");
  location_is(geohex_get_zone_by_code("Fb711277").location, geohex_location(-48.4493715354198L, -96.6803840877915L), "Fb711277: lat:-48.4493715354198,lng:-96.6803840877915");
  location_is(geohex_get_zone_by_code("OY728344").location, geohex_location(4.55696797874602L, 2.46913580246914L), "OY728344: lat:4.55696797874602,lng:2.46913580246914");
  location_is(geohex_get_zone_by_code("PA016372").location, geohex_location(2.47019851680954L, -60.4663923182442L), "PA016372: lat:2.47019851680954,lng:-60.4663923182442");
  location_is(geohex_get_zone_by_code("QU408880").location, geohex_location(10.1315903865524L, -180.0L), "QU408880: lat:10.1315903865524,lng:-180");
  location_is(geohex_get_zone_by_code("XM442337").location, geohex_location(32.5583242135466L, 138.875171467764L), "XM442337: lat:32.5583242135466,lng:138.875171467764");
  location_is(geohex_get_zone_by_code("PS387785").location, geohex_location(21.935726236625L, 127.626886145405L), "PS387785: lat:21.935726236625,lng:127.626886145405");
  location_is(geohex_get_zone_by_code("XX037037").location, geohex_location(43.8328762014381L, 143.072702331962L), "XX037037: lat:43.8328762014381,lng:143.072702331962");
  location_is(geohex_get_zone_by_code("PZ173676").location, geohex_location(39.6392946161491L, 36.9272976680384L), "PZ173676: lat:39.6392946161491,lng:36.9272976680384");
  location_is(geohex_get_zone_by_code("SV321726").location, geohex_location(65.8026708623787L, -78.3813443072702L), "SV321726: lat:65.8026708623787,lng:-78.3813443072702");
  location_is(geohex_get_zone_by_code("PC828583").location, geohex_location(39.7733383345461L, -104.663923182442L), "PC828583: lat:39.7733383345461,lng:-104.663923182442");
  location_is(geohex_get_zone_by_code("OI713375").location, geohex_location(24.382077991931L, -114.513031550069L), "OI713375: lat:24.382077991931,lng:-114.513031550069");
  location_is(geohex_get_zone_by_code("bD080050").location, geohex_location(82.4038568826114L, -40.082304526749L), "bD080050: lat:82.4038568826114,lng:-40.082304526749");
  location_is(geohex_get_zone_by_code("aX817100").location, geohex_location(78.9032956845109L, 18.2716049382716L), "aX817100: lat:78.9032956845109,lng:18.2716049382716");
  location_is(geohex_get_zone_by_code("ZA712478").location, geohex_location(75.4947160961744L, 123.045267489712L), "ZA712478: lat:75.4947160961744,lng:123.045267489712");
  location_is(geohex_get_zone_by_code("TK166315").location, geohex_location(81.0680709068572L, 179.396433470508L), "TK166315: lat:81.0680709068572,lng:179.396433470508");
  location_is(geohex_get_zone_by_code("TK873482").location, geohex_location(82.8350951420658L, -177.091906721536L), "TK873482: lat:82.8350951420658,lng:-177.091906721536");
  location_is(geohex_get_zone_by_code("TO433402").location, geohex_location(84.2508548924535L, -177.091906721536L), "TO433402: lat:84.2508548924535,lng:-177.091906721536");
  location_is(geohex_get_zone_by_code("TO586342").location, geohex_location(85.0058514824907L, 175.006858710562L), "TO586342: lat:85.0058514824907,lng:175.006858710562");
  location_is(geohex_get_zone_by_code("bb335332").location, geohex_location(85.0388357867675L, 88.4224965706447L), "bb335332: lat:85.0388357867675,lng:88.4224965706447");
  location_is(geohex_get_zone_by_code("BV8032788").location, geohex_location(-85.047503681127L, -79.6707818930041L), "BV8032788: lat:-85.047503681127,lng:-79.6707818930041");
  location_is(geohex_get_zone_by_code("CI7714524").location, geohex_location(-85.0511487999708L, 128.0109739369L), "CI7714524: lat:-85.0511487999708,lng:128.0109739369");
  location_is(geohex_get_zone_by_code("DO0514686").location, geohex_location(-85.0525150294753L, 177.219935985368L), "DO0514686: lat:-85.0525150294753,lng:177.219935985368");
  location_is(geohex_get_zone_by_code("DO0517300").location, geohex_location(-85.0506933065098L, 177.366255144033L), "DO0517300: lat:-85.0506933065098,lng:177.366255144033");
  location_is(geohex_get_zone_by_code("DO0732687").location, geohex_location(-85.0520596614496L, -177.357110196616L), "DO0732687: lat:-85.0520596614496,lng:-177.357110196616");
  location_is(geohex_get_zone_by_code("DO0732768").location, geohex_location(-85.0502377712295L, -177.393689986283L), "DO0732768: lat:-85.0502377712295,lng:-177.393689986283");
  location_is(geohex_get_zone_by_code("EU4031833").location, geohex_location(-78.2068165801529L, -179.46959304984L), "EU4031833: lat:-78.2068165801529,lng:-179.46959304984");
  location_is(geohex_get_zone_by_code("EU8072131").location, geohex_location(-76.3248300177426L, -179.817101051669L), "EU8072131: lat:-76.3248300177426,lng:-179.817101051669");
  location_is(geohex_get_zone_by_code("EU8255485").location, geohex_location(-75.6434006236876L, 174.558756287151L), "EU8255485: lat:-75.6434006236876,lng:174.558756287151");
  location_is(geohex_get_zone_by_code("CZ3800810").location, geohex_location(-78.0613410780894L, -13.360768175583L), "CZ3800810: lat:-78.0613410780894,lng:-13.360768175583");
  location_is(geohex_get_zone_by_code("OK1624776").location, geohex_location(-52.2664641271478L, 56.424325560128L), "OK1624776: lat:-52.2664641271478,lng:56.424325560128");
  location_is(geohex_get_zone_by_code("OK7464515").location, geohex_location(-47.3199214562931L, 68.029263831733L), "OK7464515: lat:-47.3199214562931,lng:68.029263831733");
  location_is(geohex_get_zone_by_code("Fb5316746").location, geohex_location(-48.4598765064117L, -104.590763603109L), "Fb5316746: lat:-48.4598765064117,lng:-104.590763603109");
  location_is(geohex_get_zone_by_code("Fb4033527").location, geohex_location(-51.8346280091477L, -99.1403749428441L), "Fb4033527: lat:-51.8346280091477,lng:-99.1403749428441");
  location_is(geohex_get_zone_by_code("GH4540858").location, geohex_location(-21.4549569468283L, -162.249657064472L), "GH4540858: lat:-21.4549569468283,lng:-162.249657064472");
  location_is(geohex_get_zone_by_code("GI4351804").location, geohex_location(-12.3839714259397L, -178.765432098765L), "GI4351804: lat:-12.3839714259397,lng:-178.765432098765");
  location_is(geohex_get_zone_by_code("GI8387484").location, geohex_location(-4.09893317247951L, -177.530864197531L), "GI8387484: lat:-4.09893317247951,lng:-177.530864197531");
  location_is(geohex_get_zone_by_code("QU0706771").location, geohex_location(4.33061760163989L, -177.183356195702L), "QU0706771: lat:4.33061760163989,lng:-177.183356195702");
  location_is(geohex_get_zone_by_code("QU4884047").location, geohex_location(14.7141280738906L, -179.990855052583L), "QU4884047: lat:14.7141280738906,lng:-179.990855052583");
  location_is(geohex_get_zone_by_code("QU8251271").location, geohex_location(19.1725252486474L, 174.421582075903L), "QU8251271: lat:19.1725252486474,lng:174.421582075903");
  location_is(geohex_get_zone_by_code("PA0565644").location, geohex_location(5.26712366729292L, -60.8230452674897L), "PA0565644: lat:5.26712366729292,lng:-60.8230452674897");
  location_is(geohex_get_zone_by_code("OY8320288").location, geohex_location(6.16022759188225L, 0.576131687242797L), "OY8320288: lat:6.16022759188225,lng:0.576131687242797");
  location_is(geohex_get_zone_by_code("OY3556486").location, geohex_location(-2.10618080216265L, 4.21582075903064L), "OY3556486: lat:-2.10618080216265,lng:4.21582075903064");
  location_is(geohex_get_zone_by_code("PZ8016814").location, geohex_location(45.3331815719879L, 39.7256515775034L), "PZ8016814: lat:45.3331815719879,lng:39.7256515775034");
  location_is(geohex_get_zone_by_code("PZ1746604").location, geohex_location(39.907121529315L, 36.2139917695473L), "PZ1746604: lat:39.907121529315,lng:36.2139917695473");
  location_is(geohex_get_zone_by_code("PS6242083").location, geohex_location(22.4295183912878L, 128.404206675812L), "PS6242083: lat:22.4295183912878,lng:128.404206675812");
  location_is(geohex_get_zone_by_code("XM5643552").location, geohex_location(35.8199354136109L, 137.896662094193L), "XM5643552: lat:35.8199354136109,lng:137.896662094193");
  location_is(geohex_get_zone_by_code("XU6303820").location, geohex_location(40.214236183804L, 135.747599451303L), "XU6303820: lat:40.214236183804,lng:135.747599451303");
  location_is(geohex_get_zone_by_code("XM7851800").location, geohex_location(38.2016470474239L, 145.679012345679L), "XM7851800: lat:38.2016470474239,lng:145.679012345679");
  location_is(geohex_get_zone_by_code("XX0345653").location, geohex_location(43.8633378587961L, 142.12162780064L), "XX0345653: lat:43.8633378587961,lng:142.12162780064");
  location_is(geohex_get_zone_by_code("XM6306347").location, geohex_location(30.8515110089981L, 156.140832190215L), "XM6306347: lat:30.8515110089981,lng:156.140832190215");
  location_is(geohex_get_zone_by_code("QU8827707").location, geohex_location(21.4549569468283L, 178.856881572931L), "QU8827707: lat:21.4549569468283,lng:178.856881572931");
  location_is(geohex_get_zone_by_code("PZ4253332").location, geohex_location(42.0355923018785L, 35.1531778692273L), "PZ4253332: lat:42.0355923018785,lng:35.1531778692273");
  location_is(geohex_get_zone_by_code("OI8776718").location, geohex_location(30.924007364529L, -116.488340192044L), "OI8776718: lat:30.924007364529,lng:-116.488340192044");
  location_is(geohex_get_zone_by_code("PF2148656").location, geohex_location(41.1352109428687L, -95.4000914494742L), "PF2148656: lat:41.1352109428687,lng:-95.4000914494742");
  location_is(geohex_get_zone_by_code("ZA4587731").location, geohex_location(75.4098380636786L, 118.125285779607L), "ZA4587731: lat:75.4098380636786,lng:118.125285779607");
  location_is(geohex_get_zone_by_code("SV4335020").location, geohex_location(66.7915979463581L, -77.3388203017833L), "SV4335020: lat:66.7915979463581,lng:-77.3388203017833");
  location_is(geohex_get_zone_by_code("SV5843218").location, geohex_location(69.7284788454194L, -86.6117969821674L), "SV5843218: lat:69.7284788454194,lng:-86.6117969821674");
  location_is(geohex_get_zone_by_code("aX0682573").location, geohex_location(76.0156327302267L, 23.9048925468679L), "aX0682573: lat:76.0156327302267,lng:23.9048925468679");
  location_is(geohex_get_zone_by_code("aX8100870").location, geohex_location(78.6702381130175L, 17.8052126200274L), "aX8100870: lat:78.6702381130175,lng:17.8052126200274");
  location_is(geohex_get_zone_by_code("bD4424804").location, geohex_location(83.1952135950448L, -41.4814814814815L), "bD4424804: lat:83.1952135950448,lng:-41.4814814814815");
  location_is(geohex_get_zone_by_code("bE6100113").location, geohex_location(84.1816867255254L, -48.9894833104709L), "bE6100113: lat:84.1816867255254,lng:-48.9894833104709");
  location_is(geohex_get_zone_by_code("TK5027217").location, geohex_location(81.8740128778651L, 171.915866483768L), "TK5027217: lat:81.8740128778651,lng:171.915866483768");
  location_is(geohex_get_zone_by_code("TK7070414").location, geohex_location(81.8732665374047L, -172.620027434842L), "TK7070414: lat:81.8732665374047,lng:-172.620027434842");
  location_is(geohex_get_zone_by_code("TO6240542").location, geohex_location(84.4058180257527L, -171.211705532693L), "TO6240542: lat:84.4058180257527,lng:-171.211705532693");
  location_is(geohex_get_zone_by_code("TO7775738").location, geohex_location(84.9596767659574L, -170.507544581619L), "TO7775738: lat:84.9596767659574,lng:-170.507544581619");
  location_is(geohex_get_zone_by_code("TO5821675").location, geohex_location(85.0076896690631L, 171.787837219936L), "TO5821675: lat:85.0076896690631,lng:171.787837219936");
  location_is(geohex_get_zone_by_code("bb3371862").location, geohex_location(85.0511487999708L, 89.4192958390489L), "bb3371862: lat:85.0511487999708,lng:89.4192958390489");
  location_is(geohex_get_zone_by_code("BV54870250").location, geohex_location(-85.0509969734635L, -86.4837677183356L), "BV54870250: lat:-85.0509969734635,lng:-86.4837677183356");
  location_is(geohex_get_zone_by_code("BV78253862").location, geohex_location(-84.8943159331226L, -74.9672306050907L), "BV78253862: lat:-84.8943159331226,lng:-74.9672306050907");
  location_is(geohex_get_zone_by_code("CI57758513").location, geohex_location(-84.9593675099988L, 116.015851242189L), "CI57758513: lat:-84.9593675099988,lng:116.015851242189");
  location_is(geohex_get_zone_by_code("CI75600226").location, geohex_location(-85.0511487999708L, 125.858862978205L), "CI75600226: lat:-85.0511487999708,lng:125.858862978205");
  location_is(geohex_get_zone_by_code("DO05603615").location, geohex_location(-85.0473517430692L, 179.384240207285L), "DO05603615: lat:-85.0473517430692,lng:179.384240207285");
  location_is(geohex_get_zone_by_code("DO07152160").location, geohex_location(-85.0446160627918L, -178.93918609968L), "DO07152160: lat:-85.0446160627918,lng:-178.93918609968");
  location_is(geohex_get_zone_by_code("EU41063674").location, geohex_location(-78.0252444701795L, 178.417924096936L), "EU41063674: lat:-78.0252444701795,lng:178.417924096936");
  location_is(geohex_get_zone_by_code("EU72201265").location, geohex_location(-76.7835357741786L, -179.38119189148L), "EU72201265: lat:-76.7835357741786,lng:-179.38119189148");
  location_is(geohex_get_zone_by_code("CZ34762511").location, geohex_location(-78.2781825453963L, -12.3030025910684L), "CZ34762511: lat:-78.2781825453963,lng:-12.3030025910684");
  location_is(geohex_get_zone_by_code("Fb38241503").location, geohex_location(-50.7361552519765L, -94.9215058680079L), "Fb38241503: lat:-50.7361552519765,lng:-94.9215058680079");
  location_is(geohex_get_zone_by_code("OK48511367").location, geohex_location(-48.0579824947847L, 58.9788142051516L), "OK48511367: lat:-48.0579824947847,lng:58.9788142051516");
  location_is(geohex_get_zone_by_code("GI32042116").location, geohex_location(-16.0580131465426L, -177.972869989331L), "GI32042116: lat:-16.0580131465426,lng:-177.972869989331");
  location_is(geohex_get_zone_by_code("GI71565064").location, geohex_location(-8.50607873048697L, -175.866483767718L), "GI71565064: lat:-8.50607873048697,lng:-175.866483767718");
  location_is(geohex_get_zone_by_code("GH45442518").location, geohex_location(-21.2894261632855L, -162.423411065386L), "GH45442518: lat:-21.2894261632855,lng:-162.423411065386");
  location_is(geohex_get_zone_by_code("OY33228746").location, geohex_location(-5.01471113242862L, 6.94711172077427L), "OY33228746: lat:-5.01471113242862,lng:6.94711172077427");
  location_is(geohex_get_zone_by_code("PA03278283").location, geohex_location(2.81126495087439L, -59.0641670477061L), "PA03278283: lat:2.81126495087439,lng:-59.0641670477061");
  location_is(geohex_get_zone_by_code("QU42174351").location, geohex_location(11.1779844636168L, 175.076969974089L), "QU42174351: lat:11.1779844636168,lng:175.076969974089");
  location_is(geohex_get_zone_by_code("QU47122108").location, geohex_location(12.2842506542222L, -179.20438957476L), "QU47122108: lat:12.2842506542222,lng:-179.20438957476");
  location_is(geohex_get_zone_by_code("XM32230826").location, geohex_location(29.2290324338197L, 140.975461057766L), "XM32230826: lat:29.2290324338197,lng:140.975461057766");
  location_is(geohex_get_zone_by_code("XM56301016").location, geohex_location(35.2355604188248L, 138.433165675964L), "XM56301016: lat:35.2355604188248,lng:138.433165675964");
  location_is(geohex_get_zone_by_code("PS61272751").location, geohex_location(21.4533189464174L, 129.727175735406L), "PS61272751: lat:21.4533189464174,lng:129.727175735406");
  location_is(geohex_get_zone_by_code("XM60832123").location, geohex_location(31.1170623309677L, 153.372961438805L), "XM60832123: lat:31.1170623309677,lng:153.372961438805");
  location_is(geohex_get_zone_by_code("XU63124187").location, geohex_location(40.5814792855475L, 134.296601127877L), "XU63124187: lat:40.5814792855475,lng:134.296601127877");
  location_is(geohex_get_zone_by_code("XX03173236").location, geohex_location(43.5082605084073L, 141.771071483006L), "XX03173236: lat:43.5082605084073,lng:141.771071483006");
  location_is(geohex_get_zone_by_code("PZ38755703").location, geohex_location(41.3760117394249L, 47.1086724584667L), "PZ38755703: lat:41.3760117394249,lng:47.1086724584667");
  location_is(geohex_get_zone_by_code("PZ57757416").location, geohex_location(46.0046711009809L, 36.1286389269928L), "PZ57757416: lat:46.0046711009809,lng:36.1286389269928");
  location_is(geohex_get_zone_by_code("Fc51504013").location, geohex_location(-39.8517479873992L, -129.635726261241L), "Fc51504013: lat:-39.8517479873992,lng:-129.635726261241");
  location_is(geohex_get_zone_by_code("OW22586402").location, geohex_location(0.702200855013125L, -58.3600060966316L), "OW22586402: lat:0.702200855013125,lng:-58.3600060966316");
  location_is(geohex_get_zone_by_code("PC52458806").location, geohex_location(36.093459539735L, -111.351928059747L), "PC52458806: lat:36.093459539735,lng:-111.351928059747");
  location_is(geohex_get_zone_by_code("SV20852101").location, geohex_location(66.8220953612271L, -93.7753391251333L), "SV20852101: lat:66.8220953612271,lng:-93.7753391251333");
  location_is(geohex_get_zone_by_code("aX46486040").location, geohex_location(77.617997794141L, 24.6090534979424L), "aX46486040: lat:77.617997794141,lng:24.6090534979424");
  location_is(geohex_get_zone_by_code("ZA62754057").location, geohex_location(74.9593947944536L, 129.376619417772L), "ZA62754057: lat:74.9593947944536,lng:129.376619417772");
  location_is(geohex_get_zone_by_code("bD28367162").location, geohex_location(83.4403223519231L, -52.0317024843774L), "bD28367162: lat:83.4403223519231,lng:-52.0317024843774");
  location_is(geohex_get_zone_by_code("TK05722747").location, geohex_location(80.760728435108L, 177.890565462582L), "TK05722747: lat:80.760728435108,lng:177.890565462582");
  location_is(geohex_get_zone_by_code("TK83151057").location, geohex_location(82.5046204779964L, -178.853833257125L), "TK83151057: lat:82.5046204779964,lng:-178.853833257125");
  location_is(geohex_get_zone_by_code("TO31130720").location, geohex_location(83.838150193033L, -176.040237768633L), "TO31130720: lat:83.838150193033,lng:-176.040237768633");
  location_is(geohex_get_zone_by_code("TO51331450").location, geohex_location(84.6150692030928L, 172.007315957933L), "TO51331450: lat:84.6150692030928,lng:172.007315957933");
  location_is(geohex_get_zone_by_code("bb33488116").location, geohex_location(85.0493265751955L, 88.8584057308337L), "bb33488116: lat:85.0493265751955,lng:88.8584057308337");
  location_is(geohex_get_zone_by_code("BV804240512").location, geohex_location(-85.0206908511882L, -80.5080526342529L), "BV804240512: lat:-85.0206908511882,lng:-80.5080526342529");
  location_is(geohex_get_zone_by_code("CI708565326").location, geohex_location(-85.2589223575257L, 126.562007824011L), "CI708565326: lat:-85.2589223575257,lng:126.562007824011");
  location_is(geohex_get_zone_by_code("CI754848748").location, geohex_location(-84.9900971535871L, 124.453589391861L), "CI754848748: lat:-84.9900971535871,lng:124.453589391861");
  location_is(geohex_get_zone_by_code("DO055580431").location, geohex_location(-84.9631288388604L, 176.792155667327L), "DO055580431: lat:-84.9631288388604,lng:176.792155667327");
  location_is(geohex_get_zone_by_code("DO053480025").location, geohex_location(-85.0506426935439L, 178.511405781639L), "DO053480025: lat:-85.0506426935439,lng:178.511405781639");
  location_is(geohex_get_zone_by_code("DO073506567").location, geohex_location(-85.0506426935439L, -177.231113143322L), "DO073506567: lat:-85.0506426935439,lng:-177.231113143322");
  location_is(geohex_get_zone_by_code("CZ347013544").location, geohex_location(-78.3494780602137L, -12.6566072245084L), "CZ347013544: lat:-78.3494780602137,lng:-12.6566072245084");
  location_is(geohex_get_zone_by_code("EU413474586").location, geohex_location(-77.9155713059442L, 178.593710308388L), "EU413474586: lat:-77.9155713059442,lng:178.593710308388");
  location_is(geohex_get_zone_by_code("EU354580674").location, geohex_location(-78.0620691964047L, -175.781130925164L), "EU354580674: lat:-78.0620691964047,lng:-175.781130925164");
  location_is(geohex_get_zone_by_code("OK474555348").location, geohex_location(-48.9226432855131L, 61.8747142203932L), "OK474555348: lat:-48.9226432855131,lng:61.8747142203932");
  location_is(geohex_get_zone_by_code("Fb484868583").location, geohex_location(-47.9901039539973L, -99.8435197886501L), "Fb484868583: lat:-47.9901039539973,lng:-99.8435197886501");
  location_is(geohex_get_zone_by_code("GH147081657").location, geohex_location(-25.8000377340134L, -165.93710308388L), "GH147081657: lat:-25.8000377340134,lng:-165.93710308388");
  location_is(geohex_get_zone_by_code("GI730641802").location, geohex_location(-9.79704499838906L, -170.646751003404L), "GI730641802: lat:-9.79704499838906,lng:-170.646751003404");
  location_is(geohex_get_zone_by_code("GI576514101").location, geohex_location(-6.3165183772949L, 176.697657877356L), "GI576514101: lat:-6.3165183772949,lng:176.697657877356");
  location_is(geohex_get_zone_by_code("OY041035522").location, geohex_location(-8.40685248119733L, -0.703144845806026L), "OY041035522: lat:-8.40685248119733,lng:-0.703144845806026");
  location_is(geohex_get_zone_by_code("OY537117080").location, geohex_location(2.81009306503265L, -4.00548696844993L), "OY537117080: lat:2.81009306503265,lng:-4.00548696844993");
  location_is(geohex_get_zone_by_code("PA402570238").location, geohex_location(9.10030722934531L, -61.661332114007L), "PA402570238: lat:9.10030722934531,lng:-61.661332114007");
  location_is(geohex_get_zone_by_code("QU058877078").location, geohex_location(6.31535220144277L, 177.890565462582L), "QU058877078: lat:6.31535220144277,lng:177.890565462582");
  location_is(geohex_get_zone_by_code("QU832828267").location, geohex_location(17.9769594326653L, -179.435045470711L), "QU832828267: lat:17.9769594326653,lng:-179.435045470711");
  location_is(geohex_get_zone_by_code("PZ382714446").location, geohex_location(40.9799418699384L, 45.3518264492201L), "PZ382714446: lat:40.9799418699384,lng:45.3518264492201");
  location_is(geohex_get_zone_by_code("PZ028668414").location, geohex_location(36.5981065089872L, 36.2109434537418L), "PZ028668414: lat:36.5981065089872,lng:36.2109434537418");
  location_is(geohex_get_zone_by_code("PS383657231").location, geohex_location(20.9605452560715L, 127.830107199106L), "PS383657231: lat:20.9605452560715,lng:127.830107199106");
  location_is(geohex_get_zone_by_code("XM602176827").location, geohex_location(30.4477570198834L, 151.737031956511L), "XM602176827: lat:30.4477570198834,lng:151.737031956511");
  location_is(geohex_get_zone_by_code("XM482452815").location, geohex_location(34.8845341899227L, 138.377279886196L), "XM482452815: lat:34.8845341899227,lng:138.377279886196");
  location_is(geohex_get_zone_by_code("XX033123366").location, geohex_location(43.3241725915388L, 142.596148961032L), "XX033123366: lat:43.3241725915388,lng:142.596148961032");
  location_is(geohex_get_zone_by_code("OI860616105").location, geohex_location(28.6118235021042L, -115.099324289996L), "OI860616105: lat:28.6118235021042,lng:-115.099324289996");
  location_is(geohex_get_zone_by_code("RX114077466").location, geohex_location(46.3155197311649L, -108.771020677742L), "RX114077466: lat:46.3155197311649,lng:-108.771020677742");
  location_is(geohex_get_zone_by_code("SV355072242").location, geohex_location(66.5133066879411L, -76.2891835594167L), "SV355072242: lat:66.5133066879411,lng:-76.2891835594167");
  location_is(geohex_get_zone_by_code("YG413103084").location, geohex_location(70.8442736203268L, 98.2990397805213L), "YG413103084: lat:70.8442736203268,lng:98.2990397805213");
  location_is(geohex_get_zone_by_code("ZA486483578").location, geohex_location(75.4967730780092L, 121.50281969212L), "ZA486483578: lat:75.4967730780092,lng:121.50281969212");
  location_is(geohex_get_zone_by_code("aX426174078").location, geohex_location(77.5421678409154L, 16.8754762993446L), "aX426174078: lat:77.5421678409154,lng:16.8754762993446");
  location_is(geohex_get_zone_by_code("aX747576237").location, geohex_location(78.4902032275222L, 27.2834425646497L), "aX747576237: lat:78.4902032275222,lng:27.2834425646497");
  location_is(geohex_get_zone_by_code("TK184816376").location, geohex_location(81.5182191033962L, 173.320123964843L), "TK184816376: lat:81.5182191033962,lng:173.320123964843");
  location_is(geohex_get_zone_by_code("TO310523631").location, geohex_location(83.829769600284L, -175.919321241681L), "TO310523631: lat:83.829769600284,lng:-175.919321241681");
  location_is(geohex_get_zone_by_code("TO423806423").location, geohex_location(84.4057608378714L, 176.346085454453L), "TO423806423: lat:84.4057608378714,lng:176.346085454453");
  location_is(geohex_get_zone_by_code("bb303856635").location, geohex_location(84.8970300131518L, 87.4002946705278L), "bb303856635: lat:84.8970300131518,lng:87.4002946705278");
  location_is(geohex_get_zone_by_code("TO815178640").location, geohex_location(85.0496809490896L, 176.890717878372L), "TO815178640: lat:85.0496809490896,lng:176.890717878372");
  location_is(geohex_get_zone_by_code("SV1700305142").location, geohex_location(65.9465407491988L, -84.3750105844299L), "SV1700305142: lat:65.9465407491988,lng:-84.3750105844299");
  location_is(geohex_get_zone_by_code("BV5482764471").location, geohex_location(-85.0511150611485L, -87.0226422123998L), "BV5482764471: lat:-85.0511150611485,lng:-87.0226422123998");
  location_is(geohex_get_zone_by_code("BV7560068257").location, geohex_location(-85.0501702809645L, -74.0259784246981L), "BV7560068257: lat:-85.0501702809645,lng:-74.0259784246981");
  location_is(geohex_get_zone_by_code("CI5263615540").location, geohex_location(-85.1412961182694L, 110.742264898643L), "CI5263615540: lat:-85.1412961182694,lng:110.742264898643");
  location_is(geohex_get_zone_by_code("CI7265571616").location, geohex_location(-85.1114082947234L, 123.398533421396L), "CI7265571616: lat:-85.1114082947234,lng:123.398533421396");
  location_is(geohex_get_zone_by_code("CI7505181555").location, geohex_location(-85.0813538350387L, 124.101678267202L), "CI7505181555: lat:-85.0813538350387,lng:124.101678267202");
  location_is(geohex_get_zone_by_code("CI5736546251").location, geohex_location(-85.0511150611485L, 116.718657386239L), "CI5736546251: lat:-85.0511150611485,lng:116.718657386239");
  location_is(geohex_get_zone_by_code("DO0273028158").location, geohex_location(-85.1114249591416L, 176.48427577097L), "DO0273028158: lat:-85.1114249591416,lng:176.48427577097");
  location_is(geohex_get_zone_by_code("DO0536546500").location, geohex_location(-85.0511319305883L, 178.945282731291L), "DO0536546500: lat:-85.0511319305883,lng:178.945282731291");
  location_is(geohex_get_zone_by_code("DO0716764500").location, geohex_location(-85.0511319305883L, -177.890565462582L), "DO0716764500: lat:-85.0511319305883,lng:-177.890565462582");
  location_is(geohex_get_zone_by_code("EU4016113514").location, geohex_location(-78.2065767797249L, 179.648427577097L), "EU4016113514: lat:-78.2065767797249,lng:179.648427577097");
  location_is(geohex_get_zone_by_code("EU4827777232").location, geohex_location(-76.9520070654571L, 178.878558485326L), "EU4827777232: lat:-76.9520070654571,lng:178.878558485326");
  location_is(geohex_get_zone_by_code("EU7445272188").location, geohex_location(-76.6712537244362L, -173.738759335467L), "EU7445272188: lat:-76.6712537244362,lng:-173.738759335467");
  location_is(geohex_get_zone_by_code("OK1777354303").location, geohex_location(-51.1793357370083L, 56.6014665786042L), "OK1777354303: lat:-51.1793357370083,lng:56.6014665786042");
  location_is(geohex_get_zone_by_code("CZ3420476772").location, geohex_location(-78.4202281335297L, -14.7657030601704L), "CZ3420476772: lat:-78.4202281335297,lng:-14.7657030601704");
  location_is(geohex_get_zone_by_code("Fb4334484641").location, geohex_location(-50.9585202016351L, -97.0312791071822L), "Fb4334484641: lat:-50.9585202016351,lng:-97.0312791071822");
  location_is(geohex_get_zone_by_code("GH5856584625").location, geohex_location(-15.9613990684089L, -166.992159054345L), "GH5856584625: lat:-15.9613990684089,lng:-166.992159054345");
  location_is(geohex_get_zone_by_code("GI1730824803").location, geohex_location(-14.5690122702619L, 176.241765313553L), "GI1730824803: lat:-14.5690122702619,lng:176.241765313553");
  location_is(geohex_get_zone_by_code("GI7234521114").location, geohex_location(-8.05907204605798L, -177.187420616776L), "GI7234521114: lat:-8.05907204605798,lng:-177.187420616776");
  location_is(geohex_get_zone_by_code("QU3851424320").location, geohex_location(10.4879003633166L, -174.374841233552L), "QU3851424320: lat:10.4879003633166,lng:-174.374841233552");
  location_is(geohex_get_zone_by_code("QU8152020110").location, geohex_location(17.9788194524589L, 176.48427577097L), "QU8152020110: lat:17.9788194524589,lng:176.48427577097");
  location_is(geohex_get_zone_by_code("PA0426257051").location, geohex_location(3.86405991256845L, -61.1719080763434L), "PA0426257051: lat:3.86405991256845,lng:-61.1719080763434");
  location_is(geohex_get_zone_by_code("OY4244664644").location, geohex_location(0.0L, -4.21886907483615L), "OY4244664644: lat:0,lng:-4.21886907483615");
  location_is(geohex_get_zone_by_code("OY7353226324").location, geohex_location(2.84817874986869L, 8.19488899049942L), "OY7353226324: lat:2.84817874986869,lng:8.19488899049942");
  location_is(geohex_get_zone_by_code("OY3444432334").location, geohex_location(-3.86425501756244L, 6.67987603515724L), "OY3444432334: lat:-3.86425501756244,lng:6.67987603515724");
  location_is(geohex_get_zone_by_code("QU8136543688").location, geohex_location(17.3087066067811L, 178.945282731291L), "QU8136543688: lat:17.3087066067811,lng:178.945282731291");
  location_is(geohex_get_zone_by_code("QU8831183154").location, geohex_location(20.749483042625L, -179.583396839913L), "QU8831183154: lat:20.749483042625,lng:-179.583396839913");
  location_is(geohex_get_zone_by_code("PS6206841033").location, geohex_location(21.7798249604327L, 129.374925908991L), "PS6206841033: lat:21.7798249604327,lng:129.374925908991");
  location_is(geohex_get_zone_by_code("XM0565771230").location, geohex_location(27.326562730624L, 139.107859574252L), "XM0565771230: lat:27.326562730624,lng:139.107859574252");
  location_is(geohex_get_zone_by_code("XM4863207510").location, geohex_location(34.6996944322973L, 141.568866534573L), "XM4863207510: lat:34.6996944322973,lng:141.568866534573");
  location_is(geohex_get_zone_by_code("XX0330807788").location, geohex_location(43.2881703923717L, 142.975156226185L), "XX0330807788: lat:43.2881703923717,lng:142.975156226185");
  location_is(geohex_get_zone_by_code("XM6054354111").location, geohex_location(30.8583938064873L, 152.643059154262L), "XM6054354111: lat:30.8583938064873,lng:152.643059154262");
  location_is(geohex_get_zone_by_code("PZ1548687734").location, geohex_location(40.1788360639254L, 31.2889295330996L), "PZ1548687734: lat:40.1788360639254,lng:31.2889295330996");
  location_is(geohex_get_zone_by_code("PZ7555070851").location, geohex_location(45.9156317843344L, 43.4828701586818L), "PZ7555070851: lat:45.9156317843344,lng:43.4828701586818");
  location_is(geohex_get_zone_by_code("OI7581576564").location, geohex_location(27.8390787658482L, -115.840065030737L), "OI7581576564: lat:27.8390787658482,lng:-115.840065030737");
  location_is(geohex_get_zone_by_code("RX1535370770").location, geohex_location(47.9898422067599L, -108.281257938322L), "RX1535370770: lat:47.9898422067599,lng:-108.281257938322");
  location_is(geohex_get_zone_by_code("SV7031782060").location, geohex_location(67.742776208542L, -72.7734593303866L), "SV7031782060: lat:67.742776208542,lng:-72.7734593303866");
  location_is(geohex_get_zone_by_code("SW6431665682").location, geohex_location(71.3007621712053L, -85.9570864874934L), "SW6431665682: lat:71.3007621712053,lng:-85.9570864874934");
  location_is(geohex_get_zone_by_code("aX1617612856").location, geohex_location(76.6392532146874L, 17.402496231943L), "aX1617612856: lat:76.6392532146874,lng:17.402496231943");
  location_is(geohex_get_zone_by_code("aX7255422107").location, geohex_location(78.4804053281635L, 21.1586987078528L), "aX7255422107: lat:78.4804053281635,lng:21.1586987078528");
  location_is(geohex_get_zone_by_code("ZA7323011017").location, geohex_location(75.4088528400187L, 127.617063794476L), "ZA7323011017: lat:75.4088528400187,lng:127.617063794476");
  location_is(geohex_get_zone_by_code("TK0130411728").location, geohex_location(80.1399718555572L, 178.482954834121L), "TK0130411728: lat:80.1399718555572,lng:178.482954834121");
  location_is(geohex_get_zone_by_code("TK8071386820").location, geohex_location(82.4189123646549L, -179.407610628461L), "TK8071386820: lat:82.4189123646549,lng:-179.407610628461");
  location_is(geohex_get_zone_by_code("TO4434206021").location, geohex_location(84.3837958331987L, -179.407949330217L), "TO4434206021: lat:84.3837958331987,lng:-179.407949330217");
  location_is(geohex_get_zone_by_code("bb3372146218").location, geohex_location(85.0511319305883L, 89.0646751003404L), "bb3372146218: lat:85.0511319305883,lng:89.0646751003404");
  location_is(geohex_get_zone_by_code("BV57264048634").location, geohex_location(-85.0207078240758L, -85.429727853139L), "BV57264048634: lat:-85.0207078240758,lng:-85.429727853139");
  location_is(geohex_get_zone_by_code("CI57246068382").location, geohex_location(-85.0207078240758L, 114.257763326503L), "CI57246068382: lat:-85.0207078240758,lng:114.257763326503");
  location_is(geohex_get_zone_by_code("DO05443747884").location, geohex_location(-85.0207078240758L, 177.890565462582L), "DO05443747884: lat:-85.0207078240758,lng:177.890565462582");
  location_is(geohex_get_zone_by_code("DO04773823048").location, geohex_location(-85.0813594239177L, -178.945282731291L), "DO04773823048: lat:-85.0813594239177,lng:-178.945282731291");
  location_is(geohex_get_zone_by_code("DO04773823048").location, geohex_location(-85.0813594239177L, -178.945282731291L), "DO04773823048: lat:-85.0813594239177,lng:-178.945282731291");
  location_is(geohex_get_zone_by_code("DO07200264504").location, geohex_location(-85.0511319305883L, -179.296855154194L), "DO07200264504: lat:-85.0511319305883,lng:-179.296855154194");
  location_is(geohex_get_zone_by_code("CZ34837816828").location, geohex_location(-78.2065501349361L, -13.0078409456553L), "CZ34837816828: lat:-78.2065501349361,lng:-13.0078409456553");
  location_is(geohex_get_zone_by_code("EU18781747622").location, geohex_location(-77.6928731694156L, 174.023381711234L), "EU18781747622: lat:-77.6928731694156,lng:174.023381711234");
  location_is(geohex_get_zone_by_code("EU47467037811").location, geohex_location(-77.282054177379L, -177.189904429654L), "EU47467037811: lat:-77.282054177379,lng:-177.189904429654");
  location_is(geohex_get_zone_by_code("Fb05827021141").location, geohex_location(-53.3308839964807L, -102.65621207246L), "Fb05827021141: lat:-53.3308839964807,lng:-102.65621207246");
  location_is(geohex_get_zone_by_code("OK72311284586").location, geohex_location(-47.7541256989525L, 62.5780848673701L), "OK72311284586: lat:-47.7541256989525,lng:62.5780848673701");
  location_is(geohex_get_zone_by_code("GH51383310718").location, geohex_location(-20.3034306596438L, -168.046876323054L), "GH51383310718: lat:-20.3034306596438,lng:-168.046876323054");
  location_is(geohex_get_zone_by_code("GI47416263465").location, geohex_location(-10.3514779944986L, -177.893049275461L), "GI47416263465: lat:-10.3514779944986,lng:-177.893049275461");
  location_is(geohex_get_zone_by_code("GI87045185255").location, geohex_location(-3.37512188767837L, -177.893049275461L), "GI87045185255: lat:-3.37512188767837,lng:-177.893049275461");
  location_is(geohex_get_zone_by_code("QU07002763476").location, geohex_location(4.00257302944338L, -177.893049275461L), "QU07002763476: lat:4.00257302944338,lng:-177.893049275461");
  location_is(geohex_get_zone_by_code("QU85663663436").location, geohex_location(20.055949967828L, 179.912163344567L), "QU85663663436: lat:20.055949967828,lng:179.912163344567");
  location_is(geohex_get_zone_by_code("QU84201138888").location, geohex_location(18.5629380736087L, 178.417924096936L), "QU84201138888: lat:18.5629380736087,lng:178.417924096936");
  location_is(geohex_get_zone_by_code("PS62147032100").location, geohex_location(22.1060119680404L, 128.232484885434L), "PS62147032100: lat:22.1060119680404,lng:128.232484885434");
  location_is(geohex_get_zone_by_code("XM30178015132").location, geohex_location(26.9477158562438L, 146.159743038268L), "XM30178015132: lat:26.9477158562438,lng:146.159743038268");
  location_is(geohex_get_zone_by_code("XM60054311737").location, geohex_location(29.8846565432607L, 153.103129039724L), "XM60054311737: lat:29.8846565432607,lng:153.103129039724");
  location_is(geohex_get_zone_by_code("XM44560457183").location, geohex_location(32.9901988529811L, 139.746086583459L), "XM44560457183: lat:32.9901988529811,lng:139.746086583459");
  location_is(geohex_get_zone_by_code("XM56456700534").location, geohex_location(36.0012826988468L, 137.722230689766L), "XM56456700534: lat:36.0012826988468,lng:137.722230689766");
  location_is(geohex_get_zone_by_code("XX03131786872").location, geohex_location(43.3251683966725L, 141.679734909426L), "XX03131786872: lat:43.3251683966725,lng:141.679734909426");
  location_is(geohex_get_zone_by_code("PZ16386410216").location, geohex_location(38.8225666991148L, 38.6718375134775L), "PZ16386410216: lat:38.8225666991148,lng:38.6718375134775");
  location_is(geohex_get_zone_by_code("OI78178446320").location, geohex_location(28.1166575001496L, -113.82072516046L), "OI78178446320: lat:28.1166575001496,lng:-113.82072516046");
  location_is(geohex_get_zone_by_code("RX13217487787").location, geohex_location(46.4121846565377L, -106.086357657764L), "RX13217487787: lat:46.4121846565377,lng:-106.086357657764");
  location_is(geohex_get_zone_by_code("SV40163034106").location, geohex_location(66.2314755568993L, -80.1562544101791L), "SV40163034106: lat:66.2314755568993,lng:-80.1562544101791");
  location_is(geohex_get_zone_by_code("aX41314430862").location, geohex_location(77.1571535655358L, 18.2812014880297L), "aX41314430862: lat:77.1571535655358,lng:18.2812014880297");
  location_is(geohex_get_zone_by_code("ZA47238521110").location, geohex_location(75.1407657617551L, 120.937526461075L), "ZA47238521110: lat:75.1407657617551,lng:120.937526461075");
  location_is(geohex_get_zone_by_code("TK11857485652").location, geohex_location(81.060173533092L, 170.944921449418L), "TK11857485652: lat:81.060173533092,lng:170.944921449418");
  location_is(geohex_get_zone_by_code("TK43222807032").location, geohex_location(81.4868096473096L, -179.91453425686L), "TK43222807032: lat:81.4868096473096,lng:-179.91453425686");
  location_is(geohex_get_zone_by_code("TO03574622544").location, geohex_location(83.549846703706L, -178.242137885485L), "TO03574622544: lat:83.549846703706,lng:-178.242137885485");
  location_is(geohex_get_zone_by_code("TO54114446763").location, geohex_location(84.7383877196727L, 172.353582053323L), "TO54114446763: lat:84.7383877196727,lng:172.353582053323");
  location_is(geohex_get_zone_by_code("bb33540877533").location, geohex_location(85.0504177407821L, 88.1597769084433L), "bb33540877533: lat:85.0504177407821,lng:88.1597769084433");
  location_is(geohex_get_zone_by_code("BV803254745602").location, geohex_location(-85.0506539409143L, -79.8266599678986L), "BV803254745602: lat:-85.0506539409143,lng:-79.8266599678986");
  location_is(geohex_get_zone_by_code("CI803456424553").location, geohex_location(-85.0511281818288L, 120.706795298067L), "CI803456424553: lat:-85.0511281818288,lng:120.706795298067");
  location_is(geohex_get_zone_by_code("DO053652024200").location, geohex_location(-85.0520746536551L, 178.868397432641L), "DO053652024200: lat:-85.0520746536551,lng:178.868397432641");
  location_is(geohex_get_zone_by_code("DO053654462750").location, geohex_location(-85.0511300562089L, 178.934331374508L), "DO053654462750: lat:-85.0511300562089,lng:178.934331374508");
  location_is(geohex_get_zone_by_code("DO071704644727").location, geohex_location(-85.0511300562089L, -178.253164509325L), "DO071704644727: lat:-85.0511300562089,lng:-178.253164509325");
  location_is(geohex_get_zone_by_code("CY281612610161").location, geohex_location(-79.4452281268277L, -13.7023300799148L), "CY281612610161: lat:-79.4452281268277,lng:-13.7023300799148");
  location_is(geohex_get_zone_by_code("EU181655132036").location, geohex_location(-77.9156668295562L, 172.968739709582L), "EU181655132036: lat:-77.9156668295562,lng:172.968739709582");
  location_is(geohex_get_zone_by_code("EU832016181016").location, geohex_location(-76.1849928085699L, -179.296892787722L), "EU832016181016: lat:-76.1849928085699,lng:-179.296892787722");
  location_is(geohex_get_zone_by_code("FY636801583240").location, geohex_location(-57.3643607170673L, -102.999204050873L), "FY636801583240: lat:-57.3643607170673,lng:-102.999204050873");
  location_is(geohex_get_zone_by_code("OK446658243285").location, geohex_location(-49.8379914216003L, 61.875015288621L), "OK446658243285: lat:-49.8379914216003,lng:61.875015288621");
  location_is(geohex_get_zone_by_code("GH058068815001").location, geohex_location(-27.7456248838545L, -162.061715223327L), "GH058068815001: lat:-27.7456248838545,lng:-162.061715223327");
  location_is(geohex_get_zone_by_code("GI410587505268").location, geohex_location(-13.3082139354019L, 177.547686384754L), "GI410587505268: lat:-13.3082139354019,lng:177.547686384754");
  location_is(geohex_get_zone_by_code("GI871735246286").location, geohex_location(-2.88144572833833L, -178.233595074524L), "GI871735246286: lat:-2.88144572833833,lng:-178.233595074524");
  location_is(geohex_get_zone_by_code("QU460311054340").location, geohex_location(10.4188204977908L, -175.421090958357L), "QU460311054340: lat:10.4188204977908,lng:-175.421090958357");
  location_is(geohex_get_zone_by_code("QU533828300764").location, geohex_location(13.8553074459289L, 176.141396693142L), "QU533828300764: lat:13.8553074459289,lng:176.141396693142");
  location_is(geohex_get_zone_by_code("OY313181386161").location, geohex_location(-5.61599033370547L, 4.92186338652833L), "OY313181386161: lat:-5.61599033370547,lng:4.92186338652833");
  location_is(geohex_get_zone_by_code("OY803527038734").location, geohex_location(4.84592692914741L, 0.360152867392618L), "OY803527038734: lat:4.84592692914741,lng:0.360152867392618");
  location_is(geohex_get_zone_by_code("PA043284261600").location, geohex_location(3.51340761034611L, -59.7656183847313L), "PA043284261600: lat:3.51340761034611,lng:-59.7656183847313");
  location_is(geohex_get_zone_by_code("PZ060785824214").location, geohex_location(35.4035204139484L, 44.6570362467329L), "PZ060785824214: lat:35.4035204139484,lng:44.6570362467329");
  location_is(geohex_get_zone_by_code("PS625060382624").location, geohex_location(22.5937282950056L, 128.320321540867L), "PS625060382624: lat:22.5937282950056,lng:128.320321540867");
  location_is(geohex_get_zone_by_code("XM317558565378").location, geohex_location(28.860201911666L, 144.852354259457L), "XM317558565378: lat:28.860201911666,lng:144.852354259457");
  location_is(geohex_get_zone_by_code("XL822458403751").location, geohex_location(29.4741720666166L, 153.992973820236L), "XL822458403751: lat:29.4741720666166,lng:153.992973820236");
  location_is(geohex_get_zone_by_code("XP251226173262").location, geohex_location(42.5014003119232L, 143.09452977847L), "XP251226173262: lat:42.5014003119232,lng:143.09452977847");
  location_is(geohex_get_zone_by_code("OI745463230145").location, geohex_location(26.3684008192149L, -113.897648092639L), "OI745463230145: lat:26.3684008192149,lng:-113.897648092639");
  location_is(geohex_get_zone_by_code("RU681285781273").location, geohex_location(43.5295623488747L, -107.921067437401L), "RU681285781273: lat:43.5295623488747,lng:-107.921067437401");
  location_is(geohex_get_zone_by_code("SV352321156833").location, geohex_location(66.3727524112604L, -76.9921778711089L), "SV352321156833: lat:66.3727524112604,lng:-76.9921778711089");
  location_is(geohex_get_zone_by_code("ZA412658306821").location, geohex_location(74.4964152417361L, 116.718732653295L), "ZA412658306821: lat:74.4964152417361,lng:116.718732653295");
  location_is(geohex_get_zone_by_code("aX413323833627").location, geohex_location(77.1571583951234L, 18.6328115444612L), "aX413323833627: lat:77.1571583951234,lng:18.6328115444612");
  location_is(geohex_get_zone_by_code("bD023073480358").location, geohex_location(82.1183811913695L, -43.5937385335343L), "bD023073480358: lat:82.1183811913695,lng:-43.5937385335343");
  location_is(geohex_get_zone_by_code("TK570232153327").location, geohex_location(82.2616990393759L, 175.078136613472L), "TK570232153327: lat:82.2616990393759,lng:175.078136613472");
  location_is(geohex_get_zone_by_code("TK800808780528").location, geohex_location(82.2994994540443L, -179.99141955551L), "TK800808780528: lat:82.2994994540443,lng:-179.99141955551");
  location_is(geohex_get_zone_by_code("TO328348003525").location, geohex_location(84.1177870218545L, -177.530450228718L), "TO328348003525: lat:84.1177870218545,lng:-177.530450228718");
  location_is(geohex_get_zone_by_code("TO563763855337").location, geohex_location(84.7641316664413L, 178.953900809309L), "TO563763855337: lat:84.7641316664413,lng:178.953900809309");
  location_is(geohex_get_zone_by_code("bb337212207184").location, geohex_location(85.0508901298028L, 88.9810157665667L), "bb337212207184: lat:85.0508901298028,lng:88.9810157665667");
  location_is(geohex_get_zone_by_code("BV8046354823266").location, geohex_location(-85.0207078240758L, -79.4531221088826L), "BV8046354823266: lat:-85.0207078240758,lng:-79.4531221088826");
  location_is(geohex_get_zone_by_code("CI5803560714155").location, geohex_location(-84.9901003159816L, 113.554681203244L), "CI5803560714155: lat:-84.9901003159816,lng:113.554681203244");
  location_is(geohex_get_zone_by_code("DO0482706175341").location, geohex_location(-85.0539714267038L, 179.604496704871L), "DO0482706175341: lat:-85.0539714267038,lng:179.604496704871");
  location_is(geohex_get_zone_by_code("DO0482731186381").location, geohex_location(-85.0530234431386L, 179.604496704871L), "DO0482731186381: lat:-85.0530234431386,lng:179.604496704871");
  location_is(geohex_get_zone_by_code("DO0485035421662").location, geohex_location(-85.0520765276776L, 179.769281381502L), "DO0485035421662: lat:-85.0520765276776,lng:179.769281381502");
  location_is(geohex_get_zone_by_code("DO0485060618642").location, geohex_location(-85.0520765276776L, 179.813237342747L), "DO0485060618642: lat:-85.0520765276776,lng:179.813237342747");
  location_is(geohex_get_zone_by_code("DO0485068654767").location, geohex_location(-85.050180904493L, 179.813237342747L), "DO0485068654767: lat:-85.050180904493,lng:179.813237342747");
  location_is(geohex_get_zone_by_code("DO0712537663424").location, geohex_location(-85.0520765276776L, -179.049678139248L), "DO0712537663424: lat:-85.0520765276776,lng:-179.049678139248");
  location_is(geohex_get_zone_by_code("DO0712564265481").location, geohex_location(-85.0511288066223L, -179.044196188602L), "DO0712564265481: lat:-85.0511288066223,lng:-179.044196188602");
  location_is(geohex_get_zone_by_code("EU4501241604860").location, geohex_location(-77.5041200412389L, 177.363282095284L), "EU4501241604860: lat:-77.5041200412389,lng:177.363282095284");
  location_is(geohex_get_zone_by_code("EU8407181150325").location, geohex_location(-75.9725790013535L, -179.848575225974L), "EU8407181150325: lat:-75.9725790013535,lng:-179.848575225974");
  location_is(geohex_get_zone_by_code("CZ3061211527483").location, geohex_location(-78.9039285182458L, -12.3046835553398L), "CZ3061211527483: lat:-78.9039285182458,lng:-12.3046835553398");
  location_is(geohex_get_zone_by_code("Fb4625116215430").location, geohex_location(-49.8379867504928L, -97.3828138965567L), "Fb4625116215430: lat:-49.8379867504928,lng:-97.3828138965567");
  location_is(geohex_get_zone_by_code("OK7250326542858").location, geohex_location(-47.2792283362341L, 61.5234428657179L), "OK7250326542858: lat:-47.2792283362341,lng:61.5234428657179");
  location_is(geohex_get_zone_by_code("GH4221515066426").location, geohex_location(-22.5937282950056L, -166.289064386577L), "GH4221515066426: lat:-22.5937282950056,lng:-166.289064386577");
  location_is(geohex_get_zone_by_code("GI4421818162227").location, geohex_location(-11.5230815941884L, 178.242188063523L), "GI4421818162227: lat:-11.5230815941884,lng:178.242188063523");
  location_is(geohex_get_zone_by_code("GI8724851414563").location, geohex_location(-2.46017683242058L, -179.296880243213L), "GI8724851414563: lat:-2.46017683242058,lng:-179.296880243213");
  location_is(geohex_get_zone_by_code("QU4074815410453").location, geohex_location(9.44905955464005L, -179.296880243213L), "QU4074815410453: lat:9.44905955464005,lng:-179.296880243213");
  location_is(geohex_get_zone_by_code("QU8810462030471").location, geohex_location(20.6327832254127L, 179.296880243213L), "QU8810462030471: lat:20.6327832254127,lng:179.296880243213");
  location_is(geohex_get_zone_by_code("PA0414822216031").location, geohex_location(3.51342206827281L, -60.8203105644214L), "PA0414822216031: lat:3.51342206827281,lng:-60.8203105644214");
  location_is(geohex_get_zone_by_code("OY4236836048713").location, geohex_location(-0.351559672202227L, -3.1640639945607L), "OY4236836048713: lat:-0.351559672202227,lng:-3.1640639945607");
  location_is(geohex_get_zone_by_code("OY7001555744550").location, geohex_location(0.355579225307545L, 6.30376655169624L), "OY7001555744550: lat:0.355579225307545,lng:6.30376655169624");
  location_is(geohex_get_zone_by_code("XM4117607703260").location, geohex_location(31.3536426919945L, 137.460941101646L), "XM4117607703260: lat:31.3536426919945,lng:137.460941101646");
  location_is(geohex_get_zone_by_code("PS6246856326218").location, geohex_location(22.5937216082807L, 129.375001176048L), "PS6246856326218: lat:22.5937216082807,lng:129.375001176048");
  location_is(geohex_get_zone_by_code("XL5887834871345").location, geohex_location(29.2323948384434L, 153.608459515418L), "XL5887834871345: lat:29.2323948384434,lng:153.608459515418");
  location_is(geohex_get_zone_by_code("XX0066438378463").location, geohex_location(42.8144673119628L, 142.006895716865L), "XX0066438378463: lat:42.8144673119628,lng:142.006895716865");
  location_is(geohex_get_zone_by_code("PZ4537105130820").location, geohex_location(42.5530775978963L, 38.671875147006L), "PZ4537105130820: lat:42.5530775978963,lng:38.671875147006");
  location_is(geohex_get_zone_by_code("OI8337351073052").location, geohex_location(27.9979498544657L, -116.74310663523L), "OI8337351073052: lat:27.9979498544657,lng:-116.74310663523");
  location_is(geohex_get_zone_by_code("RX1135780670728").location, geohex_location(46.3193563989732L, -108.305606831238L), "RX1135780670728: lat:46.3193563989732,lng:-108.305606831238");
  location_is(geohex_get_zone_by_code("SV4163853373183").location, geohex_location(66.9300595885603L, -80.5078142885727L), "SV4163853373183: lat:66.9300595885603,lng:-80.5078142885727");
  location_is(geohex_get_zone_by_code("aX4034808877353").location, geohex_location(76.9206130161942L, 20.7421833593318L), "aX4034808877353: lat:76.9206130161942,lng:20.7421833593318");
  location_is(geohex_get_zone_by_code("ZA4726354081160").location, geohex_location(75.1407787630141L, 121.289061250449L), "ZA4726354081160: lat:75.1407787630141,lng:121.289061250449");
  location_is(geohex_get_zone_by_code("bD0853382488383").location, geohex_location(82.5861070130518L, -40.4296870834831L), "bD0853382488383: lat:82.5861070130518,lng:-40.4296870834831");
  location_is(geohex_get_zone_by_code("TK2756770452053").location, geohex_location(81.9231872532598L, 168.749996079841L), "TK2756770452053: lat:81.9231872532598,lng:168.749996079841");
  location_is(geohex_get_zone_by_code("TK7434850466772").location, geohex_location(82.1664454970882L, -172.617192375698L), "TK7434850466772: lat:82.1664454970882,lng:-172.617192375698");
  location_is(geohex_get_zone_by_code("TO0846631354832").location, geohex_location(83.9054847012108L, -179.321229136129L), "TO0846631354832: lat:83.9054847012108,lng:-179.321229136129");
  location_is(geohex_get_zone_by_code("TO4805277813220").location, geohex_location(84.6082183424529L, 179.624078684181L), "TO4805277813220: lat:84.6082183424529,lng:179.624078684181");
  location_is(geohex_get_zone_by_code("bb3356324634667").location, geohex_location(85.0510988164485L, 88.6768365005084L), "bb3356324634667: lat:85.0510988164485,lng:88.6768365005084");
  location_is(geohex_get_zone_by_code("BV80717180121576").location, geohex_location(-84.9901003159816L, -79.4531262903858L), "BV80717180121576: lat:-84.9901003159816,lng:-79.4531262903858");
  location_is(geohex_get_zone_by_code("CI56436210413512").location, geohex_location(-85.1412838495068L, 118.125001437392L), "CI56436210413512: lat:-85.1412838495068,lng:118.125001437392");
  location_is(geohex_get_zone_by_code("CI56773820550701").location, geohex_location(-85.0813645988L, 118.828125375682L), "CI56773820550701: lat:-85.0813645988,lng:118.828125375682");
  location_is(geohex_get_zone_by_code("CI80611150250021").location, geohex_location(-85.0359414559233L, 121.113283402004L), "CI80611150250021: lat:-85.0359414559233,lng:121.113283402004");
  location_is(geohex_get_zone_by_code("DO05167224507116").location, geohex_location(-85.0511288066223L, 177.539064125233L), "DO05167224507116: lat:-85.0511288066223,lng:177.539064125233");
  location_is(geohex_get_zone_by_code("DO05405867244763").location, geohex_location(-85.0359414559233L, 177.714846155181L), "DO05405867244763: lat:-85.0359414559233,lng:177.714846155181");
  location_is(geohex_get_zone_by_code("DO07170215584802").location, geohex_location(-85.0513655976696L, -178.339692354268L), "DO07170215584802: lat:-85.0513655976696,lng:-178.339692354268");
  location_is(geohex_get_zone_by_code("DO07170226100057").location, geohex_location(-85.0512473076884L, -178.339692354268L), "DO07170226100057: lat:-85.0512473076884,lng:-178.339692354268");
  location_is(geohex_get_zone_by_code("DO07170227640163").location, geohex_location(-85.0510103027256L, -178.339692354268L), "DO07170227640163: lat:-85.0510103027256,lng:-178.339692354268");
  location_is(geohex_get_zone_by_code("EU16473602511456").location, geohex_location(-78.3494107814607L, 178.154297048549L), "EU16473602511456: lat:-78.3494107814607,lng:178.154297048549");
  location_is(geohex_get_zone_by_code("EU40673078217161").location, geohex_location(-78.090100386109L, -178.182430201827L), "EU40673078217161: lat:-78.090100386109,lng:-178.182430201827");
  location_is(geohex_get_zone_by_code("CZ31831222362536").location, geohex_location(-78.4905515036907L, -15.4687517314037L), "CZ31831222362536: lat:-78.4905515036907,lng:-15.4687517314037");
  location_is(geohex_get_zone_by_code("Fb31200035818717").location, geohex_location(-53.3308739043117L, -97.03124983666L), "Fb31200035818717: lat:-53.3308739043117,lng:-97.03124983666");
  location_is(geohex_get_zone_by_code("OK44243402806508").location, geohex_location(-49.9256554602755L, 58.5949145812988L), "OK44243402806508: lat:-49.9256554602755,lng:58.5949145812988");
  location_is(geohex_get_zone_by_code("OY01571576207503").location, geohex_location(-8.40717011846787L, -2.81249993466401L), "OY01571576207503: lat:-8.40717011846787,lng:-2.81249993466401");
  location_is(geohex_get_zone_by_code("OY56733420402656").location, geohex_location(4.07924016937264L, -1.17070798493572L), "OY56733420402656: lat:4.07924016937264,lng:-1.17070798493572");
  location_is(geohex_get_zone_by_code("GH84065825033010").location, geohex_location(-15.961327113736L, -159.609376519062L), "GH84065825033010: lat:-15.961327113736,lng:-159.609376519062");
  location_is(geohex_get_zone_by_code("GI50342481388451").location, geohex_location(-10.6215671070542L, 173.907416084026L), "GI50342481388451: lat:-10.6215671070542,lng:173.907416084026");
  location_is(geohex_get_zone_by_code("GI78081171860100").location, geohex_location(-5.75137803894654L, -173.436336300737L), "GI78081171860100: lat:-5.75137803894654,lng:-173.436336300737");
  location_is(geohex_get_zone_by_code("QU30541311610415").location, geohex_location(5.48056395352803L, -174.139460239027L), "QU30541311610415: lat:5.48056395352803,lng:-174.139460239027");
  location_is(geohex_get_zone_by_code("QU44828780263624").location, geohex_location(12.4217229393468L, 179.532415953355L), "QU44828780263624: lat:12.4217229393468,lng:179.532415953355");
  location_is(geohex_get_zone_by_code("PA07571045254517").location, geohex_location(5.61598552849713L, -58.3593746896541L), "PA07571045254517: lat:5.61598552849713,lng:-58.3593746896541");
  location_is(geohex_get_zone_by_code("PS38383877824230").location, geohex_location(21.1625456924414L, 127.501165071319L), "PS38383877824230: lat:21.1625456924414,lng:127.501165071319");
  location_is(geohex_get_zone_by_code("XM31385143063872").location, geohex_location(28.1845199888993L, 145.079288617593L), "XM31385143063872: lat:28.1845199888993,lng:145.079288617593");
  location_is(geohex_get_zone_by_code("XL82447011727335").location, geohex_location(29.4167803980054L, 155.626164417959L), "XL82447011727335: lat:29.4167803980054,lng:155.626164417959");
  location_is(geohex_get_zone_by_code("XP22503400845082").location, geohex_location(41.9318330553567L, 141.563664744639L), "XP22503400845082: lat:41.9318330553567,lng:141.563664744639");
  location_is(geohex_get_zone_by_code("PZ13526267300787").location, geohex_location(38.2726896879521L, 34.4531231542584L), "PZ13526267300787: lat:38.2726896879521,lng:34.4531231542584");
  location_is(geohex_get_zone_by_code("OI78437338044154").location, geohex_location(28.1845199888993L, -112.967585614709L), "OI78437338044154: lat:28.1845199888993,lng:-112.967585614709");
  location_is(geohex_get_zone_by_code("RU68880348017456").location, geohex_location(44.4934919612046L, -106.639461807091L), "RU68880348017456: lat:44.4934919612046,lng:-106.639461807091");
  location_is(geohex_get_zone_by_code("SV13411223332736").location, geohex_location(65.3100644125332L, -84.8425862680691L), "SV13411223332736: lat:65.3100644125332,lng:-84.8425862680691");
  location_is(geohex_get_zone_by_code("aX38226176387034").location, geohex_location(77.2826026619556L, 24.8449153653306L), "aX38226176387034: lat:77.2826026619556,lng:24.8449153653306");
  location_is(geohex_get_zone_by_code("ZA35122807551718").location, geohex_location(74.019543697314L, 123.046873186926L), "ZA35122807551718: lat:74.019543697314,lng:123.046873186926");
  location_is(geohex_get_zone_by_code("bD32858648748733").location, geohex_location(82.8533821663417L, -37.9687512087158L), "bD32858648748733: lat:82.8533821663417,lng:-37.9687512087158");
  location_is(geohex_get_zone_by_code("TK18678460283758").location, geohex_location(81.5182721593058L, 175.078124068962L), "TK18678460283758: lat:81.5182721593058,lng:175.078124068962");
  location_is(geohex_get_zone_by_code("TK35253726505866").location, geohex_location(81.3083208364443L, -177.187500065336L), "TK35253726505866: lat:81.3083208364443,lng:-177.187500065336");
  location_is(geohex_get_zone_by_code("TO35083224064751").location, geohex_location(84.1110299538592L, -175.545712297111L), "TO35083224064751: lat:84.1110299538592,lng:-175.545712297111");
  location_is(geohex_get_zone_by_code("TO45177603556405").location, geohex_location(84.528402680729L, 177.423039956981L), "TO45177603556405: lat:84.528402680729,lng:177.423039956981");
  location_is(geohex_get_zone_by_code("bb33563401287846").location, geohex_location(85.0501290364617L, 88.7193205726401L), "bb33563401287846: lat:85.0501290364617,lng:88.7193205726401");
  location_is(geohex_get_zone_by_code("bb33563422636071").location, geohex_location(85.0511285983578L, 88.7024983854171L), "bb33563422636071: lat:85.0511285983578,lng:88.7024983854171");
  location_is(geohex_get_zone_by_code("BV801644720107680").location, geohex_location(-85.0549183272694L, -80.2441412436501L), "BV801644720107680: lat:-85.0549183272694,lng:-80.2441412436501");
  location_is(geohex_get_zone_by_code("BV801672224571144").location, geohex_location(-85.0511288066223L, -80.2441412436502L), "BV801672224571144: lat:-85.0511288066223,lng:-80.2441412436502");
  location_is(geohex_get_zone_by_code("BV752066087034602").location, geohex_location(-85.0435409337982L, -76.8164069918357L), "BV752066087034602: lat:-85.0435409337982,lng:-76.8164069918357");
  location_is(geohex_get_zone_by_code("CI584051202811030").location, geohex_location(-84.928320892294L, 113.203125506354L), "CI584051202811030: lat:-84.928320892294,lng:113.203125506354");
  location_is(geohex_get_zone_by_code("DO053702425073344").location, geohex_location(-85.0511288066223L, 178.70361275601L), "DO053702425073344: lat:-85.0511288066223,lng:178.70361275601");
  location_is(geohex_get_zone_by_code("DO053474671871414").location, geohex_location(-85.0510103027256L, 178.621216236191L), "DO053474671871414: lat:-85.0510103027256,lng:178.621216236191");
  location_is(geohex_get_zone_by_code("DO048672464801367").location, geohex_location(-85.0511287372008L, -179.472656697824L), "DO048672464801367: lat:-85.0511287372008,lng:-179.472656697824");
  location_is(geohex_get_zone_by_code("DO048680771383421").location, geohex_location(-85.0492328907034L, -179.494629103109L), "DO048680771383421: lat:-85.0492328907034,lng:-179.494629103109");
  location_is(geohex_get_zone_by_code("CZ312460160330640").location, geohex_location(-78.6300054838506L, -16.8749996079841L), "CZ312460160330640: lat:-78.6300054838506,lng:-16.8749996079841");
  location_is(geohex_get_zone_by_code("EU482446631807432").location, geohex_location(-76.999935022208L, 178.593749335751L), "EU482446631807432: lat:-76.999935022208,lng:178.593749335751");
  location_is(geohex_get_zone_by_code("EU443120677000135").location, geohex_location(-77.6928704249372L, -179.648437333938L), "EU443120677000135: lat:-77.6928704249372,lng:-179.648437333938");
  location_is(geohex_get_zone_by_code("OK486263022716030").location, geohex_location(-48.2246730188235L, 61.1718746243181L), "OK486263022716030: lat:-48.2246730188235,lng:61.1718746243181");
  location_is(geohex_get_zone_by_code("Fb563137601173436").location, geohex_location(-47.7540981063495L, -101.601563101636L), "Fb563137601173436: lat:-47.7540981063495,lng:-101.601563101636");
  location_is(geohex_get_zone_by_code("GH405610617770460").location, geohex_location(-24.5271350911522L, -160.312500457352L), "GH405610617770460: lat:-24.5271350911522,lng:-160.312500457352");
  location_is(geohex_get_zone_by_code("GI428447007470857").location, geohex_location(-10.6278115337404L, 175.58411661599L), "GI428447007470857: lat:-10.6278115337404,lng:175.58411661599");
  location_is(geohex_get_zone_by_code("GI714676472576137").location, geohex_location(-8.89551999396073L, -174.923695581831L), "GI714676472576137: lat:-8.89551999396073,lng:-174.923695581831");
  location_is(geohex_get_zone_by_code("QU430846555413857").location, geohex_location(9.65531381002921L, -177.736195516495L), "QU430846555413857: lat:9.65531381002921,lng:-177.736195516495");
  location_is(geohex_get_zone_by_code("QU455868523435074").location, geohex_location(13.4537364543428L, 177.187500065336L), "QU455868523435074: lat:13.4537364543428,lng:177.187500065336");
  location_is(geohex_get_zone_by_code("XM314886135481601").location, geohex_location(28.6134589449893L, 144.49218745372L), "XM314886135481601: lat:28.6134589449893,lng:144.49218745372");
  location_is(geohex_get_zone_by_code("PS624076167125758").location, geohex_location(22.2687638719617L, 129.023437116151L), "PS624076167125758: lat:22.2687638719617,lng:129.023437116151");
  location_is(geohex_get_zone_by_code("XL828827023882162").location, geohex_location(30.4016609083307L, 155.413218581736L), "XL828827023882162: lat:30.4016609083307,lng:155.413218581736");
  location_is(geohex_get_zone_by_code("XP252183615213788").location, geohex_location(42.7715133490935L, 142.756969572665L), "XP252183615213788: lat:42.7715133490935,lng:142.756969572665");
  location_is(geohex_get_zone_by_code("OY441655876848342").location, geohex_location(-0.351559672202227L, -0.3515626660623L), "OY441655876848342: lat:-0.351559672202227,lng:-0.3515626660623");
  location_is(geohex_get_zone_by_code("OY450583438341310").location, geohex_location(0.648591011156901L, -2.43834321317993L), "OY450583438341310: lat:0.648591011156901,lng:-2.43834321317993");
  location_is(geohex_get_zone_by_code("PA007023204648554").location, geohex_location(1.40610876244213L, -59.414062687841L), "PA007023204648554: lat:1.40610876244213,lng:-59.414062687841");
  location_is(geohex_get_zone_by_code("OI754343508378851").location, geohex_location(27.0105635750312L, -115.289906053472L), "OI754343508378851: lat:27.0105635750312,lng:-115.289906053472");
  location_is(geohex_get_zone_by_code("RX153284780083552").location, geohex_location(47.9899213773606L, -108.632812241378L), "RX153284780083552: lat:47.9899213773606,lng:-108.632812241378");
  location_is(geohex_get_zone_by_code("PZ541437131806627").location, geohex_location(44.3395652778466L, 32.6953126116156L), "PZ541437131806627: lat:44.3395652778466,lng:32.6953126116156");
  location_is(geohex_get_zone_by_code("SV081012647253500").location, geohex_location(65.0721300584619L, -80.8593741669662L), "SV081012647253500: lat:65.0721300584619,lng:-80.8593741669662");
  location_is(geohex_get_zone_by_code("ZA162768706170274").location, geohex_location(73.8248204104306L, 116.718749379308L), "ZA162768706170274: lat:73.8248204104306,lng:116.718749379308");
  location_is(geohex_get_zone_by_code("aX538661552510561").location, geohex_location(78.278201510129L, 16.1718742758595L), "aX538661552510561: lat:78.278201510129,lng:16.1718742758595");
  location_is(geohex_get_zone_by_code("bD475537206875044").location, geohex_location(83.4000421247319L, -38.671875147006L), "bD475537206875044: lat:83.4000421247319,lng:-38.671875147006");
  location_is(geohex_get_zone_by_code("TK573170435224014").location, geohex_location(82.3088924126117L, 176.132812067149L), "TK573170435224014: lat:82.3088924126117,lng:176.132812067149");
  location_is(geohex_get_zone_by_code("TK720137660817775").location, geohex_location(82.0700282925013L, -177.890625397461L), "TK720137660817775: lat:82.0700282925013,lng:-177.890625397461");
  location_is(geohex_get_zone_by_code("TO078855632751174").location, geohex_location(83.8992664879405L, -177.868031342039L), "TO078855632751174: lat:83.8992664879405,lng:-177.868031342039");
  location_is(geohex_get_zone_by_code("TO448407012467243").location, geohex_location(84.5025950756702L, -179.977405944578L), "TO448407012467243: lat:84.5025950756702,lng:-179.977405944578");
  location_is(geohex_get_zone_by_code("TO801157747467437").location, geohex_location(84.8609006356526L, 178.967906057235L), "TO801157747467437: lat:84.8609006356526,lng:178.967906057235");
  location_is(geohex_get_zone_by_code("bb337184418811744").location, geohex_location(85.0511250578605L, 89.3795297439729L), "bb337184418811744: lat:85.0511250578605,lng:89.3795297439729");
}

void code2xy (void) {
  // verify
  ok(geohex_verify_code("XM") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EX2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aZ2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI76") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU06") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU13") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH32") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK51") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL60") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ18") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU88") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb17") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb34") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb86") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK63") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO42") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK02") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD31") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE73") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO84") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB61") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YF58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX15") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO045") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO056") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO077") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV778") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU570") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU868") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK468") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY443") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY004") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb526") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI440") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU026") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU630") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ580") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY864") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV385") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX355") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD744") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO808") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO474") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO073") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB648") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG168") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7541") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0532") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO3203") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU6235") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7172") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ0737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb0200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb8608") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI2651") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC2121") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7871") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4212") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4362") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OX2538") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY5663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OG6663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV8518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3246") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1825") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TR1202") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4054") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA5685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4881") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6270") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80373") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO08354") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU31135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU45042") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ35087") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK06445") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb80457") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH80422") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI74753") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI80240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU01265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU86344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY77334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY15454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04170") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS68342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM78145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM48257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03156") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ47685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40654") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI71873") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX40264") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA44552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD47117") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK51615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK71615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO38458") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO58484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV553581") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI802417") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI750110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO018862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053505") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO074664") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ351822") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU412420") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU708101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK847038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH501658") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI842644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI836575") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU316588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU175485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb711277") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY728344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA016372") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU408880") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM442337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS387785") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX037037") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ173676") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV321726") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC828583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI713375") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD080050") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX817100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA712478") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK166315") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK873482") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO433402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO586342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb335332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8032788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7714524") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0514686") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0517300") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732687") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732768") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4031833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8072131") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8255485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3800810") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1624776") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7464515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb5316746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4033527") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4540858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4351804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8387484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0706771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4884047") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8251271") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0565644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY8320288") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3556486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ8016814") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1746604") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6242083") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM5643552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6303820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM7851800") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0345653") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6306347") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8827707") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4253332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8776718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PF2148656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4587731") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4335020") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV5843218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0682573") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8100870") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4424804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE6100113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK5027217") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7070414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO6240542") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO7775738") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO5821675") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3371862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV54870250") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV78253862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57758513") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI75600226") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05603615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07152160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU41063674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU72201265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34762511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb38241503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK48511367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI32042116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI71565064") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH45442518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY33228746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA03278283") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU42174351") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU47122108") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM32230826") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56301016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS61272751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60832123") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU63124187") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03173236") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38755703") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ57757416") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fc51504013") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OW22586402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC52458806") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV20852101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX46486040") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA62754057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD28367162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK05722747") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK83151057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO31130720") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO51331450") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33488116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV804240512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI708565326") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI754848748") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO055580431") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053480025") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO073506567") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ347013544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU413474586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU354580674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK474555348") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb484868583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH147081657") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI730641802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI576514101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY041035522") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY537117080") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA402570238") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU058877078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU832828267") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ382714446") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ028668414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS383657231") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM602176827") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM482452815") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX033123366") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI860616105") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX114077466") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV355072242") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG413103084") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA486483578") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX426174078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX747576237") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK184816376") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO310523631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO423806423") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb303856635") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO815178640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV1700305142") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV5482764471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7560068257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5263615540") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7265571616") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7505181555") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5736546251") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0273028158") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0536546500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0716764500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4016113514") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4827777232") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU7445272188") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1777354303") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3420476772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4334484641") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH5856584625") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1730824803") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI7234521114") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU3851424320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8152020110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0426257051") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4244664644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7353226324") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3444432334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8136543688") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8831183154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6206841033") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM0565771230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4863207510") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0330807788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6054354111") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1548687734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ7555070851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI7581576564") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1535370770") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV7031782060") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6431665682") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX1617612856") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX7255422107") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA7323011017") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK0130411728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK8071386820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4434206021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3372146218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV57264048634") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57246068382") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05443747884") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07200264504") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34837816828") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU18781747622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU47467037811") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb05827021141") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK72311284586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH51383310718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47416263465") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI87045185255") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU07002763476") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU85663663436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU84201138888") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62147032100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM30178015132") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60054311737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM44560457183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56456700534") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03131786872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ16386410216") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78178446320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX13217487787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40163034106") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX41314430862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA47238521110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK11857485652") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK43222807032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO03574622544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO54114446763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33540877533") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV803254745602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI803456424553") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053652024200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053654462750") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO071704644727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CY281612610161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU181655132036") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU832016181016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("FY636801583240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK446658243285") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH058068815001") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI410587505268") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI871735246286") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU460311054340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU533828300764") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY313181386161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY803527038734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA043284261600") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ060785824214") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS625060382624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM317558565378") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL822458403751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP251226173262") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI745463230145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU681285781273") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV352321156833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA412658306821") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX413323833627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD023073480358") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK570232153327") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK800808780528") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO328348003525") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO563763855337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337212207184") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8046354823266") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5803560714155") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482706175341") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482731186381") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485035421662") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485060618642") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485068654767") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712537663424") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712564265481") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4501241604860") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8407181150325") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3061211527483") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4625116215430") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7250326542858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4221515066426") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4421818162227") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8724851414563") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4074815410453") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8810462030471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0414822216031") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4236836048713") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7001555744550") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4117607703260") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6246856326218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL5887834871345") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0066438378463") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4537105130820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8337351073052") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1135780670728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4163853373183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4034808877353") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4726354081160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD0853382488383") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK2756770452053") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7434850466772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO0846631354832") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4805277813220") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3356324634667") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80717180121576") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56436210413512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56773820550701") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI80611150250021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05167224507116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05405867244763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170215584802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170226100057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170227640163") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU16473602511456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU40673078217161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ31831222362536") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb31200035818717") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK44243402806508") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY01571576207503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY56733420402656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH84065825033010") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI50342481388451") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI78081171860100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU30541311610415") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU44828780263624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA07571045254517") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS38383877824230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM31385143063872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL82447011727335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP22503400845082") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ13526267300787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78437338044154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU68880348017456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV13411223332736") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX38226176387034") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA35122807551718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD32858648748733") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK18678460283758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK35253726505866") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO35083224064751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO45177603556405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563401287846") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563422636071") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801644720107680") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801672224571144") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV752066087034602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI584051202811030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053702425073344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053474671871414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048672464801367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048680771383421") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ312460160330640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU482446631807432") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU443120677000135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK486263022716030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb563137601173436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH405610617770460") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI428447007470857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI714676472576137") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU430846555413857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU455868523435074") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM314886135481601") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624076167125758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL828827023882162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP252183615213788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY441655876848342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY450583438341310") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA007023204648554") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI754343508378851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX153284780083552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ541437131806627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV081012647253500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA162768706170274") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX538661552510561") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD475537206875044") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK573170435224014") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK720137660817775") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO078855632751174") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO448407012467243") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO801157747467437") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337184418811744") == GEOHEX3_VERIFY_RESULT_SUCCESS);

  // code2xy
  coordinate_is(geohex_get_zone_by_code("XM").coordinate, geohex_coordinate(5L, -2L), "XM: x:5,y:-2");
  coordinate_is(geohex_get_zone_by_code("OY").coordinate, geohex_coordinate(0L, 0L), "OY: x:0,y:0");
  coordinate_is(geohex_get_zone_by_code("GI").coordinate, geohex_coordinate(-5L, 4L), "GI: x:-5,y:4");
  coordinate_is(geohex_get_zone_by_code("QU").coordinate, geohex_coordinate(-4L, 5L), "QU: x:-4,y:5");
  coordinate_is(geohex_get_zone_by_code("QU").coordinate, geohex_coordinate(-4L, 5L), "QU: x:-4,y:5");
  coordinate_is(geohex_get_zone_by_code("GH").coordinate, geohex_coordinate(-5L, 3L), "GH: x:-5,y:3");
  coordinate_is(geohex_get_zone_by_code("EU").coordinate, geohex_coordinate(-10L, -1L), "EU: x:-10,y:-1");
  coordinate_is(geohex_get_zone_by_code("CI").coordinate, geohex_coordinate(-5L, -11L), "CI: x:-5,y:-11");
  coordinate_is(geohex_get_zone_by_code("BV").coordinate, geohex_coordinate(-10L, -6L), "BV: x:-10,y:-6");
  coordinate_is(geohex_get_zone_by_code("Fb").coordinate, geohex_coordinate(-5L, 0L), "Fb: x:-5,y:0");
  coordinate_is(geohex_get_zone_by_code("SV").coordinate, geohex_coordinate(2L, 6L), "SV: x:2,y:6");
  coordinate_is(geohex_get_zone_by_code("TO").coordinate, geohex_coordinate(3L, 12L), "TO: x:3,y:12");
  coordinate_is(geohex_get_zone_by_code("TK").coordinate, geohex_coordinate(2L, 11L), "TK: x:2,y:11");
  coordinate_is(geohex_get_zone_by_code("bD").coordinate, geohex_coordinate(6L, 8L), "bD: x:6,y:8");
  coordinate_is(geohex_get_zone_by_code("ZA").coordinate, geohex_coordinate(8L, 2L), "ZA: x:8,y:2");
  coordinate_is(geohex_get_zone_by_code("aX").coordinate, geohex_coordinate(6L, 5L), "aX: x:6,y:5");
  coordinate_is(geohex_get_zone_by_code("PZ").coordinate, geohex_coordinate(3L, 1L), "PZ: x:3,y:1");
  coordinate_is(geohex_get_zone_by_code("OK").coordinate, geohex_coordinate(-1L, -4L), "OK: x:-1,y:-4");
  coordinate_is(geohex_get_zone_by_code("CZ3").coordinate, geohex_coordinate(-18L, -16L), "CZ3: x:-18,y:-16");
  coordinate_is(geohex_get_zone_by_code("CI8").coordinate, geohex_coordinate(-14L, -32L), "CI8: x:-14,y:-32");
  coordinate_is(geohex_get_zone_by_code("DO0").coordinate, geohex_coordinate(-37L, -10L), "DO0: x:-37,y:-10");
  coordinate_is(geohex_get_zone_by_code("EX2").coordinate, geohex_coordinate(-28L, -2L), "EX2: x:-28,y:-2");
  coordinate_is(geohex_get_zone_by_code("EU1").coordinate, geohex_coordinate(-4L, -30L), "EU1: x:-4,y:-30");
  coordinate_is(geohex_get_zone_by_code("OK4").coordinate, geohex_coordinate(-3L, -12L), "OK4: x:-3,y:-12");
  coordinate_is(geohex_get_zone_by_code("GI3").coordinate, geohex_coordinate(-15L, 11L), "GI3: x:-15,y:11");
  coordinate_is(geohex_get_zone_by_code("GI1").coordinate, geohex_coordinate(11L, -15L), "GI1: x:11,y:-15");
  coordinate_is(geohex_get_zone_by_code("QU0").coordinate, geohex_coordinate(-13L, 14L), "QU0: x:-13,y:14");
  coordinate_is(geohex_get_zone_by_code("QU7").coordinate, geohex_coordinate(-11L, 15L), "QU7: x:-11,y:15");
  coordinate_is(geohex_get_zone_by_code("GH8").coordinate, geohex_coordinate(-14L, 10L), "GH8: x:-14,y:10");
  coordinate_is(geohex_get_zone_by_code("OY0").coordinate, geohex_coordinate(-1L, -1L), "OY0: x:-1,y:-1");
  coordinate_is(geohex_get_zone_by_code("Fb3").coordinate, geohex_coordinate(-15L, -1L), "Fb3: x:-15,y:-1");
  coordinate_is(geohex_get_zone_by_code("XM4").coordinate, geohex_coordinate(15L, -6L), "XM4: x:15,y:-6");
  coordinate_is(geohex_get_zone_by_code("PZ0").coordinate, geohex_coordinate(8L, 2L), "PZ0: x:8,y:2");
  coordinate_is(geohex_get_zone_by_code("SW6").coordinate, geohex_coordinate(7L, 20L), "SW6: x:7,y:20");
  coordinate_is(geohex_get_zone_by_code("SV3").coordinate, geohex_coordinate(6L, 17L), "SV3: x:6,y:17");
  coordinate_is(geohex_get_zone_by_code("aX0").coordinate, geohex_coordinate(17L, 14L), "aX0: x:17,y:14");
  coordinate_is(geohex_get_zone_by_code("aX8").coordinate, geohex_coordinate(19L, 16L), "aX8: x:19,y:16");
  coordinate_is(geohex_get_zone_by_code("aZ2").coordinate, geohex_coordinate(17L, 22L), "aZ2: x:17,y:22");
  coordinate_is(geohex_get_zone_by_code("TO4").coordinate, geohex_coordinate(9L, 36L), "TO4: x:9,y:36");
  coordinate_is(geohex_get_zone_by_code("aB6").coordinate, geohex_coordinate(34L, 8L), "aB6: x:34,y:8");
  coordinate_is(geohex_get_zone_by_code("TK1").coordinate, geohex_coordinate(32L, 6L), "TK1: x:32,y:6");
  coordinate_is(geohex_get_zone_by_code("TK3").coordinate, geohex_coordinate(6L, 32L), "TK3: x:6,y:32");
  coordinate_is(geohex_get_zone_by_code("ZA4").coordinate, geohex_coordinate(24L, 6L), "ZA4: x:24,y:6");
  coordinate_is(geohex_get_zone_by_code("PA0").coordinate, geohex_coordinate(-4L, 5L), "PA0: x:-4,y:5");
  coordinate_is(geohex_get_zone_by_code("BV8").coordinate, geohex_coordinate(-29L, -17L), "BV8: x:-29,y:-17");
  coordinate_is(geohex_get_zone_by_code("CI76").coordinate, geohex_coordinate(-41L, -100L), "CI76: x:-41,y:-100");
  coordinate_is(geohex_get_zone_by_code("CI55").coordinate, geohex_coordinate(-45L, -95L), "CI55: x:-45,y:-95");
  coordinate_is(geohex_get_zone_by_code("DO07").coordinate, geohex_coordinate(-110L, -30L), "DO07: x:-110,y:-30");
  coordinate_is(geohex_get_zone_by_code("DO05").coordinate, geohex_coordinate(-30L, -110L), "DO05: x:-30,y:-110");
  coordinate_is(geohex_get_zone_by_code("EU06").coordinate, geohex_coordinate(-92L, -13L), "EU06: x:-92,y:-13");
  coordinate_is(geohex_get_zone_by_code("EU13").coordinate, geohex_coordinate(-12L, -91L), "EU13: x:-12,y:-91");
  coordinate_is(geohex_get_zone_by_code("GH32").coordinate, geohex_coordinate(-46L, 25L), "GH32: x:-46,y:25");
  coordinate_is(geohex_get_zone_by_code("OK51").coordinate, geohex_coordinate(-10L, -33L), "OK51: x:-10,y:-33");
  coordinate_is(geohex_get_zone_by_code("GI47").coordinate, geohex_coordinate(-44L, 36L), "GI47: x:-44,y:36");
  coordinate_is(geohex_get_zone_by_code("GI53").coordinate, geohex_coordinate(36L, -43L), "GI53: x:36,y:-43");
  coordinate_is(geohex_get_zone_by_code("QU08").coordinate, geohex_coordinate(-38L, 43L), "QU08: x:-38,y:43");
  coordinate_is(geohex_get_zone_by_code("OC58").coordinate, geohex_coordinate(-35L, 40L), "OC58: x:-35,y:40");
  coordinate_is(geohex_get_zone_by_code("XL60").coordinate, geohex_coordinate(47L, -31L), "XL60: x:47,y:-31");
  coordinate_is(geohex_get_zone_by_code("XM56").coordinate, geohex_coordinate(46L, -16L), "XM56: x:46,y:-16");
  coordinate_is(geohex_get_zone_by_code("PS62").coordinate, geohex_coordinate(38L, -20L), "PS62: x:38,y:-20");
  coordinate_is(geohex_get_zone_by_code("XX03").coordinate, geohex_coordinate(51L, -13L), "XX03: x:51,y:-13");
  coordinate_is(geohex_get_zone_by_code("PZ38").coordinate, geohex_coordinate(28L, 7L), "PZ38: x:28,y:7");
  coordinate_is(geohex_get_zone_by_code("PZ04").coordinate, geohex_coordinate(24L, 6L), "PZ04: x:24,y:6");
  coordinate_is(geohex_get_zone_by_code("PZ18").coordinate, geohex_coordinate(25L, 10L), "PZ18: x:25,y:10");
  coordinate_is(geohex_get_zone_by_code("OU88").coordinate, geohex_coordinate(-5L, -5L), "OU88: x:-5,y:-5");
  coordinate_is(geohex_get_zone_by_code("OY53").coordinate, geohex_coordinate(0L, 2L), "OY53: x:0,y:2");
  coordinate_is(geohex_get_zone_by_code("PA04").coordinate, geohex_coordinate(-12L, 15L), "PA04: x:-12,y:15");
  coordinate_is(geohex_get_zone_by_code("Fb17").coordinate, geohex_coordinate(-47L, 0L), "Fb17: x:-47,y:0");
  coordinate_is(geohex_get_zone_by_code("Fb34").coordinate, geohex_coordinate(-45L, -3L), "Fb34: x:-45,y:-3");
  coordinate_is(geohex_get_zone_by_code("Fb86").coordinate, geohex_coordinate(-41L, 2L), "Fb86: x:-41,y:2");
  coordinate_is(geohex_get_zone_by_code("GH58").coordinate, geohex_coordinate(-44L, 31L), "GH58: x:-44,y:31");
  coordinate_is(geohex_get_zone_by_code("TK63").coordinate, geohex_coordinate(21L, 95L), "TK63: x:21,y:95");
  coordinate_is(geohex_get_zone_by_code("TO07").coordinate, geohex_coordinate(25L, 105L), "TO07: x:25,y:105");
  coordinate_is(geohex_get_zone_by_code("TO42").coordinate, geohex_coordinate(107L, 28L), "TO42: x:107,y:28");
  coordinate_is(geohex_get_zone_by_code("TK02").coordinate, geohex_coordinate(95L, 16L), "TK02: x:95,y:16");
  coordinate_is(geohex_get_zone_by_code("bD31").coordinate, geohex_coordinate(53L, 69L), "bD31: x:53,y:69");
  coordinate_is(geohex_get_zone_by_code("bE73").coordinate, geohex_coordinate(57L, 80L), "bE73: x:57,y:80");
  coordinate_is(geohex_get_zone_by_code("bb33").coordinate, geohex_coordinate(90L, 50L), "bb33: x:90,y:50");
  coordinate_is(geohex_get_zone_by_code("TO84").coordinate, geohex_coordinate(30L, 111L), "TO84: x:30,y:111");
  coordinate_is(geohex_get_zone_by_code("TO47").coordinate, geohex_coordinate(28L, 108L), "TO47: x:28,y:108");
  coordinate_is(geohex_get_zone_by_code("aB61").coordinate, geohex_coordinate(101L, 24L), "aB61: x:101,y:24");
  coordinate_is(geohex_get_zone_by_code("ZA08").coordinate, geohex_coordinate(70L, 16L), "ZA08: x:70,y:16");
  coordinate_is(geohex_get_zone_by_code("aX55").coordinate, geohex_coordinate(54L, 49L), "aX55: x:54,y:49");
  coordinate_is(geohex_get_zone_by_code("aX04").coordinate, geohex_coordinate(51L, 42L), "aX04: x:51,y:42");
  coordinate_is(geohex_get_zone_by_code("YF58").coordinate, geohex_coordinate(55L, 40L), "YF58: x:55,y:40");
  coordinate_is(geohex_get_zone_by_code("SV40").coordinate, geohex_coordinate(17L, 53L), "SV40: x:17,y:53");
  coordinate_is(geohex_get_zone_by_code("RX15").coordinate, geohex_coordinate(-3L, 46L), "RX15: x:-3,y:46");
  coordinate_is(geohex_get_zone_by_code("OU40").coordinate, geohex_coordinate(-10L, -10L), "OU40: x:-10,y:-10");
  coordinate_is(geohex_get_zone_by_code("BV56").coordinate, geohex_coordinate(-89L, -52L), "BV56: x:-89,y:-52");
  coordinate_is(geohex_get_zone_by_code("CI771").coordinate, geohex_coordinate(-124L, -297L), "CI771: x:-124,y:-297");
  coordinate_is(geohex_get_zone_by_code("DO045").coordinate, geohex_coordinate(-90L, -332L), "DO045: x:-90,y:-332");
  coordinate_is(geohex_get_zone_by_code("DO056").coordinate, geohex_coordinate(-89L, -331L), "DO056: x:-89,y:-331");
  coordinate_is(geohex_get_zone_by_code("DO077").coordinate, geohex_coordinate(-329L, -90L), "DO077: x:-329,y:-90");
  coordinate_is(geohex_get_zone_by_code("BV778").coordinate, geohex_coordinate(-257L, -161L), "BV778: x:-257,y:-161");
  coordinate_is(geohex_get_zone_by_code("BV568").coordinate, geohex_coordinate(-266L, -155L), "BV568: x:-266,y:-155");
  coordinate_is(geohex_get_zone_by_code("CZ335").coordinate, geohex_coordinate(-162L, -146L), "CZ335: x:-162,y:-146");
  coordinate_is(geohex_get_zone_by_code("EU570").coordinate, geohex_coordinate(-25L, -262L), "EU570: x:-25,y:-262");
  coordinate_is(geohex_get_zone_by_code("EU868").coordinate, geohex_coordinate(-257L, -20L), "EU868: x:-257,y:-20");
  coordinate_is(geohex_get_zone_by_code("OK468").coordinate, geohex_coordinate(-23L, -110L), "OK468: x:-23,y:-110");
  coordinate_is(geohex_get_zone_by_code("OY443").coordinate, geohex_coordinate(0L, -1L), "OY443: x:0,y:-1");
  coordinate_is(geohex_get_zone_by_code("OY004").coordinate, geohex_coordinate(-12L, -12L), "OY004: x:-12,y:-12");
  coordinate_is(geohex_get_zone_by_code("Fb526").coordinate, geohex_coordinate(-137L, 11L), "Fb526: x:-137,y:11");
  coordinate_is(geohex_get_zone_by_code("GH588").coordinate, geohex_coordinate(-131L, 94L), "GH588: x:-131,y:94");
  coordinate_is(geohex_get_zone_by_code("GI440").coordinate, geohex_coordinate(-136L, 107L), "GI440: x:-136,y:107");
  coordinate_is(geohex_get_zone_by_code("GI622").coordinate, geohex_coordinate(-130L, 103L), "GI622: x:-130,y:103");
  coordinate_is(geohex_get_zone_by_code("QU340").coordinate, geohex_coordinate(-109L, 125L), "QU340: x:-109,y:125");
  coordinate_is(geohex_get_zone_by_code("QU026").coordinate, geohex_coordinate(124L, -115L), "QU026: x:124,y:-115");
  coordinate_is(geohex_get_zone_by_code("XM454").coordinate, geohex_coordinate(135L, -51L), "XM454: x:135,y:-51");
  coordinate_is(geohex_get_zone_by_code("PS624").coordinate, geohex_coordinate(114L, -60L), "PS624: x:114,y:-60");
  coordinate_is(geohex_get_zone_by_code("XX038").coordinate, geohex_coordinate(154L, -38L), "XX038: x:154,y:-38");
  coordinate_is(geohex_get_zone_by_code("XU630").coordinate, geohex_coordinate(143L, -40L), "XU630: x:143,y:-40");
  coordinate_is(geohex_get_zone_by_code("PZ342").coordinate, geohex_coordinate(80L, 19L), "PZ342: x:80,y:19");
  coordinate_is(geohex_get_zone_by_code("PZ580").coordinate, geohex_coordinate(83L, 38L), "PZ580: x:83,y:38");
  coordinate_is(geohex_get_zone_by_code("OY864").coordinate, geohex_coordinate(12L, 6L), "OY864: x:12,y:6");
  coordinate_is(geohex_get_zone_by_code("OY145").coordinate, geohex_coordinate(-9L, 1L), "OY145: x:-9,y:1");
  coordinate_is(geohex_get_zone_by_code("PA032").coordinate, geohex_coordinate(-37L, 43L), "PA032: x:-37,y:43");
  coordinate_is(geohex_get_zone_by_code("OI758").coordinate, geohex_coordinate(-44L, 112L), "OI758: x:-44,y:112");
  coordinate_is(geohex_get_zone_by_code("SV428").coordinate, geohex_coordinate(52L, 166L), "SV428: x:52,y:166");
  coordinate_is(geohex_get_zone_by_code("SV385").coordinate, geohex_coordinate(57L, 157L), "SV385: x:57,y:157");
  coordinate_is(geohex_get_zone_by_code("aX355").coordinate, geohex_coordinate(162L, 130L), "aX355: x:162,y:130");
  coordinate_is(geohex_get_zone_by_code("aX568").coordinate, geohex_coordinate(166L, 142L), "aX568: x:166,y:142");
  coordinate_is(geohex_get_zone_by_code("bD744").coordinate, geohex_coordinate(171L, 216L), "bD744: x:171,y:216");
  coordinate_is(geohex_get_zone_by_code("bD515").coordinate, geohex_coordinate(159L, 226L), "bD515: x:159,y:226");
  coordinate_is(geohex_get_zone_by_code("bb337").coordinate, geohex_coordinate(271L, 150L), "bb337: x:271,y:150");
  coordinate_is(geohex_get_zone_by_code("TO808").coordinate, geohex_coordinate(88L, 331L), "TO808: x:88,y:331");
  coordinate_is(geohex_get_zone_by_code("TO428").coordinate, geohex_coordinate(322L, 85L), "TO428: x:322,y:85");
  coordinate_is(geohex_get_zone_by_code("TO474").coordinate, geohex_coordinate(84L, 324L), "TO474: x:84,y:324");
  coordinate_is(geohex_get_zone_by_code("TO073").coordinate, geohex_coordinate(75L, 314L), "TO073: x:75,y:314");
  coordinate_is(geohex_get_zone_by_code("aB648").coordinate, geohex_coordinate(307L, 73L), "aB648: x:307,y:73");
  coordinate_is(geohex_get_zone_by_code("YG168").coordinate, geohex_coordinate(184L, 52L), "YG168: x:184,y:52");
  coordinate_is(geohex_get_zone_by_code("BV7511").coordinate, geohex_coordinate(-787L, -477L), "BV7511: x:-787,y:-477");
  coordinate_is(geohex_get_zone_by_code("BV7541").coordinate, geohex_coordinate(-784L, -477L), "BV7541: x:-784,y:-477");
  coordinate_is(geohex_get_zone_by_code("DO0532").coordinate, geohex_coordinate(-271L, -992L), "DO0532: x:-271,y:-992");
  coordinate_is(geohex_get_zone_by_code("DO3203").coordinate, geohex_coordinate(-984L, -265L), "DO3203: x:-984,y:-265");
  coordinate_is(geohex_get_zone_by_code("EU6235").coordinate, geohex_coordinate(-792L, -101L), "EU6235: x:-792,y:-101");
  coordinate_is(geohex_get_zone_by_code("EU1425").coordinate, geohex_coordinate(-111L, -806L), "EU1425: x:-111,y:-806");
  coordinate_is(geohex_get_zone_by_code("OK7172").coordinate, geohex_coordinate(-61L, -323L), "OK7172: x:-61,y:-323");
  coordinate_is(geohex_get_zone_by_code("CZ0737").coordinate, geohex_coordinate(-503L, -435L), "CZ0737: x:-503,y:-435");
  coordinate_is(geohex_get_zone_by_code("Fb0200").coordinate, geohex_coordinate(-445L, -22L), "Fb0200: x:-445,y:-22");
  coordinate_is(geohex_get_zone_by_code("Fb8608").coordinate, geohex_coordinate(-371L, 16L), "Fb8608: x:-371,y:16");
  coordinate_is(geohex_get_zone_by_code("GH4405").coordinate, geohex_coordinate(-408L, 241L), "GH4405: x:-408,y:241");
  coordinate_is(geohex_get_zone_by_code("GI2651").coordinate, geohex_coordinate(305L, -384L), "GI2651: x:305,y:-384");
  coordinate_is(geohex_get_zone_by_code("OC2121").coordinate, geohex_coordinate(-364L, 354L), "OC2121: x:-364,y:354");
  coordinate_is(geohex_get_zone_by_code("QU7871").coordinate, geohex_coordinate(-286L, 414L), "QU7871: x:-286,y:414");
  coordinate_is(geohex_get_zone_by_code("QU4212").coordinate, geohex_coordinate(392L, -314L), "QU4212: x:392,y:-314");
  coordinate_is(geohex_get_zone_by_code("OK4362").coordinate, geohex_coordinate(-79L, -335L), "OK4362: x:-79,y:-335");
  coordinate_is(geohex_get_zone_by_code("OX2538").coordinate, geohex_coordinate(-26L, -47L), "OX2538: x:-26,y:-47");
  coordinate_is(geohex_get_zone_by_code("OY5663").coordinate, geohex_coordinate(12L, 14L), "OY5663: x:12,y:14");
  coordinate_is(geohex_get_zone_by_code("OG6663").coordinate, geohex_coordinate(-123L, 122L), "OG6663: x:-123,y:122");
  coordinate_is(geohex_get_zone_by_code("PZ0631").coordinate, geohex_coordinate(224L, 42L), "PZ0631: x:224,y:42");
  coordinate_is(geohex_get_zone_by_code("SV8518").coordinate, geohex_coordinate(187L, 523L), "SV8518: x:187,y:523");
  coordinate_is(geohex_get_zone_by_code("TK3246").coordinate, geohex_coordinate(154L, 872L), "TK3246: x:154,y:872");
  coordinate_is(geohex_get_zone_by_code("TK1825").coordinate, geohex_coordinate(870L, 175L), "TK1825: x:870,y:175");
  coordinate_is(geohex_get_zone_by_code("aB6727").coordinate, geohex_coordinate(925L, 219L), "aB6727: x:925,y:219");
  coordinate_is(geohex_get_zone_by_code("TR1202").coordinate, geohex_coordinate(284L, 979L), "TR1202: x:284,y:979");
  coordinate_is(geohex_get_zone_by_code("bD4054").coordinate, geohex_coordinate(477L, 642L), "bD4054: x:477,y:642");
  coordinate_is(geohex_get_zone_by_code("aX4486").coordinate, geohex_coordinate(490L, 407L), "aX4486: x:490,y:407");
  coordinate_is(geohex_get_zone_by_code("ZA5685").coordinate, geohex_coordinate(660L, 184L), "ZA5685: x:660,y:184");
  coordinate_is(geohex_get_zone_by_code("XM4881").coordinate, geohex_coordinate(416L, -150L), "XM4881: x:416,y:-150");
  coordinate_is(geohex_get_zone_by_code("XU6302").coordinate, geohex_coordinate(428L, -119L), "XU6302: x:428,y:-119");
  coordinate_is(geohex_get_zone_by_code("XX0337").coordinate, geohex_coordinate(460L, -120L), "XX0337: x:460,y:-120");
  coordinate_is(geohex_get_zone_by_code("XM6425").coordinate, geohex_coordinate(429L, -185L), "XM6425: x:429,y:-185");
  coordinate_is(geohex_get_zone_by_code("PS6270").coordinate, geohex_coordinate(344L, -181L), "PS6270: x:344,y:-181");
  coordinate_is(geohex_get_zone_by_code("BV80302").coordinate, geohex_coordinate(-2380L, -1415L), "BV80302: x:-2380,y:-1415");
  coordinate_is(geohex_get_zone_by_code("BV80373").coordinate, geohex_coordinate(-2373L, -1414L), "BV80373: x:-2373,y:-1414");
  coordinate_is(geohex_get_zone_by_code("DO08354").coordinate, geohex_coordinate(-2970L, -789L), "DO08354: x:-2970,y:-789");
  coordinate_is(geohex_get_zone_by_code("DO05758").coordinate, geohex_coordinate(-800L, -2966L), "DO05758: x:-800,y:-2966");
  coordinate_is(geohex_get_zone_by_code("EU31135").coordinate, geohex_coordinate(-2466L, -326L), "EU31135: x:-2466,y:-326");
  coordinate_is(geohex_get_zone_by_code("EU45042").coordinate, geohex_coordinate(-253L, -2411L), "EU45042: x:-253,y:-2411");
  coordinate_is(geohex_get_zone_by_code("CZ35087").coordinate, geohex_coordinate(-1463L, -1275L), "CZ35087: x:-1463,y:-1275");
  coordinate_is(geohex_get_zone_by_code("OK06445").coordinate, geohex_coordinate(-297L, -1079L), "OK06445: x:-297,y:-1079");
  coordinate_is(geohex_get_zone_by_code("Fb80457").coordinate, geohex_coordinate(-1160L, 57L), "Fb80457: x:-1160,y:57");
  coordinate_is(geohex_get_zone_by_code("GH80422").coordinate, geohex_coordinate(-1165L, 787L), "GH80422: x:-1165,y:787");
  coordinate_is(geohex_get_zone_by_code("GI74753").coordinate, geohex_coordinate(-1125L, 974L), "GI74753: x:-1125,y:974");
  coordinate_is(geohex_get_zone_by_code("GI80240").coordinate, geohex_coordinate(1016L, -1153L), "GI80240: x:1016,y:-1153");
  coordinate_is(geohex_get_zone_by_code("QU01265").coordinate, geohex_coordinate(1101L, -1046L), "QU01265: x:1101,y:-1046");
  coordinate_is(geohex_get_zone_by_code("QU86344").coordinate, geohex_coordinate(-864L, 1260L), "QU86344: x:-864,y:1260");
  coordinate_is(geohex_get_zone_by_code("OY77334").coordinate, geohex_coordinate(108L, -12L), "OY77334: x:108,y:-12");
  coordinate_is(geohex_get_zone_by_code("OY15454").coordinate, geohex_coordinate(-81L, 30L), "OY15454: x:-81,y:30");
  coordinate_is(geohex_get_zone_by_code("PA04170").coordinate, geohex_coordinate(-331L, 404L), "PA04170: x:-331,y:404");
  coordinate_is(geohex_get_zone_by_code("PS62113").coordinate, geohex_coordinate(1014L, -541L), "PS62113: x:1014,y:-541");
  coordinate_is(geohex_get_zone_by_code("PS68342").coordinate, geohex_coordinate(1079L, -548L), "PS68342: x:1079,y:-548");
  coordinate_is(geohex_get_zone_by_code("XM78145").coordinate, geohex_coordinate(1314L, -458L), "XM78145: x:1314,y:-458");
  coordinate_is(geohex_get_zone_by_code("XM48257").coordinate, geohex_coordinate(1234L, -447L), "XM48257: x:1234,y:-447");
  coordinate_is(geohex_get_zone_by_code("XX03156").coordinate, geohex_coordinate(1369L, -349L), "XX03156: x:1369,y:-349");
  coordinate_is(geohex_get_zone_by_code("PZ47685").coordinate, geohex_coordinate(768L, 238L), "PZ47685: x:768,y:238");
  coordinate_is(geohex_get_zone_by_code("SV40654").coordinate, geohex_coordinate(468L, 1425L), "SV40654: x:468,y:1425");
  coordinate_is(geohex_get_zone_by_code("OI71873").coordinate, geohex_coordinate(-420L, 980L), "OI71873: x:-420,y:980");
  coordinate_is(geohex_get_zone_by_code("aX40264").coordinate, geohex_coordinate(1425L, 1194L), "aX40264: x:1425,y:1194");
  coordinate_is(geohex_get_zone_by_code("ZA44552").coordinate, geohex_coordinate(1943L, 499L), "ZA44552: x:1943,y:499");
  coordinate_is(geohex_get_zone_by_code("bD47117").coordinate, geohex_coordinate(1474L, 1944L), "bD47117: x:1474,y:1944");
  coordinate_is(geohex_get_zone_by_code("TK51615").coordinate, geohex_coordinate(2652L, 559L), "TK51615: x:2652,y:559");
  coordinate_is(geohex_get_zone_by_code("TK71615").coordinate, geohex_coordinate(546L, 2665L), "TK71615: x:546,y:2665");
  coordinate_is(geohex_get_zone_by_code("TO38458").coordinate, geohex_coordinate(757L, 2866L), "TO38458: x:757,y:2866");
  coordinate_is(geohex_get_zone_by_code("TO58484").coordinate, geohex_coordinate(2946L, 840L), "TO58484: x:2946,y:840");
  coordinate_is(geohex_get_zone_by_code("BV553581").coordinate, geohex_coordinate(-7288L, -4065L), "BV553581: x:-7288,y:-4065");
  coordinate_is(geohex_get_zone_by_code("CI802417").coordinate, geohex_coordinate(-3512L, -7830L), "CI802417: x:-3512,y:-7830");
  coordinate_is(geohex_get_zone_by_code("CI750110").coordinate, geohex_coordinate(-3442L, -7966L), "CI750110: x:-3442,y:-7966");
  coordinate_is(geohex_get_zone_by_code("DO018862").coordinate, geohex_coordinate(-2473L, -8957L), "DO018862: x:-2473,y:-8957");
  coordinate_is(geohex_get_zone_by_code("DO053505").coordinate, geohex_coordinate(-2433L, -8930L), "DO053505: x:-2433,y:-8930");
  coordinate_is(geohex_get_zone_by_code("DO074664").coordinate, geohex_coordinate(-8898L, -2442L), "DO074664: x:-8898,y:-2442");
  coordinate_is(geohex_get_zone_by_code("CZ351822").coordinate, geohex_coordinate(-4396L, -3794L), "CZ351822: x:-4396,y:-3794");
  coordinate_is(geohex_get_zone_by_code("EU412420").coordinate, geohex_coordinate(-841L, -7261L), "EU412420: x:-841,y:-7261");
  coordinate_is(geohex_get_zone_by_code("EU708101").coordinate, geohex_coordinate(-7114L, -786L), "EU708101: x:-7114,y:-786");
  coordinate_is(geohex_get_zone_by_code("OK847038").coordinate, geohex_coordinate(-467L, -2684L), "OK847038: x:-467,y:-2684");
  coordinate_is(geohex_get_zone_by_code("GH501658").coordinate, geohex_coordinate(-3743L, 2344L), "GH501658: x:-3743,y:2344");
  coordinate_is(geohex_get_zone_by_code("GI842644").coordinate, geohex_coordinate(3141L, -3384L), "GI842644: x:3141,y:-3384");
  coordinate_is(geohex_get_zone_by_code("GI836575").coordinate, geohex_coordinate(-3372L, 3061L), "GI836575: x:-3372,y:3061");
  coordinate_is(geohex_get_zone_by_code("QU316588").coordinate, geohex_coordinate(-2966L, 3388L), "QU316588: x:-2966,y:3388");
  coordinate_is(geohex_get_zone_by_code("QU175485").coordinate, geohex_coordinate(3486L, -2885L), "QU175485: x:3486,y:-2885");
  coordinate_is(geohex_get_zone_by_code("Fb711277").coordinate, geohex_coordinate(-3515L, 9L), "Fb711277: x:-3515,y:9");
  coordinate_is(geohex_get_zone_by_code("OY728344").coordinate, geohex_coordinate(189L, 99L), "OY728344: x:189,y:99");
  coordinate_is(geohex_get_zone_by_code("PA016372").coordinate, geohex_coordinate(-1024L, 1180L), "PA016372: x:-1024,y:1180");
  coordinate_is(geohex_get_zone_by_code("QU408880").coordinate, geohex_coordinate(-2959L, 3602L), "QU408880: x:-2959,y:3602");
  coordinate_is(geohex_get_zone_by_code("XM442337").coordinate, geohex_coordinate(3619L, -1443L), "XM442337: x:3619,y:-1443");
  coordinate_is(geohex_get_zone_by_code("PS387785").coordinate, geohex_coordinate(3036L, -1616L), "PS387785: x:3036,y:-1616");
  coordinate_is(geohex_get_zone_by_code("XX037037").coordinate, geohex_coordinate(4150L, -1065L), "XX037037: x:4150,y:-1065");
  coordinate_is(geohex_get_zone_by_code("PZ173676").coordinate, geohex_coordinate(2038L, 692L), "PZ173676: x:2038,y:692");
  coordinate_is(geohex_get_zone_by_code("SV321726").coordinate, geohex_coordinate(1357L, 4214L), "SV321726: x:1357,y:4214");
  coordinate_is(geohex_get_zone_by_code("PC828583").coordinate, geohex_coordinate(-537L, 3278L), "PC828583: x:-537,y:3278");
  coordinate_is(geohex_get_zone_by_code("OI713375").coordinate, geohex_coordinate(-1293L, 2881L), "OI713375: x:-1293,y:2881");
  coordinate_is(geohex_get_zone_by_code("bD080050").coordinate, geohex_coordinate(4175L, 5636L), "bD080050: x:4175,y:5636");
  coordinate_is(geohex_get_zone_by_code("aX817100").coordinate, geohex_coordinate(4550L, 3884L), "aX817100: x:4550,y:3884");
  coordinate_is(geohex_get_zone_by_code("ZA712478").coordinate, geohex_coordinate(5971L, 1486L), "ZA712478: x:5971,y:1486");
  coordinate_is(geohex_get_zone_by_code("TK166315").coordinate, geohex_coordinate(7881L, 1342L), "TK166315: x:7881,y:1342");
  coordinate_is(geohex_get_zone_by_code("TK873482").coordinate, geohex_coordinate(1784L, 8239L), "TK873482: x:1784,y:8239");
  coordinate_is(geohex_get_zone_by_code("TO433402").coordinate, geohex_coordinate(2183L, 8638L), "TO433402: x:2183,y:8638");
  coordinate_is(geohex_get_zone_by_code("TO586342").coordinate, geohex_coordinate(8855L, 2476L), "TO586342: x:8855,y:2476");
  coordinate_is(geohex_get_zone_by_code("bb335332").coordinate, geohex_coordinate(7289L, 4066L), "bb335332: x:7289,y:4066");
  coordinate_is(geohex_get_zone_by_code("BV8032788").coordinate, geohex_coordinate(-21398L, -12686L), "BV8032788: x:-21398,y:-12686");
  coordinate_is(geohex_get_zone_by_code("CI7714524").coordinate, geohex_coordinate(-10047L, -24045L), "CI7714524: x:-10047,y:-24045");
  coordinate_is(geohex_get_zone_by_code("DO0514686").coordinate, geohex_coordinate(-7358L, -26737L), "DO0514686: x:-7358,y:-26737");
  coordinate_is(geohex_get_zone_by_code("DO0517300").coordinate, geohex_coordinate(-7348L, -26743L), "DO0517300: x:-7348,y:-26743");
  coordinate_is(geohex_get_zone_by_code("DO0732687").coordinate, geohex_coordinate(-26744L, -7350L), "DO0732687: x:-26744,y:-7350");
  coordinate_is(geohex_get_zone_by_code("DO0732768").coordinate, geohex_coordinate(-26744L, -7346L), "DO0732768: x:-26744,y:-7346");
  coordinate_is(geohex_get_zone_by_code("EU4031833").coordinate, geohex_coordinate(-22131L, -2506L), "EU4031833: x:-22131,y:-2506");
  coordinate_is(geohex_get_zone_by_code("EU8072131").coordinate, geohex_coordinate(-21340L, -1677L), "EU8072131: x:-21340,y:-1677");
  coordinate_is(geohex_get_zone_by_code("EU8255485").coordinate, geohex_coordinate(-1698L, -20786L), "EU8255485: x:-1698,y:-20786");
  coordinate_is(geohex_get_zone_by_code("CZ3800810").coordinate, geohex_coordinate(-12982L, -11521L), "CZ3800810: x:-12982,y:-11521");
  coordinate_is(geohex_get_zone_by_code("OK1624776").coordinate, geohex_coordinate(-2741L, -8911L), "OK1624776: x:-2741,y:-8911");
  coordinate_is(geohex_get_zone_by_code("OK7464515").coordinate, geohex_coordinate(-1380L, -8819L), "OK7464515: x:-1380,y:-8819");
  coordinate_is(geohex_get_zone_by_code("Fb5316746").coordinate, geohex_coordinate(-10979L, 458L), "Fb5316746: x:-10979,y:458");
  coordinate_is(geohex_get_zone_by_code("Fb4033527").coordinate, geohex_coordinate(-11180L, -339L), "Fb4033527: x:-11180,y:-339");
  coordinate_is(geohex_get_zone_by_code("GH4540858").coordinate, geohex_coordinate(-10952L, 6790L), "GH4540858: x:-10952,y:6790");
  coordinate_is(geohex_get_zone_by_code("GI4351804").coordinate, geohex_coordinate(-10956L, 8592L), "GI4351804: x:-10956,y:8592");
  coordinate_is(geohex_get_zone_by_code("GI8387484").coordinate, geohex_coordinate(-10095L, 9318L), "GI8387484: x:-10095,y:9318");
  coordinate_is(geohex_get_zone_by_code("QU0706771").coordinate, geohex_coordinate(-9277L, 10098L), "QU0706771: x:-9277,y:10098");
  coordinate_is(geohex_get_zone_by_code("QU4884047").coordinate, geohex_coordinate(-8432L, 11250L), "QU4884047: x:-8432,y:11250");
  coordinate_is(geohex_get_zone_by_code("QU8251271").coordinate, geohex_coordinate(11387L, -7686L), "QU8251271: x:11387,y:-7686");
  coordinate_is(geohex_get_zone_by_code("PA0565644").coordinate, geohex_coordinate(-2826L, 3825L), "PA0565644: x:-2826,y:3825");
  coordinate_is(geohex_get_zone_by_code("OY8320288").coordinate, geohex_coordinate(616L, 553L), "OY8320288: x:616,y:553");
  coordinate_is(geohex_get_zone_by_code("OY3556486").coordinate, geohex_coordinate(31L, -430L), "OY3556486: x:31,y:-430");
  coordinate_is(geohex_get_zone_by_code("PZ8016814").coordinate, geohex_coordinate(6999L, 2655L), "PZ8016814: x:6999,y:2655");
  coordinate_is(geohex_get_zone_by_code("PZ1746604").coordinate, geohex_coordinate(6108L, 2148L), "PZ1746604: x:6108,y:2148");
  coordinate_is(geohex_get_zone_by_code("PS6242083").coordinate, geohex_coordinate(9201L, -4840L), "PS6242083: x:9201,y:-4840");
  coordinate_is(geohex_get_zone_by_code("XM5643552").coordinate, geohex_coordinate(11177L, -3902L), "XM5643552: x:11177,y:-3902");
  coordinate_is(geohex_get_zone_by_code("XU6303820").coordinate, geohex_coordinate(11588L, -3256L), "XU6303820: x:11588,y:-3256");
  coordinate_is(geohex_get_zone_by_code("XM7851800").coordinate, geohex_coordinate(11885L, -4045L), "XM7851800: x:11885,y:-4045");
  coordinate_is(geohex_get_zone_by_code("XX0345653").coordinate, geohex_coordinate(12402L, -3139L), "XX0345653: x:12402,y:-3139");
  coordinate_is(geohex_get_zone_by_code("XM6306347").coordinate, geohex_coordinate(11611L, -5463L), "XM6306347: x:11611,y:-5463");
  coordinate_is(geohex_get_zone_by_code("QU8827707").coordinate, geohex_coordinate(11860L, -7698L), "QU8827707: x:11860,y:-7698");
  coordinate_is(geohex_get_zone_by_code("PZ4253332").coordinate, geohex_coordinate(6317L, 2473L), "PZ4253332: x:6317,y:2473");
  coordinate_is(geohex_get_zone_by_code("OI8776718").coordinate, geohex_coordinate(-3287L, 9451L), "OI8776718: x:-3287,y:9451");
  coordinate_is(geohex_get_zone_by_code("PF2148656").coordinate, geohex_coordinate(-935L, 9497L), "PF2148656: x:-935,y:9497");
  coordinate_is(geohex_get_zone_by_code("ZA4587731").coordinate, geohex_coordinate(17612L, 4695L), "ZA4587731: x:17612,y:4695");
  coordinate_is(geohex_get_zone_by_code("SV4335020").coordinate, geohex_coordinate(4361L, 12818L), "SV4335020: x:4361,y:12818");
  coordinate_is(geohex_get_zone_by_code("SV5843218").coordinate, geohex_coordinate(4606L, 14077L), "SV5843218: x:4606,y:14077");
  coordinate_is(geohex_get_zone_by_code("aX0682573").coordinate, geohex_coordinate(12693L, 10079L), "aX0682573: x:12693,y:10079");
  coordinate_is(geohex_get_zone_by_code("aX8100870").coordinate, geohex_coordinate(13511L, 11564L), "aX8100870: x:13511,y:11564");
  coordinate_is(geohex_get_zone_by_code("bD4424804").coordinate, geohex_coordinate(13047L, 17583L), "bD4424804: x:13047,y:17583");
  coordinate_is(geohex_get_zone_by_code("bE6100113").coordinate, geohex_coordinate(13488L, 18845L), "bE6100113: x:13488,y:18845");
  coordinate_is(geohex_get_zone_by_code("TK5027217").coordinate, geohex_coordinate(23749L, 4950L), "TK5027217: x:23749,y:4950");
  coordinate_is(geohex_get_zone_by_code("TK7070414").coordinate, geohex_coordinate(4911L, 23787L), "TK7070414: x:4911,y:23787");
  coordinate_is(geohex_get_zone_by_code("TO6240542").coordinate, geohex_coordinate(7019L, 25741L), "TO6240542: x:7019,y:25741");
  coordinate_is(geohex_get_zone_by_code("TO7775738").coordinate, geohex_coordinate(7624L, 26269L), "TO7775738: x:7624,y:26269");
  coordinate_is(geohex_get_zone_by_code("TO5821675").coordinate, geohex_coordinate(26391L, 7606L), "TO5821675: x:26391,y:7606");
  coordinate_is(geohex_get_zone_by_code("bb3371862").coordinate, geohex_coordinate(21935L, 12157L), "bb3371862: x:21935,y:12157");
  coordinate_is(geohex_get_zone_by_code("BV54870250").coordinate, geohex_coordinate(-65323L, -36952L), "BV54870250: x:-65323,y:-36952");
  coordinate_is(geohex_get_zone_by_code("BV78253862").coordinate, geohex_coordinate(-62926L, -38333L), "BV78253862: x:-62926,y:-38333");
  coordinate_is(geohex_get_zone_by_code("CI57758513").coordinate, geohex_coordinate(-31809L, -69868L), "CI57758513: x:-31809,y:-69868");
  coordinate_is(geohex_get_zone_by_code("CI75600226").coordinate, geohex_coordinate(-30494L, -71782L), "CI75600226: x:-30494,y:-71782");
  coordinate_is(geohex_get_zone_by_code("DO05603615").coordinate, geohex_coordinate(-21702L, -80549L), "DO05603615: x:-21702,y:-80549");
  coordinate_is(geohex_get_zone_by_code("DO07152160").coordinate, geohex_coordinate(-80467L, -21766L), "DO07152160: x:-80467,y:-21766");
  coordinate_is(geohex_get_zone_by_code("EU41063674").coordinate, geohex_coordinate(-7440L, -65970L), "EU41063674: x:-7440,y:-65970");
  coordinate_is(geohex_get_zone_by_code("EU72201265").coordinate, geohex_coordinate(-64509L, -5663L), "EU72201265: x:-64509,y:-5663");
  coordinate_is(geohex_get_zone_by_code("CZ34762511").coordinate, geohex_coordinate(-39073L, -35037L), "CZ34762511: x:-39073,y:-35037");
  coordinate_is(geohex_get_zone_by_code("Fb38241503").coordinate, geohex_coordinate(-32349L, -1210L), "Fb38241503: x:-32349,y:-1210");
  coordinate_is(geohex_get_zone_by_code("OK48511367").coordinate, geohex_coordinate(-5936L, -25284L), "OK48511367: x:-5936,y:-25284");
  coordinate_is(geohex_get_zone_by_code("GI32042116").coordinate, geohex_coordinate(-33815L, 24569L), "GI32042116: x:-33815,y:24569");
  coordinate_is(geohex_get_zone_by_code("GI71565064").coordinate, geohex_coordinate(-31272L, 26421L), "GI71565064: x:-31272,y:26421");
  coordinate_is(geohex_get_zone_by_code("GH45442518").coordinate, geohex_coordinate(-32834L, 20449L), "GH45442518: x:-32834,y:20449");
  coordinate_is(geohex_get_zone_by_code("OY33228746").coordinate, geohex_coordinate(-287L, -2566L), "OY33228746: x:-287,y:-2566");
  coordinate_is(geohex_get_zone_by_code("PA03278283").coordinate, geohex_coordinate(-8889L, 10487L), "PA03278283: x:-8889,y:10487");
  coordinate_is(geohex_get_zone_by_code("QU42174351").coordinate, geohex_coordinate(31913L, -25521L), "QU42174351: x:31913,y:-25521");
  coordinate_is(geohex_get_zone_by_code("QU47122108").coordinate, geohex_coordinate(-25877L, 32911L), "QU47122108: x:-25877,y:32911");
  coordinate_is(geohex_get_zone_by_code("XM32230826").coordinate, geohex_coordinate(31813L, -14434L), "XM32230826: x:31813,y:-14434");
  coordinate_is(geohex_get_zone_by_code("XM56301016").coordinate, geohex_coordinate(33415L, -11998L), "XM56301016: x:33415,y:-11998");
  coordinate_is(geohex_get_zone_by_code("PS61272751").coordinate, geohex_coordinate(27521L, -15036L), "PS61272751: x:27521,y:-15036");
  coordinate_is(geohex_get_zone_by_code("XM60832123").coordinate, geohex_coordinate(34467L, -15847L), "XM60832123: x:34467,y:-15847");
  coordinate_is(geohex_get_zone_by_code("XU63124187").coordinate, geohex_coordinate(34663L, -9393L), "XU63124187: x:34663,y:-9393");
  coordinate_is(geohex_get_zone_by_code("XX03173236").coordinate, geohex_coordinate(37009L, -9499L), "XX03173236: x:37009,y:-9499");
  coordinate_is(geohex_get_zone_by_code("PZ38755703").coordinate, geohex_coordinate(20661L, 5207L), "PZ38755703: x:20661,y:5207");
  coordinate_is(geohex_get_zone_by_code("PZ57757416").coordinate, geohex_coordinate(20680L, 8828L), "PZ57757416: x:20680,y:8828");
  coordinate_is(geohex_get_zone_by_code("Fc51504013").coordinate, geohex_coordinate(-33627L, 8900L), "Fc51504013: x:-33627,y:8900");
  coordinate_is(geohex_get_zone_by_code("OW22586402").coordinate, geohex_coordinate(-9373L, 9772L), "OW22586402: x:-9373,y:9772");
  coordinate_is(geohex_get_zone_by_code("PC52458806").coordinate, geohex_coordinate(-7256L, 29273L), "PC52458806: x:-7256,y:29273");
  coordinate_is(geohex_get_zone_by_code("SV20852101").coordinate, geohex_coordinate(10409L, 41172L), "SV20852101: x:10409,y:41172");
  coordinate_is(geohex_get_zone_by_code("aX46486040").coordinate, geohex_coordinate(40193L, 32120L), "aX46486040: x:40193,y:32120");
  coordinate_is(geohex_get_zone_by_code("ZA62754057").coordinate, geohex_coordinate(54181L, 11739L), "ZA62754057: x:54181,y:11739");
  coordinate_is(geohex_get_zone_by_code("bD28367162").coordinate, geohex_coordinate(38009L, 55078L), "bD28367162: x:38009,y:55078");
  coordinate_is(geohex_get_zone_by_code("TK05722747").coordinate, geohex_coordinate(70129L, 11772L), "TK05722747: x:70129,y:11772");
  coordinate_is(geohex_get_zone_by_code("TK83151057").coordinate, geohex_coordinate(15031L, 73704L), "TK83151057: x:15031,y:73704");
  coordinate_is(geohex_get_zone_by_code("TO31130720").coordinate, geohex_coordinate(18689L, 76439L), "TO31130720: x:18689,y:76439");
  coordinate_is(geohex_get_zone_by_code("TO51331450").coordinate, geohex_coordinate(77975L, 21548L), "TO51331450: x:77975,y:21548");
  coordinate_is(geohex_get_zone_by_code("bb33488116").coordinate, geohex_coordinate(65707L, 36557L), "bb33488116: x:65707,y:36557");
  coordinate_is(geohex_get_zone_by_code("BV804240512").coordinate, geohex_coordinate(-192730L, -113498L), "BV804240512: x:-192730,y:-113498");
  coordinate_is(geohex_get_zone_by_code("CI708565326").coordinate, geohex_coordinate(-93233L, -217789L), "CI708565326: x:-93233,y:-217789");
  coordinate_is(geohex_get_zone_by_code("CI754848748").coordinate, geohex_coordinate(-91574L, -214055L), "CI754848748: x:-91574,y:-214055");
  coordinate_is(geohex_get_zone_by_code("DO055580431").coordinate, geohex_coordinate(-65557L, -239547L), "DO055580431: x:-65557,y:-239547");
  coordinate_is(geohex_get_zone_by_code("DO053480025").coordinate, geohex_coordinate(-65568L, -241250L), "DO053480025: x:-65568,y:-241250");
  coordinate_is(geohex_get_zone_by_code("DO073506567").coordinate, geohex_coordinate(-240620L, -66198L), "DO073506567: x:-240620,y:-66198");
  coordinate_is(geohex_get_zone_by_code("CZ347013544").coordinate, geohex_coordinate(-117693L, -105237L), "CZ347013544: x:-117693,y:-105237");
  coordinate_is(geohex_get_zone_by_code("EU413474586").coordinate, geohex_coordinate(-21785L, -197548L), "EU413474586: x:-21785,y:-197548");
  coordinate_is(geohex_get_zone_by_code("EU354580674").coordinate, geohex_coordinate(-196764L, -23769L), "EU354580674: x:-196764,y:-23769");
  coordinate_is(geohex_get_zone_by_code("OK474555348").coordinate, geohex_coordinate(-17495L, -78389L), "OK474555348: x:-17495,y:-78389");
  coordinate_is(geohex_get_zone_by_code("Fb484868583").coordinate, geohex_coordinate(-95874L, 2387L), "Fb484868583: x:-95874,y:2387");
  coordinate_is(geohex_get_zone_by_code("GH147081657").coordinate, geohex_coordinate(-104426L, 58881L), "GH147081657: x:-104426,y:58881");
  coordinate_is(geohex_get_zone_by_code("GI730641802").coordinate, geohex_coordinate(-92362L, 75580L), "GI730641802: x:-92362,y:75580");
  coordinate_is(geohex_get_zone_by_code("GI576514101").coordinate, geohex_coordinate(81554L, -92343L), "GI576514101: x:81554,y:-92343");
  coordinate_is(geohex_get_zone_by_code("OY041035522").coordinate, geohex_coordinate(-7537L, -6845L), "OY041035522: x:-7537,y:-6845");
  coordinate_is(geohex_get_zone_by_code("OY537117080").coordinate, geohex_coordinate(425L, 4367L), "OY537117080: x:425,y:4367");
  coordinate_is(geohex_get_zone_by_code("PA402570238").coordinate, geohex_coordinate(-22553L, 38131L), "PA402570238: x:-22553,y:38131");
  coordinate_is(geohex_get_zone_by_code("QU058877078").coordinate, geohex_coordinate(92929L, -82142L), "QU058877078: x:92929,y:-82142");
  coordinate_is(geohex_get_zone_by_code("QU832828267").coordinate, geohex_coordinate(-72716L, 103875L), "QU832828267: x:-72716,y:103875");
  coordinate_is(geohex_get_zone_by_code("PZ382714446").coordinate, geohex_coordinate(60670L, 16037L), "PZ382714446: x:60670,y:16037");
  coordinate_is(geohex_get_zone_by_code("PZ028668414").coordinate, geohex_coordinate(51378L, 15741L), "PZ028668414: x:51378,y:15741");
  coordinate_is(geohex_get_zone_by_code("PS383657231").coordinate, geohex_coordinate(81179L, -44625L), "PS383657231: x:81179,y:-44625");
  coordinate_is(geohex_get_zone_by_code("XM602176827").coordinate, geohex_coordinate(101932L, -47400L), "XM602176827: x:101932,y:-47400");
  coordinate_is(geohex_get_zone_by_code("XM482452815").coordinate, geohex_coordinate(99852L, -36332L), "XM482452815: x:99852,y:-36332");
  coordinate_is(geohex_get_zone_by_code("XX033123366").coordinate, geohex_coordinate(111217L, -29119L), "XX033123366: x:111217,y:-29119");
  coordinate_is(geohex_get_zone_by_code("OI860616105").coordinate, geohex_coordinate(-31170L, 82105L), "OI860616105: x:-31170,y:82105");
  coordinate_is(geohex_get_zone_by_code("RX114077466").coordinate, geohex_coordinate(-8879L, 98168L), "RX114077466: x:-8879,y:98168");
  coordinate_is(geohex_get_zone_by_code("SV355072242").coordinate, geohex_coordinate(39167L, 114247L), "SV355072242: x:39167,y:114247");
  coordinate_is(geohex_get_zone_by_code("YG413103084").coordinate, geohex_coordinate(135264L, 38523L), "YG413103084: x:135264,y:38523");
  coordinate_is(geohex_get_zone_by_code("ZA486483578").coordinate, geohex_coordinate(160465L, 40888L), "ZA486483578: x:160465,y:40888");
  coordinate_is(geohex_get_zone_by_code("aX426174078").coordinate, geohex_coordinate(116473L, 99865L), "aX426174078: x:116473,y:99865");
  coordinate_is(geohex_get_zone_by_code("aX747576237").coordinate, geohex_coordinate(125488L, 98637L), "aX747576237: x:125488,y:98637");
  coordinate_is(geohex_get_zone_by_code("TK184816376").coordinate, geohex_coordinate(212332L, 41759L), "TK184816376: x:212332,y:41759");
  coordinate_is(geohex_get_zone_by_code("TO310523631").coordinate, geohex_coordinate(56060L, 229191L), "TO310523631: x:56060,y:229191");
  coordinate_is(geohex_get_zone_by_code("TO423806423").coordinate, geohex_coordinate(234195L, 60644L), "TO423806423: x:234195,y:60644");
  coordinate_is(geohex_get_zone_by_code("bb303856635").coordinate, geohex_coordinate(194922L, 108907L), "bb303856635: x:194922,y:108907");
  coordinate_is(geohex_get_zone_by_code("TO815178640").coordinate, geohex_coordinate(240443L, 66356L), "TO815178640: x:240443,y:66356");
  coordinate_is(geohex_get_zone_by_code("SV1700305142").coordinate, geohex_coordinate(101969L, 351082L), "SV1700305142: x:101969,y:351082");
  coordinate_is(geohex_get_zone_by_code("BV5482764471").coordinate, geohex_coordinate(-588706L, -331776L), "BV5482764471: x:-588706,y:-331776");
  coordinate_is(geohex_get_zone_by_code("BV7560068257").coordinate, geohex_coordinate(-569492L, -350934L), "BV7560068257: x:-569492,y:-350934");
  coordinate_is(geohex_get_zone_by_code("CI5263615540").coordinate, geohex_coordinate(-299458L, -626419L), "CI5263615540: x:-299458,y:-626419");
  coordinate_is(geohex_get_zone_by_code("CI7265571616").coordinate, geohex_coordinate(-279875L, -644203L), "CI7265571616: x:-279875,y:-644203");
  coordinate_is(geohex_get_zone_by_code("CI7505181555").coordinate, geohex_coordinate(-277938L, -644342L), "CI7505181555: x:-277938,y:-644342");
  coordinate_is(geohex_get_zone_by_code("CI5736546251").coordinate, geohex_coordinate(-287938L, -632544L), "CI5736546251: x:-287938,y:-632544");
  coordinate_is(geohex_get_zone_by_code("DO0273028158").coordinate, geohex_coordinate(-201509L, -722570L), "DO0273028158: x:-201509,y:-722570");
  coordinate_is(geohex_get_zone_by_code("DO0536546500").coordinate, geohex_coordinate(-196078L, -724405L), "DO0536546500: x:-196078,y:-724405");
  coordinate_is(geohex_get_zone_by_code("DO0716764500").coordinate, geohex_coordinate(-722848L, -197635L), "DO0716764500: x:-722848,y:-197635");
  coordinate_is(geohex_get_zone_by_code("EU4016113514").coordinate, geohex_coordinate(-67395L, -597798L), "EU4016113514: x:-67395,y:-597798");
  coordinate_is(geohex_get_zone_by_code("EU4827777232").coordinate, geohex_coordinate(-53605L, -581735L), "EU4827777232: x:-53605,y:-581735");
  coordinate_is(geohex_get_zone_by_code("EU7445272188").coordinate, geohex_coordinate(-571001L, -58046L), "EU7445272188: x:-571001,y:-58046");
  coordinate_is(geohex_get_zone_by_code("OK1777354303").coordinate, geohex_coordinate(-69258L, -236371L), "OK1777354303: x:-69258,y:-236371");
  coordinate_is(geohex_get_zone_by_code("CZ3420476772").coordinate, geohex_coordinate(-357091L, -313496L), "CZ3420476772: x:-357091,y:-313496");
  coordinate_is(geohex_get_zone_by_code("Fb4334484641").coordinate, geohex_coordinate(-295156L, -8676L), "Fb4334484641: x:-295156,y:-8676");
  coordinate_is(geohex_get_zone_by_code("GH5856584625").coordinate, geohex_coordinate(-287868L, 205168L), "GH5856584625: x:-287868,y:205168");
  coordinate_is(geohex_get_zone_by_code("GI1730824803").coordinate, geohex_coordinate(222513L, -297832L), "GI1730824803: x:222513,y:-297832");
  coordinate_is(geohex_get_zone_by_code("GI7234521114").coordinate, geohex_coordinate(-282243L, 240894L), "GI7234521114: x:-282243,y:240894");
  coordinate_is(geohex_get_zone_by_code("QU3851424320").coordinate, geohex_coordinate(-230449L, 284384L), "QU3851424320: x:-230449,y:284384");
  coordinate_is(geohex_get_zone_by_code("QU8152020110").coordinate, geohex_coordinate(307274L, -213787L), "QU8152020110: x:307274,y:-213787");
  coordinate_is(geohex_get_zone_by_code("PA0426257051").coordinate, geohex_coordinate(-80416L, 100191L), "PA0426257051: x:-80416,y:100191");
  coordinate_is(geohex_get_zone_by_code("OY4244664644").coordinate, geohex_coordinate(-6228L, 6228L), "OY4244664644: x:-6228,y:6228");
  coordinate_is(geohex_get_zone_by_code("OY7353226324").coordinate, geohex_coordinate(19383L, -4812L), "OY7353226324: x:19383,y:-4812");
  coordinate_is(geohex_get_zone_by_code("OY3444432334").coordinate, geohex_coordinate(-27L, -19749L), "OY3444432334: x:-27,y:-19749");
  coordinate_is(geohex_get_zone_by_code("QU8136543688").coordinate, geohex_coordinate(309109L, -219218L), "QU8136543688: x:309109,y:-219218");
  coordinate_is(geohex_get_zone_by_code("QU8831183154").coordinate, geohex_coordinate(-210852L, 319359L), "QU8831183154: x:-210852,y:319359");
  coordinate_is(geohex_get_zone_by_code("PS6206841033").coordinate, geohex_coordinate(248067L, -133906L), "PS6206841033: x:248067,y:-133906");
  coordinate_is(geohex_get_zone_by_code("XM0565771230").coordinate, geohex_coordinate(278036L, -132673L), "XM0565771230: x:278036,y:-132673");
  coordinate_is(geohex_get_zone_by_code("XM4863207510").coordinate, geohex_coordinate(303692L, -114283L), "XM4863207510: x:303692,y:-114283");
  coordinate_is(geohex_get_zone_by_code("XX0330807788").coordinate, geohex_coordinate(334084L, -88043L), "XX0330807788: x:334084,y:-88043");
  coordinate_is(geohex_get_zone_by_code("XM6054354111").coordinate, geohex_coordinate(308354L, -142317L), "XM6054354111: x:308354,y:-142317");
  coordinate_is(geohex_get_zone_by_code("PZ1548687734").coordinate, geohex_coordinate(158553L, 66174L), "PZ1548687734: x:158553,y:66174");
  coordinate_is(geohex_get_zone_by_code("PZ7555070851").coordinate, geohex_coordinate(196649L, 68268L), "PZ7555070851: x:196649,y:68268");
  coordinate_is(geohex_get_zone_by_code("OI7581576564").coordinate, geohex_coordinate(-96846L, 245166L), "OI7581576564: x:-96846,y:245166");
  coordinate_is(geohex_get_zone_by_code("RX1535370770").coordinate, geohex_coordinate(-19618L, 300077L), "RX1535370770: x:-19618,y:300077");
  coordinate_is(geohex_get_zone_by_code("SV7031782060").coordinate, geohex_coordinate(130781L, 345641L), "SV7031782060: x:130781,y:345641");
  coordinate_is(geohex_get_zone_by_code("SW6431665682").coordinate, geohex_coordinate(137387L, 391171L), "SW6431665682: x:137387,y:391171");
  coordinate_is(geohex_get_zone_by_code("aX1617612856").coordinate, geohex_coordinate(339859L, 288479L), "aX1617612856: x:339859,y:288479");
  coordinate_is(geohex_get_zone_by_code("aX7255422107").coordinate, geohex_coordinate(367297L, 304827L), "aX7255422107: x:367297,y:304827");
  coordinate_is(geohex_get_zone_by_code("ZA7323011017").coordinate, geohex_coordinate(489526L, 112743L), "ZA7323011017: x:489526,y:112743");
  coordinate_is(geohex_get_zone_by_code("TK0130411728").coordinate, geohex_coordinate(622465L, 95503L), "TK0130411728: x:622465,y:95503");
  coordinate_is(geohex_get_zone_by_code("TK8071386820").coordinate, geohex_coordinate(132791L, 662483L), "TK8071386820: x:132791,y:662483");
  coordinate_is(geohex_get_zone_by_code("TO4434206021").coordinate, geohex_coordinate(176837L, 706530L), "TO4434206021: x:176837,y:706530");
  coordinate_is(geohex_get_zone_by_code("bb3372146218").coordinate, geohex_coordinate(591721L, 328762L), "bb3372146218: x:591721,y:328762");
  coordinate_is(geohex_get_zone_by_code("BV57264048634").coordinate, geohex_coordinate(-1756368L, -999687L), "BV57264048634: x:-1756368,y:-999687");
  coordinate_is(geohex_get_zone_by_code("CI57246068382").coordinate, geohex_coordinate(-872017L, -1884038L), "CI57246068382: x:-872017,y:-1884038");
  coordinate_is(geohex_get_zone_by_code("DO05443747884").coordinate, geohex_coordinate(-590208L, -2165847L), "DO05443747884: x:-590208,y:-2165847");
  coordinate_is(geohex_get_zone_by_code("DO04773823048").coordinate, geohex_coordinate(-2175911L, -590930L), "DO04773823048: x:-2175911,y:-590930");
  coordinate_is(geohex_get_zone_by_code("DO04773823048").coordinate, geohex_coordinate(-2175911L, -590930L), "DO04773823048: x:-2175911,y:-590930");
  coordinate_is(geohex_get_zone_by_code("DO07200264504").coordinate, geohex_coordinate(-2174772L, -586677L), "DO07200264504: x:-2174772,y:-586677");
  coordinate_is(geohex_get_zone_by_code("CZ34837816828").coordinate, geohex_coordinate(-1055396L, -940181L), "CZ34837816828: x:-1055396,y:-940181");
  coordinate_is(geohex_get_zone_by_code("EU18781747622").coordinate, geohex_coordinate(-208219L, -1749605L), "EU18781747622: x:-208219,y:-1749605");
  coordinate_is(geohex_get_zone_by_code("EU47467037811").coordinate, geohex_coordinate(-1749082L, -179649L), "EU47467037811: x:-1749082,y:-179649");
  coordinate_is(geohex_get_zone_by_code("Fb05827021141").coordinate, geohex_coordinate(-940042L, -30780L), "Fb05827021141: x:-940042,y:-30780");
  coordinate_is(geohex_get_zone_by_code("OK72311284586").coordinate, geohex_coordinate(-140855L, -695131L), "OK72311284586: x:-140855,y:-695131");
  coordinate_is(geohex_get_zone_by_code("GH51383310718").coordinate, geohex_coordinate(-903332L, 585118L), "GH51383310718: x:-903332,y:585118");
  coordinate_is(geohex_get_zone_by_code("GI47416263465").coordinate, geohex_coordinate(-867669L, 707992L), "GI47416263465: x:-867669,y:707992");
  coordinate_is(geohex_get_zone_by_code("GI87045185255").coordinate, geohex_coordinate(-813735L, 761926L), "GI87045185255: x:-813735,y:761926");
  coordinate_is(geohex_get_zone_by_code("QU07002763476").coordinate, geohex_coordinate(-757103L, 818558L), "QU07002763476: x:-757103,y:818558");
  coordinate_is(geohex_get_zone_by_code("QU85663663436").coordinate, geohex_coordinate(953857L, -639688L), "QU85663663436: x:953857,y:-639688");
  coordinate_is(geohex_get_zone_by_code("QU84201138888").coordinate, geohex_coordinate(935104L, -645206L), "QU84201138888: x:935104,y:-645206");
  coordinate_is(geohex_get_zone_by_code("PS62147032100").coordinate, geohex_coordinate(741839L, -393961L), "PS62147032100: x:741839,y:-393961");
  coordinate_is(geohex_get_zone_by_code("XM30178015132").coordinate, geohex_coordinate(862073L, -432515L), "XM30178015132: x:862073,y:-432515");
  coordinate_is(geohex_get_zone_by_code("XM60054311737").coordinate, geohex_coordinate(918442L, -437646L), "XM60054311737: x:918442,y:-437646");
  coordinate_is(geohex_get_zone_by_code("XM44560457183").coordinate, geohex_coordinate(887214L, -350566L), "XM44560457183: x:887214,y:-350566");
  coordinate_is(geohex_get_zone_by_code("XM56456700534").coordinate, geohex_coordinate(906282L, -313572L), "XM56456700534: x:906282,y:-313572");
  coordinate_is(geohex_get_zone_by_code("XX03131786872").coordinate, geohex_coordinate(996905L, -258002L), "XX03131786872: x:996905,y:-258002");
  coordinate_is(geohex_get_zone_by_code("PZ16386410216").coordinate, geohex_coordinate(494872L, 152342L), "PZ16386410216: x:494872,y:152342");
  coordinate_is(geohex_get_zone_by_code("OI78178446320").coordinate, geohex_coordinate(-279184L, 728966L), "OI78178446320: x:-279184,y:728966");
  coordinate_is(geohex_get_zone_by_code("RX13217487787").coordinate, geohex_coordinate(-66947L, 872697L), "RX13217487787: x:-66947,y:872697");
  coordinate_is(geohex_get_zone_by_code("SV40163034106").coordinate, geohex_coordinate(329983L, 1039955L), "SV40163034106: x:329983,y:1039955");
  coordinate_is(geohex_get_zone_by_code("aX41314430862").coordinate, geohex_coordinate(1040996L, 879073L), "aX41314430862: x:1040996,y:879073");
  coordinate_is(geohex_get_zone_by_code("ZA47238521110").coordinate, geohex_coordinate(1430906L, 359720L), "ZA47238521110: x:1430906,y:359720");
  coordinate_is(geohex_get_zone_by_code("TK11857485652").coordinate, geohex_coordinate(1877264L, 363145L), "TK11857485652: x:1877264,y:363145");
  coordinate_is(geohex_get_zone_by_code("TK43222807032").coordinate, geohex_coordinate(344996L, 1938562L), "TK43222807032: x:344996,y:1938562");
  coordinate_is(geohex_get_zone_by_code("TO03574622544").coordinate, geohex_coordinate(474714L, 2053467L), "TO03574622544: x:474714,y:2053467");
  coordinate_is(geohex_get_zone_by_code("TO54114446763").coordinate, geohex_coordinate(2117055L, 590459L), "TO54114446763: x:2117055,y:590459");
  coordinate_is(geohex_get_zone_by_code("bb33540877533").coordinate, geohex_coordinate(1771092L, 990230L), "bb33540877533: x:1771092,y:990230");
  coordinate_is(geohex_get_zone_by_code("BV803254745602").coordinate, geohex_coordinate(-5202625L, -3081467L), "BV803254745602: x:-5202625,y:-3081467");
  coordinate_is(geohex_get_zone_by_code("CI803456424553").coordinate, geohex_coordinate(-2538459L, -5745886L), "CI803456424553: x:-2538459,y:-5745886");
  coordinate_is(geohex_get_zone_by_code("DO053652024200").coordinate, geohex_coordinate(-1765975L, -6518875L), "DO053652024200: x:-1765975,y:-6518875");
  coordinate_is(geohex_get_zone_by_code("DO053654462750").coordinate, geohex_coordinate(-1764847L, -6519499L), "DO053654462750: x:-1764847,y:-6519499");
  coordinate_is(geohex_get_zone_by_code("DO071704644727").coordinate, geohex_coordinate(-6510449L, -1773897L), "DO071704644727: x:-6510449,y:-1773897");
  coordinate_is(geohex_get_zone_by_code("CY281612610161").coordinate, geohex_coordinate(-3322654L, -2958555L), "CY281612610161: x:-3322654,y:-2958555");
  coordinate_is(geohex_get_zone_by_code("EU181655132036").coordinate, geohex_coordinate(-662939L, -5259073L), "EU181655132036: x:-662939,y:-5259073");
  coordinate_is(geohex_get_zone_by_code("EU832016181016").coordinate, geohex_coordinate(-5165165L, -400879L), "EU832016181016: x:-5165165,y:-400879");
  coordinate_is(geohex_get_zone_by_code("FY636801583240").coordinate, geohex_coordinate(-2988100L, -251200L), "FY636801583240: x:-2988100,y:-251200");
  coordinate_is(geohex_get_zone_by_code("OK446658243285").coordinate, geohex_coordinate(-504717L, -2148863L), "OK446658243285: x:-504717,y:-2148863");
  coordinate_is(geohex_get_zone_by_code("GH058068815001").coordinate, geohex_coordinate(-2818165L, 1488147L), "GH058068815001: x:-2818165,y:1488147");
  coordinate_is(geohex_get_zone_by_code("GI410587505268").coordinate, geohex_coordinate(2049862L, -2667944L), "GI410587505268: x:2049862,y:-2667944");
  coordinate_is(geohex_get_zone_by_code("GI871735246286").coordinate, geohex_coordinate(-2434352L, 2301680L), "GI871735246286: x:-2434352,y:2301680");
  coordinate_is(geohex_get_zone_by_code("QU460311054340").coordinate, geohex_coordinate(-2089558L, 2571740L), "QU460311054340: x:-2089558,y:2571740");
  coordinate_is(geohex_get_zone_by_code("QU533828300764").coordinate, geohex_coordinate(2662212L, -2018226L), "QU533828300764: x:2662212,y:-2018226");
  coordinate_is(geohex_get_zone_by_code("OY313181386161").coordinate, geohex_coordinate(-64051L, -194835L), "OY313181386161: x:-64051,y:-194835");
  coordinate_is(geohex_get_zone_by_code("OY803527038734").coordinate, geohex_coordinate(116433L, 106863L), "OY803527038734: x:116433,y:106863");
  coordinate_is(geohex_get_zone_by_code("PA043284261600").coordinate, geohex_coordinate(-713146L, 874949L), "PA043284261600: x:-713146,y:874949");
  coordinate_is(geohex_get_zone_by_code("PZ060785824214").coordinate, geohex_coordinate(1465440L, 278811L), "PZ060785824214: x:1465440,y:278811");
  coordinate_is(geohex_get_zone_by_code("PS625060382624").coordinate, geohex_coordinate(2238819L, -1170915L), "PS625060382624: x:2238819,y:-1170915");
  coordinate_is(geohex_get_zone_by_code("XM317558565378").coordinate, geohex_coordinate(2618653L, -1230371L), "XM317558565378: x:2618653,y:-1230371");
  coordinate_is(geohex_get_zone_by_code("XL822458403751").coordinate, geohex_coordinate(2756276L, -1335633L), "XL822458403751: x:2756276,y:-1335633");
  coordinate_is(geohex_get_zone_by_code("XP251226173262").coordinate, geohex_coordinate(2983628L, -818687L), "XP251226173262: x:2983628,y:-818687");
  coordinate_is(geohex_get_zone_by_code("OI745463230145").coordinate, geohex_coordinate(-883827L, 2142667L), "OI745463230145: x:-883827,y:2142667");
  coordinate_is(geohex_get_zone_by_code("RU681285781273").coordinate, geohex_coordinate(-319011L, 2548673L), "RU681285781273: x:-319011,y:2548673");
  coordinate_is(geohex_get_zone_by_code("SV352321156833").coordinate, geohex_coordinate(1040076L, 3085916L), "SV352321156833: x:1040076,y:3085916");
  coordinate_is(geohex_get_zone_by_code("ZA412658306821").coordinate, geohex_coordinate(4180037L, 1078581L), "ZA412658306821: x:4180037,y:1078581");
  coordinate_is(geohex_get_zone_by_code("aX413323833627").coordinate, geohex_coordinate(3127660L, 2632548L), "aX413323833627: x:3127660,y:2632548");
  coordinate_is(geohex_get_zone_by_code("bD023073480358").coordinate, geohex_coordinate(2948131L, 4106506L), "bD023073480358: x:2948131,y:4106506");
  coordinate_is(geohex_get_zone_by_code("TK570232153327").coordinate, geohex_coordinate(5877682L, 1225497L), "TK570232153327: x:5877682,y:1225497");
  coordinate_is(geohex_get_zone_by_code("TK800808780528").coordinate, geohex_coordinate(1166695L, 5949436L), "TK800808780528: x:1166695,y:5949436");
  coordinate_is(geohex_get_zone_by_code("TO328348003525").coordinate, geohex_coordinate(1555359L, 6272707L), "TO328348003525: x:1555359,y:6272707");
  coordinate_is(geohex_get_zone_by_code("TO563763855337").coordinate, geohex_coordinate(6445333L, 1690161L), "TO563763855337: x:6445333,y:1690161");
  coordinate_is(geohex_get_zone_by_code("bb337212207184").coordinate, geohex_coordinate(5324313L, 2959905L), "bb337212207184: x:5324313,y:2959905");
  coordinate_is(geohex_get_zone_by_code("BV8046354823266").coordinate, geohex_coordinate(-15569096L, -9235399L), "BV8046354823266: x:-15569096,y:-9235399");
  coordinate_is(geohex_get_zone_by_code("CI5803560714155").coordinate, geohex_coordinate(-7851906L, -16904048L), "CI5803560714155: x:-7851906,y:-16904048");
  coordinate_is(geohex_get_zone_by_code("DO0482706175341").coordinate, geohex_coordinate(-5270104L, -19587483L), "DO0482706175341: x:-5270104,y:-19587483");
  coordinate_is(geohex_get_zone_by_code("DO0482731186381").coordinate, geohex_coordinate(-5269345L, -19586724L), "DO0482731186381: x:-5269345,y:-19586724");
  coordinate_is(geohex_get_zone_by_code("DO0485035421662").coordinate, geohex_coordinate(-5262019L, -19592534L), "DO0485035421662: x:-5262019,y:-19592534");
  coordinate_is(geohex_get_zone_by_code("DO0485060618642").coordinate, geohex_coordinate(-5260267L, -19594286L), "DO0485060618642: x:-5260267,y:-19594286");
  coordinate_is(geohex_get_zone_by_code("DO0485068654767").coordinate, geohex_coordinate(-5258750L, -19592769L), "DO0485068654767: x:-5258750,y:-19592769");
  coordinate_is(geohex_get_zone_by_code("DO0712537663424").coordinate, geohex_coordinate(-19563852L, -5290701L), "DO0712537663424: x:-19563852,y:-5290701");
  coordinate_is(geohex_get_zone_by_code("DO0712564265481").coordinate, geohex_coordinate(-19562875L, -5290161L), "DO0712564265481: x:-19562875,y:-5290161");
  coordinate_is(geohex_get_zone_by_code("EU4501241604860").coordinate, geohex_coordinate(-1680172L, -15818890L), "EU4501241604860: x:-1680172,y:-15818890");
  coordinate_is(geohex_get_zone_by_code("EU8407181150325").coordinate, geohex_coordinate(-15456531L, -1119695L), "EU8407181150325: x:-15456531,y:-1119695");
  coordinate_is(geohex_get_zone_by_code("CZ3061211527483").coordinate, geohex_coordinate(-9713247L, -8732365L), "CZ3061211527483: x:-9713247,y:-8732365");
  coordinate_is(geohex_get_zone_by_code("Fb4625116215430").coordinate, geohex_coordinate(-7861861L, -98878L), "Fb4625116215430: x:-7861861,y:-98878");
  coordinate_is(geohex_get_zone_by_code("OK7250326542858").coordinate, geohex_coordinate(-1261187L, -6165599L), "OK7250326542858: x:-1261187,y:-6165599");
  coordinate_is(geohex_get_zone_by_code("GH4221515066426").coordinate, geohex_coordinate(-8229818L, 5026106L), "GH4221515066426: x:-8229818,y:5026106");
  coordinate_is(geohex_get_zone_by_code("GI4421818162227").coordinate, geohex_coordinate(6303463L, -7905318L), "GI4421818162227: x:6303463,y:-7905318");
  coordinate_is(geohex_get_zone_by_code("GI8724851414563").coordinate, geohex_coordinate(-7316322L, 6976535L), "GI8724851414563: x:-7316322,y:6976535");
  coordinate_is(geohex_get_zone_by_code("QU4074815410453").coordinate, geohex_coordinate(-6491124L, 7801733L), "QU4074815410453: x:-6491124,y:7801733");
  coordinate_is(geohex_get_zone_by_code("QU8810462030471").coordinate, geohex_coordinate(8602661L, -5690196L), "QU8810462030471: x:8602661,y:-5690196");
  coordinate_is(geohex_get_zone_by_code("PA0414822216031").coordinate, geohex_coordinate(-2181475L, 2666886L), "PA0414822216031: x:-2181475,y:2666886");
  coordinate_is(geohex_get_zone_by_code("OY4236836048713").coordinate, geohex_coordinate(-150384L, 101843L), "OY4236836048713: x:-150384,y:101843");
  coordinate_is(geohex_get_zone_by_code("OY7001555744550").coordinate, geohex_coordinate(275804L, -226708L), "OY7001555744550: x:275804,y:-226708");
  coordinate_is(geohex_get_zone_by_code("XM4117607703260").coordinate, geohex_coordinate(7760360L, -3197497L), "XM4117607703260: x:7760360,y:-3197497");
  coordinate_is(geohex_get_zone_by_code("PS6246856326218").coordinate, geohex_coordinate(6758494L, -3554783L), "PS6246856326218: x:6758494,y:-3554783");
  coordinate_is(geohex_get_zone_by_code("XL5887834871345").coordinate, geohex_coordinate(8234352L, -4010723L), "XL5887834871345: x:8234352,y:-4010723");
  coordinate_is(geohex_get_zone_by_code("XX0066438378463").coordinate, geohex_coordinate(8936922L, -2383321L), "XX0066438378463: x:8936922,y:-2383321");
  coordinate_is(geohex_get_zone_by_code("PZ4537105130820").coordinate, geohex_coordinate(4793639L, 1710866L), "PZ4537105130820: x:4793639,y:1710866");
  coordinate_is(geohex_get_zone_by_code("OI8337351073052").coordinate, geohex_coordinate(-2638423L, 6667888L), "OI8337351073052: x:-2638423,y:6667888");
  coordinate_is(geohex_get_zone_by_code("RX1135780670728").coordinate, geohex_coordinate(-700265L, 7933441L), "RX1135780670728: x:-700265,y:7933441");
  coordinate_is(geohex_get_zone_by_code("SV4163853373183").coordinate, geohex_coordinate(3077184L, 9494957L), "SV4163853373183: x:3077184,y:9494957");
  coordinate_is(geohex_get_zone_by_code("aX4034808877353").coordinate, geohex_coordinate(9394245L, 7740758L), "aX4034808877353: x:9394245,y:7740758");
  coordinate_is(geohex_get_zone_by_code("ZA4726354081160").coordinate, geohex_coordinate(12892169L, 3223472L), "ZA4726354081160: x:12892169,y:3223472");
  coordinate_is(geohex_get_zone_by_code("bD0853382488383").coordinate, geohex_coordinate(9213213L, 12436112L), "bD0853382488383: x:9213213,y:12436112");
  coordinate_is(geohex_get_zone_by_code("TK2756770452053").coordinate, geohex_coordinate(17210925L, 3758825L), "TK2756770452053: x:17210925,y:3758825");
  coordinate_is(geohex_get_zone_by_code("TK7434850466772").coordinate, geohex_coordinate(3726038L, 17486416L), "TK7434850466772: x:3726038,y:17486416");
  coordinate_is(geohex_get_zone_by_code("TO0846631354832").coordinate, geohex_coordinate(4454198L, 18748996L), "TO0846631354832: x:4454198,y:18748996");
  coordinate_is(geohex_get_zone_by_code("TO4805277813220").coordinate, geohex_coordinate(19246478L, 4927538L), "TO4805277813220: x:19246478,y:4927538");
  coordinate_is(geohex_get_zone_by_code("bb3356324634667").coordinate, geohex_coordinate(15960982L, 8892006L), "bb3356324634667: x:15960982,y:8892006");
  coordinate_is(geohex_get_zone_by_code("BV80717180121576").coordinate, geohex_coordinate(-46634477L, -27633385L), "BV80717180121576: x:-46634477,y:-27633385");
  coordinate_is(geohex_get_zone_by_code("CI56436210413512").coordinate, geohex_coordinate(-23373283L, -51622694L), "CI56436210413512: x:-23373283,y:-51622694");
  coordinate_is(geohex_get_zone_by_code("CI56773820550701").coordinate, geohex_coordinate(-23143585L, -51561147L), "CI56773820550701: x:-23143585,y:-51561147");
  coordinate_is(geohex_get_zone_by_code("CI80611150250021").coordinate, geohex_coordinate(-22761121L, -51725175L), "CI80611150250021: x:-22761121,y:-51725175");
  coordinate_is(geohex_get_zone_by_code("DO05167224507116").coordinate, geohex_coordinate(-16050458L, -58508650L), "DO05167224507116: x:-16050458,y:-58508650");
  coordinate_is(geohex_get_zone_by_code("DO05405867244763").coordinate, geohex_coordinate(-15993033L, -58493263L), "DO05405867244763: x:-15993033,y:-58493263");
  coordinate_is(geohex_get_zone_by_code("DO07170215584802").coordinate, geohex_coordinate(-58604953L, -15955292L), "DO07170215584802: x:-58604953,y:-15955292");
  coordinate_is(geohex_get_zone_by_code("DO07170226100057").coordinate, geohex_coordinate(-58604669L, -15955008L), "DO07170226100057: x:-58604669,y:-15955008");
  coordinate_is(geohex_get_zone_by_code("DO07170227640163").coordinate, geohex_coordinate(-58604100L, -15954439L), "DO07170227640163: x:-58604100,y:-15954439");
  coordinate_is(geohex_get_zone_by_code("EU16473602511456").coordinate, geohex_coordinate(-5783264L, -48388588L), "EU16473602511456: x:-5783264,y:-48388588");
  coordinate_is(geohex_get_zone_by_code("EU40673078217161").coordinate, geohex_coordinate(-48128884L, -5516832L), "EU40673078217161: x:-48128884,y:-5516832");
  coordinate_is(geohex_get_zone_by_code("CZ31831222362536").coordinate, geohex_coordinate(-29081213L, -25381885L), "CZ31831222362536: x:-29081213,y:-25381885");
  coordinate_is(geohex_get_zone_by_code("Fb31200035818717").coordinate, geohex_coordinate(-24708530L, -1503657L), "Fb31200035818717: x:-24708530,y:-1503657");
  coordinate_is(geohex_get_zone_by_code("OK44243402806508").coordinate, geohex_coordinate(-4962845L, -18975728L), "OK44243402806508: x:-4962845,y:-18975728");
  coordinate_is(geohex_get_zone_by_code("OY01571576207503").coordinate, geohex_coordinate(-2083782L, -1411177L), "OY01571576207503: x:-2083782,y:-1411177");
  coordinate_is(geohex_get_zone_by_code("OY56733420402656").coordinate, geohex_coordinate(705574L, 985547L), "OY56733420402656: x:705574,y:985547");
  coordinate_is(geohex_get_zone_by_code("GH84065825033010").coordinate, geohex_coordinate(-22434502L, 15735833L), "GH84065825033010: x:-22434502,y:15735833");
  coordinate_is(geohex_get_zone_by_code("GI50342481388451").coordinate, geohex_coordinate(18582317L, -23007372L), "GI50342481388451: x:18582317,y:-23007372");
  coordinate_is(geohex_get_zone_by_code("GI78081171860100").coordinate, geohex_coordinate(-21931681L, 19545350L), "GI78081171860100: x:-21931681,y:19545350");
  coordinate_is(geohex_get_zone_by_code("QU30541311610415").coordinate, geohex_coordinate(-19685784L, 21959398L), "QU30541311610415: x:-19685784,y:21959398");
  coordinate_is(geohex_get_zone_by_code("QU44828780263624").coordinate, geohex_coordinate(24060489L, -18874410L), "QU44828780263624: x:24060489,y:-18874410");
  coordinate_is(geohex_get_zone_by_code("PA07571045254517").coordinate, geohex_coordinate(-5813291L, 8143263L), "PA07571045254517: x:-5813291,y:8143263");
  coordinate_is(geohex_get_zone_by_code("PS38383877824230").coordinate, geohex_coordinate(19731995L, -10759711L), "PS38383877824230: x:19731995,y:-10759711");
  coordinate_is(geohex_get_zone_by_code("XM31385143063872").coordinate, geohex_coordinate(23435741L, -11259746L), "XM31385143063872: x:23435741,y:-11259746");
  coordinate_is(geohex_get_zone_by_code("XL82447011727335").coordinate, geohex_coordinate(24988122L, -12229634L), "XL82447011727335: x:24988122,y:-12229634");
  coordinate_is(geohex_get_zone_by_code("XP22503400845082").coordinate, geohex_coordinate(26510321L, -7344410L), "XP22503400845082: x:26510321,y:-7344410");
  coordinate_is(geohex_get_zone_by_code("PZ13526267300787").coordinate, geohex_coordinate(12711478L, 4472067L), "PZ13526267300787: x:12711478,y:4472067");
  coordinate_is(geohex_get_zone_by_code("OI78437338044154").coordinate, geohex_coordinate(-7420014L, 19596009L), "OI78437338044154: x:-7420014,y:19596009");
  coordinate_is(geohex_get_zone_by_code("RU68880348017456").coordinate, geohex_coordinate(-2440259L, 23062403L), "RU68880348017456: x:-2440259,y:23062403");
  coordinate_is(geohex_get_zone_by_code("SV13411223332736").coordinate, geohex_coordinate(7884118L, 28174091L), "SV13411223332736: x:7884118,y:28174091");
  coordinate_is(geohex_get_zone_by_code("aX38226176387034").coordinate, geohex_coordinate(29009196L, 23067573L), "aX38226176387034: x:29009196,y:23067573");
  coordinate_is(geohex_get_zone_by_code("ZA35122807551718").coordinate, geohex_coordinate(38012956L, 8586487L), "ZA35122807551718: x:38012956,y:8586487");
  coordinate_is(geohex_get_zone_by_code("bD32858648748733").coordinate, geohex_coordinate(28370772L, 37450940L), "bD32858648748733: x:28370772,y:37450940");
  coordinate_is(geohex_get_zone_by_code("TK18678460283758").coordinate, geohex_coordinate(51806962L, 9937300L), "TK18678460283758: x:51806962,y:9937300");
  coordinate_is(geohex_get_zone_by_code("TK35253726505866").coordinate, geohex_coordinate(9393826L, 51767942L), "TK35253726505866: x:9393826,y:51767942");
  coordinate_is(geohex_get_zone_by_code("TO35083224064751").coordinate, geohex_coordinate(14221907L, 56203392L), "TO35083224064751: x:14221907,y:56203392");
  coordinate_is(geohex_get_zone_by_code("TO45177603556405").coordinate, geohex_coordinate(57301611L, 14871166L), "TO45177603556405: x:57301611,y:14871166");
  coordinate_is(geohex_get_zone_by_code("bb33563401287846").coordinate, geohex_coordinate(47885698L, 26668610L), "bb33563401287846: x:47885698,y:26668610");
  coordinate_is(geohex_get_zone_by_code("bb33563422636071").coordinate, geohex_coordinate(47886086L, 26673021L), "bb33563422636071: x:47886086,y:26673021");
  coordinate_is(geohex_get_zone_by_code("BV801644720107680").coordinate, geohex_coordinate(-140651359L, -83080573L), "BV801644720107680: x:-140651359,y:-83080573");
  coordinate_is(geohex_get_zone_by_code("BV801672224571144").coordinate, geohex_coordinate(-140624055L, -83053269L), "BV801672224571144: x:-140624055,y:-83053269");
  coordinate_is(geohex_get_zone_by_code("BV752066087034602").coordinate, geohex_coordinate(-139339840L, -84228266L), "BV752066087034602: x:-139339840,y:-84228266");
  coordinate_is(geohex_get_zone_by_code("CI584051202811030").coordinate, geohex_coordinate(-70356394L, -151573450L), "CI584051202811030: x:-70356394,y:-151573450");
  coordinate_is(geohex_get_zone_by_code("DO053702425073344").coordinate, geohex_coordinate(-47733624L, -175943700L), "DO053702425073344: x:-47733624,y:-175943700");
  coordinate_is(geohex_get_zone_by_code("DO053474671871414").coordinate, geohex_coordinate(-47762328L, -175913289L), "DO053474671871414: x:-47762328,y:-175913289");
  coordinate_is(geohex_get_zone_by_code("DO048672464801367").coordinate, geohex_coordinate(-176219573L, -47457750L), "DO048672464801367: x:-176219573,y:-47457750");
  coordinate_is(geohex_get_zone_by_code("DO048680771383421").coordinate, geohex_coordinate(-176213803L, -47436216L), "DO048680771383421: x:-176213803,y:-47436216");
  coordinate_is(geohex_get_zone_by_code("CZ312460160330640").coordinate, geohex_coordinate(-88184962L, -76078072L), "CZ312460160330640: x:-88184962,y:-76078072");
  coordinate_is(geohex_get_zone_by_code("EU482446631807432").coordinate, geohex_coordinate(-13260322L, -141391577L), "EU482446631807432: x:-13260322,y:-141391577");
  coordinate_is(geohex_get_zone_by_code("EU443120677000135").coordinate, geohex_coordinate(-143735832L, -14847896L), "EU443120677000135: x:-143735832,y:-14847896");
  coordinate_is(geohex_get_zone_by_code("OK486263022716030").coordinate, geohex_coordinate(-12350539L, -56238016L), "OK486263022716030: x:-12350539,y:-56238016");
  coordinate_is(geohex_get_zone_by_code("Fb563137601173436").coordinate, geohex_coordinate(-70304192L, 2589377L), "Fb563137601173436: x:-70304192,y:2589377");
  coordinate_is(geohex_get_zone_by_code("GH405610617770460").coordinate, geohex_coordinate(-73235041L, 41780417L), "GH405610617770460: x:-73235041,y:41780417");
  coordinate_is(geohex_get_zone_by_code("GI428447007470857").coordinate, geohex_coordinate(56344474L, -69627534L), "GI428447007470857: x:56344474,y:-69627534");
  coordinate_is(geohex_get_zone_by_code("GI714676472576137").coordinate, geohex_coordinate(-68298452L, 57199740L), "GI714676472576137: x:-68298452,y:57199740");
  coordinate_is(geohex_get_zone_by_code("QU430846555413857").coordinate, geohex_coordinate(-57730310L, 69785697L), "QU430846555413857: x:-57730310,y:69785697");
  coordinate_is(geohex_get_zone_by_code("QU455868523435074").coordinate, geohex_coordinate(71998221L, -55124127L), "QU455868523435074: x:71998221,y:-55124127");
  coordinate_is(geohex_get_zone_by_code("XM314886135481601").coordinate, geohex_coordinate(70399589L, -33265659L), "XM314886135481601: x:70399589,y:-33265659");
  coordinate_is(geohex_get_zone_by_code("PS624076167125758").coordinate, geohex_coordinate(60481900L, -32085365L), "PS624076167125758: x:60481900,y:-32085365");
  coordinate_is(geohex_get_zone_by_code("XL828827023882162").coordinate, geohex_coordinate(75593945L, -35906546L), "XL828827023882162: x:75593945,y:-35906546");
  coordinate_is(geohex_get_zone_by_code("XP252183615213788").coordinate, geohex_coordinate(80664997L, -21755327L), "XP252183615213788: x:80664997,y:-21755327");
  coordinate_is(geohex_get_zone_by_code("OY441655876848342").coordinate, geohex_coordinate(-344548L, -92321L), "OY441655876848342: x:-344548,y:-92321");
  coordinate_is(geohex_get_zone_by_code("OY450583438341310").coordinate, geohex_coordinate(-471694L, 1277684L), "OY450583438341310: x:-471694,y:1277684");
  coordinate_is(geohex_get_zone_by_code("PA007023204648554").coordinate, geohex_coordinate(-20439432L, 22186911L), "PA007023204648554: x:-20439432,y:22186911");
  coordinate_is(geohex_get_zone_by_code("OI754343508378851").coordinate, geohex_coordinate(-23916187L, 58798020L), "OI754343508378851: x:-23916187,y:58798020");
  coordinate_is(geohex_get_zone_by_code("RX153284780083552").coordinate, geohex_coordinate(-4893211L, 73044895L), "RX153284780083552: x:-4893211,y:73044895");
  coordinate_is(geohex_get_zone_by_code("PZ541437131806627").coordinate, geohex_coordinate(42527869L, 19070769L), "PZ541437131806627: x:42527869,y:19070769");
  coordinate_is(geohex_get_zone_by_code("SV081012647253500").coordinate, geohex_coordinate(24728891L, 82741073L), "SV081012647253500: x:24728891,y:82741073");
  coordinate_is(geohex_get_zone_by_code("ZA162768706170274").coordinate, geohex_coordinate(111331956L, 27592632L), "ZA162768706170274: x:111331956,y:27592632");
  coordinate_is(geohex_get_zone_by_code("aX538661552510561").coordinate, geohex_coordinate(86840561L, 75238125L), "aX538661552510561: x:86840561,y:75238125");
  coordinate_is(geohex_get_zone_by_code("bD475537206875044").coordinate, geohex_coordinate(87699744L, 115444701L), "bD475537206875044: x:87699744,y:115444701");
  coordinate_is(geohex_get_zone_by_code("TK573170435224014").coordinate, geohex_coordinate(159294183L, 32928516L), "TK573170435224014: x:159294183,y:32928516");
  coordinate_is(geohex_get_zone_by_code("TK720137660817775").coordinate, geohex_coordinate(31205775L, 158832577L), "TK720137660817775: x:31205775,y:158832577");
  coordinate_is(geohex_get_zone_by_code("TO078855632751174").coordinate, geohex_coordinate(40572705L, 168183297L), "TO078855632751174: x:40572705,y:168183297");
  coordinate_is(geohex_get_zone_by_code("TO448407012467243").coordinate, geohex_coordinate(43529418L, 172653371L), "TO448407012467243: x:43529418,y:172653371");
  coordinate_is(geohex_get_zone_by_code("TO801157747467437").coordinate, geohex_coordinate(174694024L, 46294332L), "TO801157747467437: x:174694024,y:46294332");
  coordinate_is(geohex_get_zone_by_code("bb337184418811744").coordinate, geohex_coordinate(143901099L, 79776171L), "bb337184418811744: x:143901099,y:79776171");
}

void coord2hex (void) {
  // verify
  ok(geohex_verify_code("XM") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EX2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aZ2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI76") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU06") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU13") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH32") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK51") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL60") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ18") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU88") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb17") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb34") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb86") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK63") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO42") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK02") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD31") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE73") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO84") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB61") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YF58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX15") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO045") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO056") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO077") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV778") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU570") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU868") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK468") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY443") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY004") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb526") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI440") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU026") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU630") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ580") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY864") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV385") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX355") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD744") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO808") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO474") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO073") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB648") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG168") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7541") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0532") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO3203") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU6235") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7172") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ0737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb0200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb8608") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI2651") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC2121") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7871") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4212") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4362") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OX2538") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY5663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OG6663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV8518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3246") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1825") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TR1202") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4054") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA5685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4881") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6270") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80373") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO08354") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU31135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU45042") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ35087") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK06445") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb80457") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH80422") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI74753") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI80240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU01265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU86344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY77334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY15454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04170") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS68342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM78145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM48257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03156") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ47685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40654") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI71873") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX40264") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA44552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD47117") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK51615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK71615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO38458") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO58484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV553581") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI802417") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI750110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO018862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053505") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO074664") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ351822") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU412420") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU708101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK847038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH501658") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI842644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI836575") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU316588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU175485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb711277") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY728344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA016372") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU408880") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM442337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS387785") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX037037") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ173676") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV321726") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC828583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI713375") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD080050") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX817100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA712478") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK166315") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK873482") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO433402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO586342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb335332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8032788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7714524") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0514686") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0517300") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732687") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732768") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4031833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8072131") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8255485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3800810") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1624776") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7464515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb5316746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4033527") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4540858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4351804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8387484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0706771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4884047") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8251271") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0565644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY8320288") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3556486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ8016814") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1746604") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6242083") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM5643552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6303820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM7851800") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0345653") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6306347") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8827707") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4253332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8776718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PF2148656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4587731") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4335020") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV5843218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0682573") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8100870") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4424804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE6100113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK5027217") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7070414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO6240542") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO7775738") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO5821675") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3371862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV54870250") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV78253862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57758513") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI75600226") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05603615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07152160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU41063674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU72201265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34762511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb38241503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK48511367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI32042116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI71565064") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH45442518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY33228746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA03278283") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU42174351") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU47122108") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM32230826") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56301016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS61272751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60832123") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU63124187") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03173236") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38755703") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ57757416") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fc51504013") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OW22586402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC52458806") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV20852101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX46486040") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA62754057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD28367162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK05722747") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK83151057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO31130720") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO51331450") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33488116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV804240512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI708565326") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI754848748") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO055580431") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053480025") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO073506567") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ347013544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU413474586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU354580674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK474555348") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb484868583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH147081657") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI730641802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI576514101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY041035522") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY537117080") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA402570238") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU058877078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU832828267") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ382714446") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ028668414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS383657231") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM602176827") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM482452815") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX033123366") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI860616105") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX114077466") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV355072242") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG413103084") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA486483578") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX426174078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX747576237") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK184816376") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO310523631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO423806423") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb303856635") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO815178640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV1700305142") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV5482764471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7560068257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5263615540") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7265571616") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7505181555") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5736546251") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0273028158") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0536546500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0716764500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4016113514") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4827777232") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU7445272188") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1777354303") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3420476772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4334484641") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH5856584625") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1730824803") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI7234521114") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU3851424320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8152020110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0426257051") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4244664644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7353226324") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3444432334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8136543688") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8831183154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6206841033") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM0565771230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4863207510") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0330807788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6054354111") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1548687734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ7555070851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI7581576564") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1535370770") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV7031782060") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6431665682") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX1617612856") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX7255422107") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA7323011017") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK0130411728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK8071386820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4434206021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3372146218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV57264048634") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57246068382") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05443747884") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07200264504") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34837816828") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU18781747622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU47467037811") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb05827021141") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK72311284586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH51383310718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47416263465") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI87045185255") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU07002763476") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU85663663436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU84201138888") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62147032100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM30178015132") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60054311737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM44560457183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56456700534") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03131786872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ16386410216") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78178446320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX13217487787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40163034106") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX41314430862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA47238521110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK11857485652") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK43222807032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO03574622544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO54114446763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33540877533") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV803254745602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI803456424553") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053652024200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053654462750") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO071704644727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CY281612610161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU181655132036") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU832016181016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("FY636801583240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK446658243285") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH058068815001") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI410587505268") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI871735246286") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU460311054340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU533828300764") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY313181386161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY803527038734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA043284261600") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ060785824214") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS625060382624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM317558565378") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL822458403751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP251226173262") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI745463230145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU681285781273") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV352321156833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA412658306821") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX413323833627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD023073480358") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK570232153327") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK800808780528") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO328348003525") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO563763855337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337212207184") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8046354823266") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5803560714155") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482706175341") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482731186381") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485035421662") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485060618642") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485068654767") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712537663424") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712564265481") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4501241604860") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8407181150325") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3061211527483") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4625116215430") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7250326542858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4221515066426") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4421818162227") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8724851414563") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4074815410453") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8810462030471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0414822216031") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4236836048713") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7001555744550") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4117607703260") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6246856326218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL5887834871345") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0066438378463") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4537105130820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8337351073052") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1135780670728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4163853373183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4034808877353") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4726354081160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD0853382488383") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK2756770452053") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7434850466772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO0846631354832") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4805277813220") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3356324634667") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80717180121576") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56436210413512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56773820550701") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI80611150250021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05167224507116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05405867244763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170215584802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170226100057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170227640163") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU16473602511456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU40673078217161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ31831222362536") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb31200035818717") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK44243402806508") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY01571576207503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY56733420402656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH84065825033010") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI50342481388451") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI78081171860100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU30541311610415") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU44828780263624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA07571045254517") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS38383877824230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM31385143063872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL82447011727335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP22503400845082") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ13526267300787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78437338044154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU68880348017456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV13411223332736") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX38226176387034") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA35122807551718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD32858648748733") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK18678460283758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK35253726505866") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO35083224064751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO45177603556405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563401287846") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563422636071") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801644720107680") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801672224571144") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV752066087034602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI584051202811030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053702425073344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053474671871414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048672464801367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048680771383421") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ312460160330640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU482446631807432") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU443120677000135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK486263022716030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb563137601173436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH405610617770460") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI428447007470857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI714676472576137") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU430846555413857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU455868523435074") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM314886135481601") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624076167125758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL828827023882162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP252183615213788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY441655876848342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY450583438341310") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA007023204648554") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI754343508378851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX153284780083552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ541437131806627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV081012647253500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA162768706170274") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX538661552510561") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD475537206875044") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK573170435224014") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK720137660817775") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO078855632751174") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO448407012467243") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO801157747467437") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337184418811744") == GEOHEX3_VERIFY_RESULT_SUCCESS);

  // coord2hex
  str_is(geohex_get_zone_by_location(geohex_location(33.3513795014662L, 135.610448095703L), 0).code, "XM", "lat:33.3513795014662,lng:135.610448095703,level:0: XM");
  str_is(geohex_get_zone_by_location(geohex_location(-1.15050062287007L, -9.2333019042969L), 0).code, "OY", "lat:-1.15050062287007,lng:-9.2333019042969,level:0: OY");
  str_is(geohex_get_zone_by_location(geohex_location(-2.73157384094483L, 178.940526220703L), 0).code, "GI", "lat:-2.73157384094483,lng:178.940526220703,level:0: GI");
  str_is(geohex_get_zone_by_location(geohex_location(4.64510641861202L, -174.819239404297L), 0).code, "QU", "lat:4.64510641861202,lng:-174.819239404297,level:0: QU");
  str_is(geohex_get_zone_by_location(geohex_location(-23.4907376902333L, -158.295801904297L), 0).code, "GH", "lat:-23.4907376902333,lng:-158.295801904297,level:0: GH");
  str_is(geohex_get_zone_by_location(geohex_location(-76.2497182061045L, 176.391698095703L), 0).code, "EU", "lat:-76.2497182061045,lng:176.391698095703,level:0: EU");
  str_is(geohex_get_zone_by_location(geohex_location(-85.2523394635965L, 108.891698095703L), 0).code, "CI", "lat:-85.2523394635965,lng:108.891698095703,level:0: CI");
  str_is(geohex_get_zone_by_location(geohex_location(-84.8900362156735L, -83.7645519042969L), 0).code, "BV", "lat:-84.8900362156735,lng:-83.7645519042969,level:0: BV");
  str_is(geohex_get_zone_by_location(geohex_location(-47.2250012375504L, -102.045801904297L), 0).code, "Fb", "lat:-47.2250012375504,lng:-102.045801904297,level:0: Fb");
  str_is(geohex_get_zone_by_location(geohex_location(66.684617798596L, -87.9833019042969L), 0).code, "SV", "lat:66.684617798596,lng:-87.9833019042969,level:0: SV");
  str_is(geohex_get_zone_by_location(geohex_location(84.648233414888L, -177.983301904297L), 0).code, "TO", "lat:84.648233414888,lng:-177.983301904297,level:0: TO");
  str_is(geohex_get_zone_by_location(geohex_location(82.2724484946331L, 172.876073095703L), 0).code, "TK", "lat:82.2724484946331,lng:172.876073095703,level:0: TK");
  str_is(geohex_get_zone_by_location(geohex_location(82.9931560555461L, -35.9520519042969L), 0).code, "bD", "lat:82.9931560555461,lng:-35.9520519042969,level:0: bD");
  str_is(geohex_get_zone_by_location(geohex_location(76.6170490163304L, 112.407323095703L), 0).code, "ZA", "lat:76.6170490163304,lng:112.407323095703,level:0: ZA");
  str_is(geohex_get_zone_by_location(geohex_location(75.0709491329254L, 24.5166980957031L), 0).code, "aX", "lat:75.0709491329254,lng:24.5166980957031,level:0: aX");
  str_is(geohex_get_zone_by_location(geohex_location(42.3526322276402L, 30.1416980957031L), 0).code, "PZ", "lat:42.3526322276402,lng:30.1416980957031,level:0: PZ");
  str_is(geohex_get_zone_by_location(geohex_location(-46.7453426931156L, 61.7823230957031L), 0).code, "OK", "lat:-46.7453426931156,lng:61.7823230957031,level:0: OK");
  str_is(geohex_get_zone_by_location(geohex_location(-78.4041456239641L, -16.9676769042969L), 1).code, "CZ3", "lat:-78.4041456239641,lng:-16.9676769042969,level:1: CZ3");
  str_is(geohex_get_zone_by_location(geohex_location(-84.7383871209534L, 119.53125L), 1).code, "CI8", "lat:-84.7383871209534,lng:119.53125,level:1: CI8");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0137687469871L, 177.094823095703L), 1).code, "DO0", "lat:-85.0137687469871,lng:177.094823095703,level:1: DO0");
  str_is(geohex_get_zone_by_location(geohex_location(-75.4088542284645L, -175.78125L), 1).code, "EX2", "lat:-75.4088542284645,lng:-175.78125,level:1: EX2");
  str_is(geohex_get_zone_by_location(geohex_location(-77.9156689863258L, 175.78125L), 1).code, "EU1", "lat:-77.9156689863258,lng:175.78125,level:1: EU1");
  str_is(geohex_get_zone_by_location(geohex_location(-51.3992056535538L, 59.0625L), 1).code, "OK4", "lat:-51.3992056535538,lng:59.0625,level:1: OK4");
  str_is(geohex_get_zone_by_location(geohex_location(-12.4765711629959L, -175.873926904297L), 1).code, "GI3", "lat:-12.4765711629959,lng:-175.873926904297,level:1: GI3");
  str_is(geohex_get_zone_by_location(geohex_location(-15.2841851140764L, 174.375L), 1).code, "GI1", "lat:-15.2841851140764,lng:174.375,level:1: GI1");
  str_is(geohex_get_zone_by_location(geohex_location(7.09295413795132L, 178.501073095703L), 1).code, "QU0", "lat:7.09295413795132,lng:178.501073095703,level:1: QU0");
  str_is(geohex_get_zone_by_location(geohex_location(15.3612360133079L, -177.280176904297L), 1).code, "QU7", "lat:15.3612360133079,lng:-177.280176904297,level:1: QU7");
  str_is(geohex_get_zone_by_location(geohex_location(-16.6361918783976L, -161.71875L), 1).code, "GH8", "lat:-16.6361918783976,lng:-161.71875,level:1: GH8");
  str_is(geohex_get_zone_by_location(geohex_location(-7.01366792756663L, -1.40625L), 1).code, "OY0", "lat:-7.01366792756663,lng:-1.40625,level:1: OY0");
  str_is(geohex_get_zone_by_location(geohex_location(-51.6180165487737L, -97.03125L), 1).code, "Fb3", "lat:-51.6180165487737,lng:-97.03125,level:1: Fb3");
  str_is(geohex_get_zone_by_location(geohex_location(31.952162238025L, 140.625L), 1).code, "XM4", "lat:31.952162238025,lng:140.625,level:1: XM4");
  str_is(geohex_get_zone_by_location(geohex_location(38.8848059617649L, 39.2823230957031L), 1).code, "PZ0", "lat:38.8848059617649,lng:39.2823230957031,level:1: PZ0");
  str_is(geohex_get_zone_by_location(geohex_location(70.6126142380192L, -87.1875L), 1).code, "SW6", "lat:70.6126142380192,lng:-87.1875,level:1: SW6");
  str_is(geohex_get_zone_by_location(geohex_location(65.9464717761574L, -77.34375L), 1).code, "SV3", "lat:65.9464717761574,lng:-77.34375,level:1: SV3");
  str_is(geohex_get_zone_by_location(geohex_location(76.5168188771732L, 18.28125L), 1).code, "aX0", "lat:76.5168188771732,lng:18.28125,level:1: aX0");
  str_is(geohex_get_zone_by_location(geohex_location(79.4470123748349L, 18.1885730957031L), 1).code, "aX8", "lat:79.4470123748349,lng:18.1885730957031,level:1: aX8");
  str_is(geohex_get_zone_by_location(geohex_location(82.1293312094838L, -33.8426769042969L), 1).code, "aZ2", "lat:82.1293312094838,lng:-33.8426769042969,level:1: aZ2");
  str_is(geohex_get_zone_by_location(geohex_location(84.2671724043167L, 178.59375L), 1).code, "TO4", "lat:84.2671724043167,lng:178.59375,level:1: TO4");
  str_is(geohex_get_zone_by_location(geohex_location(83.520162383532L, 174.375L), 1).code, "aB6", "lat:83.520162383532,lng:174.375,level:1: aB6");
  str_is(geohex_get_zone_by_location(geohex_location(81.3083209005181L, 172.96875L), 1).code, "TK1", "lat:81.3083209005181,lng:172.96875,level:1: TK1");
  str_is(geohex_get_zone_by_location(geohex_location(81.0932138526084L, -171.5625L), 1).code, "TK3", "lat:81.0932138526084,lng:-171.5625,level:1: TK3");
  str_is(geohex_get_zone_by_location(geohex_location(74.4021625984244L, 119.53125L), 1).code, "ZA4", "lat:74.4021625984244,lng:119.53125,level:1: ZA4");
  str_is(geohex_get_zone_by_location(geohex_location(0.0798907783945947L, -61.9676769042969L), 1).code, "PA0", "lat:0.0798907783945947,lng:-61.9676769042969,level:1: PA0");
  str_is(geohex_get_zone_by_location(geohex_location(-84.5413610731341L, -77.34375L), 1).code, "BV8", "lat:-84.5413610731341,lng:-77.34375,level:1: BV8");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 130.78125L), 2).code, "CI76", "lat:-85.0511287798066,lng:130.78125,level:2: CI76");
  str_is(geohex_get_zone_by_location(geohex_location(-85.04423207151L, 111.001073095703L), 2).code, "CI55", "lat:-85.04423207151,lng:111.001073095703,level:2: CI55");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9438366148284L, -178.505859375L), 2).code, "DO07", "lat:-84.9438366148284,lng:-178.505859375,level:2: DO07");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9212535198558L, 177.534276220703L), 2).code, "DO05", "lat:-84.9212535198558,lng:177.534276220703,level:2: DO05");
  str_is(geohex_get_zone_by_location(geohex_location(-79.2371850060933L, -174.7265625L), 2).code, "EU06", "lat:-79.2371850060933,lng:-174.7265625,level:2: EU06");
  str_is(geohex_get_zone_by_location(geohex_location(-78.6142448093152L, 174.282323095703L), 2).code, "EU13", "lat:-78.6142448093152,lng:174.282323095703,level:2: EU13");
  str_is(geohex_get_zone_by_location(geohex_location(-27.0591257843741L, -157.5L), 2).code, "GH32", "lat:-27.0591257843741,lng:-157.5,level:2: GH32");
  str_is(geohex_get_zone_by_location(geohex_location(-47.9899216674142L, 52.03125L), 2).code, "OK51", "lat:-47.9899216674142,lng:52.03125,level:2: OK51");
  str_is(geohex_get_zone_by_location(geohex_location(-11.1784018737118L, -178.59375L), 2).code, "GI47", "lat:-11.1784018737118,lng:-178.59375,level:2: GI47");
  str_is(geohex_get_zone_by_location(geohex_location(-8.32812783056059L, 175.688573095703L), 2).code, "GI53", "lat:-8.32812783056059,lng:175.688573095703,level:2: GI53");
  str_is(geohex_get_zone_by_location(geohex_location(7.09295413795179L, 179.907323095703L), 2).code, "QU08", "lat:7.09295413795179,lng:179.907323095703,level:2: QU08");
  str_is(geohex_get_zone_by_location(geohex_location(6.91848534360103L, -165.502833154297L), 2).code, "OC58", "lat:6.91848534360103,lng:-165.502833154297,level:2: OC58");
  str_is(geohex_get_zone_by_location(geohex_location(19.4769502064884L, 173.408203125L), 2).code, "XL60", "lat:19.4769502064884,lng:173.408203125,level:2: XL60");
  str_is(geohex_get_zone_by_location(geohex_location(35.2390854919664L, 137.016698095703L), 2).code, "XM56", "lat:35.2390854919664,lng:137.016698095703,level:2: XM56");
  str_is(geohex_get_zone_by_location(geohex_location(22.3426767537396L, 128.579198095703L), 2).code, "PS62", "lat:22.3426767537396,lng:128.579198095703,level:2: PS62");
  str_is(geohex_get_zone_by_location(geohex_location(42.8701013280904L, 142.641698095703L), 2).code, "XX03", "lat:42.8701013280904,lng:142.641698095703,level:2: XX03");
  str_is(geohex_get_zone_by_location(geohex_location(40.9798980696201L, 45.703125L), 2).code, "PZ38", "lat:40.9798980696201,lng:45.703125,level:2: PZ38");
  str_is(geohex_get_zone_by_location(geohex_location(36.0313317763319L, 38.671875L), 2).code, "PZ04", "lat:36.0313317763319,lng:38.671875,level:2: PZ04");
  str_is(geohex_get_zone_by_location(geohex_location(40.9798980696201L, 33.046875L), 2).code, "PZ18", "lat:40.9798980696201,lng:33.046875,level:2: PZ18");
  str_is(geohex_get_zone_by_location(geohex_location(-12.1330854540274L, -0.0926769042968978L), 2).code, "OU88", "lat:-12.1330854540274,lng:-0.0926769042968978,level:2: OU88");
  str_is(geohex_get_zone_by_location(geohex_location(3.51342104564004L, -4.921875L), 2).code, "OY53", "lat:3.51342104564004,lng:-4.921875,level:2: OY53");
  str_is(geohex_get_zone_by_location(geohex_location(4.21494314139065L, -59.765625L), 2).code, "PA04", "lat:4.21494314139065,lng:-59.765625,level:2: PA04");
  str_is(geohex_get_zone_by_location(geohex_location(-51.6180165487737L, -105.46875L), 2).code, "Fb17", "lat:-51.6180165487737,lng:-105.46875,level:2: Fb17");
  str_is(geohex_get_zone_by_location(geohex_location(-51.6180165487737L, -93.515625L), 2).code, "Fb34", "lat:-51.6180165487737,lng:-93.515625,level:2: Fb34");
  str_is(geohex_get_zone_by_location(geohex_location(-44.2823986826075L, -95.7176769042969L), 2).code, "Fb86", "lat:-44.2823986826075,lng:-95.7176769042969,level:2: Fb86");
  str_is(geohex_get_zone_by_location(geohex_location(-17.30868788677L, -167.34375L), 2).code, "GH58", "lat:-17.30868788677,lng:-167.34375,level:2: GH58");
  str_is(geohex_get_zone_by_location(geohex_location(81.5816722445285L, -165.327051904297L), 2).code, "TK63", "lat:81.5816722445285,lng:-165.327051904297,level:2: TK63");
  str_is(geohex_get_zone_by_location(geohex_location(83.7242834670548L, -177.983301904297L), 2).code, "TO07", "lat:83.7242834670548,lng:-177.983301904297,level:2: TO07");
  str_is(geohex_get_zone_by_location(geohex_location(84.4478417707319L, 176.391698095703L), 2).code, "TO42", "lat:84.4478417707319,lng:176.391698095703,level:2: TO42");
  str_is(geohex_get_zone_by_location(geohex_location(80.4157074446218L, 175.78125L), 2).code, "TK02", "lat:80.4157074446218,lng:175.78125,level:2: TK02");
  str_is(geohex_get_zone_by_location(geohex_location(82.4592554716036L, -35.9520519042969L), 2).code, "bD31", "lat:82.4592554716036,lng:-35.9520519042969,level:2: bD31");
  str_is(geohex_get_zone_by_location(geohex_location(84.648233414888L, -51.4208019042969L), 2).code, "bE73", "lat:84.648233414888,lng:-51.4208019042969,level:2: bE73");
  str_is(geohex_get_zone_by_location(geohex_location(85.0352492274202L, 90.0831043457031L), 2).code, "bb33", "lat:85.0352492274202,lng:90.0831043457031,level:2: bb33");
  str_is(geohex_get_zone_by_location(geohex_location(85.0511287798066L, 179.912109375L), 2).code, "TO84", "lat:85.0511287798066,lng:179.912109375,level:2: TO84");
  str_is(geohex_get_zone_by_location(geohex_location(84.5162211763226L, -177.275390625L), 2).code, "TO47", "lat:84.5162211763226,lng:-177.275390625,level:2: TO47");
  str_is(geohex_get_zone_by_location(geohex_location(83.163581025311L, 171.826171875L), 2).code, "aB61", "lat:83.163581025311,lng:171.826171875,level:2: aB61");
  str_is(geohex_get_zone_by_location(geohex_location(73.5283994876517L, 119.1796875L), 2).code, "ZA08", "lat:73.5283994876517,lng:119.1796875,level:2: ZA08");
  str_is(geohex_get_zone_by_location(geohex_location(78.5604882839878L, 10.8984375L), 2).code, "aX55", "lat:78.5604882839878,lng:10.8984375,level:2: aX55");
  str_is(geohex_get_zone_by_location(geohex_location(75.8451685402704L, 21.09375L), 2).code, "aX04", "lat:75.8451685402704,lng:21.09375,level:2: aX04");
  str_is(geohex_get_zone_by_location(geohex_location(76.5966908036953L, 33.3936512207031L), 2).code, "YF58", "lat:76.5966908036953,lng:33.3936512207031,level:2: YF58");
  str_is(geohex_get_zone_by_location(geohex_location(66.6529774005528L, -80.859375L), 2).code, "SV40", "lat:66.6529774005528,lng:-80.859375,level:2: SV40");
  str_is(geohex_get_zone_by_location(geohex_location(47.9845674191572L, -108.286036279297L), 2).code, "RX15", "lat:47.9845674191572,lng:-108.286036279297,level:2: RX15");
  str_is(geohex_get_zone_by_location(geohex_location(-25.4901725033649L, -1.05947377929692L), 2).code, "OU40", "lat:-25.4901725033649,lng:-1.05947377929692,level:2: OU40");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -82.96875L), 2).code, "BV56", "lat:-85.0511287798066,lng:-82.96875,level:2: BV56");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 128.3203125L), 3).code, "CI771", "lat:-85.0511287798066,lng:128.3203125,level:3: CI771");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0624888102515L, 179.3408203125L), 3).code, "DO045", "lat:-85.0624888102515,lng:179.3408203125,level:3: DO045");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0378424552699L, 179.23095703125L), 3).code, "DO056", "lat:-85.0378424552699,lng:179.23095703125,level:3: DO056");
  str_is(geohex_get_zone_by_location(geohex_location(-84.965795444271L, -177.280176904297L), 3).code, "DO077", "lat:-84.965795444271,lng:-177.280176904297,level:3: DO077");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9593049562383L, -70.83984375L), 3).code, "BV778", "lat:-84.9593049562383,lng:-70.83984375,level:3: BV778");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0662697036382L, -82.177734375L), 3).code, "BV568", "lat:-85.0662697036382,lng:-82.177734375,level:3: BV568");
  str_is(geohex_get_zone_by_location(geohex_location(-78.4905516616031L, -12.12890625L), 3).code, "CZ335", "lat:-78.4905516616031,lng:-12.12890625,level:3: CZ335");
  str_is(geohex_get_zone_by_location(geohex_location(-76.5577429389655L, 175.4296875L), 3).code, "EU570", "lat:-76.5577429389655,lng:175.4296875,level:3: EU570");
  str_is(geohex_get_zone_by_location(geohex_location(-75.5376233349686L, -175.412501123047L), 3).code, "EU868", "lat:-75.5376233349686,lng:-175.412501123047,level:3: EU868");
  str_is(geohex_get_zone_by_location(geohex_location(-49.3823727870095L, 64.6875L), 3).code, "OK468", "lat:-49.3823727870095,lng:64.6875,level:3: OK468");
  str_is(geohex_get_zone_by_location(geohex_location(-0.703107352436478L, 0.703125L), 3).code, "OY443", "lat:-0.703107352436478,lng:0.703125,level:3: OY443");
  str_is(geohex_get_zone_by_location(geohex_location(-10.4878118820567L, 0L), 3).code, "OY004", "lat:-10.4878118820567,lng:0,level:3: OY004");
  str_is(geohex_get_zone_by_location(geohex_location(-47.5172006978394L, -109.6875L), 3).code, "Fb526", "lat:-47.5172006978394,lng:-109.6875,level:3: Fb526");
  str_is(geohex_get_zone_by_location(geohex_location(-15.2841851140764L, -166.640625L), 3).code, "GH588", "lat:-15.2841851140764,lng:-166.640625,level:3: GH588");
  str_is(geohex_get_zone_by_location(geohex_location(-12.1975231443078L, 179.665623876953L), 3).code, "GI440", "lat:-12.1975231443078,lng:179.665623876953,level:3: GI440");
  str_is(geohex_get_zone_by_location(geohex_location(-11.5093959703978L, -172.600001123047L), 3).code, "GI622", "lat:-11.5093959703978,lng:-172.600001123047,level:3: GI622");
  str_is(geohex_get_zone_by_location(geohex_location(6.67848578014459L, -173.303126123047L), 3).code, "QU340", "lat:6.67848578014459,lng:-173.303126123047,level:3: QU340");
  str_is(geohex_get_zone_by_location(geohex_location(4.21494314139065L, 177.1875L), 3).code, "QU026", "lat:4.21494314139065,lng:177.1875,level:3: QU026");
  str_is(geohex_get_zone_by_location(geohex_location(34.0278228898362L, 137.478123876953L), 3).code, "XM454", "lat:34.0278228898362,lng:137.478123876953,level:3: XM454");
  str_is(geohex_get_zone_by_location(geohex_location(22.5937260639293L, 128.49609375L), 3).code, "PS624", "lat:22.5937260639293,lng:128.49609375,level:3: PS624");
  str_is(geohex_get_zone_by_location(geohex_location(44.3395652480971L, 142.294921875L), 3).code, "XX038", "lat:44.3395652480971,lng:142.294921875,level:3: XX038");
  str_is(geohex_get_zone_by_location(geohex_location(40.0444375846086L, 135.52734375L), 3).code, "XU630", "lat:40.0444375846086,lng:135.52734375,level:3: XU630");
  str_is(geohex_get_zone_by_location(geohex_location(39.0959629363055L, 45.3515625L), 3).code, "PZ342", "lat:39.0959629363055,lng:45.3515625,level:3: PZ342");
  str_is(geohex_get_zone_by_location(geohex_location(46.0829232667361L, 33.239842626953L), 3).code, "PZ580", "lat:46.0829232667361,lng:33.239842626953,level:3: PZ580");
  str_is(geohex_get_zone_by_location(geohex_location(7.71099165543323L, 4.21875L), 3).code, "OY864", "lat:7.71099165543323,lng:4.21875,level:3: OY864");
  str_is(geohex_get_zone_by_location(geohex_location(-3.51342104564003L, -7.734375L), 3).code, "OY145", "lat:-3.51342104564003,lng:-7.734375,level:3: OY145");
  str_is(geohex_get_zone_by_location(geohex_location(2.81137119333114L, -59.4140625L), 3).code, "PA032", "lat:2.81137119333114,lng:-59.4140625,level:3: PA032");
  str_is(geohex_get_zone_by_location(geohex_location(27.6959007090629L, -115.471094873047L), 3).code, "OI758", "lat:27.6959007090629,lng:-115.471094873047,level:3: OI758");
  str_is(geohex_get_zone_by_location(geohex_location(67.7427590666639L, -84.7265625L), 3).code, "SV428", "lat:67.7427590666639,lng:-84.7265625,level:3: SV428");
  str_is(geohex_get_zone_by_location(geohex_location(67.067433351083L, -74.1796875L), 3).code, "SV385", "lat:67.067433351083,lng:-74.1796875,level:3: SV385");
  str_is(geohex_get_zone_by_location(geohex_location(77.0787838962494L, 23.90625L), 3).code, "aX355", "lat:77.0787838962494,lng:23.90625,level:3: aX355");
  str_is(geohex_get_zone_by_location(geohex_location(78.5632592313568L, 18.122655126953L), 3).code, "aX568", "lat:78.5632592313568,lng:18.122655126953,level:3: aX568");
  str_is(geohex_get_zone_by_location(geohex_location(83.599030708362L, -33.046875L), 3).code, "bD744", "lat:83.599030708362,lng:-33.046875,level:3: bD744");
  str_is(geohex_get_zone_by_location(geohex_location(83.5597167645715L, -49.921875L), 3).code, "bD515", "lat:83.5597167645715,lng:-49.921875,level:3: bD515");
  str_is(geohex_get_zone_by_location(geohex_location(85.0435409456565L, 89.2529296875L), 3).code, "bb337", "lat:85.0435409456565,lng:89.2529296875,level:3: bb337");
  str_is(geohex_get_zone_by_location(geohex_location(84.9785740239428L, 179.6484375L), 3).code, "TO808", "lat:84.9785740239428,lng:179.6484375,level:3: TO808");
  str_is(geohex_get_zone_by_location(geohex_location(84.5162211763226L, 175.2978515625L), 3).code, "TO428", "lat:84.5162211763226,lng:175.2978515625,level:3: TO428");
  str_is(geohex_get_zone_by_location(geohex_location(84.5552138939799L, -177.521876123047L), 3).code, "TO474", "lat:84.5552138939799,lng:-177.521876123047,level:3: TO474");
  str_is(geohex_get_zone_by_location(geohex_location(83.7010964160167L, -176.748046875L), 3).code, "TO073", "lat:83.7010964160167,lng:-176.748046875,level:3: TO073");
  str_is(geohex_get_zone_by_location(geohex_location(83.272558965094L, 173.5400390625L), 3).code, "aB648", "lat:83.272558965094,lng:173.5400390625,level:3: aB648");
  str_is(geohex_get_zone_by_location(geohex_location(70.6463998268061L, 97.707616064453L), 3).code, "YG168", "lat:70.6463998268061,lng:97.707616064453,level:3: YG168");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0587050266129L, -76.46484375L), 4).code, "BV7511", "lat:-85.0587050266129,lng:-76.46484375,level:4: BV7511");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0283304449441L, -75.9375L), 4).code, "BV7541", "lat:-85.0283304449441,lng:-75.9375,level:4: BV7541");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0435409456565L, 177.978515625L), 4).code, "DO0532", "lat:-85.0435409456565,lng:177.978515625,level:4: DO0532");
  str_is(geohex_get_zone_by_location(geohex_location(-84.8723924583849L, -177.477930810547L), 4).code, "DO3203", "lat:-84.8723924583849,lng:-177.477930810547,level:4: DO3203");
  str_is(geohex_get_zone_by_location(geohex_location(-77.595847144363L, -170.622462060547L), 4).code, "EU6235", "lat:-77.595847144363,lng:-170.622462060547,level:4: EU6235");
  str_is(geohex_get_zone_by_location(geohex_location(-78.3494106901463L, 171.5625L), 4).code, "EU1425", "lat:-78.3494106901463,lng:171.5625,level:4: EU1425");
  str_is(geohex_get_zone_by_location(geohex_location(-47.9899216674142L, 64.6875L), 4).code, "OK7172", "lat:-47.9899216674142,lng:64.6875,level:4: OK7172");
  str_is(geohex_get_zone_by_location(geohex_location(-78.9039293885709L, -16.875L), 4).code, "CZ0737", "lat:-78.9039293885709,lng:-16.875,level:4: CZ0737");
  str_is(geohex_get_zone_by_location(geohex_location(-55.3211950064193L, -104.528712060547L), 4).code, "Fb0200", "lat:-55.3211950064193,lng:-104.528712060547,level:4: Fb0200");
  str_is(geohex_get_zone_by_location(geohex_location(-45.089035564831L, -95.625L), 4).code, "Fb8608", "lat:-45.089035564831,lng:-95.625,level:4: Fb8608");
  str_is(geohex_get_zone_by_location(geohex_location(-23.2413461023861L, -160.3125L), 4).code, "GH4405", "lat:-23.2413461023861,lng:-160.3125,level:4: GH4405");
  str_is(geohex_get_zone_by_location(geohex_location(-11.1784018737118L, 170.15625L), 4).code, "GI2651", "lat:-11.1784018737118,lng:170.15625,level:4: GI2651");
  str_is(geohex_get_zone_by_location(geohex_location(-1.40610883543516L, -177.1875L), 4).code, "OC2121", "lat:-1.40610883543516,lng:-177.1875,level:4: OC2121");
  str_is(geohex_get_zone_by_location(geohex_location(17.9787330955562L, -172.96875L), 4).code, "QU7871", "lat:17.9787330955562,lng:-172.96875,level:4: QU7871");
  str_is(geohex_get_zone_by_location(geohex_location(11.1784018737118L, 174.375L), 4).code, "QU4212", "lat:11.1784018737118,lng:174.375,level:4: QU4212");
  str_is(geohex_get_zone_by_location(geohex_location(-50.7364551370106L, 63.28125L), 4).code, "OK4362", "lat:-50.7364551370106,lng:63.28125,level:4: OK4362");
  str_is(geohex_get_zone_by_location(geohex_location(-10.3876340301868L, 5.15878793945296L), 4).code, "OX2538", "lat:-10.3876340301868,lng:5.15878793945296,level:4: OX2538");
  str_is(geohex_get_zone_by_location(geohex_location(3.61508745924257L, -0.466212060547036L), 4).code, "OY5663", "lat:3.61508745924257,lng:-0.466212060547036,level:4: OY5663");
  str_is(geohex_get_zone_by_location(geohex_location(-0.00001L, -60.46875L), 4).code, "OG6663", "lat:-0.00001,lng:-60.46875,level:4: OG6663");
  str_is(geohex_get_zone_by_location(geohex_location(35.4606699514953L, 45L), 4).code, "PZ0631", "lat:35.4606699514953,lng:45,level:4: PZ0631");
  str_is(geohex_get_zone_by_location(geohex_location(70.6126142380192L, -82.96875L), 4).code, "SV8518", "lat:70.6126142380192,lng:-82.96875,level:4: SV8518");
  str_is(geohex_get_zone_by_location(geohex_location(81.0932138526084L, -177.1875L), 4).code, "TK3246", "lat:81.0932138526084,lng:-177.1875,level:4: TK3246");
  str_is(geohex_get_zone_by_location(geohex_location(81.5182718765338L, 171.5625L), 4).code, "TK1825", "lat:81.5182718765338,lng:171.5625,level:4: TK1825");
  str_is(geohex_get_zone_by_location(geohex_location(83.3595113303545L, 174.375L), 4).code, "aB6727", "lat:83.3595113303545,lng:174.375,level:4: aB6727");
  str_is(geohex_get_zone_by_location(geohex_location(85.0587050266129L, -171.650390625L), 4).code, "TR1202", "lat:85.0587050266129,lng:-171.650390625,level:4: TR1202");
  str_is(geohex_get_zone_by_location(geohex_location(82.9403268016951L, -40.78125L), 4).code, "bD4054", "lat:82.9403268016951,lng:-40.78125,level:4: bD4054");
  str_is(geohex_get_zone_by_location(geohex_location(77.767582382728L, 20.390625L), 4).code, "aX4486", "lat:77.767582382728,lng:20.390625,level:4: aX4486");
  str_is(geohex_get_zone_by_location(geohex_location(76.0160936642099L, 117.421875L), 4).code, "ZA5685", "lat:76.0160936642099,lng:117.421875,level:4: ZA5685");
  str_is(geohex_get_zone_by_location(geohex_location(35.3890499669117L, 139.7021484375L), 4).code, "XM4881", "lat:35.3890499669117,lng:139.7021484375,level:4: XM4881");
  str_is(geohex_get_zone_by_location(geohex_location(40.2795256688129L, 135L), 4).code, "XU6302", "lat:40.2795256688129,lng:135,level:4: XU6302");
  str_is(geohex_get_zone_by_location(geohex_location(43.6122167681757L, 143.1298828125L), 4).code, "XX0337", "lat:43.6122167681757,lng:143.1298828125,level:4: XX0337");
  str_is(geohex_get_zone_by_location(geohex_location(32.8057447329069L, 151.5673828125L), 4).code, "XM6425", "lat:32.8057447329069,lng:151.5673828125,level:4: XM6425");
  str_is(geohex_get_zone_by_location(geohex_location(22.7153900193359L, 129.5947265625L), 4).code, "PS6270", "lat:22.7153900193359,lng:129.5947265625,level:4: PS6270");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0813644184664L, -79.453125L), 5).code, "BV80302", "lat:-85.0813644184664,lng:-79.453125,level:5: BV80302");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -78.92578125L), 5).code, "BV80373", "lat:-85.0511287798066,lng:-78.92578125,level:5: BV80373");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9283209294996L, -179.47265625L), 5).code, "DO08354", "lat:-84.9283209294996,lng:-179.47265625,level:5: DO08354");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9593049562383L, 178.2421875L), 5).code, "DO05758", "lat:-84.9593049562383,lng:178.2421875,level:5: DO05758");
  str_is(geohex_get_zone_by_location(geohex_location(-78.7335005077847L, -176.1328125L), 5).code, "EU31135", "lat:-78.7335005077847,lng:-176.1328125,level:5: EU31135");
  str_is(geohex_get_zone_by_location(geohex_location(-77.4629957529448L, 177.600194189453L), 5).code, "EU45042", "lat:-77.4629957529448,lng:177.600194189453,level:5: EU45042");
  str_is(geohex_get_zone_by_location(geohex_location(-78.2065631107471L, -15.46875L), 5).code, "CZ35087", "lat:-78.2065631107471,lng:-15.46875,level:5: CZ35087");
  str_is(geohex_get_zone_by_location(geohex_location(-54.5720616556585L, 64.3359375L), 5).code, "OK06445", "lat:-54.5720616556585,lng:64.3359375,level:5: OK06445");
  str_is(geohex_get_zone_by_location(geohex_location(-46.3165841818222L, -100.1953125L), 5).code, "Fb80457", "lat:-46.3165841818222,lng:-100.1953125,level:5: Fb80457");
  str_is(geohex_get_zone_by_location(geohex_location(-17.6440220278727L, -160.6640625L), 5).code, "GH80422", "lat:-17.6440220278727,lng:-160.6640625,level:5: GH80422");
  str_is(geohex_get_zone_by_location(geohex_location(-7.17423764065876L, -172.731837060547L), 5).code, "GI74753", "lat:-7.17423764065876,lng:-172.731837060547,level:5: GI74753");
  str_is(geohex_get_zone_by_location(geohex_location(-6.47609984882554L, 178.479100439453L), 5).code, "GI80240", "lat:-6.47609984882554,lng:178.479100439453,level:5: GI80240");
  str_is(geohex_get_zone_by_location(geohex_location(2.64974654877715L, 176.721287939453L), 5).code, "QU01265", "lat:2.64974654877715,lng:176.721287939453,level:5: QU01265");
  str_is(geohex_get_zone_by_location(geohex_location(18.4928608912187L, -174.841212060547L), 5).code, "QU86344", "lat:18.4928608912187,lng:-174.841212060547,level:5: QU86344");
  str_is(geohex_get_zone_by_location(geohex_location(4.56547355071029L, 9.84375L), 5).code, "OY77334", "lat:4.56547355071029,lng:9.84375,level:5: OY77334");
  str_is(geohex_get_zone_by_location(geohex_location(-2.46018118102099L, -9.140625L), 5).code, "OY15454", "lat:-2.46018118102099,lng:-9.140625,level:5: OY15454");
  str_is(geohex_get_zone_by_location(geohex_location(3.51342104564004L, -60.46875L), 5).code, "PA04170", "lat:3.51342104564004,lng:-60.46875,level:5: PA04170");
  str_is(geohex_get_zone_by_location(geohex_location(21.9430455334382L, 127.96875L), 5).code, "PS62113", "lat:21.9430455334382,lng:127.96875,level:5: PS62113");
  str_is(geohex_get_zone_by_location(geohex_location(24.4598690265572L, 133.918553564453L), 5).code, "PS68342", "lat:24.4598690265572,lng:133.918553564453,level:5: PS68342");
  str_is(geohex_get_zone_by_location(geohex_location(37.6490340215787L, 145.810546875L), 5).code, "XM78145", "lat:37.6490340215787,lng:145.810546875,level:5: XM78145");
  str_is(geohex_get_zone_by_location(geohex_location(35.0299963690257L, 138.33984375L), 5).code, "XM48257", "lat:35.0299963690257,lng:138.33984375,level:5: XM48257");
  str_is(geohex_get_zone_by_location(geohex_location(43.5166885350291L, 141.416015625L), 5).code, "XX03156", "lat:43.5166885350291,lng:141.416015625,level:5: XX03156");
  str_is(geohex_get_zone_by_location(geohex_location(43.0688877741696L, 43.59375L), 5).code, "PZ47685", "lat:43.0688877741696,lng:43.59375,level:5: PZ47685");
  str_is(geohex_get_zone_by_location(geohex_location(66.5132604431118L, -78.75L), 5).code, "SV40654", "lat:66.5132604431118,lng:-78.75,level:5: SV40654");
  str_is(geohex_get_zone_by_location(geohex_location(25.7333228756498L, -115.251368310547L), 5).code, "OI71873", "lat:25.7333228756498,lng:-115.251368310547,level:5: OI71873");
  str_is(geohex_get_zone_by_location(geohex_location(76.9999351181161L, 18.984375L), 5).code, "aX40264", "lat:76.9999351181161,lng:18.984375,level:5: aX40264");
  str_is(geohex_get_zone_by_location(geohex_location(74.9593916589497L, 118.828125L), 5).code, "ZA44552", "lat:74.9593916589497,lng:118.828125,level:5: ZA44552");
  str_is(geohex_get_zone_by_location(geohex_location(83.277705039617L, -38.671875L), 5).code, "bD47117", "lat:83.277705039617,lng:-38.671875,level:5: bD47117");
  str_is(geohex_get_zone_by_location(geohex_location(82.0213780195089L, 172.265625L), 5).code, "TK51615", "lat:82.0213780195089,lng:172.265625,level:5: TK51615");
  str_is(geohex_get_zone_by_location(geohex_location(82.0213780195089L, -174.375L), 5).code, "TK71615", "lat:82.0213780195089,lng:-174.375,level:5: TK71615");
  str_is(geohex_get_zone_by_location(geohex_location(84.3296816703432L, -173.610743310547L), 5).code, "TO38458", "lat:84.3296816703432,lng:-173.610743310547,level:5: TO38458");
  str_is(geohex_get_zone_by_location(geohex_location(85.0435409456565L, 173.3203125L), 5).code, "TO58484", "lat:85.0435409456565,lng:173.3203125,level:5: TO58484");
  str_is(geohex_get_zone_by_location(geohex_location(-85.035941506574L, -88.41796875L), 6).code, "BV553581", "lat:-85.035941506574,lng:-88.41796875,level:6: BV553581");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, 118.4765625L), 6).code, "CI802417", "lat:-85.0207077431259,lng:118.4765625,level:6: CI802417");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1114157806266L, 124.1015625L), 6).code, "CI750110", "lat:-85.1114157806266,lng:124.1015625,level:6: CI750110");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1412839811764L, 177.890625L), 6).code, "DO018862", "lat:-85.1412839811764,lng:177.890625,level:6: DO018862");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 178.2421875L), 6).code, "DO053505", "lat:-85.0511287798066,lng:178.2421875,level:6: DO053505");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0194948138159L, -177.126368310547L), 6).code, "DO074664", "lat:-85.0194948138159,lng:-177.126368310547,level:6: DO074664");
  str_is(geohex_get_zone_by_location(geohex_location(-78.1344931829381L, -16.5234375L), 6).code, "CZ351822", "lat:-78.1344931829381,lng:-16.5234375,level:6: CZ351822");
  str_is(geohex_get_zone_by_location(geohex_location(-77.8418477505252L, 176.1328125L), 6).code, "EU412420", "lat:-77.8418477505252,lng:176.1328125,level:6: EU412420");
  str_is(geohex_get_zone_by_location(geohex_location(-77.154056306248L, -173.610743310547L), 6).code, "EU708101", "lat:-77.154056306248,lng:-173.610743310547,level:6: EU708101");
  str_is(geohex_get_zone_by_location(geohex_location(-44.5904671813088L, 60.8203125L), 6).code, "OK847038", "lat:-44.5904671813088,lng:60.8203125,level:6: OK847038");
  str_is(geohex_get_zone_by_location(geohex_location(-21.6165793367406L, -166.9921875L), 6).code, "GH501658", "lat:-21.6165793367406,lng:-166.9921875,level:6: GH501658");
  str_is(geohex_get_zone_by_location(geohex_location(-3.85031343257015L, 179.006444189453L), 6).code, "GI842644", "lat:-3.85031343257015,lng:179.006444189453,level:6: GI842644");
  str_is(geohex_get_zone_by_location(geohex_location(-4.91583280131316L, -176.484375L), 6).code, "GI836575", "lat:-4.91583280131316,lng:-176.484375,level:6: GI836575");
  str_is(geohex_get_zone_by_location(geohex_location(6.67848578032986L, -174.313868310547L), 6).code, "QU316588", "lat:6.67848578032986,lng:-174.313868310547,level:6: QU316588");
  str_is(geohex_get_zone_by_location(geohex_location(9.46284480235845L, 174.787694189453L), 6).code, "QU175485", "lat:9.46284480235845,lng:174.787694189453,level:6: QU175485");
  str_is(geohex_get_zone_by_location(geohex_location(-48.4583518828086L, -96.6796875L), 6).code, "Fb711277", "lat:-48.4583518828086,lng:-96.6796875,level:6: Fb711277");
  str_is(geohex_get_zone_by_location(geohex_location(4.56547355071029L, 2.4609375L), 6).code, "OY728344", "lat:4.56547355071029,lng:2.4609375,level:6: OY728344");
  str_is(geohex_get_zone_by_location(geohex_location(2.46018118102101L, -60.46875L), 6).code, "PA016372", "lat:2.46018118102101,lng:-60.46875,level:6: PA016372");
  str_is(geohex_get_zone_by_location(geohex_location(10.141931686131L, -180L), 6).code, "QU408880", "lat:10.141931686131,lng:-180,level:6: QU408880");
  str_is(geohex_get_zone_by_location(geohex_location(32.5468131735151L, 138.8671875L), 6).code, "XM442337", "lat:32.5468131735151,lng:138.8671875,level:6: XM442337");
  str_is(geohex_get_zone_by_location(geohex_location(21.9430455334382L, 127.6171875L), 6).code, "PS387785", "lat:21.9430455334382,lng:127.6171875,level:6: PS387785");
  str_is(geohex_get_zone_by_location(geohex_location(43.8345267822368L, 143.0859375L), 6).code, "XX037037", "lat:43.8345267822368,lng:143.0859375,level:6: XX037037");
  str_is(geohex_get_zone_by_location(geohex_location(39.6395375643667L, 36.9140625L), 6).code, "PZ173676", "lat:39.6395375643667,lng:36.9140625,level:6: PZ173676");
  str_is(geohex_get_zone_by_location(geohex_location(65.8027763934024L, -78.3984375L), 6).code, "SV321726", "lat:65.8027763934024,lng:-78.3984375,level:6: SV321726");
  str_is(geohex_get_zone_by_location(geohex_location(39.7855076845378L, -104.660547998047L), 6).code, "PC828583", "lat:39.7855076845378,lng:-104.660547998047,level:6: PC828583");
  str_is(geohex_get_zone_by_location(geohex_location(24.3798410664542L, -114.504297998047L), 6).code, "OI713375", "lat:24.3798410664542,lng:-114.504297998047,level:6: OI713375");
  str_is(geohex_get_zone_by_location(geohex_location(82.4024234793885L, -40.078125L), 6).code, "bD080050", "lat:82.4024234793885,lng:-40.078125,level:6: bD080050");
  str_is(geohex_get_zone_by_location(geohex_location(78.9039293885709L, 18.28125L), 6).code, "aX817100", "lat:78.9039293885709,lng:18.28125,level:6: aX817100");
  str_is(geohex_get_zone_by_location(geohex_location(75.4971573189308L, 123.046875L), 6).code, "ZA712478", "lat:75.4971573189308,lng:123.046875,level:6: ZA712478");
  str_is(geohex_get_zone_by_location(geohex_location(81.0681264963294L, 179.401952001953L), 6).code, "TK166315", "lat:81.0681264963294,lng:179.401952001953,level:6: TK166315");
  str_is(geohex_get_zone_by_location(geohex_location(82.8332236662427L, -177.082422998047L), 6).code, "TK873482", "lat:82.8332236662427,lng:-177.082422998047,level:6: TK873482");
  str_is(geohex_get_zone_by_location(geohex_location(84.2509866562372L, -177.082422998047L), 6).code, "TO433402", "lat:84.2509866562372,lng:-177.082422998047,level:6: TO433402");
  str_is(geohex_get_zone_by_location(geohex_location(85.0066436947991L, 175.007420751953L), 6).code, "TO586342", "lat:85.0066436947991,lng:175.007420751953,level:6: TO586342");
  str_is(geohex_get_zone_by_location(geohex_location(85.0397426778322L, 88.41796875L), 6).code, "bb335332", "lat:85.0397426778322,lng:88.41796875,level:6: bb335332");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0473363122482L, -79.6728515625L), 7).code, "BV8032788", "lat:-85.0473363122482,lng:-79.6728515625,level:7: BV8032788");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 128.0126953125L), 7).code, "CI7714524", "lat:-85.0511287798066,lng:128.0126953125,level:7: CI7714524");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, 177.220458984375L), 7).code, "DO0514686", "lat:-85.0520764439798,lng:177.220458984375,level:7: DO0514686");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 177.36328125L), 7).code, "DO0517300", "lat:-85.0511287798066,lng:177.36328125,level:7: DO0517300");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, -177.352294921875L), 7).code, "DO0732687", "lat:-85.0520764439798,lng:-177.352294921875,level:7: DO0732687");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0501809345811L, -177.396240234375L), 7).code, "DO0732768", "lat:-85.0501809345811,lng:-177.396240234375,level:7: DO0732768");
  str_is(geohex_get_zone_by_location(geohex_location(-78.2065631107471L, -179.47265625L), 7).code, "EU4031833", "lat:-78.2065631107471,lng:-179.47265625,level:7: EU4031833");
  str_is(geohex_get_zone_by_location(geohex_location(-76.3252431164896L, -179.818018701172L), 7).code, "EU8072131", "lat:-76.3252431164896,lng:-179.818018701172,level:7: EU8072131");
  str_is(geohex_get_zone_by_location(geohex_location(-75.6442438813013L, 174.556981298828L), 7).code, "EU8255485", "lat:-75.6442438813013,lng:174.556981298828,level:7: EU8255485");
  str_is(geohex_get_zone_by_location(geohex_location(-78.0619891866597L, -13.359375L), 7).code, "CZ3800810", "lat:-78.0619891866597,lng:-13.359375,level:7: CZ3800810");
  str_is(geohex_get_zone_by_location(geohex_location(-52.2681573737682L, 56.42578125L), 7).code, "OK1624776", "lat:-52.2681573737682,lng:56.42578125,level:7: OK1624776");
  str_is(geohex_get_zone_by_location(geohex_location(-47.3219061200486L, 68.0335437988283L), 7).code, "OK7464515", "lat:-47.3219061200486,lng:68.0335437988283,level:7: OK7464515");
  str_is(geohex_get_zone_by_location(geohex_location(-48.4583518828086L, -104.58984375L), 7).code, "Fb5316746", "lat:-48.4583518828086,lng:-104.58984375,level:7: Fb5316746");
  str_is(geohex_get_zone_by_location(geohex_location(-51.8357775204525L, -99.140625L), 7).code, "Fb4033527", "lat:-51.8357775204525,lng:-99.140625,level:7: Fb4033527");
  str_is(geohex_get_zone_by_location(geohex_location(-21.4530686330868L, -162.24609375L), 7).code, "GH4540858", "lat:-21.4530686330868,lng:-162.24609375,level:7: GH4540858");
  str_is(geohex_get_zone_by_location(geohex_location(-12.3829283384874L, -178.76953125L), 7).code, "GI4351804", "lat:-12.3829283384874,lng:-178.76953125,level:7: GI4351804");
  str_is(geohex_get_zone_by_location(geohex_location(-4.10239049848663L, -177.532862451172L), 7).code, "GI8387484", "lat:-4.10239049848663,lng:-177.532862451172,level:7: GI8387484");
  str_is(geohex_get_zone_by_location(geohex_location(4.32747949211224L, -177.181299951172L), 7).code, "QU0706771", "lat:4.32747949211224,lng:-177.181299951172,level:7: QU0706771");
  str_is(geohex_get_zone_by_location(geohex_location(14.7140233449093L, -179.993799951172L), 7).code, "QU4884047", "lat:14.7140233449093,lng:-179.993799951172,level:7: QU4884047");
  str_is(geohex_get_zone_by_location(geohex_location(19.1687452003202L, 174.425145361328L), 7).code, "QU8251271", "lat:19.1687452003202,lng:174.425145361328,level:7: QU8251271");
  str_is(geohex_get_zone_by_location(geohex_location(5.2660078828055L, -60.8203125L), 7).code, "PA0565644", "lat:5.2660078828055,lng:-60.8203125,level:7: PA0565644");
  str_is(geohex_get_zone_by_location(geohex_location(6.16537016364512L, 0.577489111328305L), 7).code, "OY8320288", "lat:6.16537016364512,lng:0.577489111328305,level:7: OY8320288");
  str_is(geohex_get_zone_by_location(geohex_location(-2.10889865924313L, 4.21875L), 7).code, "OY3556486", "lat:-2.10889865924313,lng:4.21875,level:7: OY3556486");
  str_is(geohex_get_zone_by_location(geohex_location(45.3367019099681L, 39.7265625L), 7).code, "PZ8016814", "lat:45.3367019099681,lng:39.7265625,level:7: PZ8016814");
  str_is(geohex_get_zone_by_location(geohex_location(39.9097362345372L, 36.2109375L), 7).code, "PZ1746604", "lat:39.9097362345372,lng:36.2109375,level:7: PZ1746604");
  str_is(geohex_get_zone_by_location(geohex_location(22.4313401563606L, 128.408203125L), 7).code, "PS6242083", "lat:22.4313401563606,lng:128.408203125,level:7: PS6242083");
  str_is(geohex_get_zone_by_location(geohex_location(35.8178131586966L, 137.900390625L), 7).code, "XM5643552", "lat:35.8178131586966,lng:137.900390625,level:7: XM5643552");
  str_is(geohex_get_zone_by_location(geohex_location(40.2124407182865L, 135.7470703125L), 7).code, "XU6303820", "lat:40.2124407182865,lng:135.7470703125,level:7: XU6303820");
  str_is(geohex_get_zone_by_location(geohex_location(38.2036553180715L, 145.6787109375L), 7).code, "XM7851800", "lat:38.2036553180715,lng:145.6787109375,level:7: XM7851800");
  str_is(geohex_get_zone_by_location(geohex_location(43.8662180065564L, 142.119140625L), 7).code, "XX0345653", "lat:43.8662180065564,lng:142.119140625,level:7: XX0345653");
  str_is(geohex_get_zone_by_location(geohex_location(30.8482114570361L, 156.143895361328L), 7).code, "XM6306347", "lat:30.8482114570361,lng:156.143895361328,level:7: XM6306347");
  str_is(geohex_get_zone_by_location(geohex_location(21.4530686330868L, 178.857421875L), 7).code, "QU8827707", "lat:21.4530686330868,lng:178.857421875,level:7: QU8827707");
  str_is(geohex_get_zone_by_location(geohex_location(42.0329743324414L, 35.15625L), 7).code, "PZ4253332", "lat:42.0329743324414,lng:35.15625,level:7: PZ4253332");
  str_is(geohex_get_zone_by_location(geohex_location(30.9236383940856L, -116.492823388672L), 7).code, "OI8776718", "lat:30.9236383940856,lng:-116.492823388672,level:7: OI8776718");
  str_is(geohex_get_zone_by_location(geohex_location(41.1312708370144L, -95.3990733886717L), 7).code, "PF2148656", "lat:41.1312708370144,lng:-95.3990733886717,level:7: PF2148656");
  str_is(geohex_get_zone_by_location(geohex_location(75.4088542284645L, 118.125L), 7).code, "ZA4587731", "lat:75.4088542284645,lng:118.125,level:7: ZA4587731");
  str_is(geohex_get_zone_by_location(geohex_location(66.791909473418L, -77.34375L), 7).code, "SV4335020", "lat:66.791909473418,lng:-77.34375,level:7: SV4335020");
  str_is(geohex_get_zone_by_location(geohex_location(69.726756757278L, -86.6100108886717L), 7).code, "SV5843218", "lat:69.726756757278,lng:-86.6100108886717,level:7: SV5843218");
  str_is(geohex_get_zone_by_location(geohex_location(76.0160936642099L, 23.90625L), 7).code, "aX0682573", "lat:76.0160936642099,lng:23.90625,level:7: aX0682573");
  str_is(geohex_get_zone_by_location(geohex_location(78.6695124342049L, 17.8040516113283L), 7).code, "aX8100870", "lat:78.6695124342049,lng:17.8040516113283,level:7: aX8100870");
  str_is(geohex_get_zone_by_location(geohex_location(83.1948956366159L, -41.484375L), 7).code, "bD4424804", "lat:83.1948956366159,lng:-41.484375,level:7: bD4424804");
  str_is(geohex_get_zone_by_location(geohex_location(84.181236162653L, -48.9928233886717L), 7).code, "bE6100113", "lat:84.181236162653,lng:-48.9928233886717,level:7: bE6100113");
  str_is(geohex_get_zone_by_location(geohex_location(81.8736412548283L, 171.9140625L), 7).code, "TK5027217", "lat:81.8736412548283,lng:171.9140625,level:7: TK5027217");
  str_is(geohex_get_zone_by_location(geohex_location(81.8736412548283L, -172.6171875L), 7).code, "TK7070414", "lat:81.8736412548283,lng:-172.6171875,level:7: TK7070414");
  str_is(geohex_get_zone_by_location(geohex_location(84.4059410412698L, -171.2109375L), 7).code, "TO6240542", "lat:84.4059410412698,lng:-171.2109375,level:7: TO6240542");
  str_is(geohex_get_zone_by_location(geohex_location(84.9593049562383L, -170.5078125L), 7).code, "TO7775738", "lat:84.9593049562383,lng:-170.5078125,level:7: TO7775738");
  str_is(geohex_get_zone_by_location(geohex_location(85.0075998559899L, 171.788426611328L), 7).code, "TO5821675", "lat:85.0075998559899,lng:171.788426611328,level:7: TO5821675");
  str_is(geohex_get_zone_by_location(geohex_location(85.0508918354752L, 89.4149780273438L), 7).code, "bb3371862", "lat:85.0508918354752,lng:89.4149780273438,level:7: bb3371862");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -86.484375L), 8).code, "BV54870250", "lat:-85.0511287798066,lng:-86.484375,level:8: BV54870250");
  str_is(geohex_get_zone_by_location(geohex_location(-84.8943460271761L, -74.9662196899412L), 8).code, "BV78253862", "lat:-84.8943460271761,lng:-74.9662196899412,level:8: BV78253862");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9593049562383L, 116.015625L), 8).code, "CI57758513", "lat:-84.9593049562383,lng:116.015625,level:8: CI57758513");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 125.859375L), 8).code, "CI75600226", "lat:-85.0511287798066,lng:125.859375,level:8: CI75600226");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0473363122482L, 179.384765625L), 8).code, "DO05603615", "lat:-85.0473363122482,lng:179.384765625,level:8: DO05603615");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0446176171078L, -178.940829064941L), 8).code, "DO07152160", "lat:-85.0446176171078,lng:-178.940829064941,level:8: DO07152160");
  str_is(geohex_get_zone_by_location(geohex_location(-78.0255736328409L, 178.41796875L), 8).code, "EU41063674", "lat:-78.0255736328409,lng:178.41796875,level:8: EU41063674");
  str_is(geohex_get_zone_by_location(geohex_location(-76.7835046518998L, -179.380282189941L), 8).code, "EU72201265", "lat:-76.7835046518998,lng:-179.380282189941,level:8: EU72201265");
  str_is(geohex_get_zone_by_location(geohex_location(-78.2782014554281L, -12.3046875L), 8).code, "CZ34762511", "lat:-78.2782014554281,lng:-12.3046875,level:8: CZ34762511");
  str_is(geohex_get_zone_by_location(geohex_location(-50.7364551370106L, -94.921875L), 8).code, "Fb38241503", "lat:-50.7364551370106,lng:-94.921875,level:8: Fb38241503");
  str_is(geohex_get_zone_by_location(geohex_location(-48.0570407777163L, 58.9790928100588L), 8).code, "OK48511367", "lat:-48.0570407777163,lng:58.9790928100588,level:8: OK48511367");
  str_is(geohex_get_zone_by_location(geohex_location(-16.0577905631594L, -177.974032189941L), 8).code, "GI32042116", "lat:-16.0577905631594,lng:-177.974032189941,level:8: GI32042116");
  str_is(geohex_get_zone_by_location(geohex_location(-8.50643064977766L, -175.864657189941L), 8).code, "GI71565064", "lat:-8.50643064977766,lng:-175.864657189941,level:8: GI71565064");
  str_is(geohex_get_zone_by_location(geohex_location(-21.2893743558604L, -162.421875L), 8).code, "GH45442518", "lat:-21.2893743558604,lng:-162.421875,level:8: GH45442518");
  str_is(geohex_get_zone_by_location(geohex_location(-5.01580975357458L, 6.94784281005877L), 8).code, "OY33228746", "lat:-5.01580975357458,lng:6.94784281005877,level:8: OY33228746");
  str_is(geohex_get_zone_by_location(geohex_location(2.81137119333114L, -59.0625L), 8).code, "PA03278283", "lat:2.81137119333114,lng:-59.0625,level:8: PA03278283");
  str_is(geohex_get_zone_by_location(geohex_location(11.1784018737118L, 175.078125L), 8).code, "QU42174351", "lat:11.1784018737118,lng:175.078125,level:8: QU42174351");
  str_is(geohex_get_zone_by_location(geohex_location(12.2848909400907L, -179.204500939941L), 8).code, "QU47122108", "lat:12.2848909400907,lng:-179.204500939941,level:8: QU47122108");
  str_is(geohex_get_zone_by_location(geohex_location(29.2288900301942L, 140.9765625L), 8).code, "XM32230826", "lat:29.2288900301942,lng:140.9765625,level:8: XM32230826");
  str_is(geohex_get_zone_by_location(geohex_location(35.2354400884114L, 138.432217810059L), 8).code, "XM56301016", "lat:35.2354400884114,lng:138.432217810059,level:8: XM56301016");
  str_is(geohex_get_zone_by_location(geohex_location(21.4530686330868L, 129.7265625L), 8).code, "PS61272751", "lat:21.4530686330868,lng:129.7265625,level:8: PS61272751");
  str_is(geohex_get_zone_by_location(geohex_location(31.1175301983385L, 153.373624060059L), 8).code, "XM60832123", "lat:31.1175301983385,lng:153.373624060059,level:8: XM60832123");
  str_is(geohex_get_zone_by_location(geohex_location(40.5805846641276L, 134.296875L), 8).code, "XU63124187", "lat:40.5805846641276,lng:134.296875,level:8: XU63124187");
  str_is(geohex_get_zone_by_location(geohex_location(43.5076500047502L, 141.772061560059L), 8).code, "XX03173236", "lat:43.5076500047502,lng:141.772061560059,level:8: XX03173236");
  str_is(geohex_get_zone_by_location(geohex_location(41.3768085657023L, 47.109375L), 8).code, "PZ38755703", "lat:41.3768085657023,lng:47.109375,level:8: PZ38755703");
  str_is(geohex_get_zone_by_location(geohex_location(46.0035675375752L, 36.1275303100588L), 8).code, "PZ57757416", "lat:46.0035675375752,lng:36.1275303100588,level:8: PZ57757416");
  str_is(geohex_get_zone_by_location(geohex_location(-39.8518545936532L, -129.634188439941L), 8).code, "Fc51504013", "lat:-39.8518545936532,lng:-129.634188439941,level:8: Fc51504013");
  str_is(geohex_get_zone_by_location(geohex_location(0.703107352436491L, -58.359375L), 8).code, "OW22586402", "lat:0.703107352436491,lng:-58.359375,level:8: OW22586402");
  str_is(geohex_get_zone_by_location(geohex_location(36.0923061169101L, -111.352938439941L), 8).code, "PC52458806", "lat:36.0923061169101,lng:-111.352938439941,level:8: PC52458806");
  str_is(geohex_get_zone_by_location(geohex_location(66.8216153828775L, -93.7748134399412L), 8).code, "SV20852101", "lat:66.8216153828775,lng:-93.7748134399412,level:8: SV20852101");
  str_is(geohex_get_zone_by_location(geohex_location(77.6177090527968L, 24.609375L), 8).code, "aX46486040", "lat:77.6177090527968,lng:24.609375,level:8: aX46486040");
  str_is(geohex_get_zone_by_location(geohex_location(74.9593916589497L, 129.375L), 8).code, "ZA62754057", "lat:74.9593916589497,lng:129.375,level:8: ZA62754057");
  str_is(geohex_get_zone_by_location(geohex_location(83.4403264952731L, -52.03125L), 8).code, "bD28367162", "lat:83.4403264952731,lng:-52.03125,level:8: bD28367162");
  str_is(geohex_get_zone_by_location(geohex_location(80.7606147075245L, 177.890625L), 8).code, "TK05722747", "lat:80.7606147075245,lng:177.890625,level:8: TK05722747");
  str_is(geohex_get_zone_by_location(geohex_location(82.5046692199114L, -178.852938439941L), 8).code, "TK83151057", "lat:82.5046692199114,lng:-178.852938439941,level:8: TK83151057");
  str_is(geohex_get_zone_by_location(geohex_location(83.8380470615988L, -176.040438439941L), 8).code, "TO31130720", "lat:83.8380470615988,lng:-176.040438439941,level:8: TO31130720");
  str_is(geohex_get_zone_by_location(geohex_location(84.6149239022333L, 172.006436560059L), 8).code, "TO51331450", "lat:84.6149239022333,lng:172.006436560059,level:8: TO51331450");
  str_is(geohex_get_zone_by_location(geohex_location(85.0492329082692L, 88.857421875L), 8).code, "bb33488116", "lat:85.0492329082692,lng:88.857421875,level:8: bb33488116");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, -80.5078125L), 9).code, "BV804240512", "lat:-85.0207077431259,lng:-80.5078125,level:9: BV804240512");
  str_is(geohex_get_zone_by_location(geohex_location(-85.2589472349756L, 126.5625L), 9).code, "CI708565326", "lat:-85.2589472349756,lng:126.5625,level:9: CI708565326");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9901001802348L, 124.453125L), 9).code, "CI754848748", "lat:-84.9901001802348,lng:124.453125,level:9: CI754848748");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9631646609104L, 176.7919921875L), 9).code, "DO055580431", "lat:-84.9631646609104,lng:176.7919921875,level:9: DO055580431");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0506548798275L, 178.511352539062L), 9).code, "DO053480025", "lat:-85.0506548798275,lng:178.511352539062,level:9: DO053480025");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0506548798275L, -177.2314453125L), 9).code, "DO073506567", "lat:-85.0506548798275,lng:-177.2314453125,level:9: DO073506567");
  str_is(geohex_get_zone_by_location(geohex_location(-78.3494106901463L, -12.65625L), 9).code, "CZ347013544", "lat:-78.3494106901463,lng:-12.65625,level:9: CZ347013544");
  str_is(geohex_get_zone_by_location(geohex_location(-77.9156689863258L, 178.59375L), 9).code, "EU413474586", "lat:-77.9156689863258,lng:178.59375,level:9: EU413474586");
  str_is(geohex_get_zone_by_location(geohex_location(-78.0619891866597L, -175.78125L), 9).code, "EU354580674", "lat:-78.0619891866597,lng:-175.78125,level:9: EU354580674");
  str_is(geohex_get_zone_by_location(geohex_location(-48.9224992637582L, 61.875L), 9).code, "OK474555348", "lat:-48.9224992637582,lng:61.875,level:9: OK474555348");
  str_is(geohex_get_zone_by_location(geohex_location(-47.9899216674142L, -99.84375L), 9).code, "Fb484868583", "lat:-47.9899216674142,lng:-99.84375,level:9: Fb484868583");
  str_is(geohex_get_zone_by_location(geohex_location(-25.7998911820883L, -165.9375L), 9).code, "GH147081657", "lat:-25.7998911820883,lng:-165.9375,level:9: GH147081657");
  str_is(geohex_get_zone_by_location(geohex_location(-9.79713273881522L, -170.646151330566L), 9).code, "GI730641802", "lat:-9.79713273881522,lng:-170.646151330566,level:9: GI730641802");
  str_is(geohex_get_zone_by_location(geohex_location(-6.31676626334665L, 176.697598669434L), 9).code, "GI576514101", "lat:-6.31676626334665,lng:176.697598669434,level:9: GI576514101");
  str_is(geohex_get_zone_by_location(geohex_location(-8.40716816360107L, -0.703125L), 9).code, "OY041035522", "lat:-8.40716816360107,lng:-0.703125,level:9: OY041035522");
  str_is(geohex_get_zone_by_location(geohex_location(2.80989628150481L, -4.00552633056623L), 9).code, "OY537117080", "lat:2.80989628150481,lng:-4.00552633056623,level:9: OY537117080");
  str_is(geohex_get_zone_by_location(geohex_location(9.10063864198236L, -61.6617763305662L), 9).code, "PA402570238", "lat:9.10063864198236,lng:-61.6617763305662,level:9: PA402570238");
  str_is(geohex_get_zone_by_location(geohex_location(6.31529853833003L, 177.890625L), 9).code, "QU058877078", "lat:6.31529853833003,lng:177.890625,level:9: QU058877078");
  str_is(geohex_get_zone_by_location(geohex_location(17.9773285067521L, -179.435213830566L), 9).code, "QU832828267", "lat:17.9773285067521,lng:-179.435213830566,level:9: QU832828267");
  str_is(geohex_get_zone_by_location(geohex_location(40.9798980696201L, 45.3515625L), 9).code, "PZ382714446", "lat:40.9798980696201,lng:45.3515625,level:9: PZ382714446");
  str_is(geohex_get_zone_by_location(geohex_location(36.5978891330702L, 36.2109375L), 9).code, "PZ028668414", "lat:36.5978891330702,lng:36.2109375,level:9: PZ028668414");
  str_is(geohex_get_zone_by_location(geohex_location(20.960060644697L, 127.830411169434L), 9).code, "PS383657231", "lat:20.960060644697,lng:127.830411169434,level:9: PS383657231");
  str_is(geohex_get_zone_by_location(geohex_location(30.447400642478L, 151.736661169434L), 9).code, "XM602176827", "lat:30.447400642478,lng:151.736661169434,level:9: XM602176827");
  str_is(geohex_get_zone_by_location(geohex_location(34.8847196158007L, 138.377286169434L), 9).code, "XM482452815", "lat:34.8847196158007,lng:138.377286169434,level:9: XM482452815");
  str_is(geohex_get_zone_by_location(geohex_location(43.3241034221846L, 142.596036169434L), 9).code, "XX033123366", "lat:43.3241034221846,lng:142.596036169434,level:9: XX033123366");
  str_is(geohex_get_zone_by_location(geohex_location(28.6121630749919L, -115.099276330566L), 9).code, "OI860616105", "lat:28.6121630749919,lng:-115.099276330566,level:9: OI860616105");
  str_is(geohex_get_zone_by_location(geohex_location(46.3155642634689L, -108.771151330566L), 9).code, "RX114077466", "lat:46.3155642634689,lng:-108.771151330566,level:9: RX114077466");
  str_is(geohex_get_zone_by_location(geohex_location(66.5132604431118L, -76.2890625L), 9).code, "SV355072242", "lat:66.5132604431118,lng:-76.2890625,level:9: SV355072242");
  str_is(geohex_get_zone_by_location(geohex_location(70.844188082313L, 98.2991611694338L), 9).code, "YG413103084", "lat:70.844188082313,lng:98.2991611694338,level:9: YG413103084");
  str_is(geohex_get_zone_by_location(geohex_location(75.4967875101885L, 121.502286169434L), 9).code, "ZA486483578", "lat:75.4967875101885,lng:121.502286169434,level:9: ZA486483578");
  str_is(geohex_get_zone_by_location(geohex_location(77.5420959607555L, 16.875L), 9).code, "aX426174078", "lat:77.5420959607555,lng:16.875,level:9: aX426174078");
  str_is(geohex_get_zone_by_location(geohex_location(78.4902570149857L, 27.2835361694338L), 9).code, "aX747576237", "lat:78.4902570149857,lng:27.2835361694338,level:9: aX747576237");
  str_is(geohex_get_zone_by_location(geohex_location(81.5182718765338L, 173.3203125L), 9).code, "TK184816376", "lat:81.5182718765338,lng:173.3203125,level:9: TK184816376");
  str_is(geohex_get_zone_by_location(geohex_location(83.8297867078656L, -175.919588830566L), 9).code, "TO310523631", "lat:83.8297867078656,lng:-175.919588830566,level:9: TO310523631");
  str_is(geohex_get_zone_by_location(geohex_location(84.4057970922956L, 176.346036169434L), 9).code, "TO423806423", "lat:84.4057970922956,lng:176.346036169434,level:9: TO423806423");
  str_is(geohex_get_zone_by_location(geohex_location(84.8970156075168L, 87.4007236694338L), 9).code, "bb303856635", "lat:84.8970156075168,lng:87.4007236694338,level:9: bb303856635");
  str_is(geohex_get_zone_by_location(geohex_location(85.0497069440631L, 176.890869140625L), 9).code, "TO815178640", "lat:85.0497069440631,lng:176.890869140625,level:9: TO815178640");
  str_is(geohex_get_zone_by_location(geohex_location(65.9464717761574L, -84.375L), 10).code, "SV1700305142", "lat:65.9464717761574,lng:-84.375,level:10: SV1700305142");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -87.022705078125L), 10).code, "BV5482764471", "lat:-85.0511287798066,lng:-87.022705078125,level:10: BV5482764471");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0501809345811L, -74.02587890625L), 10).code, "BV7560068257", "lat:-85.0501809345811,lng:-74.02587890625,level:10: BV7560068257");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1412839811764L, 110.7421875L), 10).code, "CI5263615540", "lat:-85.1412839811764,lng:110.7421875,level:10: CI5263615540");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1114157806266L, 123.3984375L), 10).code, "CI7265571616", "lat:-85.1114157806266,lng:123.3984375,level:10: CI7265571616");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0813644184664L, 124.1015625L), 10).code, "CI7505181555", "lat:-85.0813644184664,lng:124.1015625,level:10: CI7505181555");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 116.71875L), 10).code, "CI5736546251", "lat:-85.0511287798066,lng:116.71875,level:10: CI5736546251");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1114157806266L, 176.484375L), 10).code, "DO0273028158", "lat:-85.1114157806266,lng:176.484375,level:10: DO0273028158");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 178.9453125L), 10).code, "DO0536546500", "lat:-85.0511287798066,lng:178.9453125,level:10: DO0536546500");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -177.890625L), 10).code, "DO0716764500", "lat:-85.0511287798066,lng:-177.890625,level:10: DO0716764500");
  str_is(geohex_get_zone_by_location(geohex_location(-78.2065631107471L, 179.6484375L), 10).code, "EU4016113514", "lat:-78.2065631107471,lng:179.6484375,level:10: EU4016113514");
  str_is(geohex_get_zone_by_location(geohex_location(-76.9519883560986L, 178.878384802246L), 10).code, "EU4827777232", "lat:-76.9519883560986,lng:178.878384802246,level:10: EU4827777232");
  str_is(geohex_get_zone_by_location(geohex_location(-76.6712633375603L, -173.738802697754L), 10).code, "EU7445272188", "lat:-76.6712633375603,lng:-173.738802697754,level:10: EU7445272188");
  str_is(geohex_get_zone_by_location(geohex_location(-51.1793429792893L, 56.6015625L), 10).code, "OK1777354303", "lat:-51.1793429792893,lng:56.6015625,level:10: OK1777354303");
  str_is(geohex_get_zone_by_location(geohex_location(-78.420193275912L, -14.765625L), 10).code, "CZ3420476772", "lat:-78.420193275912,lng:-14.765625,level:10: CZ3420476772");
  str_is(geohex_get_zone_by_location(geohex_location(-50.9584267233599L, -97.03125L), 10).code, "Fb4334484641", "lat:-50.9584267233599,lng:-97.03125,level:10: Fb4334484641");
  str_is(geohex_get_zone_by_location(geohex_location(-15.9613290815966L, -166.9921875L), 10).code, "GH5856584625", "lat:-15.9613290815966,lng:-166.9921875,level:10: GH5856584625");
  str_is(geohex_get_zone_by_location(geohex_location(-14.5690635426975L, 176.241666052246L), 10).code, "GI1730824803", "lat:-14.5690635426975,lng:176.241666052246,level:10: GI1730824803");
  str_is(geohex_get_zone_by_location(geohex_location(-8.05922962720018L, -177.1875L), 10).code, "GI7234521114", "lat:-8.05922962720018,lng:-177.1875,level:10: GI7234521114");
  str_is(geohex_get_zone_by_location(geohex_location(10.4878118820567L, -174.375L), 10).code, "QU3851424320", "lat:10.4878118820567,lng:-174.375,level:10: QU3851424320");
  str_is(geohex_get_zone_by_location(geohex_location(17.9787330955562L, 176.484375L), 10).code, "QU8152020110", "lat:17.9787330955562,lng:176.484375,level:10: QU8152020110");
  str_is(geohex_get_zone_by_location(geohex_location(3.86425461572141L, -61.171875L), 10).code, "PA0426257051", "lat:3.86425461572141,lng:-61.171875,level:10: PA0426257051");
  str_is(geohex_get_zone_by_location(geohex_location(0L, -4.21875L), 10).code, "OY4244664644", "lat:0,lng:-4.21875,level:10: OY4244664644");
  str_is(geohex_get_zone_by_location(geohex_location(2.84830156370805L, 8.19479105224627L), 10).code, "OY7353226324", "lat:2.84830156370805,lng:8.19479105224627,level:10: OY7353226324");
  str_is(geohex_get_zone_by_location(geohex_location(-3.8642546157214L, 6.6796875L), 10).code, "OY3444432334", "lat:-3.8642546157214,lng:6.6796875,level:10: OY3444432334");
  str_is(geohex_get_zone_by_location(geohex_location(17.30868788677L, 178.9453125L), 10).code, "QU8136543688", "lat:17.30868788677,lng:178.9453125,level:10: QU8136543688");
  str_is(geohex_get_zone_by_location(geohex_location(20.7495962435651L, -179.583529260254L), 10).code, "QU8831183154", "lat:20.7495962435651,lng:-179.583529260254,level:10: QU8831183154");
  str_is(geohex_get_zone_by_location(geohex_location(21.7799053425296L, 129.375L), 10).code, "PS6206841033", "lat:21.7799053425296,lng:129.375,level:10: PS6206841033");
  str_is(geohex_get_zone_by_location(geohex_location(27.32654326053L, 139.107876989746L), 10).code, "XM0565771230", "lat:27.32654326053,lng:139.107876989746,level:10: XM0565771230");
  str_is(geohex_get_zone_by_location(geohex_location(34.6997633697495L, 141.568814489746L), 10).code, "XM4863207510", "lat:34.6997633697495,lng:141.568814489746,level:10: XM4863207510");
  str_is(geohex_get_zone_by_location(geohex_location(43.2881270664159L, 142.975064489746L), 10).code, "XX0330807788", "lat:43.2881270664159,lng:142.975064489746,level:10: XX0330807788");
  str_is(geohex_get_zone_by_location(geohex_location(30.8585272380353L, 152.643033239746L), 10).code, "XM6054354111", "lat:30.8585272380353,lng:152.643033239746,level:10: XM6054354111");
  str_is(geohex_get_zone_by_location(geohex_location(40.178873314347L, 31.2890625L), 10).code, "PZ1548687734", "lat:40.178873314347,lng:31.2890625,level:10: PZ1548687734");
  str_is(geohex_get_zone_by_location(geohex_location(45.9157385222754L, 43.4828769897463L), 10).code, "PZ7555070851", "lat:45.9157385222754,lng:43.4828769897463,level:10: PZ7555070851");
  str_is(geohex_get_zone_by_location(geohex_location(27.8390760947778L, -115.83984375L), 10).code, "OI7581576564", "lat:27.8390760947778,lng:-115.83984375,level:10: OI7581576564");
  str_is(geohex_get_zone_by_location(geohex_location(47.9899216674142L, -108.28125L), 10).code, "RX1535370770", "lat:47.9899216674142,lng:-108.28125,level:10: RX1535370770");
  str_is(geohex_get_zone_by_location(geohex_location(67.7427590666639L, -72.7734375L), 10).code, "SV7031782060", "lat:67.7427590666639,lng:-72.7734375,level:10: SV7031782060");
  str_is(geohex_get_zone_by_location(geohex_location(71.3007929163745L, -85.95703125L), 10).code, "SW6431665682", "lat:71.3007929163745,lng:-85.95703125,level:10: SW6431665682");
  str_is(geohex_get_zone_by_location(geohex_location(76.6392256096589L, 17.40234375L), 10).code, "aX1617612856", "lat:76.6392256096589,lng:17.40234375,level:10: aX1617612856");
  str_is(geohex_get_zone_by_location(geohex_location(78.4803881585882L, 21.1586582397463L), 10).code, "aX7255422107", "lat:78.4803881585882,lng:21.1586582397463,level:10: aX7255422107");
  str_is(geohex_get_zone_by_location(geohex_location(75.4088542284645L, 127.6171875L), 10).code, "ZA7323011017", "lat:75.4088542284645,lng:127.6171875,level:10: ZA7323011017");
  str_is(geohex_get_zone_by_location(geohex_location(80.1399691499017L, 178.482876989746L), 10).code, "TK0130411728", "lat:80.1399691499017,lng:178.482876989746,level:10: TK0130411728");
  str_is(geohex_get_zone_by_location(geohex_location(82.4189147631075L, -179.407748010254L), 10).code, "TK8071386820", "lat:82.4189147631075,lng:-179.407748010254,level:10: TK8071386820");
  str_is(geohex_get_zone_by_location(geohex_location(84.3837991765363L, -179.407748010254L), 10).code, "TO4434206021", "lat:84.3837991765363,lng:-179.407748010254,level:10: TO4434206021");
  str_is(geohex_get_zone_by_location(geohex_location(85.0511287798066L, 89.0647888183594L), 10).code, "bb3372146218", "lat:85.0511287798066,lng:89.0647888183594,level:10: bb3372146218");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, -85.4296875L), 11).code, "BV57264048634", "lat:-85.0207077431259,lng:-85.4296875,level:11: BV57264048634");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, 114.2578125L), 11).code, "CI57246068382", "lat:-85.0207077431259,lng:114.2578125,level:11: CI57246068382");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, 177.890625L), 11).code, "DO05443747884", "lat:-85.0207077431259,lng:177.890625,level:11: DO05443747884");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0813644184664L, -178.9453125L), 11).code, "DO04773823048", "lat:-85.0813644184664,lng:-178.9453125,level:11: DO04773823048");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0813644184664L, -178.9453125L), 11).code, "DO04773823048", "lat:-85.0813644184664,lng:-178.9453125,level:11: DO04773823048");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -179.296875L), 11).code, "DO07200264504", "lat:-85.0511287798066,lng:-179.296875,level:11: DO07200264504");
  str_is(geohex_get_zone_by_location(geohex_location(-78.2065631107471L, -13.0078125L), 11).code, "CZ34837816828", "lat:-78.2065631107471,lng:-13.0078125,level:11: CZ34837816828");
  str_is(geohex_get_zone_by_location(geohex_location(-77.6928703364193L, 174.0234375L), 11).code, "EU18781747622", "lat:-77.6928703364193,lng:174.0234375,level:11: EU18781747622");
  str_is(geohex_get_zone_by_location(geohex_location(-77.2820430745299L, -177.189883020019L), 11).code, "EU47467037811", "lat:-77.2820430745299,lng:-177.189883020019,level:11: EU47467037811");
  str_is(geohex_get_zone_by_location(geohex_location(-53.330872983017L, -102.65625L), 11).code, "Fb05827021141", "lat:-53.330872983017,lng:-102.65625,level:11: Fb05827021141");
  str_is(geohex_get_zone_by_location(geohex_location(-47.75409797968L, 62.578125L), 11).code, "OK72311284586", "lat:-47.75409797968,lng:62.578125,level:11: OK72311284586");
  str_is(geohex_get_zone_by_location(geohex_location(-20.3034175184893L, -168.046875L), 11).code, "GH51383310718", "lat:-20.3034175184893,lng:-168.046875,level:11: GH51383310718");
  str_is(geohex_get_zone_by_location(geohex_location(-10.3514984896236L, -177.893008020019L), 11).code, "GI47416263465", "lat:-10.3514984896236,lng:-177.893008020019,level:11: GI47416263465");
  str_is(geohex_get_zone_by_location(geohex_location(-3.3750724311904L, -177.893008020019L), 11).code, "GI87045185255", "lat:-3.3750724311904,lng:-177.893008020019,level:11: GI87045185255");
  str_is(geohex_get_zone_by_location(geohex_location(4.00252710335009L, -177.893008020019L), 11).code, "QU07002763476", "lat:4.00252710335009,lng:-177.893008020019,level:11: QU07002763476");
  str_is(geohex_get_zone_by_location(geohex_location(20.0559312651944L, 179.912109375L), 11).code, "QU85663663436", "lat:20.0559312651944,lng:179.912109375,level:11: QU85663663436");
  str_is(geohex_get_zone_by_location(geohex_location(18.5629474428883L, 178.41796875L), 11).code, "QU84201138888", "lat:18.5629474428883,lng:178.41796875,level:11: QU84201138888");
  str_is(geohex_get_zone_by_location(geohex_location(22.1059987997506L, 128.232421875L), 11).code, "PS62147032100", "lat:22.1059987997506,lng:128.232421875,level:11: PS62147032100");
  str_is(geohex_get_zone_by_location(geohex_location(26.947688436082L, 146.159726354981L), 11).code, "XM30178015132", "lat:26.947688436082,lng:146.159726354981,level:11: XM30178015132");
  str_is(geohex_get_zone_by_location(geohex_location(29.8846192961586L, 153.103085729981L), 11).code, "XM60054311737", "lat:29.8846192961586,lng:153.103085729981,level:11: XM60054311737");
  str_is(geohex_get_zone_by_location(geohex_location(32.9902355596511L, 139.74609375L), 11).code, "XM44560457183", "lat:32.9902355596511,lng:139.74609375,level:11: XM44560457183");
  str_is(geohex_get_zone_by_location(geohex_location(36.0012569177875L, 137.722226354981L), 11).code, "XM56456700534", "lat:36.0012569177875,lng:137.722226354981,level:11: XM56456700534");
  str_is(geohex_get_zone_by_location(geohex_location(43.325177679993L, 141.6796875L), 11).code, "XX03131786872", "lat:43.325177679993,lng:141.6796875,level:11: XX03131786872");
  str_is(geohex_get_zone_by_location(geohex_location(38.8225909761771L, 38.671875L), 11).code, "PZ16386410216", "lat:38.8225909761771,lng:38.671875,level:11: PZ16386410216");
  str_is(geohex_get_zone_by_location(geohex_location(28.1167138721005L, -113.820742395019L), 11).code, "OI78178446320", "lat:28.1167138721005,lng:-113.820742395019,level:11: OI78178446320");
  str_is(geohex_get_zone_by_location(geohex_location(46.412227057262L, -106.086367395019L), 11).code, "RX13217487787", "lat:46.412227057262,lng:-106.086367395019,level:11: RX13217487787");
  str_is(geohex_get_zone_by_location(geohex_location(66.2314574786257L, -80.15625L), 11).code, "SV40163034106", "lat:66.2314574786257,lng:-80.15625,level:11: SV40163034106");
  str_is(geohex_get_zone_by_location(geohex_location(77.157162522661L, 18.28125L), 11).code, "aX41314430862", "lat:77.157162522661,lng:18.28125,level:11: aX41314430862");
  str_is(geohex_get_zone_by_location(geohex_location(75.1407778407043L, 120.9375L), 11).code, "ZA47238521110", "lat:75.1407778407043,lng:120.9375,level:11: ZA47238521110");
  str_is(geohex_get_zone_by_location(geohex_location(81.0601806553806L, 170.944882604981L), 11).code, "TK11857485652", "lat:81.0601806553806,lng:170.944882604981,level:11: TK11857485652");
  str_is(geohex_get_zone_by_location(geohex_location(81.4868032304587L, -179.914492395019L), 11).code, "TK43222807032", "lat:81.4868032304587,lng:-179.914492395019,level:11: TK43222807032");
  str_is(geohex_get_zone_by_location(geohex_location(83.5498507668598L, -178.2421875L), 11).code, "TO03574622544", "lat:83.5498507668598,lng:-178.2421875,level:11: TO03574622544");
  str_is(geohex_get_zone_by_location(geohex_location(84.7383871209534L, 172.353515625L), 11).code, "TO54114446763", "lat:84.7383871209534,lng:172.353515625,level:11: TO54114446763");
  str_is(geohex_get_zone_by_location(geohex_location(85.050417912863L, 88.1597900390625L), 11).code, "bb33540877533", "lat:85.050417912863,lng:88.1597900390625,level:11: bb33540877533");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0506548798275L, -79.82666015625L), 12).code, "BV803254745602", "lat:-85.0506548798275,lng:-79.82666015625,level:12: BV803254745602");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 120.706787109375L), 12).code, "CI803456424553", "lat:-85.0511287798066,lng:120.706787109375,level:12: CI803456424553");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, 178.868408203125L), 12).code, "DO053652024200", "lat:-85.0520764439798,lng:178.868408203125,level:12: DO053652024200");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 178.934326171875L), 12).code, "DO053654462750", "lat:-85.0511287798066,lng:178.934326171875,level:12: DO053654462750");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -178.253173828125L), 12).code, "DO071704644727", "lat:-85.0511287798066,lng:-178.253173828125,level:12: DO071704644727");
  str_is(geohex_get_zone_by_location(geohex_location(-79.445226643583L, -13.7023341918944L), 12).code, "CY281612610161", "lat:-79.445226643583,lng:-13.7023341918944,level:12: CY281612610161");
  str_is(geohex_get_zone_by_location(geohex_location(-77.9156689863258L, 172.96875L), 12).code, "EU181655132036", "lat:-77.9156689863258,lng:172.96875,level:12: EU181655132036");
  str_is(geohex_get_zone_by_location(geohex_location(-76.1849954609471L, -179.296875L), 12).code, "EU832016181016", "lat:-76.1849954609471,lng:-179.296875,level:12: EU832016181016");
  str_is(geohex_get_zone_by_location(geohex_location(-57.3643675190898L, -102.999209191894L), 12).code, "FY636801583240", "lat:-57.3643675190898,lng:-102.999209191894,level:12: FY636801583240");
  str_is(geohex_get_zone_by_location(geohex_location(-49.8379824530848L, 61.875L), 12).code, "OK446658243285", "lat:-49.8379824530848,lng:61.875,level:12: OK446658243285");
  str_is(geohex_get_zone_by_location(geohex_location(-27.7456223888095L, -162.061709191894L), 12).code, "GH058068815001", "lat:-27.7456223888095,lng:-162.061709191894,level:12: GH058068815001");
  str_is(geohex_get_zone_by_location(geohex_location(-13.3082127596866L, 177.547665808106L), 12).code, "GI410587505268", "lat:-13.3082127596866,lng:177.547665808106,level:12: GI410587505268");
  str_is(geohex_get_zone_by_location(geohex_location(-2.8814258912385L, -178.233584191894L), 12).code, "GI871735246286", "lat:-2.8814258912385,lng:-178.233584191894,level:12: GI871735246286");
  str_is(geohex_get_zone_by_location(geohex_location(10.4188347787547L, -175.421084191894L), 12).code, "QU460311054340", "lat:10.4188347787547,lng:-175.421084191894,level:12: QU460311054340");
  str_is(geohex_get_zone_by_location(geohex_location(13.8553135172218L, 176.141415808106L), 12).code, "QU533828300764", "lat:13.8553135172218,lng:176.141415808106,level:12: QU533828300764");
  str_is(geohex_get_zone_by_location(geohex_location(-5.61598581915533L, 4.921875L), 12).code, "OY313181386161", "lat:-5.61598581915533,lng:4.921875,level:12: OY313181386161");
  str_is(geohex_get_zone_by_location(geohex_location(4.84594591772659L, 0.360165808105606L), 12).code, "OY803527038734", "lat:4.84594591772659,lng:0.360165808105606,level:12: OY803527038734");
  str_is(geohex_get_zone_by_location(geohex_location(3.51342104564004L, -59.765625L), 12).code, "PA043284261600", "lat:3.51342104564004,lng:-59.765625,level:12: PA043284261600");
  str_is(geohex_get_zone_by_location(geohex_location(35.4035186514968L, 44.6570408081056L), 12).code, "PZ060785824214", "lat:35.4035186514968,lng:44.6570408081056,level:12: PZ060785824214");
  str_is(geohex_get_zone_by_location(geohex_location(22.5937260639293L, 128.3203125L), 12).code, "PS625060382624", "lat:22.5937260639293,lng:128.3203125,level:12: PS625060382624");
  str_is(geohex_get_zone_by_location(geohex_location(28.8602197525588L, 144.852353308106L), 12).code, "XM317558565378", "lat:28.8602197525588,lng:144.852353308106,level:12: XM317558565378");
  str_is(geohex_get_zone_by_location(geohex_location(29.4741845785535L, 153.992978308106L), 12).code, "XL822458403751", "lat:29.4741845785535,lng:153.992978308106,level:12: XL822458403751");
  str_is(geohex_get_zone_by_location(geohex_location(42.5013892782751L, 143.094540808106L), 12).code, "XP251226173262", "lat:42.5013892782751,lng:143.094540808106,level:12: XP251226173262");
  str_is(geohex_get_zone_by_location(geohex_location(26.3684016357923L, -113.897646691894L), 12).code, "OI745463230145", "lat:26.3684016357923,lng:-113.897646691894,level:12: OI745463230145");
  str_is(geohex_get_zone_by_location(geohex_location(43.5295585527122L, -107.921084191894L), 12).code, "RU681285781273", "lat:43.5295585527122,lng:-107.921084191894,level:12: RU681285781273");
  str_is(geohex_get_zone_by_location(geohex_location(66.3727550024746L, -76.9921875L), 12).code, "SV352321156833", "lat:66.3727550024746,lng:-76.9921875,level:12: SV352321156833");
  str_is(geohex_get_zone_by_location(geohex_location(74.4964131169431L, 116.71875L), 12).code, "ZA412658306821", "lat:74.4964131169431,lng:116.71875,level:12: ZA412658306821");
  str_is(geohex_get_zone_by_location(geohex_location(77.157162522661L, 18.6328125L), 12).code, "aX413323833627", "lat:77.157162522661,lng:18.6328125,level:12: aX413323833627");
  str_is(geohex_get_zone_by_location(geohex_location(82.1183836069127L, -43.59375L), 12).code, "bD023073480358", "lat:82.1183836069127,lng:-43.59375,level:12: bD023073480358");
  str_is(geohex_get_zone_by_location(geohex_location(82.2616987368315L, 175.078125L), 12).code, "TK570232153327", "lat:82.2616987368315,lng:175.078125,level:12: TK570232153327");
  str_is(geohex_get_zone_by_location(geohex_location(82.2994996528633L, -179.991396691894L), 12).code, "TK800808780528", "lat:82.2994996528633,lng:-179.991396691894,level:12: TK800808780528");
  str_is(geohex_get_zone_by_location(geohex_location(84.1177892355522L, -177.530459191894L), 12).code, "TO328348003525", "lat:84.1177892355522,lng:-177.530459191894,level:12: TO328348003525");
  str_is(geohex_get_zone_by_location(geohex_location(84.7641314110921L, 178.953915808106L), 12).code, "TO563763855337", "lat:84.7641314110921,lng:178.953915808106,level:12: TO563763855337");
  str_is(geohex_get_zone_by_location(geohex_location(85.0508918354752L, 88.9810180664062L), 12).code, "bb337212207184", "lat:85.0508918354752,lng:88.9810180664062,level:12: bb337212207184");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0207077431259L, -79.453125L), 13).code, "BV8046354823266", "lat:-85.0207077431259,lng:-79.453125,level:13: BV8046354823266");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9901001802348L, 113.5546875L), 13).code, "CI5803560714155", "lat:-84.9901001802348,lng:113.5546875,level:13: CI5803560714155");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0539712293069L, 179.6044921875L), 13).code, "DO0482706175341", "lat:-85.0539712293069,lng:179.6044921875,level:13: DO0482706175341");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0530239271352L, 179.6044921875L), 13).code, "DO0482731186381", "lat:-85.0530239271352,lng:179.6044921875,level:13: DO0482731186381");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, 179.769287109375L), 13).code, "DO0485035421662", "lat:-85.0520764439798,lng:179.769287109375,level:13: DO0485035421662");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, 179.813232421875L), 13).code, "DO0485060618642", "lat:-85.0520764439798,lng:179.813232421875,level:13: DO0485060618642");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0501809345811L, 179.813232421875L), 13).code, "DO0485068654767", "lat:-85.0501809345811,lng:179.813232421875,level:13: DO0485068654767");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0520764439798L, -179.049682617188L), 13).code, "DO0712537663424", "lat:-85.0520764439798,lng:-179.049682617188,level:13: DO0712537663424");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -179.044189453125L), 13).code, "DO0712564265481", "lat:-85.0511287798066,lng:-179.044189453125,level:13: DO0712564265481");
  str_is(geohex_get_zone_by_location(geohex_location(-77.5041191797399L, 177.36328125L), 13).code, "EU4501241604860", "lat:-77.5041191797399,lng:177.36328125,level:13: EU4501241604860");
  str_is(geohex_get_zone_by_location(geohex_location(-75.9725794480917L, -179.848574426269L), 13).code, "EU8407181150325", "lat:-75.9725794480917,lng:-179.848574426269,level:13: EU8407181150325");
  str_is(geohex_get_zone_by_location(geohex_location(-78.9039293885709L, -12.3046875L), 13).code, "CZ3061211527483", "lat:-78.9039293885709,lng:-12.3046875,level:13: CZ3061211527483");
  str_is(geohex_get_zone_by_location(geohex_location(-49.8379824530848L, -97.3828125L), 13).code, "Fb4625116215430", "lat:-49.8379824530848,lng:-97.3828125,level:13: Fb4625116215430");
  str_is(geohex_get_zone_by_location(geohex_location(-47.2792290025708L, 61.5234375L), 13).code, "OK7250326542858", "lat:-47.2792290025708,lng:61.5234375,level:13: OK7250326542858");
  str_is(geohex_get_zone_by_location(geohex_location(-22.5937260639293L, -166.2890625L), 13).code, "GH4221515066426", "lat:-22.5937260639293,lng:-166.2890625,level:13: GH4221515066426");
  str_is(geohex_get_zone_by_location(geohex_location(-11.5230875068685L, 178.2421875L), 13).code, "GI4421818162227", "lat:-11.5230875068685,lng:178.2421875,level:13: GI4421818162227");
  str_is(geohex_get_zone_by_location(geohex_location(-2.46018118102099L, -179.296875L), 13).code, "GI8724851414563", "lat:-2.46018118102099,lng:-179.296875,level:13: GI8724851414563");
  str_is(geohex_get_zone_by_location(geohex_location(9.44906182688142L, -179.296875L), 13).code, "QU4074815410453", "lat:9.44906182688142,lng:-179.296875,level:13: QU4074815410453");
  str_is(geohex_get_zone_by_location(geohex_location(20.632784250388L, 179.296875L), 13).code, "QU8810462030471", "lat:20.632784250388,lng:179.296875,level:13: QU8810462030471");
  str_is(geohex_get_zone_by_location(geohex_location(3.51342104564004L, -60.8203125L), 13).code, "PA0414822216031", "lat:3.51342104564004,lng:-60.8203125,level:13: PA0414822216031");
  str_is(geohex_get_zone_by_location(geohex_location(-0.351560293992271L, -3.1640625L), 13).code, "OY4236836048713", "lat:-0.351560293992271,lng:-3.1640625,level:13: OY4236836048713");
  str_is(geohex_get_zone_by_location(geohex_location(0.355576693380542L, 6.30376932373061L), 13).code, "OY7001555744550", "lat:0.355576693380542,lng:6.30376932373061,level:13: OY7001555744550");
  str_is(geohex_get_zone_by_location(geohex_location(31.353636941501L, 137.4609375L), 13).code, "XM4117607703260", "lat:31.353636941501,lng:137.4609375,level:13: XM4117607703260");
  str_is(geohex_get_zone_by_location(geohex_location(22.5937260639293L, 129.375L), 13).code, "PS6246856326218", "lat:22.5937260639293,lng:129.375,level:13: PS6246856326218");
  str_is(geohex_get_zone_by_location(geohex_location(29.232395052192L, 153.608456823731L), 13).code, "XL5887834871345", "lat:29.232395052192,lng:153.608456823731,level:13: XL5887834871345");
  str_is(geohex_get_zone_by_location(geohex_location(42.814468134372L, 142.006894323731L), 13).code, "XX0066438378463", "lat:42.814468134372,lng:142.006894323731,level:13: XX0066438378463");
  str_is(geohex_get_zone_by_location(geohex_location(42.5530802889558L, 38.671875L), 13).code, "PZ4537105130820", "lat:42.5530802889558,lng:38.671875,level:13: PZ4537105130820");
  str_is(geohex_get_zone_by_location(geohex_location(27.9979478746264L, -116.743105676269L), 13).code, "OI8337351073052", "lat:27.9979478746264,lng:-116.743105676269,level:13: OI8337351073052");
  str_is(geohex_get_zone_by_location(geohex_location(46.3193581834244L, -108.305605676269L), 13).code, "RX1135780670728", "lat:46.3193581834244,lng:-108.305605676269,level:13: RX1135780670728");
  str_is(geohex_get_zone_by_location(geohex_location(66.9300602586245L, -80.5078125L), 13).code, "SV4163853373183", "lat:66.9300602586245,lng:-80.5078125,level:13: SV4163853373183");
  str_is(geohex_get_zone_by_location(geohex_location(76.9206135182968L, 20.7421875L), 13).code, "aX4034808877353", "lat:76.9206135182968,lng:20.7421875,level:13: aX4034808877353");
  str_is(geohex_get_zone_by_location(geohex_location(75.1407778407043L, 121.2890625L), 13).code, "ZA4726354081160", "lat:75.1407778407043,lng:121.2890625,level:13: ZA4726354081160");
  str_is(geohex_get_zone_by_location(geohex_location(82.5861063502088L, -40.4296875L), 13).code, "bD0853382488383", "lat:82.5861063502088,lng:-40.4296875,level:13: bD0853382488383");
  str_is(geohex_get_zone_by_location(geohex_location(81.923186326022L, 168.75L), 13).code, "TK2756770452053", "lat:81.923186326022,lng:168.75,level:13: TK2756770452053");
  str_is(geohex_get_zone_by_location(geohex_location(82.1664460084773L, -172.6171875L), 13).code, "TK7434850466772", "lat:82.1664460084773,lng:-172.6171875,level:13: TK7434850466772");
  str_is(geohex_get_zone_by_location(geohex_location(83.9054843956402L, -179.321230676269L), 13).code, "TO0846631354832", "lat:83.9054843956402,lng:-179.321230676269,level:13: TO0846631354832");
  str_is(geohex_get_zone_by_location(geohex_location(84.6082178794592L, 179.624081823731L), 13).code, "TO4805277813220", "lat:84.6082178794592,lng:179.624081823731,level:13: TO4805277813220");
  str_is(geohex_get_zone_by_location(geohex_location(85.051099162384L, 88.6768341064453L), 13).code, "bb3356324634667", "lat:85.051099162384,lng:88.6768341064453,level:13: bb3356324634667");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9901001802348L, -79.453125L), 14).code, "BV80717180121576", "lat:-84.9901001802348,lng:-79.453125,level:14: BV80717180121576");
  str_is(geohex_get_zone_by_location(geohex_location(-85.1412839811764L, 118.125L), 14).code, "CI56436210413512", "lat:-85.1412839811764,lng:118.125,level:14: CI56436210413512");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0813644184664L, 118.828125L), 14).code, "CI56773820550701", "lat:-85.0813644184664,lng:118.828125,level:14: CI56773820550701");
  str_is(geohex_get_zone_by_location(geohex_location(-85.035941506574L, 121.11328125L), 14).code, "CI80611150250021", "lat:-85.035941506574,lng:121.11328125,level:14: CI80611150250021");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 177.5390625L), 14).code, "DO05167224507116", "lat:-85.0511287798066,lng:177.5390625,level:14: DO05167224507116");
  str_is(geohex_get_zone_by_location(geohex_location(-85.035941506574L, 177.71484375L), 14).code, "DO05405867244763", "lat:-85.035941506574,lng:177.71484375,level:14: DO05405867244763");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0513657128222L, -178.339691162109L), 14).code, "DO07170215584802", "lat:-85.0513657128222,lng:-178.339691162109,level:14: DO07170215584802");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0512472477288L, -178.339691162109L), 14).code, "DO07170226100057", "lat:-85.0512472477288,lng:-178.339691162109,level:14: DO07170226100057");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0510103090554L, -178.339691162109L), 14).code, "DO07170227640163", "lat:-85.0510103090554,lng:-178.339691162109,level:14: DO07170227640163");
  str_is(geohex_get_zone_by_location(geohex_location(-78.3494106901463L, 178.154296875L), 14).code, "EU16473602511456", "lat:-78.3494106901463,lng:178.154296875,level:14: EU16473602511456");
  str_is(geohex_get_zone_by_location(geohex_location(-78.0901008123345L, -178.182429101562L), 14).code, "EU40673078217161", "lat:-78.0901008123345,lng:-178.182429101562,level:14: EU40673078217161");
  str_is(geohex_get_zone_by_location(geohex_location(-78.4905516616031L, -15.46875L), 14).code, "CZ31831222362536", "lat:-78.4905516616031,lng:-15.46875,level:14: CZ31831222362536");
  str_is(geohex_get_zone_by_location(geohex_location(-53.330872983017L, -97.03125L), 14).code, "Fb31200035818717", "lat:-53.330872983017,lng:-97.03125,level:14: Fb31200035818717");
  str_is(geohex_get_zone_by_location(geohex_location(-49.9256543925955L, 58.5949146484376L), 14).code, "OK44243402806508", "lat:-49.9256543925955,lng:58.5949146484376,level:14: OK44243402806508");
  str_is(geohex_get_zone_by_location(geohex_location(-8.40716816360107L, -2.8125L), 14).code, "OY01571576207503", "lat:-8.40716816360107,lng:-2.8125,level:14: OY01571576207503");
  str_is(geohex_get_zone_by_location(geohex_location(4.07924021199305L, -1.17071035156236L), 14).code, "OY56733420402656", "lat:4.07924021199305,lng:-1.17071035156236,level:14: OY56733420402656");
  str_is(geohex_get_zone_by_location(geohex_location(-15.9613290815966L, -159.609375L), 14).code, "GH84065825033010", "lat:-15.9613290815966,lng:-159.609375,level:14: GH84065825033010");
  str_is(geohex_get_zone_by_location(geohex_location(-10.621569004993L, 173.907414648438L), 14).code, "GI50342481388451", "lat:-10.621569004993,lng:173.907414648438,level:14: GI50342481388451");
  str_is(geohex_get_zone_by_location(geohex_location(-5.75137610292601L, -173.436335351562L), 14).code, "GI78081171860100", "lat:-5.75137610292601,lng:-173.436335351562,level:14: GI78081171860100");
  str_is(geohex_get_zone_by_location(geohex_location(5.48056406874262L, -174.139460351562L), 14).code, "QU30541311610415", "lat:5.48056406874262,lng:-174.139460351562,level:14: QU30541311610415");
  str_is(geohex_get_zone_by_location(geohex_location(12.4217234089099L, 179.532414648438L), 14).code, "QU44828780263624", "lat:12.4217234089099,lng:179.532414648438,level:14: QU44828780263624");
  str_is(geohex_get_zone_by_location(geohex_location(5.61598581915534L, -58.359375L), 14).code, "PA07571045254517", "lat:5.61598581915534,lng:-58.359375,level:14: PA07571045254517");
  str_is(geohex_get_zone_by_location(geohex_location(21.162545457735L, 127.501164648438L), 14).code, "PS38383877824230", "lat:21.162545457735,lng:127.501164648438,level:14: PS38383877824230");
  str_is(geohex_get_zone_by_location(geohex_location(28.1845211850003L, 145.079289648438L), 14).code, "XM31385143063872", "lat:28.1845211850003,lng:145.079289648438,level:14: XM31385143063872");
  str_is(geohex_get_zone_by_location(geohex_location(29.4167816436476L, 155.626164648438L), 14).code, "XL82447011727335", "lat:29.4167816436476,lng:155.626164648438,level:14: XL82447011727335");
  str_is(geohex_get_zone_by_location(geohex_location(41.9318347167088L, 141.563664648438L), 14).code, "XP22503400845082", "lat:41.9318347167088,lng:141.563664648438,level:14: XP22503400845082");
  str_is(geohex_get_zone_by_location(geohex_location(38.272688535981L, 34.453125L), 14).code, "PZ13526267300787", "lat:38.272688535981,lng:34.453125,level:14: PZ13526267300787");
  str_is(geohex_get_zone_by_location(geohex_location(28.1845211850003L, -112.967585351562L), 14).code, "OI78437338044154", "lat:28.1845211850003,lng:-112.967585351562,level:14: OI78437338044154");
  str_is(geohex_get_zone_by_location(geohex_location(44.4934928233501L, -106.639460351562L), 14).code, "RU68880348017456", "lat:44.4934928233501,lng:-106.639460351562,level:14: RU68880348017456");
  str_is(geohex_get_zone_by_location(geohex_location(65.3100652213914L, -84.8425853515624L), 14).code, "SV13411223332736", "lat:65.3100652213914,lng:-84.8425853515624,level:14: SV13411223332736");
  str_is(geohex_get_zone_by_location(geohex_location(77.282602201606L, 24.8449146484376L), 14).code, "aX38226176387034", "lat:77.282602201606,lng:24.8449146484376,level:14: aX38226176387034");
  str_is(geohex_get_zone_by_location(geohex_location(74.0195433115023L, 123.046875L), 14).code, "ZA35122807551718", "lat:74.0195433115023,lng:123.046875,level:14: ZA35122807551718");
  str_is(geohex_get_zone_by_location(geohex_location(82.8533822917608L, -37.96875L), 14).code, "bD32858648748733", "lat:82.8533822917608,lng:-37.96875,level:14: bD32858648748733");
  str_is(geohex_get_zone_by_location(geohex_location(81.5182718765338L, 175.078125L), 14).code, "TK18678460283758", "lat:81.5182718765338,lng:175.078125,level:14: TK18678460283758");
  str_is(geohex_get_zone_by_location(geohex_location(81.3083209005181L, -177.1875L), 14).code, "TK35253726505866", "lat:81.3083209005181,lng:-177.1875,level:14: TK35253726505866");
  str_is(geohex_get_zone_by_location(geohex_location(84.1110298514359L, -175.545710351562L), 14).code, "TO35083224064751", "lat:84.1110298514359,lng:-175.545710351562,level:14: TO35083224064751");
  str_is(geohex_get_zone_by_location(geohex_location(84.5284028366271L, 177.423039648438L), 14).code, "TO45177603556405", "lat:84.5284028366271,lng:177.423039648438,level:14: TO45177603556405");
  str_is(geohex_get_zone_by_location(geohex_location(85.0501290940733L, 88.7193202972412L), 14).code, "bb33563401287846", "lat:85.0501290940733,lng:88.7193202972412,level:14: bb33563401287846");
  str_is(geohex_get_zone_by_location(geohex_location(85.0511287798066L, 88.7024974822998L), 14).code, "bb33563422636071", "lat:85.0511287798066,lng:88.7024974822998,level:14: bb33563422636071");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0549183505294L, -80.244140625L), 15).code, "BV801644720107680", "lat:-85.0549183505294,lng:-80.244140625,level:15: BV801644720107680");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -80.244140625L), 15).code, "BV801672224571144", "lat:-85.0511287798066,lng:-80.244140625,level:15: BV801672224571144");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0435409456565L, -76.81640625L), 15).code, "BV752066087034602", "lat:-85.0435409456565,lng:-76.81640625,level:15: BV752066087034602");
  str_is(geohex_get_zone_by_location(geohex_location(-84.9283209294996L, 113.203125L), 15).code, "CI584051202811030", "lat:-84.9283209294996,lng:113.203125,level:15: CI584051202811030");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, 178.70361328125L), 15).code, "DO053702425073344", "lat:-85.0511287798066,lng:178.70361328125,level:15: DO053702425073344");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0510103090554L, 178.621215820312L), 15).code, "DO053474671871414", "lat:-85.0510103090554,lng:178.621215820312,level:15: DO053474671871414");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0511287798066L, -179.47265625L), 15).code, "DO048672464801367", "lat:-85.0511287798066,lng:-179.47265625,level:15: DO048672464801367");
  str_is(geohex_get_zone_by_location(geohex_location(-85.0492329082692L, -179.49462890625L), 15).code, "DO048680771383421", "lat:-85.0492329082692,lng:-179.49462890625,level:15: DO048680771383421");
  str_is(geohex_get_zone_by_location(geohex_location(-78.6300055677483L, -16.875L), 15).code, "CZ312460160330640", "lat:-78.6300055677483,lng:-16.875,level:15: CZ312460160330640");
  str_is(geohex_get_zone_by_location(geohex_location(-76.9999351181161L, 178.59375L), 15).code, "EU482446631807432", "lat:-76.9999351181161,lng:178.59375,level:15: EU482446631807432");
  str_is(geohex_get_zone_by_location(geohex_location(-77.6928703364193L, -179.6484375L), 15).code, "EU443120677000135", "lat:-77.6928703364193,lng:-179.6484375,level:15: EU443120677000135");
  str_is(geohex_get_zone_by_location(geohex_location(-48.2246726495652L, 61.171875L), 15).code, "OK486263022716030", "lat:-48.2246726495652,lng:61.171875,level:15: OK486263022716030");
  str_is(geohex_get_zone_by_location(geohex_location(-47.75409797968L, -101.6015625L), 15).code, "Fb563137601173436", "lat:-47.75409797968,lng:-101.6015625,level:15: Fb563137601173436");
  str_is(geohex_get_zone_by_location(geohex_location(-24.5271348225978L, -160.3125L), 15).code, "GH405610617770460", "lat:-24.5271348225978,lng:-160.3125,level:15: GH405610617770460");
  str_is(geohex_get_zone_by_location(geohex_location(-10.6278115862448L, 175.584117147827L), 15).code, "GI428447007470857", "lat:-10.6278115862448,lng:175.584117147827,level:15: GI428447007470857");
  str_is(geohex_get_zone_by_location(geohex_location(-8.89551936027947L, -174.923695352173L), 15).code, "GI714676472576137", "lat:-8.89551936027947,lng:-174.923695352173,level:15: GI714676472576137");
  str_is(geohex_get_zone_by_location(geohex_location(9.65531361108872L, -177.736195352173L), 15).code, "QU430846555413857", "lat:9.65531361108872,lng:-177.736195352173,level:15: QU430846555413857");
  str_is(geohex_get_zone_by_location(geohex_location(13.4537372134192L, 177.1875L), 15).code, "QU455868523435074", "lat:13.4537372134192,lng:177.1875,level:15: QU455868523435074");
  str_is(geohex_get_zone_by_location(geohex_location(28.6134594240044L, 144.4921875L), 15).code, "XM314886135481601", "lat:28.6134594240044,lng:144.4921875,level:15: XM314886135481601");
  str_is(geohex_get_zone_by_location(geohex_location(22.268764039074L, 129.0234375L), 15).code, "PS624076167125758", "lat:22.268764039074,lng:129.0234375,level:15: PS624076167125758");
  str_is(geohex_get_zone_by_location(geohex_location(30.4016615131776L, 155.413218710327L), 15).code, "XL828827023882162", "lat:30.4016615131776,lng:155.413218710327,level:15: XL828827023882162");
  str_is(geohex_get_zone_by_location(geohex_location(42.7715132719991L, 142.756968710327L), 15).code, "XP252183615213788", "lat:42.7715132719991,lng:142.756968710327,level:15: XP252183615213788");
  str_is(geohex_get_zone_by_location(geohex_location(-0.351560293992271L, -0.3515625L), 15).code, "OY441655876848342", "lat:-0.351560293992271,lng:-0.3515625,level:15: OY441655876848342");
  str_is(geohex_get_zone_by_location(geohex_location(0.648591093753425L, -2.43834378967267L), 15).code, "OY450583438341310", "lat:0.648591093753425,lng:-2.43834378967267,level:15: OY450583438341310");
  str_is(geohex_get_zone_by_location(geohex_location(1.40610883543516L, -59.4140625L), 15).code, "PA007023204648554", "lat:1.40610883543516,lng:-59.4140625,level:15: PA007023204648554");
  str_is(geohex_get_zone_by_location(geohex_location(27.0105631247302L, -115.289906289673L), 15).code, "OI754343508378851", "lat:27.0105631247302,lng:-115.289906289673,level:15: OI754343508378851");
  str_is(geohex_get_zone_by_location(geohex_location(47.9899216674142L, -108.6328125L), 15).code, "RX153284780083552", "lat:47.9899216674142,lng:-108.6328125,level:15: RX153284780083552");
  str_is(geohex_get_zone_by_location(geohex_location(44.3395652480971L, 32.6953125L), 15).code, "PZ541437131806627", "lat:44.3395652480971,lng:32.6953125,level:15: PZ541437131806627");
  str_is(geohex_get_zone_by_location(geohex_location(65.072130085607L, -80.859375L), 15).code, "SV081012647253500", "lat:65.072130085607,lng:-80.859375,level:15: SV081012647253500");
  str_is(geohex_get_zone_by_location(geohex_location(73.8248203461393L, 116.71875L), 15).code, "ZA162768706170274", "lat:73.8248203461393,lng:116.71875,level:15: ZA162768706170274");
  str_is(geohex_get_zone_by_location(geohex_location(78.2782014554281L, 16.171875L), 15).code, "aX538661552510561", "lat:78.2782014554281,lng:16.171875,level:15: aX538661552510561");
  str_is(geohex_get_zone_by_location(geohex_location(83.400042059767L, -38.671875L), 15).code, "bD475537206875044", "lat:83.400042059767,lng:-38.671875,level:15: bD475537206875044");
  str_is(geohex_get_zone_by_location(geohex_location(82.3088925182155L, 176.1328125L), 15).code, "TK573170435224014", "lat:82.3088925182155,lng:176.1328125,level:15: TK573170435224014");
  str_is(geohex_get_zone_by_location(geohex_location(82.0700281944827L, -177.890625L), 15).code, "TK720137660817775", "lat:82.0700281944827,lng:-177.890625,level:15: TK720137660817775");
  str_is(geohex_get_zone_by_location(geohex_location(83.8992664793694L, -177.868031289673L), 15).code, "TO078855632751174", "lat:83.8992664793694,lng:-177.868031289673,level:15: TO078855632751174");
  str_is(geohex_get_zone_by_location(geohex_location(84.5025950013051L, -179.977406289673L), 15).code, "TO448407012467243", "lat:84.5025950013051,lng:-179.977406289673,level:15: TO448407012467243");
  str_is(geohex_get_zone_by_location(geohex_location(84.8609006021274L, 178.967906210327L), 15).code, "TO801157747467437", "lat:84.8609006021274,lng:178.967906210327,level:15: TO801157747467437");
  str_is(geohex_get_zone_by_location(geohex_location(85.0511250776385L, 89.3795299530029L), 15).code, "bb337184418811744", "lat:85.0511250776385,lng:89.3795299530029,level:15: bb337184418811744");
}

void coord2xy (void) {
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(33.3513795014662L, 135.610448095703L), 0), geohex_coordinate(5L, -2L), "lat:33.3513795014662,lng:135.610448095703,level:0: x:5,y:-2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-1.15050062287007L, -9.2333019042969L), 0), geohex_coordinate(0L, 0L), "lat:-1.15050062287007,lng:-9.2333019042969,level:0: x:0,y:0");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-2.73157384094483L, 178.940526220703L), 0), geohex_coordinate(-5L, 4L), "lat:-2.73157384094483,lng:178.940526220703,level:0: x:-5,y:4");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.64510641861202L, -174.819239404297L), 0), geohex_coordinate(-4L, 5L), "lat:4.64510641861202,lng:-174.819239404297,level:0: x:-4,y:5");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-23.4907376902333L, -158.295801904297L), 0), geohex_coordinate(-5L, 3L), "lat:-23.4907376902333,lng:-158.295801904297,level:0: x:-5,y:3");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.2497182061045L, 176.391698095703L), 0), geohex_coordinate(-10L, -1L), "lat:-76.2497182061045,lng:176.391698095703,level:0: x:-10,y:-1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.2523394635965L, 108.891698095703L), 0), geohex_coordinate(-5L, -11L), "lat:-85.2523394635965,lng:108.891698095703,level:0: x:-5,y:-11");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.8900362156735L, -83.7645519042969L), 0), geohex_coordinate(-10L, -6L), "lat:-84.8900362156735,lng:-83.7645519042969,level:0: x:-10,y:-6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.2250012375504L, -102.045801904297L), 0), geohex_coordinate(-5L, 0L), "lat:-47.2250012375504,lng:-102.045801904297,level:0: x:-5,y:0");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.684617798596L, -87.9833019042969L), 0), geohex_coordinate(2L, 6L), "lat:66.684617798596,lng:-87.9833019042969,level:0: x:2,y:6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.648233414888L, -177.983301904297L), 0), geohex_coordinate(3L, 12L), "lat:84.648233414888,lng:-177.983301904297,level:0: x:3,y:12");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.2724484946331L, 172.876073095703L), 0), geohex_coordinate(2L, 11L), "lat:82.2724484946331,lng:172.876073095703,level:0: x:2,y:11");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.9931560555461L, -35.9520519042969L), 0), geohex_coordinate(6L, 8L), "lat:82.9931560555461,lng:-35.9520519042969,level:0: x:6,y:8");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.6170490163304L, 112.407323095703L), 0), geohex_coordinate(8L, 2L), "lat:76.6170490163304,lng:112.407323095703,level:0: x:8,y:2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.0709491329254L, 24.5166980957031L), 0), geohex_coordinate(6L, 5L), "lat:75.0709491329254,lng:24.5166980957031,level:0: x:6,y:5");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.3526322276402L, 30.1416980957031L), 0), geohex_coordinate(3L, 1L), "lat:42.3526322276402,lng:30.1416980957031,level:0: x:3,y:1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-46.7453426931156L, 61.7823230957031L), 0), geohex_coordinate(-1L, -4L), "lat:-46.7453426931156,lng:61.7823230957031,level:0: x:-1,y:-4");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.4041456239641L, -16.9676769042969L), 1), geohex_coordinate(-18L, -16L), "lat:-78.4041456239641,lng:-16.9676769042969,level:1: x:-18,y:-16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.7383871209534L, 119.53125L), 1), geohex_coordinate(-14L, -32L), "lat:-84.7383871209534,lng:119.53125,level:1: x:-14,y:-32");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0137687469871L, 177.094823095703L), 1), geohex_coordinate(-37L, -10L), "lat:-85.0137687469871,lng:177.094823095703,level:1: x:-37,y:-10");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-75.4088542284645L, -175.78125L), 1), geohex_coordinate(-28L, -2L), "lat:-75.4088542284645,lng:-175.78125,level:1: x:-28,y:-2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.9156689863258L, 175.78125L), 1), geohex_coordinate(-4L, -30L), "lat:-77.9156689863258,lng:175.78125,level:1: x:-4,y:-30");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.3992056535538L, 59.0625L), 1), geohex_coordinate(-3L, -12L), "lat:-51.3992056535538,lng:59.0625,level:1: x:-3,y:-12");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-12.4765711629959L, -175.873926904297L), 1), geohex_coordinate(-15L, 11L), "lat:-12.4765711629959,lng:-175.873926904297,level:1: x:-15,y:11");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-15.2841851140764L, 174.375L), 1), geohex_coordinate(11L, -15L), "lat:-15.2841851140764,lng:174.375,level:1: x:11,y:-15");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(7.09295413795132L, 178.501073095703L), 1), geohex_coordinate(-13L, 14L), "lat:7.09295413795132,lng:178.501073095703,level:1: x:-13,y:14");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(15.3612360133079L, -177.280176904297L), 1), geohex_coordinate(-11L, 15L), "lat:15.3612360133079,lng:-177.280176904297,level:1: x:-11,y:15");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-16.6361918783976L, -161.71875L), 1), geohex_coordinate(-14L, 10L), "lat:-16.6361918783976,lng:-161.71875,level:1: x:-14,y:10");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-7.01366792756663L, -1.40625L), 1), geohex_coordinate(-1L, -1L), "lat:-7.01366792756663,lng:-1.40625,level:1: x:-1,y:-1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.6180165487737L, -97.03125L), 1), geohex_coordinate(-15L, -1L), "lat:-51.6180165487737,lng:-97.03125,level:1: x:-15,y:-1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(31.952162238025L, 140.625L), 1), geohex_coordinate(15L, -6L), "lat:31.952162238025,lng:140.625,level:1: x:15,y:-6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(38.8848059617649L, 39.2823230957031L), 1), geohex_coordinate(8L, 2L), "lat:38.8848059617649,lng:39.2823230957031,level:1: x:8,y:2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(70.6126142380192L, -87.1875L), 1), geohex_coordinate(7L, 20L), "lat:70.6126142380192,lng:-87.1875,level:1: x:7,y:20");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(65.9464717761574L, -77.34375L), 1), geohex_coordinate(6L, 17L), "lat:65.9464717761574,lng:-77.34375,level:1: x:6,y:17");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.5168188771732L, 18.28125L), 1), geohex_coordinate(17L, 14L), "lat:76.5168188771732,lng:18.28125,level:1: x:17,y:14");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(79.4470123748349L, 18.1885730957031L), 1), geohex_coordinate(19L, 16L), "lat:79.4470123748349,lng:18.1885730957031,level:1: x:19,y:16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.1293312094838L, -33.8426769042969L), 1), geohex_coordinate(17L, 22L), "lat:82.1293312094838,lng:-33.8426769042969,level:1: x:17,y:22");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.2671724043167L, 178.59375L), 1), geohex_coordinate(9L, 36L), "lat:84.2671724043167,lng:178.59375,level:1: x:9,y:36");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.520162383532L, 174.375L), 1), geohex_coordinate(34L, 8L), "lat:83.520162383532,lng:174.375,level:1: x:34,y:8");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.3083209005181L, 172.96875L), 1), geohex_coordinate(32L, 6L), "lat:81.3083209005181,lng:172.96875,level:1: x:32,y:6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.0932138526084L, -171.5625L), 1), geohex_coordinate(6L, 32L), "lat:81.0932138526084,lng:-171.5625,level:1: x:6,y:32");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(74.4021625984244L, 119.53125L), 1), geohex_coordinate(24L, 6L), "lat:74.4021625984244,lng:119.53125,level:1: x:24,y:6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(0.0798907783945947L, -61.9676769042969L), 1), geohex_coordinate(-4L, 5L), "lat:0.0798907783945947,lng:-61.9676769042969,level:1: x:-4,y:5");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.5413610731341L, -77.34375L), 1), geohex_coordinate(-29L, -17L), "lat:-84.5413610731341,lng:-77.34375,level:1: x:-29,y:-17");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 130.78125L), 2), geohex_coordinate(-41L, -100L), "lat:-85.0511287798066,lng:130.78125,level:2: x:-41,y:-100");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.04423207151L, 111.001073095703L), 2), geohex_coordinate(-45L, -95L), "lat:-85.04423207151,lng:111.001073095703,level:2: x:-45,y:-95");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9438366148284L, -178.505859375L), 2), geohex_coordinate(-110L, -30L), "lat:-84.9438366148284,lng:-178.505859375,level:2: x:-110,y:-30");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9212535198558L, 177.534276220703L), 2), geohex_coordinate(-30L, -110L), "lat:-84.9212535198558,lng:177.534276220703,level:2: x:-30,y:-110");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-79.2371850060933L, -174.7265625L), 2), geohex_coordinate(-92L, -13L), "lat:-79.2371850060933,lng:-174.7265625,level:2: x:-92,y:-13");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.6142448093152L, 174.282323095703L), 2), geohex_coordinate(-12L, -91L), "lat:-78.6142448093152,lng:174.282323095703,level:2: x:-12,y:-91");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-27.0591257843741L, -157.5L), 2), geohex_coordinate(-46L, 25L), "lat:-27.0591257843741,lng:-157.5,level:2: x:-46,y:25");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.9899216674142L, 52.03125L), 2), geohex_coordinate(-10L, -33L), "lat:-47.9899216674142,lng:52.03125,level:2: x:-10,y:-33");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-11.1784018737118L, -178.59375L), 2), geohex_coordinate(-44L, 36L), "lat:-11.1784018737118,lng:-178.59375,level:2: x:-44,y:36");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.32812783056059L, 175.688573095703L), 2), geohex_coordinate(36L, -43L), "lat:-8.32812783056059,lng:175.688573095703,level:2: x:36,y:-43");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(7.09295413795179L, 179.907323095703L), 2), geohex_coordinate(-38L, 43L), "lat:7.09295413795179,lng:179.907323095703,level:2: x:-38,y:43");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(6.91848534360103L, -165.502833154297L), 2), geohex_coordinate(-35L, 40L), "lat:6.91848534360103,lng:-165.502833154297,level:2: x:-35,y:40");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(19.4769502064884L, 173.408203125L), 2), geohex_coordinate(47L, -31L), "lat:19.4769502064884,lng:173.408203125,level:2: x:47,y:-31");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.2390854919664L, 137.016698095703L), 2), geohex_coordinate(46L, -16L), "lat:35.2390854919664,lng:137.016698095703,level:2: x:46,y:-16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.3426767537396L, 128.579198095703L), 2), geohex_coordinate(38L, -20L), "lat:22.3426767537396,lng:128.579198095703,level:2: x:38,y:-20");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.8701013280904L, 142.641698095703L), 2), geohex_coordinate(51L, -13L), "lat:42.8701013280904,lng:142.641698095703,level:2: x:51,y:-13");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.9798980696201L, 45.703125L), 2), geohex_coordinate(28L, 7L), "lat:40.9798980696201,lng:45.703125,level:2: x:28,y:7");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(36.0313317763319L, 38.671875L), 2), geohex_coordinate(24L, 6L), "lat:36.0313317763319,lng:38.671875,level:2: x:24,y:6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.9798980696201L, 33.046875L), 2), geohex_coordinate(25L, 10L), "lat:40.9798980696201,lng:33.046875,level:2: x:25,y:10");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-12.1330854540274L, -0.0926769042968978L), 2), geohex_coordinate(-5L, -5L), "lat:-12.1330854540274,lng:-0.0926769042968978,level:2: x:-5,y:-5");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.51342104564004L, -4.921875L), 2), geohex_coordinate(0L, 2L), "lat:3.51342104564004,lng:-4.921875,level:2: x:0,y:2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.21494314139065L, -59.765625L), 2), geohex_coordinate(-12L, 15L), "lat:4.21494314139065,lng:-59.765625,level:2: x:-12,y:15");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.6180165487737L, -105.46875L), 2), geohex_coordinate(-47L, 0L), "lat:-51.6180165487737,lng:-105.46875,level:2: x:-47,y:0");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.6180165487737L, -93.515625L), 2), geohex_coordinate(-45L, -3L), "lat:-51.6180165487737,lng:-93.515625,level:2: x:-45,y:-3");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-44.2823986826075L, -95.7176769042969L), 2), geohex_coordinate(-41L, 2L), "lat:-44.2823986826075,lng:-95.7176769042969,level:2: x:-41,y:2");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-17.30868788677L, -167.34375L), 2), geohex_coordinate(-44L, 31L), "lat:-17.30868788677,lng:-167.34375,level:2: x:-44,y:31");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.5816722445285L, -165.327051904297L), 2), geohex_coordinate(21L, 95L), "lat:81.5816722445285,lng:-165.327051904297,level:2: x:21,y:95");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.7242834670548L, -177.983301904297L), 2), geohex_coordinate(25L, 105L), "lat:83.7242834670548,lng:-177.983301904297,level:2: x:25,y:105");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.4478417707319L, 176.391698095703L), 2), geohex_coordinate(107L, 28L), "lat:84.4478417707319,lng:176.391698095703,level:2: x:107,y:28");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(80.4157074446218L, 175.78125L), 2), geohex_coordinate(95L, 16L), "lat:80.4157074446218,lng:175.78125,level:2: x:95,y:16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.4592554716036L, -35.9520519042969L), 2), geohex_coordinate(53L, 69L), "lat:82.4592554716036,lng:-35.9520519042969,level:2: x:53,y:69");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.648233414888L, -51.4208019042969L), 2), geohex_coordinate(57L, 80L), "lat:84.648233414888,lng:-51.4208019042969,level:2: x:57,y:80");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0352492274202L, 90.0831043457031L), 2), geohex_coordinate(90L, 50L), "lat:85.0352492274202,lng:90.0831043457031,level:2: x:90,y:50");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0511287798066L, 179.912109375L), 2), geohex_coordinate(30L, 111L), "lat:85.0511287798066,lng:179.912109375,level:2: x:30,y:111");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.5162211763226L, -177.275390625L), 2), geohex_coordinate(28L, 108L), "lat:84.5162211763226,lng:-177.275390625,level:2: x:28,y:108");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.163581025311L, 171.826171875L), 2), geohex_coordinate(101L, 24L), "lat:83.163581025311,lng:171.826171875,level:2: x:101,y:24");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(73.5283994876517L, 119.1796875L), 2), geohex_coordinate(70L, 16L), "lat:73.5283994876517,lng:119.1796875,level:2: x:70,y:16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.5604882839878L, 10.8984375L), 2), geohex_coordinate(54L, 49L), "lat:78.5604882839878,lng:10.8984375,level:2: x:54,y:49");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.8451685402704L, 21.09375L), 2), geohex_coordinate(51L, 42L), "lat:75.8451685402704,lng:21.09375,level:2: x:51,y:42");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.5966908036953L, 33.3936512207031L), 2), geohex_coordinate(55L, 40L), "lat:76.5966908036953,lng:33.3936512207031,level:2: x:55,y:40");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.6529774005528L, -80.859375L), 2), geohex_coordinate(17L, 53L), "lat:66.6529774005528,lng:-80.859375,level:2: x:17,y:53");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(47.9845674191572L, -108.286036279297L), 2), geohex_coordinate(-3L, 46L), "lat:47.9845674191572,lng:-108.286036279297,level:2: x:-3,y:46");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-25.4901725033649L, -1.05947377929692L), 2), geohex_coordinate(-10L, -10L), "lat:-25.4901725033649,lng:-1.05947377929692,level:2: x:-10,y:-10");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -82.96875L), 2), geohex_coordinate(-89L, -52L), "lat:-85.0511287798066,lng:-82.96875,level:2: x:-89,y:-52");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 128.3203125L), 3), geohex_coordinate(-124L, -297L), "lat:-85.0511287798066,lng:128.3203125,level:3: x:-124,y:-297");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0624888102515L, 179.3408203125L), 3), geohex_coordinate(-90L, -332L), "lat:-85.0624888102515,lng:179.3408203125,level:3: x:-90,y:-332");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0378424552699L, 179.23095703125L), 3), geohex_coordinate(-89L, -331L), "lat:-85.0378424552699,lng:179.23095703125,level:3: x:-89,y:-331");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.965795444271L, -177.280176904297L), 3), geohex_coordinate(-329L, -90L), "lat:-84.965795444271,lng:-177.280176904297,level:3: x:-329,y:-90");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9593049562383L, -70.83984375L), 3), geohex_coordinate(-257L, -161L), "lat:-84.9593049562383,lng:-70.83984375,level:3: x:-257,y:-161");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0662697036382L, -82.177734375L), 3), geohex_coordinate(-266L, -155L), "lat:-85.0662697036382,lng:-82.177734375,level:3: x:-266,y:-155");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.4905516616031L, -12.12890625L), 3), geohex_coordinate(-162L, -146L), "lat:-78.4905516616031,lng:-12.12890625,level:3: x:-162,y:-146");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.5577429389655L, 175.4296875L), 3), geohex_coordinate(-25L, -262L), "lat:-76.5577429389655,lng:175.4296875,level:3: x:-25,y:-262");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-75.5376233349686L, -175.412501123047L), 3), geohex_coordinate(-257L, -20L), "lat:-75.5376233349686,lng:-175.412501123047,level:3: x:-257,y:-20");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-49.3823727870095L, 64.6875L), 3), geohex_coordinate(-23L, -110L), "lat:-49.3823727870095,lng:64.6875,level:3: x:-23,y:-110");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-0.703107352436478L, 0.703125L), 3), geohex_coordinate(0L, -1L), "lat:-0.703107352436478,lng:0.703125,level:3: x:0,y:-1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-10.4878118820567L, 0L), 3), geohex_coordinate(-12L, -12L), "lat:-10.4878118820567,lng:0,level:3: x:-12,y:-12");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.5172006978394L, -109.6875L), 3), geohex_coordinate(-137L, 11L), "lat:-47.5172006978394,lng:-109.6875,level:3: x:-137,y:11");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-15.2841851140764L, -166.640625L), 3), geohex_coordinate(-131L, 94L), "lat:-15.2841851140764,lng:-166.640625,level:3: x:-131,y:94");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-12.1975231443078L, 179.665623876953L), 3), geohex_coordinate(-136L, 107L), "lat:-12.1975231443078,lng:179.665623876953,level:3: x:-136,y:107");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-11.5093959703978L, -172.600001123047L), 3), geohex_coordinate(-130L, 103L), "lat:-11.5093959703978,lng:-172.600001123047,level:3: x:-130,y:103");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(6.67848578014459L, -173.303126123047L), 3), geohex_coordinate(-109L, 125L), "lat:6.67848578014459,lng:-173.303126123047,level:3: x:-109,y:125");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.21494314139065L, 177.1875L), 3), geohex_coordinate(124L, -115L), "lat:4.21494314139065,lng:177.1875,level:3: x:124,y:-115");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(34.0278228898362L, 137.478123876953L), 3), geohex_coordinate(135L, -51L), "lat:34.0278228898362,lng:137.478123876953,level:3: x:135,y:-51");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.5937260639293L, 128.49609375L), 3), geohex_coordinate(114L, -60L), "lat:22.5937260639293,lng:128.49609375,level:3: x:114,y:-60");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(44.3395652480971L, 142.294921875L), 3), geohex_coordinate(154L, -38L), "lat:44.3395652480971,lng:142.294921875,level:3: x:154,y:-38");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.0444375846086L, 135.52734375L), 3), geohex_coordinate(143L, -40L), "lat:40.0444375846086,lng:135.52734375,level:3: x:143,y:-40");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(39.0959629363055L, 45.3515625L), 3), geohex_coordinate(80L, 19L), "lat:39.0959629363055,lng:45.3515625,level:3: x:80,y:19");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(46.0829232667361L, 33.239842626953L), 3), geohex_coordinate(83L, 38L), "lat:46.0829232667361,lng:33.239842626953,level:3: x:83,y:38");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(7.71099165543323L, 4.21875L), 3), geohex_coordinate(12L, 6L), "lat:7.71099165543323,lng:4.21875,level:3: x:12,y:6");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-3.51342104564003L, -7.734375L), 3), geohex_coordinate(-9L, 1L), "lat:-3.51342104564003,lng:-7.734375,level:3: x:-9,y:1");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.81137119333114L, -59.4140625L), 3), geohex_coordinate(-37L, 43L), "lat:2.81137119333114,lng:-59.4140625,level:3: x:-37,y:43");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(27.6959007090629L, -115.471094873047L), 3), geohex_coordinate(-44L, 112L), "lat:27.6959007090629,lng:-115.471094873047,level:3: x:-44,y:112");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(67.7427590666639L, -84.7265625L), 3), geohex_coordinate(52L, 166L), "lat:67.7427590666639,lng:-84.7265625,level:3: x:52,y:166");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(67.067433351083L, -74.1796875L), 3), geohex_coordinate(57L, 157L), "lat:67.067433351083,lng:-74.1796875,level:3: x:57,y:157");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.0787838962494L, 23.90625L), 3), geohex_coordinate(162L, 130L), "lat:77.0787838962494,lng:23.90625,level:3: x:162,y:130");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.5632592313568L, 18.122655126953L), 3), geohex_coordinate(166L, 142L), "lat:78.5632592313568,lng:18.122655126953,level:3: x:166,y:142");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.599030708362L, -33.046875L), 3), geohex_coordinate(171L, 216L), "lat:83.599030708362,lng:-33.046875,level:3: x:171,y:216");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.5597167645715L, -49.921875L), 3), geohex_coordinate(159L, 226L), "lat:83.5597167645715,lng:-49.921875,level:3: x:159,y:226");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0435409456565L, 89.2529296875L), 3), geohex_coordinate(271L, 150L), "lat:85.0435409456565,lng:89.2529296875,level:3: x:271,y:150");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.9785740239428L, 179.6484375L), 3), geohex_coordinate(88L, 331L), "lat:84.9785740239428,lng:179.6484375,level:3: x:88,y:331");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.5162211763226L, 175.2978515625L), 3), geohex_coordinate(322L, 85L), "lat:84.5162211763226,lng:175.2978515625,level:3: x:322,y:85");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.5552138939799L, -177.521876123047L), 3), geohex_coordinate(84L, 324L), "lat:84.5552138939799,lng:-177.521876123047,level:3: x:84,y:324");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.7010964160167L, -176.748046875L), 3), geohex_coordinate(75L, 314L), "lat:83.7010964160167,lng:-176.748046875,level:3: x:75,y:314");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.272558965094L, 173.5400390625L), 3), geohex_coordinate(307L, 73L), "lat:83.272558965094,lng:173.5400390625,level:3: x:307,y:73");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(70.6463998268061L, 97.707616064453L), 3), geohex_coordinate(184L, 52L), "lat:70.6463998268061,lng:97.707616064453,level:3: x:184,y:52");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0587050266129L, -76.46484375L), 4), geohex_coordinate(-787L, -477L), "lat:-85.0587050266129,lng:-76.46484375,level:4: x:-787,y:-477");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0283304449441L, -75.9375L), 4), geohex_coordinate(-784L, -477L), "lat:-85.0283304449441,lng:-75.9375,level:4: x:-784,y:-477");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0435409456565L, 177.978515625L), 4), geohex_coordinate(-271L, -992L), "lat:-85.0435409456565,lng:177.978515625,level:4: x:-271,y:-992");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.8723924583849L, -177.477930810547L), 4), geohex_coordinate(-984L, -265L), "lat:-84.8723924583849,lng:-177.477930810547,level:4: x:-984,y:-265");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.595847144363L, -170.622462060547L), 4), geohex_coordinate(-792L, -101L), "lat:-77.595847144363,lng:-170.622462060547,level:4: x:-792,y:-101");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.3494106901463L, 171.5625L), 4), geohex_coordinate(-111L, -806L), "lat:-78.3494106901463,lng:171.5625,level:4: x:-111,y:-806");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.9899216674142L, 64.6875L), 4), geohex_coordinate(-61L, -323L), "lat:-47.9899216674142,lng:64.6875,level:4: x:-61,y:-323");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.9039293885709L, -16.875L), 4), geohex_coordinate(-503L, -435L), "lat:-78.9039293885709,lng:-16.875,level:4: x:-503,y:-435");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-55.3211950064193L, -104.528712060547L), 4), geohex_coordinate(-445L, -22L), "lat:-55.3211950064193,lng:-104.528712060547,level:4: x:-445,y:-22");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-45.089035564831L, -95.625L), 4), geohex_coordinate(-371L, 16L), "lat:-45.089035564831,lng:-95.625,level:4: x:-371,y:16");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-23.2413461023861L, -160.3125L), 4), geohex_coordinate(-408L, 241L), "lat:-23.2413461023861,lng:-160.3125,level:4: x:-408,y:241");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-11.1784018737118L, 170.15625L), 4), geohex_coordinate(305L, -384L), "lat:-11.1784018737118,lng:170.15625,level:4: x:305,y:-384");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-1.40610883543516L, -177.1875L), 4), geohex_coordinate(-364L, 354L), "lat:-1.40610883543516,lng:-177.1875,level:4: x:-364,y:354");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(17.9787330955562L, -172.96875L), 4), geohex_coordinate(-286L, 414L), "lat:17.9787330955562,lng:-172.96875,level:4: x:-286,y:414");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(11.1784018737118L, 174.375L), 4), geohex_coordinate(392L, -314L), "lat:11.1784018737118,lng:174.375,level:4: x:392,y:-314");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-50.7364551370106L, 63.28125L), 4), geohex_coordinate(-79L, -335L), "lat:-50.7364551370106,lng:63.28125,level:4: x:-79,y:-335");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-10.3876340301868L, 5.15878793945296L), 4), geohex_coordinate(-26L, -47L), "lat:-10.3876340301868,lng:5.15878793945296,level:4: x:-26,y:-47");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.61508745924257L, -0.466212060547036L), 4), geohex_coordinate(12L, 14L), "lat:3.61508745924257,lng:-0.466212060547036,level:4: x:12,y:14");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-0.00001L, -60.46875L), 4), geohex_coordinate(-123L, 122L), "lat:-0.00001,lng:-60.46875,level:4: x:-123,y:122");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.4606699514953L, 45L), 4), geohex_coordinate(224L, 42L), "lat:35.4606699514953,lng:45,level:4: x:224,y:42");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(70.6126142380192L, -82.96875L), 4), geohex_coordinate(187L, 523L), "lat:70.6126142380192,lng:-82.96875,level:4: x:187,y:523");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.0932138526084L, -177.1875L), 4), geohex_coordinate(154L, 872L), "lat:81.0932138526084,lng:-177.1875,level:4: x:154,y:872");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.5182718765338L, 171.5625L), 4), geohex_coordinate(870L, 175L), "lat:81.5182718765338,lng:171.5625,level:4: x:870,y:175");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.3595113303545L, 174.375L), 4), geohex_coordinate(925L, 219L), "lat:83.3595113303545,lng:174.375,level:4: x:925,y:219");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0587050266129L, -171.650390625L), 4), geohex_coordinate(284L, 979L), "lat:85.0587050266129,lng:-171.650390625,level:4: x:284,y:979");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.9403268016951L, -40.78125L), 4), geohex_coordinate(477L, 642L), "lat:82.9403268016951,lng:-40.78125,level:4: x:477,y:642");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.767582382728L, 20.390625L), 4), geohex_coordinate(490L, 407L), "lat:77.767582382728,lng:20.390625,level:4: x:490,y:407");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.0160936642099L, 117.421875L), 4), geohex_coordinate(660L, 184L), "lat:76.0160936642099,lng:117.421875,level:4: x:660,y:184");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.3890499669117L, 139.7021484375L), 4), geohex_coordinate(416L, -150L), "lat:35.3890499669117,lng:139.7021484375,level:4: x:416,y:-150");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.2795256688129L, 135L), 4), geohex_coordinate(428L, -119L), "lat:40.2795256688129,lng:135,level:4: x:428,y:-119");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.6122167681757L, 143.1298828125L), 4), geohex_coordinate(460L, -120L), "lat:43.6122167681757,lng:143.1298828125,level:4: x:460,y:-120");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(32.8057447329069L, 151.5673828125L), 4), geohex_coordinate(429L, -185L), "lat:32.8057447329069,lng:151.5673828125,level:4: x:429,y:-185");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.7153900193359L, 129.5947265625L), 4), geohex_coordinate(344L, -181L), "lat:22.7153900193359,lng:129.5947265625,level:4: x:344,y:-181");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0813644184664L, -79.453125L), 5), geohex_coordinate(-2380L, -1415L), "lat:-85.0813644184664,lng:-79.453125,level:5: x:-2380,y:-1415");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -78.92578125L), 5), geohex_coordinate(-2373L, -1414L), "lat:-85.0511287798066,lng:-78.92578125,level:5: x:-2373,y:-1414");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9283209294996L, -179.47265625L), 5), geohex_coordinate(-2970L, -789L), "lat:-84.9283209294996,lng:-179.47265625,level:5: x:-2970,y:-789");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9593049562383L, 178.2421875L), 5), geohex_coordinate(-800L, -2966L), "lat:-84.9593049562383,lng:178.2421875,level:5: x:-800,y:-2966");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.7335005077847L, -176.1328125L), 5), geohex_coordinate(-2466L, -326L), "lat:-78.7335005077847,lng:-176.1328125,level:5: x:-2466,y:-326");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.4629957529448L, 177.600194189453L), 5), geohex_coordinate(-253L, -2411L), "lat:-77.4629957529448,lng:177.600194189453,level:5: x:-253,y:-2411");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.2065631107471L, -15.46875L), 5), geohex_coordinate(-1463L, -1275L), "lat:-78.2065631107471,lng:-15.46875,level:5: x:-1463,y:-1275");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-54.5720616556585L, 64.3359375L), 5), geohex_coordinate(-297L, -1079L), "lat:-54.5720616556585,lng:64.3359375,level:5: x:-297,y:-1079");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-46.3165841818222L, -100.1953125L), 5), geohex_coordinate(-1160L, 57L), "lat:-46.3165841818222,lng:-100.1953125,level:5: x:-1160,y:57");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-17.6440220278727L, -160.6640625L), 5), geohex_coordinate(-1165L, 787L), "lat:-17.6440220278727,lng:-160.6640625,level:5: x:-1165,y:787");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-7.17423764065876L, -172.731837060547L), 5), geohex_coordinate(-1125L, 974L), "lat:-7.17423764065876,lng:-172.731837060547,level:5: x:-1125,y:974");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-6.47609984882554L, 178.479100439453L), 5), geohex_coordinate(1016L, -1153L), "lat:-6.47609984882554,lng:178.479100439453,level:5: x:1016,y:-1153");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.64974654877715L, 176.721287939453L), 5), geohex_coordinate(1101L, -1046L), "lat:2.64974654877715,lng:176.721287939453,level:5: x:1101,y:-1046");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(18.4928608912187L, -174.841212060547L), 5), geohex_coordinate(-864L, 1260L), "lat:18.4928608912187,lng:-174.841212060547,level:5: x:-864,y:1260");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.56547355071029L, 9.84375L), 5), geohex_coordinate(108L, -12L), "lat:4.56547355071029,lng:9.84375,level:5: x:108,y:-12");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-2.46018118102099L, -9.140625L), 5), geohex_coordinate(-81L, 30L), "lat:-2.46018118102099,lng:-9.140625,level:5: x:-81,y:30");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.51342104564004L, -60.46875L), 5), geohex_coordinate(-331L, 404L), "lat:3.51342104564004,lng:-60.46875,level:5: x:-331,y:404");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.9430455334382L, 127.96875L), 5), geohex_coordinate(1014L, -541L), "lat:21.9430455334382,lng:127.96875,level:5: x:1014,y:-541");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(24.4598690265572L, 133.918553564453L), 5), geohex_coordinate(1079L, -548L), "lat:24.4598690265572,lng:133.918553564453,level:5: x:1079,y:-548");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(37.6490340215787L, 145.810546875L), 5), geohex_coordinate(1314L, -458L), "lat:37.6490340215787,lng:145.810546875,level:5: x:1314,y:-458");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.0299963690257L, 138.33984375L), 5), geohex_coordinate(1234L, -447L), "lat:35.0299963690257,lng:138.33984375,level:5: x:1234,y:-447");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.5166885350291L, 141.416015625L), 5), geohex_coordinate(1369L, -349L), "lat:43.5166885350291,lng:141.416015625,level:5: x:1369,y:-349");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.0688877741696L, 43.59375L), 5), geohex_coordinate(768L, 238L), "lat:43.0688877741696,lng:43.59375,level:5: x:768,y:238");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.5132604431118L, -78.75L), 5), geohex_coordinate(468L, 1425L), "lat:66.5132604431118,lng:-78.75,level:5: x:468,y:1425");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(25.7333228756498L, -115.251368310547L), 5), geohex_coordinate(-420L, 980L), "lat:25.7333228756498,lng:-115.251368310547,level:5: x:-420,y:980");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.9999351181161L, 18.984375L), 5), geohex_coordinate(1425L, 1194L), "lat:76.9999351181161,lng:18.984375,level:5: x:1425,y:1194");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(74.9593916589497L, 118.828125L), 5), geohex_coordinate(1943L, 499L), "lat:74.9593916589497,lng:118.828125,level:5: x:1943,y:499");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.277705039617L, -38.671875L), 5), geohex_coordinate(1474L, 1944L), "lat:83.277705039617,lng:-38.671875,level:5: x:1474,y:1944");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.0213780195089L, 172.265625L), 5), geohex_coordinate(2652L, 559L), "lat:82.0213780195089,lng:172.265625,level:5: x:2652,y:559");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.0213780195089L, -174.375L), 5), geohex_coordinate(546L, 2665L), "lat:82.0213780195089,lng:-174.375,level:5: x:546,y:2665");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.3296816703432L, -173.610743310547L), 5), geohex_coordinate(757L, 2866L), "lat:84.3296816703432,lng:-173.610743310547,level:5: x:757,y:2866");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0435409456565L, 173.3203125L), 5), geohex_coordinate(2946L, 840L), "lat:85.0435409456565,lng:173.3203125,level:5: x:2946,y:840");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.035941506574L, -88.41796875L), 6), geohex_coordinate(-7288L, -4065L), "lat:-85.035941506574,lng:-88.41796875,level:6: x:-7288,y:-4065");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, 118.4765625L), 6), geohex_coordinate(-3512L, -7830L), "lat:-85.0207077431259,lng:118.4765625,level:6: x:-3512,y:-7830");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1114157806266L, 124.1015625L), 6), geohex_coordinate(-3442L, -7966L), "lat:-85.1114157806266,lng:124.1015625,level:6: x:-3442,y:-7966");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1412839811764L, 177.890625L), 6), geohex_coordinate(-2473L, -8957L), "lat:-85.1412839811764,lng:177.890625,level:6: x:-2473,y:-8957");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 178.2421875L), 6), geohex_coordinate(-2433L, -8930L), "lat:-85.0511287798066,lng:178.2421875,level:6: x:-2433,y:-8930");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0194948138159L, -177.126368310547L), 6), geohex_coordinate(-8898L, -2442L), "lat:-85.0194948138159,lng:-177.126368310547,level:6: x:-8898,y:-2442");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.1344931829381L, -16.5234375L), 6), geohex_coordinate(-4396L, -3794L), "lat:-78.1344931829381,lng:-16.5234375,level:6: x:-4396,y:-3794");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.8418477505252L, 176.1328125L), 6), geohex_coordinate(-841L, -7261L), "lat:-77.8418477505252,lng:176.1328125,level:6: x:-841,y:-7261");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.154056306248L, -173.610743310547L), 6), geohex_coordinate(-7114L, -786L), "lat:-77.154056306248,lng:-173.610743310547,level:6: x:-7114,y:-786");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-44.5904671813088L, 60.8203125L), 6), geohex_coordinate(-467L, -2684L), "lat:-44.5904671813088,lng:60.8203125,level:6: x:-467,y:-2684");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-21.6165793367406L, -166.9921875L), 6), geohex_coordinate(-3743L, 2344L), "lat:-21.6165793367406,lng:-166.9921875,level:6: x:-3743,y:2344");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-3.85031343257015L, 179.006444189453L), 6), geohex_coordinate(3141L, -3384L), "lat:-3.85031343257015,lng:179.006444189453,level:6: x:3141,y:-3384");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-4.91583280131316L, -176.484375L), 6), geohex_coordinate(-3372L, 3061L), "lat:-4.91583280131316,lng:-176.484375,level:6: x:-3372,y:3061");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(6.67848578032986L, -174.313868310547L), 6), geohex_coordinate(-2966L, 3388L), "lat:6.67848578032986,lng:-174.313868310547,level:6: x:-2966,y:3388");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(9.46284480235845L, 174.787694189453L), 6), geohex_coordinate(3486L, -2885L), "lat:9.46284480235845,lng:174.787694189453,level:6: x:3486,y:-2885");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-48.4583518828086L, -96.6796875L), 6), geohex_coordinate(-3515L, 9L), "lat:-48.4583518828086,lng:-96.6796875,level:6: x:-3515,y:9");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.56547355071029L, 2.4609375L), 6), geohex_coordinate(189L, 99L), "lat:4.56547355071029,lng:2.4609375,level:6: x:189,y:99");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.46018118102101L, -60.46875L), 6), geohex_coordinate(-1024L, 1180L), "lat:2.46018118102101,lng:-60.46875,level:6: x:-1024,y:1180");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(10.141931686131L, -180L), 6), geohex_coordinate(-2959L, 3602L), "lat:10.141931686131,lng:-180,level:6: x:-2959,y:3602");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(32.5468131735151L, 138.8671875L), 6), geohex_coordinate(3619L, -1443L), "lat:32.5468131735151,lng:138.8671875,level:6: x:3619,y:-1443");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.9430455334382L, 127.6171875L), 6), geohex_coordinate(3036L, -1616L), "lat:21.9430455334382,lng:127.6171875,level:6: x:3036,y:-1616");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.8345267822368L, 143.0859375L), 6), geohex_coordinate(4150L, -1065L), "lat:43.8345267822368,lng:143.0859375,level:6: x:4150,y:-1065");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(39.6395375643667L, 36.9140625L), 6), geohex_coordinate(2038L, 692L), "lat:39.6395375643667,lng:36.9140625,level:6: x:2038,y:692");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(65.8027763934024L, -78.3984375L), 6), geohex_coordinate(1357L, 4214L), "lat:65.8027763934024,lng:-78.3984375,level:6: x:1357,y:4214");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(39.7855076845378L, -104.660547998047L), 6), geohex_coordinate(-537L, 3278L), "lat:39.7855076845378,lng:-104.660547998047,level:6: x:-537,y:3278");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(24.3798410664542L, -114.504297998047L), 6), geohex_coordinate(-1293L, 2881L), "lat:24.3798410664542,lng:-114.504297998047,level:6: x:-1293,y:2881");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.4024234793885L, -40.078125L), 6), geohex_coordinate(4175L, 5636L), "lat:82.4024234793885,lng:-40.078125,level:6: x:4175,y:5636");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.9039293885709L, 18.28125L), 6), geohex_coordinate(4550L, 3884L), "lat:78.9039293885709,lng:18.28125,level:6: x:4550,y:3884");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.4971573189308L, 123.046875L), 6), geohex_coordinate(5971L, 1486L), "lat:75.4971573189308,lng:123.046875,level:6: x:5971,y:1486");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.0681264963294L, 179.401952001953L), 6), geohex_coordinate(7881L, 1342L), "lat:81.0681264963294,lng:179.401952001953,level:6: x:7881,y:1342");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.8332236662427L, -177.082422998047L), 6), geohex_coordinate(1784L, 8239L), "lat:82.8332236662427,lng:-177.082422998047,level:6: x:1784,y:8239");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.2509866562372L, -177.082422998047L), 6), geohex_coordinate(2183L, 8638L), "lat:84.2509866562372,lng:-177.082422998047,level:6: x:2183,y:8638");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0066436947991L, 175.007420751953L), 6), geohex_coordinate(8855L, 2476L), "lat:85.0066436947991,lng:175.007420751953,level:6: x:8855,y:2476");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0397426778322L, 88.41796875L), 6), geohex_coordinate(7289L, 4066L), "lat:85.0397426778322,lng:88.41796875,level:6: x:7289,y:4066");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0473363122482L, -79.6728515625L), 7), geohex_coordinate(-21398L, -12686L), "lat:-85.0473363122482,lng:-79.6728515625,level:7: x:-21398,y:-12686");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 128.0126953125L), 7), geohex_coordinate(-10047L, -24045L), "lat:-85.0511287798066,lng:128.0126953125,level:7: x:-10047,y:-24045");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, 177.220458984375L), 7), geohex_coordinate(-7358L, -26737L), "lat:-85.0520764439798,lng:177.220458984375,level:7: x:-7358,y:-26737");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 177.36328125L), 7), geohex_coordinate(-7348L, -26743L), "lat:-85.0511287798066,lng:177.36328125,level:7: x:-7348,y:-26743");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, -177.352294921875L), 7), geohex_coordinate(-26744L, -7350L), "lat:-85.0520764439798,lng:-177.352294921875,level:7: x:-26744,y:-7350");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0501809345811L, -177.396240234375L), 7), geohex_coordinate(-26744L, -7346L), "lat:-85.0501809345811,lng:-177.396240234375,level:7: x:-26744,y:-7346");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.2065631107471L, -179.47265625L), 7), geohex_coordinate(-22131L, -2506L), "lat:-78.2065631107471,lng:-179.47265625,level:7: x:-22131,y:-2506");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.3252431164896L, -179.818018701172L), 7), geohex_coordinate(-21340L, -1677L), "lat:-76.3252431164896,lng:-179.818018701172,level:7: x:-21340,y:-1677");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-75.6442438813013L, 174.556981298828L), 7), geohex_coordinate(-1698L, -20786L), "lat:-75.6442438813013,lng:174.556981298828,level:7: x:-1698,y:-20786");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.0619891866597L, -13.359375L), 7), geohex_coordinate(-12982L, -11521L), "lat:-78.0619891866597,lng:-13.359375,level:7: x:-12982,y:-11521");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-52.2681573737682L, 56.42578125L), 7), geohex_coordinate(-2741L, -8911L), "lat:-52.2681573737682,lng:56.42578125,level:7: x:-2741,y:-8911");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.3219061200486L, 68.0335437988283L), 7), geohex_coordinate(-1380L, -8819L), "lat:-47.3219061200486,lng:68.0335437988283,level:7: x:-1380,y:-8819");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-48.4583518828086L, -104.58984375L), 7), geohex_coordinate(-10979L, 458L), "lat:-48.4583518828086,lng:-104.58984375,level:7: x:-10979,y:458");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.8357775204525L, -99.140625L), 7), geohex_coordinate(-11180L, -339L), "lat:-51.8357775204525,lng:-99.140625,level:7: x:-11180,y:-339");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-21.4530686330868L, -162.24609375L), 7), geohex_coordinate(-10952L, 6790L), "lat:-21.4530686330868,lng:-162.24609375,level:7: x:-10952,y:6790");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-12.3829283384874L, -178.76953125L), 7), geohex_coordinate(-10956L, 8592L), "lat:-12.3829283384874,lng:-178.76953125,level:7: x:-10956,y:8592");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-4.10239049848663L, -177.532862451172L), 7), geohex_coordinate(-10095L, 9318L), "lat:-4.10239049848663,lng:-177.532862451172,level:7: x:-10095,y:9318");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.32747949211224L, -177.181299951172L), 7), geohex_coordinate(-9277L, 10098L), "lat:4.32747949211224,lng:-177.181299951172,level:7: x:-9277,y:10098");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(14.7140233449093L, -179.993799951172L), 7), geohex_coordinate(-8432L, 11250L), "lat:14.7140233449093,lng:-179.993799951172,level:7: x:-8432,y:11250");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(19.1687452003202L, 174.425145361328L), 7), geohex_coordinate(11387L, -7686L), "lat:19.1687452003202,lng:174.425145361328,level:7: x:11387,y:-7686");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(5.2660078828055L, -60.8203125L), 7), geohex_coordinate(-2826L, 3825L), "lat:5.2660078828055,lng:-60.8203125,level:7: x:-2826,y:3825");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(6.16537016364512L, 0.577489111328305L), 7), geohex_coordinate(616L, 553L), "lat:6.16537016364512,lng:0.577489111328305,level:7: x:616,y:553");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-2.10889865924313L, 4.21875L), 7), geohex_coordinate(31L, -430L), "lat:-2.10889865924313,lng:4.21875,level:7: x:31,y:-430");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(45.3367019099681L, 39.7265625L), 7), geohex_coordinate(6999L, 2655L), "lat:45.3367019099681,lng:39.7265625,level:7: x:6999,y:2655");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(39.9097362345372L, 36.2109375L), 7), geohex_coordinate(6108L, 2148L), "lat:39.9097362345372,lng:36.2109375,level:7: x:6108,y:2148");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.4313401563606L, 128.408203125L), 7), geohex_coordinate(9201L, -4840L), "lat:22.4313401563606,lng:128.408203125,level:7: x:9201,y:-4840");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.8178131586966L, 137.900390625L), 7), geohex_coordinate(11177L, -3902L), "lat:35.8178131586966,lng:137.900390625,level:7: x:11177,y:-3902");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.2124407182865L, 135.7470703125L), 7), geohex_coordinate(11588L, -3256L), "lat:40.2124407182865,lng:135.7470703125,level:7: x:11588,y:-3256");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(38.2036553180715L, 145.6787109375L), 7), geohex_coordinate(11885L, -4045L), "lat:38.2036553180715,lng:145.6787109375,level:7: x:11885,y:-4045");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.8662180065564L, 142.119140625L), 7), geohex_coordinate(12402L, -3139L), "lat:43.8662180065564,lng:142.119140625,level:7: x:12402,y:-3139");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(30.8482114570361L, 156.143895361328L), 7), geohex_coordinate(11611L, -5463L), "lat:30.8482114570361,lng:156.143895361328,level:7: x:11611,y:-5463");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.4530686330868L, 178.857421875L), 7), geohex_coordinate(11860L, -7698L), "lat:21.4530686330868,lng:178.857421875,level:7: x:11860,y:-7698");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.0329743324414L, 35.15625L), 7), geohex_coordinate(6317L, 2473L), "lat:42.0329743324414,lng:35.15625,level:7: x:6317,y:2473");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(30.9236383940856L, -116.492823388672L), 7), geohex_coordinate(-3287L, 9451L), "lat:30.9236383940856,lng:-116.492823388672,level:7: x:-3287,y:9451");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(41.1312708370144L, -95.3990733886717L), 7), geohex_coordinate(-935L, 9497L), "lat:41.1312708370144,lng:-95.3990733886717,level:7: x:-935,y:9497");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.4088542284645L, 118.125L), 7), geohex_coordinate(17612L, 4695L), "lat:75.4088542284645,lng:118.125,level:7: x:17612,y:4695");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.791909473418L, -77.34375L), 7), geohex_coordinate(4361L, 12818L), "lat:66.791909473418,lng:-77.34375,level:7: x:4361,y:12818");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(69.726756757278L, -86.6100108886717L), 7), geohex_coordinate(4606L, 14077L), "lat:69.726756757278,lng:-86.6100108886717,level:7: x:4606,y:14077");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.0160936642099L, 23.90625L), 7), geohex_coordinate(12693L, 10079L), "lat:76.0160936642099,lng:23.90625,level:7: x:12693,y:10079");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.6695124342049L, 17.8040516113283L), 7), geohex_coordinate(13511L, 11564L), "lat:78.6695124342049,lng:17.8040516113283,level:7: x:13511,y:11564");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.1948956366159L, -41.484375L), 7), geohex_coordinate(13047L, 17583L), "lat:83.1948956366159,lng:-41.484375,level:7: x:13047,y:17583");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.181236162653L, -48.9928233886717L), 7), geohex_coordinate(13488L, 18845L), "lat:84.181236162653,lng:-48.9928233886717,level:7: x:13488,y:18845");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.8736412548283L, 171.9140625L), 7), geohex_coordinate(23749L, 4950L), "lat:81.8736412548283,lng:171.9140625,level:7: x:23749,y:4950");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.8736412548283L, -172.6171875L), 7), geohex_coordinate(4911L, 23787L), "lat:81.8736412548283,lng:-172.6171875,level:7: x:4911,y:23787");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.4059410412698L, -171.2109375L), 7), geohex_coordinate(7019L, 25741L), "lat:84.4059410412698,lng:-171.2109375,level:7: x:7019,y:25741");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.9593049562383L, -170.5078125L), 7), geohex_coordinate(7624L, 26269L), "lat:84.9593049562383,lng:-170.5078125,level:7: x:7624,y:26269");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0075998559899L, 171.788426611328L), 7), geohex_coordinate(26391L, 7606L), "lat:85.0075998559899,lng:171.788426611328,level:7: x:26391,y:7606");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0508918354752L, 89.4149780273438L), 7), geohex_coordinate(21935L, 12157L), "lat:85.0508918354752,lng:89.4149780273438,level:7: x:21935,y:12157");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -86.484375L), 8), geohex_coordinate(-65323L, -36952L), "lat:-85.0511287798066,lng:-86.484375,level:8: x:-65323,y:-36952");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.8943460271761L, -74.9662196899412L), 8), geohex_coordinate(-62926L, -38333L), "lat:-84.8943460271761,lng:-74.9662196899412,level:8: x:-62926,y:-38333");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9593049562383L, 116.015625L), 8), geohex_coordinate(-31809L, -69868L), "lat:-84.9593049562383,lng:116.015625,level:8: x:-31809,y:-69868");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 125.859375L), 8), geohex_coordinate(-30494L, -71782L), "lat:-85.0511287798066,lng:125.859375,level:8: x:-30494,y:-71782");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0473363122482L, 179.384765625L), 8), geohex_coordinate(-21702L, -80549L), "lat:-85.0473363122482,lng:179.384765625,level:8: x:-21702,y:-80549");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0446176171078L, -178.940829064941L), 8), geohex_coordinate(-80467L, -21766L), "lat:-85.0446176171078,lng:-178.940829064941,level:8: x:-80467,y:-21766");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.0255736328409L, 178.41796875L), 8), geohex_coordinate(-7440L, -65970L), "lat:-78.0255736328409,lng:178.41796875,level:8: x:-7440,y:-65970");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.7835046518998L, -179.380282189941L), 8), geohex_coordinate(-64509L, -5663L), "lat:-76.7835046518998,lng:-179.380282189941,level:8: x:-64509,y:-5663");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.2782014554281L, -12.3046875L), 8), geohex_coordinate(-39073L, -35037L), "lat:-78.2782014554281,lng:-12.3046875,level:8: x:-39073,y:-35037");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-50.7364551370106L, -94.921875L), 8), geohex_coordinate(-32349L, -1210L), "lat:-50.7364551370106,lng:-94.921875,level:8: x:-32349,y:-1210");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-48.0570407777163L, 58.9790928100588L), 8), geohex_coordinate(-5936L, -25284L), "lat:-48.0570407777163,lng:58.9790928100588,level:8: x:-5936,y:-25284");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-16.0577905631594L, -177.974032189941L), 8), geohex_coordinate(-33815L, 24569L), "lat:-16.0577905631594,lng:-177.974032189941,level:8: x:-33815,y:24569");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.50643064977766L, -175.864657189941L), 8), geohex_coordinate(-31272L, 26421L), "lat:-8.50643064977766,lng:-175.864657189941,level:8: x:-31272,y:26421");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-21.2893743558604L, -162.421875L), 8), geohex_coordinate(-32834L, 20449L), "lat:-21.2893743558604,lng:-162.421875,level:8: x:-32834,y:20449");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-5.01580975357458L, 6.94784281005877L), 8), geohex_coordinate(-287L, -2566L), "lat:-5.01580975357458,lng:6.94784281005877,level:8: x:-287,y:-2566");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.81137119333114L, -59.0625L), 8), geohex_coordinate(-8889L, 10487L), "lat:2.81137119333114,lng:-59.0625,level:8: x:-8889,y:10487");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(11.1784018737118L, 175.078125L), 8), geohex_coordinate(31913L, -25521L), "lat:11.1784018737118,lng:175.078125,level:8: x:31913,y:-25521");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(12.2848909400907L, -179.204500939941L), 8), geohex_coordinate(-25877L, 32911L), "lat:12.2848909400907,lng:-179.204500939941,level:8: x:-25877,y:32911");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(29.2288900301942L, 140.9765625L), 8), geohex_coordinate(31813L, -14434L), "lat:29.2288900301942,lng:140.9765625,level:8: x:31813,y:-14434");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.2354400884114L, 138.432217810059L), 8), geohex_coordinate(33415L, -11998L), "lat:35.2354400884114,lng:138.432217810059,level:8: x:33415,y:-11998");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.4530686330868L, 129.7265625L), 8), geohex_coordinate(27521L, -15036L), "lat:21.4530686330868,lng:129.7265625,level:8: x:27521,y:-15036");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(31.1175301983385L, 153.373624060059L), 8), geohex_coordinate(34467L, -15847L), "lat:31.1175301983385,lng:153.373624060059,level:8: x:34467,y:-15847");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.5805846641276L, 134.296875L), 8), geohex_coordinate(34663L, -9393L), "lat:40.5805846641276,lng:134.296875,level:8: x:34663,y:-9393");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.5076500047502L, 141.772061560059L), 8), geohex_coordinate(37009L, -9499L), "lat:43.5076500047502,lng:141.772061560059,level:8: x:37009,y:-9499");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(41.3768085657023L, 47.109375L), 8), geohex_coordinate(20661L, 5207L), "lat:41.3768085657023,lng:47.109375,level:8: x:20661,y:5207");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(46.0035675375752L, 36.1275303100588L), 8), geohex_coordinate(20680L, 8828L), "lat:46.0035675375752,lng:36.1275303100588,level:8: x:20680,y:8828");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-39.8518545936532L, -129.634188439941L), 8), geohex_coordinate(-33627L, 8900L), "lat:-39.8518545936532,lng:-129.634188439941,level:8: x:-33627,y:8900");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(0.703107352436491L, -58.359375L), 8), geohex_coordinate(-9373L, 9772L), "lat:0.703107352436491,lng:-58.359375,level:8: x:-9373,y:9772");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(36.0923061169101L, -111.352938439941L), 8), geohex_coordinate(-7256L, 29273L), "lat:36.0923061169101,lng:-111.352938439941,level:8: x:-7256,y:29273");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.8216153828775L, -93.7748134399412L), 8), geohex_coordinate(10409L, 41172L), "lat:66.8216153828775,lng:-93.7748134399412,level:8: x:10409,y:41172");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.6177090527968L, 24.609375L), 8), geohex_coordinate(40193L, 32120L), "lat:77.6177090527968,lng:24.609375,level:8: x:40193,y:32120");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(74.9593916589497L, 129.375L), 8), geohex_coordinate(54181L, 11739L), "lat:74.9593916589497,lng:129.375,level:8: x:54181,y:11739");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.4403264952731L, -52.03125L), 8), geohex_coordinate(38009L, 55078L), "lat:83.4403264952731,lng:-52.03125,level:8: x:38009,y:55078");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(80.7606147075245L, 177.890625L), 8), geohex_coordinate(70129L, 11772L), "lat:80.7606147075245,lng:177.890625,level:8: x:70129,y:11772");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.5046692199114L, -178.852938439941L), 8), geohex_coordinate(15031L, 73704L), "lat:82.5046692199114,lng:-178.852938439941,level:8: x:15031,y:73704");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.8380470615988L, -176.040438439941L), 8), geohex_coordinate(18689L, 76439L), "lat:83.8380470615988,lng:-176.040438439941,level:8: x:18689,y:76439");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.6149239022333L, 172.006436560059L), 8), geohex_coordinate(77975L, 21548L), "lat:84.6149239022333,lng:172.006436560059,level:8: x:77975,y:21548");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0492329082692L, 88.857421875L), 8), geohex_coordinate(65707L, 36557L), "lat:85.0492329082692,lng:88.857421875,level:8: x:65707,y:36557");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, -80.5078125L), 9), geohex_coordinate(-192730L, -113498L), "lat:-85.0207077431259,lng:-80.5078125,level:9: x:-192730,y:-113498");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.2589472349756L, 126.5625L), 9), geohex_coordinate(-93233L, -217789L), "lat:-85.2589472349756,lng:126.5625,level:9: x:-93233,y:-217789");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9901001802348L, 124.453125L), 9), geohex_coordinate(-91574L, -214055L), "lat:-84.9901001802348,lng:124.453125,level:9: x:-91574,y:-214055");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9631646609104L, 176.7919921875L), 9), geohex_coordinate(-65557L, -239547L), "lat:-84.9631646609104,lng:176.7919921875,level:9: x:-65557,y:-239547");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0506548798275L, 178.511352539062L), 9), geohex_coordinate(-65568L, -241250L), "lat:-85.0506548798275,lng:178.511352539062,level:9: x:-65568,y:-241250");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0506548798275L, -177.2314453125L), 9), geohex_coordinate(-240620L, -66198L), "lat:-85.0506548798275,lng:-177.2314453125,level:9: x:-240620,y:-66198");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.3494106901463L, -12.65625L), 9), geohex_coordinate(-117693L, -105237L), "lat:-78.3494106901463,lng:-12.65625,level:9: x:-117693,y:-105237");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.9156689863258L, 178.59375L), 9), geohex_coordinate(-21785L, -197548L), "lat:-77.9156689863258,lng:178.59375,level:9: x:-21785,y:-197548");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.0619891866597L, -175.78125L), 9), geohex_coordinate(-196764L, -23769L), "lat:-78.0619891866597,lng:-175.78125,level:9: x:-196764,y:-23769");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-48.9224992637582L, 61.875L), 9), geohex_coordinate(-17495L, -78389L), "lat:-48.9224992637582,lng:61.875,level:9: x:-17495,y:-78389");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.9899216674142L, -99.84375L), 9), geohex_coordinate(-95874L, 2387L), "lat:-47.9899216674142,lng:-99.84375,level:9: x:-95874,y:2387");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-25.7998911820883L, -165.9375L), 9), geohex_coordinate(-104426L, 58881L), "lat:-25.7998911820883,lng:-165.9375,level:9: x:-104426,y:58881");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-9.79713273881522L, -170.646151330566L), 9), geohex_coordinate(-92362L, 75580L), "lat:-9.79713273881522,lng:-170.646151330566,level:9: x:-92362,y:75580");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-6.31676626334665L, 176.697598669434L), 9), geohex_coordinate(81554L, -92343L), "lat:-6.31676626334665,lng:176.697598669434,level:9: x:81554,y:-92343");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.40716816360107L, -0.703125L), 9), geohex_coordinate(-7537L, -6845L), "lat:-8.40716816360107,lng:-0.703125,level:9: x:-7537,y:-6845");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.80989628150481L, -4.00552633056623L), 9), geohex_coordinate(425L, 4367L), "lat:2.80989628150481,lng:-4.00552633056623,level:9: x:425,y:4367");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(9.10063864198236L, -61.6617763305662L), 9), geohex_coordinate(-22553L, 38131L), "lat:9.10063864198236,lng:-61.6617763305662,level:9: x:-22553,y:38131");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(6.31529853833003L, 177.890625L), 9), geohex_coordinate(92929L, -82142L), "lat:6.31529853833003,lng:177.890625,level:9: x:92929,y:-82142");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(17.9773285067521L, -179.435213830566L), 9), geohex_coordinate(-72716L, 103875L), "lat:17.9773285067521,lng:-179.435213830566,level:9: x:-72716,y:103875");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.9798980696201L, 45.3515625L), 9), geohex_coordinate(60670L, 16037L), "lat:40.9798980696201,lng:45.3515625,level:9: x:60670,y:16037");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(36.5978891330702L, 36.2109375L), 9), geohex_coordinate(51378L, 15741L), "lat:36.5978891330702,lng:36.2109375,level:9: x:51378,y:15741");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(20.960060644697L, 127.830411169434L), 9), geohex_coordinate(81179L, -44625L), "lat:20.960060644697,lng:127.830411169434,level:9: x:81179,y:-44625");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(30.447400642478L, 151.736661169434L), 9), geohex_coordinate(101932L, -47400L), "lat:30.447400642478,lng:151.736661169434,level:9: x:101932,y:-47400");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(34.8847196158007L, 138.377286169434L), 9), geohex_coordinate(99852L, -36332L), "lat:34.8847196158007,lng:138.377286169434,level:9: x:99852,y:-36332");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.3241034221846L, 142.596036169434L), 9), geohex_coordinate(111217L, -29119L), "lat:43.3241034221846,lng:142.596036169434,level:9: x:111217,y:-29119");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.6121630749919L, -115.099276330566L), 9), geohex_coordinate(-31170L, 82105L), "lat:28.6121630749919,lng:-115.099276330566,level:9: x:-31170,y:82105");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(46.3155642634689L, -108.771151330566L), 9), geohex_coordinate(-8879L, 98168L), "lat:46.3155642634689,lng:-108.771151330566,level:9: x:-8879,y:98168");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.5132604431118L, -76.2890625L), 9), geohex_coordinate(39167L, 114247L), "lat:66.5132604431118,lng:-76.2890625,level:9: x:39167,y:114247");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(70.844188082313L, 98.2991611694338L), 9), geohex_coordinate(135264L, 38523L), "lat:70.844188082313,lng:98.2991611694338,level:9: x:135264,y:38523");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.4967875101885L, 121.502286169434L), 9), geohex_coordinate(160465L, 40888L), "lat:75.4967875101885,lng:121.502286169434,level:9: x:160465,y:40888");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.5420959607555L, 16.875L), 9), geohex_coordinate(116473L, 99865L), "lat:77.5420959607555,lng:16.875,level:9: x:116473,y:99865");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.4902570149857L, 27.2835361694338L), 9), geohex_coordinate(125488L, 98637L), "lat:78.4902570149857,lng:27.2835361694338,level:9: x:125488,y:98637");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.5182718765338L, 173.3203125L), 9), geohex_coordinate(212332L, 41759L), "lat:81.5182718765338,lng:173.3203125,level:9: x:212332,y:41759");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.8297867078656L, -175.919588830566L), 9), geohex_coordinate(56060L, 229191L), "lat:83.8297867078656,lng:-175.919588830566,level:9: x:56060,y:229191");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.4057970922956L, 176.346036169434L), 9), geohex_coordinate(234195L, 60644L), "lat:84.4057970922956,lng:176.346036169434,level:9: x:234195,y:60644");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.8970156075168L, 87.4007236694338L), 9), geohex_coordinate(194922L, 108907L), "lat:84.8970156075168,lng:87.4007236694338,level:9: x:194922,y:108907");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0497069440631L, 176.890869140625L), 9), geohex_coordinate(240443L, 66356L), "lat:85.0497069440631,lng:176.890869140625,level:9: x:240443,y:66356");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(65.9464717761574L, -84.375L), 10), geohex_coordinate(101969L, 351082L), "lat:65.9464717761574,lng:-84.375,level:10: x:101969,y:351082");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -87.022705078125L), 10), geohex_coordinate(-588706L, -331776L), "lat:-85.0511287798066,lng:-87.022705078125,level:10: x:-588706,y:-331776");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0501809345811L, -74.02587890625L), 10), geohex_coordinate(-569492L, -350934L), "lat:-85.0501809345811,lng:-74.02587890625,level:10: x:-569492,y:-350934");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1412839811764L, 110.7421875L), 10), geohex_coordinate(-299458L, -626419L), "lat:-85.1412839811764,lng:110.7421875,level:10: x:-299458,y:-626419");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1114157806266L, 123.3984375L), 10), geohex_coordinate(-279875L, -644203L), "lat:-85.1114157806266,lng:123.3984375,level:10: x:-279875,y:-644203");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0813644184664L, 124.1015625L), 10), geohex_coordinate(-277938L, -644342L), "lat:-85.0813644184664,lng:124.1015625,level:10: x:-277938,y:-644342");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 116.71875L), 10), geohex_coordinate(-287938L, -632544L), "lat:-85.0511287798066,lng:116.71875,level:10: x:-287938,y:-632544");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1114157806266L, 176.484375L), 10), geohex_coordinate(-201509L, -722570L), "lat:-85.1114157806266,lng:176.484375,level:10: x:-201509,y:-722570");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 178.9453125L), 10), geohex_coordinate(-196078L, -724405L), "lat:-85.0511287798066,lng:178.9453125,level:10: x:-196078,y:-724405");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -177.890625L), 10), geohex_coordinate(-722848L, -197635L), "lat:-85.0511287798066,lng:-177.890625,level:10: x:-722848,y:-197635");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.2065631107471L, 179.6484375L), 10), geohex_coordinate(-67395L, -597798L), "lat:-78.2065631107471,lng:179.6484375,level:10: x:-67395,y:-597798");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.9519883560986L, 178.878384802246L), 10), geohex_coordinate(-53605L, -581735L), "lat:-76.9519883560986,lng:178.878384802246,level:10: x:-53605,y:-581735");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.6712633375603L, -173.738802697754L), 10), geohex_coordinate(-571001L, -58046L), "lat:-76.6712633375603,lng:-173.738802697754,level:10: x:-571001,y:-58046");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-51.1793429792893L, 56.6015625L), 10), geohex_coordinate(-69258L, -236371L), "lat:-51.1793429792893,lng:56.6015625,level:10: x:-69258,y:-236371");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.420193275912L, -14.765625L), 10), geohex_coordinate(-357091L, -313496L), "lat:-78.420193275912,lng:-14.765625,level:10: x:-357091,y:-313496");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-50.9584267233599L, -97.03125L), 10), geohex_coordinate(-295156L, -8676L), "lat:-50.9584267233599,lng:-97.03125,level:10: x:-295156,y:-8676");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-15.9613290815966L, -166.9921875L), 10), geohex_coordinate(-287868L, 205168L), "lat:-15.9613290815966,lng:-166.9921875,level:10: x:-287868,y:205168");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-14.5690635426975L, 176.241666052246L), 10), geohex_coordinate(222513L, -297832L), "lat:-14.5690635426975,lng:176.241666052246,level:10: x:222513,y:-297832");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.05922962720018L, -177.1875L), 10), geohex_coordinate(-282243L, 240894L), "lat:-8.05922962720018,lng:-177.1875,level:10: x:-282243,y:240894");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(10.4878118820567L, -174.375L), 10), geohex_coordinate(-230449L, 284384L), "lat:10.4878118820567,lng:-174.375,level:10: x:-230449,y:284384");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(17.9787330955562L, 176.484375L), 10), geohex_coordinate(307274L, -213787L), "lat:17.9787330955562,lng:176.484375,level:10: x:307274,y:-213787");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.86425461572141L, -61.171875L), 10), geohex_coordinate(-80416L, 100191L), "lat:3.86425461572141,lng:-61.171875,level:10: x:-80416,y:100191");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(0L, -4.21875L), 10), geohex_coordinate(-6228L, 6228L), "lat:0,lng:-4.21875,level:10: x:-6228,y:6228");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(2.84830156370805L, 8.19479105224627L), 10), geohex_coordinate(19383L, -4812L), "lat:2.84830156370805,lng:8.19479105224627,level:10: x:19383,y:-4812");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-3.8642546157214L, 6.6796875L), 10), geohex_coordinate(-27L, -19749L), "lat:-3.8642546157214,lng:6.6796875,level:10: x:-27,y:-19749");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(17.30868788677L, 178.9453125L), 10), geohex_coordinate(309109L, -219218L), "lat:17.30868788677,lng:178.9453125,level:10: x:309109,y:-219218");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(20.7495962435651L, -179.583529260254L), 10), geohex_coordinate(-210852L, 319359L), "lat:20.7495962435651,lng:-179.583529260254,level:10: x:-210852,y:319359");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.7799053425296L, 129.375L), 10), geohex_coordinate(248067L, -133906L), "lat:21.7799053425296,lng:129.375,level:10: x:248067,y:-133906");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(27.32654326053L, 139.107876989746L), 10), geohex_coordinate(278036L, -132673L), "lat:27.32654326053,lng:139.107876989746,level:10: x:278036,y:-132673");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(34.6997633697495L, 141.568814489746L), 10), geohex_coordinate(303692L, -114283L), "lat:34.6997633697495,lng:141.568814489746,level:10: x:303692,y:-114283");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.2881270664159L, 142.975064489746L), 10), geohex_coordinate(334084L, -88043L), "lat:43.2881270664159,lng:142.975064489746,level:10: x:334084,y:-88043");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(30.8585272380353L, 152.643033239746L), 10), geohex_coordinate(308354L, -142317L), "lat:30.8585272380353,lng:152.643033239746,level:10: x:308354,y:-142317");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(40.178873314347L, 31.2890625L), 10), geohex_coordinate(158553L, 66174L), "lat:40.178873314347,lng:31.2890625,level:10: x:158553,y:66174");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(45.9157385222754L, 43.4828769897463L), 10), geohex_coordinate(196649L, 68268L), "lat:45.9157385222754,lng:43.4828769897463,level:10: x:196649,y:68268");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(27.8390760947778L, -115.83984375L), 10), geohex_coordinate(-96846L, 245166L), "lat:27.8390760947778,lng:-115.83984375,level:10: x:-96846,y:245166");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(47.9899216674142L, -108.28125L), 10), geohex_coordinate(-19618L, 300077L), "lat:47.9899216674142,lng:-108.28125,level:10: x:-19618,y:300077");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(67.7427590666639L, -72.7734375L), 10), geohex_coordinate(130781L, 345641L), "lat:67.7427590666639,lng:-72.7734375,level:10: x:130781,y:345641");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(71.3007929163745L, -85.95703125L), 10), geohex_coordinate(137387L, 391171L), "lat:71.3007929163745,lng:-85.95703125,level:10: x:137387,y:391171");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.6392256096589L, 17.40234375L), 10), geohex_coordinate(339859L, 288479L), "lat:76.6392256096589,lng:17.40234375,level:10: x:339859,y:288479");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.4803881585882L, 21.1586582397463L), 10), geohex_coordinate(367297L, 304827L), "lat:78.4803881585882,lng:21.1586582397463,level:10: x:367297,y:304827");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.4088542284645L, 127.6171875L), 10), geohex_coordinate(489526L, 112743L), "lat:75.4088542284645,lng:127.6171875,level:10: x:489526,y:112743");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(80.1399691499017L, 178.482876989746L), 10), geohex_coordinate(622465L, 95503L), "lat:80.1399691499017,lng:178.482876989746,level:10: x:622465,y:95503");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.4189147631075L, -179.407748010254L), 10), geohex_coordinate(132791L, 662483L), "lat:82.4189147631075,lng:-179.407748010254,level:10: x:132791,y:662483");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.3837991765363L, -179.407748010254L), 10), geohex_coordinate(176837L, 706530L), "lat:84.3837991765363,lng:-179.407748010254,level:10: x:176837,y:706530");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0511287798066L, 89.0647888183594L), 10), geohex_coordinate(591721L, 328762L), "lat:85.0511287798066,lng:89.0647888183594,level:10: x:591721,y:328762");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, -85.4296875L), 11), geohex_coordinate(-1756368L, -999687L), "lat:-85.0207077431259,lng:-85.4296875,level:11: x:-1756368,y:-999687");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, 114.2578125L), 11), geohex_coordinate(-872017L, -1884038L), "lat:-85.0207077431259,lng:114.2578125,level:11: x:-872017,y:-1884038");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, 177.890625L), 11), geohex_coordinate(-590208L, -2165847L), "lat:-85.0207077431259,lng:177.890625,level:11: x:-590208,y:-2165847");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0813644184664L, -178.9453125L), 11), geohex_coordinate(-2175911L, -590930L), "lat:-85.0813644184664,lng:-178.9453125,level:11: x:-2175911,y:-590930");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0813644184664L, -178.9453125L), 11), geohex_coordinate(-2175911L, -590930L), "lat:-85.0813644184664,lng:-178.9453125,level:11: x:-2175911,y:-590930");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -179.296875L), 11), geohex_coordinate(-2174772L, -586677L), "lat:-85.0511287798066,lng:-179.296875,level:11: x:-2174772,y:-586677");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.2065631107471L, -13.0078125L), 11), geohex_coordinate(-1055396L, -940181L), "lat:-78.2065631107471,lng:-13.0078125,level:11: x:-1055396,y:-940181");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.6928703364193L, 174.0234375L), 11), geohex_coordinate(-208219L, -1749605L), "lat:-77.6928703364193,lng:174.0234375,level:11: x:-208219,y:-1749605");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.2820430745299L, -177.189883020019L), 11), geohex_coordinate(-1749082L, -179649L), "lat:-77.2820430745299,lng:-177.189883020019,level:11: x:-1749082,y:-179649");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-53.330872983017L, -102.65625L), 11), geohex_coordinate(-940042L, -30780L), "lat:-53.330872983017,lng:-102.65625,level:11: x:-940042,y:-30780");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.75409797968L, 62.578125L), 11), geohex_coordinate(-140855L, -695131L), "lat:-47.75409797968,lng:62.578125,level:11: x:-140855,y:-695131");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-20.3034175184893L, -168.046875L), 11), geohex_coordinate(-903332L, 585118L), "lat:-20.3034175184893,lng:-168.046875,level:11: x:-903332,y:585118");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-10.3514984896236L, -177.893008020019L), 11), geohex_coordinate(-867669L, 707992L), "lat:-10.3514984896236,lng:-177.893008020019,level:11: x:-867669,y:707992");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-3.3750724311904L, -177.893008020019L), 11), geohex_coordinate(-813735L, 761926L), "lat:-3.3750724311904,lng:-177.893008020019,level:11: x:-813735,y:761926");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.00252710335009L, -177.893008020019L), 11), geohex_coordinate(-757103L, 818558L), "lat:4.00252710335009,lng:-177.893008020019,level:11: x:-757103,y:818558");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(20.0559312651944L, 179.912109375L), 11), geohex_coordinate(953857L, -639688L), "lat:20.0559312651944,lng:179.912109375,level:11: x:953857,y:-639688");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(18.5629474428883L, 178.41796875L), 11), geohex_coordinate(935104L, -645206L), "lat:18.5629474428883,lng:178.41796875,level:11: x:935104,y:-645206");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.1059987997506L, 128.232421875L), 11), geohex_coordinate(741839L, -393961L), "lat:22.1059987997506,lng:128.232421875,level:11: x:741839,y:-393961");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(26.947688436082L, 146.159726354981L), 11), geohex_coordinate(862073L, -432515L), "lat:26.947688436082,lng:146.159726354981,level:11: x:862073,y:-432515");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(29.8846192961586L, 153.103085729981L), 11), geohex_coordinate(918442L, -437646L), "lat:29.8846192961586,lng:153.103085729981,level:11: x:918442,y:-437646");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(32.9902355596511L, 139.74609375L), 11), geohex_coordinate(887214L, -350566L), "lat:32.9902355596511,lng:139.74609375,level:11: x:887214,y:-350566");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(36.0012569177875L, 137.722226354981L), 11), geohex_coordinate(906282L, -313572L), "lat:36.0012569177875,lng:137.722226354981,level:11: x:906282,y:-313572");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.325177679993L, 141.6796875L), 11), geohex_coordinate(996905L, -258002L), "lat:43.325177679993,lng:141.6796875,level:11: x:996905,y:-258002");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(38.8225909761771L, 38.671875L), 11), geohex_coordinate(494872L, 152342L), "lat:38.8225909761771,lng:38.671875,level:11: x:494872,y:152342");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.1167138721005L, -113.820742395019L), 11), geohex_coordinate(-279184L, 728966L), "lat:28.1167138721005,lng:-113.820742395019,level:11: x:-279184,y:728966");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(46.412227057262L, -106.086367395019L), 11), geohex_coordinate(-66947L, 872697L), "lat:46.412227057262,lng:-106.086367395019,level:11: x:-66947,y:872697");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.2314574786257L, -80.15625L), 11), geohex_coordinate(329983L, 1039955L), "lat:66.2314574786257,lng:-80.15625,level:11: x:329983,y:1039955");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.157162522661L, 18.28125L), 11), geohex_coordinate(1040996L, 879073L), "lat:77.157162522661,lng:18.28125,level:11: x:1040996,y:879073");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.1407778407043L, 120.9375L), 11), geohex_coordinate(1430906L, 359720L), "lat:75.1407778407043,lng:120.9375,level:11: x:1430906,y:359720");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.0601806553806L, 170.944882604981L), 11), geohex_coordinate(1877264L, 363145L), "lat:81.0601806553806,lng:170.944882604981,level:11: x:1877264,y:363145");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.4868032304587L, -179.914492395019L), 11), geohex_coordinate(344996L, 1938562L), "lat:81.4868032304587,lng:-179.914492395019,level:11: x:344996,y:1938562");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.5498507668598L, -178.2421875L), 11), geohex_coordinate(474714L, 2053467L), "lat:83.5498507668598,lng:-178.2421875,level:11: x:474714,y:2053467");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.7383871209534L, 172.353515625L), 11), geohex_coordinate(2117055L, 590459L), "lat:84.7383871209534,lng:172.353515625,level:11: x:2117055,y:590459");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.050417912863L, 88.1597900390625L), 11), geohex_coordinate(1771092L, 990230L), "lat:85.050417912863,lng:88.1597900390625,level:11: x:1771092,y:990230");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0506548798275L, -79.82666015625L), 12), geohex_coordinate(-5202625L, -3081467L), "lat:-85.0506548798275,lng:-79.82666015625,level:12: x:-5202625,y:-3081467");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 120.706787109375L), 12), geohex_coordinate(-2538459L, -5745886L), "lat:-85.0511287798066,lng:120.706787109375,level:12: x:-2538459,y:-5745886");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, 178.868408203125L), 12), geohex_coordinate(-1765975L, -6518875L), "lat:-85.0520764439798,lng:178.868408203125,level:12: x:-1765975,y:-6518875");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 178.934326171875L), 12), geohex_coordinate(-1764847L, -6519499L), "lat:-85.0511287798066,lng:178.934326171875,level:12: x:-1764847,y:-6519499");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -178.253173828125L), 12), geohex_coordinate(-6510449L, -1773897L), "lat:-85.0511287798066,lng:-178.253173828125,level:12: x:-6510449,y:-1773897");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-79.445226643583L, -13.7023341918944L), 12), geohex_coordinate(-3322654L, -2958555L), "lat:-79.445226643583,lng:-13.7023341918944,level:12: x:-3322654,y:-2958555");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.9156689863258L, 172.96875L), 12), geohex_coordinate(-662939L, -5259073L), "lat:-77.9156689863258,lng:172.96875,level:12: x:-662939,y:-5259073");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.1849954609471L, -179.296875L), 12), geohex_coordinate(-5165165L, -400879L), "lat:-76.1849954609471,lng:-179.296875,level:12: x:-5165165,y:-400879");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-57.3643675190898L, -102.999209191894L), 12), geohex_coordinate(-2988100L, -251200L), "lat:-57.3643675190898,lng:-102.999209191894,level:12: x:-2988100,y:-251200");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-49.8379824530848L, 61.875L), 12), geohex_coordinate(-504717L, -2148863L), "lat:-49.8379824530848,lng:61.875,level:12: x:-504717,y:-2148863");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-27.7456223888095L, -162.061709191894L), 12), geohex_coordinate(-2818165L, 1488147L), "lat:-27.7456223888095,lng:-162.061709191894,level:12: x:-2818165,y:1488147");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-13.3082127596866L, 177.547665808106L), 12), geohex_coordinate(2049862L, -2667944L), "lat:-13.3082127596866,lng:177.547665808106,level:12: x:2049862,y:-2667944");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-2.8814258912385L, -178.233584191894L), 12), geohex_coordinate(-2434352L, 2301680L), "lat:-2.8814258912385,lng:-178.233584191894,level:12: x:-2434352,y:2301680");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(10.4188347787547L, -175.421084191894L), 12), geohex_coordinate(-2089558L, 2571740L), "lat:10.4188347787547,lng:-175.421084191894,level:12: x:-2089558,y:2571740");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(13.8553135172218L, 176.141415808106L), 12), geohex_coordinate(2662212L, -2018226L), "lat:13.8553135172218,lng:176.141415808106,level:12: x:2662212,y:-2018226");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-5.61598581915533L, 4.921875L), 12), geohex_coordinate(-64051L, -194835L), "lat:-5.61598581915533,lng:4.921875,level:12: x:-64051,y:-194835");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.84594591772659L, 0.360165808105606L), 12), geohex_coordinate(116433L, 106863L), "lat:4.84594591772659,lng:0.360165808105606,level:12: x:116433,y:106863");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.51342104564004L, -59.765625L), 12), geohex_coordinate(-713146L, 874949L), "lat:3.51342104564004,lng:-59.765625,level:12: x:-713146,y:874949");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(35.4035186514968L, 44.6570408081056L), 12), geohex_coordinate(1465440L, 278811L), "lat:35.4035186514968,lng:44.6570408081056,level:12: x:1465440,y:278811");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.5937260639293L, 128.3203125L), 12), geohex_coordinate(2238819L, -1170915L), "lat:22.5937260639293,lng:128.3203125,level:12: x:2238819,y:-1170915");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.8602197525588L, 144.852353308106L), 12), geohex_coordinate(2618653L, -1230371L), "lat:28.8602197525588,lng:144.852353308106,level:12: x:2618653,y:-1230371");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(29.4741845785535L, 153.992978308106L), 12), geohex_coordinate(2756276L, -1335633L), "lat:29.4741845785535,lng:153.992978308106,level:12: x:2756276,y:-1335633");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.5013892782751L, 143.094540808106L), 12), geohex_coordinate(2983628L, -818687L), "lat:42.5013892782751,lng:143.094540808106,level:12: x:2983628,y:-818687");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(26.3684016357923L, -113.897646691894L), 12), geohex_coordinate(-883827L, 2142667L), "lat:26.3684016357923,lng:-113.897646691894,level:12: x:-883827,y:2142667");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(43.5295585527122L, -107.921084191894L), 12), geohex_coordinate(-319011L, 2548673L), "lat:43.5295585527122,lng:-107.921084191894,level:12: x:-319011,y:2548673");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.3727550024746L, -76.9921875L), 12), geohex_coordinate(1040076L, 3085916L), "lat:66.3727550024746,lng:-76.9921875,level:12: x:1040076,y:3085916");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(74.4964131169431L, 116.71875L), 12), geohex_coordinate(4180037L, 1078581L), "lat:74.4964131169431,lng:116.71875,level:12: x:4180037,y:1078581");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.157162522661L, 18.6328125L), 12), geohex_coordinate(3127660L, 2632548L), "lat:77.157162522661,lng:18.6328125,level:12: x:3127660,y:2632548");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.1183836069127L, -43.59375L), 12), geohex_coordinate(2948131L, 4106506L), "lat:82.1183836069127,lng:-43.59375,level:12: x:2948131,y:4106506");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.2616987368315L, 175.078125L), 12), geohex_coordinate(5877682L, 1225497L), "lat:82.2616987368315,lng:175.078125,level:12: x:5877682,y:1225497");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.2994996528633L, -179.991396691894L), 12), geohex_coordinate(1166695L, 5949436L), "lat:82.2994996528633,lng:-179.991396691894,level:12: x:1166695,y:5949436");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.1177892355522L, -177.530459191894L), 12), geohex_coordinate(1555359L, 6272707L), "lat:84.1177892355522,lng:-177.530459191894,level:12: x:1555359,y:6272707");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.7641314110921L, 178.953915808106L), 12), geohex_coordinate(6445333L, 1690161L), "lat:84.7641314110921,lng:178.953915808106,level:12: x:6445333,y:1690161");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0508918354752L, 88.9810180664062L), 12), geohex_coordinate(5324313L, 2959905L), "lat:85.0508918354752,lng:88.9810180664062,level:12: x:5324313,y:2959905");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0207077431259L, -79.453125L), 13), geohex_coordinate(-15569096L, -9235399L), "lat:-85.0207077431259,lng:-79.453125,level:13: x:-15569096,y:-9235399");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9901001802348L, 113.5546875L), 13), geohex_coordinate(-7851906L, -16904048L), "lat:-84.9901001802348,lng:113.5546875,level:13: x:-7851906,y:-16904048");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0539712293069L, 179.6044921875L), 13), geohex_coordinate(-5270104L, -19587483L), "lat:-85.0539712293069,lng:179.6044921875,level:13: x:-5270104,y:-19587483");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0530239271352L, 179.6044921875L), 13), geohex_coordinate(-5269345L, -19586724L), "lat:-85.0530239271352,lng:179.6044921875,level:13: x:-5269345,y:-19586724");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, 179.769287109375L), 13), geohex_coordinate(-5262019L, -19592534L), "lat:-85.0520764439798,lng:179.769287109375,level:13: x:-5262019,y:-19592534");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, 179.813232421875L), 13), geohex_coordinate(-5260267L, -19594286L), "lat:-85.0520764439798,lng:179.813232421875,level:13: x:-5260267,y:-19594286");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0501809345811L, 179.813232421875L), 13), geohex_coordinate(-5258750L, -19592769L), "lat:-85.0501809345811,lng:179.813232421875,level:13: x:-5258750,y:-19592769");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0520764439798L, -179.049682617188L), 13), geohex_coordinate(-19563852L, -5290701L), "lat:-85.0520764439798,lng:-179.049682617188,level:13: x:-19563852,y:-5290701");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -179.044189453125L), 13), geohex_coordinate(-19562875L, -5290161L), "lat:-85.0511287798066,lng:-179.044189453125,level:13: x:-19562875,y:-5290161");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.5041191797399L, 177.36328125L), 13), geohex_coordinate(-1680172L, -15818890L), "lat:-77.5041191797399,lng:177.36328125,level:13: x:-1680172,y:-15818890");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-75.9725794480917L, -179.848574426269L), 13), geohex_coordinate(-15456531L, -1119695L), "lat:-75.9725794480917,lng:-179.848574426269,level:13: x:-15456531,y:-1119695");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.9039293885709L, -12.3046875L), 13), geohex_coordinate(-9713247L, -8732365L), "lat:-78.9039293885709,lng:-12.3046875,level:13: x:-9713247,y:-8732365");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-49.8379824530848L, -97.3828125L), 13), geohex_coordinate(-7861861L, -98878L), "lat:-49.8379824530848,lng:-97.3828125,level:13: x:-7861861,y:-98878");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.2792290025708L, 61.5234375L), 13), geohex_coordinate(-1261187L, -6165599L), "lat:-47.2792290025708,lng:61.5234375,level:13: x:-1261187,y:-6165599");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-22.5937260639293L, -166.2890625L), 13), geohex_coordinate(-8229818L, 5026106L), "lat:-22.5937260639293,lng:-166.2890625,level:13: x:-8229818,y:5026106");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-11.5230875068685L, 178.2421875L), 13), geohex_coordinate(6303463L, -7905318L), "lat:-11.5230875068685,lng:178.2421875,level:13: x:6303463,y:-7905318");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-2.46018118102099L, -179.296875L), 13), geohex_coordinate(-7316322L, 6976535L), "lat:-2.46018118102099,lng:-179.296875,level:13: x:-7316322,y:6976535");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(9.44906182688142L, -179.296875L), 13), geohex_coordinate(-6491124L, 7801733L), "lat:9.44906182688142,lng:-179.296875,level:13: x:-6491124,y:7801733");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(20.632784250388L, 179.296875L), 13), geohex_coordinate(8602661L, -5690196L), "lat:20.632784250388,lng:179.296875,level:13: x:8602661,y:-5690196");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(3.51342104564004L, -60.8203125L), 13), geohex_coordinate(-2181475L, 2666886L), "lat:3.51342104564004,lng:-60.8203125,level:13: x:-2181475,y:2666886");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-0.351560293992271L, -3.1640625L), 13), geohex_coordinate(-150384L, 101843L), "lat:-0.351560293992271,lng:-3.1640625,level:13: x:-150384,y:101843");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(0.355576693380542L, 6.30376932373061L), 13), geohex_coordinate(275804L, -226708L), "lat:0.355576693380542,lng:6.30376932373061,level:13: x:275804,y:-226708");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(31.353636941501L, 137.4609375L), 13), geohex_coordinate(7760360L, -3197497L), "lat:31.353636941501,lng:137.4609375,level:13: x:7760360,y:-3197497");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.5937260639293L, 129.375L), 13), geohex_coordinate(6758494L, -3554783L), "lat:22.5937260639293,lng:129.375,level:13: x:6758494,y:-3554783");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(29.232395052192L, 153.608456823731L), 13), geohex_coordinate(8234352L, -4010723L), "lat:29.232395052192,lng:153.608456823731,level:13: x:8234352,y:-4010723");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.814468134372L, 142.006894323731L), 13), geohex_coordinate(8936922L, -2383321L), "lat:42.814468134372,lng:142.006894323731,level:13: x:8936922,y:-2383321");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.5530802889558L, 38.671875L), 13), geohex_coordinate(4793639L, 1710866L), "lat:42.5530802889558,lng:38.671875,level:13: x:4793639,y:1710866");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(27.9979478746264L, -116.743105676269L), 13), geohex_coordinate(-2638423L, 6667888L), "lat:27.9979478746264,lng:-116.743105676269,level:13: x:-2638423,y:6667888");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(46.3193581834244L, -108.305605676269L), 13), geohex_coordinate(-700265L, 7933441L), "lat:46.3193581834244,lng:-108.305605676269,level:13: x:-700265,y:7933441");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(66.9300602586245L, -80.5078125L), 13), geohex_coordinate(3077184L, 9494957L), "lat:66.9300602586245,lng:-80.5078125,level:13: x:3077184,y:9494957");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(76.9206135182968L, 20.7421875L), 13), geohex_coordinate(9394245L, 7740758L), "lat:76.9206135182968,lng:20.7421875,level:13: x:9394245,y:7740758");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(75.1407778407043L, 121.2890625L), 13), geohex_coordinate(12892169L, 3223472L), "lat:75.1407778407043,lng:121.2890625,level:13: x:12892169,y:3223472");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.5861063502088L, -40.4296875L), 13), geohex_coordinate(9213213L, 12436112L), "lat:82.5861063502088,lng:-40.4296875,level:13: x:9213213,y:12436112");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.923186326022L, 168.75L), 13), geohex_coordinate(17210925L, 3758825L), "lat:81.923186326022,lng:168.75,level:13: x:17210925,y:3758825");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.1664460084773L, -172.6171875L), 13), geohex_coordinate(3726038L, 17486416L), "lat:82.1664460084773,lng:-172.6171875,level:13: x:3726038,y:17486416");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.9054843956402L, -179.321230676269L), 13), geohex_coordinate(4454198L, 18748996L), "lat:83.9054843956402,lng:-179.321230676269,level:13: x:4454198,y:18748996");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.6082178794592L, 179.624081823731L), 13), geohex_coordinate(19246478L, 4927538L), "lat:84.6082178794592,lng:179.624081823731,level:13: x:19246478,y:4927538");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.051099162384L, 88.6768341064453L), 13), geohex_coordinate(15960982L, 8892006L), "lat:85.051099162384,lng:88.6768341064453,level:13: x:15960982,y:8892006");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9901001802348L, -79.453125L), 14), geohex_coordinate(-46634477L, -27633385L), "lat:-84.9901001802348,lng:-79.453125,level:14: x:-46634477,y:-27633385");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.1412839811764L, 118.125L), 14), geohex_coordinate(-23373283L, -51622694L), "lat:-85.1412839811764,lng:118.125,level:14: x:-23373283,y:-51622694");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0813644184664L, 118.828125L), 14), geohex_coordinate(-23143585L, -51561147L), "lat:-85.0813644184664,lng:118.828125,level:14: x:-23143585,y:-51561147");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.035941506574L, 121.11328125L), 14), geohex_coordinate(-22761121L, -51725175L), "lat:-85.035941506574,lng:121.11328125,level:14: x:-22761121,y:-51725175");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 177.5390625L), 14), geohex_coordinate(-16050458L, -58508650L), "lat:-85.0511287798066,lng:177.5390625,level:14: x:-16050458,y:-58508650");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.035941506574L, 177.71484375L), 14), geohex_coordinate(-15993033L, -58493263L), "lat:-85.035941506574,lng:177.71484375,level:14: x:-15993033,y:-58493263");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0513657128222L, -178.339691162109L), 14), geohex_coordinate(-58604953L, -15955292L), "lat:-85.0513657128222,lng:-178.339691162109,level:14: x:-58604953,y:-15955292");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0512472477288L, -178.339691162109L), 14), geohex_coordinate(-58604669L, -15955008L), "lat:-85.0512472477288,lng:-178.339691162109,level:14: x:-58604669,y:-15955008");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0510103090554L, -178.339691162109L), 14), geohex_coordinate(-58604100L, -15954439L), "lat:-85.0510103090554,lng:-178.339691162109,level:14: x:-58604100,y:-15954439");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.3494106901463L, 178.154296875L), 14), geohex_coordinate(-5783264L, -48388588L), "lat:-78.3494106901463,lng:178.154296875,level:14: x:-5783264,y:-48388588");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.0901008123345L, -178.182429101562L), 14), geohex_coordinate(-48128884L, -5516832L), "lat:-78.0901008123345,lng:-178.182429101562,level:14: x:-48128884,y:-5516832");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.4905516616031L, -15.46875L), 14), geohex_coordinate(-29081213L, -25381885L), "lat:-78.4905516616031,lng:-15.46875,level:14: x:-29081213,y:-25381885");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-53.330872983017L, -97.03125L), 14), geohex_coordinate(-24708530L, -1503657L), "lat:-53.330872983017,lng:-97.03125,level:14: x:-24708530,y:-1503657");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-49.9256543925955L, 58.5949146484376L), 14), geohex_coordinate(-4962845L, -18975728L), "lat:-49.9256543925955,lng:58.5949146484376,level:14: x:-4962845,y:-18975728");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.40716816360107L, -2.8125L), 14), geohex_coordinate(-2083782L, -1411177L), "lat:-8.40716816360107,lng:-2.8125,level:14: x:-2083782,y:-1411177");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(4.07924021199305L, -1.17071035156236L), 14), geohex_coordinate(705574L, 985547L), "lat:4.07924021199305,lng:-1.17071035156236,level:14: x:705574,y:985547");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-15.9613290815966L, -159.609375L), 14), geohex_coordinate(-22434502L, 15735833L), "lat:-15.9613290815966,lng:-159.609375,level:14: x:-22434502,y:15735833");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-10.621569004993L, 173.907414648438L), 14), geohex_coordinate(18582317L, -23007372L), "lat:-10.621569004993,lng:173.907414648438,level:14: x:18582317,y:-23007372");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-5.75137610292601L, -173.436335351562L), 14), geohex_coordinate(-21931681L, 19545350L), "lat:-5.75137610292601,lng:-173.436335351562,level:14: x:-21931681,y:19545350");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(5.48056406874262L, -174.139460351562L), 14), geohex_coordinate(-19685784L, 21959398L), "lat:5.48056406874262,lng:-174.139460351562,level:14: x:-19685784,y:21959398");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(12.4217234089099L, 179.532414648438L), 14), geohex_coordinate(24060489L, -18874410L), "lat:12.4217234089099,lng:179.532414648438,level:14: x:24060489,y:-18874410");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(5.61598581915534L, -58.359375L), 14), geohex_coordinate(-5813291L, 8143263L), "lat:5.61598581915534,lng:-58.359375,level:14: x:-5813291,y:8143263");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(21.162545457735L, 127.501164648438L), 14), geohex_coordinate(19731995L, -10759711L), "lat:21.162545457735,lng:127.501164648438,level:14: x:19731995,y:-10759711");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.1845211850003L, 145.079289648438L), 14), geohex_coordinate(23435741L, -11259746L), "lat:28.1845211850003,lng:145.079289648438,level:14: x:23435741,y:-11259746");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(29.4167816436476L, 155.626164648438L), 14), geohex_coordinate(24988122L, -12229634L), "lat:29.4167816436476,lng:155.626164648438,level:14: x:24988122,y:-12229634");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(41.9318347167088L, 141.563664648438L), 14), geohex_coordinate(26510321L, -7344410L), "lat:41.9318347167088,lng:141.563664648438,level:14: x:26510321,y:-7344410");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(38.272688535981L, 34.453125L), 14), geohex_coordinate(12711478L, 4472067L), "lat:38.272688535981,lng:34.453125,level:14: x:12711478,y:4472067");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.1845211850003L, -112.967585351562L), 14), geohex_coordinate(-7420014L, 19596009L), "lat:28.1845211850003,lng:-112.967585351562,level:14: x:-7420014,y:19596009");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(44.4934928233501L, -106.639460351562L), 14), geohex_coordinate(-2440259L, 23062403L), "lat:44.4934928233501,lng:-106.639460351562,level:14: x:-2440259,y:23062403");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(65.3100652213914L, -84.8425853515624L), 14), geohex_coordinate(7884118L, 28174091L), "lat:65.3100652213914,lng:-84.8425853515624,level:14: x:7884118,y:28174091");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(77.282602201606L, 24.8449146484376L), 14), geohex_coordinate(29009196L, 23067573L), "lat:77.282602201606,lng:24.8449146484376,level:14: x:29009196,y:23067573");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(74.0195433115023L, 123.046875L), 14), geohex_coordinate(38012956L, 8586487L), "lat:74.0195433115023,lng:123.046875,level:14: x:38012956,y:8586487");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.8533822917608L, -37.96875L), 14), geohex_coordinate(28370772L, 37450940L), "lat:82.8533822917608,lng:-37.96875,level:14: x:28370772,y:37450940");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.5182718765338L, 175.078125L), 14), geohex_coordinate(51806962L, 9937300L), "lat:81.5182718765338,lng:175.078125,level:14: x:51806962,y:9937300");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(81.3083209005181L, -177.1875L), 14), geohex_coordinate(9393826L, 51767942L), "lat:81.3083209005181,lng:-177.1875,level:14: x:9393826,y:51767942");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.1110298514359L, -175.545710351562L), 14), geohex_coordinate(14221907L, 56203392L), "lat:84.1110298514359,lng:-175.545710351562,level:14: x:14221907,y:56203392");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.5284028366271L, 177.423039648438L), 14), geohex_coordinate(57301611L, 14871166L), "lat:84.5284028366271,lng:177.423039648438,level:14: x:57301611,y:14871166");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0501290940733L, 88.7193202972412L), 14), geohex_coordinate(47885698L, 26668610L), "lat:85.0501290940733,lng:88.7193202972412,level:14: x:47885698,y:26668610");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0511287798066L, 88.7024974822998L), 14), geohex_coordinate(47886086L, 26673021L), "lat:85.0511287798066,lng:88.7024974822998,level:14: x:47886086,y:26673021");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0549183505294L, -80.244140625L), 15), geohex_coordinate(-140651359L, -83080573L), "lat:-85.0549183505294,lng:-80.244140625,level:15: x:-140651359,y:-83080573");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -80.244140625L), 15), geohex_coordinate(-140624055L, -83053269L), "lat:-85.0511287798066,lng:-80.244140625,level:15: x:-140624055,y:-83053269");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0435409456565L, -76.81640625L), 15), geohex_coordinate(-139339840L, -84228266L), "lat:-85.0435409456565,lng:-76.81640625,level:15: x:-139339840,y:-84228266");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-84.9283209294996L, 113.203125L), 15), geohex_coordinate(-70356394L, -151573450L), "lat:-84.9283209294996,lng:113.203125,level:15: x:-70356394,y:-151573450");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, 178.70361328125L), 15), geohex_coordinate(-47733624L, -175943700L), "lat:-85.0511287798066,lng:178.70361328125,level:15: x:-47733624,y:-175943700");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0510103090554L, 178.621215820312L), 15), geohex_coordinate(-47762328L, -175913289L), "lat:-85.0510103090554,lng:178.621215820312,level:15: x:-47762328,y:-175913289");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0511287798066L, -179.47265625L), 15), geohex_coordinate(-176219573L, -47457750L), "lat:-85.0511287798066,lng:-179.47265625,level:15: x:-176219573,y:-47457750");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-85.0492329082692L, -179.49462890625L), 15), geohex_coordinate(-176213803L, -47436216L), "lat:-85.0492329082692,lng:-179.49462890625,level:15: x:-176213803,y:-47436216");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-78.6300055677483L, -16.875L), 15), geohex_coordinate(-88184962L, -76078072L), "lat:-78.6300055677483,lng:-16.875,level:15: x:-88184962,y:-76078072");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-76.9999351181161L, 178.59375L), 15), geohex_coordinate(-13260322L, -141391577L), "lat:-76.9999351181161,lng:178.59375,level:15: x:-13260322,y:-141391577");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-77.6928703364193L, -179.6484375L), 15), geohex_coordinate(-143735832L, -14847896L), "lat:-77.6928703364193,lng:-179.6484375,level:15: x:-143735832,y:-14847896");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-48.2246726495652L, 61.171875L), 15), geohex_coordinate(-12350539L, -56238016L), "lat:-48.2246726495652,lng:61.171875,level:15: x:-12350539,y:-56238016");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-47.75409797968L, -101.6015625L), 15), geohex_coordinate(-70304192L, 2589377L), "lat:-47.75409797968,lng:-101.6015625,level:15: x:-70304192,y:2589377");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-24.5271348225978L, -160.3125L), 15), geohex_coordinate(-73235041L, 41780417L), "lat:-24.5271348225978,lng:-160.3125,level:15: x:-73235041,y:41780417");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-10.6278115862448L, 175.584117147827L), 15), geohex_coordinate(56344474L, -69627534L), "lat:-10.6278115862448,lng:175.584117147827,level:15: x:56344474,y:-69627534");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-8.89551936027947L, -174.923695352173L), 15), geohex_coordinate(-68298452L, 57199740L), "lat:-8.89551936027947,lng:-174.923695352173,level:15: x:-68298452,y:57199740");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(9.65531361108872L, -177.736195352173L), 15), geohex_coordinate(-57730310L, 69785697L), "lat:9.65531361108872,lng:-177.736195352173,level:15: x:-57730310,y:69785697");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(13.4537372134192L, 177.1875L), 15), geohex_coordinate(71998221L, -55124127L), "lat:13.4537372134192,lng:177.1875,level:15: x:71998221,y:-55124127");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(28.6134594240044L, 144.4921875L), 15), geohex_coordinate(70399589L, -33265659L), "lat:28.6134594240044,lng:144.4921875,level:15: x:70399589,y:-33265659");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(22.268764039074L, 129.0234375L), 15), geohex_coordinate(60481900L, -32085365L), "lat:22.268764039074,lng:129.0234375,level:15: x:60481900,y:-32085365");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(30.4016615131776L, 155.413218710327L), 15), geohex_coordinate(75593945L, -35906546L), "lat:30.4016615131776,lng:155.413218710327,level:15: x:75593945,y:-35906546");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(42.7715132719991L, 142.756968710327L), 15), geohex_coordinate(80664997L, -21755327L), "lat:42.7715132719991,lng:142.756968710327,level:15: x:80664997,y:-21755327");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(-0.351560293992271L, -0.3515625L), 15), geohex_coordinate(-344548L, -92321L), "lat:-0.351560293992271,lng:-0.3515625,level:15: x:-344548,y:-92321");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(0.648591093753425L, -2.43834378967267L), 15), geohex_coordinate(-471694L, 1277684L), "lat:0.648591093753425,lng:-2.43834378967267,level:15: x:-471694,y:1277684");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(1.40610883543516L, -59.4140625L), 15), geohex_coordinate(-20439432L, 22186911L), "lat:1.40610883543516,lng:-59.4140625,level:15: x:-20439432,y:22186911");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(27.0105631247302L, -115.289906289673L), 15), geohex_coordinate(-23916187L, 58798020L), "lat:27.0105631247302,lng:-115.289906289673,level:15: x:-23916187,y:58798020");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(47.9899216674142L, -108.6328125L), 15), geohex_coordinate(-4893211L, 73044895L), "lat:47.9899216674142,lng:-108.6328125,level:15: x:-4893211,y:73044895");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(44.3395652480971L, 32.6953125L), 15), geohex_coordinate(42527869L, 19070769L), "lat:44.3395652480971,lng:32.6953125,level:15: x:42527869,y:19070769");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(65.072130085607L, -80.859375L), 15), geohex_coordinate(24728891L, 82741073L), "lat:65.072130085607,lng:-80.859375,level:15: x:24728891,y:82741073");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(73.8248203461393L, 116.71875L), 15), geohex_coordinate(111331956L, 27592632L), "lat:73.8248203461393,lng:116.71875,level:15: x:111331956,y:27592632");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(78.2782014554281L, 16.171875L), 15), geohex_coordinate(86840561L, 75238125L), "lat:78.2782014554281,lng:16.171875,level:15: x:86840561,y:75238125");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.400042059767L, -38.671875L), 15), geohex_coordinate(87699744L, 115444701L), "lat:83.400042059767,lng:-38.671875,level:15: x:87699744,y:115444701");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.3088925182155L, 176.1328125L), 15), geohex_coordinate(159294183L, 32928516L), "lat:82.3088925182155,lng:176.1328125,level:15: x:159294183,y:32928516");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(82.0700281944827L, -177.890625L), 15), geohex_coordinate(31205775L, 158832577L), "lat:82.0700281944827,lng:-177.890625,level:15: x:31205775,y:158832577");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(83.8992664793694L, -177.868031289673L), 15), geohex_coordinate(40572705L, 168183297L), "lat:83.8992664793694,lng:-177.868031289673,level:15: x:40572705,y:168183297");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.5025950013051L, -179.977406289673L), 15), geohex_coordinate(43529418L, 172653371L), "lat:84.5025950013051,lng:-179.977406289673,level:15: x:43529418,y:172653371");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(84.8609006021274L, 178.967906210327L), 15), geohex_coordinate(174694024L, 46294332L), "lat:84.8609006021274,lng:178.967906210327,level:15: x:174694024,y:46294332");
  coordinate_is(geohex_get_coordinate_by_location(geohex_location(85.0511250776385L, 89.3795299530029L), 15), geohex_coordinate(143901099L, 79776171L), "lat:85.0511250776385,lng:89.3795299530029,level:15: x:143901099,y:79776171");
}

void code2coords (void) {
  // verify
  ok(geohex_verify_code("XM") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EX2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aZ2") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI76") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU06") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU13") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH32") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK51") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL60") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ18") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU88") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY53") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb17") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb34") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb86") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK63") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO07") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO42") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK02") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD31") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE73") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO84") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO47") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB61") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA08") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX55") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX04") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YF58") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX15") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OU40") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV56") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO045") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO056") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO077") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV778") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU570") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU868") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK468") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY443") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY004") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb526") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI440") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU026") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU630") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ580") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY864") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV385") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX355") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX568") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD744") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO808") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO428") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO474") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO073") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB648") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG168") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7541") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0532") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO3203") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU6235") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU1425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7172") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ0737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb0200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb8608") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI2651") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OC2121") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU7871") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4212") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK4362") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OX2538") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY5663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OG6663") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ0631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV8518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK3246") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK1825") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aB6727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TR1202") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4054") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA5685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4881") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6425") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6270") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80302") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80373") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO08354") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU31135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU45042") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ35087") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK06445") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb80457") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH80422") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI74753") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI80240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU01265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU86344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY77334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY15454") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA04170") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS68342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM78145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM48257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03156") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ47685") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40654") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI71873") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX40264") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA44552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD47117") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK51615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK71615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO38458") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO58484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV553581") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI802417") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI750110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO018862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053505") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO074664") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ351822") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU412420") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU708101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK847038") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH501658") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI842644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI836575") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU316588") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU175485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb711277") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY728344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA016372") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU408880") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM442337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS387785") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX037037") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ173676") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV321726") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC828583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI713375") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD080050") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX817100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA712478") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK166315") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK873482") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO433402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO586342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb335332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8032788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7714524") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0514686") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0517300") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732687") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0732768") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4031833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8072131") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8255485") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3800810") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1624776") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7464515") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb5316746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4033527") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4540858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4351804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8387484") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU0706771") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4884047") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8251271") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0565644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY8320288") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3556486") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ8016814") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1746604") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6242083") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM5643552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU6303820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM7851800") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0345653") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6306347") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8827707") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4253332") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8776718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PF2148656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4587731") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4335020") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV5843218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX0682573") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX8100870") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD4424804") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bE6100113") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK5027217") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7070414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO6240542") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO7775738") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO5821675") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3371862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV54870250") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV78253862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57758513") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI75600226") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05603615") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07152160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU41063674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU72201265") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34762511") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb38241503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK48511367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI32042116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI71565064") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH45442518") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY33228746") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA03278283") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU42174351") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU47122108") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM32230826") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56301016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS61272751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60832123") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XU63124187") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03173236") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ38755703") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ57757416") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fc51504013") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OW22586402") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PC52458806") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV20852101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX46486040") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA62754057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD28367162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK05722747") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK83151057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO31130720") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO51331450") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33488116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV804240512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI708565326") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI754848748") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO055580431") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053480025") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO073506567") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ347013544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU413474586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU354580674") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK474555348") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb484868583") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH147081657") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI730641802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI576514101") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY041035522") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY537117080") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA402570238") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU058877078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU832828267") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ382714446") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ028668414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS383657231") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM602176827") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM482452815") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX033123366") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI860616105") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX114077466") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV355072242") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("YG413103084") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA486483578") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX426174078") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX747576237") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK184816376") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO310523631") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO423806423") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb303856635") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO815178640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV1700305142") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV5482764471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV7560068257") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5263615540") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7265571616") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI7505181555") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5736546251") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0273028158") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0536546500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0716764500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4016113514") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4827777232") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU7445272188") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK1777354303") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3420476772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4334484641") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH5856584625") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI1730824803") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI7234521114") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU3851424320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8152020110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0426257051") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4244664644") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7353226324") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY3444432334") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8136543688") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8831183154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6206841033") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM0565771230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4863207510") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0330807788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM6054354111") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ1548687734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ7555070851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI7581576564") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1535370770") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV7031782060") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SW6431665682") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX1617612856") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX7255422107") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA7323011017") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK0130411728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK8071386820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4434206021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3372146218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV57264048634") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI57246068382") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05443747884") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO04773823048") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07200264504") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ34837816828") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU18781747622") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU47467037811") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb05827021141") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK72311284586") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH51383310718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI47416263465") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI87045185255") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU07002763476") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU85663663436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU84201138888") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS62147032100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM30178015132") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM60054311737") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM44560457183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM56456700534") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX03131786872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ16386410216") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78178446320") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX13217487787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV40163034106") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX41314430862") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA47238521110") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK11857485652") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK43222807032") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO03574622544") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO54114446763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33540877533") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV803254745602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI803456424553") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053652024200") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053654462750") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO071704644727") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CY281612610161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU181655132036") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU832016181016") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("FY636801583240") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK446658243285") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH058068815001") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI410587505268") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI871735246286") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU460311054340") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU533828300764") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY313181386161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY803527038734") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA043284261600") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ060785824214") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS625060382624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM317558565378") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL822458403751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP251226173262") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI745463230145") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU681285781273") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV352321156833") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA412658306821") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX413323833627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD023073480358") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK570232153327") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK800808780528") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO328348003525") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO563763855337") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337212207184") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV8046354823266") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI5803560714155") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482706175341") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0482731186381") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485035421662") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485060618642") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0485068654767") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712537663424") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO0712564265481") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU4501241604860") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU8407181150325") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ3061211527483") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb4625116215430") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK7250326542858") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH4221515066426") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI4421818162227") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI8724851414563") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU4074815410453") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU8810462030471") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA0414822216031") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY4236836048713") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY7001555744550") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM4117607703260") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS6246856326218") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL5887834871345") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XX0066438378463") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ4537105130820") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI8337351073052") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX1135780670728") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV4163853373183") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX4034808877353") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA4726354081160") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD0853382488383") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK2756770452053") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK7434850466772") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO0846631354832") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO4805277813220") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb3356324634667") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV80717180121576") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56436210413512") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI56773820550701") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI80611150250021") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05167224507116") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO05405867244763") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170215584802") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170226100057") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO07170227640163") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU16473602511456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU40673078217161") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ31831222362536") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb31200035818717") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK44243402806508") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY01571576207503") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY56733420402656") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH84065825033010") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI50342481388451") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI78081171860100") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU30541311610415") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU44828780263624") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA07571045254517") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS38383877824230") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM31385143063872") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL82447011727335") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP22503400845082") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ13526267300787") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI78437338044154") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RU68880348017456") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV13411223332736") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX38226176387034") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA35122807551718") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD32858648748733") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK18678460283758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK35253726505866") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO35083224064751") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO45177603556405") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563401287846") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb33563422636071") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801644720107680") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV801672224571144") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("BV752066087034602") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CI584051202811030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053702425073344") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO053474671871414") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048672464801367") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("DO048680771383421") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("CZ312460160330640") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU482446631807432") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("EU443120677000135") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OK486263022716030") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("Fb563137601173436") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GH405610617770460") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI428447007470857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("GI714676472576137") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU430846555413857") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("QU455868523435074") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XM314886135481601") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PS624076167125758") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XL828827023882162") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("XP252183615213788") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY441655876848342") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OY450583438341310") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PA007023204648554") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("OI754343508378851") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("RX153284780083552") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("PZ541437131806627") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("SV081012647253500") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("ZA162768706170274") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("aX538661552510561") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bD475537206875044") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK573170435224014") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TK720137660817775") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO078855632751174") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO448407012467243") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("TO801157747467437") == GEOHEX3_VERIFY_RESULT_SUCCESS);
  ok(geohex_verify_code("bb337184418811744") == GEOHEX3_VERIFY_RESULT_SUCCESS);

  // code2coords
  {
    note("geohex: XM");
    geohex_t zone = geohex_get_zone_by_code("XM");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(22.4929492879726L, 146.666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(22.4929492879726L, 133.333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(32.7050565948485L, 153.333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(32.7050565948485L, 126.666666666667L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(41.8706764000141L, 146.666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(41.8706764000141L, 133.333333333333L), "bottom.left");
  }
  {
    note("geohex: OY");
    geohex_t zone = geohex_get_zone_by_code("OY");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-11.4696249513643L, 6.66666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(-11.4696249513643L, -6.66666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(0.0L, 13.3333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(0.0L, -13.3333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(11.4696249513643L, 6.66666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(11.4696249513643L, -6.66666666666667L), "bottom.left");
  }
  {
    note("geohex: GI");
    geohex_t zone = geohex_get_zone_by_code("GI");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-22.4929492879726L, -173.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(-22.4929492879726L, -186.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(-11.4696249513643L, -166.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-11.4696249513643L, -193.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(0.0L, -173.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(0.0L, -186.666666666667L), "bottom.left");
  }
  {
    note("geohex: QU");
    geohex_t zone = geohex_get_zone_by_code("QU");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(1.27222187258541e-14L, -173.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(1.27222187258541e-14L, -186.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(11.4696249513643L, -166.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(11.4696249513643L, -193.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(22.4929492879726L, -173.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(22.4929492879726L, -186.666666666667L), "bottom.left");
  }
  {
    note("geohex: GH");
    geohex_t zone = geohex_get_zone_by_code("GH");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-32.7050565948485L, -153.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(-32.7050565948485L, -166.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(-22.4929492879726L, -146.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-22.4929492879726L, -173.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.4696249513643L, -153.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.4696249513643L, -166.666666666667L), "bottom.left");
  }
  {
    note("geohex: EU");
    geohex_t zone = geohex_get_zone_by_code("EU");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-79.8208663803628L, -173.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(-79.8208663803628L, -186.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.564295156692L, -166.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.564295156692L, -193.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-74.8171611748047L, -173.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-74.8171611748047L, -186.666666666667L), "bottom.left");
  }
  {
    note("geohex: CI");
    geohex_t zone = geohex_get_zone_by_code("CI");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-86.2754112576219L, 126.666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(-86.2754112576219L, 113.333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.4445925866876L, 133.333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.4445925866876L, 106.666666666667L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.4289312717818L, 126.666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.4289312717818L, 113.333333333333L), "bottom.left");
  }
  {
    note("geohex: BV");
    geohex_t zone = geohex_get_zone_by_code("BV");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-86.2754112576219L, -73.3333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(-86.2754112576219L, -86.6666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.4445925866876L, -66.6666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.4445925866876L, -93.3333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.4289312717818L, -73.3333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.4289312717818L, -86.6666666666667L), "bottom.left");
  }
  {
    note("geohex: Fb");
    geohex_t zone = geohex_get_zone_by_code("Fb");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-56.765999116369L, -93.3333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(-56.765999116369L, -106.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(-49.8887630323615L, -86.6666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-49.8887630323615L, -113.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-41.8706764000141L, -93.3333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-41.8706764000141L, -106.666666666667L), "bottom.left");
  }
  {
    note("geohex: SV");
    geohex_t zone = geohex_get_zone_by_code("SV");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(62.5793731923105L, -73.3333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(62.5793731923105L, -86.6666666666666L), "top.left");
    location_is(polygon.middle.right, geohex_location(67.4423781033328L, -66.6666666666666L), "middle.right");
    location_is(polygon.middle.left, geohex_location(67.4423781033328L, -93.3333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(71.4806668681882L, -73.3333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(71.4806668681882L, -86.6666666666666L), "bottom.left");
  }
  {
    note("geohex: TO");
    geohex_t zone = geohex_get_zone_by_code("TO");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.1877023714706L, -173.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(83.1877023714706L, -186.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.4289312717818L, -166.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.4289312717818L, -193.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.4445925866876L, -173.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.4445925866876L, -186.666666666667L), "bottom.left");
  }
  {
    note("geohex: TK");
    geohex_t zone = geohex_get_zone_by_code("TK");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(79.8208663803628L, -173.333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(79.8208663803628L, -186.666666666667L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.6715381665137L, -166.666666666667L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.6715381665137L, -193.333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.1877023714706L, -173.333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.1877023714706L, -186.666666666667L), "bottom.left");
  }
  {
    note("geohex: bD");
    geohex_t zone = geohex_get_zone_by_code("bD");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.6715381665137L, -33.3333333333333L), "top.right");
    location_is(polygon.top.left, geohex_location(81.6715381665137L, -46.6666666666666L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.1877023714706L, -26.6666666666666L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.1877023714706L, -53.3333333333333L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.4289312717818L, -33.3333333333333L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.4289312717818L, -46.6666666666666L), "bottom.left");
  }
  {
    note("geohex: ZA");
    geohex_t zone = geohex_get_zone_by_code("ZA");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(71.4806668681882L, 126.666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(71.4806668681882L, 113.333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(74.8171611748047L, 133.333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(74.8171611748047L, 106.666666666667L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.564295156692L, 126.666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.564295156692L, 113.333333333333L), "bottom.left");
  }
  {
    note("geohex: aX");
    geohex_t zone = geohex_get_zone_by_code("aX");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(74.8171611748047L, 26.6666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(74.8171611748047L, 13.3333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(77.564295156692L, 33.3333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(77.564295156692L, 6.66666666666665L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(79.8208663803628L, 26.6666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(79.8208663803628L, 13.3333333333333L), "bottom.left");
  }
  {
    note("geohex: PZ");
    geohex_t zone = geohex_get_zone_by_code("PZ");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(32.7050565948485L, 46.6666666666667L), "top.right");
    location_is(polygon.top.left, geohex_location(32.7050565948485L, 33.3333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(41.8706764000141L, 53.3333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(41.8706764000141L, 26.6666666666667L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(49.8887630323615L, 46.6666666666667L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(49.8887630323615L, 33.3333333333333L), "bottom.left");
  }
  {
    note("geohex: OK");
    geohex_t zone = geohex_get_zone_by_code("OK");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-56.765999116369L, 66.6666666666666L), "top.right");
    location_is(polygon.top.left, geohex_location(-56.765999116369L, 53.3333333333333L), "top.left");
    location_is(polygon.middle.right, geohex_location(-49.8887630323615L, 73.3333333333333L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-49.8887630323615L, 46.6666666666666L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-41.8706764000141L, 66.6666666666666L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-41.8706764000141L, 53.3333333333333L), "bottom.left");
  }
  {
    note("geohex: CZ3");
    geohex_t zone = geohex_get_zone_by_code("CZ3");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-79.117671767354L, -11.1111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(-79.117671767354L, -15.5555555555555L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.3665252517046L, -8.88888888888888L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.3665252517046L, -17.7777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.564295156692L, -11.1111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.564295156692L, -15.5555555555555L), "bottom.left");
  }
  {
    note("geohex: CI8");
    geohex_t zone = geohex_get_zone_by_code("CI8");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, 122.222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, 117.777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.7903734685558L, 124.444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.7903734685558L, 115.555555555556L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.4289312717818L, 122.222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.4289312717818L, 117.777777777778L), "bottom.left");
  }
  {
    note("geohex: DO0");
    geohex_t zone = geohex_get_zone_by_code("DO0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.4445925866875L, -177.777777777778L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.4445925866875L, -182.222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1284264049787L, -175.555555555556L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1284264049787L, -184.444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.7903734685558L, -177.777777777778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.7903734685558L, -182.222222222222L), "bottom.left");
  }
  {
    note("geohex: EX2");
    geohex_t zone = geohex_get_zone_by_code("EX2");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-75.7931846054884L, -171.111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(-75.7931846054884L, -175.555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(-74.8171611748047L, -168.888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-74.8171611748047L, -177.777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-73.775768209176L, -171.111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-73.775768209176L, -175.555555555556L), "bottom.left");
  }
  {
    note("geohex: EU1");
    geohex_t zone = geohex_get_zone_by_code("EU1");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-79.1176717673541L, 175.555555555556L), "top.right");
    location_is(polygon.top.left, geohex_location(-79.1176717673541L, 171.111111111111L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.3665252517047L, 177.777777777778L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.3665252517047L, 168.888888888889L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.564295156692L, 175.555555555556L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.564295156692L, 171.111111111111L), "bottom.left");
  }
  {
    note("geohex: OK4");
    geohex_t zone = geohex_get_zone_by_code("OK4");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-52.3052216727475L, 62.2222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(-52.3052216727475L, 57.7777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(-49.8887630323615L, 64.4444444444445L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-49.8887630323615L, 55.5555555555556L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.3449700820465L, 62.2222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.3449700820465L, 57.7777777777778L), "bottom.left");
  }
  {
    note("geohex: GI3");
    geohex_t zone = geohex_get_zone_by_code("GI3");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-18.8930183495882L, -171.111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(-18.8930183495882L, -175.555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(-15.2140034644785L, -168.888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-15.2140034644785L, -177.777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.4696249513643L, -171.111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.4696249513643L, -175.555555555556L), "bottom.left");
  }
  {
    note("geohex: GI1");
    geohex_t zone = geohex_get_zone_by_code("GI1");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-18.8930183495882L, 175.555555555556L), "top.right");
    location_is(polygon.top.left, geohex_location(-18.8930183495882L, 171.111111111111L), "top.left");
    location_is(polygon.middle.right, geohex_location(-15.2140034644785L, 177.777777777778L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-15.2140034644785L, 168.888888888889L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.4696249513643L, 175.555555555556L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.4696249513643L, 171.111111111111L), "bottom.left");
  }
  {
    note("geohex: QU0");
    geohex_t zone = geohex_get_zone_by_code("QU0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(0.0L, -177.777777777778L), "top.right");
    location_is(polygon.top.left, geohex_location(0.0L, -182.222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.84611006144169L, -175.555555555556L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.84611006144169L, -184.444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(7.67494760129784L, -177.777777777778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(7.67494760129784L, -182.222222222222L), "bottom.left");
  }
  {
    note("geohex: QU7");
    geohex_t zone = geohex_get_zone_by_code("QU7");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(11.4696249513643L, -171.111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(11.4696249513643L, -175.555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(15.2140034644785L, -168.888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(15.2140034644785L, -177.777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(18.8930183495882L, -171.111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(18.8930183495882L, -175.555555555556L), "bottom.left");
  }
  {
    note("geohex: GH8");
    geohex_t zone = geohex_get_zone_by_code("GH8");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-18.8930183495882L, -157.777777777778L), "top.right");
    location_is(polygon.top.left, geohex_location(-18.8930183495882L, -162.222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(-15.2140034644785L, -155.555555555556L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-15.2140034644785L, -164.444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.4696249513643L, -157.777777777778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.4696249513643L, -162.222222222222L), "bottom.left");
  }
  {
    note("geohex: OY0");
    geohex_t zone = geohex_get_zone_by_code("OY0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-11.4696249513643L, 2.22222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(-11.4696249513643L, -2.22222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(-7.67494760129784L, 4.44444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-7.67494760129784L, -4.44444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-3.84611006144169L, 2.22222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-3.84611006144169L, -2.22222222222222L), "bottom.left");
  }
  {
    note("geohex: Fb3");
    geohex_t zone = geohex_get_zone_by_code("Fb3");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-54.5966358085242L, -91.1111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(-54.5966358085242L, -95.5555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(-52.3052216727475L, -88.8888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-52.3052216727475L, -97.7777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-49.8887630323615L, -91.1111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-49.8887630323615L, -95.5555555555556L), "bottom.left");
  }
  {
    note("geohex: XM4");
    geohex_t zone = geohex_get_zone_by_code("XM4");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(29.4085702268386L, 142.222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(29.4085702268386L, 137.777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(32.7050565948485L, 144.444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(32.7050565948485L, 135.555555555556L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.8841275913257L, 142.222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.8841275913257L, 137.777777777778L), "bottom.left");
  }
  {
    note("geohex: PZ0");
    geohex_t zone = geohex_get_zone_by_code("PZ0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(32.7050565948485L, 42.2222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(32.7050565948485L, 37.7777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.8841275913258L, 44.4444444444445L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.8841275913258L, 35.5555555555556L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(38.9405407349711L, 42.2222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(38.9405407349711L, 37.7777777777778L), "bottom.left");
  }
  {
    note("geohex: SW6");
    geohex_t zone = geohex_get_zone_by_code("SW6");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(70.2184522534529L, -84.4444444444445L), "top.right");
    location_is(polygon.top.left, geohex_location(70.2184522534529L, -88.8888888888889L), "top.left");
    location_is(polygon.middle.right, geohex_location(71.4806668681882L, -82.2222222222222L), "middle.right");
    location_is(polygon.middle.left, geohex_location(71.4806668681882L, -91.1111111111111L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(72.6649954378075L, -84.4444444444445L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(72.6649954378075L, -88.8888888888889L), "bottom.left");
  }
  {
    note("geohex: SV3");
    geohex_t zone = geohex_get_zone_by_code("SV3");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(64.2998370349224L, -71.1111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(64.2998370349224L, -75.5555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(65.9192675132544L, -68.8888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(65.9192675132544L, -77.7777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(67.4423781033328L, -71.1111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(67.4423781033328L, -75.5555555555556L), "bottom.left");
  }
  {
    note("geohex: aX0");
    geohex_t zone = geohex_get_zone_by_code("aX0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(74.8171611748047L, 22.2222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(74.8171611748047L, 17.7777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(75.7931846054884L, 24.4444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(75.7931846054884L, 15.5555555555555L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(76.7076757831938L, 22.2222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(76.7076757831938L, 17.7777777777778L), "bottom.left");
  }
  {
    note("geohex: aX8");
    geohex_t zone = geohex_get_zone_by_code("aX8");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.3665252517047L, 22.2222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(78.3665252517047L, 17.7777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(79.1176717673541L, 24.4444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(79.1176717673541L, 15.5555555555555L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(79.8208663803629L, 22.2222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(79.8208663803629L, 17.7777777777778L), "bottom.left");
  }
  {
    note("geohex: aZ2");
    geohex_t zone = geohex_get_zone_by_code("aZ2");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.0950821454212L, -31.1111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(81.0950821454212L, -35.5555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.6715381665137L, -28.8888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.6715381665137L, -37.7777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.2109240990719L, -31.1111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.2109240990719L, -35.5555555555556L), "bottom.left");
  }
  {
    note("geohex: TO4");
    geohex_t zone = geohex_get_zone_by_code("TO4");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.0424969734017L, -177.777777777778L), "top.right");
    location_is(polygon.top.left, geohex_location(84.0424969734017L, -182.222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.4289312717818L, -175.555555555556L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.4289312717818L, -184.444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.7903734685558L, -177.777777777778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.7903734685558L, -182.222222222222L), "bottom.left");
  }
  {
    note("geohex: aB6");
    geohex_t zone = geohex_get_zone_by_code("aB6");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.7155789635238L, 175.555555555556L), "top.right");
    location_is(polygon.top.left, geohex_location(82.7155789635238L, 171.111111111111L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.1877023714706L, 177.777777777778L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.1877023714706L, 168.888888888889L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.6293613243906L, 175.555555555556L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.6293613243906L, 171.111111111111L), "bottom.left");
  }
  {
    note("geohex: TK1");
    geohex_t zone = geohex_get_zone_by_code("TK1");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(80.4790708574883L, 175.555555555556L), "top.right");
    location_is(polygon.top.left, geohex_location(80.4790708574883L, 171.111111111111L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.0950821454213L, 177.777777777778L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.0950821454213L, 168.888888888889L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.6715381665137L, 175.555555555556L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.6715381665137L, 171.111111111111L), "bottom.left");
  }
  {
    note("geohex: TK3");
    geohex_t zone = geohex_get_zone_by_code("TK3");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(80.4790708574883L, -171.111111111111L), "top.right");
    location_is(polygon.top.left, geohex_location(80.4790708574883L, -175.555555555556L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.0950821454213L, -168.888888888889L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.0950821454213L, -177.777777777778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.6715381665137L, -171.111111111111L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.6715381665137L, -175.555555555556L), "bottom.left");
  }
  {
    note("geohex: ZA4");
    geohex_t zone = geohex_get_zone_by_code("ZA4");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(73.775768209176L, 122.222222222222L), "top.right");
    location_is(polygon.top.left, geohex_location(73.775768209176L, 117.777777777778L), "top.left");
    location_is(polygon.middle.right, geohex_location(74.8171611748047L, 124.444444444444L), "middle.right");
    location_is(polygon.middle.left, geohex_location(74.8171611748047L, 115.555555555556L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(75.7931846054884L, 122.222222222222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(75.7931846054884L, 117.777777777778L), "bottom.left");
  }
  {
    note("geohex: PA0");
    geohex_t zone = geohex_get_zone_by_code("PA0");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(0.0L, -57.7777777777778L), "top.right");
    location_is(polygon.top.left, geohex_location(0.0L, -62.2222222222222L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.8461100614417L, -55.5555555555556L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.8461100614417L, -64.4444444444445L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(7.67494760129786L, -57.7777777777778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(7.67494760129786L, -62.2222222222222L), "bottom.left");
  }
  {
    note("geohex: BV8");
    geohex_t zone = geohex_get_zone_by_code("BV8");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, -77.7777777777777L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, -82.2222222222221L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.7903734685558L, -75.5555555555555L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.7903734685558L, -84.4444444444444L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.4289312717818L, -77.7777777777777L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.4289312717818L, -82.2222222222221L), "bottom.left");
  }
  {
    note("geohex: CI76");
    geohex_t zone = geohex_get_zone_by_code("CI76");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.2361755730778L, 131.851851851852L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.2361755730778L, 130.37037037037L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1284264049787L, 132.592592592593L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1284264049787L, 129.62962962963L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0182461528016L, 131.851851851852L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0182461528016L, 130.37037037037L), "bottom.left");
  }
  {
    note("geohex: CI55");
    geohex_t zone = geohex_get_zone_by_code("CI55");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, 111.851851851852L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, 110.37037037037L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0182461528016L, 112.592592592593L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0182461528016L, 109.62962962963L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9055803821142L, 111.851851851852L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9055803821142L, 110.37037037037L), "bottom.left");
  }
  {
    note("geohex: DO07");
    geohex_t zone = geohex_get_zone_by_code("DO07");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, -177.037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, -178.518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0182461528016L, -176.296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0182461528016L, -179.259259259259L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9055803821143L, -177.037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9055803821143L, -178.518518518519L), "bottom.left");
  }
  {
    note("geohex: DO05");
    geohex_t zone = geohex_get_zone_by_code("DO05");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, 178.518518518519L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, 177.037037037037L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0182461528016L, 179.259259259259L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0182461528016L, 176.296296296296L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9055803821142L, 178.518518518519L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9055803821142L, 177.037037037037L), "bottom.left");
  }
  {
    note("geohex: EU06");
    geohex_t zone = geohex_get_zone_by_code("EU06");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-79.3572482500017L, -174.814814814815L), "top.right");
    location_is(polygon.top.left, geohex_location(-79.3572482500017L, -176.296296296296L), "top.left");
    location_is(polygon.middle.right, geohex_location(-79.117671767354L, -174.074074074074L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-79.117671767354L, -177.037037037037L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.8727686949929L, -174.814814814815L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.8727686949929L, -176.296296296296L), "bottom.left");
  }
  {
    note("geohex: EU13");
    geohex_t zone = geohex_get_zone_by_code("EU13");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.8727686949929L, 176.296296296296L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.8727686949929L, 174.814814814815L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.6224251800773L, 177.037037037037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.6224251800773L, 174.074074074074L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.3665252517047L, 176.296296296296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.3665252517047L, 174.814814814815L), "bottom.left");
  }
  {
    note("geohex: GH32");
    geohex_t zone = geohex_get_zone_by_code("GH32");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-27.1490456975025L, -157.037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(-27.1490456975025L, -158.518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(-26.0016268633643L, -156.296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-26.0016268633643L, -159.259259259259L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-24.8428896902851L, -157.037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-24.8428896902851L, -158.518518518519L), "bottom.left");
  }
  {
    note("geohex: OK51");
    geohex_t zone = geohex_get_zone_by_code("OK51");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-49.055070190506L, 51.8518518518518L), "top.right");
    location_is(polygon.top.left, geohex_location(-49.055070190506L, 50.3703703703704L), "top.left");
    location_is(polygon.middle.right, geohex_location(-48.2071571029478L, 52.5925925925926L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-48.2071571029478L, 49.6296296296296L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.3449700820465L, 51.8518518518518L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.3449700820465L, 50.3703703703704L), "bottom.left");
  }
  {
    note("geohex: GI47");
    geohex_t zone = geohex_get_zone_by_code("GI47");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-11.4696249513643L, -177.037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(-11.4696249513643L, -178.518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(-10.2095434727833L, -176.296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-10.2095434727833L, -179.259259259259L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-8.94445133154766L, -177.037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-8.94445133154766L, -178.518518518519L), "bottom.left");
  }
  {
    note("geohex: GI53");
    geohex_t zone = geohex_get_zone_by_code("GI53");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-10.2095434727833L, 176.296296296296L), "top.right");
    location_is(polygon.top.left, geohex_location(-10.2095434727833L, 174.814814814815L), "top.left");
    location_is(polygon.middle.right, geohex_location(-8.94445133154764L, 177.037037037037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-8.94445133154764L, 174.074074074074L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-7.67494760129782L, 176.296296296296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-7.67494760129782L, 174.814814814815L), "bottom.left");
  }
  {
    note("geohex: QU08");
    geohex_t zone = geohex_get_zone_by_code("QU08");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(5.12515391392619L, -179.259259259259L), "top.right");
    location_is(polygon.top.left, geohex_location(5.12515391392619L, -180.740740740741L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.40164208700373L, -178.518518518519L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.40164208700373L, -181.481481481481L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(7.67494760129786L, -179.259259259259L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(7.67494760129786L, -180.740740740741L), "bottom.left");
  }
  {
    note("geohex: OC58");
    geohex_t zone = geohex_get_zone_by_code("OC58");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(5.12515391392619L, -165.925925925926L), "top.right");
    location_is(polygon.top.left, geohex_location(5.12515391392619L, -167.407407407407L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.40164208700373L, -165.185185185185L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.40164208700373L, -168.148148148148L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(7.67494760129786L, -165.925925925926L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(7.67494760129786L, -167.407407407407L), "bottom.left");
  }
  {
    note("geohex: XL60");
    geohex_t zone = geohex_get_zone_by_code("XL60");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(18.8930183495882L, 174.074074074074L), "top.right");
    location_is(polygon.top.left, geohex_location(18.8930183495882L, 172.592592592593L), "top.left");
    location_is(polygon.middle.right, geohex_location(20.1024169233546L, 174.814814814815L), "middle.right");
    location_is(polygon.middle.left, geohex_location(20.1024169233546L, 171.851851851852L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.3025443312145L, 174.074074074074L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.3025443312145L, 172.592592592593L), "bottom.left");
  }
  {
    note("geohex: XM56");
    geohex_t zone = geohex_get_zone_by_code("XM56");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(34.8378414723136L, 138.518518518519L), "top.right");
    location_is(polygon.top.left, geohex_location(34.8378414723136L, 137.037037037037L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.8841275913258L, 139.259259259259L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.8841275913258L, 136.296296296296L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(36.916771667614L, 138.518518518519L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(36.916771667614L, 137.037037037037L), "bottom.left");
  }
  {
    note("geohex: PS62");
    geohex_t zone = geohex_get_zone_by_code("PS62");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.3025443312145L, 129.62962962963L), "top.right");
    location_is(polygon.top.left, geohex_location(21.3025443312145L, 128.148148148148L), "top.left");
    location_is(polygon.middle.right, geohex_location(22.4929492879726L, 130.37037037037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(22.4929492879726L, 127.407407407407L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(23.6732010110163L, 129.62962962963L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(23.6732010110163L, 128.148148148148L), "bottom.left");
  }
  {
    note("geohex: XX03");
    geohex_t zone = geohex_get_zone_by_code("XX03");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(42.8189193212977L, 142.962962962963L), "top.right");
    location_is(polygon.top.left, geohex_location(42.8189193212977L, 141.481481481481L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.7528403384023L, 143.703703703704L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.7528403384023L, 140.740740740741L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(44.6724113934194L, 142.962962962963L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(44.6724113934194L, 141.481481481481L), "bottom.left");
  }
  {
    note("geohex: PZ38");
    geohex_t zone = geohex_get_zone_by_code("PZ38");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.9314177389891L, 47.4074074074074L), "top.right");
    location_is(polygon.top.left, geohex_location(39.9314177389891L, 45.9259259259259L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.9081556333403L, 48.1481481481482L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.9081556333403L, 45.1851851851852L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(41.8706764000141L, 47.4074074074074L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(41.8706764000141L, 45.9259259259259L), "bottom.left");
  }
  {
    note("geohex: PZ04");
    geohex_t zone = geohex_get_zone_by_code("PZ04");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(34.8378414723136L, 40.7407407407407L), "top.right");
    location_is(polygon.top.left, geohex_location(34.8378414723136L, 39.2592592592593L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.8841275913258L, 41.4814814814815L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.8841275913258L, 38.5185185185185L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(36.916771667614L, 40.7407407407407L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(36.916771667614L, 39.2592592592593L), "bottom.left");
  }
  {
    note("geohex: PZ18");
    geohex_t zone = geohex_get_zone_by_code("PZ18");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.9314177389891L, 34.0740740740741L), "top.right");
    location_is(polygon.top.left, geohex_location(39.9314177389891L, 32.5925925925926L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.9081556333403L, 34.8148148148148L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.9081556333403L, 31.8518518518519L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(41.8706764000141L, 34.0740740740741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(41.8706764000141L, 32.5925925925926L), "bottom.left");
  }
  {
    note("geohex: OU88");
    geohex_t zone = geohex_get_zone_by_code("OU88");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-13.9724213026311L, 0.740740740740741L), "top.right");
    location_is(polygon.top.left, geohex_location(-13.9724213026311L, -0.740740740740741L), "top.left");
    location_is(polygon.middle.right, geohex_location(-12.724108773261L, 1.48148148148148L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-12.724108773261L, -1.48148148148148L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.4696249513643L, 0.740740740740741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.4696249513643L, -0.740740740740741L), "bottom.left");
  }
  {
    note("geohex: OY53");
    geohex_t zone = geohex_get_zone_by_code("OY53");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(1.28289338959935L, -3.7037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(1.28289338959935L, -5.18518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.5651438499496L, -2.96296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.5651438499496L, -5.92592592592593L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(3.8461100614417L, -3.7037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(3.8461100614417L, -5.18518518518519L), "bottom.left");
  }
  {
    note("geohex: PA04");
    geohex_t zone = geohex_get_zone_by_code("PA04");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.56514384994961L, -59.2592592592593L), "top.right");
    location_is(polygon.top.left, geohex_location(2.56514384994961L, -60.7407407407407L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.8461100614417L, -58.5185185185185L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.8461100614417L, -61.4814814814815L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(5.1251539139262L, -59.2592592592593L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(5.1251539139262L, -60.7407407407407L), "bottom.left");
  }
  {
    note("geohex: Fb17");
    geohex_t zone = geohex_get_zone_by_code("Fb17");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-52.3052216727475L, -103.703703703704L), "top.right");
    location_is(polygon.top.left, geohex_location(-52.3052216727475L, -105.185185185185L), "top.left");
    location_is(polygon.middle.right, geohex_location(-51.5137582931174L, -102.962962962963L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-51.5137582931174L, -105.925925925926L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-50.7083005615114L, -103.703703703704L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-50.7083005615114L, -105.185185185185L), "bottom.left");
  }
  {
    note("geohex: Fb34");
    geohex_t zone = geohex_get_zone_by_code("Fb34");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-53.0827854378808L, -92.5925925925926L), "top.right");
    location_is(polygon.top.left, geohex_location(-53.0827854378808L, -94.0740740740741L), "top.left");
    location_is(polygon.middle.right, geohex_location(-52.3052216727475L, -91.8518518518518L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-52.3052216727475L, -94.8148148148148L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-51.5137582931173L, -92.5925925925926L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-51.5137582931173L, -94.0740740740741L), "bottom.left");
  }
  {
    note("geohex: Fb86");
    geohex_t zone = geohex_get_zone_by_code("Fb86");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-45.5776197587709L, -94.8148148148148L), "top.right");
    location_is(polygon.top.left, geohex_location(-45.5776197587709L, -96.2962962962963L), "top.left");
    location_is(polygon.middle.right, geohex_location(-44.6724113934194L, -94.0740740740741L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-44.6724113934194L, -97.037037037037L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-43.7528403384023L, -94.8148148148148L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-43.7528403384023L, -96.2962962962963L), "bottom.left");
  }
  {
    note("geohex: GH58");
    geohex_t zone = geohex_get_zone_by_code("GH58");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-17.6748198317407L, -165.925925925926L), "top.right");
    location_is(polygon.top.left, geohex_location(-17.6748198317407L, -167.407407407407L), "top.left");
    location_is(polygon.middle.right, geohex_location(-16.4483118659619L, -165.185185185185L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-16.4483118659619L, -168.148148148148L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-15.2140034644785L, -165.925925925926L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-15.2140034644785L, -167.407407407407L), "bottom.left");
  }
  {
    note("geohex: TK63");
    geohex_t zone = geohex_get_zone_by_code("TK63");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.291503376622L, -163.703703703704L), "top.right");
    location_is(polygon.top.left, geohex_location(81.291503376622L, -165.185185185185L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.4836247115026L, -162.962962962963L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.4836247115026L, -165.925925925926L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.6715381665136L, -163.703703703704L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.6715381665136L, -165.185185185185L), "bottom.left");
  }
  {
    note("geohex: TO07");
    geohex_t zone = geohex_get_zone_by_code("TO07");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.6293613243906L, -177.037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(83.6293613243906L, -178.518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.7701501008722L, -176.296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.7701501008722L, -179.259259259259L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.9078394995407L, -177.037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.9078394995407L, -178.518518518519L), "bottom.left");
  }
  {
    note("geohex: TO42");
    geohex_t zone = geohex_get_zone_by_code("TO42");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.3029788975169L, 176.296296296296L), "top.right");
    location_is(polygon.top.left, geohex_location(84.3029788975169L, 174.814814814815L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.4289312717818L, 177.037037037037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.4289312717818L, 174.074074074074L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.5521076214116L, 176.296296296296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.5521076214116L, 174.814814814815L), "bottom.left");
  }
  {
    note("geohex: TK02");
    geohex_t zone = geohex_get_zone_by_code("TK02");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(80.2644922878378L, 176.296296296296L), "top.right");
    location_is(polygon.top.left, geohex_location(80.2644922878378L, 174.814814814815L), "top.left");
    location_is(polygon.middle.right, geohex_location(80.4790708574883L, 177.037037037037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(80.4790708574883L, 174.074074074074L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(80.6889626043584L, 176.296296296296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(80.6889626043584L, 174.814814814815L), "bottom.left");
  }
  {
    note("geohex: bD31");
    geohex_t zone = geohex_get_zone_by_code("bD31");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.3828899687718L, -34.8148148148148L), "top.right");
    location_is(polygon.top.left, geohex_location(82.3828899687718L, -36.2962962962963L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.5510811105676L, -34.074074074074L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.5510811105676L, -37.037037037037L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.7155789635238L, -34.8148148148148L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.7155789635238L, -36.2962962962963L), "bottom.left");
  }
  {
    note("geohex: bE73");
    geohex_t zone = geohex_get_zone_by_code("bE73");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.5521076214116L, -50.3703703703704L), "top.right");
    location_is(polygon.top.left, geohex_location(84.5521076214116L, -51.8518518518518L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.672568573839L, -49.6296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.672568573839L, -52.5925925925926L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.7903734685558L, -50.3703703703704L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.7903734685558L, -51.8518518518518L), "bottom.left");
  }
  {
    note("geohex: bb33");
    geohex_t zone = geohex_get_zone_by_code("bb33");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.9055803821142L, 89.6296296296296L), "top.right");
    location_is(polygon.top.left, geohex_location(84.9055803821142L, 88.1481481481481L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0182461528016L, 90.3703703703703L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0182461528016L, 87.4074074074074L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.1284264049787L, 89.6296296296296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.1284264049787L, 88.1481481481481L), "bottom.left");
  }
  {
    note("geohex: TO84");
    geohex_t zone = geohex_get_zone_by_code("TO84");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0182461528016L, -179.259259259259L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0182461528016L, -180.740740740741L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.1284264049787L, -178.518518518519L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.1284264049787L, -181.481481481481L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.2361755730778L, -179.259259259259L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.2361755730778L, -180.740740740741L), "bottom.left");
  }
  {
    note("geohex: TO47");
    geohex_t zone = geohex_get_zone_by_code("TO47");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.4289312717818L, -177.037037037037L), "top.right");
    location_is(polygon.top.left, geohex_location(84.4289312717818L, -178.518518518519L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.5521076214116L, -176.296296296296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.5521076214116L, -179.259259259259L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.672568573839L, -177.037037037037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.672568573839L, -178.518518518519L), "bottom.left");
  }
  {
    note("geohex: aB61");
    geohex_t zone = geohex_get_zone_by_code("aB61");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.876463301598L, 171.851851851852L), "top.right");
    location_is(polygon.top.left, geohex_location(82.876463301598L, 170.37037037037L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.0338122616632L, 172.592592592593L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.0338122616632L, 169.62962962963L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.1877023714706L, 171.851851851852L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.1877023714706L, 170.37037037037L), "bottom.left");
  }
  {
    note("geohex: ZA08");
    geohex_t zone = geohex_get_zone_by_code("ZA08");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(73.0432163690016L, 120.740740740741L), "top.right");
    location_is(polygon.top.left, geohex_location(73.0432163690016L, 119.259259259259L), "top.left");
    location_is(polygon.middle.right, geohex_location(73.4134223884459L, 121.481481481482L), "middle.right");
    location_is(polygon.middle.left, geohex_location(73.4134223884459L, 118.518518518519L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(73.775768209176L, 120.740740740741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(73.775768209176L, 119.259259259259L), "bottom.left");
  }
  {
    note("geohex: aX55");
    geohex_t zone = geohex_get_zone_by_code("aX55");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.3665252517047L, 11.8518518518518L), "top.right");
    location_is(polygon.top.left, geohex_location(78.3665252517047L, 10.3703703703704L), "top.left");
    location_is(polygon.middle.right, geohex_location(78.6224251800773L, 12.5925925925926L), "middle.right");
    location_is(polygon.middle.left, geohex_location(78.6224251800773L, 9.62962962962962L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(78.8727686949929L, 11.8518518518518L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(78.8727686949929L, 10.3703703703704L), "bottom.left");
  }
  {
    note("geohex: aX04");
    geohex_t zone = geohex_get_zone_by_code("aX04");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(75.4748662596862L, 20.7407407407408L), "top.right");
    location_is(polygon.top.left, geohex_location(75.4748662596862L, 19.2592592592593L), "top.left");
    location_is(polygon.middle.right, geohex_location(75.7931846054884L, 21.4814814814815L), "middle.right");
    location_is(polygon.middle.left, geohex_location(75.7931846054884L, 18.5185185185185L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(76.1046674926321L, 20.7407407407408L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(76.1046674926321L, 19.2592592592593L), "bottom.left");
  }
  {
    note("geohex: YF58");
    geohex_t zone = geohex_get_zone_by_code("YF58");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(76.1046674926321L, 34.0740740740741L), "top.right");
    location_is(polygon.top.left, geohex_location(76.1046674926321L, 32.5925925925926L), "top.left");
    location_is(polygon.middle.right, geohex_location(76.4094526930952L, 34.8148148148148L), "middle.right");
    location_is(polygon.middle.left, geohex_location(76.4094526930952L, 31.8518518518519L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(76.7076757831938L, 34.0740740740741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(76.7076757831938L, 32.5925925925926L), "bottom.left");
  }
  {
    note("geohex: SV40");
    geohex_t zone = geohex_get_zone_by_code("SV40");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(65.9192675132544L, -79.2592592592592L), "top.right");
    location_is(polygon.top.left, geohex_location(65.9192675132544L, -80.7407407407407L), "top.left");
    location_is(polygon.middle.right, geohex_location(66.43743994247L, -78.5185185185185L), "middle.right");
    location_is(polygon.middle.left, geohex_location(66.43743994247L, -81.4814814814815L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(66.9450851987393L, -79.2592592592592L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(66.9450851987393L, -80.7407407407407L), "bottom.left");
  }
  {
    note("geohex: RX15");
    geohex_t zone = geohex_get_zone_by_code("RX15");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(47.3449700820465L, -108.148148148148L), "top.right");
    location_is(polygon.top.left, geohex_location(47.3449700820465L, -109.62962962963L), "top.left");
    location_is(polygon.middle.right, geohex_location(48.2071571029478L, -107.407407407407L), "middle.right");
    location_is(polygon.middle.left, geohex_location(48.2071571029478L, -110.37037037037L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(49.055070190506L, -108.148148148148L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(49.055070190506L, -109.62962962963L), "bottom.left");
  }
  {
    note("geohex: OU40");
    geohex_t zone = geohex_get_zone_by_code("OU40");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-26.0016268633643L, 0.740740740740741L), "top.right");
    location_is(polygon.top.left, geohex_location(-26.0016268633643L, -0.740740740740741L), "top.left");
    location_is(polygon.middle.right, geohex_location(-24.8428896902851L, 1.48148148148148L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-24.8428896902851L, -1.48148148148148L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-23.6732010110163L, 0.740740740740741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-23.6732010110163L, -0.740740740740741L), "bottom.left");
  }
  {
    note("geohex: BV56");
    geohex_t zone = geohex_get_zone_by_code("BV56");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.2361755730778L, -81.4814814814815L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.2361755730778L, -82.962962962963L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1284264049787L, -80.7407407407407L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1284264049787L, -83.7037037037037L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0182461528016L, -81.4814814814815L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0182461528016L, -82.962962962963L), "bottom.left");
  }
  {
    note("geohex: CI771");
    geohex_t zone = geohex_get_zone_by_code("CI771");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0919724386031L, 128.395061728395L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0919724386031L, 127.901234567901L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.055246359875L, 128.641975308642L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.055246359875L, 127.654320987654L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0182461528016L, 128.395061728395L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0182461528016L, 127.901234567901L), "bottom.left");
  }
  {
    note("geohex: DO045");
    geohex_t zone = geohex_get_zone_by_code("DO045");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1284264049787L, 179.506172839506L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1284264049787L, 179.012345679012L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0919724386031L, 179.753086419753L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0919724386031L, 178.765432098765L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.055246359875L, 179.506172839506L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.055246359875L, 179.012345679012L), "bottom.left");
  }
  {
    note("geohex: DO056");
    geohex_t zone = geohex_get_zone_by_code("DO056");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.055246359875L, 179.506172839506L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.055246359875L, 179.012345679012L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0182461528016L, 179.753086419753L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0182461528016L, 178.765432098765L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9809697867981L, 179.506172839506L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9809697867981L, 179.012345679012L), "bottom.left");
  }
  {
    note("geohex: DO077");
    geohex_t zone = geohex_get_zone_by_code("DO077");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0182461528016L, -176.79012345679L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0182461528016L, -177.283950617284L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9809697867981L, -176.543209876543L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9809697867981L, -177.530864197531L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9434152165899L, -176.79012345679L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9434152165899L, -177.283950617284L), "bottom.left");
  }
  {
    note("geohex: BV778");
    geohex_t zone = geohex_get_zone_by_code("BV778");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9809697867981L, -70.8641975308642L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9809697867981L, -71.358024691358L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9434152165899L, -70.6172839506173L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9434152165899L, -71.604938271605L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9055803821143L, -70.8641975308642L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9055803821143L, -71.358024691358L), "bottom.left");
  }
  {
    note("geohex: BV568");
    geohex_t zone = geohex_get_zone_by_code("BV568");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0919724386031L, -81.9753086419753L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0919724386031L, -82.4691358024691L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.055246359875L, -81.7283950617284L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.055246359875L, -82.716049382716L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0182461528016L, -81.9753086419753L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0182461528016L, -82.4691358024691L), "bottom.left");
  }
  {
    note("geohex: CZ335");
    geohex_t zone = geohex_get_zone_by_code("CZ335");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.6224251800773L, -11.6049382716049L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.6224251800773L, -12.0987654320987L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.5377483715364L, -11.358024691358L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.5377483715364L, -12.3456790123457L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.4524498534913L, -11.6049382716049L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.4524498534913L, -12.0987654320987L), "bottom.left");
  }
  {
    note("geohex: EU570");
    geohex_t zone = geohex_get_zone_by_code("EU570");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-76.7076757831938L, 175.802469135802L), "top.right");
    location_is(polygon.top.left, geohex_location(-76.7076757831938L, 175.308641975309L), "top.left");
    location_is(polygon.middle.right, geohex_location(-76.6089889314605L, 176.049382716049L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-76.6089889314605L, 175.061728395062L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-76.5095828813868L, 175.802469135802L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-76.5095828813868L, 175.308641975309L), "bottom.left");
  }
  {
    note("geohex: EU868");
    geohex_t zone = geohex_get_zone_by_code("EU868");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-75.6878448523063L, -175.308641975309L), "top.right");
    location_is(polygon.top.left, geohex_location(-75.6878448523063L, -175.802469135802L), "top.left");
    location_is(polygon.middle.right, geohex_location(-75.5817404649569L, -175.061728395062L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-75.5817404649569L, -176.049382716049L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-75.4748662596862L, -175.308641975309L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-75.4748662596862L, -175.802469135802L), "bottom.left");
  }
  {
    note("geohex: OK468");
    geohex_t zone = geohex_get_zone_by_code("OK468");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-49.6124416615636L, 64.6913580246913L), "top.right");
    location_is(polygon.top.left, geohex_location(-49.6124416615636L, 64.1975308641975L), "top.left");
    location_is(polygon.middle.right, geohex_location(-49.3345448501638L, 64.9382716049383L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-49.3345448501638L, 63.9506172839506L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-49.055070190506L, 64.6913580246913L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-49.055070190506L, 64.1975308641975L), "bottom.left");
  }
  {
    note("geohex: OY443");
    geohex_t zone = geohex_get_zone_by_code("OY443");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-0.855301964409653L, 0.987654320987654L), "top.right");
    location_is(polygon.top.left, geohex_location(-0.855301964409653L, 0.493827160493827L), "top.left");
    location_is(polygon.middle.right, geohex_location(-0.427662894935065L, 1.23456790123457L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-0.427662894935065L, 0.246913580246914L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(1.27222187258541e-14L, 0.987654320987654L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(1.27222187258541e-14L, 0.493827160493827L), "bottom.left");
  }
  {
    note("geohex: OY004");
    geohex_t zone = geohex_get_zone_by_code("OY004");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-10.6301566211044L, 0.246913580246914L), "top.right");
    location_is(polygon.top.left, geohex_location(-10.6301566211044L, -0.246913580246914L), "top.left");
    location_is(polygon.middle.right, geohex_location(-10.2095434727833L, 0.493827160493827L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-10.2095434727833L, -0.493827160493827L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-9.7883734846721L, 0.246913580246914L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-9.7883734846721L, -0.246913580246914L), "bottom.left");
  }
  {
    note("geohex: Fb526");
    geohex_t zone = geohex_get_zone_by_code("Fb526");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-47.6339545793101L, -109.382716049383L), "top.right");
    location_is(polygon.top.left, geohex_location(-47.6339545793101L, -109.876543209877L), "top.left");
    location_is(polygon.middle.right, geohex_location(-47.3449700820465L, -109.135802469136L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-47.3449700820465L, -110.123456790123L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.0543948474294L, -109.382716049383L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.0543948474294L, -109.876543209877L), "bottom.left");
  }
  {
    note("geohex: GH588");
    geohex_t zone = geohex_get_zone_by_code("GH588");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-16.0377167933024L, -166.41975308642L), "top.right");
    location_is(polygon.top.left, geohex_location(-16.0377167933024L, -166.913580246914L), "top.left");
    location_is(polygon.middle.right, geohex_location(-15.6262741560122L, -166.172839506173L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-15.6262741560122L, -167.160493827161L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-15.2140034644785L, -166.41975308642L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-15.2140034644785L, -166.913580246914L), "bottom.left");
  }
  {
    note("geohex: GI440");
    geohex_t zone = geohex_get_zone_by_code("GI440");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-12.724108773261L, -179.753086419753L), "top.right");
    location_is(polygon.top.left, geohex_location(-12.724108773261L, -180.246913580247L), "top.left");
    location_is(polygon.middle.right, geohex_location(-12.3066051591638L, -179.506172839506L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-12.3066051591638L, -180.493827160494L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.8884368016234L, -179.753086419753L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.8884368016234L, -180.246913580247L), "bottom.left");
  }
  {
    note("geohex: GI622");
    geohex_t zone = geohex_get_zone_by_code("GI622");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-11.8884368016234L, -172.345679012346L), "top.right");
    location_is(polygon.top.left, geohex_location(-11.8884368016234L, -172.839506172839L), "top.left");
    location_is(polygon.middle.right, geohex_location(-11.4696249513643L, -172.098765432099L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-11.4696249513643L, -173.086419753086L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.0501910292264L, -172.345679012346L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.0501910292264L, -172.839506172839L), "bottom.left");
  }
  {
    note("geohex: QU340");
    geohex_t zone = geohex_get_zone_by_code("QU340");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(6.40164208700372L, -173.086419753086L), "top.right");
    location_is(polygon.top.left, geohex_location(6.40164208700372L, -173.58024691358L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.82646163717905L, -172.83950617284L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.82646163717905L, -173.827160493827L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(7.25090445414504L, -173.086419753086L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(7.25090445414504L, -173.58024691358L), "bottom.left");
  }
  {
    note("geohex: QU026");
    geohex_t zone = geohex_get_zone_by_code("QU026");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(3.41930349159571L, 177.283950617284L), "top.right");
    location_is(polygon.top.left, geohex_location(3.41930349159571L, 176.79012345679L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.84611006144169L, 177.530864197531L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.84611006144169L, 176.543209876543L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(4.27270299638955L, 177.283950617284L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(4.27270299638955L, 176.79012345679L), "bottom.left");
  }
  {
    note("geohex: XM454");
    geohex_t zone = geohex_get_zone_by_code("XM454");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(33.4218747315811L, 138.024691358025L), "top.right");
    location_is(polygon.top.left, geohex_location(33.4218747315811L, 137.530864197531L), "top.left");
    location_is(polygon.middle.right, geohex_location(33.7780865480893L, 138.271604938272L), "middle.right");
    location_is(polygon.middle.left, geohex_location(33.7780865480893L, 137.283950617284L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(34.1328231890485L, 138.024691358025L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(34.1328231890485L, 137.530864197531L), "bottom.left");
  }
  {
    note("geohex: PS624");
    geohex_t zone = geohex_get_zone_by_code("PS624");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(22.0972549270129L, 129.135802469136L), "top.right");
    location_is(polygon.top.left, geohex_location(22.0972549270129L, 128.641975308642L), "top.left");
    location_is(polygon.middle.right, geohex_location(22.4929492879726L, 129.382716049383L), "middle.right");
    location_is(polygon.middle.left, geohex_location(22.4929492879726L, 128.395061728395L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(22.887515339138L, 129.135802469136L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(22.887515339138L, 128.641975308642L), "bottom.left");
  }
  {
    note("geohex: XX038");
    geohex_t zone = geohex_get_zone_by_code("XX038");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(44.0609594011089L, 142.469135802469L), "top.right");
    location_is(polygon.top.left, geohex_location(44.0609594011089L, 141.975308641975L), "top.left");
    location_is(polygon.middle.right, geohex_location(44.3674832423129L, 142.716049382716L), "middle.right");
    location_is(polygon.middle.left, geohex_location(44.3674832423129L, 141.728395061728L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(44.6724113934194L, 142.469135802469L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(44.6724113934194L, 141.975308641975L), "bottom.left");
  }
  {
    note("geohex: XU630");
    geohex_t zone = geohex_get_zone_by_code("XU630");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.9314177389891L, 135.802469135802L), "top.right");
    location_is(polygon.top.left, geohex_location(39.9314177389891L, 135.308641975309L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.2585722649131L, 136.049382716049L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.2585722649131L, 135.061728395062L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(40.5841525253636L, 135.802469135802L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(40.5841525253636L, 135.308641975309L), "bottom.left");
  }
  {
    note("geohex: PZ342");
    geohex_t zone = geohex_get_zone_by_code("PZ342");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(38.6071224301071L, 45.4320987654321L), "top.right");
    location_is(polygon.top.left, geohex_location(38.6071224301071L, 44.9382716049383L), "top.left");
    location_is(polygon.middle.right, geohex_location(38.9405407349711L, 45.679012345679L), "middle.right");
    location_is(polygon.middle.left, geohex_location(38.9405407349711L, 44.6913580246914L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(39.2723985350746L, 45.4320987654321L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(39.2723985350746L, 44.9382716049383L), "bottom.left");
  }
  {
    note("geohex: PZ580");
    geohex_t zone = geohex_get_zone_by_code("PZ580");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(45.5776197587709L, 33.5802469135803L), "top.right");
    location_is(polygon.top.left, geohex_location(45.5776197587709L, 33.0864197530864L), "top.left");
    location_is(polygon.middle.right, geohex_location(45.8761640952879L, 33.8271604938272L), "middle.right");
    location_is(polygon.middle.left, geohex_location(45.8761640952879L, 32.8395061728395L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(46.1731130979309L, 33.5802469135803L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(46.1731130979309L, 33.0864197530864L), "bottom.left");
  }
  {
    note("geohex: OY864");
    geohex_t zone = geohex_get_zone_by_code("OY864");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(7.25090445414505L, 4.69135802469136L), "top.right");
    location_is(polygon.top.left, geohex_location(7.25090445414505L, 4.19753086419753L), "top.left");
    location_is(polygon.middle.right, geohex_location(7.67494760129786L, 4.93827160493827L), "middle.right");
    location_is(polygon.middle.left, geohex_location(7.67494760129786L, 3.95061728395062L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(8.09856825123215L, 4.69135802469136L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(8.09856825123215L, 4.19753086419753L), "bottom.left");
  }
  {
    note("geohex: OY145");
    geohex_t zone = geohex_get_zone_by_code("OY145");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-3.84611006144169L, -7.1604938271605L), "top.right");
    location_is(polygon.top.left, geohex_location(-3.84611006144169L, -7.65432098765432L), "top.left");
    location_is(polygon.middle.right, geohex_location(-3.41930349159571L, -6.91358024691358L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-3.41930349159571L, -7.90123456790124L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-2.99230687435892L, -7.1604938271605L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-2.99230687435892L, -7.65432098765432L), "bottom.left");
  }
  {
    note("geohex: PA032");
    geohex_t zone = geohex_get_zone_by_code("PA032");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.13783810478654L, -59.0123456790123L), "top.right");
    location_is(polygon.top.left, geohex_location(2.13783810478654L, -59.5061728395062L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.56514384994961L, -58.7654320987654L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.56514384994961L, -59.7530864197531L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.99230687435894L, -59.0123456790123L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.99230687435894L, -59.5061728395062L), "bottom.left");
  }
  {
    note("geohex: OI758");
    geohex_t zone = geohex_get_zone_by_code("OI758");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(27.5289431930909L, -115.308641975309L), "top.right");
    location_is(polygon.top.left, geohex_location(27.5289431930909L, -115.802469135802L), "top.left");
    location_is(polygon.middle.right, geohex_location(27.9075323430044L, -115.061728395062L), "middle.right");
    location_is(polygon.middle.left, geohex_location(27.9075323430044L, -116.049382716049L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(28.2848011809809L, -115.308641975309L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(28.2848011809809L, -115.802469135802L), "bottom.left");
  }
  {
    note("geohex: SV428");
    geohex_t zone = geohex_get_zone_by_code("SV428");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(67.6058720425258L, -84.1975308641975L), "top.right");
    location_is(polygon.top.left, geohex_location(67.6058720425258L, -84.6913580246914L), "top.left");
    location_is(polygon.middle.right, geohex_location(67.7682415504757L, -83.9506172839506L), "middle.right");
    location_is(polygon.middle.left, geohex_location(67.7682415504757L, -84.9382716049383L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(67.929493065438L, -84.1975308641975L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(67.929493065438L, -84.6913580246914L), "bottom.left");
  }
  {
    note("geohex: SV385");
    geohex_t zone = geohex_get_zone_by_code("SV385");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(66.9450851987393L, -73.8271604938272L), "top.right");
    location_is(polygon.top.left, geohex_location(66.9450851987393L, -74.320987654321L), "top.left");
    location_is(polygon.middle.right, geohex_location(67.1119911384732L, -73.5802469135803L), "middle.right");
    location_is(polygon.middle.left, geohex_location(67.1119911384732L, -74.5679012345679L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(67.2777532865535L, -73.8271604938272L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(67.2777532865535L, -74.320987654321L), "bottom.left");
  }
  {
    note("geohex: aX355");
    geohex_t zone = geohex_get_zone_by_code("aX355");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(76.9994701395295L, 23.9506172839506L), "top.right");
    location_is(polygon.top.left, geohex_location(76.9994701395295L, 23.4567901234568L), "top.left");
    location_is(polygon.middle.right, geohex_location(77.0953290532401L, 24.1975308641975L), "middle.right");
    location_is(polygon.middle.left, geohex_location(77.0953290532401L, 23.2098765432099L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.1904930604711L, 23.9506172839506L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.1904930604711L, 23.4567901234568L), "bottom.left");
  }
  {
    note("geohex: aX568");
    geohex_t zone = geohex_get_zone_by_code("aX568");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.4524498534913L, 18.0246913580247L), "top.right");
    location_is(polygon.top.left, geohex_location(78.4524498534913L, 17.5308641975309L), "top.left");
    location_is(polygon.middle.right, geohex_location(78.5377483715365L, 18.2716049382716L), "middle.right");
    location_is(polygon.middle.left, geohex_location(78.5377483715365L, 17.2839506172839L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(78.6224251800773L, 18.0246913580247L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(78.6224251800773L, 17.5308641975309L), "bottom.left");
  }
  {
    note("geohex: bD744");
    geohex_t zone = geohex_get_zone_by_code("bD744");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.5817311155525L, -33.0864197530864L), "top.right");
    location_is(polygon.top.left, geohex_location(83.5817311155525L, -33.5802469135803L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.6293613243906L, -32.8395061728395L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.6293613243906L, -33.8271604938272L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.6766395147701L, -33.0864197530864L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.6766395147701L, -33.5802469135803L), "bottom.left");
  }
  {
    note("geohex: bD515");
    geohex_t zone = geohex_get_zone_by_code("bD515");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.4854042727994L, -49.3827160493827L), "top.right");
    location_is(polygon.top.left, geohex_location(83.4854042727994L, -49.8765432098765L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.5337463003993L, -49.1358024691358L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.5337463003993L, -50.1234567901234L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.5817311155524L, -49.3827160493827L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.5817311155524L, -49.8765432098765L), "bottom.left");
  }
  {
    note("geohex: bb337");
    geohex_t zone = geohex_get_zone_by_code("bb337");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0182461528016L, 89.8765432098766L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0182461528016L, 89.3827160493828L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.055246359875L, 90.1234567901235L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.055246359875L, 89.1358024691358L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0919724386032L, 89.8765432098766L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0919724386032L, 89.3827160493828L), "bottom.left");
  }
  {
    note("geohex: TO808");
    geohex_t zone = geohex_get_zone_by_code("TO808");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.94341521659L, -179.753086419753L), "top.right");
    location_is(polygon.top.left, geohex_location(84.94341521659L, -180.246913580247L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.9809697867981L, -179.506172839506L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.9809697867981L, -180.493827160494L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0182461528016L, -179.753086419753L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0182461528016L, -180.246913580247L), "bottom.left");
  }
  {
    note("geohex: TO428");
    geohex_t zone = geohex_get_zone_by_code("TO428");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.4702954814487L, 175.802469135802L), "top.right");
    location_is(polygon.top.left, geohex_location(84.4702954814487L, 175.308641975309L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.5113535162066L, 176.049382716049L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.5113535162066L, 175.061728395062L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.5521076214116L, 175.802469135802L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.5521076214116L, 175.308641975309L), "bottom.left");
  }
  {
    note("geohex: TO474");
    geohex_t zone = geohex_get_zone_by_code("TO474");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.5113535162065L, -177.530864197531L), "top.right");
    location_is(polygon.top.left, geohex_location(84.5113535162065L, -178.024691358025L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.5521076214116L, -177.283950617284L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.5521076214116L, -178.271604938272L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.5925600264163L, -177.530864197531L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.5925600264163L, -178.024691358025L), "bottom.left");
  }
  {
    note("geohex: TO073");
    geohex_t zone = geohex_get_zone_by_code("TO073");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.67663951477L, -176.79012345679L), "top.right");
    location_is(polygon.top.left, geohex_location(83.67663951477L, -177.283950617284L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.7235682563837L, -176.543209876543L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.7235682563837L, -177.530864197531L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.7701501008721L, -176.79012345679L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.7701501008721L, -177.283950617284L), "bottom.left");
  }
  {
    note("geohex: aB648");
    geohex_t zone = geohex_get_zone_by_code("aB648");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.2382434400818L, 173.58024691358L), "top.right");
    location_is(polygon.top.left, geohex_location(83.2382434400818L, 173.086419753086L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.2884112693828L, 173.827160493827L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.2884112693828L, 172.83950617284L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.3382085775188L, 173.58024691358L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.3382085775188L, 173.086419753086L), "bottom.left");
  }
  {
    note("geohex: YG168");
    geohex_t zone = geohex_get_zone_by_code("YG168");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(70.3626823791612L, 98.0246913580247L), "top.right");
    location_is(polygon.top.left, geohex_location(70.3626823791612L, 97.5308641975309L), "top.left");
    location_is(polygon.middle.right, geohex_location(70.5059021145644L, 98.2716049382716L), "middle.right");
    location_is(polygon.middle.left, geohex_location(70.5059021145644L, 97.283950617284L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(70.6481176492254L, 98.0246913580247L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(70.6481176492254L, 97.5308641975309L), "bottom.left");
  }
  {
    note("geohex: BV7511");
    geohex_t zone = geohex_get_zone_by_code("BV7511");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0797607463223L, -76.4609053497943L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0797607463223L, -76.6255144032922L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0675187449682L, -76.3786008230453L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0675187449682L, -76.7078189300412L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.055246359875L, -76.4609053497943L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.055246359875L, -76.6255144032922L), "bottom.left");
  }
  {
    note("geohex: BV7541");
    geohex_t zone = geohex_get_zone_by_code("BV7541");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0429435161968L, -75.7201646090535L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0429435161968L, -75.8847736625514L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0306101389078L, -75.6378600823045L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0306101389078L, -75.9670781893004L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0182461528016L, -75.7201646090535L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0182461528016L, -75.8847736625514L), "bottom.left");
  }
  {
    note("geohex: DO0532");
    geohex_t zone = geohex_get_zone_by_code("DO0532");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0675187449682L, 178.106995884774L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0675187449682L, 177.942386831276L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.055246359875L, 178.189300411523L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.055246359875L, 177.860082304527L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0429435161968L, 178.106995884774L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0429435161968L, 177.942386831276L), "bottom.left");
  }
  {
    note("geohex: DO3203");
    geohex_t zone = geohex_get_zone_by_code("DO3203");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.8929061314715L, -177.448559670782L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.8929061314715L, -177.61316872428L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.8802004327088L, -177.366255144033L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.8802004327088L, -177.695473251029L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.8674632084215L, -177.448559670782L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.8674632084215L, -177.61316872428L), "bottom.left");
  }
  {
    note("geohex: EU6235");
    geohex_t zone = geohex_get_zone_by_code("EU6235");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-77.6560557436566L, -170.534979423868L), "top.right");
    location_is(polygon.top.left, geohex_location(-77.6560557436566L, -170.699588477366L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.6255431823326L, -170.452674897119L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.6255431823326L, -170.781893004115L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.5949563773154L, -170.534979423868L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.5949563773154L, -170.699588477366L), "bottom.left");
  }
  {
    note("geohex: EU1425");
    geohex_t zone = geohex_get_zone_by_code("EU1425");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.3665252517046L, 171.687242798354L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.3665252517046L, 171.522633744856L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.3377438281995L, 171.769547325103L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.3377438281995L, 171.440329218107L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.3088921874373L, 171.687242798354L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.3088921874373L, 171.522633744856L), "bottom.left");
  }
  {
    note("geohex: OK7172");
    geohex_t zone = geohex_get_zone_by_code("OK7172");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-48.0167951988167L, 64.7736625514403L), "top.right");
    location_is(polygon.top.left, geohex_location(-48.0167951988167L, 64.6090534979424L), "top.left");
    location_is(polygon.middle.right, geohex_location(-47.9213497363355L, 64.8559670781893L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-47.9213497363355L, 64.5267489711934L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.8257278514634L, 64.7736625514403L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.8257278514634L, 64.6090534979424L), "bottom.left");
  }
  {
    note("geohex: CZ0737");
    geohex_t zone = geohex_get_zone_by_code("CZ0737");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.9550018802927L, -16.7078189300412L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.9550018802927L, -16.8724279835391L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.9276577201097L, -16.6255144032922L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.9276577201097L, -16.9547325102881L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.9002467107229L, -16.7078189300412L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.9002467107229L, -16.8724279835391L), "bottom.left");
  }
  {
    note("geohex: Fb0200");
    geohex_t zone = geohex_get_zone_by_code("Fb0200");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-55.3331528181034L, -104.362139917695L), "top.right");
    location_is(polygon.top.left, geohex_location(-55.3331528181034L, -104.526748971193L), "top.left");
    location_is(polygon.middle.right, geohex_location(-55.2519836552773L, -104.279835390947L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-55.2519836552773L, -104.609053497942L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-55.1706483838047L, -104.362139917695L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-55.1706483838047L, -104.526748971193L), "bottom.left");
  }
  {
    note("geohex: Fb8608");
    geohex_t zone = geohex_get_zone_by_code("Fb8608");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-45.1770783087657L, -95.4732510288066L), "top.right");
    location_is(polygon.top.left, geohex_location(-45.1770783087657L, -95.6378600823045L), "top.left");
    location_is(polygon.middle.right, geohex_location(-45.0764996106517L, -95.3909465020576L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-45.0764996106517L, -95.7201646090535L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-44.9757435695275L, -95.4732510288066L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-44.9757435695275L, -95.6378600823045L), "bottom.left");
  }
  {
    note("geohex: GH4405");
    geohex_t zone = geohex_get_zone_by_code("GH4405");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-23.2809376400502L, -160.164609053498L), "top.right");
    location_is(polygon.top.left, geohex_location(-23.2809376400502L, -160.329218106996L), "top.left");
    location_is(polygon.middle.right, geohex_location(-23.149924898842L, -160.082304526749L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-23.149924898842L, -160.411522633745L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-23.0187839444656L, -160.164609053498L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-23.0187839444656L, -160.329218106996L), "bottom.left");
  }
  {
    note("geohex: GI2651");
    geohex_t zone = geohex_get_zone_by_code("GI2651");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-11.3298817004596L, 170.205761316872L), "top.right");
    location_is(polygon.top.left, geohex_location(-11.3298817004596L, 170.041152263374L), "top.left");
    location_is(polygon.middle.right, geohex_location(-11.1900701265807L, 170.288065843621L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-11.1900701265807L, 169.958847736626L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-11.0501910292264L, 170.205761316872L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-11.0501910292264L, 170.041152263374L), "bottom.left");
  }
  {
    note("geohex: OC2121");
    geohex_t zone = geohex_get_zone_by_code("OC2121");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-1.56791611410211L, -177.201646090535L), "top.right");
    location_is(polygon.top.left, geohex_location(-1.56791611410211L, -177.366255144033L), "top.left");
    location_is(polygon.middle.right, geohex_location(-1.42540916199355L, -177.119341563786L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-1.42540916199355L, -177.448559670782L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-1.28289338959933L, -177.201646090535L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-1.28289338959933L, -177.366255144033L), "bottom.left");
  }
  {
    note("geohex: QU7871");
    geohex_t zone = geohex_get_zone_by_code("QU7871");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(17.8105946996974L, -172.757201646091L), "top.right");
    location_is(polygon.top.left, geohex_location(17.8105946996974L, -172.921810699589L), "top.left");
    location_is(polygon.middle.right, geohex_location(17.9462662786555L, -172.674897119342L), "middle.right");
    location_is(polygon.middle.left, geohex_location(17.9462662786555L, -173.004115226337L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(18.0818338870585L, -172.757201646091L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(18.0818338870585L, -172.921810699589L), "bottom.left");
  }
  {
    note("geohex: QU4212");
    geohex_t zone = geohex_get_zone_by_code("QU4212");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(10.9102452098912L, 174.40329218107L), "top.right");
    location_is(polygon.top.left, geohex_location(10.9102452098912L, 174.238683127572L), "top.left");
    location_is(polygon.middle.right, geohex_location(11.0501910292264L, 174.485596707819L), "middle.right");
    location_is(polygon.middle.left, geohex_location(11.0501910292264L, 174.156378600823L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(11.1900701265807L, 174.40329218107L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(11.1900701265807L, 174.238683127572L), "bottom.left");
  }
  {
    note("geohex: OK4362");
    geohex_t zone = geohex_get_zone_by_code("OK4362");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-50.7984896842917L, 63.2921810699589L), "top.right");
    location_is(polygon.top.left, geohex_location(-50.7984896842917L, 63.1275720164609L), "top.left");
    location_is(polygon.middle.right, geohex_location(-50.7083005615114L, 63.3744855967078L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-50.7083005615114L, 63.0452674897119L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-50.6179376039815L, 63.2921810699589L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-50.6179376039815L, 63.1275720164609L), "bottom.left");
  }
  {
    note("geohex: OX2538");
    geohex_t zone = geohex_get_zone_by_code("OX2538");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-10.490015464426L, 5.26748971193415L), "top.right");
    location_is(polygon.top.left, geohex_location(-10.490015464426L, 5.10288065843621L), "top.left");
    location_is(polygon.middle.right, geohex_location(-10.3498108112696L, 5.34979423868312L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-10.3498108112696L, 5.02057613168724L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-10.2095434727833L, 5.26748971193415L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-10.2095434727833L, 5.10288065843621L), "bottom.left");
  }
  {
    note("geohex: OY5663");
    geohex_t zone = geohex_get_zone_by_code("OY5663");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(3.5615946305499L, -0.411522633744855L), "top.right");
    location_is(polygon.top.left, geohex_location(3.5615946305499L, -0.576131687242798L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.7038637783779L, -0.329218106995884L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.7038637783779L, -0.658436213991769L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(3.84611006144169L, -0.411522633744855L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(3.84611006144169L, -0.576131687242798L), "bottom.left");
  }
  {
    note("geohex: OG6663");
    geohex_t zone = geohex_get_zone_by_code("OG6663");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-0.285110067403661L, -60.4115226337449L), "top.right");
    location_is(polygon.top.left, geohex_location(-0.285110067403661L, -60.5761316872428L), "top.left");
    location_is(polygon.middle.right, geohex_location(-0.142555474941371L, -60.3292181069959L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-0.142555474941371L, -60.6584362139918L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-1.27222187258541e-14L, -60.4115226337449L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-1.27222187258541e-14L, -60.5761316872428L), "bottom.left");
  }
  {
    note("geohex: PZ0631");
    geohex_t zone = geohex_get_zone_by_code("PZ0631");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(35.3045311082906L, 45.0205761316872L), "top.right");
    location_is(polygon.top.left, geohex_location(35.3045311082906L, 44.8559670781893L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.4207859134104L, 45.1028806584362L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.4207859134104L, 44.7736625514403L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.536873197198L, 45.0205761316872L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.536873197198L, 44.8559670781893L), "bottom.left");
  }
  {
    note("geohex: SV8518");
    geohex_t zone = geohex_get_zone_by_code("SV8518");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(70.5534185655184L, -82.8806584362139L), "top.right");
    location_is(polygon.top.left, geohex_location(70.5534185655184L, -83.0452674897119L), "top.left");
    location_is(polygon.middle.right, geohex_location(70.6008236675529L, -82.798353909465L), "middle.right");
    location_is(polygon.middle.left, geohex_location(70.6008236675529L, -83.1275720164609L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(70.6481176492254L, -82.8806584362139L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(70.6481176492254L, -83.0452674897119L), "bottom.left");
  }
  {
    note("geohex: TK3246");
    geohex_t zone = geohex_get_zone_by_code("TK3246");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.0729880787625L, -177.201646090535L), "top.right");
    location_is(polygon.top.left, geohex_location(81.0729880787625L, -177.366255144033L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.0950821454213L, -177.119341563786L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.0950821454213L, -177.448559670782L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.1171219698958L, -177.201646090535L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.1171219698958L, -177.366255144033L), "bottom.left");
  }
  {
    note("geohex: TK1825");
    geohex_t zone = geohex_get_zone_by_code("TK1825");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.4836247115025L, 171.687242798354L), "top.right");
    location_is(polygon.top.left, geohex_location(81.4836247115025L, 171.522633744856L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.5047101156331L, 171.769547325103L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.5047101156331L, 171.440329218107L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.5257436973084L, 171.687242798354L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.5257436973084L, 171.522633744856L), "bottom.left");
  }
  {
    note("geohex: aB6727");
    geohex_t zone = geohex_get_zone_by_code("aB6727");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.3382085775188L, 174.40329218107L), "top.right");
    location_is(polygon.top.left, geohex_location(83.3382085775188L, 174.238683127572L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.3547258092653L, 174.485596707819L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.3547258092653L, 174.156378600823L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.371202271563L, 174.40329218107L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.371202271563L, 174.238683127572L), "bottom.left");
  }
  {
    note("geohex: TR1202");
    geohex_t zone = geohex_get_zone_by_code("TR1202");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0429435161969L, -171.522633744856L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0429435161969L, -171.687242798354L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.055246359875L, -171.440329218107L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.055246359875L, -171.769547325103L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0675187449683L, -171.522633744856L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0675187449683L, -171.687242798354L), "bottom.left");
  }
  {
    note("geohex: bD4054");
    geohex_t zone = geohex_get_zone_by_code("bD4054");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.9117325442845L, -40.6584362139918L), "top.right");
    location_is(polygon.top.left, geohex_location(82.9117325442845L, -40.8230452674897L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.9293019627422L, -40.5761316872428L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.9293019627422L, -40.9053497942387L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.9468280533026L, -40.6584362139918L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.9468280533026L, -40.8230452674897L), "bottom.left");
  }
  {
    note("geohex: aX4486");
    geohex_t zone = geohex_get_zone_by_code("aX4486");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(77.7168588212124L, 20.5761316872428L), "top.right");
    location_is(polygon.top.left, geohex_location(77.7168588212124L, 20.4115226337449L), "top.left");
    location_is(polygon.middle.right, geohex_location(77.747149679606L, 20.6584362139918L), "middle.right");
    location_is(polygon.middle.left, geohex_location(77.747149679606L, 20.3292181069959L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.7773669786304L, 20.5761316872428L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.7773669786304L, 20.4115226337449L), "bottom.left");
  }
  {
    note("geohex: ZA5685");
    geohex_t zone = geohex_get_zone_by_code("ZA5685");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(76.0015908094264L, 117.61316872428L), "top.right");
    location_is(polygon.top.left, geohex_location(76.0015908094264L, 117.448559670782L), "top.left");
    location_is(polygon.middle.right, geohex_location(76.0360327020615L, 117.695473251029L), "middle.right");
    location_is(polygon.middle.left, geohex_location(76.0360327020615L, 117.366255144033L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(76.0703915338015L, 117.61316872428L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(76.0703915338015L, 117.448559670782L), "bottom.left");
  }
  {
    note("geohex: XM4881");
    geohex_t zone = geohex_get_zone_by_code("XM4881");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(35.3045311082906L, 139.835390946502L), "top.right");
    location_is(polygon.top.left, geohex_location(35.3045311082906L, 139.670781893004L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.4207859134104L, 139.917695473251L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.4207859134104L, 139.588477366255L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.536873197198L, 139.835390946502L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.536873197198L, 139.670781893004L), "bottom.left");
  }
  {
    note("geohex: XU6302");
    geohex_t zone = geohex_get_zone_by_code("XU6302");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(40.1496955258122L, 135.144032921811L), "top.right");
    location_is(polygon.top.left, geohex_location(40.1496955258122L, 134.979423868313L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.2585722649131L, 135.22633744856L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.2585722649131L, 134.897119341564L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(40.3672740838274L, 135.144032921811L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(40.3672740838274L, 134.979423868313L), "bottom.left");
  }
  {
    note("geohex: XX0337");
    geohex_t zone = geohex_get_zone_by_code("XX0337");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.4431267092789L, 143.292181069959L), "top.right");
    location_is(polygon.top.left, geohex_location(43.4431267092789L, 143.127572016461L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.5465417115035L, 143.374485596708L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.5465417115035L, 143.045267489712L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.6497795982984L, 143.292181069959L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.6497795982984L, 143.127572016461L), "bottom.left");
  }
  {
    note("geohex: XM6425");
    geohex_t zone = geohex_get_zone_by_code("XM6425");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(32.7050565948485L, 151.687242798354L), "top.right");
    location_is(polygon.top.left, geohex_location(32.7050565948485L, 151.522633744856L), "top.left");
    location_is(polygon.middle.right, geohex_location(32.8249312089187L, 151.769547325103L), "middle.right");
    location_is(polygon.middle.left, geohex_location(32.8249312089187L, 151.440329218107L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(32.9446442554393L, 151.687242798354L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(32.9446442554393L, 151.522633744856L), "bottom.left");
  }
  {
    note("geohex: PS6270");
    geohex_t zone = geohex_get_zone_by_code("PS6270");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(22.4929492879726L, 129.711934156379L), "top.right");
    location_is(polygon.top.left, geohex_location(22.4929492879726L, 129.547325102881L), "top.left");
    location_is(polygon.middle.right, geohex_location(22.6245974406222L, 129.794238683128L), "middle.right");
    location_is(polygon.middle.left, geohex_location(22.6245974406222L, 129.465020576132L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(22.7561196483026L, 129.711934156379L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(22.7561196483026L, 129.547325102881L), "bottom.left");
  }
  {
    note("geohex: BV80302");
    geohex_t zone = geohex_get_zone_by_code("BV80302");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0838346744086L, -79.3964334705075L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0838346744086L, -79.4513031550068L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0797607463223L, -79.3689986282579L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0797607463223L, -79.4787379972565L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0756834505626L, -79.3964334705075L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0756834505626L, -79.4513031550068L), "bottom.left");
  }
  {
    note("geohex: BV80373");
    geohex_t zone = geohex_get_zone_by_code("BV80373");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, -78.9026063100137L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, -78.957475994513L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0470478530043L, -78.875171467764L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0470478530043L, -78.9849108367626L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0429435161968L, -78.9026063100137L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0429435161968L, -78.957475994513L), "bottom.left");
  }
  {
    note("geohex: DO08354");
    geohex_t zone = geohex_get_zone_by_code("DO08354");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9350317687854L, -179.478737997256L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9350317687854L, -179.533607681756L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9308348477316L, -179.451303155007L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9308348477316L, -179.561042524005L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9266344581218L, -179.478737997256L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9266344581218L, -179.533607681756L), "bottom.left");
  }
  {
    note("geohex: DO05758");
    geohex_t zone = geohex_get_zone_by_code("DO05758");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9643133350153L, 178.299039780521L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9643133350153L, 178.244170096022L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9601406144117L, 178.326474622771L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9601406144117L, 178.216735253772L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9559644450966L, 178.299039780521L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9559644450966L, 178.244170096022L), "bottom.left");
  }
  {
    note("geohex: EU31135");
    geohex_t zone = geohex_get_zone_by_code("EU31135");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.7343679987212L, -176.104252400549L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.7343679987212L, -176.159122085048L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.7250810999821L, -176.076817558299L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.7250810999821L, -176.186556927298L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.7157866446833L, -176.104252400549L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.7157866446833L, -176.159122085048L), "bottom.left");
  }
  {
    note("geohex: EU45042");
    geohex_t zone = geohex_get_zone_by_code("EU45042");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-77.4821667810886L, 177.64060356653L), "top.right");
    location_is(polygon.top.left, geohex_location(-77.4821667810886L, 177.58573388203L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.4718632770568L, 177.668038408779L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.4718632770568L, 177.558299039781L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.4615514278509L, 177.64060356653L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.4615514278509L, 177.58573388203L), "bottom.left");
  }
  {
    note("geohex: CZ35087");
    geohex_t zone = geohex_get_zone_by_code("CZ35087");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.2219143202323L, -15.4458161865569L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.2219143202323L, -15.5006858710562L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.2122108191318L, -15.4183813443073L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.2122108191318L, -15.5281207133059L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.2024994369026L, -15.4458161865569L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.2024994369026L, -15.5006858710562L), "bottom.left");
  }
  {
    note("geohex: OK06445");
    geohex_t zone = geohex_get_zone_by_code("OK06445");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-54.5966358085242L, 64.3895747599451L), "top.right");
    location_is(polygon.top.left, geohex_location(-54.5966358085242L, 64.3347050754458L), "top.left");
    location_is(polygon.middle.right, geohex_location(-54.5690976325026L, 64.4170096021948L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-54.5690976325026L, 64.3072702331961L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-54.5415408406897L, 64.3895747599451L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-54.5415408406897L, 64.3347050754458L), "bottom.left");
  }
  {
    note("geohex: Fb80457");
    geohex_t zone = geohex_get_zone_by_code("Fb80457");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-46.3701930882356L, -100.137174211248L), "top.right");
    location_is(polygon.top.left, geohex_location(-46.3701930882356L, -100.192043895748L), "top.left");
    location_is(polygon.middle.right, geohex_location(-46.3373956350873L, -100.109739368999L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-46.3373956350873L, -100.219478737997L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-46.3045784985401L, -100.137174211248L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-46.3045784985401L, -100.192043895748L), "bottom.left");
  }
  {
    note("geohex: GH80422");
    geohex_t zone = geohex_get_zone_by_code("GH80422");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-17.7200895554267L, -160.631001371742L), "top.right");
    location_is(polygon.top.left, geohex_location(-17.7200895554267L, -160.685871056241L), "top.left");
    location_is(polygon.middle.right, geohex_location(-17.6748198317407L, -160.603566529492L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-17.6748198317407L, -160.713305898491L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-17.6295387075199L, -160.631001371742L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-17.6295387075199L, -160.685871056241L), "bottom.left");
  }
  {
    note("geohex: GI74753");
    geohex_t zone = geohex_get_zone_by_code("GI74753");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-7.20376345934287L, -172.729766803841L), "top.right");
    location_is(polygon.top.left, geohex_location(-7.20376345934287L, -172.78463648834L), "top.left");
    location_is(polygon.middle.right, geohex_location(-7.15661756163309L, -172.702331961591L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-7.15661756163309L, -172.81207133059L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-7.10946679243079L, -172.729766803841L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-7.10946679243079L, -172.78463648834L), "bottom.left");
  }
  {
    note("geohex: GI80240");
    geohex_t zone = geohex_get_zone_by_code("GI80240");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-6.54328904282261L, 178.545953360768L), "top.right");
    location_is(polygon.top.left, geohex_location(-6.54328904282261L, 178.491083676269L), "top.left");
    location_is(polygon.middle.right, geohex_location(-6.49607781033387L, 178.573388203018L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-6.49607781033387L, 178.463648834019L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-6.44886214784392L, 178.545953360768L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-6.44886214784392L, 178.491083676269L), "bottom.left");
  }
  {
    note("geohex: QU01265");
    geohex_t zone = geohex_get_zone_by_code("QU01265");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.56514384994961L, 176.735253772291L), "top.right");
    location_is(polygon.top.left, geohex_location(2.56514384994961L, 176.680384087792L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.61261388974431L, 176.76268861454L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.61261388974431L, 176.652949245542L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.66008213499604L, 176.735253772291L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.66008213499604L, 176.680384087792L), "bottom.left");
  }
  {
    note("geohex: QU86344");
    geohex_t zone = geohex_get_zone_by_code("QU86344");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(18.4428340565478L, -174.787379972565L), "top.right");
    location_is(polygon.top.left, geohex_location(18.4428340565478L, -174.842249657064L), "top.left");
    location_is(polygon.middle.right, geohex_location(18.4879061162228L, -174.759945130316L), "middle.right");
    location_is(polygon.middle.left, geohex_location(18.4879061162228L, -174.869684499314L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(18.5329663238589L, -174.787379972565L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(18.5329663238589L, -174.842249657064L), "bottom.left");
  }
  {
    note("geohex: OY77334");
    geohex_t zone = geohex_get_zone_by_code("OY77334");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(4.50959809697502L, 9.9039780521262L), "top.right");
    location_is(polygon.top.left, geohex_location(4.50959809697502L, 9.84910836762688L), "top.left");
    location_is(polygon.middle.right, geohex_location(4.55696797874602L, 9.93141289437586L), "middle.right");
    location_is(polygon.middle.left, geohex_location(4.55696797874602L, 9.82167352537723L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(4.60433473930148L, 9.9039780521262L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(4.60433473930148L, 9.84910836762688L), "bottom.left");
  }
  {
    note("geohex: OY15454");
    geohex_t zone = geohex_get_zone_by_code("OY15454");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-2.47019851680954L, -9.10836762688614L), "top.right");
    location_is(polygon.top.left, geohex_location(-2.47019851680954L, -9.16323731138546L), "top.left");
    location_is(polygon.middle.right, geohex_location(-2.42272328851834L, -9.08093278463648L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-2.42272328851834L, -9.19067215363511L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-2.3752463957922L, -9.10836762688614L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-2.3752463957922L, -9.16323731138546L), "bottom.left");
  }
  {
    note("geohex: PA04170");
    geohex_t zone = geohex_get_zone_by_code("PA04170");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(3.41930349159573L, -60.4663923182442L), "top.right");
    location_is(polygon.top.left, geohex_location(3.41930349159573L, -60.5212620027435L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.46673626074913L, -60.4389574759945L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.46673626074913L, -60.5486968449931L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(3.51416665119458L, -60.4663923182442L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(3.51416665119458L, -60.5212620027435L), "bottom.left");
  }
  {
    note("geohex: PS62113");
    geohex_t zone = geohex_get_zone_by_code("PS62113");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.8769429534219L, 128.0109739369L), "top.right");
    location_is(polygon.top.left, geohex_location(21.8769429534219L, 127.956104252401L), "top.left");
    location_is(polygon.middle.right, geohex_location(21.921032689852L, 128.03840877915L), "middle.right");
    location_is(polygon.middle.left, geohex_location(21.921032689852L, 127.928669410151L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.9651087772564L, 128.0109739369L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.9651087772564L, 127.956104252401L), "bottom.left");
  }
  {
    note("geohex: PS68342");
    geohex_t zone = geohex_get_zone_by_code("PS68342");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(24.4109283625301L, 133.936899862826L), "top.right");
    location_is(polygon.top.left, geohex_location(24.4109283625301L, 133.882030178326L), "top.left");
    location_is(polygon.middle.right, geohex_location(24.4541915572933L, 133.964334705075L), "middle.right");
    location_is(polygon.middle.left, geohex_location(24.4541915572933L, 133.854595336077L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(24.4974399012965L, 133.936899862826L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(24.4974399012965L, 133.882030178326L), "bottom.left");
  }
  {
    note("geohex: XM78145");
    geohex_t zone = geohex_get_zone_by_code("XM78145");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(37.597545701302L, 145.871056241427L), "top.right");
    location_is(polygon.top.left, geohex_location(37.597545701302L, 145.816186556927L), "top.left");
    location_is(polygon.middle.right, geohex_location(37.6351858644021L, 145.898491083676L), "middle.right");
    location_is(polygon.middle.left, geohex_location(37.6351858644021L, 145.788751714678L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(37.6728069702087L, 145.871056241427L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(37.6728069702087L, 145.816186556927L), "bottom.left");
  }
  {
    note("geohex: XM48257");
    geohex_t zone = geohex_get_zone_by_code("XM48257");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(34.9547639560787L, 138.38134430727L), "top.right");
    location_is(polygon.top.left, geohex_location(34.9547639560787L, 138.326474622771L), "top.left");
    location_is(polygon.middle.right, geohex_location(34.9937011179371L, 138.40877914952L), "middle.right");
    location_is(polygon.middle.left, geohex_location(34.9937011179371L, 138.299039780521L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.0326197647605L, 138.38134430727L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.0326197647605L, 138.326474622771L), "bottom.left");
  }
  {
    note("geohex: XX03156");
    geohex_t zone = geohex_get_zone_by_code("XX03156");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.5120897219759L, 141.426611796982L), "top.right");
    location_is(polygon.top.left, geohex_location(43.5120897219759L, 141.371742112483L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.5465417115035L, 141.454046639232L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.5465417115035L, 141.344307270233L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.5809740215196L, 141.426611796982L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.5809740215196L, 141.371742112483L), "bottom.left");
  }
  {
    note("geohex: PZ47685");
    geohex_t zone = geohex_get_zone_by_code("PZ47685");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.0276962541387L, 43.6488340192044L), "top.right");
    location_is(polygon.top.left, geohex_location(43.0276962541387L, 43.5939643347051L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.0624236158088L, 43.676268861454L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.0624236158088L, 43.5665294924554L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.0971313176636L, 43.6488340192044L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.0971313176636L, 43.5939643347051L), "bottom.left");
  }
  {
    note("geohex: SV40654");
    geohex_t zone = geohex_get_zone_by_code("SV40654");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(66.4754021607312L, -78.7379972565158L), "top.right");
    location_is(polygon.top.left, geohex_location(66.4754021607312L, -78.7928669410151L), "top.left");
    location_is(polygon.middle.right, geohex_location(66.4943616312731L, -78.7105624142661L), "middle.right");
    location_is(polygon.middle.left, geohex_location(66.4943616312731L, -78.8203017832647L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(66.5133066879411L, -78.7379972565158L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(66.5133066879411L, -78.7928669410151L), "bottom.left");
  }
  {
    note("geohex: OI71873");
    geohex_t zone = geohex_get_zone_by_code("OI71873");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(25.6594611871118L, -115.19890260631L), "top.right");
    location_is(polygon.top.left, geohex_location(25.6594611871118L, -115.253772290809L), "top.left");
    location_is(polygon.middle.right, geohex_location(25.7022859273215L, -115.17146776406L), "middle.right");
    location_is(polygon.middle.left, geohex_location(25.7022859273215L, -115.281207133059L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(25.7450952667949L, -115.19890260631L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(25.7450952667949L, -115.253772290809L), "bottom.left");
  }
  {
    note("geohex: aX40264");
    geohex_t zone = geohex_get_zone_by_code("aX40264");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(76.9887760452365L, 19.039780521262L), "top.right");
    location_is(polygon.top.left, geohex_location(76.9887760452365L, 18.9849108367627L), "top.left");
    location_is(polygon.middle.right, geohex_location(76.9994701395296L, 19.0672153635117L), "middle.right");
    location_is(polygon.middle.left, geohex_location(76.9994701395296L, 18.957475994513L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.0101555954485L, 19.039780521262L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.0101555954485L, 18.9849108367627L), "bottom.left");
  }
  {
    note("geohex: ZA44552");
    geohex_t zone = geohex_get_zone_by_code("ZA44552");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(74.9534563911502L, 118.875171467764L), "top.right");
    location_is(polygon.top.left, geohex_location(74.9534563911502L, 118.820301783265L), "top.left");
    location_is(polygon.middle.right, geohex_location(74.9657874374314L, 118.902606310014L), "middle.right");
    location_is(polygon.middle.left, geohex_location(74.9657874374314L, 118.792866941015L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(74.9781086109047L, 118.875171467764L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(74.9781086109047L, 118.820301783265L), "bottom.left");
  }
  {
    note("geohex: bD47117");
    geohex_t zone = geohex_get_zone_by_code("bD47117");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.2717299624724L, -38.6556927297668L), "top.right");
    location_is(polygon.top.left, geohex_location(83.2717299624724L, -38.7105624142661L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.2772949786223L, -38.6282578875171L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.2772949786223L, -38.7379972565158L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.282855413019L, -38.6556927297668L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.282855413019L, -38.7105624142661L), "bottom.left");
  }
  {
    note("geohex: TK51615");
    geohex_t zone = geohex_get_zone_by_code("TK51615");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.0153225906358L, 172.290809327846L), "top.right");
    location_is(polygon.top.left, geohex_location(82.0153225906358L, 172.235939643347L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.0219205989575L, 172.318244170096L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.0219205989575L, 172.208504801097L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.0285131903759L, 172.290809327846L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.0285131903759L, 172.235939643347L), "bottom.left");
  }
  {
    note("geohex: TK71615");
    geohex_t zone = geohex_get_zone_by_code("TK71615");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.0153225906358L, -174.37585733882L), "top.right");
    location_is(polygon.top.left, geohex_location(82.0153225906358L, -174.43072702332L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.0219205989575L, -174.348422496571L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.0219205989575L, -174.458161865569L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.0285131903759L, -174.37585733882L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.0285131903759L, -174.43072702332L), "bottom.left");
  }
  {
    note("geohex: TO38458");
    geohex_t zone = geohex_get_zone_by_code("TO38458");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.3218160738426L, -173.552812071331L), "top.right");
    location_is(polygon.top.left, geohex_location(84.3218160738426L, -173.60768175583L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.3265156597377L, -173.525377229081L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.3265156597377L, -173.63511659808L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.3312113687006L, -173.552812071331L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.3312113687006L, -173.60768175583L), "bottom.left");
  }
  {
    note("geohex: TO58484");
    geohex_t zone = geohex_get_zone_by_code("TO58484");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0388357867675L, 173.360768175583L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0388357867675L, 173.305898491084L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0429435161968L, 173.388203017833L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0429435161968L, 173.278463648834L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0470478530043L, 173.360768175583L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0470478530043L, 173.305898491084L), "bottom.left");
  }
  {
    note("geohex: BV553581");
    geohex_t zone = geohex_get_zone_by_code("BV553581");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0374657892273L, -88.4133516232281L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0374657892273L, -88.4316415180612L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0360954143169L, -88.4042066758116L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0360954143169L, -88.4407864654778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0347246619329L, -88.4133516232281L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0347246619329L, -88.4316415180612L), "bottom.left");
  }
  {
    note("geohex: CI802417");
    geohex_t zone = geohex_get_zone_by_code("CI802417");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0223708871332L, 118.472793781436L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0223708871332L, 118.454503886603L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.020996354334L, 118.481938728852L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.020996354334L, 118.445358939186L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0196214429246L, 118.472793781436L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0196214429246L, 118.454503886603L), "bottom.left");
  }
  {
    note("geohex: CI750110");
    geohex_t zone = geohex_get_zone_by_code("CI750110");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1122581078036L, 124.124371284865L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1122581078036L, 124.106081390032L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1109083358255L, 124.133516232282L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1109083358255L, 124.096936442615L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.1095581920072L, 124.124371284865L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.1095581920072L, 124.106081390032L), "bottom.left");
  }
  {
    note("geohex: DO018862");
    geohex_t zone = geohex_get_zone_by_code("DO018862");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1418592212103L, 177.896662094193L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1418592212103L, 177.87837219936L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1405176040458L, 177.90580704161L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1405176040458L, 177.869227251943L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.1391756172713L, 177.896662094193L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.1391756172713L, 177.87837219936L), "bottom.left");
  }
  {
    note("geohex: DO053505");
    geohex_t zone = geohex_get_zone_by_code("DO053505");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, 178.253315043439L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, 178.235025148605L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.049782194126L, 178.262459990855L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.049782194126L, 178.225880201189L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0484152118382L, 178.253315043439L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0484152118382L, 178.235025148605L), "bottom.left");
  }
  {
    note("geohex: DO074664");
    geohex_t zone = geohex_get_zone_by_code("DO074664");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0196214429246L, -177.110196616369L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0196214429246L, -177.128486511203L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0182461528016L, -177.101051668953L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0182461528016L, -177.137631458619L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0168704838614L, -177.110196616369L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0168704838614L, -177.128486511203L), "bottom.left");
  }
  {
    note("geohex: CZ351822");
    geohex_t zone = geohex_get_zone_by_code("CZ351822");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.1375550297113L, -16.506630086877L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.1375550297113L, -16.5249199817101L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.1342985749577L, -16.4974851394605L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.1342985749577L, -16.5340649291267L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.131041239069L, -16.506630086877L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.131041239069L, -16.5249199817101L), "bottom.left");
  }
  {
    note("geohex: EU412420");
    geohex_t zone = geohex_get_zone_by_code("EU412420");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-77.8475889011933L, 176.140832190215L), "top.right");
    location_is(polygon.top.left, geohex_location(-77.8475889011933L, 176.122542295382L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.8442540286679L, 176.149977137632L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.8442540286679L, 176.113397347965L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.8409182547605L, 176.140832190215L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.8409182547605L, 176.122542295382L), "bottom.left");
  }
  {
    note("geohex: EU708101");
    geohex_t zone = geohex_get_zone_by_code("EU708101");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-77.1553278534821L, -173.598536808413L), "top.right");
    location_is(polygon.top.left, geohex_location(-77.1553278534821L, -173.616826703246L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.1518061167366L, -173.589391860997L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.1518061167366L, -173.625971650663L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.1482834306493L, -173.598536808413L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.1482834306493L, -173.616826703246L), "bottom.left");
  }
  {
    note("geohex: OK847038");
    geohex_t zone = geohex_get_zone_by_code("OK847038");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-44.5935091871764L, 60.8321902149063L), "top.right");
    location_is(polygon.top.left, geohex_location(-44.5935091871764L, 60.8139003200732L), "top.left");
    location_is(polygon.middle.right, geohex_location(-44.5822286864963L, 60.8413351623228L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-44.5822286864963L, 60.8047553726566L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-44.5709459966191L, 60.8321902149063L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-44.5709459966191L, 60.8139003200732L), "bottom.left");
  }
  {
    note("geohex: GH501658");
    geohex_t zone = geohex_get_zone_by_code("GH501658");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-21.6415680809959L, -166.986739826246L), "top.right");
    location_is(polygon.top.left, geohex_location(-21.6415680809959L, -167.005029721079L), "top.left");
    location_is(polygon.middle.right, geohex_location(-21.6268443575399L, -166.977594878829L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-21.6268443575399L, -167.014174668496L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-21.6121191338212L, -166.986739826246L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-21.6121191338212L, -167.005029721079L), "bottom.left");
  }
  {
    note("geohex: GI842644");
    geohex_t zone = geohex_get_zone_by_code("GI842644");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-3.86191375467323L, 179.021490626429L), "top.right");
    location_is(polygon.top.left, geohex_location(-3.86191375467323L, 179.003200731596L), "top.left");
    location_is(polygon.middle.right, geohex_location(-3.84611006144169L, 179.030635573846L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-3.84611006144169L, 178.994055784179L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-3.83030607515138L, 179.021490626429L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-3.83030607515138L, 179.003200731596L), "bottom.left");
  }
  {
    note("geohex: GI836575");
    geohex_t zone = geohex_get_zone_by_code("GI836575");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-4.93581196869263L, -176.479195244627L), "top.right");
    location_is(polygon.top.left, geohex_location(-4.93581196869263L, -176.49748513946L), "top.left");
    location_is(polygon.middle.right, geohex_location(-4.92003100511791L, -176.470050297211L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-4.92003100511791L, -176.506630086877L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-4.90424966737299L, -176.479195244627L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-4.90424966737299L, -176.49748513946L), "bottom.left");
  }
  {
    note("geohex: QU316588");
    geohex_t zone = geohex_get_zone_by_code("QU316588");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(6.65343117983402L, -174.311842706904L), "top.right");
    location_is(polygon.top.left, geohex_location(6.65343117983402L, -174.330132601738L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.6691637644673L, -174.302697759488L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.6691637644673L, -174.339277549154L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(6.68489584399763L, -174.311842706904L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(6.68489584399763L, -174.330132601738L), "bottom.left");
  }
  {
    note("geohex: QU175485");
    geohex_t zone = geohex_get_zone_by_code("QU175485");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(9.46042596144656L, 174.796524919982L), "top.right");
    location_is(polygon.top.left, geohex_location(9.46042596144656L, 174.778235025149L), "top.left");
    location_is(polygon.middle.right, geohex_location(9.47604969238702L, 174.805669867398L), "middle.right");
    location_is(polygon.middle.left, geohex_location(9.47604969238702L, 174.769090077732L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(9.49167271224977L, 174.796524919982L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(9.49167271224977L, 174.778235025149L), "bottom.left");
  }
  {
    note("geohex: Fb711277");
    geohex_t zone = geohex_get_zone_by_code("Fb711277");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-48.4598765064117L, -96.671239140375L), "top.right");
    location_is(polygon.top.left, geohex_location(-48.4598765064117L, -96.6895290352081L), "top.left");
    location_is(polygon.middle.right, geohex_location(-48.4493715354198L, -96.6620941929584L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-48.4493715354198L, -96.6986739826246L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-48.4388643908495L, -96.671239140375L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-48.4388643908495L, -96.6895290352081L), "bottom.left");
  }
  {
    note("geohex: OY728344");
    geohex_t zone = geohex_get_zone_by_code("OY728344");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(4.54117836336873L, 2.47828074988569L), "top.right");
    location_is(polygon.top.left, geohex_location(4.54117836336873L, 2.45999085505258L), "top.left");
    location_is(polygon.middle.right, geohex_location(4.55696797874602L, 2.48742569730224L), "middle.right");
    location_is(polygon.middle.left, geohex_location(4.55696797874602L, 2.45084590763603L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(4.57275724732149L, 2.47828074988569L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(4.57275724732149L, 2.45999085505258L), "bottom.left");
  }
  {
    note("geohex: PA016372");
    geohex_t zone = geohex_get_zone_by_code("PA016372");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.45437362765821L, -60.4572473708276L), "top.right");
    location_is(polygon.top.left, geohex_location(2.45437362765821L, -60.4755372656607L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.47019851680954L, -60.4481024234111L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.47019851680954L, -60.4846822130773L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.48602321740854L, -60.4572473708276L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.48602321740854L, -60.4755372656607L), "bottom.left");
  }
  {
    note("geohex: QU408880");
    geohex_t zone = geohex_get_zone_by_code("QU408880");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(10.1159974900213L, -179.990855052583L), "top.right");
    location_is(polygon.top.left, geohex_location(10.1159974900213L, -180.009144947417L), "top.left");
    location_is(polygon.middle.right, geohex_location(10.1315903865524L, -179.981710105167L), "middle.right");
    location_is(polygon.middle.left, geohex_location(10.1315903865524L, -180.018289894833L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(10.1471825248119L, -179.990855052583L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(10.1471825248119L, -180.009144947417L), "bottom.left");
  }
  {
    note("geohex: XM442337");
    geohex_t zone = geohex_get_zone_by_code("XM442337");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(32.5449729805341L, 138.884316415181L), "top.right");
    location_is(polygon.top.left, geohex_location(32.5449729805341L, 138.866026520348L), "top.left");
    location_is(polygon.middle.right, geohex_location(32.5583242135466L, 138.893461362597L), "middle.right");
    location_is(polygon.middle.left, geohex_location(32.5583242135466L, 138.856881572931L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(32.5716734603819L, 138.884316415181L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(32.5716734603819L, 138.866026520348L), "bottom.left");
  }
  {
    note("geohex: PS387785");
    geohex_t zone = geohex_get_zone_by_code("PS387785");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.921032689852L, 127.636031092821L), "top.right");
    location_is(polygon.top.left, geohex_location(21.921032689852L, 127.617741197988L), "top.left");
    location_is(polygon.middle.right, geohex_location(21.935726236625L, 127.645176040238L), "middle.right");
    location_is(polygon.middle.left, geohex_location(21.935726236625L, 127.608596250572L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.9504182660296L, 127.636031092821L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.9504182660296L, 127.617741197988L), "bottom.left");
  }
  {
    note("geohex: XX037037");
    geohex_t zone = geohex_get_zone_by_code("XX037037");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.8214490692687L, 143.081847279378L), "top.right");
    location_is(polygon.top.left, geohex_location(43.8214490692687L, 143.063557384545L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.8328762014381L, 143.090992226795L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.8328762014381L, 143.054412437128L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.8443011459943L, 143.081847279378L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.8443011459943L, 143.063557384545L), "bottom.left");
  }
  {
    note("geohex: PZ173676");
    geohex_t zone = geohex_get_zone_by_code("PZ173676");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.6270959128635L, 36.936442615455L), "top.right");
    location_is(polygon.top.left, geohex_location(39.6270959128635L, 36.9181527206219L), "top.left");
    location_is(polygon.middle.right, geohex_location(39.6392946161491L, 36.9455875628715L), "middle.right");
    location_is(polygon.middle.left, geohex_location(39.6392946161491L, 36.9090077732053L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(39.6514911682249L, 36.936442615455L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(39.6514911682249L, 36.9181527206219L), "bottom.left");
  }
  {
    note("geohex: SV321726");
    geohex_t zone = geohex_get_zone_by_code("SV321726");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(65.7961777357975L, -78.3721993598537L), "top.right");
    location_is(polygon.top.left, geohex_location(65.7961777357975L, -78.3904892546868L), "top.left");
    location_is(polygon.middle.right, geohex_location(65.8026708623787L, -78.3630544124372L), "middle.right");
    location_is(polygon.middle.left, geohex_location(65.8026708623787L, -78.3996342021034L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(65.8091623518439L, -78.3721993598537L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(65.8091623518439L, -78.3904892546868L), "bottom.left");
  }
  {
    note("geohex: PC828583");
    geohex_t zone = geohex_get_zone_by_code("PC828583");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.7611633040255L, -104.654778235025L), "top.right");
    location_is(polygon.top.left, geohex_location(39.7611633040255L, -104.673068129858L), "top.left");
    location_is(polygon.middle.right, geohex_location(39.7733383345461L, -104.645633287609L), "middle.right");
    location_is(polygon.middle.left, geohex_location(39.7733383345461L, -104.682213077275L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(39.7855112119747L, -104.654778235025L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(39.7855112119747L, -104.673068129858L), "bottom.left");
  }
  {
    note("geohex: OI713375");
    geohex_t zone = geohex_get_zone_by_code("OI713375");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(24.3676503365825L, -114.503886602652L), "top.right");
    location_is(polygon.top.left, geohex_location(24.3676503365825L, -114.522176497485L), "top.left");
    location_is(polygon.middle.right, geohex_location(24.382077991931L, -114.494741655236L), "middle.right");
    location_is(polygon.middle.left, geohex_location(24.382077991931L, -114.531321444902L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(24.3965040008224L, -114.503886602652L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(24.3965040008224L, -114.522176497485L), "bottom.left");
  }
  {
    note("geohex: bD080050");
    geohex_t zone = geohex_get_zone_by_code("bD080050");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.4017627756988L, -40.0731595793324L), "top.right");
    location_is(polygon.top.left, geohex_location(82.4017627756988L, -40.0914494741655L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.4038568826114L, -40.0640146319159L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.4038568826114L, -40.1005944215821L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.4059504157635L, -40.0731595793324L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.4059504157635L, -40.0914494741655L), "bottom.left");
  }
  {
    note("geohex: aX817100");
    geohex_t zone = geohex_get_zone_by_code("aX817100");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.9002467107229L, 18.2807498856881L), "top.right");
    location_is(polygon.top.left, geohex_location(78.9002467107229L, 18.262459990855L), "top.left");
    location_is(polygon.middle.right, geohex_location(78.9032956845109L, 18.2898948331047L), "middle.right");
    location_is(polygon.middle.left, geohex_location(78.9032956845109L, 18.2533150434385L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(78.9063438312762L, 18.2807498856881L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(78.9063438312762L, 18.262459990855L), "bottom.left");
  }
  {
    note("geohex: ZA712478");
    geohex_t zone = geohex_get_zone_by_code("ZA712478");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(75.4907482535574L, 123.054412437128L), "top.right");
    location_is(polygon.top.left, geohex_location(75.4907482535574L, 123.036122542295L), "top.left");
    location_is(polygon.middle.right, geohex_location(75.4947160961744L, 123.063557384545L), "middle.right");
    location_is(polygon.middle.left, geohex_location(75.4947160961744L, 123.026977594879L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(75.4986828769816L, 123.054412437128L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(75.4986828769816L, 123.036122542295L), "bottom.left");
  }
  {
    note("geohex: TK166315");
    geohex_t zone = geohex_get_zone_by_code("TK166315");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.0656113135618L, 179.405578417924L), "top.right");
    location_is(polygon.top.left, geohex_location(81.0656113135618L, 179.387288523091L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.0680709068572L, 179.414723365341L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.0680709068572L, 179.378143575674L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.0705298285311L, 179.405578417924L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.0705298285311L, 179.387288523091L), "bottom.left");
  }
  {
    note("geohex: TK873482");
    geohex_t zone = geohex_get_zone_by_code("TK873482");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.833119279622L, -177.08276177412L), "top.right");
    location_is(polygon.top.left, geohex_location(82.833119279622L, -177.101051668953L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.8350951420659L, -177.073616826703L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.8350951420659L, -177.11019661637L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.837070462619L, -177.08276177412L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.837070462619L, -177.101051668953L), "bottom.left");
  }
  {
    note("geohex: TO433402");
    geohex_t zone = geohex_get_zone_by_code("TO433402");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.2492679792019L, -177.08276177412L), "top.right");
    location_is(polygon.top.left, geohex_location(84.2492679792019L, -177.101051668953L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.2508548924535L, -177.073616826703L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.2508548924535L, -177.11019661637L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.252441369267L, -177.08276177412L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.252441369267L, -177.101051668953L), "bottom.left");
  }
  {
    note("geohex: TO586342");
    geohex_t zone = geohex_get_zone_by_code("TO586342");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.004472399533L, 175.016003657979L), "top.right");
    location_is(polygon.top.left, geohex_location(85.004472399533L, 174.997713763146L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0058514824907L, 175.025148605396L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0058514824907L, 174.988568815729L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0072301856982L, 175.016003657979L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0072301856982L, 174.997713763146L), "bottom.left");
  }
  {
    note("geohex: bb335332");
    geohex_t zone = geohex_get_zone_by_code("bb335332");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0374657892273L, 88.4316415180613L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0374657892273L, 88.4133516232282L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0388357867675L, 88.4407864654778L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0388357867675L, 88.4042066758116L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0402054070403L, 88.4316415180613L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0402054070403L, 88.4133516232282L), "bottom.left");
  }
  {
    note("geohex: BV8032788");
    geohex_t zone = geohex_get_zone_by_code("BV8032788");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0479594674037L, -79.6677335771986L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0479594674037L, -79.6738302088096L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.047503681127L, -79.6646852613931L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.047503681127L, -79.6768785246151L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0470478530043L, -79.6677335771986L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0470478530043L, -79.6738302088096L), "bottom.left");
  }
  {
    note("geohex: CI7714524");
    geohex_t zone = geohex_get_zone_by_code("CI7714524");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0516042516161L, 128.014022252705L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0516042516161L, 128.007925621094L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511487999708L, 128.017070568511L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511487999708L, 128.004877305289L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0506933065099L, 128.014022252705L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0506933065099L, 128.007925621094L), "bottom.left");
  }
  {
    note("geohex: DO0514686");
    geohex_t zone = geohex_get_zone_by_code("DO0514686");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0529703556967L, 177.222984301174L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0529703556967L, 177.216887669563L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0525150294753L, 177.226032616979L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0525150294753L, 177.213839353757L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0520596614497L, 177.222984301174L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0520596614497L, 177.216887669563L), "bottom.left");
  }
  {
    note("geohex: DO0517300");
    geohex_t zone = geohex_get_zone_by_code("DO0517300");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, 177.369303459838L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, 177.363206828227L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0506933065098L, 177.372351775644L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0506933065098L, 177.360158512422L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0502377712295L, 177.369303459838L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0502377712295L, 177.363206828227L), "bottom.left");
  }
  {
    note("geohex: DO0732687");
    geohex_t zone = geohex_get_zone_by_code("DO0732687");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0525150294752L, -177.354061880811L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0525150294752L, -177.360158512422L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0520596614496L, -177.351013565005L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0520596614496L, -177.363206828227L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0516042516161L, -177.354061880811L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0516042516161L, -177.360158512422L), "bottom.left");
  }
  {
    note("geohex: DO0732768");
    geohex_t zone = geohex_get_zone_by_code("DO0732768");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0506933065098L, -177.390641670477L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0506933065098L, -177.396738302088L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0502377712295L, -177.387593354672L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0502377712295L, -177.399786617894L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.049782194126L, -177.390641670477L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.049782194126L, -177.396738302088L), "bottom.left");
  }
  {
    note("geohex: EU4031833");
    geohex_t zone = geohex_get_zone_by_code("EU4031833");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.2078956225948L, -179.466544734034L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.2078956225948L, -179.472641365645L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.2068165801529L, -179.463496418229L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.2068165801529L, -179.475689681451L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.2057374403711L, -179.466544734034L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.2057374403711L, -179.472641365645L), "bottom.left");
  }
  {
    note("geohex: EU8072131");
    geohex_t zone = geohex_get_zone_by_code("EU8072131");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-76.3260782057512L, -179.814052735863L), "top.right");
    location_is(polygon.top.left, geohex_location(-76.3260782057512L, -179.820149367474L), "top.left");
    location_is(polygon.middle.right, geohex_location(-76.3248300177426L, -179.811004420058L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-76.3248300177426L, -179.82319768328L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-76.3235817179685L, -179.814052735863L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-76.3235817179685L, -179.820149367474L), "bottom.left");
  }
  {
    note("geohex: EU8255485");
    geohex_t zone = geohex_get_zone_by_code("EU8255485");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-75.6447097334129L, 174.561804602957L), "top.right");
    location_is(polygon.top.left, geohex_location(-75.6447097334129L, 174.555707971346L), "top.left");
    location_is(polygon.middle.right, geohex_location(-75.6434006236876L, 174.564852918762L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-75.6434006236876L, 174.55265965554L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-75.6420913970892L, 174.561804602957L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-75.6420913970892L, 174.555707971346L), "bottom.left");
  }
  {
    note("geohex: CZ3800810");
    geohex_t zone = geohex_get_zone_by_code("CZ3800810");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.0624332391514L, -13.3577198597774L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.0624332391514L, -13.3638164913885L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.0613410780894L, -13.3546715439719L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.0613410780894L, -13.366864807194L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.0602488185566L, -13.3577198597774L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.0602488185566L, -13.3638164913885L), "bottom.left");
  }
  {
    note("geohex: OK1624776");
    geohex_t zone = geohex_get_zone_by_code("OK1624776");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-52.2696952176244L, 56.4273738759335L), "top.right");
    location_is(polygon.top.left, geohex_location(-52.2696952176244L, 56.4212772443225L), "top.left");
    location_is(polygon.middle.right, geohex_location(-52.2664641271478L, 56.430422191739L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-52.2664641271478L, 56.418228928517L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-52.263232801185L, 56.4273738759335L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-52.263232801185L, 56.4212772443225L), "bottom.left");
  }
  {
    note("geohex: OK7464515");
    geohex_t zone = geohex_get_zone_by_code("OK7464515");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-47.3235005587993L, 68.0323121475385L), "top.right");
    location_is(polygon.top.left, geohex_location(-47.3235005587993L, 68.0262155159274L), "top.left");
    location_is(polygon.middle.right, geohex_location(-47.3199214562931L, 68.035360463344L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-47.3199214562931L, 68.0231672001219L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.3163421113141L, 68.0323121475385L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.3163421113141L, 68.0262155159274L), "bottom.left");
  }
  {
    note("geohex: Fb5316746");
    geohex_t zone = geohex_get_zone_by_code("Fb5316746");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-48.4633776804082L, -104.587715287304L), "top.right");
    location_is(polygon.top.left, geohex_location(-48.4633776804082L, -104.593811918915L), "top.left");
    location_is(polygon.middle.right, geohex_location(-48.4598765064117L, -104.584666971498L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-48.4598765064117L, -104.59686023472L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-48.4563750909171L, -104.587715287304L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-48.4563750909171L, -104.593811918915L), "bottom.left");
  }
  {
    note("geohex: Fb4033527");
    geohex_t zone = geohex_get_zone_by_code("Fb4033527");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-51.8378904787554L, -99.1373266270385L), "top.right");
    location_is(polygon.top.left, geohex_location(-51.8378904787554L, -99.1434232586496L), "top.left");
    location_is(polygon.middle.right, geohex_location(-51.8346280091477L, -99.134278311233L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-51.8346280091477L, -99.1464715744551L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-51.8313653031605L, -99.1373266270385L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-51.8313653031605L, -99.1434232586496L), "bottom.left");
  }
  {
    note("geohex: GH4540858");
    geohex_t zone = geohex_get_zone_by_code("GH4540858");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-21.4598708376365L, -162.246608748666L), "top.right");
    location_is(polygon.top.left, geohex_location(-21.4598708376365L, -162.252705380277L), "top.left");
    location_is(polygon.middle.right, geohex_location(-21.4549569468283L, -162.243560432861L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-21.4549569468283L, -162.255753696083L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-21.4500428903903L, -162.246608748666L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-21.4500428903903L, -162.252705380277L), "bottom.left");
  }
  {
    note("geohex: GI4351804");
    geohex_t zone = geohex_get_zone_by_code("GI4351804");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-12.3891283632109L, -178.76238378296L), "top.right");
    location_is(polygon.top.left, geohex_location(-12.3891283632109L, -178.768480414571L), "top.left");
    location_is(polygon.middle.right, geohex_location(-12.3839714259397L, -178.759335467154L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-12.3839714259397L, -178.771528730377L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-12.3788143867519L, -178.76238378296L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-12.3788143867519L, -178.768480414571L), "bottom.left");
  }
  {
    note("geohex: GI8387484");
    geohex_t zone = geohex_get_zone_by_code("GI8387484");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-4.10419948775739L, -177.527815881725L), "top.right");
    location_is(polygon.top.left, geohex_location(-4.10419948775739L, -177.533912513336L), "top.left");
    location_is(polygon.middle.right, geohex_location(-4.09893317247951L, -177.52476756592L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-4.09893317247951L, -177.536960829142L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-4.09366682251329L, -177.527815881725L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-4.09366682251329L, -177.533912513336L), "bottom.left");
  }
  {
    note("geohex: QU0706771");
    geohex_t zone = geohex_get_zone_by_code("QU0706771");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(4.32535281981477L, -177.180307879896L), "top.right");
    location_is(polygon.top.left, geohex_location(4.32535281981477L, -177.186404511507L), "top.left");
    location_is(polygon.middle.right, geohex_location(4.33061760163989L, -177.177259564091L), "middle.right");
    location_is(polygon.middle.left, geohex_location(4.33061760163989L, -177.189452827313L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(4.33588234683049L, -177.180307879896L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(4.33588234683049L, -177.186404511507L), "bottom.left");
  }
  {
    note("geohex: QU4884047");
    geohex_t zone = geohex_get_zone_by_code("QU4884047");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(14.709021327764L, -179.987806736778L), "top.right");
    location_is(polygon.top.left, geohex_location(14.709021327764L, -179.993903368389L), "top.left");
    location_is(polygon.middle.right, geohex_location(14.7141280738906L, -179.984758420972L), "middle.right");
    location_is(polygon.middle.left, geohex_location(14.7141280738906L, -179.996951684194L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(14.7192347004905L, -179.987806736778L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(14.7192347004905L, -179.993903368389L), "bottom.left");
  }
  {
    note("geohex: QU8251271");
    geohex_t zone = geohex_get_zone_by_code("QU8251271");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(19.1675381870286L, 174.424630391709L), "top.right");
    location_is(polygon.top.left, geohex_location(19.1675381870286L, 174.418533760098L), "top.left");
    location_is(polygon.middle.right, geohex_location(19.1725252486474L, 174.427678707514L), "middle.right");
    location_is(polygon.middle.left, geohex_location(19.1725252486474L, 174.415485444292L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(19.1775121593425L, 174.424630391709L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(19.1775121593425L, 174.418533760098L), "bottom.left");
  }
  {
    note("geohex: PA0565644");
    geohex_t zone = geohex_get_zone_by_code("PA0565644");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(5.26186610113234L, -60.8199969516842L), "top.right");
    location_is(polygon.top.left, geohex_location(5.26186610113234L, -60.8260935832952L), "top.left");
    location_is(polygon.middle.right, geohex_location(5.26712366729293L, -60.8169486358787L), "middle.right");
    location_is(polygon.middle.left, geohex_location(5.26712366729293L, -60.8291418991007L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(5.27238118897812L, -60.8199969516842L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(5.27238118897812L, -60.8260935832952L), "bottom.left");
  }
  {
    note("geohex: OY8320288");
    geohex_t zone = geohex_get_zone_by_code("OY8320288");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(6.15497821548596L, 0.579180003048316L), "top.right");
    location_is(polygon.top.left, geohex_location(6.15497821548596L, 0.573083371437281L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.16022759188225L, 0.582228318853833L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.16022759188225L, 0.570035055631764L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(6.1654769163698L, 0.579180003048316L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(6.1654769163698L, 0.573083371437281L), "bottom.left");
  }
  {
    note("geohex: OY3556486");
    geohex_t zone = geohex_get_zone_by_code("OY3556486");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-2.11145706419977L, 4.21886907483615L), "top.right");
    location_is(polygon.top.left, geohex_location(-2.11145706419977L, 4.21277244322512L), "top.left");
    location_is(polygon.middle.right, geohex_location(-2.10618080216265L, 4.22191739064167L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-2.10618080216265L, 4.2097241274196L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-2.10090452225653L, 4.21886907483615L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-2.10090452225653L, 4.21277244322512L), "bottom.left");
  }
  {
    note("geohex: PZ8016814");
    geohex_t zone = geohex_get_zone_by_code("PZ8016814");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(45.3294698144182L, 39.7286998933089L), "top.right");
    location_is(polygon.top.left, geohex_location(45.3294698144182L, 39.7226032616979L), "top.left");
    location_is(polygon.middle.right, geohex_location(45.3331815719879L, 39.7317482091145L), "middle.right");
    location_is(polygon.middle.left, geohex_location(45.3331815719879L, 39.7195549458924L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(45.3368930863041L, 39.7286998933089L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(45.3368930863041L, 39.7226032616979L), "bottom.left");
  }
  {
    note("geohex: PZ1746604");
    geohex_t zone = geohex_get_zone_by_code("PZ1746604");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(39.9030713229747L, 36.2170400853528L), "top.right");
    location_is(polygon.top.left, geohex_location(39.9030713229747L, 36.2109434537418L), "top.left");
    location_is(polygon.middle.right, geohex_location(39.907121529315L, 36.2200884011583L), "middle.right");
    location_is(polygon.middle.left, geohex_location(39.907121529315L, 36.2078951379363L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(39.9111714962193L, 36.2170400853528L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(39.9111714962193L, 36.2109434537418L), "bottom.left");
  }
  {
    note("geohex: PS6242083");
    geohex_t zone = geohex_get_zone_by_code("PS6242083");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(22.424637889562L, 128.407254991617L), "top.right");
    location_is(polygon.top.left, geohex_location(22.424637889562L, 128.401158360006L), "top.left");
    location_is(polygon.middle.right, geohex_location(22.4295183912878L, 128.410303307423L), "middle.right");
    location_is(polygon.middle.left, geohex_location(22.4295183912878L, 128.398110044201L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(22.4343987214196L, 128.407254991617L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(22.4343987214196L, 128.401158360006L), "bottom.left");
  }
  {
    note("geohex: XM5643552");
    geohex_t zone = geohex_get_zone_by_code("XM5643552");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(35.8156540875783L, 137.899710409998L), "top.right");
    location_is(polygon.top.left, geohex_location(35.8156540875783L, 137.893613778387L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.8199354136109L, 137.902758725804L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.8199354136109L, 137.890565462582L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.824216508757L, 137.899710409998L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.824216508757L, 137.893613778387L), "bottom.left");
  }
  {
    note("geohex: XU6303820");
    geohex_t zone = geohex_get_zone_by_code("XU6303820");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(40.210204191562L, 135.750647767109L), "top.right");
    location_is(polygon.top.left, geohex_location(40.210204191562L, 135.744551135498L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.214236183804L, 135.753696082914L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.214236183804L, 135.741502819692L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(40.2182679361626L, 135.750647767109L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(40.2182679361626L, 135.744551135498L), "bottom.left");
  }
  {
    note("geohex: XM7851800");
    geohex_t zone = geohex_get_zone_by_code("XM7851800");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(38.1974978260893L, 145.682060661485L), "top.right");
    location_is(polygon.top.left, geohex_location(38.1974978260893L, 145.675964029873L), "top.left");
    location_is(polygon.middle.right, geohex_location(38.2016470474239L, 145.68510897729L), "middle.right");
    location_is(polygon.middle.left, geohex_location(38.2016470474239L, 145.672915714068L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(38.2057960323063L, 145.682060661485L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(38.2057960323063L, 145.675964029873L), "bottom.left");
  }
  {
    note("geohex: XX0345653");
    geohex_t zone = geohex_get_zone_by_code("XX0345653");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.8595310023876L, 142.124676116446L), "top.right");
    location_is(polygon.top.left, geohex_location(43.8595310023876L, 142.118579484835L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.8633378587961L, 142.127724432251L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.8633378587961L, 142.115531169029L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.867144472126L, 142.124676116446L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.867144472126L, 142.118579484835L), "bottom.left");
  }
  {
    note("geohex: XM6306347");
    geohex_t zone = geohex_get_zone_by_code("XM6306347");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(30.8469781653046L, 156.14388050602L), "top.right");
    location_is(polygon.top.left, geohex_location(30.8469781653046L, 156.137783874409L), "top.left");
    location_is(polygon.middle.right, geohex_location(30.8515110089981L, 156.146928821826L), "middle.right");
    location_is(polygon.middle.left, geohex_location(30.8515110089981L, 156.134735558604L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(30.8560436384917L, 156.14388050602L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(30.8560436384917L, 156.137783874409L), "bottom.left");
  }
  {
    note("geohex: QU8827707");
    geohex_t zone = geohex_get_zone_by_code("QU8827707");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.4500428903903L, 178.859929888736L), "top.right");
    location_is(polygon.top.left, geohex_location(21.4500428903903L, 178.853833257125L), "top.left");
    location_is(polygon.middle.right, geohex_location(21.4549569468283L, 178.862978204542L), "middle.right");
    location_is(polygon.middle.left, geohex_location(21.4549569468283L, 178.85078494132L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.4598708376365L, 178.859929888736L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.4598708376365L, 178.853833257125L), "bottom.left");
  }
  {
    note("geohex: PZ4253332");
    geohex_t zone = geohex_get_zone_by_code("PZ4253332");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(42.0316706921203L, 35.1562261850328L), "top.right");
    location_is(polygon.top.left, geohex_location(42.0316706921203L, 35.1501295534217L), "top.left");
    location_is(polygon.middle.right, geohex_location(42.0355923018785L, 35.1592745008383L), "middle.right");
    location_is(polygon.middle.left, geohex_location(42.0355923018785L, 35.1470812376162L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(42.039513669668L, 35.1562261850328L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(42.039513669668L, 35.1501295534217L), "bottom.left");
  }
  {
    note("geohex: OI8776718");
    geohex_t zone = geohex_get_zone_by_code("OI8776718");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(30.9194779502181L, -116.485291876238L), "top.right");
    location_is(polygon.top.left, geohex_location(30.9194779502181L, -116.491388507849L), "top.left");
    location_is(polygon.middle.right, geohex_location(30.9240073645291L, -116.482243560433L), "middle.right");
    location_is(polygon.middle.left, geohex_location(30.9240073645291L, -116.494436823655L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(30.928536564349L, -116.485291876238L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(30.928536564349L, -116.491388507849L), "bottom.left");
  }
  {
    note("geohex: PF2148656");
    geohex_t zone = geohex_get_zone_by_code("PF2148656");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(41.1312342635584L, -95.3970431336686L), "top.right");
    location_is(polygon.top.left, geohex_location(41.1312342635584L, -95.4031397652797L), "top.left");
    location_is(polygon.middle.right, geohex_location(41.1352109428687L, -95.3939948178631L), "middle.right");
    location_is(polygon.middle.left, geohex_location(41.1352109428687L, -95.4061880810852L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(41.1391873811194L, -95.3970431336686L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(41.1391873811194L, -95.4031397652797L), "bottom.left");
  }
  {
    note("geohex: ZA4587731");
    geohex_t zone = geohex_get_zone_by_code("ZA4587731");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(75.4085079963618L, 118.128334095412L), "top.right");
    location_is(polygon.top.left, geohex_location(75.4085079963618L, 118.122237463801L), "top.left");
    location_is(polygon.middle.right, geohex_location(75.4098380636786L, 118.131382411218L), "middle.right");
    location_is(polygon.middle.left, geohex_location(75.4098380636786L, 118.119189147996L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(75.4111680123867L, 118.128334095412L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(75.4111680123867L, 118.122237463801L), "bottom.left");
  }
  {
    note("geohex: SV4335020");
    geohex_t zone = geohex_get_zone_by_code("SV4335020");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(66.789517197219L, -77.3357719859777L), "top.right");
    location_is(polygon.top.left, geohex_location(66.789517197219L, -77.3418686175888L), "top.left");
    location_is(polygon.middle.right, geohex_location(66.7915979463581L, -77.3327236701722L), "middle.right");
    location_is(polygon.middle.left, geohex_location(66.7915979463581L, -77.3449169333943L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(66.7936785192786L, -77.3357719859777L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(66.7936785192786L, -77.3418686175888L), "bottom.left");
  }
  {
    note("geohex: SV5843218");
    geohex_t zone = geohex_get_zone_by_code("SV5843218");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(69.7266494639338L, -86.6087486663618L), "top.right");
    location_is(polygon.top.left, geohex_location(69.7266494639338L, -86.6148452979729L), "top.left");
    location_is(polygon.middle.right, geohex_location(69.7284788454195L, -86.6057003505563L), "middle.right");
    location_is(polygon.middle.left, geohex_location(69.7284788454195L, -86.6178936137784L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(69.7303080687751L, -86.6087486663618L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(69.7303080687751L, -86.6148452979729L), "bottom.left");
  }
  {
    note("geohex: aX0682573");
    geohex_t zone = geohex_get_zone_by_code("aX0682573");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(76.0143567626192L, 23.9079408626734L), "top.right");
    location_is(polygon.top.left, geohex_location(76.0143567626192L, 23.9018442310623L), "top.left");
    location_is(polygon.middle.right, geohex_location(76.0156327302267L, 23.9109891784789L), "middle.right");
    location_is(polygon.middle.left, geohex_location(76.0156327302267L, 23.8987959152568L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(76.0169085837432L, 23.9079408626734L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(76.0169085837432L, 23.9018442310623L), "bottom.left");
  }
  {
    note("geohex: aX8100870");
    geohex_t zone = geohex_get_zone_by_code("aX8100870");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.6692008130174L, 17.808260935833L), "top.right");
    location_is(polygon.top.left, geohex_location(78.6692008130174L, 17.8021643042219L), "top.left");
    location_is(polygon.middle.right, geohex_location(78.6702381130175L, 17.8113092516385L), "middle.right");
    location_is(polygon.middle.left, geohex_location(78.6702381130175L, 17.7991159884164L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(78.6712753192969L, 17.808260935833L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(78.6712753192969L, 17.8021643042219L), "bottom.left");
  }
  {
    note("geohex: bD4424804");
    geohex_t zone = geohex_get_zone_by_code("bD4424804");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.194587974704L, -41.4784331656759L), "top.right");
    location_is(polygon.top.left, geohex_location(83.194587974704L, -41.484529797287L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.1952135950448L, -41.4753848498704L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.1952135950448L, -41.4875781130925L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.1958391581432L, -41.4784331656759L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.1958391581432L, -41.484529797287L), "bottom.left");
  }
  {
    note("geohex: bE6100113");
    geohex_t zone = geohex_get_zone_by_code("bE6100113");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.1811514612154L, -48.9864349946655L), "top.right");
    location_is(polygon.top.left, geohex_location(84.1811514612154L, -48.9925316262765L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.1816867255254L, -48.98338667886L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.1816867255254L, -48.995579942082L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.1822219407669L, -48.9864349946655L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.1822219407669L, -48.9925316262765L), "bottom.left");
  }
  {
    note("geohex: TK5027217");
    geohex_t zone = geohex_get_zone_by_code("TK5027217");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.8732665374047L, 171.918914799573L), "top.right");
    location_is(polygon.top.left, geohex_location(81.8732665374047L, 171.912818167962L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.8740128778651L, 171.921963115379L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.8740128778651L, 171.909769852157L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.8747591502434L, 171.918914799573L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.8747591502434L, 171.912818167962L), "bottom.left");
  }
  {
    note("geohex: TK7070414");
    geohex_t zone = geohex_get_zone_by_code("TK7070414");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.8725201288562L, -172.616979119037L), "top.right");
    location_is(polygon.top.left, geohex_location(81.8725201288562L, -172.623075750648L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.8732665374047L, -172.613930803231L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.8732665374047L, -172.626124066453L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.8740128778651L, -172.616979119037L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.8740128778651L, -172.623075750648L), "bottom.left");
  }
  {
    note("geohex: TO6240542");
    geohex_t zone = geohex_get_zone_by_code("TO6240542");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.4053033138408L, -171.208657216888L), "top.right");
    location_is(polygon.top.left, geohex_location(84.4053033138408L, -171.214753848499L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.4058180257527L, -171.205608901082L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.4058180257527L, -171.217802164304L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.4063326904617L, -171.208657216888L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.4063326904617L, -171.214753848499L), "bottom.left");
  }
  {
    note("geohex: TO7775738");
    geohex_t zone = geohex_get_zone_by_code("TO7775738");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.9592128749224L, -170.504496265813L), "top.right");
    location_is(polygon.top.left, geohex_location(84.9592128749224L, -170.510592897424L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.9596767659574L, -170.501447950008L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.9596767659574L, -170.51364121323L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.9601406144117L, -170.504496265813L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.9601406144117L, -170.510592897424L), "bottom.left");
  }
  {
    note("geohex: TO5821675");
    geohex_t zone = geohex_get_zone_by_code("TO5821675");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0072301856982L, 171.790885535741L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0072301856982L, 171.78478890413L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0076896690631L, 171.793933851547L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0076896690631L, 171.781740588325L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0081491102489L, 171.790885535741L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0081491102489L, 171.78478890413L), "bottom.left");
  }
  {
    note("geohex: bb3371862");
    geohex_t zone = geohex_get_zone_by_code("bb3371862");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0506933065099L, 89.4223441548545L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0506933065099L, 89.4162475232434L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0511487999708L, 89.42539247066L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0511487999708L, 89.4131992074379L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.0516042516161L, 89.4223441548545L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.0516042516161L, 89.4162475232434L), "bottom.left");
  }
  {
    note("geohex: BV54870250");
    geohex_t zone = geohex_get_zone_by_code("BV54870250");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, -86.4827516130671L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, -86.4847838236041L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0509969734635L, -86.4817355077986L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0509969734635L, -86.4857999288726L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0508451423099L, -86.4827516130671L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0508451423099L, -86.4847838236041L), "bottom.left");
  }
  {
    note("geohex: BV78253862");
    geohex_t zone = geohex_get_zone_by_code("BV78253862");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.8944725537891L, -74.9662144998222L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.8944725537891L, -74.9682467103592L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.8943159331226L, -74.9651983945537L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.8943159331226L, -74.9692628156277L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.8941593076641L, -74.9662144998222L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.8941593076641L, -74.9682467103592L), "bottom.left");
  }
  {
    note("geohex: CI57758513");
    geohex_t zone = geohex_get_zone_by_code("CI57758513");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9595221403438L, 116.016867347457L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9595221403438L, 116.01483513692L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9593675099988L, 116.017883452726L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9593675099988L, 116.013819031652L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9592128749224L, 116.016867347457L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9592128749224L, 116.01483513692L), "bottom.left");
  }
  {
    note("geohex: CI75600226");
    geohex_t zone = geohex_get_zone_by_code("CI75600226");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0513006218319L, 125.859879083473L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0513006218319L, 125.857846872936L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511487999708L, 125.860895188742L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511487999708L, 125.856830767668L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0509969734635L, 125.859879083473L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0509969734635L, 125.857846872936L), "bottom.left");
  }
  {
    note("geohex: DO05603615");
    geohex_t zone = geohex_get_zone_by_code("DO05603615");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.047503681127L, 179.385256312554L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.047503681127L, 179.383224102017L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0473517430692L, 179.386272417823L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0473517430692L, 179.382207996748L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0471998003617L, 179.385256312554L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0471998003617L, 179.383224102017L), "bottom.left");
  }
  {
    note("geohex: DO07152160");
    geohex_t zone = geohex_get_zone_by_code("DO07152160");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0447680845659L, -178.938169994411L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0447680845659L, -178.940202204948L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0446160627918L, -178.937153889143L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0446160627918L, -178.941218310217L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0444640363654L, -178.938169994411L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0444640363654L, -178.940202204948L), "bottom.left");
  }
  {
    note("geohex: EU41063674");
    geohex_t zone = geohex_get_zone_by_code("EU41063674");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.0256096195107L, 178.418940202205L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.0256096195107L, 178.416907991668L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.0252444701795L, 178.419956307473L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.0252444701795L, 178.415891886399L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.024879309876L, 178.418940202205L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.024879309876L, 178.416907991668L), "bottom.left");
  }
  {
    note("geohex: EU72201265");
    geohex_t zone = geohex_get_zone_by_code("EU72201265");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-76.7839381457023L, -179.380175786211L), "top.right");
    location_is(polygon.top.left, geohex_location(-76.7839381457023L, -179.382207996748L), "top.left");
    location_is(polygon.middle.right, geohex_location(-76.7835357741786L, -179.379159680943L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-76.7835357741786L, -179.383224102017L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-76.7831333906224L, -179.380175786211L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-76.7831333906224L, -179.382207996748L), "bottom.left");
  }
  {
    note("geohex: CZ34762511");
    geohex_t zone = geohex_get_zone_by_code("CZ34762511");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.2785400909123L, -12.3019864857999L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.2785400909123L, -12.3040186963369L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.2781825453963L, -12.3009703805314L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.2781825453963L, -12.3050348016054L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.2778249891265L, -12.3019864857999L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.2778249891265L, -12.3040186963369L), "bottom.left");
  }
  {
    note("geohex: Fb38241503");
    geohex_t zone = geohex_get_zone_by_code("Fb38241503");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-50.7372690952039L, -94.9204897627394L), "top.right");
    location_is(polygon.top.left, geohex_location(-50.7372690952039L, -94.9225219732764L), "top.left");
    location_is(polygon.middle.right, geohex_location(-50.7361552519765L, -94.9194736574709L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-50.7361552519765L, -94.9235380785449L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-50.7350413822592L, -94.9204897627394L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-50.7350413822592L, -94.9225219732764L), "bottom.left");
  }
  {
    note("geohex: OK48511367");
    geohex_t zone = geohex_get_zone_by_code("OK48511367");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-48.0591587908747L, 58.9798303104201L), "top.right");
    location_is(polygon.top.left, geohex_location(-48.0591587908747L, 58.9777980998831L), "top.left");
    location_is(polygon.middle.right, geohex_location(-48.0579824947847L, 58.9808464156887L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-48.0579824947847L, 58.9767819946146L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-48.0568061718185L, 58.9798303104201L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-48.0568061718185L, 58.9777980998831L), "bottom.left");
  }
  {
    note("geohex: GI32042116");
    geohex_t zone = geohex_get_zone_by_code("GI32042116");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-16.0597044159391L, -177.971853884062L), "top.right");
    location_is(polygon.top.left, geohex_location(-16.0597044159391L, -177.973886094599L), "top.left");
    location_is(polygon.middle.right, geohex_location(-16.0580131465426L, -177.970837778794L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-16.0580131465426L, -177.974902199868L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-16.0563218627759L, -177.971853884062L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-16.0563218627759L, -177.973886094599L), "bottom.left");
  }
  {
    note("geohex: GI71565064");
    geohex_t zone = geohex_get_zone_by_code("GI71565064");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-8.50781931338796L, -175.86546766245L), "top.right");
    location_is(polygon.top.left, geohex_location(-8.50781931338796L, -175.867499872987L), "top.left");
    location_is(polygon.middle.right, geohex_location(-8.50607873048697L, -175.864451557181L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-8.50607873048697L, -175.868515978255L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-8.50433813967769L, -175.86546766245L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-8.50433813967769L, -175.867499872987L), "bottom.left");
  }
  {
    note("geohex: GH45442518");
    geohex_t zone = geohex_get_zone_by_code("GH45442518");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-21.2910659982988L, -162.422394960118L), "top.right");
    location_is(polygon.top.left, geohex_location(-21.2910659982988L, -162.424427170655L), "top.left");
    location_is(polygon.middle.right, geohex_location(-21.2894261632855L, -162.421378854849L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-21.2894261632855L, -162.425443275923L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-21.2877863099837L, -162.422394960118L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-21.2877863099837L, -162.424427170655L), "bottom.left");
  }
  {
    note("geohex: OY33228746");
    geohex_t zone = geohex_get_zone_by_code("OY33228746");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-5.01646433945816L, 6.94812782604278L), "top.right");
    location_is(polygon.top.left, geohex_location(-5.01646433945816L, 6.94609561550577L), "top.left");
    location_is(polygon.middle.right, geohex_location(-5.01471113242862L, 6.94914393131128L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-5.01471113242862L, 6.94507951023726L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-5.0129579206917L, 6.94812782604278L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-5.0129579206917L, 6.94609561550577L), "bottom.left");
  }
  {
    note("geohex: PA03278283");
    geohex_t zone = geohex_get_zone_by_code("PA03278283");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.80950712167057L, -59.0631509424376L), "top.right");
    location_is(polygon.top.left, geohex_location(2.80950712167057L, -59.0651831529747L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.81126495087439L, -59.0621348371691L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.81126495087439L, -59.0661992582432L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.81302277742997L, -59.0631509424376L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.81302277742997L, -59.0651831529747L), "bottom.left");
  }
  {
    note("geohex: QU42174351");
    geohex_t zone = geohex_get_zone_by_code("QU42174351");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(11.1762578991997L, 175.077986079358L), "top.right");
    location_is(polygon.top.left, geohex_location(11.1762578991997L, 175.075953868821L), "top.left");
    location_is(polygon.middle.right, geohex_location(11.1779844636168L, 175.079002184626L), "middle.right");
    location_is(polygon.middle.left, geohex_location(11.1779844636168L, 175.074937763552L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(11.1797110177528L, 175.077986079358L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(11.1797110177528L, 175.075953868821L), "bottom.left");
  }
  {
    note("geohex: QU47122108");
    geohex_t zone = geohex_get_zone_by_code("QU47122108");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(12.2825309982078L, -179.203373469491L), "top.right");
    location_is(polygon.top.left, geohex_location(12.2825309982078L, -179.205405680028L), "top.left");
    location_is(polygon.middle.right, geohex_location(12.2842506542222L, -179.202357364223L), "middle.right");
    location_is(polygon.middle.left, geohex_location(12.2842506542222L, -179.206421785297L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(12.285970298998L, -179.203373469491L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(12.285970298998L, -179.205405680028L), "bottom.left");
  }
  {
    note("geohex: XM32230826");
    geohex_t zone = geohex_get_zone_by_code("XM32230826");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(29.2274965618893L, 140.976477163034L), "top.right");
    location_is(polygon.top.left, geohex_location(29.2274965618893L, 140.974444952497L), "top.left");
    location_is(polygon.middle.right, geohex_location(29.2290324338197L, 140.977493268303L), "middle.right");
    location_is(polygon.middle.left, geohex_location(29.2290324338197L, 140.973428847229L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(29.2305682827135L, 140.976477163034L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(29.2305682827135L, 140.974444952497L), "bottom.left");
  }
  {
    note("geohex: XM56301016");
    geohex_t zone = geohex_get_zone_by_code("XM56301016");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(35.2341229051485L, 138.434181781233L), "top.right");
    location_is(polygon.top.left, geohex_location(35.2341229051485L, 138.432149570695L), "top.left");
    location_is(polygon.middle.right, geohex_location(35.2355604188248L, 138.435197886501L), "middle.right");
    location_is(polygon.middle.left, geohex_location(35.2355604188248L, 138.431133465427L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(35.236997907026L, 138.434181781233L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(35.236997907026L, 138.432149570695L), "bottom.left");
  }
  {
    note("geohex: PS61272751");
    geohex_t zone = geohex_get_zone_by_code("PS61272751");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.4516809276044L, 129.728191840675L), "top.right");
    location_is(polygon.top.left, geohex_location(21.4516809276044L, 129.726159630138L), "top.left");
    location_is(polygon.middle.right, geohex_location(21.4533189464174L, 129.729207945943L), "middle.right");
    location_is(polygon.middle.left, geohex_location(21.4533189464174L, 129.725143524869L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.4549569468283L, 129.728191840675L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.4549569468283L, 129.726159630138L), "bottom.left");
  }
  {
    note("geohex: XM60832123");
    geohex_t zone = geohex_get_zone_by_code("XM60832123");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(31.1155556060029L, 153.373977544074L), "top.right");
    location_is(polygon.top.left, geohex_location(31.1155556060029L, 153.371945333537L), "top.left");
    location_is(polygon.middle.right, geohex_location(31.1170623309677L, 153.374993649342L), "middle.right");
    location_is(polygon.middle.left, geohex_location(31.1170623309677L, 153.370929228268L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(31.1185690320146L, 153.373977544074L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(31.1185690320146L, 153.371945333537L), "bottom.left");
  }
  {
    note("geohex: XU63124187");
    geohex_t zone = geohex_get_zone_by_code("XU63124187");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(40.5801426255756L, 134.297617233145L), "top.right");
    location_is(polygon.top.left, geohex_location(40.5801426255756L, 134.295585022608L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.5814792855475L, 134.298633338414L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.5814792855475L, 134.29456891734L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(40.5828159188102L, 134.297617233145L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(40.5828159188102L, 134.295585022608L), "bottom.left");
  }
  {
    note("geohex: XX03173236");
    geohex_t zone = geohex_get_zone_by_code("XX03173236");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.5069840498977L, 141.772087588274L), "top.right");
    location_is(polygon.top.left, geohex_location(43.5069840498977L, 141.770055377737L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.5082605084073L, 141.773103693543L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.5082605084073L, 141.769039272469L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.5095369399236L, 141.772087588274L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.5095369399236L, 141.770055377737L), "bottom.left");
  }
  {
    note("geohex: PZ38755703");
    geohex_t zone = geohex_get_zone_by_code("PZ38755703");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(41.3746910839103L, 47.1096885637352L), "top.right");
    location_is(polygon.top.left, geohex_location(41.3746910839103L, 47.1076563531982L), "top.left");
    location_is(polygon.middle.right, geohex_location(41.3760117394249L, 47.1107046690037L), "middle.right");
    location_is(polygon.middle.left, geohex_location(41.3760117394249L, 47.1066402479297L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(41.3773323681254L, 47.1096885637352L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(41.3773323681254L, 47.1076563531982L), "bottom.left");
  }
  {
    note("geohex: PZ57757416");
    geohex_t zone = geohex_get_zone_by_code("PZ57757416");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(46.0034486295038L, 36.1296550322613L), "top.right");
    location_is(polygon.top.left, geohex_location(46.0034486295038L, 36.1276228217243L), "top.left");
    location_is(polygon.middle.right, geohex_location(46.0046711009809L, 36.1306711375299L), "middle.right");
    location_is(polygon.middle.left, geohex_location(46.0046711009809L, 36.1266067164558L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(46.0058935454445L, 36.1296550322613L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(46.0058935454445L, 36.1276228217243L), "bottom.left");
  }
  {
    note("geohex: Fc51504013");
    geohex_t zone = geohex_get_zone_by_code("Fc51504013");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-39.85309909355L, -129.634710155972L), "top.right");
    location_is(polygon.top.left, geohex_location(-39.85309909355L, -129.636742366509L), "top.left");
    location_is(polygon.middle.right, geohex_location(-39.8517479873992L, -129.633694050704L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-39.8517479873992L, -129.637758471778L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-39.8503968546537L, -129.634710155972L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-39.8503968546537L, -129.636742366509L), "bottom.left");
  }
  {
    note("geohex: OW22586402");
    geohex_t zone = geohex_get_zone_by_code("OW22586402");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(0.700441040903862L, -58.3589899913631L), "top.right");
    location_is(polygon.top.left, geohex_location(0.700441040903862L, -58.3610222019001L), "top.left");
    location_is(polygon.middle.right, geohex_location(0.702200855013125L, -58.3579738860946L), "middle.right");
    location_is(polygon.middle.left, geohex_location(0.702200855013125L, -58.3620383071686L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(0.703960668459942L, -58.3589899913631L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(0.703960668459942L, -58.3610222019001L), "bottom.left");
  }
  {
    note("geohex: PC52458806");
    geohex_t zone = geohex_get_zone_by_code("PC52458806");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(36.0920373899818L, -111.350911954478L), "top.right");
    location_is(polygon.top.left, geohex_location(36.0920373899818L, -111.352944165016L), "top.left");
    location_is(polygon.middle.right, geohex_location(36.0934595397351L, -111.34989584921L), "middle.right");
    location_is(polygon.middle.left, geohex_location(36.0934595397351L, -111.353960270284L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(36.0948816637541L, -111.350911954478L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(36.0948816637541L, -111.352944165016L), "bottom.left");
  }
  {
    note("geohex: SV20852101");
    geohex_t zone = geohex_get_zone_by_code("SV20852101");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(66.821402658847L, -93.7743230198649L), "top.right");
    location_is(polygon.top.left, geohex_location(66.821402658847L, -93.7763552304019L), "top.left");
    location_is(polygon.middle.right, geohex_location(66.8220953612271L, -93.7733069145964L), "middle.right");
    location_is(polygon.middle.left, geohex_location(66.8220953612271L, -93.7773713356704L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(66.8227880440472L, -93.7743230198649L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(66.8227880440472L, -93.7763552304019L), "bottom.left");
  }
  {
    note("geohex: aX46486040");
    geohex_t zone = geohex_get_zone_by_code("aX46486040");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(77.617620405868L, 24.6100696032109L), "top.right");
    location_is(polygon.top.left, geohex_location(77.617620405868L, 24.6080373926739L), "top.left");
    location_is(polygon.middle.right, geohex_location(77.617997794141L, 24.6110857084794L), "middle.right");
    location_is(polygon.middle.left, geohex_location(77.617997794141L, 24.6070212874054L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.6183751710916L, 24.6100696032109L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.6183751710916L, 24.6080373926739L), "bottom.left");
  }
  {
    note("geohex: ZA62754057");
    geohex_t zone = geohex_get_zone_by_code("ZA62754057");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(74.9589380754989L, 129.37763552304L), "top.right");
    location_is(polygon.top.left, geohex_location(74.9589380754989L, 129.375603312503L), "top.left");
    location_is(polygon.middle.right, geohex_location(74.9593947944536L, 129.378651628309L), "middle.right");
    location_is(polygon.middle.left, geohex_location(74.9593947944536L, 129.374587207235L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(74.9598514998601L, 129.37763552304L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(74.9598514998601L, 129.375603312503L), "bottom.left");
  }
  {
    note("geohex: bD28367162");
    geohex_t zone = geohex_get_zone_by_code("bD28367162");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.4401212961002L, -52.0306863791089L), "top.right");
    location_is(polygon.top.left, geohex_location(83.4401212961002L, -52.0327185896459L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.4403223519231L, -52.0296702738404L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.4403223519231L, -52.0337346949144L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.4405234016108L, -52.0306863791089L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.4405234016108L, -52.0327185896459L), "bottom.left");
  }
  {
    note("geohex: TK05722747");
    geohex_t zone = geohex_get_zone_by_code("TK05722747");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(80.7604458578603L, 177.89158156785L), "top.right");
    location_is(polygon.top.left, geohex_location(80.7604458578603L, 177.889549357313L), "top.left");
    location_is(polygon.middle.right, geohex_location(80.760728435108L, 177.892597673119L), "middle.right");
    location_is(polygon.middle.left, geohex_location(80.760728435108L, 177.888533252045L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(80.7610110037885L, 177.89158156785L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(80.7610110037885L, 177.889549357313L), "bottom.left");
  }
  {
    note("geohex: TK83151057");
    geohex_t zone = geohex_get_zone_by_code("TK83151057");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(82.5043908961701L, -178.852817151857L), "top.right");
    location_is(polygon.top.left, geohex_location(82.5043908961701L, -178.854849362394L), "top.left");
    location_is(polygon.middle.right, geohex_location(82.5046204779964L, -178.851801046588L), "middle.right");
    location_is(polygon.middle.left, geohex_location(82.5046204779964L, -178.855865467663L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(82.5048500528309L, -178.852817151857L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(82.5048500528309L, -178.854849362394L), "bottom.left");
  }
  {
    note("geohex: TO31130720");
    geohex_t zone = geohex_get_zone_by_code("TO31130720");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.8379612821613L, -176.039221663364L), "top.right");
    location_is(polygon.top.left, geohex_location(83.8379612821613L, -176.041253873901L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.838150193033L, -176.038205558096L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.838150193033L, -176.04226997917L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.8383390981356L, -176.039221663364L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.8383390981356L, -176.041253873901L), "bottom.left");
  }
  {
    note("geohex: TO51331450");
    geohex_t zone = geohex_get_zone_by_code("TO51331450");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.6149040358523L, 172.008332063202L), "top.right");
    location_is(polygon.top.left, geohex_location(84.6149040358523L, 172.006299852665L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.6150692030928L, 172.00934816847L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.6150692030928L, 172.005283747396L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.6152343652824L, 172.008332063202L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.6152343652824L, 172.006299852665L), "bottom.left");
  }
  {
    note("geohex: bb33488116");
    geohex_t zone = geohex_get_zone_by_code("bb33488116");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0491746929231L, 88.8594218361022L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0491746929231L, 88.8573896255652L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0493265751955L, 88.8604379413707L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0493265751955L, 88.8563735202967L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.04947845282L, 88.8594218361022L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.04947845282L, 88.8573896255652L), "bottom.left");
  }
  {
    note("geohex: BV804240512");
    geohex_t zone = geohex_get_zone_by_code("BV804240512");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0207417696776L, -80.5077139324968L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0207417696776L, -80.5083913360091L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0206908511882L, -80.5073752307406L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0206908511882L, -80.5087300377653L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0206399321795L, -80.5077139324968L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0206399321795L, -80.5083913360091L), "bottom.left");
  }
  {
    note("geohex: CI708565326");
    geohex_t zone = geohex_get_zone_by_code("CI708565326");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.2589708455591L, 126.562346525767L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.2589708455591L, 126.561669122254L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.2589223575258L, 126.562685227523L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.2589223575258L, 126.561330420498L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.2588738689976L, 126.562346525767L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.2588738689976L, 126.561669122254L), "bottom.left");
  }
  {
    note("geohex: CI754848748");
    geohex_t zone = geohex_get_zone_by_code("CI754848748");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9901483841328L, 124.453928093617L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9901483841328L, 124.453250690105L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9900971535871L, 124.454266795373L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9900971535871L, 124.452911988349L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9900459225188L, 124.453928093617L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9900459225188L, 124.453250690105L), "bottom.left");
  }
  {
    note("geohex: DO055580431");
    geohex_t zone = geohex_get_zone_by_code("DO055580431");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-84.9631803444714L, 176.792494369083L), "top.right");
    location_is(polygon.top.left, geohex_location(-84.9631803444714L, 176.791816965571L), "top.left");
    location_is(polygon.middle.right, geohex_location(-84.9631288388604L, 176.792833070839L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-84.9631288388604L, 176.791478263815L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-84.9630773327241L, 176.792494369083L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-84.9630773327241L, 176.791816965571L), "bottom.left");
  }
  {
    note("geohex: DO053480025");
    geohex_t zone = geohex_get_zone_by_code("DO053480025");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0506933065098L, 178.511744483395L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0506933065098L, 178.511067079883L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0506426935439L, 178.512083185151L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0506426935439L, 178.510728378127L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0505920800617L, 178.511744483395L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0505920800617L, 178.511067079883L), "bottom.left");
  }
  {
    note("geohex: DO073506567");
    geohex_t zone = geohex_get_zone_by_code("DO073506567");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0506933065098L, -177.230774441565L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0506933065098L, -177.231451845078L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0506426935439L, -177.230435739809L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0506426935439L, -177.231790546834L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0505920800617L, -177.230774441565L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0505920800617L, -177.231451845078L), "bottom.left");
  }
  {
    note("geohex: CZ347013544");
    geohex_t zone = geohex_get_zone_by_code("CZ347013544");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.3495965283909L, -12.6562685227523L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.3495965283909L, -12.6569459262646L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.3494780602137L, -12.6559298209961L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.3494780602137L, -12.6572846280208L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.3493595908485L, -12.6562685227523L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.3493595908485L, -12.6569459262646L), "bottom.left");
  }
  {
    note("geohex: EU413474586");
    geohex_t zone = geohex_get_zone_by_code("EU413474586");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-77.9156941218801L, 178.594049010144L), "top.right");
    location_is(polygon.top.left, geohex_location(-77.9156941218801L, 178.593371606632L), "top.left");
    location_is(polygon.middle.right, geohex_location(-77.9155713059442L, 178.5943877119L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-77.9155713059442L, 178.593032904876L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-77.9154484887786L, 178.594049010144L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-77.9154484887786L, 178.593371606632L), "bottom.left");
  }
  {
    note("geohex: EU354580674");
    geohex_t zone = geohex_get_zone_by_code("EU354580674");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.0621905452025L, -175.780792223408L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.0621905452025L, -175.78146962692L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.0620691964047L, -175.780453521651L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.0620691964047L, -175.781808328676L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.0619478463913L, -175.780792223408L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.0619478463913L, -175.78146962692L), "bottom.left");
  }
  {
    note("geohex: OK474555348");
    geohex_t zone = geohex_get_zone_by_code("OK474555348");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-48.9230287575873L, 61.8750529221494L), "top.right");
    location_is(polygon.top.left, geohex_location(-48.9230287575873L, 61.8743755186371L), "top.left");
    location_is(polygon.middle.right, geohex_location(-48.9226432855131L, 61.8753916239056L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-48.9226432855131L, 61.8740368168809L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-48.9222578104636L, 61.8750529221494L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-48.9222578104636L, 61.8743755186371L), "bottom.left");
  }
  {
    note("geohex: Fb484868583");
    geohex_t zone = geohex_get_zone_by_code("Fb484868583");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-47.9904965723643L, -99.8431810868939L), "top.right");
    location_is(polygon.top.left, geohex_location(-47.9904965723643L, -99.8438584904063L), "top.left");
    location_is(polygon.middle.right, geohex_location(-47.9901039539973L, -99.8428423851378L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-47.9901039539973L, -99.8441971921624L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-47.9897113326433L, -99.8431810868939L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-47.9897113326433L, -99.8438584904063L), "bottom.left");
  }
  {
    note("geohex: GH147081657");
    geohex_t zone = geohex_get_zone_by_code("GH147081657");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-25.8005659034605L, -165.936764382123L), "top.right");
    location_is(polygon.top.left, geohex_location(-25.8005659034605L, -165.937441785636L), "top.left");
    location_is(polygon.middle.right, geohex_location(-25.8000377340134L, -165.936425680367L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-25.8000377340134L, -165.937780487392L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-25.7995095622126L, -165.936764382123L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-25.7995095622126L, -165.937441785636L), "bottom.left");
  }
  {
    note("geohex: GI730641802");
    geohex_t zone = geohex_get_zone_by_code("GI730641802");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-9.79762309124821L, -170.646412301648L), "top.right");
    location_is(polygon.top.left, geohex_location(-9.79762309124821L, -170.64708970516L), "top.left");
    location_is(polygon.middle.right, geohex_location(-9.79704499838907L, -170.646073599892L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-9.79704499838907L, -170.647428406916L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-9.79646690452274L, -170.646412301648L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-9.79646690452274L, -170.64708970516L), "bottom.left");
  }
  {
    note("geohex: GI576514101");
    geohex_t zone = geohex_get_zone_by_code("GI576514101");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-6.31710146423577L, 176.697996579112L), "top.right");
    location_is(polygon.top.left, geohex_location(-6.31710146423577L, 176.6973191756L), "top.left");
    location_is(polygon.middle.right, geohex_location(-6.31651837729493L, 176.698335280868L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-6.31651837729493L, 176.696980473844L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-6.31593528969724L, 176.697996579112L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-6.31593528969724L, 176.6973191756L), "bottom.left");
  }
  {
    note("geohex: OY041035522");
    geohex_t zone = geohex_get_zone_by_code("OY041035522");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-8.4074328257882L, -0.702806144049857L), "top.right");
    location_is(polygon.top.left, geohex_location(-8.4074328257882L, -0.703483547562194L), "top.left");
    location_is(polygon.middle.right, geohex_location(-8.40685248119733L, -0.702467442293689L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-8.40685248119733L, -0.703822249318363L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-8.40627213573772L, -0.702806144049857L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-8.40627213573772L, -0.703483547562194L), "bottom.left");
  }
  {
    note("geohex: OY537117080");
    geohex_t zone = geohex_get_zone_by_code("OY537117080");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.80950712167055L, -4.00514826669376L), "top.right");
    location_is(polygon.top.left, geohex_location(2.80950712167055L, -4.0058256702061L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.81009306503265L, -4.00480956493759L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.81009306503265L, -4.00616437196227L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.81067900810061L, -4.00514826669376L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.81067900810061L, -4.0058256702061L), "bottom.left");
  }
  {
    note("geohex: PA402570238");
    geohex_t zone = geohex_get_zone_by_code("PA402570238");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(9.09972796439679L, -61.6609934122508L), "top.right");
    location_is(polygon.top.left, geohex_location(9.09972796439679L, -61.6616708157632L), "top.left");
    location_is(polygon.middle.right, geohex_location(9.10030722934531L, -61.6606547104947L), "middle.right");
    location_is(polygon.middle.left, geohex_location(9.10030722934531L, -61.6620095175193L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(9.10088649335576L, -61.6609934122508L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(9.10088649335576L, -61.6616708157632L), "bottom.left");
  }
  {
    note("geohex: QU058877078");
    geohex_t zone = geohex_get_zone_by_code("QU058877078");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(6.31476911253157L, 177.890904164338L), "top.right");
    location_is(polygon.top.left, geohex_location(6.31476911253157L, 177.890226760826L), "top.left");
    location_is(polygon.middle.right, geohex_location(6.31535220144277L, 177.891242866094L), "middle.right");
    location_is(polygon.middle.left, geohex_location(6.31535220144277L, 177.88988805907L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(6.31593528969724L, 177.890904164338L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(6.31593528969724L, 177.890226760826L), "bottom.left");
  }
  {
    note("geohex: QU832828267");
    geohex_t zone = geohex_get_zone_by_code("QU832828267");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(17.9764014229065L, -179.434706768955L), "top.right");
    location_is(polygon.top.left, geohex_location(17.9764014229065L, -179.435384172467L), "top.left");
    location_is(polygon.middle.right, geohex_location(17.9769594326653L, -179.434368067198L), "middle.right");
    location_is(polygon.middle.left, geohex_location(17.9769594326653L, -179.435722874223L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(17.9775174406607L, -179.434706768955L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(17.9775174406607L, -179.435384172467L), "bottom.left");
  }
  {
    note("geohex: PZ382714446");
    geohex_t zone = geohex_get_zone_by_code("PZ382714446");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(40.9794989843845L, 45.3521651509763L), "top.right");
    location_is(polygon.top.left, geohex_location(40.9794989843845L, 45.351487747464L), "top.left");
    location_is(polygon.middle.right, geohex_location(40.9799418699384L, 45.3525038527325L), "middle.right");
    location_is(polygon.middle.left, geohex_location(40.9799418699384L, 45.3511490457078L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(40.9803847525186L, 45.3521651509763L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(40.9803847525186L, 45.351487747464L), "bottom.left");
  }
  {
    note("geohex: PZ028668414");
    geohex_t zone = geohex_get_zone_by_code("PZ028668414");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(36.5976355242024L, 36.211282155498L), "top.right");
    location_is(polygon.top.left, geohex_location(36.5976355242024L, 36.2106047519856L), "top.left");
    location_is(polygon.middle.right, geohex_location(36.5981065089872L, 36.2116208572542L), "middle.right");
    location_is(polygon.middle.left, geohex_location(36.5981065089872L, 36.2102660502295L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(36.5985774908969L, 36.211282155498L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(36.5985774908969L, 36.2106047519856L), "bottom.left");
  }
  {
    note("geohex: PS383657231");
    geohex_t zone = geohex_get_zone_by_code("PS383657231");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(20.9599974267292L, 127.830445900862L), "top.right");
    location_is(polygon.top.left, geohex_location(20.9599974267292L, 127.82976849735L), "top.left");
    location_is(polygon.middle.right, geohex_location(20.9605452560715L, 127.830784602618L), "middle.right");
    location_is(polygon.middle.left, geohex_location(20.9605452560715L, 127.829429795593L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(20.9610930834072L, 127.830445900862L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(20.9610930834072L, 127.82976849735L), "bottom.left");
  }
  {
    note("geohex: XM602176827");
    geohex_t zone = geohex_get_zone_by_code("XM602176827");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(30.4472512737085L, 151.737370658267L), "top.right");
    location_is(polygon.top.left, geohex_location(30.4472512737085L, 151.736693254755L), "top.left");
    location_is(polygon.middle.right, geohex_location(30.4477570198834L, 151.737709360023L), "middle.right");
    location_is(polygon.middle.left, geohex_location(30.4477570198834L, 151.736354552998L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(30.4482627634342L, 151.737370658267L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(30.4482627634342L, 151.736693254755L), "bottom.left");
  }
  {
    note("geohex: XM482452815");
    geohex_t zone = geohex_get_zone_by_code("XM482452815");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(34.8840529569388L, 138.377618587952L), "top.right");
    location_is(polygon.top.left, geohex_location(34.8840529569388L, 138.37694118444L), "top.left");
    location_is(polygon.middle.right, geohex_location(34.8845341899227L, 138.377957289709L), "middle.right");
    location_is(polygon.middle.left, geohex_location(34.8845341899227L, 138.376602482684L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(34.8850154200885L, 138.377618587952L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(34.8850154200885L, 138.37694118444L), "bottom.left");
  }
  {
    note("geohex: XX033123366");
    geohex_t zone = geohex_get_zone_by_code("XX033123366");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(43.3237458129131L, 142.596487662789L), "top.right");
    location_is(polygon.top.left, geohex_location(43.3237458129131L, 142.595810259276L), "top.left");
    location_is(polygon.middle.right, geohex_location(43.3241725915388L, 142.596826364545L), "middle.right");
    location_is(polygon.middle.left, geohex_location(43.3241725915388L, 142.59547155752L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(43.3245993671663L, 142.596487662789L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(43.3245993671663L, 142.595810259276L), "bottom.left");
  }
  {
    note("geohex: OI860616105");
    geohex_t zone = geohex_get_zone_by_code("OI860616105");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(28.6113084912756L, -115.09898558824L), "top.right");
    location_is(polygon.top.left, geohex_location(28.6113084912756L, -115.099662991753L), "top.left");
    location_is(polygon.middle.right, geohex_location(28.6118235021042L, -115.098646886484L), "middle.right");
    location_is(polygon.middle.left, geohex_location(28.6118235021042L, -115.100001693509L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(28.6123385104076L, -115.09898558824L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(28.6123385104076L, -115.099662991753L), "bottom.left");
  }
  {
    note("geohex: RX114077466");
    geohex_t zone = geohex_get_zone_by_code("RX114077466");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(46.3151145393293L, -108.770681975986L), "top.right");
    location_is(polygon.top.left, geohex_location(46.3151145393293L, -108.771359379498L), "top.left");
    location_is(polygon.middle.right, geohex_location(46.3155197311649L, -108.77034327423L), "middle.right");
    location_is(polygon.middle.left, geohex_location(46.3155197311649L, -108.771698081255L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(46.3159249200003L, -108.770681975986L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(46.3159249200003L, -108.771359379498L), "bottom.left");
  }
  {
    note("geohex: SV355072242");
    geohex_t zone = geohex_get_zone_by_code("SV355072242");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(66.5130728861928L, -76.2888448576606L), "top.right");
    location_is(polygon.top.left, geohex_location(66.5130728861928L, -76.2895222611729L), "top.left");
    location_is(polygon.middle.right, geohex_location(66.5133066879411L, -76.2885061559044L), "middle.right");
    location_is(polygon.middle.left, geohex_location(66.5133066879411L, -76.2898609629291L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(66.5135404874939L, -76.2888448576606L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(66.5135404874939L, -76.2895222611729L), "bottom.left");
  }
  {
    note("geohex: YG413103084");
    geohex_t zone = geohex_get_zone_by_code("YG413103084");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(70.8440811183794L, 98.2993784822774L), "top.right");
    location_is(polygon.top.left, geohex_location(70.8440811183794L, 98.2987010787651L), "top.left");
    location_is(polygon.middle.right, geohex_location(70.8442736203269L, 98.2997171840336L), "middle.right");
    location_is(polygon.middle.left, geohex_location(70.8442736203269L, 98.2983623770089L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(70.8444661204125L, 98.2993784822774L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(70.8444661204125L, 98.2987010787651L), "bottom.left");
  }
  {
    note("geohex: ZA486483578");
    geohex_t zone = geohex_get_zone_by_code("ZA486483578");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(75.496626160202L, 121.503158393876L), "top.right");
    location_is(polygon.top.left, geohex_location(75.496626160202L, 121.502480990364L), "top.left");
    location_is(polygon.middle.right, geohex_location(75.4967730780092L, 121.503497095632L), "middle.right");
    location_is(polygon.middle.left, geohex_location(75.4967730780092L, 121.502142288608L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(75.4969199943602L, 121.503158393876L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(75.4969199943602L, 121.502480990364L), "bottom.left");
  }
  {
    note("geohex: aX426174078");
    geohex_t zone = geohex_get_zone_by_code("aX426174078");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(77.5420412878298L, 16.8758150011008L), "top.right");
    location_is(polygon.top.left, geohex_location(77.5420412878298L, 16.8751375975884L), "top.left");
    location_is(polygon.middle.right, geohex_location(77.5421678409154L, 16.876153702857L), "middle.right");
    location_is(polygon.middle.left, geohex_location(77.5421678409154L, 16.8747988958323L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(77.5422943927357L, 16.8758150011008L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(77.5422943927357L, 16.8751375975884L), "bottom.left");
  }
  {
    note("geohex: aX747576237");
    geohex_t zone = geohex_get_zone_by_code("aX747576237");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(78.4900861697121L, 27.2837812664059L), "top.right");
    location_is(polygon.top.left, geohex_location(78.4900861697121L, 27.2831038628935L), "top.left");
    location_is(polygon.middle.right, geohex_location(78.4902032275222L, 27.2841199681621L), "middle.right");
    location_is(polygon.middle.left, geohex_location(78.4902032275222L, 27.2827651611374L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(78.4903202841578L, 27.2837812664059L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(78.4903202841578L, 27.2831038628935L), "bottom.left");
  }
  {
    note("geohex: TK184816376");
    geohex_t zone = geohex_get_zone_by_code("TK184816376");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(81.5181325752664L, 173.320462666599L), "top.right");
    location_is(polygon.top.left, geohex_location(81.5181325752664L, 173.319785263087L), "top.left");
    location_is(polygon.middle.right, geohex_location(81.5182191033962L, 173.320801368355L), "middle.right");
    location_is(polygon.middle.left, geohex_location(81.5182191033962L, 173.31944656133L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(81.5183056306498L, 173.320462666599L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(81.5183056306498L, 173.319785263087L), "bottom.left");
  }
  {
    note("geohex: TO310523631");
    geohex_t zone = geohex_get_zone_by_code("TO310523631");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(83.829706545322L, -175.918982539924L), "top.right");
    location_is(polygon.top.left, geohex_location(83.829706545322L, -175.919659943437L), "top.left");
    location_is(polygon.middle.right, geohex_location(83.829769600284L, -175.918643838168L), "middle.right");
    location_is(polygon.middle.left, geohex_location(83.829769600284L, -175.919998645193L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(83.8298326546042L, -175.918982539924L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(83.8298326546042L, -175.919659943437L), "bottom.left");
  }
  {
    note("geohex: TO423806423");
    geohex_t zone = geohex_get_zone_by_code("TO423806423");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.4057036494073L, 176.346424156209L), "top.right");
    location_is(polygon.top.left, geohex_location(84.4057036494073L, 176.345746752697L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.4057608378714L, 176.346762857965L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.4057608378714L, 176.345408050941L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.4058180257527L, 176.346424156209L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.4058180257527L, 176.345746752697L), "bottom.left");
  }
  {
    note("geohex: bb303856635");
    geohex_t zone = geohex_get_zone_by_code("bb303856635");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(84.8969778328773L, 87.4006333722841L), "top.right");
    location_is(polygon.top.left, geohex_location(84.8969778328773L, 87.3999559687717L), "top.left");
    location_is(polygon.middle.right, geohex_location(84.8970300131518L, 87.4009720740402L), "middle.right");
    location_is(polygon.middle.left, geohex_location(84.8970300131518L, 87.3996172670156L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(84.897082192894L, 87.4006333722841L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(84.897082192894L, 87.3999559687717L), "bottom.left");
  }
  {
    note("geohex: TO815178640");
    geohex_t zone = geohex_get_zone_by_code("TO815178640");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(85.0496303257969L, 176.891056580128L), "top.right");
    location_is(polygon.top.left, geohex_location(85.0496303257969L, 176.890379176616L), "top.left");
    location_is(polygon.middle.right, geohex_location(85.0496809490896L, 176.891395281885L), "middle.right");
    location_is(polygon.middle.left, geohex_location(85.0496809490896L, 176.89004047486L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(85.049731571866L, 176.891056580128L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(85.049731571866L, 176.890379176616L), "bottom.left");
  }
  {
    note("geohex: SV1700305142");
    geohex_t zone = geohex_get_zone_by_code("SV1700305142");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(65.9464610452602L, -84.3748976838445L), "top.right");
    location_is(polygon.top.left, geohex_location(65.9464610452602L, -84.3751234850153L), "top.left");
    location_is(polygon.middle.right, geohex_location(65.9465407491988L, -84.3747847832591L), "middle.right");
    location_is(polygon.middle.left, geohex_location(65.9465407491988L, -84.3752363856007L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(65.9466204528889L, -84.3748976838445L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(65.9466204528889L, -84.3751234850153L), "bottom.left");
  }
  {
    note("geohex: BV5482764471");
    geohex_t zone = geohex_get_zone_by_code("BV5482764471");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511319305883L, -87.0225293118145L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511319305883L, -87.0227551129853L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511150611485L, -87.0224164112291L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511150611485L, -87.0228680135707L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0510981916512L, -87.0225293118145L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0510981916512L, -87.0227551129853L), "bottom.left");
  }
  {
    note("geohex: BV7560068257");
    geohex_t zone = geohex_get_zone_by_code("BV7560068257");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0501871536168L, -74.0258655241127L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0501871536168L, -74.0260913252835L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0501702809645L, -74.0257526235274L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0501702809645L, -74.0262042258689L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0501534082548L, -74.0258655241127L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0501534082548L, -74.0260913252835L), "bottom.left");
  }
  {
    note("geohex: CI5263615540");
    geohex_t zone = geohex_get_zone_by_code("CI5263615540");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1413126810499L, 110.742377799229L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1413126810499L, 110.742151998058L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1412961182694L, 110.742490699814L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1412961182694L, 110.742039097473L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.1412795554325L, 110.742377799229L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.1412795554325L, 110.742151998058L), "bottom.left");
  }
  {
    note("geohex: CI7265571616");
    geohex_t zone = geohex_get_zone_by_code("CI7265571616");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1114249591416L, 123.398646321981L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1114249591416L, 123.39842052081L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1114082947234L, 123.398759222567L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1114082947234L, 123.398307620225L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.1113916302485L, 123.398646321981L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.1113916302485L, 123.39842052081L), "bottom.left");
  }
  {
    note("geohex: CI7505181555");
    geohex_t zone = geohex_get_zone_by_code("CI7505181555");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0813706016566L, 124.101791167787L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0813706016566L, 124.101565366616L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0813538350387L, 124.101904068373L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0813538350387L, 124.101452466031L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0813370683637L, 124.101791167787L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0813370683637L, 124.101565366616L), "bottom.left");
  }
  {
    note("geohex: CI5736546251");
    geohex_t zone = geohex_get_zone_by_code("CI5736546251");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511319305883L, 116.718770286824L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511319305883L, 116.718544485653L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511150611485L, 116.718883187409L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511150611485L, 116.718431585068L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0510981916512L, 116.718770286824L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0510981916512L, 116.718544485653L), "bottom.left");
  }
  {
    note("geohex: DO0273028158");
    geohex_t zone = geohex_get_zone_by_code("DO0273028158");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.1114416235032L, 176.484388671555L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.1114416235032L, 176.484162870384L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.1114249591416L, 176.484501572141L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.1114249591416L, 176.484049969799L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.1114082947234L, 176.484388671555L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.1114082947234L, 176.484162870384L), "bottom.left");
  }
  {
    note("geohex: DO0536546500");
    geohex_t zone = geohex_get_zone_by_code("DO0536546500");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, 178.945395631876L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, 178.945169830706L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511319305883L, 178.945508532462L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511319305883L, 178.94505693012L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0511150611485L, 178.945395631876L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0511150611485L, 178.945169830706L), "bottom.left");
  }
  {
    note("geohex: DO0716764500");
    geohex_t zone = geohex_get_zone_by_code("DO0716764500");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-85.0511487999708L, -177.890452561996L), "top.right");
    location_is(polygon.top.left, geohex_location(-85.0511487999708L, -177.890678363167L), "top.left");
    location_is(polygon.middle.right, geohex_location(-85.0511319305883L, -177.890339661411L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-85.0511319305883L, -177.890791263753L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-85.0511150611485L, -177.890452561996L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-85.0511150611485L, -177.890678363167L), "bottom.left");
  }
  {
    note("geohex: EU4016113514");
    geohex_t zone = geohex_get_zone_by_code("EU4016113514");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.2066167467967L, 179.648540477682L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.2066167467967L, 179.648314676512L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.2065767797249L, 179.648653378268L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.2065767797249L, 179.648201775926L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.2065368125195L, 179.648540477682L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.2065368125195L, 179.648314676512L), "bottom.left");
  }
  {
    note("geohex: EU4827777232");
    geohex_t zone = geohex_get_zone_by_code("EU4827777232");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-76.9520512140467L, 178.878671385911L), "top.right");
    location_is(polygon.top.left, geohex_location(-76.9520512140467L, 178.87844558474L), "top.left");
    location_is(polygon.middle.right, geohex_location(-76.9520070654571L, 178.878784286497L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-76.9520070654571L, 178.878332684155L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-76.9519629167208L, 178.878671385911L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-76.9519629167208L, 178.87844558474L), "bottom.left");
  }
  {
    note("geohex: EU7445272188");
    geohex_t zone = geohex_get_zone_by_code("EU7445272188");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-76.6712988059574L, -173.738646434882L), "top.right");
    location_is(polygon.top.left, geohex_location(-76.6712988059574L, -173.738872236053L), "top.left");
    location_is(polygon.middle.right, geohex_location(-76.6712537244362L, -173.738533534296L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-76.6712537244362L, -173.738985136638L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-76.6712086427653L, -173.738646434882L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-76.6712086427653L, -173.738872236053L), "bottom.left");
  }
  {
    note("geohex: OK1777354303");
    geohex_t zone = geohex_get_zone_by_code("OK1777354303");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-51.179458323895L, 56.6015794791896L), "top.right");
    location_is(polygon.top.left, geohex_location(-51.179458323895L, 56.6013536780188L), "top.left");
    location_is(polygon.middle.right, geohex_location(-51.1793357370083L, 56.601692379775L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-51.1793357370083L, 56.6012407774334L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-51.1792131497957L, 56.6015794791896L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-51.1792131497957L, 56.6013536780188L), "bottom.left");
  }
  {
    note("geohex: CZ3420476772");
    geohex_t zone = geohex_get_zone_by_code("CZ3420476772");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-78.4202673865305L, -14.765590159585L), "top.right");
    location_is(polygon.top.left, geohex_location(-78.4202673865305L, -14.7658159607558L), "top.left");
    location_is(polygon.middle.right, geohex_location(-78.4202281335297L, -14.7654772589996L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-78.4202281335297L, -14.7659288613412L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-78.4201888803977L, -14.765590159585L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-78.4201888803977L, -14.7658159607558L), "bottom.left");
  }
  {
    note("geohex: Fb4334484641");
    geohex_t zone = geohex_get_zone_by_code("Fb4334484641");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-50.9586433747794L, -97.0311662065968L), "top.right");
    location_is(polygon.top.left, geohex_location(-50.9586433747794L, -97.0313920077676L), "top.left");
    location_is(polygon.middle.right, geohex_location(-50.9585202016351L, -97.0310533060114L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-50.9585202016351L, -97.031504908353L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-50.9583970281643L, -97.0311662065968L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-50.9583970281643L, -97.0313920077676L), "bottom.left");
  }
  {
    note("geohex: GH5856584625");
    geohex_t zone = geohex_get_zone_by_code("GH5856584625");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-15.9615870788838L, -166.992046153759L), "top.right");
    location_is(polygon.top.left, geohex_location(-15.9615870788838L, -166.99227195493L), "top.left");
    location_is(polygon.middle.right, geohex_location(-15.9613990684089L, -166.991933253174L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-15.9613990684089L, -166.992384855515L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-15.9612110577575L, -166.992046153759L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-15.9612110577575L, -166.99227195493L), "bottom.left");
  }
  {
    note("geohex: GI1730824803");
    geohex_t zone = geohex_get_zone_by_code("GI1730824803");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-14.5692015319049L, 176.241878214138L), "top.right");
    location_is(polygon.top.left, geohex_location(-14.5692015319049L, 176.241652412968L), "top.left");
    location_is(polygon.middle.right, geohex_location(-14.5690122702619L, 176.241991114724L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-14.5690122702619L, 176.241539512382L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-14.5688230084564L, 176.241878214138L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-14.5688230084564L, 176.241652412968L), "bottom.left");
  }
  {
    note("geohex: GI7234521114");
    geohex_t zone = geohex_get_zone_by_code("GI7234521114");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-8.05926566432509L, -177.187307716191L), "top.right");
    location_is(polygon.top.left, geohex_location(-8.05926566432509L, -177.187533517361L), "top.left");
    location_is(polygon.middle.right, geohex_location(-8.05907204605798L, -177.187194815605L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-8.05907204605798L, -177.187646417947L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-8.05887842769819L, -177.187307716191L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-8.05887842769819L, -177.187533517361L), "bottom.left");
  }
  {
    note("geohex: QU3851424320");
    geohex_t zone = geohex_get_zone_by_code("QU3851424320");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(10.4877080806808L, -174.374728332966L), "top.right");
    location_is(polygon.top.left, geohex_location(10.4877080806808L, -174.374954134137L), "top.left");
    location_is(polygon.middle.right, geohex_location(10.4879003633167L, -174.374615432381L), "middle.right");
    location_is(polygon.middle.left, geohex_location(10.4879003633167L, -174.375067034723L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(10.488092645833L, -174.374728332966L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(10.488092645833L, -174.374954134137L), "bottom.left");
  }
  {
    note("geohex: QU8152020110");
    geohex_t zone = geohex_get_zone_by_code("QU8152020110");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(17.9786334513613L, 176.484388671555L), "top.right");
    location_is(polygon.top.left, geohex_location(17.9786334513613L, 176.484162870384L), "top.left");
    location_is(polygon.middle.right, geohex_location(17.9788194524589L, 176.484501572141L), "middle.right");
    location_is(polygon.middle.left, geohex_location(17.9788194524589L, 176.484049969799L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(17.9790054533606L, 176.484388671555L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(17.9790054533606L, 176.484162870384L), "bottom.left");
  }
  {
    note("geohex: PA0426257051");
    geohex_t zone = geohex_get_zone_by_code("PA0426257051");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(3.86386480752959L, -61.171795175758L), "top.right");
    location_is(polygon.top.left, geohex_location(3.86386480752959L, -61.1720209769288L), "top.left");
    location_is(polygon.middle.right, geohex_location(3.86405991256846L, -61.1716822751726L), "middle.right");
    location_is(polygon.middle.left, geohex_location(3.86405991256846L, -61.1721338775142L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(3.86425501756247L, -61.171795175758L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(3.86425501756247L, -61.1720209769288L), "bottom.left");
  }
  {
    note("geohex: OY4244664644");
    geohex_t zone = geohex_get_zone_by_code("OY4244664644");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-0.000195549550100057L, -4.21875617425076L), "top.right");
    location_is(polygon.top.left, geohex_location(-0.000195549550100057L, -4.21898197542154L), "top.left");
    location_is(polygon.middle.right, geohex_location(0.0L, -4.21864327366537L), "middle.right");
    location_is(polygon.middle.left, geohex_location(0.0L, -4.21909487600693L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(0.000195549550087335L, -4.21875617425076L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(0.000195549550087335L, -4.21898197542154L), "bottom.left");
  }
  {
    note("geohex: OY7353226324");
    geohex_t zone = geohex_get_zone_by_code("OY7353226324");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(2.84798344186291L, 8.1950018910848L), "top.right");
    location_is(polygon.top.left, geohex_location(2.84798344186291L, 8.19477608991403L), "top.left");
    location_is(polygon.middle.right, geohex_location(2.84817874986869L, 8.19511479167019L), "middle.right");
    location_is(polygon.middle.left, geohex_location(2.84817874986869L, 8.19466318932864L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(2.84837405784135L, 8.1950018910848L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(2.84837405784135L, 8.19477608991403L), "bottom.left");
  }
  {
    note("geohex: OY3444432334");
    geohex_t zone = geohex_get_zone_by_code("OY3444432334");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(-3.86445012251156L, 6.67998893574263L), "top.right");
    location_is(polygon.top.left, geohex_location(-3.86445012251156L, 6.67976313457185L), "top.left");
    location_is(polygon.middle.right, geohex_location(-3.86425501756244L, 6.68010183632802L), "middle.right");
    location_is(polygon.middle.left, geohex_location(-3.86425501756244L, 6.67965023398646L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(-3.86405991256843L, 6.67998893574263L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(-3.86405991256843L, 6.67976313457185L), "bottom.left");
  }
  {
    note("geohex: QU8136543688");
    geohex_t zone = geohex_get_zone_by_code("QU8136543688");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(17.3085199124803L, 178.945395631876L), "top.right");
    location_is(polygon.top.left, geohex_location(17.3085199124803L, 178.945169830706L), "top.left");
    location_is(polygon.middle.right, geohex_location(17.3087066067811L, 178.945508532462L), "middle.right");
    location_is(polygon.middle.left, geohex_location(17.3087066067811L, 178.94505693012L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(17.3088933008923L, 178.945395631876L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(17.3088933008923L, 178.945169830706L), "bottom.left");
  }
  {
    note("geohex: QU8831183154");
    geohex_t zone = geohex_get_zone_by_code("QU8831183154");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(20.7493001766198L, -179.583283939327L), "top.right");
    location_is(polygon.top.left, geohex_location(20.7493001766198L, -179.583509740498L), "top.left");
    location_is(polygon.middle.right, geohex_location(20.749483042625L, -179.583171038742L), "middle.right");
    location_is(polygon.middle.left, geohex_location(20.749483042625L, -179.583622641083L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(20.7496659084091L, -179.583283939327L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(20.7496659084091L, -179.583509740498L), "bottom.left");
  }
  {
    note("geohex: PS6206841033");
    geohex_t zone = geohex_get_zone_by_code("PS6206841033");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(21.779643369772L, 129.375038809576L), "top.right");
    location_is(polygon.top.left, geohex_location(21.779643369772L, 129.374813008405L), "top.left");
    location_is(polygon.middle.right, geohex_location(21.7798249604327L, 129.375151710162L), "middle.right");
    location_is(polygon.middle.left, geohex_location(21.7798249604327L, 129.37470010782L), "middle.left");
    location_is(polygon.bottom.right, geohex_location(21.7800065508635L, 129.375038809576L), "bottom.right");
    location_is(polygon.bottom.left, geohex_location(21.7800065508635L, 129.374813008405L), "bottom.left");
  }
  {
    note("geohex: XM0565771230");
    geohex_t zone = geohex_get_zone_by_code("XM0565771230");
    geohex_polygon_t polygon = geohex_get_hex_polygon(&zone);
    location_is(polygon.top.right, geohex_location(27.3263890033868L, 139.107972474837L), "top.