package Data::Apple::PriceTier;
use strict;
use warnings;
use Carp;
use 5.008001;

our $VERSION = '0.05';

our %COUNTRIES = (
    'U.S.'         => 0,
    'Canada'       => 1,
    'Mexico'       => 2,
    'Australia'    => 3,
    'New Zealand'  => 4,
    'Japan'        => 5,
    'Europe'       => 6,
    'Switzerland'  => 7,
    'Norway'       => 8,
    'U.K.'         => 9,
    'Denmark'      => 10,
    'Sweden'       => 11,
    'China'        => 12,
    'Singapore'    => 13,
    'Hong Kong'    => 14,
    'Taiwan'       => 15,
    'Russia'       => 16,
    'Turkey'       => 17,
    'India'        => 18,
    'Indonesia'    => 19,
    'Isreal'       => 20,
    'South Africa' => 21,
    'Saudi Arabia' => 22,
    'UAE'          => 23,
);

our %CURRENCIES = (
    'US$'  => 0,
    'CAD'  => 1,
    'MXP'  => 2,
    'AUD'  => 3,
    'NZD'  => 4,
    'Yen'  => 5,
    'Euro' => 6,
    'CHF'  => 7,
    'NOK'  => 8,
    'GBP'  => 9,
    'DKK'  => 10,
    'SEK'  => 11,
    'CNY'  => 12,
    'SGD'  => 13,
    'HKD'  => 14,
    'TWD'  => 15,
    'RUB'  => 16,
    'TRY'  => 17,
    'INR'  => 18,
    'IDR'  => 19,
    'ILS'  => 20,
    'ZAR'  => 21,
    'SAR'  => 22,
    'AED'  => 23,
);

our $PRICE_MATRIX = [
    [    0.99,    0.99,   12.00,    0.99,    1.29,      85,    0.79,    1.00,    7.00,    0.69,    6.00,    7.00,       6,    1.28,    8.00,      30,      33,    1.79,      55,    9500,     3.9,    7.99,    3.69,    3.69],
    [    1.99,    1.99,      24,    1.99,    2.59,     170,    1.59,    2.00,   14.00,    1.49,   12.00,   15.00,      12,    2.58,   15.00,      60,      66,    3.59,     110,   19000,     7.9,   15.99,    7.29,    7.29],
    [    2.99,    2.99,      36,    2.99,    4.19,     250,    2.39,    3.00,   21.00,    1.99,   18.00,   22.00,      18,    3.98,   23.00,      90,      99,    5.49,     170,   29000,   11.90,   24.99,   10.99,   10.99],
    [    3.99,    3.99,      48,    4.49,    5.29,     350,    2.99,    4.00,   28.00,    2.49,   24.00,   28.00,      25,    4.98,   28.00,     120,     129,    6.99,     220,   39000,   15.90,   32.99,   14.99,   14.99],
    [    4.99,    4.99,      60,    5.49,    6.49,     450,    3.99,    5.00,   35.00,    2.99,   30.00,   38.00,      30,    5.98,   38.00,     150,     169,    8.99,     270,   49000,   19.90,   39.99,   17.99,   17.99],
    [    5.99,    5.99,      72,    6.49,    8.29,     500,    4.99,    6.00,   42.00,    3.99,   36.00,   45.00,      40,    6.98,   48.00,     180,     199,   10.99,     350,   59000,   23.90,   48.99,   20.99,   20.99],
    [    6.99,    6.99,      84,    7.49,    9.99,     600,    5.49,    7.00,   49.00,    4.99,   42.00,   49.00,      45,    8.98,   53.00,     210,     229,   12.99,     390,   69000,   27.90,   56.99,   24.99,   24.99],
    [    7.99,    7.99,      96,    8.49,   10.99,     700,    5.99,    8.00,   56.00,    5.49,   48.00,   55.00,      50,    9.98,   58.00,     240,     269,   14.99,     450,   79000,   31.90,   64.99,   29.99,   29.99],
    [    8.99,    8.99,     108,    9.49,   12.99,     800,    6.99,    9.00,   63.00,    5.99,   54.00,   65.00,      60,   10.98,   68.00,     270,     299,   16.99,     490,   89000,   35.90,   72.99,   32.99,   32.99],
    [    9.99,    9.99,     120,   10.49,   13.99,     850,    7.99,   10.00,   70.00,    6.99,   59.00,   75.00,      68,   12.98,   78.00,     300,     329,   17.99,     550,   95000,   39.90,   79.99,   36.99,   36.99],
    [   10.99,   10.99,     130,   11.49,   14.99,     900,    8.99,   11.00,   77.00,    7.49,   69.00,   85.00,      73,   13.98,   83.00,     330,     349,   19.99,     590,   99000,   43.90,   89.99,   39.99,   39.99],
    [   11.99,   11.99,     140,   12.99,   15.99,    1000,    9.99,   12.00,   84.00,    7.99,   75.00,   95.00,      78,   14.98,   88.00,     360,     379,   21.99,     650,  109000,   47.90,   99.99,   44.99,   44.99],
    [   12.99,   12.99,     160,   13.99,   16.99,    1100,   10.49,   13.00,   91.00,    8.99,   79.00,   99.00,      88,   15.98,   98.00,     390,     399,   23.99,     690,  119000,   51.90,  109.99,   47.99,   47.99],
    [   13.99,   13.99,     170,   14.99,   17.99,    1200,   10.99,   14.00,   98.00,    9.99,   85.00,  105.00,      93,   17.98,  108.00,     420,     449,   24.99,     750,  129000,   55.90,  114.99,   49.99,   49.99],
    [   14.99,   14.99,     180,   15.99,   18.99,    1300,   11.99,   15.00,  105.00,   10.49,   89.00,  109.00,      98,   18.98,  118.00,     450,     479,   26.99,     790,  139000,   59.90,  119.99,   54.99,   54.99],
    [   15.99,   15.99,     190,   16.99,   19.99,    1400,   12.99,   16.00,  112.00,   10.99,   99.00,  119.00,     108,   19.98,  123.00,     490,     499,   28.99,     890,  149000,   63.90,  129.99,   59.99,   59.99],
    [   16.99,   16.99,     200,   17.99,   20.99,    1500,   13.99,   17.00,  119.00,   11.99,  105.00,  129.00,     113,   21.98,  128.00,     520,     549,   30.99,     950,  159000,   67.90,  139.99,   64.99,   64.99],
    [   17.99,   17.99,     220,   18.99,   22.99,    1600,   14.49,   18.00,  126.00,   12.99,  109.00,  135.00,     118,   22.98,  138.00,     540,     579,   32.99,     990,  169000,   71.90,  149.99,   67.99,   67.99],
    [   18.99,   18.99,     230,   19.99,   23.99,    1650,   14.99,   19.00,  133.00,   13.49,  115.00,  139.00,     123,   23.98,  148.00,     570,     599,   34.99,    1050,  179000,   75.90,  154.99,   69.99,   69.99],
    [   19.99,   19.99,     240,   20.99,   24.99,    1700,   15.99,   20.00,  140.00,   13.99,  119.00,  149.00,     128,   25.98,  158.00,     590,     649,   35.99,    1100,  189000,   79.90,  159.99,   74.99,   74.99],
    [   20.99,   20.99,     250,   21.99,   25.99,    1800,   16.99,   21.00,  147.00,   14.99,  125.00,  159.00,     138,   26.98,  163.00,     630,     679,   37.99,    1150,  199000,   83.90,  169.99,   77.99,   77.99],
    [   21.99,   21.99,     260,   22.99,   27.99,    1900,   17.99,   22.00,  154.00,   15.49,  129.00,  169.00,     148,   27.98,  168.00,     660,     699,   39.99,    1200,  209000,   87.90,  179.99,   79.99,   79.99],
    [   22.99,   22.99,     270,   23.99,   28.99,    2000,   18.49,   23.00,  161.00,   15.99,  135.00,  175.00,     153,   28.98,  178.00,     690,     749,   41.99,    1250,  219000,   91.90,  189.99,   84.99,   84.99],
    [   23.99,   23.99,     280,   24.99,   29.99,    2100,   18.99,   24.00,  168.00,   16.99,  139.00,  179.00,     158,   30.98,  188.00,     720,     779,   43.99,    1300,  229000,   95.90,  194.99,   87.99,   87.99],
    [   24.99,   24.99,     300,   25.99,   30.99,    2200,   19.99,   25.00,  175.00,   17.49,  149.00,  189.00,     163,   31.98,  198.00,     750,     799,   44.99,    1350,  239000,   99.90,  199.99,   89.99,   89.99],
    [   25.99,   25.99,     310,   26.99,   32.99,    2300,   20.99,   26.00,  182.00,   17.99,  155.00,  195.00,     168,   32.98,  203.00,     790,     849,   46.99,    1400,  249000,  103.90,  209.99,   94.99,   94.99],
    [   26.99,   26.99,     320,   27.99,   34.99,    2400,   21.49,   27.00,  189.00,   18.99,  159.00,  199.00,     178,   34.98,  208.00,     820,     879,   48.99,    1500,  259000,  107.90,  219.99,   99.99,   99.99],
    [   27.99,   27.99,     330,   29.99,   35.99,    2450,   21.99,   28.00,  196.00,   19.49,  165.00,  209.00,     188,   35.98,  218.00,     840,     899,   50.99,    1550,  269000,  111.90,  229.99,  104.99,  104.99],
    [   28.99,   28.99,     340,   30.99,   36.99,    2500,   22.99,   28.50,  203.00,   19.99,  169.00,  219.00,     193,   36.98,  228.00,     870,     949,   52.99,    1600,  279000,  115.90,  234.99,  107.99,  107.99],
    [   29.99,   29.99,     360,   31.99,   38.99,    2600,   23.99,   29.00,  209.00,   20.99,  179.00,  229.00,     198,   38.98,  238.00,     890,     979,   53.99,    1650,  289000,  119.90,  239.99,  109.99,  109.99],
    [   30.99,   30.99,     370,   32.99,   39.99,    2700,   24.99,   30.00,  217.00,   21.99,  185.00,  235.00,     208,   39.98,  243.00,     930,     999,   55.99,    1700,  299000,  123.90,  249.99,  114.99,  114.99],
    [   31.99,   31.99,     380,   33.99,   40.99,    2800,   25.49,   31.00,  224.00,   22.49,  189.00,  239.00,     218,   40.98,  248.00,     960,    1029,   57.99,    1750,  309000,  127.90,  259.99,  117.99,  117.99],
    [   32.99,   32.99,     390,   34.99,   41.99,    2900,   25.99,   32.00,  231.00,   22.99,  195.00,  245.00,     223,   41.98,  258.00,     990,    1049,   59.99,    1800,  319000,  131.90,  269.99,  119.99,  119.99],
    [   33.99,   33.99,     400,   35.99,   43.99,    2950,   26.99,   33.00,  238.00,   23.99,  199.00,  249.00,     228,   43.98,  268.00,    1020,    1099,   61.99,    1850,  329000,  135.90,  274.99,  124.99,  124.99],
    [   34.99,   34.99,     420,   36.99,   44.99,    3000,   27.99,   34.00,  245.00,   24.49,  209.00,  265.00,     233,   44.98,  278.00,    1050,    1129,   62.99,    1900,  339000,  139.90,  279.99,  127.99,  127.99],
    [   35.99,   35.99,     430,   37.99,   45.99,    3100,   28.99,   35.00,  252.00,   24.99,  215.00,  269.00,     238,   45.98,  283.00,    1090,    1149,   64.99,    2000,  349000,  143.90,  289.99,  129.99,  129.99],
    [   36.99,   36.99,     440,   38.99,   46.99,    3200,   29.49,   36.00,  259.00,   25.99,  219.00,  275.00,     243,   47.98,  288.00,    1120,    1199,   66.99,    2050,  359000,  147.90,  299.99,  134.99,  134.99],
    [   37.99,   37.99,     450,   39.99,   47.99,    3300,   29.99,   37.00,  266.00,   26.99,  225.00,  285.00,     248,   48.98,  298.00,    1140,    1229,   68.99,    2100,  369000,  151.90,  309.99,  139.99,  139.99],
    [   38.99,   38.99,     470,   40.99,   48.99,    3400,   30.99,   38.00,  273.00,   27.49,  229.00,  289.00,     253,   49.98,  308.00,    1170,    1249,   70.99,    2150,  379000,  155.90,  314.99,  144.99,  144.99],
    [   39.99,   39.99,     480,   41.99,   49.99,    3450,   31.99,   39.00,  280.00,   27.99,  239.00,  299.00,     258,   51.98,  318.00,    1190,    1299,   71.99,    2200,  389000,  159.90,  319.99,  147.99,  147.99],
    [   40.99,   40.99,     490,   42.99,   50.99,    3500,   32.99,   40.00,  287.00,   28.99,  245.00,  309.00,     263,   52.98,  323.00,    1230,    1329,   73.99,    2250,  395000,  163.90,  329.99,  149.99,  149.99],
    [   41.99,   41.99,     500,   43.99,   51.99,    3600,   33.49,   41.00,  294.00,   29.49,  249.00,  315.00,     268,   53.98,  328.00,    1260,    1349,   75.99,    2300,  399000,  167.90,  339.99,  154.99,  154.99],
    [   42.99,   42.99,     520,   44.99,   53.99,    3700,   33.99,   42.00,  301.00,   29.99,  255.00,  319.00,     273,   54.98,  338.00,    1290,    1399,   77.99,    2350,  409000,  171.90,  349.99,  157.99,  157.99],
    [   43.99,   43.99,     530,   45.99,   54.99,    3800,   34.99,   43.00,  308.00,   30.99,  259.00,  329.00,     278,   56.98,  348.00,    1320,    1429,   79.99,    2400,  419000,  175.90,  354.99,  159.99,  159.99],
    [   44.99,   44.99,     540,   46.99,   55.99,    3900,   35.99,   44.00,  315.00,   31.99,  269.00,  339.00,     283,   57.98,  358.00,    1350,    1449,   80.99,    2450,  429000,  179.90,  359.99,  164.99,  164.99],
    [   45.99,   45.99,     550,   47.99,   56.99,    3950,   36.99,   45.00,  322.00,   32.49,  275.00,  345.00,     288,   58.98,  363.00,    1390,    1499,   82.99,    2500,  439000,  183.90,  369.99,  167.99,  167.99],
    [   46.99,   46.99,     560,   48.99,   58.99,    4000,   37.49,   46.00,  329.00,   32.99,  279.00,  349.00,     298,   60.98,  368.00,    1420,    1529,   84.99,    2550,  449000,  187.90,  379.99,  169.99,  169.99],
    [   47.99,   47.99,     570,   49.99,   59.99,    4100,   37.99,   47.00,  336.00,   33.99,  285.00,  359.00,     308,   61.98,  378.00,    1440,    1549,   86.99,    2600,  459000,  191.90,  389.99,  174.99,  174.99],
    [   48.99,   48.99,     580,   50.99,   60.99,    4200,   38.99,   47.50,  343.00,   34.49,  289.00,  369.00,     318,   62.98,  388.00,    1470,    1590,   88.99,    2650,  469000,  195.90,  394.99,  179.99,  179.99],
    [   49.99,   49.99,     600,   51.99,   64.99,    4300,   39.99,   48.00,  349.00,   34.99,  299.00,  379.00,     328,   64.98,  398.00,    1490,    1690,   89.99,    2700,  479000,  199.90,  399.99,  184.99,  184.99],
    [   54.99,   54.99,     650,   59.99,   74.99,    4800,   42.99,   55.00,  385.00,   37.99,  319.00,  399.00,     348,   68.98,  418.00,    1590,    1790,   99.99,    2900,  499000,  219.90,  449.99,  199.99,  199.99],
    [   59.99,   59.99,     700,   64.99,   79.99,    5200,   44.99,   60.00,  420.00,   39.99,  339.00,  419.00,     388,   74.98,  448.00,    1790,    1990,  109.99,    3200,  549000,  239.90,  499.99,  219.99,  219.99],
    [   64.99,   64.99,     800,   69.99,   84.99,    5700,   49.99,   65.00,  455.00,   44.99,  369.00,  469.00,     418,   78.98,  488.00,    1990,    2090,  119.99,    3500,  599000,  259.90,  549.99,  229.99,  229.99],
    [   69.99,   69.99,     850,   74.99,   94.99,    6100,   54.99,   70.00,  490.00,   47.99,  399.00,  519.00,     448,   88.98,  548.00,    2090,    2290,  129.99,    3900,  649000,  279.90,  579.99,  249.99,  249.99],
    [   74.99,   74.99,     900,   79.99,   99.99,    6500,   59.99,   75.00,  525.00,   49.99,  439.00,  569.00,     488,   94.98,  588.00,    2190,    2490,  139.99,    4200,  699000,  299.90,  599.99,  279.99,  279.99],
    [   79.99,   79.99,     950,   84.99,  104.99,    6900,   62.99,   80.00,  560.00,   54.99,  469.00,  599.00,     518,   98.98,  618.00,    2390,    2690,  144.99,    4500,  749000,  319.90,  649.99,  299.99,  299.99],
    [   84.99,   84.99,    1000,   89.99,  109.99,    7400,   64.99,   85.00,  595.00,   57.99,  499.00,  619.00,     548,  104.98,  648.00,    2490,    2790,  149.99,    4700,  799000,  339.90,  699.99,  319.99,  319.99],
    [   89.99,   89.99,    1100,   94.99,  114.99,    7800,   69.99,   90.00,  630.00,   59.99,  529.00,  659.00,     588,  108.98,  688.00,    2690,    2990,  159.99,    4900,  849000,  359.90,  749.99,  329.99,  329.99],
    [   94.99,   94.99,    1150,   99.99,  119.99,    8200,   74.99,   95.00,  665.00,   64.99,  559.00,  699.00,     618,  118.98,  748.00,    2790,    3090,  169.99,    5200,  899000,  379.90,  779.99,  349.99,  349.99],
    [   99.99,   99.99,    1200,  109.99,  124.99,    8500,   79.99,  100.00,  700.00,   69.99,  599.00,  749.00,     648,  128.98,  788.00,    2990,    3290,  179.99,    5500,  949000,  399.90,  799.99,  369.99,  369.99],
    [  109.99,  109.99,    1300,  119.99,  149.99,    9500,   84.99,  110.00,  770.00,   74.99,  629.00,  799.00,     698,  138.98,  848.00,    3290,    3490,  199.99,    5900, 1049000,  439.90,  899.99,  399.99,  399.99],
    [  119.99,  119.99,    1400,  129.99,  159.99,   10500,   89.99,  120.00,  840.00,   79.99,  669.00,  849.00,     798,  148.98,  888.00,    3590,    3790,  219.99,    6500, 1149000,  479.90,  999.99,  429.99,  429.99],
    [  124.99,  124.99,    1500,  134.99,  164.99,   11000,   92.99,  125.00,  870.00,   84.99,  689.00,  879.00,  818.00,  158.98,  988.00,    3790,    3890,  229.99,    6900, 1199000,  499.90, 1049.99,  449.99,  449.99],
    [  129.99,  129.99,    1600,  139.99,  169.99,   11500,   94.99,  130.00,  910.00,   89.99,  699.00,  899.00,     848,  168.98, 1048.00,    3890,    3990,  239.99,    7500, 1249000,  519.90, 1099.99,  479.99,  479.99],
    [  139.99,  139.99,    1700,  149.99,  179.99,   12500,   99.99,  140.00,  980.00,   94.99,  749.00,  949.00,     898,  178.98, 1088.00,    4190,    4490,  249.99,    7900, 1299000,  559.90, 1149.99,  499.99,  499.99],
    [  149.99,  149.99,    1800,  159.99,  199.99,   13000,  109.99,  150.00, 1050.00,   99.99,  819.00,  999.00,     998,  188.98, 1188.00,    4490,    4790,  269.99,    8500, 1399000,  599.90, 1199.99,  549.99,  549.99],
    [  159.99,  159.99,    1900,  169.99,  209.99,   14000,  119.99,  160.00, 1120.00,  109.99,  899.00, 1099.00,    1048,  198.98, 1248.00,    4790,    4990,  289.99,    8900, 1499000,  639.90, 1299.99,  579.99,  579.99],
    [  169.99,  169.99,    2000,  179.99,  229.99,   15000,  124.99,  170.00, 1190.00,  119.99,  929.00, 1179.00,    1098,  208.98, 1288.00,    5090,    5490,  309.99,    9500, 1599000,  679.90, 1399.99,  599.99,  599.99],
    [  174.99,  174.99,    2100,  184.99,  234.99,   15500,  127.99,  175.00, 1220.00,  122.99,  949.00, 1199.00, 1148.00,  218.98, 1388.00,    5290,    5690,  319.99,    9900, 1649000,  699.90, 1449.99,  649.99,  649.99],
    [  179.99,  179.99,    2200,  189.99,  239.99,   16000,  129.99,  180.00, 1260.00,  124.99,  969.00, 1239.00,    1198,  228.98, 1448.00,    5390,    5790,  329.99,   10500, 1699000,  719.90, 1499.99,  679.99,  679.99],
    [  189.99,  189.99,    2300,  199.99,  249.99,   16500,  139.99,  190.00, 1330.00,  129.99, 1039.00, 1319.00,    1248,  238.98, 1488.00,    5690,    5990,  349.99,   10900, 1799000,  759.90, 1549.99,  699.99,  699.99],
    [  199.99,  199.99,    2400,  209.99,  259.99,   17000,  149.99,  200.00, 1400.00,  139.99, 1119.00, 1399.00,    1298,  258.98, 1588.00,    5990,    6490,  359.99,   11500, 1899000,  799.90, 1599.99,  749.99,  749.99],
    [  209.99,  209.99,    2500,  219.99,  269.99,   18000,  159.99,  210.00, 1470.00,  144.99, 1199.00, 1499.00,    1398,  268.98, 1648.00,    6290,    6790,  379.99,   11900, 1999000,  839.90, 1699.99,  779.99,  779.99],
    [  219.99,  219.99,    2700,  229.99,  279.99,   19000,  169.99,  220.00, 1540.00,  149.99, 1269.00, 1599.00,    1448,  278.98, 1688.00,    6590,    6990,  399.99,   12500, 2099000,  879.90, 1799.99,  799.99,  799.99],
    [  229.99,  229.99,    2800,  239.99,  289.99,   20000,  179.99,  230.00, 1610.00,  159.99, 1349.00, 1699.00,    1498,  288.98, 1788.00,    6890,    7490,  419.99,   12900, 2199000,  919.90, 1899.99,  849.99,  849.99],
    [  239.99,  239.99,    2900,  249.99,  299.99,   21000,  189.99,  240.00, 1680.00,  169.99, 1399.00, 1799.00,    1598,  298.98, 1848.00,    7190,    7790,  439.99,   13500, 2299000,  959.90, 1949.99,  879.99,  879.99],
    [  249.99,  249.99,    3000,  269.99,  319.99,   22000,  199.99,  250.00, 1750.00,  174.99, 1499.00, 1899.00,    1648,  308.98, 1888.00,    7490,    7990,  449.99,   13900, 2399000,  999.90, 1999.99,  899.99,  899.99],
    [  299.99,  299.99,    3600,  319.99,  399.99,   26000,  239.99,  300.00, 2100.00,  199.99, 1799.00, 2299.00,    1998,  368.98, 2288.00,    8990,    9790,  549.99,   15900, 2899000, 1199.90, 2499.99, 1099.99, 1099.99],
    [  349.99,  349.99,    4200,  379.99,  449.99,   30000,  279.99,  350.00, 2450.00,  249.99, 1999.00, 2599.00,    2298,  428.98, 2688.00,    9990,   11490,  649.99,   18900, 3399000, 1399.90, 2999.99, 1299.99, 1299.99],
    [  399.99,  399.99,    4800,  429.99,  499.99,   35000,  319.99,  400.00, 2800.00,  299.99, 2399.00, 2999.00,    2598,  488.98, 3088.00,   11900,   12990,  749.99,   21900, 3899000, 1599.90, 3299.99, 1499.99, 1499.99],
    [  449.99,  449.99,    5400,  499.99,  549.99,   39000,  359.99,  450.00, 3150.00,  324.99, 2699.00, 3399.00,    2998,  588.98, 3488.00,   12900,   14990,  799.99,   24900, 4299000, 1799.90, 3799.99, 1599.99, 1599.99],
    [  499.99,  499.99,    6000,  549.99,  649.99,   42500,  399.99,  500.00, 3500.00,  349.99, 2999.00, 3799.00,    3298,  648.98, 3888.00,   14900,   16990,  899.99,   27900, 4799000, 1999.90, 3999.99, 1799.99, 1799.99],
    [  599.99,  599.99,    7200,  649.99,  749.99,   50000,  479.99,  600.00, 4200.00,  399.99, 3499.00, 4499.00,    3998,  788.98, 4488.00,   17900,   19990, 1099.99,   32900, 5499000, 2399.90, 4999.99, 2199.99, 2199.99],
    [  699.99,  699.99,    8400,  749.99,  849.99,   60000,  559.99,  700.00, 4900.00,  499.99, 3999.00, 5299.00,    4498,  888.98, 4988.00,   20900,   22990, 1299.99,   38900, 6499000, 2799.90, 5999.99, 2499.99, 2499.99],
    [  799.99,  799.99,    9600,  849.99,  949.99,   70000,  639.99,  800.00, 5600.00,  549.99, 4799.00, 5999.00,    4998,  988.98, 5988.00,   23900,   26990, 1399.99,   44900, 7499000, 3199.90, 6499.99, 2999.99, 2999.99],
    [  899.99,  899.99,   10800,  949.99, 1049.99,   80000,  719.99,  900.00, 6300.00,  599.99, 5499.00, 6799.00,    5898, 1088.98, 6988.00,   26900,   29990, 1599.99,   49900, 8499000, 3599.90, 7499.99, 3299.99, 3299.99],
    [  999.99,  999.99,   12000, 1049.99, 1249.99,   85000,  799.99, 1000.00, 7000.00,  699.99, 5999.00, 7499.00,    6498, 1288.98, 7888.00,   29900,   32990, 1799.99,   54900, 9499000, 3999.90, 7999.99, 3699.99, 3699.99],
];

our $PROCEED_MATRIX = [
    [    0.70,    0.70,    8.40,    0.63,    0.90,      60,    0.48,    0.65,    3.92,    0.42,    3.65,    4.26,    4.20,    0.90,    5.60,      21,   23.10,    1.25,   38.50,    6650,    2.73,    5.59,    2.58,    2.58],
    [    1.40,    1.40,   16.80,    1.27,    1.81,     119,    0.97,    1.30,    7.84,    0.91,    7.30,    9.13,    8.40,    1.81,   10.50,      42,   46.20,    2.51,      77,   13300,    5.53,   11.19,    5.10,    5.10],
    [    2.10,    2.10,   25.20,    1.90,    2.93,     175,    1.45,    1.94,   11.76,    1.21,   10.96,   13.39,   12.60,    2.79,   16.10,      63,   69.30,    3.84,     119,   20300,    8.33,   17.49,    7.69,    7.69],
    [    2.80,    2.80,   33.60,    2.86,    3.70,     245,    1.82,    2.59,   15.68,    1.52,   14.61,   17.04,   17.50,    3.49,   19.60,      84,   90.30,    4.89,     154,   27300,   11.13,   23.09,   10.49,   10.49],
    [    3.50,    3.50,   42.00,    3.49,    4.54,     315,    2.43,    3.24,   19.60,    1.82,   18.26,   23.13,   21.00,    4.19,   26.60,     105,  118.30,    6.29,     189,   34300,   13.93,   27.99,   12.59,   12.59],
    [    4.20,    4.20,   50.40,    4.13,    5.80,     350,    3.04,    3.89,   23.52,    2.43,   21.91,   27.39,   28.00,    4.89,   33.60,     126,  139.30,    7.69,     245,   41300,   16.73,   34.29,   14.69,   14.69],
    [    4.90,    4.90,   58.80,    4.77,    6.99,     420,    3.34,    4.54,   27.44,    3.04,   25.57,   29.83,   31.50,    6.29,   37.10,     147,  160.30,    9.09,     273,   48300,   19.53,   39.89,   17.49,   17.49],
    [    5.60,    5.60,   67.20,    5.40,    7.69,     490,    3.65,    5.19,   31.36,    3.34,   29.22,   33.48,   35.00,    6.99,   40.60,     168,  188.30,   10.49,     315,   55300,   22.33,   45.49,   20.99,   20.99],
    [    6.30,    6.30,   75.60,    6.04,    9.09,     560,    4.25,    5.83,   35.28,    3.65,   32.87,   39.57,   42.00,    7.69,   47.60,     189,  209.30,   11.89,     343,   62300,   25.13,   51.09,   23.09,   23.09],
    [    7.00,    7.00,   84.00,    6.68,    9.79,     595,    4.86,    6.48,   39.20,    4.25,   35.91,   45.65,   47.60,    9.09,   54.60,     210,  230.30,   12.59,     385,   66500,   27.93,   55.99,   25.89,   25.89],
    [    7.70,    7.70,   91.00,    7.31,   10.49,     630,    5.47,    7.13,   43.12,    4.56,   42.00,   51.74,   51.10,    9.79,   58.10,     231,  244.30,   13.99,     413,   69300,   30.73,   62.99,   27.99,   27.99],
    [    8.40,    8.40,   98.00,    8.27,   11.19,     700,    6.08,    7.78,   47.04,    4.86,   45.65,   57.83,   54.60,   10.49,   61.60,     252,  265.30,   15.39,     455,   76300,   33.53,   69.99,   31.49,   31.49],
    [    9.10,    9.10,  112.00,    8.90,   11.89,     770,    6.39,    8.43,   50.96,    5.47,   48.09,   60.26,   61.60,   11.19,   68.60,     273,  279.30,   16.79,     483,   83300,   36.33,   76.99,   33.59,   33.59],
    [    9.80,    9.80,  119.00,    9.54,   12.59,     840,    6.69,    9.07,   54.88,    6.08,   51.74,   63.91,   65.10,   12.59,   75.60,     294,  314.30,   17.49,     525,   90300,   39.13,   80.49,   34.99,   34.99],
    [   10.50,   10.50,  126.00,   10.18,   13.29,     910,    7.30,    9.72,   58.80,    6.39,   54.17,   66.35,   68.60,   13.29,   82.60,     315,  335.30,   18.89,     553,   97300,   41.93,   83.99,   38.49,   38.49],
    [   11.20,   11.20,  133.00,   10.81,   13.99,     980,    7.91,   10.37,   62.72,    6.69,   60.26,   72.43,   75.60,   13.99,   86.10,     343,  349.30,   20.29,     623,  104300,   44.73,   90.99,   41.99,   41.99],
    [   11.90,   11.90,  140.00,   11.45,   14.69,    1050,    8.52,   11.02,   66.64,    7.30,   63.91,   78.52,   79.10,   15.39,   89.60,     364,  384.30,   21.69,     665,  111300,   47.53,   97.99,   45.49,   45.49],
    [   12.60,   12.60,  154.00,   12.08,   16.09,    1120,    8.82,   11.67,   70.56,    7.91,   66.35,   82.17,   82.60,   16.09,   96.60,     378,  405.30,   23.09,     693,  118300,   50.33,  104.99,   47.59,   47.59],
    [   13.30,   13.30,  161.00,   12.72,   16.79,    1155,    9.12,   12.31,   74.48,    8.21,   70.00,   84.61,   86.10,   16.79,  103.60,     399,  419.30,   24.49,     735,  125300,   53.13,  108.49,   48.99,   48.99],
    [   14.00,   14.00,  168.00,   13.36,   17.49,    1190,    9.73,   12.96,   78.40,    8.52,   72.43,   90.70,   89.60,   18.19,  110.60,     413,  454.30,   25.19,     770,  132300,   55.93,  111.99,   52.49,   52.49],
    [   14.70,   14.70,  175.00,   13.99,   18.19,    1260,   10.34,   13.61,   82.32,    9.12,   76.09,   96.78,   96.60,   18.89,  114.10,     441,  475.30,   26.59,     805,  139300,   58.73,  118.99,   54.59,   54.59],
    [   15.40,   15.40,  182.00,   14.63,   19.59,    1330,   10.95,   14.26,   86.24,    9.43,   78.52,  102.87,  103.60,   19.59,  117.60,     462,  489.30,   27.99,     840,  146300,   61.53,  125.99,   55.99,   55.99],
    [   16.10,   16.10,  189.00,   15.27,   20.29,    1400,   11.25,   14.91,   90.16,    9.73,   82.17,  106.52,  107.10,   20.29,  124.60,     483,  524.30,   29.39,     875,  153300,   64.33,  132.99,   59.49,   59.49],
    [   16.80,   16.80,  196.00,   15.90,   20.99,    1470,   11.56,   15.56,   94.08,   10.34,   84.61,  108.96,  110.60,   21.69,  131.60,     504,  545.30,   30.79,     910,  160300,   67.13,  136.49,   61.59,   61.59],
    [   17.50,   17.50,  210.00,   16.54,   21.69,    1540,   12.17,   16.20,   98.00,   10.65,   90.70,  115.04,  114.10,   22.39,  138.60,     525,  559.30,   31.49,     945,  167300,   69.93,  139.99,   62.99,   62.99],
    [   18.20,   18.20,  217.00,   17.18,   23.09,    1610,   12.78,   16.85,  101.92,   10.95,   94.35,  118.70,  117.60,   23.09,  142.10,     553,  594.30,   32.89,     980,  174300,   72.73,  146.99,   66.49,   66.49],
    [   18.90,   18.90,  224.00,   17.81,   24.49,    1680,   13.08,   17.50,  105.84,   11.56,   96.78,  121.13,  124.60,   24.49,  145.60,     574,  615.30,   34.29,    1050,  181300,   75.53,  153.99,   69.99,   69.99],
    [   19.60,   19.60,  231.00,   19.08,   25.19,    1715,   13.39,   18.15,  109.76,   11.86,  100.43,  127.22,  131.60,   25.19,  152.60,     588,  629.30,   35.69,    1085,  188300,   78.33,  160.99,   73.49,   73.49],
    [   20.30,   20.30,  238.00,   19.72,   25.89,    1750,   13.99,   18.47,  113.68,   12.17,  102.87,  133.30,  138.60,   25.89,  159.60,     609,  664.30,   37.09,    1120,  195300,   81.13,  164.49,   75.59,   75.59],
    [   21.00,   21.00,  252.00,   20.36,   27.29,    1820,   14.60,   18.80,  117.04,   12.78,  108.96,  139.39,  138.60,   27.29,  166.60,     623,  685.30,   37.79,    1155,  202300,   83.93,  167.99,   76.99,   76.99],
    [   21.70,   21.70,  259.00,   20.99,   27.99,    1890,   15.21,   19.44,  121.52,   13.39,  112.61,  143.04,  145.60,   27.99,  170.10,     651,  699.30,   39.19,    1190,  209300,   86.73,  174.99,   80.49,   80.49],
    [   22.40,   22.40,  266.00,   21.63,   28.69,    1960,   15.52,   20.09,  125.44,   13.69,  115.04,  145.48,  152.60,   28.69,  173.60,     672,  720.30,   40.59,    1225,  216300,   89.53,  181.99,   82.59,   82.59],
    [   23.10,   23.10,  273.00,   22.27,   29.39,    2030,   15.82,   20.74,  129.36,   13.99,  118.70,  149.13,  156.10,   29.39,  180.60,     693,  734.30,   41.99,    1260,  223300,   92.33,  188.99,   83.99,   83.99],
    [   23.80,   23.80,  280.00,   22.90,   30.79,    2065,   16.43,   21.39,  133.28,   14.60,  121.13,  151.57,  159.60,   30.79,  187.60,     714,  769.30,   43.39,    1295,  230300,   95.13,  192.49,   87.49,   87.49],
    [   24.50,   24.50,  294.00,   23.54,   31.49,    2100,   17.04,   22.04,  137.20,   14.91,  127.22,  161.30,  163.10,   31.49,  194.60,     735,  790.30,   44.09,    1330,  237300,   97.93,  195.99,   89.59,   89.59],
    [   25.20,   25.20,  301.00,   24.18,   32.19,    2170,   17.65,   22.69,  141.12,   15.21,  130.87,  163.74,  166.60,   32.19,  198.10,     763,  804.30,   45.49,    1400,  244300,  100.73,  202.99,   90.99,   90.99],
    [   25.90,   25.90,  308.00,   24.81,   32.89,    2240,   17.95,   23.33,  145.04,   15.82,  133.30,  167.39,  170.10,   33.59,  201.60,     784,  839.30,   46.89,    1435,  251300,  103.53,  209.99,   94.49,   94.49],
    [   26.60,   26.60,  315.00,   25.45,   33.59,    2310,   18.25,   23.98,  148.96,   16.43,  136.96,  173.48,  173.60,   34.29,  208.60,     798,  860.30,   48.29,    1470,  258300,  106.33,  216.99,   97.99,   97.99],
    [   27.30,   27.30,  329.00,   26.08,   34.29,    2380,   18.86,   24.63,  152.88,   16.73,  139.39,  175.91,  177.10,   34.99,  215.60,     819,  874.30,   49.69,    1505,  265300,  109.13,  220.49,  101.49,  101.49],
    [   28.00,   28.00,  336.00,   26.72,   34.99,    2415,   19.47,   25.28,  156.80,   17.04,  145.48,  182.00,  180.60,   36.39,  222.60,     833,  909.30,   50.39,    1540,  272300,  111.93,  223.99,  103.59,  103.59],
    [   28.70,   28.70,  343.00,   27.36,   35.69,    2450,   20.08,   25.93,  160.72,   17.65,  149.13,  188.09,  184.10,   37.09,  226.10,     861,  930.30,   51.79,    1575,  276500,  114.73,  230.99,  104.99,  104.99],
    [   29.40,   29.40,  350.00,   27.99,   36.39,    2520,   20.39,   26.57,  164.64,   17.95,  151.57,  191.74,  187.60,   37.79,  229.60,     882,  944.30,   53.19,    1610,  279300,  117.53,  237.99,  108.49,  108.49],
    [   30.10,   30.10,  364.00,   28.63,   37.79,    2590,   20.69,   27.22,  168.56,   18.25,  155.22,  194.17,  191.10,   38.49,  236.60,     903,  979.30,   54.59,    1645,  286300,  120.33,  244.99,  110.59,  110.59],
    [   30.80,   30.80,  371.00,   29.27,   38.49,    2660,   21.30,   27.87,  172.48,   18.86,  157.65,  200.26,  194.60,   39.89,  243.60,     924, 1000.30,   55.99,    1680,  293300,  123.13,  248.49,  111.99,  111.99],
    [   31.50,   31.50,  378.00,   29.90,   39.19,    2730,   21.91,   28.52,  176.40,   19.47,  163.74,  206.35,  198.10,   40.59,  250.60,     945, 1014.30,   56.69,    1715,  300300,  125.93,  251.99,  115.49,  115.49],
    [   32.20,   32.20,  385.00,   30.54,   39.89,    2765,   22.52,   29.17,  180.32,   19.78,  167.39,  210.00,  201.60,   41.29,  254.10,     973, 1049.30,   58.09,    1750,  307300,  128.73,  258.99,  117.59,  117.59],
    [   32.90,   32.90,  392.00,   31.18,   41.29,    2800,   22.82,   29.81,  184.24,   20.08,  169.83,  212.43,  208.60,   42.69,  257.60,     994, 1070.30,   59.49,    1785,  314300,  131.53,  265.99,  118.99,  118.99],
    [   33.60,   33.60,  399.00,   31.81,   41.99,    2870,   23.12,   30.46,  188.16,   20.69,  173.48,  218.52,  215.60,   43.39,  264.60,    1008, 1084.30,   60.89,    1820,  321300,  134.33,  272.99,  122.49,  122.49],
    [   34.30,   34.30,  406.00,   32.45,   42.69,    2940,   23.73,   30.79,  192.08,   20.99,  175.91,  224.61,  222.60,   44.09,  271.60,    1029,    1113,   62.29,    1855,  328300,  137.13,  276.49,  125.99,  125.99],
    [   35.00,   35.00,  420.00,   33.08,   45.49,    3010,   24.34,   31.11,  195.44,   21.30,  182.00,  230.70,  229.60,   45.49,  278.60,    1043,    1183,   62.99,    1890,  335300,  139.93,  279.99,  129.49,  129.49],
    [   38.50,   38.50,  455.00,   38.18,   52.49,    3360,   26.17,   35.65,  215.60,   23.12,  194.17,  242.87,  243.60,   48.29,  292.60,    1113,    1253,   69.99,    2030,  349300,  153.93,  314.99,  139.99,  139.99],
    [   42.00,   42.00,  490.00,   41.36,   55.99,    3640,   27.39,   38.89,  235.20,   24.34,  206.35,  255.04,  271.60,   52.49,  313.60,    1253,    1393,   76.99,    2240,  384300,  167.93,  349.99,  153.99,  153.99],
    [   45.50,   45.50,  560.00,   44.54,   59.49,    3990,   30.43,   42.13,  254.80,   27.39,  224.61,  285.48,  292.60,   55.29,  341.60,    1393,    1463,   83.99,    2450,  419300,  181.93,  384.99,  160.99,  160.99],
    [   49.00,   49.00,  595.00,   47.72,   66.49,    4270,   33.47,   45.37,  274.40,   29.21,  242.87,  315.91,  313.60,   62.29,  383.60,    1463,    1603,   90.99,    2730,  454300,  195.93,  405.99,  174.99,  174.99],
    [   52.50,   52.50,  630.00,   50.90,   69.99,    4550,   36.52,   48.61,  294.00,   30.43,  267.22,  346.35,  341.60,   66.49,  411.60,    1533,    1743,   97.99,    2940,  489300,  209.93,  419.99,  195.99,  195.99],
    [   56.00,   56.00,  665.00,   54.08,   73.49,    4830,   38.34,   51.85,  313.60,   33.47,  285.48,  364.61,  362.60,   69.29,  432.60,    1673,    1883,  101.49,    3150,  524300,  223.93,  454.99,  209.99,  209.99],
    [   59.50,   59.50,  700.00,   57.27,   76.99,    5180,   39.56,   55.09,  333.20,   35.30,  303.74,  376.78,  383.60,   73.49,  453.60,    1743,    1953,  104.99,    3290,  559300,  237.93,  489.99,  223.99,  223.99],
    [   63.00,   63.00,  770.00,   60.45,   80.49,    5460,   42.60,   58.33,  352.80,   36.52,  322.00,  401.13,  411.60,   76.29,  481.60,    1883,    2093,  111.99,    3430,  594300,  251.93,  524.99,  230.99,  230.99],
    [   66.50,   66.50,  805.00,   63.63,   83.99,    5740,   45.65,   61.57,  372.40,   39.56,  340.26,  425.48,  432.60,   83.29,  523.60,    1953,    2163,  118.99,    3640,  629300,  265.93,  545.99,  244.99,  244.99],
    [   70.00,   70.00,  840.00,   69.99,   87.49,    5950,   48.69,   64.81,  392.00,   42.60,  364.61,  455.91,  453.60,   90.29,  551.60,    2093,    2303,  125.99,    3850,  664300,  279.93,  559.99,  258.99,  258.99],
    [   77.00,   77.00,  910.00,   76.36,  104.99,    6650,   51.73,   71.30,  431.20,   45.65,  382.87,  486.35,  488.60,   97.29,  593.60,    2303,    2443,  139.99,    4130,  734300,  307.93,  629.99,  279.99,  279.99],
    [   84.00,   84.00,  980.00,   82.72,  111.99,    7350,   54.78,   77.78,  470.40,   48.69,  407.22,  516.78,  558.60,  104.29,  621.60,    2513,    2653,  153.99,    4550,  804300,  335.93,  699.99,  300.99,  300.99],
    [   87.50,   87.50,    1050,   85.90,  115.49,    7700,   56.60,   81.02,  487.20,   51.73,  419.39,  535.04,  572.60,  111.29,  691.60,    2653,    2723,  160.99,    4830,  839300,  349.93,  734.99,  314.99,  314.99],
    [   91.00,   91.00, 1120.00,   89.08,  118.99,    8050,   57.82,   84.26,  509.60,   54.78,  425.48,  547.22,  593.60,  118.29,  733.60,    2723,    2793,  167.99,    5250,  874300,  363.93,  769.99,  335.99,  335.99],
    [   98.00,   98.00, 1190.00,   95.45,  125.99,    8750,   60.86,   90.74,  548.80,   57.82,  455.91,  577.65,  628.60,  125.29,  761.60,    2933,    3143,  174.99,    5530,  909300,  391.93,  804.99,  349.99,  349.99],
    [  105.00,  105.00, 1260.00,  101.81,  139.99,    9100,   66.95,   97.22,  588.00,   60.86,  498.52,  608.09,  698.60,  132.29,  831.60,    3143,    3353,  188.99,    5950,  979300,  419.93,  839.99,  384.99,  384.99],
    [  112.00,  112.00, 1330.00,  108.18,  146.99,    9800,   73.04,  103.70,  627.20,   66.95,  547.22,  668.96,  733.60,  139.29,  873.60,    3353,    3493,  202.99,    6230, 1049300,  447.93,  909.99,  405.99,  405.99],
    [  119.00,  119.00, 1400.00,  114.54,  160.99,   10500,   76.08,  110.19,  666.40,   73.04,  565.48,  717.65,  768.60,  146.29,  901.60,    3563,    3843,  216.99,    6650, 1119300,  475.93,  979.99,  419.99,  419.99],
    [  122.50,  122.50,    1470,  117.72,  164.49,   10850,   77.91,  113.43,  683.20,   74.86,  577.65,  729.83,  803.60,  153.29,  971.60,    3703,    3983,  223.99,    6930, 1154300,  489.93, 1014.99,  454.99,  454.99],
    [  126.00,  126.00, 1540.00,  120.90,  167.99,   11200,   79.12,  116.67,  705.60,   76.08,  589.83,  754.17,  838.60,  160.29, 1013.60,    3773,    4053,  230.99,    7350, 1189300,  503.93, 1049.99,  475.99,  475.99],
    [  133.00,  133.00, 1610.00,  127.27,  174.99,   11550,   85.21,  123.15,  744.80,   79.12,  632.43,  802.87,  873.60,  167.29, 1041.60,    3983,    4193,  244.99,    7630, 1259300,  531.93, 1084.99,  489.99,  489.99],
    [  140.00,  140.00, 1680.00,  133.63,  181.99,   11900,   91.30,  129.63,  784.00,   85.21,  681.13,  851.57,  908.60,  181.29, 1111.60,    4193,    4543,  251.99,    8050, 1329300,  559.93, 1119.99,  524.99,  524.99],
    [  147.00,  147.00, 1750.00,  139.99,  188.99,   12600,   97.39,  136.11,  823.20,   88.25,  729.83,  912.43,  978.60,  188.29, 1153.60,    4403,    4753,  265.99,    8330, 1399300,  587.93, 1189.99,  545.99,  545.99],
    [  154.00,  154.00, 1890.00,  146.36,  195.99,   13300,  103.47,  142.59,  862.40,   91.30,  772.43,  973.30, 1013.60,  195.29, 1181.60,    4613,    4893,  279.99,    8750, 1469300,  615.93, 1259.99,  559.99,  559.99],
    [  161.00,  161.00, 1960.00,  152.72,  202.99,   14000,  109.56,  149.07,  901.60,   97.39,  821.13, 1034.17, 1048.60,  202.29, 1251.60,    4823,    5243,  293.99,    9030, 1539300,  643.93, 1329.99,  594.99,  594.99],
    [  168.00,  168.00, 2030.00,  159.08,  209.99,   14700,  115.65,  155.56,  940.80,  103.47,  851.57, 1095.04, 1118.60,  209.29, 1293.60,    5033,    5453,  307.99,    9450, 1609300,  671.93, 1364.99,  615.99,  615.99],
    [  175.00,  175.00, 2100.00,  171.81,  223.99,   15400,  121.73,  162.04,  980.00,  106.52,  912.43, 1155.91, 1153.60,  216.29, 1321.60,    5243,    5593,  314.99,    9730, 1679300,  699.93, 1399.99,  629.99,  629.99],
    [  210.00,  210.00, 2520.00,  203.63,  279.99,   18200,  146.08,  194.44, 1176.00,  121.73, 1095.04, 1399.39, 1398.60,  258.29, 1601.60,    6293,    6853,  384.99,   11130, 2029300,  839.93, 1749.99,  769.99,  769.99],
    [  245.00,  245.00, 2940.00,  241.81,  314.99,   21000,  170.43,  226.85, 1372.00,  152.17, 1216.78, 1582.00, 1608.60,  300.29, 1881.60,    6993,    8043,  454.99,   13230, 2379300,  979.93, 2099.99,  909.99,  909.99],
    [  280.00,  280.00, 3360.00,  273.63,  349.99,   24500,  194.78,  259.26, 1568.00,  182.60, 1460.26, 1825.48, 1818.60,  342.29, 2161.60,    8330,    9093,  524.99,   15330, 2729300, 1119.93, 2309.99, 1049.99, 1049.99],
    [  315.00,  315.00, 3780.00,  318.18,  384.99,   27300,  219.12,  291.67, 1764.00,  197.82, 1642.87, 2068.96, 2098.60,  412.29, 2441.60,    9030,   10493,  559.99,   17430, 3009300, 1259.93, 2659.99, 1119.99, 1119.99],
    [  350.00,  350.00, 4200.00,  349.99,  454.99,   29750,  243.47,  324.07, 1960.00,  213.04, 1825.48, 2312.43, 2308.60,  454.29, 2721.60,   10430,   11893,  629.99,   19530, 3359300, 1399.93, 2799.99, 1259.99, 1259.99],
    [  420.00,  420.00, 5040.00,  413.63,  524.99,   35000,  292.17,  388.89, 2352.00,  243.47, 2129.83, 2738.52, 2798.60,  552.29, 3141.60,   12530,   13993,  769.99,   23030, 3849300, 1679.93, 3499.99, 1539.99, 1539.99],
    [  490.00,  490.00, 5880.00,  477.27,  594.99,   42000,  340.86,  453.70, 2744.00,  304.34, 2434.17, 3225.48, 3148.60,  622.29, 3491.60,   14630,   16093,  909.99,   27230, 4549300, 1959.93, 4199.99, 1749.99, 1749.99],
    [  560.00,  560.00, 6720.00,  540.90,  664.99,   49000,  389.56,  518.52, 3136.00,  334.78, 2921.13, 3651.57, 3498.60,  692.29, 4191.60,   16730,   18893,  979.99,   31430, 5249300, 2239.93, 4549.99, 2099.99, 2099.99],
    [  630.00,  630.00, 7560.00,  604.54,  734.99,   56000,  438.25,  583.33, 3528.00,  365.21, 3347.22, 4138.52, 4128.60,  762.29, 4891.60,   18830,   20993, 1119.99,   34930, 5949300, 2519.93, 5249.99, 2309.99, 2309.99],
    [  700.00,  700.00, 8400.00,  668.18,  874.99,   59500,  486.95,  648.15, 3920.00,  426.08, 3651.57, 4564.61, 4548.60,  902.29, 5521.60,   20930,   23093, 1259.99,   38430, 6649300, 2799.93, 5599.99, 2589.99, 2589.99],
];

sub price_for {
    my ($class, %args) = @_;
    my $code = $class->_get_code(%args);

    my $tier = $args{tier}
        or croak 'tier parameter is required';

    return 0 if $tier == 0;
    $PRICE_MATRIX->[ $tier - 1 ][ $code ];
}

sub proceed_for {
    my ($class, %args) = @_;
    my $code = $class->_get_code(%args);

    my $tier = $args{tier}
        or croak 'tier parameter is required';

    return 0 if $tier == 0;
    $PROCEED_MATRIX->[ $tier - 1 ][ $code ];
}

sub prices {
    my ($class, %args) = @_;
    my $code = $class->_get_code(%args);

    my @prices;
    for my $tier (1 .. scalar @$PRICE_MATRIX) {
        push @prices, $PRICE_MATRIX->[ $tier - 1 ][ $code ];
    }

    @prices;
}

sub proceeds {
    my ($class, %args) = @_;
    my $code = $class->_get_code(%args);

    my @proceeds;
    for my $tier (1 .. scalar @$PROCEED_MATRIX) {
        push @proceeds, $PROCEED_MATRIX->[ $tier - 1 ][ $code ];
    }

    @proceeds;
}

sub supported_countries {
    return keys %COUNTRIES;
}

sub supported_currencies {
    return keys %CURRENCIES;
}

sub supported_countries_and_currencies {
    my %map;

    my $i = 0;
    my @currencies = keys %CURRENCIES;
    for my $country (keys %COUNTRIES) {
        $map{$country} = $currencies[$i++];
    }

    return %map;
}

sub new {
    my ($class, %args) = @_;

    my $code = $class->_get_code(%args);
    bless { code => $code }, $class;
}

sub price_for_tier {
    my ($self, $tier) = @_;
    return 0 if $tier == 0;
    $PRICE_MATRIX->[ $tier - 1 ][ $self->{code} ];
}

sub proceed_for_tier {
    my ($self, $tier) = @_;
    return 0 if $tier == 0;
    $PROCEED_MATRIX->[ $tier - 1 ][ $self->{code} ];
}

sub _get_code {
    my ($class_or_self, %args) = @_;

    my $code;
    if ($args{country}) {
        $code = $COUNTRIES{ $args{country} };
        croak "Unsupported country: $args{country}" unless defined $code;
    }
    elsif ($args{currency}) {
        $code = $CURRENCIES{ $args{currency} };
        croak "Unsupported currency: $args{currency}" unless defined $code;
    }
    else {
        croak 'required either country or currency parameter';
    }

    $code;
}

1;

__END__

=head1 NAME

Data::Apple::PriceTier - Utility for Apple (App|Mac) Store's price tier.

=head1 SYNOPSIS

    # class interface
    my $price = Data::Apple::PriceTier->price_for(
        currency => 'Euro',
        tier     => 1,
    ); # => 0.79
    
    my $proceed = Data::Apple::PriceTier->proceed_for(
        country => 'Japan',
        tier    => 1,
    ); # => 60
    
    # object interface
    my $us_tier = Data::Apple::PriceTier->new( country => 'U.S.' );
    my $price   = $us_tier->price_for_tier(1); # => 0.99

=head1 DESCRIPTION

Data::Apple::PriceTier is a simple utility module that helps you to convert Apple's price tier to real currencies.
It's useful to create server-side implementation of In-App purchases that supports multiple currencies.

=head1 CLASS METHODS

=head2 $price = Data::Apple::PriceTier->price_for(%args);

    $price = Data::Apple::PriceTier->price_for( currency => 'US$', tier => 1 );

Return customer price for C<%args>

Supported C<%args> is:

=over

=item * currency

=item * country

Specify target country or currency. Either country or currency is required.

=item * tier

Specify target price tier. Required.

=back

=head2 $proceed = Data::Apple::PriceTier->proceed_for(%args);

    $proceed = Data::Apple::PriceTier->proceed_for( currency => 'Yen', tier => 1 );

Return your proceed for C<%args>. Supported args is same as above C<price_for> method.

=head2 @prices = Data::Apple::PriceTier->prices(%country_or_currency);

    my @prices = Data::Apple::PriceTier->prices( country => 'Japan' );
    my @prices = Data::Apple::PriceTier->prices( currency => 'Yen' );

Return customer price list for given country or currency.

Note: this list start with tier 1. $prices[0] represent tier 1 price not Free price.

=head2 @proceeds = Data::Apple::PriceTier->proceeds(%country_or_currency);

    my @proceeds = Data::Apple::PriceTier->proceeds( country => 'Japan' );
    my @proceeds = Data::Apple::PriceTier->proceeds( currency => 'Yen' );

Return your proceed list for given country or currency.

=head2 $obj = Data::Apple::PriceTier->new(%country_or_currency);

Create Data::Apple::PriceTier object and return it. See C<INSTANCE METHODS> showed below for more detail.

=head2 @countries = Data::Apple::PriceTier->supported_countries;

List of countries that Apple (and this module) supports.

=head2 @currencies = Data::Apple::PriceTier->supported_currencies;

List of currencies that Apple (and this module) supports.

=head2 %countries_and_currencies = Data::Apple::PriceTier->supported_countries_and_currencies;

Return list of supported countries and currencies at once.

=head1 INSTANCE METHODS

=head2 $price = $obj->price_for_tier($tier);

Return customer price for C<$tier> with C<$obj>'s country.

=head2 $proceed = $obj->proceed_for_tier($tier);

Return your proceed for C<$tier> with C<$obj>'s country.

=head1 AUTHOR

Daisuke Murase <typester@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2012 KAYAC Inc. All rights reserved.

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.

=cut

