#!perl

use strict;
use warnings;
use Test::More tests => 2;

use IO::CaptureOutput qw(capture capture_exec);

my ($stdout, $stderr);

chdir 'ex';

my @perl = ( $^X, '-I../lib' );
push @perl, '-MDevel::Cover=-silent,1,-db,../cover_db,-ignore,.,-select,Pod-Advent' if exists $INC{'Devel/Cover.pm'};
($stdout, $stderr) = capture_exec( @perl, '../bin/pod2advent', 'sample.pod' );

my $html = do{ local $/ = undef; open FILE, '<', 'sample.html'; <FILE> };
my $err = <<'EOF';
## Please see file perltidy.ERR
Possible SPELLING ERRORS:
	href
	inline
	lt
	pre
	footnote1
EOF
s/^<!-- Generated by Pod::Advent .+? -->$//m for $html, $stdout;

is($stdout, $html, "file matches");
is($stderr, $err, "errors match");

