%{
/*                                                                
**  Copyright (C) 2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* ipar.y
**/

#ifdef __linux__
/* stdio.h: fileno */
#define _POSIX_C_SOURCE 2
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "pfile.h"
#include "putil.h"
#include "ipar.h"
#include "iraf.h"
#include "mode.h"

/* externally defined procedures */

static void ipar_error(char const *s);

/* These defines must be kept in sync with the %s statement 
** in the lexical analyser
**/

#define NAME	1
#define TYPE	2
#define VALUE	3
#define LINE	4
#define DQUOTE	5
#define SQUOTE	6

static ParamList *result;

extern int	ipar_lineno;

#define YYDEBUG 1
#define YYINITDEPTH 256
#define YYMAXDEPTH  257
%}

%union {
	ParamList	*plist;
	Parameter	*param;
	char		*stri;
}

%type <plist>	pfile
%type <plist>	plist

%type <param>	param
%type <param>	ptypedp
%type <param>	pstruct
%type <param>	pminmaxprompt
%type <stri>	piece
%type <stri>	lstruct

%token <param>	T_comment
%token <stri>	T_struct
%token <stri>	T_word
%token <stri>	T_line

%token 		T_nl

%%

pfile	: plist
		{ result = $1;			}
	;

plist	: param
		{ if ( $1 && ($1->pvalue.value==NULL) )
			VNewValue(&$1->pvalue, "", StringType);

		  if ( $1 != NULL )
			$$ = PListAdd(NULL, $1);
		}
	| plist  param
		{ if ( $2 && ($2->pvalue.value==NULL) )
			VNewValue(&$2->pvalue, "", StringType);

		  if ( $2 != NULL )
			$$ = PListAdd($1, $2);	}
	;
	  
param	: ptypedp
	| pstruct
	| T_comment T_nl
	| T_nl
		{ 		int	mode = 0;
		  $$ = ParamCreate(str_duplicate("")
				, CommentType 
				, &mode, str_duplicate(""), NULL); 
		}
	;

ptypedp	: T_word ','  T_word ',' T_word ',' T_word  pminmaxprompt T_nl
		{ 		int	mode;
		  $$ = ParamCreate($1
				, String2Type($3)
				, String2Mode($5, &mode), $7, $8);
			if ( $3 != NULL ) free($3);
			if ( $5 != NULL ) free($5);
		}
	| T_word ',' T_word ',' T_word ',' pminmaxprompt T_nl
		{ 		int	mode;
		  $$ = ParamCreate($1
				, String2Type($3)
				, String2Mode($5, &mode), NULL, $7); }
	;

pstruct	: T_word ',' T_struct ',' T_word ',' T_word pminmaxprompt T_nl
		{ 		int	mode = 0;
		  $<param>$ = ParamCreate($1
				, String2Type($3)
				, String2Mode($5, &mode), NULL, $8);
			if ( $3 != NULL ) free($3);
			if ( $5 != NULL ) free($5);

		  ipar_begin(LINE);
		}
	  lstruct
		{ $$ = ParamStruct($<param>10, $11);
		  ipar_begin(NAME);
		}
	;

lstruct : T_line     T_nl
		{ $$ = $1;		}
	| T_nl
		{ $$ = NULL;		}
	;

pminmaxprompt	:
		{ $$ = NULL;					}
	| piece
		{ $$ = NULL;
		  if ( $1 ) ParamMin(NULL, StringType, $1);
		}
	| piece piece
		{ 
		  $$ = NULL;
		  if ( $1 ) $$ = ParamMin(NULL, StringType, $1);
		  if ( $2 ) $$ = ParamMax(  $$, StringType, $2);
		}
	| piece piece piece
		{
		  $$ = NULL;
		  if ( $1 ) $$ = ParamMin( NULL, StringType, $1);
		  if ( $2 ) $$ = ParamMax(   $$, StringType, $2);
		  if ( $3 ) $$ = ParamPrompt($$, $3);
		}
	;

piece :   ','
		{ $$ = NULL;					}
	| ',' T_word
		{ $$ = $2;					}

%%


extern char *ipar_inchar;


ParamList *IRAFParseStr(char *str)
{
		static int parser = 0;

/*
		extern yydebug;

	yydebug = 1;
 */
	if ( str == NULL ) return(NULL);
	result = NULL;

	ipar_lineno = 1;

	if ( parser ) {
		ipar_reparse();
		/*yyrestart(str);*/
		ipar_inchar = str;
	} else {
		ipar_inchar = str;
		parser = 1;
	}

	if ( ipar_parse() ) {
	  PFree(result);
	  return(NULL);
	}

	return result;
}

ParamList *IRAFParFile(FILE *f)
{
  ParamList	*plist;
  int		 size;
  char		*text;
  struct stat   info;
  
  if (( NULL == f ) ||
      ( 0 != fstat( fileno(f), &info ) ) )
    return(NULL);

  size=0;
  text=(char*)calloc(101,sizeof(char));


  while (!feof(f)) {
    char buff[100] = "";
    int  rr;
    rr = fread( buff, 1, 100, f);
    strncat( text, buff, 100 );
    
    text[size+rr] = '\0';
    size+=rr;
    text=(char*)realloc(text,sizeof(char)*(size+101));
  }

  text[size]='\0';
  
  plist = IRAFParseStr(text);
  free(text);
  
  return plist;
}


static void ipar_error(char const *s)
{
	extern int ipar_field;
	static char	*fields[] = {
		"Name", "Type", "Mode", "Value", "Min", "Max", "Prompt"
	};

	if ( ipar_field > 6 ) {
	  fprintf(stderr, "Error in parameter file: line %d: too many fields\n"
		 , ipar_lineno);
	  parerr=PARBADPFILE;
	}
	else {
	  fprintf(stderr, "Error in parameter file: line %d: field %s\n"
		 , ipar_lineno
		 , fields[ipar_field]);
	  parerr=PARBADPFILE;
	}
}
