# Generated by default/object.tt
package Paws::CodeGuruProfiler::NotificationConfiguration;
  use Moose;
  has Channels => (is => 'ro', isa => 'ArrayRef[Paws::CodeGuruProfiler::Channel]', request_name => 'channels', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::NotificationConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::NotificationConfiguration object:

  $service_obj->Method(Att1 => { Channels => $value, ..., Channels => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::NotificationConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Channels

=head1 DESCRIPTION

The configuration for notifications stored for each profiling group.
This includes up to to two channels and a list of event publishers
associated with each channel.

=head1 ATTRIBUTES


=head2 Channels => ArrayRef[L<Paws::CodeGuruProfiler::Channel>]

List of up to two channels to be used for sending notifications for
events detected from the application profile.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

