/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVariable
extends GeneralVariable
implements Container,
InstructionInfo {
    private Executable executable;
    private SlotManager stackFrameMap = null;
    private boolean indexed;

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.executable.getLocationMap().getLineNumber(locationId);
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.executable.getLocationMap().getLineNumber(locationId);
    }

    @Override
    public int getConstructType() {
        return 204;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getVariableQName();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public Container getContainer() {
        return this;
    }

    @Override
    public int getHostLanguage() {
        return this.executable.getHostLanguage();
    }

    public void setIndexedVariable() {
        this.indexed = true;
    }

    public boolean isIndexedVariable() {
        return this.indexed;
    }

    @Override
    public int getContainerGranularity() {
        return 2;
    }

    public void setContainsLocals(SlotManager map) {
        this.stackFrameMap = map;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public void lookForCycles(Stack<Container> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable. $" + this.getVariableQName().getDisplayName();
            for (int i = s; i < referees.size() - 1; ++i) {
                InstructionInfo next;
                if (i != s) {
                    message = message + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next = (GlobalVariable)referees.get(i + 1);
                    message = message + " uses $" + ((GeneralVariable)((Object)next)).getVariableQName().getDisplayName();
                    continue;
                }
                if (!(referees.get(i + 1) instanceof XQueryFunction)) continue;
                next = (XQueryFunction)referees.get(i + 1);
                message = message + " calls " + ((XQueryFunction)next).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next).getNumberOfArguments() + "()";
            }
            message = message + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0054");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        if (this.select != null) {
            referees.push(this);
            ArrayList<Binding> list = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(this.select, list);
            for (Binding b : list) {
                if (!(b instanceof GlobalVariable)) continue;
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            ArrayList flist = new ArrayList();
            ExpressionTool.gatherCalledFunctionNames(this.select, flist);
            for (String s : flist) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey(s);
                if (referees.contains(f)) continue;
                GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack<Container> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Expression body = f.getBody();
        referees.push(f);
        ArrayList<Binding> list = new ArrayList<Binding>(10);
        ExpressionTool.gatherReferencedVariables(body, list);
        for (Binding b : list) {
            if (!(b instanceof GlobalVariable)) continue;
            ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
        }
        ArrayList flist = new ArrayList();
        ExpressionTool.gatherCalledFunctionNames(body, flist);
        for (String s : flist) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey(s);
            if (referees.contains(qf)) continue;
            GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
        }
        referees.pop();
    }

    @Override
    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        try {
            XPathContextMajor c2 = context.newCleanContext();
            c2.setOrigin(this);
            Controller controller = c2.getController();
            assert (controller != null);
            UnfailingIterator<Item> initialNode = SingletonIterator.makeIterator(controller.getContextForGlobalVariables());
            initialNode.next();
            c2.setCurrentIterator(initialNode);
            if (this.stackFrameMap != null) {
                c2.openStackFrame(this.stackFrameMap);
            }
            return ExpressionTool.evaluate(this.select, this.evaluationMode, c2, this.referenceCount);
        }
        catch (XPathException e) {
            if (!this.getVariableQName().getURI().equals("http://saxon.sf.net/generated-global-variable")) {
                e.setIsGlobalError(true);
            }
            throw e;
        }
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery();
        ValueRepresentation v = b.getGlobalVariable(this.getSlotNumber());
        if (v != null) {
            return v;
        }
        return this.actuallyEvaluate(context);
    }

    protected ValueRepresentation actuallyEvaluate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery();
        try {
            GlobalVariable.setDependencies(b, this, context);
            boolean go = b.setExecuting(this);
            if (!go) {
                return b.getGlobalVariable(this.getSlotNumber());
            }
            ValueRepresentation value = this.getSelectValue(context);
            if (this.indexed) {
                value = controller.getConfiguration().obtainOptimizer().makeIndexedValue(Value.asIterator(value));
            }
            return b.saveGlobalVariableValue(this, value);
        }
        catch (XPathException err) {
            b.setNotExecuting(this);
            if (err instanceof XPathException.Circularity) {
                err.setErrorCode(this.getHostLanguage() == 50 ? "XTDE0640" : "XQST0054");
                err.setXPathContext(context);
                SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                b.defineGlobalVariable(this, closure);
                err.setLocator(this);
                throw err;
            }
            throw err;
        }
    }

    protected static void setDependencies(Bindery bindery, GlobalVariable var, XPathContext context) throws XPathException {
        if (!(context instanceof XPathContextMajor)) {
            context = GlobalVariable.getMajorCaller(context);
        }
        while (context != null) {
            do {
                InstructionInfo instructionInfo;
                if (!((instructionInfo = ((XPathContextMajor)context).getOrigin()) instanceof GlobalVariable)) continue;
                bindery.registerDependency((GlobalVariable)instructionInfo, var);
                return;
            } while ((context = GlobalVariable.getMajorCaller(context)) != null);
        }
    }

    private static XPathContextMajor getMajorCaller(XPathContext context) {
        XPathContext caller;
        for (caller = context.getCaller(); caller != null && !(caller instanceof XPathContextMajor); caller = caller.getCaller()) {
        }
        return (XPathContextMajor)caller;
    }
}

