package Daje::Document::Templates::Tools::Generate::Angular;
use Mojo::Base 'Daje::Document::Templates::Base', -base;
use v5.42;

# NAME
# ====
#
# Daje::Templates::Tools::Generate::Angular; - It creates Angular code
#
# SYNOPSIS
# ========
#
#     use Daje::Templates::Tools::Generate::Angular;
#
#     Provides a method for the template to be loaded into the data structure
#
#     sub length_default_calc($self) returns a sub for setting details in template.
#
#
# DESCRIPTION
# ===========
#
# Daje::Templates::Tools::Generate::Angular; is a module that retrieves data from a View
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub set_subs($self) {
    $self->subs('set_datatype');
}

sub set_datatype($datatype) {
    my $result = "string";
    if(uc($datatype) eq 'BIGINT') {
        $result = 'numeric';
    } elsif(uc($datatype) eq 'NUMERIC') {
        $result = 'numeric';
    } elsif(uc($datatype) eq 'BOOLEAN') {
        $result = 'boolean';
    } elsif(uc($datatype) eq 'MONEY') {
        $result = 'numeric';
    }

    return $result;
}
1;

__DATA__

@@ interface
// Autogenerated file [%- date_time %]
import{ ResponseBase } from '../../../core/response/response.interface';

export interface [%- class_name -%]Interface extends ResponseBase {
    [% project_name -%]_[%- table.table_name -%]_pkey:number,
    [%- FOREACH field IN fields -%]
    [%- IF field.foreign_key %]
    [%- project_name -%]_[%- field.fieldname %]_fkey:number[% "," IF loop.last() == 0 %]
    [%- ELSE %]
    [% field.fieldname %]:[% set_datatype(field.datatype) %][% "," IF loop.last() == 0 %]
    [%- END -%]
    [% END %]
};

@@ component

// Autogenerated file [%- date_time %]
import { Component, inject } from '@angular/core';
import { ActivatedRoute } from "@angular/router";
import { InputTextModule } from 'primeng/inputtext';
import { FormsModule } from '@angular/forms';
import { FloatLabel } from 'primeng/floatlabel';
import { CheckboxModule } from 'primeng/checkbox';
import { ButtonModule } from 'primeng/button';
import { CardModule } from 'primeng/card';
import { SelectModule } from 'primeng/select';
import { WorkflowService } from '../../../core/workflow/workflow.service';
import { DatabaseService } from '../../../core/database/database.service';

@Component({
  selector: 'p-[% project_name -%]-[%- table.table_name -%]',
  imports: [
    FormsModule,
    InputTextModule,
    FloatLabel,
    CheckboxModule,
    ButtonModule,
    CardModule,
    SelectModule
  ],
  templateUrl: './[%table.table_name%].component.html',
  styleUrl: './[%table.table_name%].component.css',
  standalone: true,
})

export class [%- class_name -%]Component {
  payload:[%- class_name -%]Interface = {} as [%- class_name -%]Interface;
  private activatedRoute = inject(ActivatedRoute);

  constructor(
        private workflow: WorkflowService,
        private database: DatabaseService,
  ) {}

  saveObject([% project_name %]_[% table.table_name%]_pkey) {

  }

  cancelData() {

  }
};

@@ component_html
<!-- Autogenerated file [%- date_time %] -->
div class="w-full flex flex-wrap justify-center ">
        <p-card [style]="{ width: '25rem', overflow: 'hidden' }">
            <div class="flex gap-4 mt-1 p-3 ">
            [%- FOREACH field IN fields -%]

                [% IF field.datatype == 'BOOLEAN' %]
                <div class="flex gap-4 mt-1 p-3">
                    <p-checkbox inputId="[%- field.fieldname %]" name="[%- field.fieldname %]" value="true" [(ngModel)]="payload.[%- field.fieldname %]" [binary]="true"/>
                    <label for="[%- field.fieldname %]" class="ml-2"> [%- field.fieldname %] </label>
                </div>
                [%- ELSE -%]
                <div class ="w-full">
                 <p-floatlabel variant="on">
                        <input pInputText id="[%- field.fieldname %]" [(ngModel)]="payload.[%- field.fieldname %]" autocomplete="off" fluid="true"/>
                        <label for="[%- field.fieldname %]">[%- field.fieldname %]</label>
                    </p-floatlabel>
                 </div>
                [%- END -%]
                [%- END -%]
            </div>
             <div class="flex gap-4 mt-1">
                <p-button (click)="cancelData()" label="Cancel" severity="secondary" class="w-full" [outlined]="true" styleClass="w-full" />
                <p-button (click)="saveObject([% project_name %]_[% table.table_name%]_pkey)"  label="Save" class="w-full" styleClass="w-full" />
            </div>
       </p-card>
 </div>
