#include "ccv.h"
#include "ccv_internal.h"
#ifdef HAVE_GSL
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#endif
#ifdef USE_OPENMP
#include <omp.h>
#endif
#ifdef USE_DISPATCH
#include <dispatch/dispatch.h>
#endif

const ccv_icf_param_t ccv_icf_default_params = {
	.min_neighbors = 2,
	.threshold = 0,
	.step_through = 2,
	.flags = 0,
	.interval = 8,
};

// this uses a look up table for cubic root computation because rgb to luv only requires data within range of 0~1
static inline float fast_cube_root(const float d)
{
	static const float cube_root[2048] = {
		0.000000e+00, 7.875788e-02, 9.922871e-02, 1.135885e-01, 1.250203e-01, 1.346741e-01, 1.431126e-01, 1.506584e-01,
		1.575158e-01, 1.638230e-01, 1.696787e-01, 1.751560e-01, 1.803105e-01, 1.851861e-01, 1.898177e-01, 1.942336e-01,
		1.984574e-01, 2.025087e-01, 2.064040e-01, 2.101577e-01, 2.137818e-01, 2.172870e-01, 2.206827e-01, 2.239769e-01,
		2.271770e-01, 2.302894e-01, 2.333199e-01, 2.362736e-01, 2.391553e-01, 2.419692e-01, 2.447191e-01, 2.474085e-01,
		2.500407e-01, 2.526186e-01, 2.551450e-01, 2.576222e-01, 2.600528e-01, 2.624387e-01, 2.647821e-01, 2.670846e-01,
		2.693482e-01, 2.715743e-01, 2.737645e-01, 2.759202e-01, 2.780428e-01, 2.801334e-01, 2.821933e-01, 2.842235e-01,
		2.862251e-01, 2.881992e-01, 2.901465e-01, 2.920681e-01, 2.939647e-01, 2.958371e-01, 2.976862e-01, 2.995125e-01,
		3.013168e-01, 3.030998e-01, 3.048621e-01, 3.066041e-01, 3.083267e-01, 3.100302e-01, 3.117152e-01, 3.133821e-01,
		3.150315e-01, 3.166639e-01, 3.182795e-01, 3.198789e-01, 3.214625e-01, 3.230307e-01, 3.245837e-01, 3.261220e-01,
		3.276460e-01, 3.291559e-01, 3.306521e-01, 3.321348e-01, 3.336045e-01, 3.350613e-01, 3.365056e-01, 3.379375e-01,
		3.393574e-01, 3.407656e-01, 3.421622e-01, 3.435475e-01, 3.449216e-01, 3.462850e-01, 3.476377e-01, 3.489799e-01,
		3.503119e-01, 3.516339e-01, 3.529460e-01, 3.542483e-01, 3.555412e-01, 3.568248e-01, 3.580992e-01, 3.593646e-01,
		3.606211e-01, 3.618689e-01, 3.631082e-01, 3.643391e-01, 3.655617e-01, 3.667762e-01, 3.679827e-01, 3.691814e-01,
		3.703723e-01, 3.715556e-01, 3.727314e-01, 3.738999e-01, 3.750610e-01, 3.762151e-01, 3.773621e-01, 3.785022e-01,
		3.796354e-01, 3.807619e-01, 3.818818e-01, 3.829952e-01, 3.841021e-01, 3.852027e-01, 3.862970e-01, 3.873852e-01,
		3.884673e-01, 3.895434e-01, 3.906136e-01, 3.916779e-01, 3.927365e-01, 3.937894e-01, 3.948367e-01, 3.958785e-01,
		3.969149e-01, 3.979458e-01, 3.989714e-01, 3.999918e-01, 4.010071e-01, 4.020171e-01, 4.030222e-01, 4.040223e-01,
		4.050174e-01, 4.060076e-01, 4.069931e-01, 4.079738e-01, 4.089499e-01, 4.099212e-01, 4.108880e-01, 4.118503e-01,
		4.128081e-01, 4.137615e-01, 4.147105e-01, 4.156551e-01, 4.165955e-01, 4.175317e-01, 4.184637e-01, 4.193916e-01,
		4.203153e-01, 4.212351e-01, 4.221508e-01, 4.230626e-01, 4.239704e-01, 4.248744e-01, 4.257746e-01, 4.266710e-01,
		4.275636e-01, 4.284525e-01, 4.293377e-01, 4.302193e-01, 4.310973e-01, 4.319718e-01, 4.328427e-01, 4.337101e-01,
		4.345741e-01, 4.354346e-01, 4.362918e-01, 4.371456e-01, 4.379961e-01, 4.388433e-01, 4.396872e-01, 4.405279e-01,
		4.413654e-01, 4.421997e-01, 4.430309e-01, 4.438590e-01, 4.446840e-01, 4.455060e-01, 4.463249e-01, 4.471409e-01,
		4.479539e-01, 4.487639e-01, 4.495711e-01, 4.503753e-01, 4.511767e-01, 4.519752e-01, 4.527710e-01, 4.535639e-01,
		4.543541e-01, 4.551415e-01, 4.559263e-01, 4.567083e-01, 4.574877e-01, 4.582644e-01, 4.590385e-01, 4.598100e-01,
		4.605789e-01, 4.613453e-01, 4.621091e-01, 4.628704e-01, 4.636292e-01, 4.643855e-01, 4.651394e-01, 4.658908e-01,
		4.666398e-01, 4.673865e-01, 4.681307e-01, 4.688726e-01, 4.696122e-01, 4.703494e-01, 4.710843e-01, 4.718169e-01,
		4.725473e-01, 4.732754e-01, 4.740013e-01, 4.747250e-01, 4.754464e-01, 4.761657e-01, 4.768828e-01, 4.775978e-01,
		4.783106e-01, 4.790214e-01, 4.797300e-01, 4.804365e-01, 4.811410e-01, 4.818434e-01, 4.825437e-01, 4.832420e-01,
		4.839384e-01, 4.846327e-01, 4.853250e-01, 4.860154e-01, 4.867038e-01, 4.873902e-01, 4.880748e-01, 4.887574e-01,
		4.894381e-01, 4.901170e-01, 4.907939e-01, 4.914690e-01, 4.921423e-01, 4.928137e-01, 4.934832e-01, 4.941510e-01,
		4.948170e-01, 4.954812e-01, 4.961436e-01, 4.968042e-01, 4.974631e-01, 4.981203e-01, 4.987757e-01, 4.994294e-01,
		5.000814e-01, 5.007317e-01, 5.013803e-01, 5.020273e-01, 5.026726e-01, 5.033162e-01, 5.039582e-01, 5.045985e-01,
		5.052372e-01, 5.058743e-01, 5.065099e-01, 5.071438e-01, 5.077761e-01, 5.084069e-01, 5.090362e-01, 5.096638e-01,
		5.102900e-01, 5.109145e-01, 5.115376e-01, 5.121592e-01, 5.127792e-01, 5.133978e-01, 5.140148e-01, 5.146304e-01,
		5.152445e-01, 5.158572e-01, 5.164684e-01, 5.170782e-01, 5.176865e-01, 5.182934e-01, 5.188988e-01, 5.195029e-01,
		5.201056e-01, 5.207069e-01, 5.213068e-01, 5.219053e-01, 5.225024e-01, 5.230982e-01, 5.236927e-01, 5.242857e-01,
		5.248775e-01, 5.254679e-01, 5.260570e-01, 5.266448e-01, 5.272312e-01, 5.278164e-01, 5.284002e-01, 5.289828e-01,
		5.295641e-01, 5.301442e-01, 5.307229e-01, 5.313004e-01, 5.318767e-01, 5.324517e-01, 5.330254e-01, 5.335979e-01,
		5.341693e-01, 5.347394e-01, 5.353082e-01, 5.358759e-01, 5.364423e-01, 5.370076e-01, 5.375717e-01, 5.381346e-01,
		5.386963e-01, 5.392569e-01, 5.398163e-01, 5.403746e-01, 5.409316e-01, 5.414876e-01, 5.420424e-01, 5.425960e-01,
		5.431486e-01, 5.437000e-01, 5.442503e-01, 5.447995e-01, 5.453476e-01, 5.458946e-01, 5.464405e-01, 5.469853e-01,
		5.475290e-01, 5.480717e-01, 5.486133e-01, 5.491537e-01, 5.496932e-01, 5.502316e-01, 5.507689e-01, 5.513052e-01,
		5.518404e-01, 5.523747e-01, 5.529078e-01, 5.534400e-01, 5.539711e-01, 5.545012e-01, 5.550303e-01, 5.555584e-01,
		5.560855e-01, 5.566117e-01, 5.571368e-01, 5.576609e-01, 5.581840e-01, 5.587062e-01, 5.592273e-01, 5.597475e-01,
		5.602668e-01, 5.607851e-01, 5.613024e-01, 5.618188e-01, 5.623342e-01, 5.628487e-01, 5.633622e-01, 5.638748e-01,
		5.643865e-01, 5.648973e-01, 5.654072e-01, 5.659161e-01, 5.664241e-01, 5.669311e-01, 5.674374e-01, 5.679426e-01,
		5.684470e-01, 5.689505e-01, 5.694531e-01, 5.699549e-01, 5.704557e-01, 5.709556e-01, 5.714548e-01, 5.719529e-01,
		5.724503e-01, 5.729468e-01, 5.734424e-01, 5.739372e-01, 5.744311e-01, 5.749242e-01, 5.754164e-01, 5.759078e-01,
		5.763984e-01, 5.768881e-01, 5.773770e-01, 5.778650e-01, 5.783523e-01, 5.788387e-01, 5.793243e-01, 5.798091e-01,
		5.802931e-01, 5.807762e-01, 5.812586e-01, 5.817402e-01, 5.822210e-01, 5.827010e-01, 5.831801e-01, 5.836585e-01,
		5.841362e-01, 5.846130e-01, 5.850891e-01, 5.855644e-01, 5.860389e-01, 5.865127e-01, 5.869856e-01, 5.874579e-01,
		5.879294e-01, 5.884001e-01, 5.888700e-01, 5.893393e-01, 5.898077e-01, 5.902755e-01, 5.907425e-01, 5.912087e-01,
		5.916742e-01, 5.921390e-01, 5.926031e-01, 5.930664e-01, 5.935290e-01, 5.939909e-01, 5.944521e-01, 5.949125e-01,
		5.953723e-01, 5.958313e-01, 5.962896e-01, 5.967473e-01, 5.972042e-01, 5.976604e-01, 5.981160e-01, 5.985708e-01,
		5.990250e-01, 5.994784e-01, 5.999312e-01, 6.003833e-01, 6.008347e-01, 6.012855e-01, 6.017355e-01, 6.021850e-01,
		6.026337e-01, 6.030817e-01, 6.035291e-01, 6.039758e-01, 6.044219e-01, 6.048673e-01, 6.053120e-01, 6.057562e-01,
		6.061996e-01, 6.066424e-01, 6.070846e-01, 6.075261e-01, 6.079670e-01, 6.084072e-01, 6.088468e-01, 6.092858e-01,
		6.097241e-01, 6.101618e-01, 6.105989e-01, 6.110353e-01, 6.114712e-01, 6.119064e-01, 6.123410e-01, 6.127750e-01,
		6.132084e-01, 6.136411e-01, 6.140732e-01, 6.145048e-01, 6.149357e-01, 6.153660e-01, 6.157957e-01, 6.162249e-01,
		6.166534e-01, 6.170813e-01, 6.175086e-01, 6.179354e-01, 6.183616e-01, 6.187872e-01, 6.192122e-01, 6.196365e-01,
		6.200604e-01, 6.204836e-01, 6.209063e-01, 6.213284e-01, 6.217499e-01, 6.221709e-01, 6.225913e-01, 6.230111e-01,
		6.234304e-01, 6.238490e-01, 6.242672e-01, 6.246848e-01, 6.251017e-01, 6.255182e-01, 6.259341e-01, 6.263494e-01,
		6.267643e-01, 6.271785e-01, 6.275922e-01, 6.280054e-01, 6.284180e-01, 6.288301e-01, 6.292416e-01, 6.296526e-01,
		6.300631e-01, 6.304730e-01, 6.308824e-01, 6.312913e-01, 6.316996e-01, 6.321074e-01, 6.325147e-01, 6.329215e-01,
		6.333277e-01, 6.337335e-01, 6.341386e-01, 6.345433e-01, 6.349475e-01, 6.353511e-01, 6.357543e-01, 6.361569e-01,
		6.365590e-01, 6.369606e-01, 6.373618e-01, 6.377624e-01, 6.381625e-01, 6.385621e-01, 6.389612e-01, 6.393598e-01,
		6.397579e-01, 6.401555e-01, 6.405526e-01, 6.409492e-01, 6.413454e-01, 6.417410e-01, 6.421362e-01, 6.425309e-01,
		6.429250e-01, 6.433188e-01, 6.437120e-01, 6.441047e-01, 6.444970e-01, 6.448888e-01, 6.452801e-01, 6.456710e-01,
		6.460613e-01, 6.464512e-01, 6.468406e-01, 6.472296e-01, 6.476181e-01, 6.480061e-01, 6.483937e-01, 6.487808e-01,
		6.491674e-01, 6.495536e-01, 6.499393e-01, 6.503246e-01, 6.507094e-01, 6.510937e-01, 6.514776e-01, 6.518611e-01,
		6.522441e-01, 6.526266e-01, 6.530087e-01, 6.533904e-01, 6.537716e-01, 6.541524e-01, 6.545327e-01, 6.549126e-01,
		6.552920e-01, 6.556710e-01, 6.560495e-01, 6.564277e-01, 6.568054e-01, 6.571826e-01, 6.575595e-01, 6.579359e-01,
		6.583118e-01, 6.586874e-01, 6.590625e-01, 6.594372e-01, 6.598114e-01, 6.601852e-01, 6.605586e-01, 6.609316e-01,
		6.613042e-01, 6.616763e-01, 6.620481e-01, 6.624194e-01, 6.627903e-01, 6.631607e-01, 6.635308e-01, 6.639005e-01,
		6.642697e-01, 6.646385e-01, 6.650070e-01, 6.653750e-01, 6.657426e-01, 6.661098e-01, 6.664766e-01, 6.668430e-01,
		6.672090e-01, 6.675746e-01, 6.679398e-01, 6.683046e-01, 6.686690e-01, 6.690330e-01, 6.693966e-01, 6.697598e-01,
		6.701226e-01, 6.704850e-01, 6.708471e-01, 6.712087e-01, 6.715700e-01, 6.719308e-01, 6.722913e-01, 6.726514e-01,
		6.730111e-01, 6.733705e-01, 6.737294e-01, 6.740879e-01, 6.744461e-01, 6.748039e-01, 6.751614e-01, 6.755184e-01,
		6.758750e-01, 6.762313e-01, 6.765872e-01, 6.769428e-01, 6.772979e-01, 6.776527e-01, 6.780071e-01, 6.783612e-01,
		6.787149e-01, 6.790682e-01, 6.794212e-01, 6.797737e-01, 6.801260e-01, 6.804778e-01, 6.808293e-01, 6.811804e-01,
		6.815312e-01, 6.818815e-01, 6.822316e-01, 6.825813e-01, 6.829306e-01, 6.832796e-01, 6.836282e-01, 6.839765e-01,
		6.843244e-01, 6.846719e-01, 6.850191e-01, 6.853660e-01, 6.857125e-01, 6.860586e-01, 6.864043e-01, 6.867498e-01,
		6.870949e-01, 6.874397e-01, 6.877841e-01, 6.881282e-01, 6.884719e-01, 6.888152e-01, 6.891583e-01, 6.895010e-01,
		6.898433e-01, 6.901854e-01, 6.905270e-01, 6.908684e-01, 6.912094e-01, 6.915500e-01, 6.918904e-01, 6.922303e-01,
		6.925700e-01, 6.929094e-01, 6.932484e-01, 6.935870e-01, 6.939254e-01, 6.942633e-01, 6.946011e-01, 6.949384e-01,
		6.952754e-01, 6.956121e-01, 6.959485e-01, 6.962845e-01, 6.966202e-01, 6.969556e-01, 6.972907e-01, 6.976255e-01,
		6.979599e-01, 6.982940e-01, 6.986278e-01, 6.989613e-01, 6.992944e-01, 6.996273e-01, 6.999598e-01, 7.002920e-01,
		7.006239e-01, 7.009555e-01, 7.012867e-01, 7.016177e-01, 7.019483e-01, 7.022786e-01, 7.026086e-01, 7.029384e-01,
		7.032678e-01, 7.035969e-01, 7.039256e-01, 7.042542e-01, 7.045823e-01, 7.049102e-01, 7.052377e-01, 7.055650e-01,
		7.058919e-01, 7.062186e-01, 7.065449e-01, 7.068710e-01, 7.071967e-01, 7.075222e-01, 7.078474e-01, 7.081722e-01,
		7.084967e-01, 7.088210e-01, 7.091449e-01, 7.094686e-01, 7.097920e-01, 7.101150e-01, 7.104378e-01, 7.107603e-01,
		7.110825e-01, 7.114044e-01, 7.117260e-01, 7.120473e-01, 7.123684e-01, 7.126891e-01, 7.130095e-01, 7.133297e-01,
		7.136496e-01, 7.139692e-01, 7.142885e-01, 7.146075e-01, 7.149262e-01, 7.152447e-01, 7.155629e-01, 7.158808e-01,
		7.161984e-01, 7.165157e-01, 7.168328e-01, 7.171495e-01, 7.174660e-01, 7.177821e-01, 7.180981e-01, 7.184138e-01,
		7.187291e-01, 7.190442e-01, 7.193590e-01, 7.196736e-01, 7.199879e-01, 7.203019e-01, 7.206156e-01, 7.209290e-01,
		7.212422e-01, 7.215551e-01, 7.218677e-01, 7.221801e-01, 7.224922e-01, 7.228040e-01, 7.231156e-01, 7.234268e-01,
		7.237378e-01, 7.240486e-01, 7.243591e-01, 7.246693e-01, 7.249793e-01, 7.252890e-01, 7.255983e-01, 7.259076e-01,
		7.262164e-01, 7.265251e-01, 7.268335e-01, 7.271415e-01, 7.274494e-01, 7.277570e-01, 7.280643e-01, 7.283714e-01,
		7.286782e-01, 7.289847e-01, 7.292911e-01, 7.295971e-01, 7.299029e-01, 7.302084e-01, 7.305137e-01, 7.308187e-01,
		7.311234e-01, 7.314279e-01, 7.317322e-01, 7.320362e-01, 7.323400e-01, 7.326434e-01, 7.329467e-01, 7.332497e-01,
		7.335525e-01, 7.338549e-01, 7.341572e-01, 7.344592e-01, 7.347609e-01, 7.350624e-01, 7.353637e-01, 7.356647e-01,
		7.359655e-01, 7.362660e-01, 7.365662e-01, 7.368662e-01, 7.371660e-01, 7.374656e-01, 7.377649e-01, 7.380639e-01,
		7.383628e-01, 7.386613e-01, 7.389597e-01, 7.392578e-01, 7.395556e-01, 7.398532e-01, 7.401506e-01, 7.404477e-01,
		7.407446e-01, 7.410412e-01, 7.413377e-01, 7.416338e-01, 7.419298e-01, 7.422255e-01, 7.425209e-01, 7.428162e-01,
		7.431112e-01, 7.434059e-01, 7.437005e-01, 7.439948e-01, 7.442889e-01, 7.445827e-01, 7.448763e-01, 7.451697e-01,
		7.454628e-01, 7.457558e-01, 7.460485e-01, 7.463409e-01, 7.466331e-01, 7.469251e-01, 7.472169e-01, 7.475084e-01,
		7.477998e-01, 7.480908e-01, 7.483817e-01, 7.486723e-01, 7.489627e-01, 7.492529e-01, 7.495428e-01, 7.498326e-01,
		7.501221e-01, 7.504114e-01, 7.507005e-01, 7.509893e-01, 7.512779e-01, 7.515663e-01, 7.518545e-01, 7.521424e-01,
		7.524302e-01, 7.527177e-01, 7.530050e-01, 7.532921e-01, 7.535789e-01, 7.538656e-01, 7.541520e-01, 7.544382e-01,
		7.547241e-01, 7.550099e-01, 7.552955e-01, 7.555808e-01, 7.558660e-01, 7.561509e-01, 7.564356e-01, 7.567201e-01,
		7.570043e-01, 7.572884e-01, 7.575722e-01, 7.578558e-01, 7.581393e-01, 7.584225e-01, 7.587055e-01, 7.589883e-01,
		7.592708e-01, 7.595532e-01, 7.598354e-01, 7.601173e-01, 7.603990e-01, 7.606806e-01, 7.609619e-01, 7.612430e-01,
		7.615239e-01, 7.618046e-01, 7.620851e-01, 7.623653e-01, 7.626454e-01, 7.629253e-01, 7.632049e-01, 7.634844e-01,
		7.637637e-01, 7.640427e-01, 7.643216e-01, 7.646002e-01, 7.648786e-01, 7.651569e-01, 7.654349e-01, 7.657127e-01,
		7.659904e-01, 7.662678e-01, 7.665451e-01, 7.668221e-01, 7.670989e-01, 7.673756e-01, 7.676520e-01, 7.679282e-01,
		7.682042e-01, 7.684801e-01, 7.687557e-01, 7.690312e-01, 7.693064e-01, 7.695814e-01, 7.698563e-01, 7.701310e-01,
		7.704054e-01, 7.706797e-01, 7.709538e-01, 7.712276e-01, 7.715013e-01, 7.717748e-01, 7.720481e-01, 7.723212e-01,
		7.725941e-01, 7.728668e-01, 7.731394e-01, 7.734116e-01, 7.736838e-01, 7.739558e-01, 7.742275e-01, 7.744991e-01,
		7.747704e-01, 7.750416e-01, 7.753126e-01, 7.755834e-01, 7.758540e-01, 7.761245e-01, 7.763947e-01, 7.766647e-01,
		7.769346e-01, 7.772043e-01, 7.774737e-01, 7.777431e-01, 7.780122e-01, 7.782811e-01, 7.785498e-01, 7.788184e-01,
		7.790868e-01, 7.793550e-01, 7.796230e-01, 7.798908e-01, 7.801584e-01, 7.804259e-01, 7.806932e-01, 7.809603e-01,
		7.812271e-01, 7.814939e-01, 7.817604e-01, 7.820268e-01, 7.822930e-01, 7.825589e-01, 7.828248e-01, 7.830904e-01,
		7.833558e-01, 7.836211e-01, 7.838862e-01, 7.841511e-01, 7.844158e-01, 7.846804e-01, 7.849448e-01, 7.852090e-01,
		7.854730e-01, 7.857369e-01, 7.860005e-01, 7.862641e-01, 7.865273e-01, 7.867905e-01, 7.870535e-01, 7.873163e-01,
		7.875788e-01, 7.878413e-01, 7.881036e-01, 7.883657e-01, 7.886276e-01, 7.888893e-01, 7.891509e-01, 7.894123e-01,
		7.896735e-01, 7.899345e-01, 7.901954e-01, 7.904561e-01, 7.907166e-01, 7.909770e-01, 7.912372e-01, 7.914972e-01,
		7.917571e-01, 7.920167e-01, 7.922763e-01, 7.925356e-01, 7.927948e-01, 7.930537e-01, 7.933126e-01, 7.935712e-01,
		7.938297e-01, 7.940881e-01, 7.943462e-01, 7.946042e-01, 7.948620e-01, 7.951197e-01, 7.953772e-01, 7.956345e-01,
		7.958916e-01, 7.961487e-01, 7.964054e-01, 7.966621e-01, 7.969186e-01, 7.971749e-01, 7.974311e-01, 7.976871e-01,
		7.979429e-01, 7.981986e-01, 7.984541e-01, 7.987095e-01, 7.989646e-01, 7.992196e-01, 7.994745e-01, 7.997292e-01,
		7.999837e-01, 8.002381e-01, 8.004923e-01, 8.007463e-01, 8.010002e-01, 8.012539e-01, 8.015075e-01, 8.017609e-01,
		8.020141e-01, 8.022672e-01, 8.025202e-01, 8.027729e-01, 8.030255e-01, 8.032780e-01, 8.035302e-01, 8.037823e-01,
		8.040344e-01, 8.042861e-01, 8.045378e-01, 8.047893e-01, 8.050406e-01, 8.052918e-01, 8.055428e-01, 8.057937e-01,
		8.060444e-01, 8.062950e-01, 8.065454e-01, 8.067956e-01, 8.070457e-01, 8.072957e-01, 8.075454e-01, 8.077950e-01,
		8.080446e-01, 8.082938e-01, 8.085430e-01, 8.087921e-01, 8.090409e-01, 8.092896e-01, 8.095381e-01, 8.097866e-01,
		8.100348e-01, 8.102829e-01, 8.105308e-01, 8.107786e-01, 8.110263e-01, 8.112738e-01, 8.115211e-01, 8.117683e-01,
		8.120154e-01, 8.122622e-01, 8.125089e-01, 8.127556e-01, 8.130020e-01, 8.132483e-01, 8.134944e-01, 8.137404e-01,
		8.139862e-01, 8.142319e-01, 8.144775e-01, 8.147229e-01, 8.149682e-01, 8.152133e-01, 8.154582e-01, 8.157030e-01,
		8.159477e-01, 8.161922e-01, 8.164365e-01, 8.166808e-01, 8.169249e-01, 8.171688e-01, 8.174126e-01, 8.176562e-01,
		8.178997e-01, 8.181431e-01, 8.183863e-01, 8.186293e-01, 8.188722e-01, 8.191150e-01, 8.193576e-01, 8.196001e-01,
		8.198425e-01, 8.200847e-01, 8.203267e-01, 8.205686e-01, 8.208104e-01, 8.210521e-01, 8.212935e-01, 8.215349e-01,
		8.217760e-01, 8.220171e-01, 8.222581e-01, 8.224988e-01, 8.227395e-01, 8.229799e-01, 8.232203e-01, 8.234605e-01,
		8.237006e-01, 8.239405e-01, 8.241804e-01, 8.244200e-01, 8.246595e-01, 8.248989e-01, 8.251381e-01, 8.253772e-01,
		8.256162e-01, 8.258550e-01, 8.260937e-01, 8.263323e-01, 8.265706e-01, 8.268089e-01, 8.270471e-01, 8.272851e-01,
		8.275229e-01, 8.277607e-01, 8.279983e-01, 8.282357e-01, 8.284730e-01, 8.287102e-01, 8.289472e-01, 8.291842e-01,
		8.294209e-01, 8.296576e-01, 8.298941e-01, 8.301305e-01, 8.303667e-01, 8.306028e-01, 8.308387e-01, 8.310746e-01,
		8.313103e-01, 8.315458e-01, 8.317813e-01, 8.320166e-01, 8.322517e-01, 8.324867e-01, 8.327217e-01, 8.329564e-01,
		8.331911e-01, 8.334256e-01, 8.336599e-01, 8.338942e-01, 8.341283e-01, 8.343623e-01, 8.345962e-01, 8.348299e-01,
		8.350635e-01, 8.352969e-01, 8.355302e-01, 8.357634e-01, 8.359964e-01, 8.362294e-01, 8.364622e-01, 8.366948e-01,
		8.369274e-01, 8.371598e-01, 8.373921e-01, 8.376243e-01, 8.378563e-01, 8.380882e-01, 8.383200e-01, 8.385516e-01,
		8.387831e-01, 8.390145e-01, 8.392458e-01, 8.394769e-01, 8.397079e-01, 8.399388e-01, 8.401695e-01, 8.404002e-01,
		8.406307e-01, 8.408611e-01, 8.410913e-01, 8.413214e-01, 8.415514e-01, 8.417813e-01, 8.420110e-01, 8.422406e-01,
		8.424702e-01, 8.426995e-01, 8.429288e-01, 8.431579e-01, 8.433869e-01, 8.436158e-01, 8.438445e-01, 8.440731e-01,
		8.443016e-01, 8.445300e-01, 8.447582e-01, 8.449863e-01, 8.452144e-01, 8.454422e-01, 8.456700e-01, 8.458977e-01,
		8.461251e-01, 8.463526e-01, 8.465798e-01, 8.468069e-01, 8.470340e-01, 8.472609e-01, 8.474877e-01, 8.477143e-01,
		8.479409e-01, 8.481673e-01, 8.483936e-01, 8.486198e-01, 8.488458e-01, 8.490717e-01, 8.492976e-01, 8.495233e-01,
		8.497488e-01, 8.499743e-01, 8.501996e-01, 8.504249e-01, 8.506500e-01, 8.508750e-01, 8.510998e-01, 8.513246e-01,
		8.515491e-01, 8.517737e-01, 8.519981e-01, 8.522223e-01, 8.524465e-01, 8.526706e-01, 8.528944e-01, 8.531182e-01,
		8.533419e-01, 8.535655e-01, 8.537889e-01, 8.540123e-01, 8.542355e-01, 8.544586e-01, 8.546816e-01, 8.549044e-01,
		8.551272e-01, 8.553498e-01, 8.555723e-01, 8.557947e-01, 8.560170e-01, 8.562392e-01, 8.564612e-01, 8.566832e-01,
		8.569050e-01, 8.571267e-01, 8.573483e-01, 8.575698e-01, 8.577912e-01, 8.580124e-01, 8.582336e-01, 8.584546e-01,
		8.586755e-01, 8.588963e-01, 8.591169e-01, 8.593375e-01, 8.595580e-01, 8.597783e-01, 8.599985e-01, 8.602186e-01,
		8.604387e-01, 8.606585e-01, 8.608783e-01, 8.610980e-01, 8.613176e-01, 8.615370e-01, 8.617563e-01, 8.619756e-01,
		8.621947e-01, 8.624136e-01, 8.626326e-01, 8.628513e-01, 8.630700e-01, 8.632885e-01, 8.635070e-01, 8.637253e-01,
		8.639436e-01, 8.641617e-01, 8.643796e-01, 8.645976e-01, 8.648154e-01, 8.650330e-01, 8.652506e-01, 8.654680e-01,
		8.656853e-01, 8.659026e-01, 8.661197e-01, 8.663368e-01, 8.665537e-01, 8.667705e-01, 8.669872e-01, 8.672037e-01,
		8.674202e-01, 8.676366e-01, 8.678529e-01, 8.680690e-01, 8.682851e-01, 8.685010e-01, 8.687168e-01, 8.689325e-01,
		8.691481e-01, 8.693637e-01, 8.695791e-01, 8.697944e-01, 8.700095e-01, 8.702246e-01, 8.704396e-01, 8.706545e-01,
		8.708693e-01, 8.710839e-01, 8.712984e-01, 8.715129e-01, 8.717272e-01, 8.719414e-01, 8.721556e-01, 8.723696e-01,
		8.725836e-01, 8.727974e-01, 8.730111e-01, 8.732247e-01, 8.734382e-01, 8.736516e-01, 8.738649e-01, 8.740780e-01,
		8.742912e-01, 8.745041e-01, 8.747170e-01, 8.749298e-01, 8.751425e-01, 8.753550e-01, 8.755675e-01, 8.757799e-01,
		8.759921e-01, 8.762043e-01, 8.764163e-01, 8.766283e-01, 8.768401e-01, 8.770519e-01, 8.772635e-01, 8.774751e-01,
		8.776865e-01, 8.778979e-01, 8.781091e-01, 8.783202e-01, 8.785312e-01, 8.787422e-01, 8.789530e-01, 8.791637e-01,
		8.793744e-01, 8.795849e-01, 8.797953e-01, 8.800057e-01, 8.802159e-01, 8.804260e-01, 8.806360e-01, 8.808460e-01,
		8.810558e-01, 8.812655e-01, 8.814751e-01, 8.816847e-01, 8.818941e-01, 8.821034e-01, 8.823127e-01, 8.825217e-01,
		8.827308e-01, 8.829397e-01, 8.831486e-01, 8.833573e-01, 8.835659e-01, 8.837745e-01, 8.839829e-01, 8.841912e-01,
		8.843995e-01, 8.846076e-01, 8.848156e-01, 8.850236e-01, 8.852314e-01, 8.854392e-01, 8.856469e-01, 8.858544e-01,
		8.860618e-01, 8.862692e-01, 8.864765e-01, 8.866837e-01, 8.868908e-01, 8.870977e-01, 8.873046e-01, 8.875114e-01,
		8.877181e-01, 8.879247e-01, 8.881311e-01, 8.883376e-01, 8.885438e-01, 8.887501e-01, 8.889562e-01, 8.891622e-01,
		8.893681e-01, 8.895739e-01, 8.897797e-01, 8.899853e-01, 8.901908e-01, 8.903963e-01, 8.906016e-01, 8.908069e-01,
		8.910121e-01, 8.912171e-01, 8.914221e-01, 8.916270e-01, 8.918318e-01, 8.920364e-01, 8.922410e-01, 8.924455e-01,
		8.926499e-01, 8.928543e-01, 8.930585e-01, 8.932626e-01, 8.934667e-01, 8.936706e-01, 8.938744e-01, 8.940782e-01,
		8.942819e-01, 8.944854e-01, 8.946889e-01, 8.948923e-01, 8.950956e-01, 8.952988e-01, 8.955019e-01, 8.957049e-01,
		8.959078e-01, 8.961107e-01, 8.963134e-01, 8.965160e-01, 8.967186e-01, 8.969210e-01, 8.971235e-01, 8.973257e-01,
		8.975279e-01, 8.977300e-01, 8.979320e-01, 8.981339e-01, 8.983358e-01, 8.985375e-01, 8.987392e-01, 8.989407e-01,
		8.991421e-01, 8.993436e-01, 8.995448e-01, 8.997460e-01, 8.999471e-01, 9.001482e-01, 9.003491e-01, 9.005499e-01,
		9.007506e-01, 9.009513e-01, 9.011519e-01, 9.013523e-01, 9.015527e-01, 9.017531e-01, 9.019532e-01, 9.021534e-01,
		9.023534e-01, 9.025534e-01, 9.027532e-01, 9.029530e-01, 9.031526e-01, 9.033523e-01, 9.035518e-01, 9.037512e-01,
		9.039505e-01, 9.041498e-01, 9.043489e-01, 9.045479e-01, 9.047469e-01, 9.049459e-01, 9.051446e-01, 9.053434e-01,
		9.055420e-01, 9.057405e-01, 9.059390e-01, 9.061373e-01, 9.063356e-01, 9.065338e-01, 9.067319e-01, 9.069299e-01,
		9.071279e-01, 9.073257e-01, 9.075235e-01, 9.077212e-01, 9.079187e-01, 9.081162e-01, 9.083136e-01, 9.085110e-01,
		9.087082e-01, 9.089054e-01, 9.091024e-01, 9.092994e-01, 9.094964e-01, 9.096932e-01, 9.098899e-01, 9.100866e-01,
		9.102831e-01, 9.104796e-01, 9.106760e-01, 9.108723e-01, 9.110685e-01, 9.112647e-01, 9.114607e-01, 9.116567e-01,
		9.118526e-01, 9.120483e-01, 9.122441e-01, 9.124397e-01, 9.126353e-01, 9.128307e-01, 9.130261e-01, 9.132214e-01,
		9.134166e-01, 9.136118e-01, 9.138068e-01, 9.140018e-01, 9.141967e-01, 9.143915e-01, 9.145862e-01, 9.147808e-01,
		9.149753e-01, 9.151698e-01, 9.153642e-01, 9.155585e-01, 9.157528e-01, 9.159469e-01, 9.161409e-01, 9.163349e-01,
		9.165288e-01, 9.167226e-01, 9.169164e-01, 9.171100e-01, 9.173036e-01, 9.174970e-01, 9.176905e-01, 9.178838e-01,
		9.180770e-01, 9.182702e-01, 9.184632e-01, 9.186562e-01, 9.188492e-01, 9.190420e-01, 9.192348e-01, 9.194274e-01,
		9.196200e-01, 9.198125e-01, 9.200049e-01, 9.201973e-01, 9.203895e-01, 9.205818e-01, 9.207739e-01, 9.209659e-01,
		9.211578e-01, 9.213497e-01, 9.215415e-01, 9.217332e-01, 9.219248e-01, 9.221163e-01, 9.223078e-01, 9.224992e-01,
		9.226905e-01, 9.228818e-01, 9.230729e-01, 9.232640e-01, 9.234550e-01, 9.236459e-01, 9.238367e-01, 9.240275e-01,
		9.242182e-01, 9.244088e-01, 9.245993e-01, 9.247897e-01, 9.249801e-01, 9.251704e-01, 9.253606e-01, 9.255507e-01,
		9.257408e-01, 9.259307e-01, 9.261206e-01, 9.263105e-01, 9.265002e-01, 9.266899e-01, 9.268795e-01, 9.270689e-01,
		9.272584e-01, 9.274477e-01, 9.276370e-01, 9.278262e-01, 9.280154e-01, 9.282044e-01, 9.283934e-01, 9.285822e-01,
		9.287710e-01, 9.289598e-01, 9.291484e-01, 9.293370e-01, 9.295255e-01, 9.297140e-01, 9.299023e-01, 9.300906e-01,
		9.302788e-01, 9.304669e-01, 9.306549e-01, 9.308429e-01, 9.310308e-01, 9.312186e-01, 9.314064e-01, 9.315941e-01,
		9.317816e-01, 9.319692e-01, 9.321566e-01, 9.323440e-01, 9.325313e-01, 9.327185e-01, 9.329057e-01, 9.330927e-01,
		9.332797e-01, 9.334666e-01, 9.336535e-01, 9.338402e-01, 9.340270e-01, 9.342135e-01, 9.344001e-01, 9.345866e-01,
		9.347730e-01, 9.349593e-01, 9.351455e-01, 9.353317e-01, 9.355178e-01, 9.357038e-01, 9.358898e-01, 9.360756e-01,
		9.362615e-01, 9.364472e-01, 9.366328e-01, 9.368184e-01, 9.370039e-01, 9.371893e-01, 9.373747e-01, 9.375600e-01,
		9.377452e-01, 9.379303e-01, 9.381154e-01, 9.383004e-01, 9.384854e-01, 9.386702e-01, 9.388550e-01, 9.390397e-01,
		9.392243e-01, 9.394089e-01, 9.395934e-01, 9.397778e-01, 9.399621e-01, 9.401464e-01, 9.403306e-01, 9.405147e-01,
		9.406988e-01, 9.408827e-01, 9.410667e-01, 9.412505e-01, 9.414343e-01, 9.416180e-01, 9.418016e-01, 9.419851e-01,
		9.421686e-01, 9.423520e-01, 9.425353e-01, 9.427186e-01, 9.429018e-01, 9.430850e-01, 9.432680e-01, 9.434510e-01,
		9.436339e-01, 9.438167e-01, 9.439995e-01, 9.441822e-01, 9.443648e-01, 9.445474e-01, 9.447299e-01, 9.449123e-01,
		9.450946e-01, 9.452769e-01, 9.454591e-01, 9.456412e-01, 9.458233e-01, 9.460053e-01, 9.461872e-01, 9.463691e-01,
		9.465508e-01, 9.467326e-01, 9.469142e-01, 9.470958e-01, 9.472773e-01, 9.474587e-01, 9.476401e-01, 9.478214e-01,
		9.480026e-01, 9.481838e-01, 9.483649e-01, 9.485459e-01, 9.487268e-01, 9.489077e-01, 9.490886e-01, 9.492693e-01,
		9.494500e-01, 9.496306e-01, 9.498111e-01, 9.499916e-01, 9.501719e-01, 9.503523e-01, 9.505326e-01, 9.507128e-01,
		9.508929e-01, 9.510729e-01, 9.512529e-01, 9.514329e-01, 9.516127e-01, 9.517925e-01, 9.519722e-01, 9.521519e-01,
		9.523315e-01, 9.525110e-01, 9.526904e-01, 9.528698e-01, 9.530491e-01, 9.532284e-01, 9.534075e-01, 9.535866e-01,
		9.537657e-01, 9.539447e-01, 9.541236e-01, 9.543024e-01, 9.544812e-01, 9.546599e-01, 9.548386e-01, 9.550171e-01,
		9.551957e-01, 9.553741e-01, 9.555525e-01, 9.557307e-01, 9.559090e-01, 9.560872e-01, 9.562653e-01, 9.564433e-01,
		9.566213e-01, 9.567992e-01, 9.569771e-01, 9.571549e-01, 9.573326e-01, 9.575102e-01, 9.576878e-01, 9.578653e-01,
		9.580427e-01, 9.582201e-01, 9.583974e-01, 9.585747e-01, 9.587519e-01, 9.589290e-01, 9.591061e-01, 9.592831e-01,
		9.594600e-01, 9.596368e-01, 9.598137e-01, 9.599904e-01, 9.601671e-01, 9.603436e-01, 9.605201e-01, 9.606966e-01,
		9.608730e-01, 9.610494e-01, 9.612256e-01, 9.614019e-01, 9.615780e-01, 9.617541e-01, 9.619301e-01, 9.621060e-01,
		9.622819e-01, 9.624578e-01, 9.626336e-01, 9.628092e-01, 9.629849e-01, 9.631604e-01, 9.633359e-01, 9.635113e-01,
		9.636867e-01, 9.638621e-01, 9.640373e-01, 9.642125e-01, 9.643876e-01, 9.645627e-01, 9.647377e-01, 9.649126e-01,
		9.650874e-01, 9.652622e-01, 9.654370e-01, 9.656116e-01, 9.657863e-01, 9.659608e-01, 9.661353e-01, 9.663097e-01,
		9.664841e-01, 9.666584e-01, 9.668326e-01, 9.670068e-01, 9.671809e-01, 9.673550e-01, 9.675289e-01, 9.677029e-01,
		9.678767e-01, 9.680505e-01, 9.682242e-01, 9.683979e-01, 9.685715e-01, 9.687451e-01, 9.689186e-01, 9.690920e-01,
		9.692653e-01, 9.694387e-01, 9.696119e-01, 9.697851e-01, 9.699582e-01, 9.701312e-01, 9.703043e-01, 9.704772e-01,
		9.706500e-01, 9.708228e-01, 9.709955e-01, 9.711683e-01, 9.713409e-01, 9.715135e-01, 9.716859e-01, 9.718584e-01,
		9.720308e-01, 9.722031e-01, 9.723753e-01, 9.725475e-01, 9.727197e-01, 9.728917e-01, 9.730637e-01, 9.732357e-01,
		9.734076e-01, 9.735794e-01, 9.737512e-01, 9.739228e-01, 9.740945e-01, 9.742661e-01, 9.744377e-01, 9.746091e-01,
		9.747805e-01, 9.749519e-01, 9.751231e-01, 9.752944e-01, 9.754655e-01, 9.756366e-01, 9.758077e-01, 9.759787e-01,
		9.761496e-01, 9.763204e-01, 9.764913e-01, 9.766620e-01, 9.768327e-01, 9.770033e-01, 9.771739e-01, 9.773444e-01,
		9.775148e-01, 9.776852e-01, 9.778556e-01, 9.780258e-01, 9.781960e-01, 9.783661e-01, 9.785362e-01, 9.787063e-01,
		9.788762e-01, 9.790462e-01, 9.792160e-01, 9.793859e-01, 9.795555e-01, 9.797252e-01, 9.798949e-01, 9.800645e-01,
		9.802339e-01, 9.804034e-01, 9.805728e-01, 9.807421e-01, 9.809114e-01, 9.810806e-01, 9.812497e-01, 9.814188e-01,
		9.815878e-01, 9.817568e-01, 9.819257e-01, 9.820946e-01, 9.822634e-01, 9.824321e-01, 9.826008e-01, 9.827695e-01,
		9.829381e-01, 9.831066e-01, 9.832750e-01, 9.834434e-01, 9.836118e-01, 9.837800e-01, 9.839482e-01, 9.841164e-01,
		9.842845e-01, 9.844526e-01, 9.846206e-01, 9.847885e-01, 9.849564e-01, 9.851242e-01, 9.852920e-01, 9.854597e-01,
		9.856274e-01, 9.857950e-01, 9.859625e-01, 9.861299e-01, 9.862974e-01, 9.864647e-01, 9.866320e-01, 9.867993e-01,
		9.869665e-01, 9.871337e-01, 9.873008e-01, 9.874678e-01, 9.876347e-01, 9.878017e-01, 9.879685e-01, 9.881353e-01,
		9.883021e-01, 9.884688e-01, 9.886354e-01, 9.888020e-01, 9.889685e-01, 9.891350e-01, 9.893014e-01, 9.894677e-01,
		9.896340e-01, 9.898003e-01, 9.899665e-01, 9.901326e-01, 9.902986e-01, 9.904646e-01, 9.906306e-01, 9.907965e-01,
		9.909624e-01, 9.911281e-01, 9.912939e-01, 9.914596e-01, 9.916252e-01, 9.917908e-01, 9.919563e-01, 9.921218e-01,
		9.922872e-01, 9.924526e-01, 9.926178e-01, 9.927831e-01, 9.929483e-01, 9.931134e-01, 9.932785e-01, 9.934435e-01,
		9.936085e-01, 9.937734e-01, 9.939383e-01, 9.941031e-01, 9.942678e-01, 9.944325e-01, 9.945971e-01, 9.947617e-01,
		9.949263e-01, 9.950907e-01, 9.952552e-01, 9.954196e-01, 9.955838e-01, 9.957481e-01, 9.959123e-01, 9.960765e-01,
		9.962406e-01, 9.964046e-01, 9.965686e-01, 9.967325e-01, 9.968964e-01, 9.970602e-01, 9.972240e-01, 9.973878e-01,
		9.975514e-01, 9.977150e-01, 9.978786e-01, 9.980421e-01, 9.982055e-01, 9.983689e-01, 9.985323e-01, 9.986956e-01,
		9.988588e-01, 9.990220e-01, 9.991851e-01, 9.993482e-01, 9.995112e-01, 9.996742e-01, 9.998372e-01, 1.000000e+00,
	};
	int i = (int)(d * 2047);
	assert(i >= 0 && i < 2048);
	return cube_root[i];
}

static inline void _ccv_rgb_to_luv(const float r, const float g, const float b, float* pl, float* pu, float* pv)
{
	const float x = 0.412453f * r + 0.35758f * g + 0.180423f * b;
	const float y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
	const float z = 0.019334f * r + 0.119193f * g + 0.950227f * b;

	const float x_n = 0.312713f, y_n = 0.329016f;
	const float uv_n_divisor = -2.f * x_n + 12.f * y_n + 3.f;
	const float u_n = 4.f * x_n / uv_n_divisor;
	const float v_n = 9.f * y_n / uv_n_divisor;

    const float uv_divisor = ccv_max((x + 15.f * y + 3.f * z), FLT_EPSILON);
	const float u = 4.f * x / uv_divisor;
	const float v = 9.f * y / uv_divisor;

	const float y_cube_root = fast_cube_root(y);

	const float l_value = ccv_max(0.f, ((116.f * y_cube_root) - 16.f));
	const float u_value = 13.f * l_value * (u - u_n);
	const float v_value = 13.f * l_value * (v - v_n);

	// L in [0, 100], U in [-134, 220], V in [-140, 122]
	*pl = l_value * (255.f / 100.f);
	*pu = (u_value + 134.f) * (255.f / (220.f + 134.f));
	*pv = (v_value + 140.f) * (255.f / (122.f + 140.f));
}

// generating the integrate channels features (which combines the grayscale, gradient magnitude, and 6-direction HOG)
void ccv_icf(ccv_dense_matrix_t* a, ccv_dense_matrix_t** b, int type)
{
	int ch = CCV_GET_CHANNEL(a->type);
	assert(ch == 1 || ch == 3);
	int nchr = (ch == 1) ? 8 : 10;
	ccv_declare_derived_signature(sig, a->sig != 0, ccv_sign_with_literal("ccv_icf"), a->sig, CCV_EOF_SIGN);
	ccv_dense_matrix_t* db = *b = ccv_dense_matrix_renew(*b, a->rows, a->cols, CCV_32F | nchr, CCV_32F | nchr, sig);
	ccv_object_return_if_cached(, db);
	ccv_dense_matrix_t* ag = 0;
	ccv_dense_matrix_t* mg = 0;
	ccv_gradient(a, &ag, 0, &mg, 0, 1, 1);
	float* agp = ag->data.f32;
	float* mgp = mg->data.f32;
	float* dbp = db->data.f32;
	ccv_zero(db);
	int i, j, k;
	unsigned char* a_ptr = a->data.u8;
	float magnitude_scaling = 1 / sqrtf(2); // regularize it to 0~1
	if (ch == 1)
	{
#define for_block(_, _for_get) \
		for (i = 0; i < a->rows; i++) \
		{ \
			for (j = 0; j < a->cols; j++) \
			{ \
				dbp[0] = _for_get(a_ptr, j, 0); \
				dbp[1] = mgp[j] * magnitude_scaling; \
				float agr = (ccv_clamp(agp[j] <= 180 ? agp[j] : agp[j] - 180, 0, 179.99) / 180.0) * 6; \
				int ag0 = (int)agr; \
				int ag1 = ag0 < 5 ? ag0 + 1 : 0; \
				agr = agr - ag0; \
				dbp[2 + ag0] = dbp[1] * (1 - agr); \
				dbp[2 + ag1] = dbp[1] * agr; \
				dbp += 8; \
			} \
			a_ptr += a->step; \
			agp += a->cols; \
			mgp += a->cols; \
		}
		ccv_matrix_getter(a->type, for_block);
#undef for_block
	} else {
		// color one, luv, gradient magnitude, and 6-direction HOG
#define for_block(_, _for_get) \
		for (i = 0; i < a->rows; i++) \
		{ \
			for (j = 0; j < a->cols; j++) \
			{ \
				_ccv_rgb_to_luv(_for_get(a_ptr, j * ch, 0) / 255.0, \
								_for_get(a_ptr, j * ch + 1, 0) / 255.0, \
								_for_get(a_ptr, j * ch + 2, 0) / 255.0, \
								dbp, dbp + 1, dbp + 2); \
				float agv = agp[j * ch]; \
				float mgv = mgp[j * ch]; \
				for (k = 1; k < ch; k++) \
				{ \
					if (mgp[j * ch + k] > mgv) \
					{ \
						mgv = mgp[j * ch + k]; \
						agv = agp[j * ch + k]; \
					} \
				} \
				dbp[3] = mgv * magnitude_scaling; \
				float agr = (ccv_clamp(agv <= 180 ? agv : agv - 180, 0, 179.99) / 180.0) * 6; \
				int ag0 = (int)agr; \
				int ag1 = ag0 < 5 ? ag0 + 1 : 0; \
				agr = agr - ag0; \
				dbp[4 + ag0] = dbp[3] * (1 - agr); \
				dbp[4 + ag1] = dbp[3] * agr; \
				dbp += 10; \
			} \
			a_ptr += a->step; \
			agp += a->cols * ch; \
			mgp += a->cols * ch; \
		}
		ccv_matrix_getter(a->type, for_block);
#undef for_block
	}
	ccv_matrix_free(ag);
	ccv_matrix_free(mg);
}

static inline float _ccv_icf_run_feature(ccv_icf_feature_t* feature, float* ptr, int cols, int ch, int x, int y)
{
	float c = feature->beta;
	int q;
	for (q = 0; q < feature->count; q++)
		c += (ptr[(feature->sat[q * 2 + 1].x + x + 1 + (feature->sat[q * 2 + 1].y + y + 1) * cols) * ch + feature->channel[q]] - ptr[(feature->sat[q * 2].x + x + (feature->sat[q * 2 + 1].y + y + 1) * cols) * ch + feature->channel[q]] + ptr[(feature->sat[q * 2].x + x + (feature->sat[q * 2].y + y) * cols) * ch + feature->channel[q]] - ptr[(feature->sat[q * 2 + 1].x + x + 1 + (feature->sat[q * 2].y + y) * cols) * ch + feature->channel[q]]) * feature->alpha[q];
	return c;
}

static inline int _ccv_icf_run_weak_classifier(ccv_icf_decision_tree_t* weak_classifier, float* ptr, int cols, int ch, int x, int y)
{
	float c = _ccv_icf_run_feature(weak_classifier->features, ptr, cols, ch, x, y);
	if (c > 0)
	{
		if (!(weak_classifier->pass & 0x1))
			return 1;
		return _ccv_icf_run_feature(weak_classifier->features + 2, ptr, cols, ch, x, y) > 0;
	} else {
		if (!(weak_classifier->pass & 0x2))
			return 0;
		return _ccv_icf_run_feature(weak_classifier->features + 1, ptr, cols, ch, x, y) > 0;
	}
}

#ifdef HAVE_GSL
static void _ccv_icf_randomize_feature(gsl_rng* rng, ccv_size_t size, int minimum, ccv_icf_feature_t* feature, int grayscale)
{
	feature->count = gsl_rng_uniform_int(rng, CCV_ICF_SAT_MAX) + 1;
	assert(feature->count <= CCV_ICF_SAT_MAX);
	int i;
	feature->beta = 0;
	for (i = 0; i < feature->count; i++)
	{
		int x0, y0, x1, y1;
		do {
			x0 = gsl_rng_uniform_int(rng, size.width);
			x1 = gsl_rng_uniform_int(rng, size.width);
			y0 = gsl_rng_uniform_int(rng, size.height);
			y1 = gsl_rng_uniform_int(rng, size.height);
		} while ((ccv_max(x0, x1) - ccv_min(x0, x1) + 1) * (ccv_max(y0, y1) - ccv_min(y0, y1) + 1) < (minimum + 1) * (minimum + 1) ||
				 (ccv_max(x0, x1) - ccv_min(x0, x1) + 1) < minimum ||
				 (ccv_max(y0, y1) - ccv_min(y0, y1) + 1) < minimum);
		feature->sat[i * 2].x = ccv_min(x0, x1);
		feature->sat[i * 2].y = ccv_min(y0, y1);
		feature->sat[i * 2 + 1].x = ccv_max(x0, x1);
		feature->sat[i * 2 + 1].y = ccv_max(y0, y1);
		feature->channel[i] = gsl_rng_uniform_int(rng, grayscale ? 8 : 10); // 8-channels for grayscale, and 10-channels for rgb
		assert(feature->channel[i] >= 0 && feature->channel[i] < (grayscale ? 8 : 10));
		feature->alpha[i] = gsl_rng_uniform(rng) / (float)((feature->sat[i * 2 + 1].x - feature->sat[i * 2].x + 1) * (feature->sat[i * 2 + 1].y - feature->sat[i * 2].y + 1));
	}
}

static void _ccv_icf_check_params(ccv_icf_new_param_t params)
{
	assert(params.size.width > 0 && params.size.height > 0);
	assert(params.deform_shift >= 0);
	assert(params.deform_angle >= 0);
	assert(params.deform_scale >= 0 && params.deform_scale < 1);
	assert(params.feature_size > 0);
	assert(params.acceptance > 0 && params.acceptance < 1.0);
}

static ccv_dense_matrix_t* _ccv_icf_capture_feature(gsl_rng* rng, ccv_dense_matrix_t* image, ccv_decimal_pose_t pose, ccv_size_t size, ccv_margin_t margin, float deform_angle, float deform_scale, float deform_shift)
{
	float rotate_x = (deform_angle * 2 * gsl_rng_uniform(rng) - deform_angle) * CCV_PI / 180 + pose.pitch;
	float rotate_y = (deform_angle * 2 * gsl_rng_uniform(rng) - deform_angle) * CCV_PI / 180 + pose.yaw;
	float rotate_z = (deform_angle * 2 * gsl_rng_uniform(rng) - deform_angle) * CCV_PI / 180 + pose.roll;
	float scale = gsl_rng_uniform(rng);
	// to make the scale evenly distributed, for example, when deforming of 1/2 ~ 2, we want it to distribute around 1, rather than any average of 1/2 ~ 2
	scale = (1 + deform_scale * scale) / (1 + deform_scale * (1 - scale));
	float scale_ratio = sqrtf((float)(size.width * size.height) / (pose.a * pose.b * 4));
	float m00 = cosf(rotate_z) * scale;
	float m01 = cosf(rotate_y) * sinf(rotate_z) * scale;
	float m02 = (deform_shift * 2 * gsl_rng_uniform(rng) - deform_shift) / scale_ratio + pose.x + (margin.right - margin.left) / scale_ratio - image->cols * 0.5;
	float m10 = (sinf(rotate_y) * cosf(rotate_z) - cosf(rotate_x) * sinf(rotate_z)) * scale;
	float m11 = (sinf(rotate_y) * sinf(rotate_z) + cosf(rotate_x) * cosf(rotate_z)) * scale;
	float m12 = (deform_shift * 2 * gsl_rng_uniform(rng) - deform_shift) / scale_ratio + pose.y + (margin.bottom - margin.top) / scale_ratio - image->rows * 0.5;
	float m20 = (sinf(rotate_y) * cosf(rotate_z) + sinf(rotate_x) * sinf(rotate_z)) * scale;
	float m21 = (sinf(rotate_y) * sinf(rotate_z) - sinf(rotate_x) * cosf(rotate_z)) * scale;
	float m22 = cosf(rotate_x) * cosf(rotate_y);
	ccv_dense_matrix_t* b = 0;
	ccv_perspective_transform(image, &b, 0, m00, m01, m02, m10, m11, m12, m20, m21, m22);
	ccv_dense_matrix_t* resize = 0;
	// have 1px border around the grayscale image because we need these to compute correct gradient feature
	ccv_size_t scale_size = {
		.width = (int)((size.width + margin.left + margin.right + 2) / scale_ratio + 0.5),
		.height = (int)((size.height + margin.top + margin.bottom + 2) / scale_ratio + 0.5),
	};
	assert(scale_size.width > 0 && scale_size.height > 0);
	ccv_slice(b, (ccv_matrix_t**)&resize, 0, (int)(b->rows * 0.5 - (size.height + margin.top + margin.bottom + 2) / scale_ratio * 0.5 + 0.5), (int)(b->cols * 0.5 - (size.width + margin.left + margin.right + 2) / scale_ratio * 0.5 + 0.5), scale_size.height, scale_size.width);
	ccv_matrix_free(b);
	b = 0;
	if (scale_ratio > 1)
		ccv_resample(resize, &b, 0, size.height + margin.top + margin.bottom + 2, size.width + margin.left + margin.right + 2, CCV_INTER_CUBIC);
	else
		ccv_resample(resize, &b, 0, size.height + margin.top + margin.bottom + 2, size.width + margin.left + margin.right + 2, CCV_INTER_AREA);
	ccv_matrix_free(resize);
	return b;
}

typedef struct {
	uint8_t correct:1;
	double weight;
	float rate;
} ccv_icf_example_state_t;

typedef struct {
	uint8_t classifier:1;
	uint8_t positives:1;
	uint8_t negatives:1;
	uint8_t features:1;
	uint8_t example_state:1;
	uint8_t precomputed:1;
} ccv_icf_classifier_cascade_persistence_state_t;

typedef struct {
	uint32_t index;
	float value;
} ccv_icf_value_index_t;

typedef struct {
	ccv_function_state_reserve_field;
	int i;
	int bootstrap;
	ccv_icf_new_param_t params;
	ccv_icf_classifier_cascade_t* classifier;
	ccv_array_t* positives;
	ccv_array_t* negatives;
	ccv_icf_feature_t* features;
	ccv_size_t size;
	ccv_margin_t margin;
	ccv_icf_example_state_t* example_state;
	uint8_t* precomputed;
	ccv_icf_classifier_cascade_persistence_state_t x;
} ccv_icf_classifier_cascade_state_t;

static void _ccv_icf_write_classifier_cascade_state(ccv_icf_classifier_cascade_state_t* state, const char* directory)
{
	char filename[1024];
	snprintf(filename, 1024, "%s/state", directory);
	FILE* w = fopen(filename, "w+");
	fprintf(w, "%d %d %d\n", state->line_no, state->i, state->bootstrap);
	fprintf(w, "%d %d %d\n", state->params.feature_size, state->size.width, state->size.height);
	fprintf(w, "%d %d %d %d\n", state->margin.left, state->margin.top, state->margin.right, state->margin.bottom);
	fclose(w);
	int i, q;
	if (!state->x.positives)
	{
		snprintf(filename, 1024, "%s/positives", directory);
		w = fopen(filename, "wb+");
		fwrite(&state->positives->rnum, sizeof(state->positives->rnum), 1, w);
		fwrite(&state->positives->rsize, sizeof(state->positives->rsize), 1, w);
		for (i = 0; i < state->positives->rnum; i++)
		{
			ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccv_array_get(state->positives, i);
			assert(a->rows == state->size.height + state->margin.top + state->margin.bottom + 2 && a->cols == state->size.width + state->margin.left + state->margin.right + 2);
			fwrite(a, 1, state->positives->rsize, w);
		}
		fclose(w);
		state->x.positives = 1;
	}
	if (!state->x.negatives)
	{
		assert(state->negatives->rsize == state->positives->rsize);
		snprintf(filename, 1024, "%s/negatives", directory);
		w = fopen(filename, "wb+");
		fwrite(&state->negatives->rnum, sizeof(state->negatives->rnum), 1, w);
		fwrite(&state->negatives->rsize, sizeof(state->negatives->rsize), 1, w);
		for (i = 0; i < state->negatives->rnum; i++)
		{
			ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccv_array_get(state->negatives, i);
			assert(a->rows == state->size.height + state->margin.top + state->margin.bottom + 2 && a->cols == state->size.width + state->margin.left + state->margin.right + 2);
			fwrite(a, 1, state->negatives->rsize, w);
		}
		fclose(w);
		state->x.negatives = 1;
	}
	if (!state->x.features)
	{
		snprintf(filename, 1024, "%s/features", directory);
		w = fopen(filename, "w+");
		for (i = 0; i < state->params.feature_size; i++)
		{
			ccv_icf_feature_t* feature = state->features + i;
			fprintf(w, "%d %a\n", feature->count, feature->beta);
			for (q = 0; q < feature->count; q++)
				fprintf(w, "%d %a %d %d %d %d\n", feature->channel[q], feature->alpha[q], feature->sat[q * 2].x, feature->sat[q * 2].y, feature->sat[q * 2 + 1].x, feature->sat[q * 2 + 1].y);
		}
		fclose(w);
		state->x.features = 1;
	}
	if (!state->x.example_state)
	{
		snprintf(filename, 1024, "%s/example_state", directory);
		w = fopen(filename, "w+");
		for (i = 0; i < state->positives->rnum + state->negatives->rnum; i++)
			fprintf(w, "%u %la %a\n", (uint32_t)state->example_state[i].correct, state->example_state[i].weight, state->example_state[i].rate);
		fclose(w);
		state->x.example_state = 1;
	}
	if (!state->x.precomputed)
	{
		size_t step = (3 * (state->positives->rnum + state->negatives->rnum) + 3) & -4;
		snprintf(filename, 1024, "%s/precomputed", directory);
		w = fopen(filename, "wb+");
		fwrite(state->precomputed, 1, step * state->params.feature_size, w);
		fclose(w);
		state->x.precomputed = 1;
	}
	if (!state->x.classifier)
	{
		snprintf(filename, 1024, "%s/cascade", directory);
		ccv_icf_write_classifier_cascade(state->classifier, filename);
		state->x.classifier = 1;
	}
}

static void _ccv_icf_read_classifier_cascade_state(const char* directory, ccv_icf_classifier_cascade_state_t* state)
{
	char filename[1024];
	state->line_no = state->i = 0;
	state->bootstrap = 0;
	snprintf(filename, 1024, "%s/state", directory);
	FILE* r = fopen(filename, "r");
	if (r)
	{
		int feature_size;
		fscanf(r, "%d %d %d", &state->line_no, &state->i, &state->bootstrap);
		fscanf(r, "%d %d %d", &feature_size, &state->size.width, &state->size.height);
		fscanf(r, "%d %d %d %d", &state->margin.left, &state->margin.top, &state->margin.right, &state->margin.bottom);
		assert(feature_size == state->params.feature_size);
		fclose(r);
	}
	int i, q;
	snprintf(filename, 1024, "%s/positives", directory);
	r = fopen(filename, "rb");
	state->x.precomputed = state->x.features = state->x.example_state = state->x.classifier = state->x.positives = state->x.negatives = 1;
	if (r)
	{
		int rnum, rsize;
		fread(&rnum, sizeof(rnum), 1, r);
		fread(&rsize, sizeof(rsize), 1, r);
		state->positives = ccv_array_new(rsize, rnum, 0);
		ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)alloca(rsize);
		for (i = 0; i < rnum; i++)
		{
			fread(a, 1, rsize, r);
			assert(a->rows == state->size.height + state->margin.top + state->margin.bottom + 2 && a->cols == state->size.width + state->margin.left + state->margin.right + 2);
			ccv_array_push(state->positives, a);
		}
		fclose(r);
	}
	snprintf(filename, 1024, "%s/negatives", directory);
	r = fopen(filename, "rb");
	if (r)
	{
		int rnum, rsize;
		fread(&rnum, sizeof(rnum), 1, r);
		fread(&rsize, sizeof(rsize), 1, r);
		state->negatives = ccv_array_new(rsize, rnum, 0);
		ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)alloca(rsize);
		for (i = 0; i < rnum; i++)
		{
			fread(a, 1, rsize, r);
			assert(a->rows == state->size.height + state->margin.top + state->margin.bottom + 2 && a->cols == state->size.width + state->margin.left + state->margin.right + 2);
			ccv_array_push(state->negatives, a);
		}
		fclose(r);
	}
	snprintf(filename, 1024, "%s/features", directory);
	r = fopen(filename, "r");
	if (r)
	{
		state->features = (ccv_icf_feature_t*)ccmalloc(state->params.feature_size * sizeof(ccv_icf_feature_t));
		for (i = 0; i < state->params.feature_size; i++)
		{
			ccv_icf_feature_t* feature = state->features + i;
			fscanf(r, "%d %a", &feature->count, &feature->beta);
			for (q = 0; q < feature->count; q++)
				fscanf(r, "%d %a %d %d %d %d", &feature->channel[q], &feature->alpha[q], &feature->sat[q * 2].x, &feature->sat[q * 2].y, &feature->sat[q * 2 + 1].x, &feature->sat[q * 2 + 1].y);
		}
		fclose(r);
	}
	snprintf(filename, 1024, "%s/example_state", directory);
	r = fopen(filename, "r");
	if (r)
	{
		state->example_state = (ccv_icf_example_state_t*)ccmalloc((state->positives->rnum + state->negatives->rnum) * sizeof(ccv_icf_example_state_t));
		for (i = 0; i < state->positives->rnum + state->negatives->rnum; i++)
		{
			uint32_t correct;
			double weight;
			float rate;
			fscanf(r, "%u %la %a", &correct, &weight, &rate);
			state->example_state[i].correct = correct;
			state->example_state[i].weight = weight;
			state->example_state[i].rate = rate;
		}
		fclose(r);
	} else
		state->example_state = 0;
	snprintf(filename, 1024, "%s/precomputed", directory);
	r = fopen(filename, "rb");
	if (r)
	{
		size_t step = (3 * (state->positives->rnum + state->negatives->rnum) + 3) & -4;
		state->precomputed = (uint8_t*)ccmalloc(sizeof(uint8_t) * state->params.feature_size * step);
		fread(state->precomputed, 1, step * state->params.feature_size, r);
		fclose(r);
	} else
		state->precomputed = 0;
	snprintf(filename, 1024, "%s/cascade", directory);
	state->classifier = ccv_icf_read_classifier_cascade(filename);
	if (!state->classifier)
	{
		state->classifier = (ccv_icf_classifier_cascade_t*)ccmalloc(sizeof(ccv_icf_classifier_cascade_t));
		state->classifier->count = 0;
		state->classifier->grayscale = state->params.grayscale;
		state->classifier->weak_classifiers = (ccv_icf_decision_tree_t*)ccmalloc(sizeof(ccv_icf_decision_tree_t) * state->params.weak_classifier);
	} else {
		if (state->classifier->count < state->params.weak_classifier)
			state->classifier->weak_classifiers = (ccv_icf_decision_tree_t*)ccrealloc(state->classifier->weak_classifiers, sizeof(ccv_icf_decision_tree_t) * state->params.weak_classifier);
	}
}

#define less_than(s1, s2, aux) ((s1).value < (s2).value)
static CCV_IMPLEMENT_QSORT(_ccv_icf_precomputed_ordering, ccv_icf_value_index_t, less_than)
#undef less_than

static inline void _ccv_icf_3_uint8_to_1_uint1_1_uint23(uint8_t* u8, uint8_t* u1, uint32_t* uint23)
{
	*u1 = (u8[0] >> 7);
	*uint23 = (((uint32_t)(u8[0] & 0x7f)) << 16) | ((uint32_t)(u8[1]) << 8) | u8[2];
}

static inline uint32_t _ccv_icf_3_uint8_to_1_uint23(uint8_t* u8)
{
	return (((uint32_t)(u8[0] & 0x7f)) << 16) | ((uint32_t)(u8[1]) << 8) | u8[2];
}

static inline void _ccv_icf_1_uint1_1_uint23_to_3_uint8(uint8_t u1, uint32_t u23, uint8_t* u8)
{
	u8[0] = ((u1 << 7) | (u23 >> 16)) & 0xff;
	u8[1] = (u23 >> 8) & 0xff;
	u8[2] = u23 & 0xff;
}

static float _ccv_icf_run_feature_on_example(ccv_icf_feature_t* feature, ccv_dense_matrix_t* a)
{
	ccv_dense_matrix_t* icf = 0;
	// we have 1px padding around the image
	ccv_icf(a, &icf, 0);
	ccv_dense_matrix_t* sat = 0;
	ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
	ccv_matrix_free(icf);
	float* ptr = sat->data.f32;
	int ch = CCV_GET_CHANNEL(sat->type);
	float c = _ccv_icf_run_feature(feature, ptr, sat->cols, ch, 1, 1);
	ccv_matrix_free(sat);
	return c;
}

static uint8_t* _ccv_icf_precompute_features(ccv_icf_feature_t* features, int feature_size, ccv_array_t* positives, ccv_array_t* negatives)
{
	int i, j;
	// we use 3 bytes to represent the sorted index, and compute feature result (float) on fly
	size_t step = (3 * (positives->rnum + negatives->rnum) + 3) & -4;
	uint8_t* precomputed = (uint8_t*)ccmalloc(sizeof(uint8_t) * feature_size * step);
	ccv_icf_value_index_t* sortkv = (ccv_icf_value_index_t*)ccmalloc(sizeof(ccv_icf_value_index_t) * (positives->rnum + negatives->rnum));
	PRINT(CCV_CLI_INFO, " - precompute features using %uM memory temporarily\n", (uint32_t)((sizeof(float) * (positives->rnum + negatives->rnum) * feature_size + sizeof(uint8_t) * feature_size * step) / (1024 * 1024)));
	float* featval = (float*)ccmalloc(sizeof(float) * feature_size * (positives->rnum + negatives->rnum));
	ccv_disable_cache(); // clean up cache so we have enough space to run it
#ifdef USE_DISPATCH
	dispatch_semaphore_t sema = dispatch_semaphore_create(1);
	dispatch_apply(positives->rnum + negatives->rnum, dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^(size_t i) {
#else
	for (i = 0; i < positives->rnum + negatives->rnum; i++)
	{
#endif
#ifdef USE_DISPATCH
		dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
#endif
		if (i % 37 == 0 || i == positives->rnum + negatives->rnum - 1) // don't flush too fast
			FLUSH(CCV_CLI_INFO, " - precompute %d features through %d%% (%d / %d) examples", feature_size, (int)(i + 1) * 100 / (positives->rnum + negatives->rnum), (int)i + 1, positives->rnum + negatives->rnum);
#ifdef USE_DISPATCH
		dispatch_semaphore_signal(sema);
		int j;
#endif
		ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccv_array_get(i < positives->rnum ? positives : negatives, i < positives->rnum ? i : i - positives->rnum);
		a->data.u8 = (unsigned char*)(a + 1); // re-host the pointer to the right place
		ccv_dense_matrix_t* icf = 0;
		// we have 1px padding around the image
		ccv_icf(a, &icf, 0);
		ccv_dense_matrix_t* sat = 0;
		ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
		ccv_matrix_free(icf);
		float* ptr = sat->data.f32;
		int ch = CCV_GET_CHANNEL(sat->type);
		for (j = 0; j < feature_size; j++)
		{
			ccv_icf_feature_t* feature = features + j;
			float c = _ccv_icf_run_feature(feature, ptr, sat->cols, ch, 1, 1);
			assert(isfinite(c));
			featval[(size_t)j * (positives->rnum + negatives->rnum) + i] = c;
		}
		ccv_matrix_free(sat);
#ifdef USE_DISPATCH
	});
	dispatch_release(sema);
#else
	}
#endif
	PRINT(CCV_CLI_INFO, "\n");
	uint8_t* computed = precomputed;
	float* pfeatval = featval;
	for (i = 0; i < feature_size; i++)
	{
		if (i % 37 == 0 || i == feature_size - 1) // don't flush too fast
			FLUSH(CCV_CLI_INFO, " - precompute %d examples through %d%% (%d / %d) features", positives->rnum + negatives->rnum, (i + 1) * 100 / feature_size, i + 1, feature_size);
		for (j = 0; j < positives->rnum + negatives->rnum; j++)
			sortkv[j].value = pfeatval[j], sortkv[j].index = j;
		_ccv_icf_precomputed_ordering(sortkv, positives->rnum + negatives->rnum, 0);
		// the first flag denotes if the subsequent one are equal to the previous one (if so, we have to skip both of them)
		for (j = 0; j < positives->rnum + negatives->rnum - 1; j++)
			_ccv_icf_1_uint1_1_uint23_to_3_uint8(sortkv[j].value == sortkv[j + 1].value, sortkv[j].index, computed + j * 3);
		j = positives->rnum + negatives->rnum - 1;
		_ccv_icf_1_uint1_1_uint23_to_3_uint8(0, sortkv[j].index, computed + j * 3);
		computed += step;
		pfeatval += positives->rnum + negatives->rnum;
	}
	ccfree(featval);
	ccfree(sortkv);
	PRINT(CCV_CLI_INFO, "\n - features are precomputed on examples and will occupy %uM memory\n", (uint32_t)((feature_size * step) / (1024 * 1024)));
	return precomputed;
}

typedef struct {
	uint32_t pass;
	double weigh[4];
	int first_feature;
	uint8_t* lut;
} ccv_icf_decision_tree_cache_t;

static inline float _ccv_icf_compute_threshold_between(ccv_icf_feature_t* feature, uint8_t* computed, ccv_array_t* positives, ccv_array_t* negatives, int index0, int index1)
{
	float c[2];
	uint32_t b[2] = {
		_ccv_icf_3_uint8_to_1_uint23(computed + index0 * 3),
		_ccv_icf_3_uint8_to_1_uint23(computed + index1 * 3),
	};
	ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccv_array_get(b[0] < positives->rnum ? positives : negatives, b[0] < positives->rnum ? b[0] : b[0] - positives->rnum);
	a->data.u8 = (unsigned char*)(a + 1); // re-host the pointer to the right place
	c[0] = _ccv_icf_run_feature_on_example(feature, a);
	a = (ccv_dense_matrix_t*)ccv_array_get(b[1] < positives->rnum ? positives : negatives, b[1] < positives->rnum ? b[1] : b[1] - positives->rnum);
	a->data.u8 = (unsigned char*)(a + 1); // re-host the pointer to the right place
	c[1] = _ccv_icf_run_feature_on_example(feature, a);
	return (c[0] + c[1]) * 0.5;
}

static inline void _ccv_icf_example_correct(ccv_icf_example_state_t* example_state, uint8_t* computed, uint8_t* lut, int leaf, ccv_array_t* positives, ccv_array_t* negatives, int start, int end)
{
	int i;
	for (i = start; i <= end; i++)
	{
		uint32_t index = _ccv_icf_3_uint8_to_1_uint23(computed + i * 3);
		if (!lut || lut[index] == leaf)
			example_state[index].correct = (index < positives->rnum);
	}
}

typedef struct {
	int error_index;
	double error_rate;
	double weigh[2];
	int count[2];
} ccv_icf_first_feature_find_t;

static ccv_icf_decision_tree_cache_t _ccv_icf_find_first_feature(ccv_icf_feature_t* features, int feature_size, ccv_array_t* positives, ccv_array_t* negatives, uint8_t* precomputed, ccv_icf_example_state_t* example_state, ccv_icf_feature_t* feature)
{
	int i;
	assert(feature != 0);
	ccv_icf_decision_tree_cache_t intermediate_cache;
	double aweigh0 = 0, aweigh1 = 0;
	for (i = 0; i < positives->rnum; i++)
		aweigh1 += example_state[i].weight, example_state[i].correct = 0; // assuming positive examples we get wrong
	for (i = positives->rnum; i < positives->rnum + negatives->rnum; i++)
		aweigh0 += example_state[i].weight, example_state[i].correct = 1; // assuming negative examples we get right
	size_t step = (3 * (positives->rnum + negatives->rnum) + 3) & -4;
	ccv_icf_first_feature_find_t* feature_find = (ccv_icf_first_feature_find_t*)ccmalloc(sizeof(ccv_icf_first_feature_find_t) * feature_size);
	parallel_for(i, feature_size) {
		ccv_icf_first_feature_find_t min_find = {
			.error_rate = 1.0,
			.error_index = 0,
			.weigh = {0, 0},
			.count = {0, 0},
		};
		double weigh[2] = {0, 0};
		int count[2] = {0, 0};
		int j;
		uint8_t* computed = precomputed + step * i;
		for (j = 0; j < positives->rnum + negatives->rnum; j++)
		{
			uint8_t skip;
			uint32_t index;
			_ccv_icf_3_uint8_to_1_uint1_1_uint23(computed + j * 3, &skip, &index);
			conditional_assert(j == positives->rnum + negatives->rnum - 1, !skip);
			assert(index >= 0 && index < positives->rnum + negatives->rnum);
			weigh[index < positives->rnum] += example_state[index].weight;
			assert(example_state[index].weight > 0);
			assert(weigh[0] <= aweigh0 + 1e-10 && weigh[1] <= aweigh1 + 1e-10);
			++count[index < positives->rnum];
			if (skip) // the current index is equal to the next one, we cannot differentiate, therefore, skip
				continue;
			double error_rate = ccv_min(weigh[0] + aweigh1 - weigh[1], weigh[1] + aweigh0 - weigh[0]);
			assert(error_rate > 0);
			if (error_rate < min_find.error_rate)
			{
				min_find.error_index = j;
				min_find.error_rate = error_rate;
				min_find.weigh[0] = weigh[0];
				min_find.weigh[1] = weigh[1];
				min_find.count[0] = count[0];
				min_find.count[1] = count[1];
			}
		}
		feature_find[i] = min_find;
	} parallel_endfor
	ccv_icf_first_feature_find_t best = {
		.error_rate = 1.0,
		.error_index = -1,
		.weigh = {0, 0},
		.count = {0, 0},
	};
	int feature_index = 0;
	for (i = 0; i < feature_size; i++)
		if (feature_find[i].error_rate < best.error_rate)
		{
			best = feature_find[i];
			feature_index = i;
		}
	ccfree(feature_find);
	*feature = features[feature_index];
	uint8_t* computed = precomputed + step * feature_index;
	intermediate_cache.lut = (uint8_t*)ccmalloc(positives->rnum + negatives->rnum);
	assert(best.error_index < positives->rnum + negatives->rnum - 1 && best.error_index >= 0);
	if (best.weigh[0] + aweigh1 - best.weigh[1] < best.weigh[1] + aweigh0 - best.weigh[0])
	{
		for (i = 0; i < positives->rnum + negatives->rnum; i++)
			intermediate_cache.lut[_ccv_icf_3_uint8_to_1_uint23(computed + i * 3)] = (i <= best.error_index);
		feature->beta = _ccv_icf_compute_threshold_between(feature, computed, positives, negatives, best.error_index, best.error_index + 1);
		// revert the sign of alpha, after threshold is computed
		for (i = 0; i < feature->count; i++)
			feature->alpha[i] = -feature->alpha[i];
		intermediate_cache.weigh[0] = aweigh0 - best.weigh[0];
		intermediate_cache.weigh[1] = aweigh1 - best.weigh[1];
		intermediate_cache.weigh[2] = best.weigh[0];
		intermediate_cache.weigh[3] = best.weigh[1];
		intermediate_cache.pass = 3;
		if (best.count[0] == 0)
			intermediate_cache.pass &= 2; // only positive examples in the right, no need to build right leaf
		if (best.count[1] == positives->rnum)
			intermediate_cache.pass &= 1; // no positive examples in the left, no need to build left leaf
		if (!(intermediate_cache.pass & 1)) // mark positives in the right as correct, if we don't have right leaf
			_ccv_icf_example_correct(example_state, computed, 0, 0, positives, negatives, 0, best.error_index);
	} else {
		for (i = 0; i < positives->rnum + negatives->rnum; i++)
			intermediate_cache.lut[_ccv_icf_3_uint8_to_1_uint23(computed + i * 3)] = (i > best.error_index);
		feature->beta = -_ccv_icf_compute_threshold_between(feature, computed, positives, negatives, best.error_index, best.error_index + 1);
		intermediate_cache.weigh[0] = best.weigh[0];
		intermediate_cache.weigh[1] = best.weigh[1];
		intermediate_cache.weigh[2] = aweigh0 - best.weigh[0];
		intermediate_cache.weigh[3] = aweigh1 - best.weigh[1];
		intermediate_cache.pass = 3;
		if (best.count[0] == negatives->rnum)
			intermediate_cache.pass &= 2; // only positive examples in the right, no need to build right leaf
		if (best.count[1] == 0)
			intermediate_cache.pass &= 1; // no positive examples in the left, no need to build left leaf
		if (!(intermediate_cache.pass & 1)) // mark positives in the right as correct if we don't have right leaf
			_ccv_icf_example_correct(example_state, computed, 0, 0, positives, negatives, best.error_index + 1, positives->rnum + negatives->rnum - 1);
	}
	intermediate_cache.first_feature = feature_index;
	return intermediate_cache;
}

typedef struct {
	int error_index;
	double error_rate;
	double weigh[2];
} ccv_icf_second_feature_find_t;

static double _ccv_icf_find_second_feature(ccv_icf_decision_tree_cache_t intermediate_cache, int leaf, ccv_icf_feature_t* features, int feature_size, ccv_array_t* positives, ccv_array_t* negatives, uint8_t* precomputed, ccv_icf_example_state_t* example_state, ccv_icf_feature_t* feature)
{
	size_t step = (3 * (positives->rnum + negatives->rnum) + 3) & -4;
	uint8_t* lut = intermediate_cache.lut;
	double* aweigh = intermediate_cache.weigh + leaf * 2;
	ccv_icf_second_feature_find_t* feature_find = (ccv_icf_second_feature_find_t*)ccmalloc(sizeof(ccv_icf_second_feature_find_t) * feature_size);
	parallel_for(i, feature_size) {
		ccv_icf_second_feature_find_t min_find = {
			.error_rate = 1.0,
			.error_index = 0,
			.weigh = {0, 0},
		};
		double weigh[2] = {0, 0};
		uint8_t* computed = precomputed + step * i;
		int j, k;
		for (j = 0; j < positives->rnum + negatives->rnum; j++)
		{
			uint8_t skip;
			uint32_t index;
			_ccv_icf_3_uint8_to_1_uint1_1_uint23(computed + j * 3, &skip, &index);
			conditional_assert(j == positives->rnum + negatives->rnum - 1, !skip);
			assert(index >= 0 && index < positives->rnum + negatives->rnum);
			// only care about part of the data
			if (lut[index] == leaf)
			{
				uint8_t leaf_skip = 0;
				for (k = j + 1; skip; k++)
				{
					uint32_t new_index;
					_ccv_icf_3_uint8_to_1_uint1_1_uint23(computed + j * 3, &skip, &new_index);
					// if the next equal one is the same leaf, we cannot distinguish them, skip
					if ((leaf_skip = (lut[new_index] == leaf)))
						break;
					conditional_assert(k == positives->rnum + negatives->rnum - 1, !skip);
				}
				weigh[index < positives->rnum] += example_state[index].weight;
				if (leaf_skip)
					continue;
				assert(example_state[index].weight > 0);
				assert(weigh[0] <= aweigh[0] + 1e-10 && weigh[1] <= aweigh[1] + 1e-10);
				double error_rate = ccv_min(weigh[0] + aweigh[1] - weigh[1], weigh[1] + aweigh[0] - weigh[0]);
				if (error_rate < min_find.error_rate)
				{
					min_find.error_index = j;
					min_find.error_rate = error_rate;
					min_find.weigh[0] = weigh[0];
					min_find.weigh[1] = weigh[1];
				}
			}
		}
		feature_find[i] = min_find;
	} parallel_endfor
	ccv_icf_second_feature_find_t best = {
		.error_rate = 1.0,
		.error_index = -1,
		.weigh = {0, 0},
	};
	int i;
	int feature_index = 0;
	for (i = 0; i < feature_size; i++)
		if (feature_find[i].error_rate < best.error_rate)
		{
			best = feature_find[i];
			feature_index = i;
		}
	ccfree(feature_find);
	*feature = features[feature_index];
	uint8_t* computed = precomputed + step * feature_index;
	assert(best.error_index < positives->rnum + negatives->rnum - 1 && best.error_index >= 0);
	if (best.weigh[0] + aweigh[1] - best.weigh[1] < best.weigh[1] + aweigh[0] - best.weigh[0])
	{
		feature->beta = _ccv_icf_compute_threshold_between(feature, computed, positives, negatives, best.error_index, best.error_index + 1);
		// revert the sign of alpha, after threshold is computed
		for (i = 0; i < feature->count; i++)
			feature->alpha[i] = -feature->alpha[i];
		// mark everything on the right properly
		_ccv_icf_example_correct(example_state, computed, lut, leaf, positives, negatives, 0, best.error_index);
		return best.weigh[1] + aweigh[0] - best.weigh[0];
	} else {
		feature->beta = -_ccv_icf_compute_threshold_between(feature, computed, positives, negatives, best.error_index, best.error_index + 1);
		// mark everything on the right properly
		_ccv_icf_example_correct(example_state, computed, lut, leaf, positives, negatives, best.error_index + 1, positives->rnum + negatives->rnum - 1);
		return best.weigh[0] + aweigh[1] - best.weigh[1];
	}
}

static double _ccv_icf_find_best_weak_classifier(ccv_icf_feature_t* features, int feature_size, ccv_array_t* positives, ccv_array_t* negatives, uint8_t* precomputed, ccv_icf_example_state_t* example_state, ccv_icf_decision_tree_t* weak_classifier)
{
	// we are building the specific depth-2 decision tree
	ccv_icf_decision_tree_cache_t intermediate_cache = _ccv_icf_find_first_feature(features, feature_size, positives, negatives, precomputed, example_state, weak_classifier->features);
	// find the left feature
	// for the pass, 10 is the left branch, 01 is the right branch
	weak_classifier->pass = intermediate_cache.pass;
	double rate = 0;
	if (weak_classifier->pass & 0x2)
		rate += _ccv_icf_find_second_feature(intermediate_cache, 0, features, feature_size, positives, negatives, precomputed, example_state, weak_classifier->features + 1);
	else
		rate += intermediate_cache.weigh[0]; // the negative weights covered by first feature
	// find the right feature
	if (weak_classifier->pass & 0x1)
		rate += _ccv_icf_find_second_feature(intermediate_cache, 1, features, feature_size, positives, negatives, precomputed, example_state, weak_classifier->features + 2);
	else
		rate += intermediate_cache.weigh[3]; // the positive weights covered by first feature
	ccfree(intermediate_cache.lut);
	return rate;
}

static ccv_array_t* _ccv_icf_collect_validates(gsl_rng* rng, ccv_size_t size, ccv_margin_t margin, ccv_array_t* validatefiles, int grayscale)
{
	ccv_array_t* validates = ccv_array_new(ccv_compute_dense_matrix_size(size.height + margin.top + margin.bottom + 2, size.width + margin.left + margin.right + 2, CCV_8U | (grayscale ? CCV_C1 : CCV_C3)), validatefiles->rnum, 0);
	int i;
	// collect tests
	for (i = 0; i < validatefiles->rnum; i++)
	{
		ccv_file_info_t* file_info = (ccv_file_info_t*)ccv_array_get(validatefiles, i);
		ccv_dense_matrix_t* image = 0;
		ccv_read(file_info->filename, &image, CCV_IO_ANY_FILE | (grayscale ? CCV_IO_GRAY : CCV_IO_RGB_COLOR));
		if (image == 0)
		{
			PRINT(CCV_CLI_ERROR, "\n - %s: cannot be open, possibly corrupted\n", file_info->filename);
			continue;
		}
		ccv_dense_matrix_t* feature = _ccv_icf_capture_feature(rng, image, file_info->pose, size, margin, 0, 0, 0);
		feature->sig = 0;
		ccv_array_push(validates, feature);
		ccv_matrix_free(feature);
		ccv_matrix_free(image);
	}
	return validates;
}

static ccv_array_t* _ccv_icf_collect_positives(gsl_rng* rng, ccv_size_t size, ccv_margin_t margin, ccv_array_t* posfiles, int posnum, float deform_angle, float deform_scale, float deform_shift, int grayscale)
{
	ccv_array_t* positives = ccv_array_new(ccv_compute_dense_matrix_size(size.height + margin.top + margin.bottom + 2, size.width + margin.left + margin.right + 2, CCV_8U | (grayscale ? CCV_C1 : CCV_C3)), posnum, 0);
	int i, j, q;
	// collect positives (with random deformation)
	for (i = 0; i < posnum;)
	{
		FLUSH(CCV_CLI_INFO, " - collect positives %d%% (%d / %d)", (i + 1) * 100 / posnum, i + 1, posnum);
		double ratio = (double)(posnum - i) / posfiles->rnum;
		for (j = 0; j < posfiles->rnum && i < posnum; j++)
		{
			ccv_file_info_t* file_info = (ccv_file_info_t*)ccv_array_get(posfiles, j);
			ccv_dense_matrix_t* image = 0;
			ccv_read(file_info->filename, &image, CCV_IO_ANY_FILE | (grayscale ? CCV_IO_GRAY : CCV_IO_RGB_COLOR));
			if (image == 0)
			{
				PRINT(CCV_CLI_ERROR, "\n - %s: cannot be open, possibly corrupted\n", file_info->filename);
				continue;
			}
			for (q = 0; q < ratio; q++)
				if (q < (int)ratio || gsl_rng_uniform(rng) <= ratio - (int)ratio)
				{
					FLUSH(CCV_CLI_INFO, " - collect positives %d%% (%d / %d)", (i + 1) * 100 / posnum, i + 1, posnum);
					ccv_dense_matrix_t* feature = _ccv_icf_capture_feature(rng, image, file_info->pose, size, margin, deform_angle, deform_scale, deform_shift);
					feature->sig = 0;
					ccv_array_push(positives, feature);
					ccv_matrix_free(feature);
					++i;
					if (i >= posnum)
						break;
				}
			ccv_matrix_free(image);
		}
	}
	PRINT(CCV_CLI_INFO, "\n");
	return positives;
}

static uint64_t* _ccv_icf_precompute_classifier_cascade(ccv_icf_classifier_cascade_t* cascade, ccv_array_t* positives)
{
	int step = ((cascade->count - 1) >> 6) + 1;
	uint64_t* precomputed = (uint64_t*)ccmalloc(sizeof(uint64_t) * positives->rnum * step);
	uint64_t* result = precomputed;
	int i, j;
	for (i = 0; i < positives->rnum; i++)
	{
		ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)(ccv_array_get(positives, i));
		a->data.u8 = (uint8_t*)(a + 1);
		ccv_dense_matrix_t* icf = 0;
		ccv_icf(a, &icf, 0);
		ccv_dense_matrix_t* sat = 0;
		ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
		ccv_matrix_free(icf);
		float* ptr = sat->data.f32;
		int ch = CCV_GET_CHANNEL(sat->type);
		for (j = 0; j < cascade->count; j++)
			if (_ccv_icf_run_weak_classifier(cascade->weak_classifiers + j,  ptr, sat->cols, ch, 1, 1))
				precomputed[j >> 6] |= (1UL << (j & 63));
			else
				precomputed[j >> 6] &= ~(1UL << (j & 63));
		ccv_matrix_free(sat);
		precomputed += step;
	}
	return result;
}

#define less_than(s1, s2, aux) ((s1) > (s2))
static CCV_IMPLEMENT_QSORT(_ccv_icf_threshold_rating, float, less_than)
#undef less_than

static void _ccv_icf_classifier_cascade_soft_with_validates(ccv_array_t* validates, ccv_icf_classifier_cascade_t* cascade, double min_accept)
{
	int i, j;
	int step = ((cascade->count - 1) >> 6) + 1;
	uint64_t* precomputed = _ccv_icf_precompute_classifier_cascade(cascade, validates);
	float* positive_rate = (float*)ccmalloc(sizeof(float) * validates->rnum);
	uint64_t* computed = precomputed;
	for (i = 0; i < validates->rnum; i++)
	{
		positive_rate[i] = 0;
		for (j = 0; j < cascade->count; j++)
		{
			uint64_t accept = computed[j >> 6] & (1UL << (j & 63));
			positive_rate[i] += cascade->weak_classifiers[j].weigh[!!accept];
		}
		computed += step;
	}
	_ccv_icf_threshold_rating(positive_rate, validates->rnum, 0);
	float threshold = positive_rate[ccv_min((int)(min_accept * (validates->rnum + 0.5) - 0.5), validates->rnum - 1)];
	ccfree(positive_rate);
	computed = precomputed;
	// compute the final acceptance per validates / negatives with final threshold
	uint64_t* acceptance = (uint64_t*)cccalloc(((validates->rnum - 1) >> 6) + 1, sizeof(uint64_t));
	int true_positives = 0;
	for (i = 0; i < validates->rnum; i++)
	{
		float rate = 0;
		for (j = 0; j < cascade->count; j++)
		{
			uint64_t accept = computed[j >> 6] & (1UL << (j & 63));
			rate += cascade->weak_classifiers[j].weigh[!!accept];
		}
		if (rate >= threshold)
		{
			acceptance[i >> 6] |= (1UL << (i & 63));
			++true_positives;
		} else
			acceptance[i >> 6] &= ~(1UL << (i & 63));
		computed += step;
	}
	PRINT(CCV_CLI_INFO, " - at threshold %f, true positive rate: %f%%\n", threshold, (float)true_positives * 100 / validates->rnum);
	float* rate = (float*)cccalloc(validates->rnum, sizeof(float));
	for (j = 0; j < cascade->count; j++)
	{
		computed = precomputed;
		for (i = 0; i < validates->rnum; i++)
		{
			uint64_t correct = computed[j >> 6] & (1UL << (j & 63));
			rate[i] += cascade->weak_classifiers[j].weigh[!!correct];
			computed += step;
		}
		float threshold = FLT_MAX;
		// find a threshold that keeps all accepted validates still acceptable
		for (i = 0; i < validates->rnum; i++)
		{
			uint64_t correct = acceptance[i >> 6] & (1UL << (i & 63));
			if (correct && rate[i] < threshold)
				threshold = rate[i];
		}
		cascade->weak_classifiers[j].threshold = threshold - 1e-10;
	}
	ccfree(rate);
	ccfree(acceptance);
	ccfree(precomputed);
}

typedef struct {
	ccv_point_t point;
	float sum;
} ccv_point_with_sum_t;

static void _ccv_icf_bootstrap_negatives(ccv_icf_classifier_cascade_t* cascade, ccv_array_t* negatives, gsl_rng* rng, ccv_array_t* bgfiles, int negnum, int grayscale, int spread, ccv_icf_param_t params)
{
#ifdef USE_DISPATCH
	__block int i;
#else
	int i;
#endif
#ifdef USE_DISPATCH
	__block int fppi = 0, is = 0;
#else
	int fppi = 0, is = 0;
#endif
	int t = 0;
	for (i = 0; i < negnum;)
	{
		double ratio = (double)(negnum - i) / bgfiles->rnum;
#ifdef USE_DISPATCH
		dispatch_semaphore_t sem = dispatch_semaphore_create(1);
		dispatch_apply(bgfiles->rnum, dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^(size_t j) {
#else
		size_t j;
		for (j = 0; j < bgfiles->rnum; j++)
		{
#endif
			int k, x, y, q, p;
			ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccmalloc(ccv_compute_dense_matrix_size(cascade->size.height + 2, cascade->size.width + 2, (grayscale ? CCV_C1 : CCV_C3) | CCV_8U));
#ifdef USE_DISPATCH
			dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
#endif
			if (i >= negnum || (spread && ratio < 1 && gsl_rng_uniform(rng) > ratio))
			{
				ccfree(a);
#ifdef USE_DISPATCH
				dispatch_semaphore_signal(sem);
				return;
#else
				continue;
#endif
			}
			FLUSH(CCV_CLI_INFO, " - bootstrap negatives %d%% (%d / %d) [%u / %d] %s", (i + 1) * 100 / negnum, i + 1, negnum, (uint32_t)(j + 1), bgfiles->rnum, spread ? "" : "without statistic balancing");
#ifdef USE_DISPATCH
			gsl_rng* crng = gsl_rng_alloc(gsl_rng_default);
			gsl_rng_set(crng, gsl_rng_get(rng));
			dispatch_semaphore_signal(sem);
#else
			gsl_rng* crng = rng;
#endif
			ccv_file_info_t* file_info = (ccv_file_info_t*)ccv_array_get(bgfiles, j);
			ccv_dense_matrix_t* image = 0;
			ccv_read(file_info->filename, &image, CCV_IO_ANY_FILE | (grayscale ? CCV_IO_GRAY : CCV_IO_RGB_COLOR));
			if (image == 0)
			{
				PRINT(CCV_CLI_ERROR, "\n - %s: cannot be open, possibly corrupted\n", file_info->filename);
				ccfree(a);
#ifdef USE_DISPATCH
				gsl_rng_free(crng);
				return;
#else
				continue;
#endif
			}
			if (ccv_max(image->rows, image->cols) < 800 ||
				image->rows <= (cascade->size.height - cascade->margin.top - cascade->margin.bottom) ||
				image->cols <= (cascade->size.width - cascade->margin.left - cascade->margin.right)) // background is too small, blow it up to next scale
			{
				ccv_dense_matrix_t* blowup = 0;
				ccv_sample_up(image, &blowup, 0, 0, 0);
				ccv_matrix_free(image);
				image = blowup;
			}
			if (image->rows <= (cascade->size.height - cascade->margin.top - cascade->margin.bottom) ||
				image->cols <= (cascade->size.width - cascade->margin.left - cascade->margin.right)) // background is still too small, abort
			{
				ccv_matrix_free(image);
				ccfree(a);
#ifdef USE_DISPATCH
				gsl_rng_free(crng);
				return;
#else
				continue;
#endif
			}
			double scale = pow(2., 1. / (params.interval + 1.));
			int next = params.interval + 1;
			int scale_upto = (int)(log(ccv_min((double)image->rows / (cascade->size.height - cascade->margin.top - cascade->margin.bottom), (double)image->cols / (cascade->size.width - cascade->margin.left - cascade->margin.right))) / log(scale) - DBL_MIN) + 1;
			ccv_dense_matrix_t** pyr = (ccv_dense_matrix_t**)ccmalloc(scale_upto * sizeof(ccv_dense_matrix_t*));
			memset(pyr, 0, scale_upto * sizeof(ccv_dense_matrix_t*));
#ifdef USE_DISPATCH
			dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
#endif
			++is; // how many images are scanned
#ifdef USE_DISPATCH
			dispatch_semaphore_signal(sem);
#endif
			if (t % 2 != 0)
				ccv_flip(image, 0, 0, CCV_FLIP_X);
			if (t % 4 >= 2)
				ccv_flip(image, 0, 0, CCV_FLIP_Y);
			pyr[0] = image;
			for (q = 1; q < ccv_min(params.interval + 1, scale_upto); q++)
				ccv_resample(pyr[0], &pyr[q], 0, (int)(pyr[0]->rows / pow(scale, q)), (int)(pyr[0]->cols / pow(scale, q)), CCV_INTER_AREA);
			for (q = next; q < scale_upto; q++)
				ccv_sample_down(pyr[q - next], &pyr[q], 0, 0, 0);
			for (q = 0; q < scale_upto; q++)
			{
#ifdef USE_DISPATCH
				dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
#endif
				if (i >= negnum)
				{
#ifdef USE_DISPATCH
					dispatch_semaphore_signal(sem);
#endif
					ccv_matrix_free(pyr[q]);
					continue;
				}
#ifdef USE_DISPATCH
				dispatch_semaphore_signal(sem);
#endif
				ccv_dense_matrix_t* bordered = 0;
				ccv_border(pyr[q], (ccv_matrix_t**)&bordered, 0, cascade->margin);
				ccv_matrix_free(pyr[q]);
				ccv_dense_matrix_t* icf = 0;
				ccv_icf(bordered, &icf, 0);
				ccv_dense_matrix_t* sat = 0;
				ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
				ccv_matrix_free(icf);
				assert(sat->rows == bordered->rows + 1 && sat->cols == bordered->cols + 1);
				int ch = CCV_GET_CHANNEL(sat->type);
				float* ptr = sat->data.f32 + sat->cols * ch;
				ccv_array_t* seq = ccv_array_new(sizeof(ccv_point_with_sum_t), 64, 0);
				for (y = 1; y < sat->rows - cascade->size.height - 2; y += params.step_through)
				{
					for (x = 1; x < sat->cols - cascade->size.width - 2; x += params.step_through)
					{
						int pass = 1;
						float sum = 0;
						for (p = 0; p < cascade->count; p++)
						{
							ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + p;
							int c = _ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, x, 0);
							sum += weak_classifier->weigh[c];
							if (sum < weak_classifier->threshold)
							{
								pass = 0;
								break;
							}
						}
						if (pass)
						{
							ccv_point_with_sum_t point;
							point.point = ccv_point(x - 1, y - 1);
							point.sum = sum;
							ccv_array_push(seq, &point);
						}
					}
					ptr += sat->cols * ch * params.step_through;
				}
				ccv_matrix_free(sat);
				// shuffle negatives so that we don't have too biased negatives
#ifdef USE_DISPATCH
				dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
#endif
				fppi += seq->rnum; // how many detections we have in total
#ifdef USE_DISPATCH
				dispatch_semaphore_signal(sem);
#endif
				if (seq->rnum > 0)
				{
					gsl_ran_shuffle(crng, ccv_array_get(seq, 0), seq->rnum, seq->rsize);
					/* so that we at least collect 10 from each scale */
					for (p = 0; p < (spread ? ccv_min(10, seq->rnum) : seq->rnum); p++) // collect enough negatives from this scale
					{
						a = ccv_dense_matrix_new(cascade->size.height + 2, cascade->size.width + 2, (grayscale ? CCV_C1 : CCV_C3) | CCV_8U, a, 0);
						ccv_point_with_sum_t* point = (ccv_point_with_sum_t*)ccv_array_get(seq, p);
						ccv_slice(bordered, (ccv_matrix_t**)&a, 0, point->point.y, point->point.x, a->rows, a->cols);
						assert(bordered->rows >= point->point.y + a->rows && bordered->cols >= point->point.x + a->cols);
						a->sig = 0;
						// verify the data we sliced is worthy negative
						ccv_dense_matrix_t* icf = 0;
						ccv_icf(a, &icf, 0);
						ccv_dense_matrix_t* sat = 0;
						ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
						ccv_matrix_free(icf);
						float* ptr = sat->data.f32;
						int ch = CCV_GET_CHANNEL(sat->type);
						int pass = 1;
						float sum = 0;
						for (k = 0; k < cascade->count; k++)
						{
							ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + k;
							int c = _ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, 1, 1);
							sum += weak_classifier->weigh[c];
							if (sum < weak_classifier->threshold)
							{
								pass = 0;
								break;
							}
						}
						ccv_matrix_free(sat);
						if (pass)
						{
#ifdef USE_DISPATCH
							dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
#endif
							if (i < negnum)
								ccv_array_push(negatives, a);
							++i;
							if (i >= negnum)
							{
#ifdef USE_DISPATCH
								dispatch_semaphore_signal(sem);
#endif
								break;
							}
#ifdef USE_DISPATCH
							dispatch_semaphore_signal(sem);
#endif
						}
					}
				}
				ccv_array_free(seq);
				ccv_matrix_free(bordered);
			}
			ccfree(pyr);
			ccfree(a);
#ifdef USE_DISPATCH
			gsl_rng_free(crng);
		});
		dispatch_release(sem);
#else
		}
#endif
		if ((double)fppi / is <= (double)negnum / bgfiles->rnum) // if the targeted negative per image is bigger than our fppi, we don't prob anymore
			spread = 0;
		++t;
		if (t > (spread ? 4 : 3) && !spread) // we've go over 4 or 3 transformations (original, flip x, flip y, flip x & y, [and original again]), and nothing we can do now
			break;
	}
	PRINT(CCV_CLI_INFO, "\n");
}

static ccv_array_t* _ccv_icf_collect_negatives(gsl_rng* rng, ccv_size_t size, ccv_margin_t margin, ccv_array_t* bgfiles, int negnum, float deform_angle, float deform_scale, float deform_shift, int grayscale)
{
	ccv_array_t* negatives = ccv_array_new(ccv_compute_dense_matrix_size(size.height + margin.top + margin.bottom + 2, size.width + margin.left + margin.right + 2, CCV_8U | (grayscale ? CCV_C1 : CCV_C3)), negnum, 0);
	int i, j, q;
	// randomly collect negatives (with random deformation)
	for (i = 0; i < negnum;)
	{
		FLUSH(CCV_CLI_INFO, " - collect negatives %d%% (%d / %d)", (i + 1) * 100 / negnum, i + 1, negnum);
		double ratio = (double)(negnum - i) / bgfiles->rnum;
		for (j = 0; j < bgfiles->rnum && i < negnum; j++)
		{
			ccv_file_info_t* file_info = (ccv_file_info_t*)ccv_array_get(bgfiles, j);
			ccv_dense_matrix_t* image = 0;
			ccv_read(file_info->filename, &image, CCV_IO_ANY_FILE | (grayscale ? CCV_IO_GRAY : CCV_IO_RGB_COLOR));
			if (image == 0)
			{
				PRINT(CCV_CLI_ERROR, "\n - %s: cannot be open, possibly corrupted\n", file_info->filename);
				continue;
			}
			double max_scale_ratio = ccv_min((double)image->rows / size.height, (double)image->cols / size.width);
			if (max_scale_ratio <= 0.5) // too small to be interesting
				continue;
			for (q = 0; q < ratio; q++)
				if (q < (int)ratio || gsl_rng_uniform(rng) <= ratio - (int)ratio)
				{
					FLUSH(CCV_CLI_INFO, " - collect negatives %d%% (%d / %d)", (i + 1) * 100 / negnum, i + 1, negnum);
					ccv_decimal_pose_t pose;
					double scale_ratio = gsl_rng_uniform(rng) * (max_scale_ratio - 0.5) + 0.5;
					pose.a = size.width * 0.5 * scale_ratio;
					pose.b = size.height * 0.5 * scale_ratio;
					pose.x = gsl_rng_uniform_int(rng, ccv_max((int)(image->cols - pose.a * 2 + 1.5), 1)) + pose.a;
					pose.y = gsl_rng_uniform_int(rng, ccv_max((int)(image->rows - pose.b * 2 + 1.5), 1)) + pose.b;
					pose.roll = pose.pitch = pose.yaw = 0;
					ccv_dense_matrix_t* feature = _ccv_icf_capture_feature(rng, image, pose, size, margin, deform_angle, deform_scale, deform_shift);
					feature->sig = 0;
					ccv_array_push(negatives, feature);
					ccv_matrix_free(feature);
					++i;
					if (i >= negnum)
						break;
				}
			ccv_matrix_free(image);
		}
	}
	PRINT(CCV_CLI_INFO, "\n");
	return negatives;
}

#ifdef USE_SANITY_ASSERTION
static double _ccv_icf_rate_weak_classifier(ccv_icf_decision_tree_t* weak_classifier, ccv_array_t* positives, ccv_array_t* negatives, ccv_icf_example_state_t* example_state)
{
	int i;
	double rate = 0;
	for (i = 0; i < positives->rnum + negatives->rnum; i++)
	{
		ccv_dense_matrix_t* a = (ccv_dense_matrix_t*)ccv_array_get(i < positives->rnum ? positives : negatives, i < positives->rnum ? i : i - positives->rnum);
		a->data.u8 = (uint8_t*)(a + 1); // re-host the pointer to the right place
		ccv_dense_matrix_t* icf = 0;
		// we have 1px padding around the image
		ccv_icf(a, &icf, 0);
		ccv_dense_matrix_t* sat = 0;
		ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
		ccv_matrix_free(icf);
		float* ptr = sat->data.f32;
		int ch = CCV_GET_CHANNEL(sat->type);
		if (i < positives->rnum)
		{
			if (_ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, 1, 1))
			{
				assert(example_state[i].correct);
				rate += example_state[i].weight;
			} else {
				assert(!example_state[i].correct);
			}
		} else {
			if (!_ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, 1, 1))
			{
				assert(example_state[i].correct);
				rate += example_state[i].weight;
			} else {
				assert(!example_state[i].correct);
			}
		}
		ccv_matrix_free(sat);
	}
	return rate;
}
#endif
#endif

ccv_icf_classifier_cascade_t* ccv_icf_classifier_cascade_new(ccv_array_t* posfiles, int posnum, ccv_array_t* bgfiles, int negnum, ccv_array_t* validatefiles, const char* dir, ccv_icf_new_param_t params)
{
#ifdef HAVE_GSL
	_ccv_icf_check_params(params);
	assert(posfiles->rnum > 0);
	assert(bgfiles->rnum > 0);
	assert(posnum > 0 && negnum > 0);
	PRINT(CCV_CLI_INFO, "with %d positive examples and %d negative examples\n"
						"positive examples are going to be collected from %d positive images\n"
						"negative examples are are going to be collected from %d background images\n",
						posnum, negnum, posfiles->rnum, bgfiles->rnum);
	PRINT(CCV_CLI_INFO, "use color? %s\n", params.grayscale ? "no" : "yes");
	PRINT(CCV_CLI_INFO, "feature pool size : %d\n"
						"weak classifier count : %d\n"
						"soft cascade acceptance : %lf\n"
						"minimum dimension of ICF feature : %d\n"
						"number of bootstrap : %d\n"
						"distortion on translation : %f\n"
						"distortion on rotation : %f\n"
						"distortion on scale : %f\n"
						"learn ICF classifier cascade at size %dx%d with margin (%d,%d,%d,%d)\n"
						"------------------------\n",
						params.feature_size, params.weak_classifier, params.acceptance, params.min_dimension, params.bootstrap, params.deform_shift, params.deform_angle, params.deform_scale, params.size.width, params.size.height, params.margin.left, params.margin.top, params.margin.right, params.margin.bottom);
	gsl_rng_env_setup();
	gsl_rng* rng = gsl_rng_alloc(gsl_rng_default);
	// we will keep all states inside this structure for easier save / resume across process
	// this should work better than ad-hoc one we used in DPM / BBF implementation
	ccv_icf_classifier_cascade_state_t z;
	z.params = params;
	ccv_function_state_begin(_ccv_icf_read_classifier_cascade_state, z, dir);
	z.classifier->grayscale = params.grayscale;
	z.size = params.size;
	z.margin = params.margin;
	z.classifier->size = ccv_size(z.size.width + z.margin.left + z.margin.right, z.size.height + z.margin.top + z.margin.bottom);
	z.features = (ccv_icf_feature_t*)ccmalloc(sizeof(ccv_icf_feature_t) * params.feature_size);
	// generate random features
	for (z.i = 0; z.i < params.feature_size; z.i++)
		_ccv_icf_randomize_feature(rng, z.classifier->size, params.min_dimension, z.features + z.i, params.grayscale);
	z.x.features = 0;
	ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
	z.positives = _ccv_icf_collect_positives(rng, z.size, z.margin, posfiles, posnum, params.deform_angle, params.deform_scale, params.deform_shift, params.grayscale);
	z.x.positives = 0;
	ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
	z.negatives = _ccv_icf_collect_negatives(rng, z.size, z.margin, bgfiles, negnum, params.deform_angle, params.deform_scale, params.deform_shift, params.grayscale);
	z.x.negatives = 0;
	ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
	for (z.bootstrap = 0; z.bootstrap <= params.bootstrap; z.bootstrap++)
	{
		z.example_state = (ccv_icf_example_state_t*)ccmalloc(sizeof(ccv_icf_example_state_t) * (z.negatives->rnum + z.positives->rnum));
		memset(z.example_state, 0, sizeof(ccv_icf_example_state_t) * (z.negatives->rnum + z.positives->rnum));
		for (z.i = 0; z.i < z.positives->rnum + z.negatives->rnum; z.i++)
			z.example_state[z.i].weight = (z.i < z.positives->rnum) ? 0.5 / z.positives->rnum : 0.5 / z.negatives->rnum;
		z.x.example_state = 0;
		ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
		z.precomputed = _ccv_icf_precompute_features(z.features, params.feature_size, z.positives, z.negatives);
		z.x.precomputed = 0;
		ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
		for (z.i = 0; z.i < params.weak_classifier; z.i++)
		{
			z.classifier->count = z.i + 1;
			PRINT(CCV_CLI_INFO, " - boost weak classifier %d of %d\n", z.i + 1, params.weak_classifier);
			int j;
			ccv_icf_decision_tree_t weak_classifier;
			double rate = _ccv_icf_find_best_weak_classifier(z.features, params.feature_size, z.positives, z.negatives, z.precomputed, z.example_state, &weak_classifier);
			assert(rate > 0.5); // it has to be better than random chance
#ifdef USE_SANITY_ASSERTION
			double confirm_rate = _ccv_icf_rate_weak_classifier(&weak_classifier, z.positives, z.negatives, z.example_state);
#endif
			double alpha = sqrt((1 - rate) / rate);
			double beta = 1.0 / alpha;
			double c = log(rate / (1 - rate));
			weak_classifier.weigh[0] = -c;
			weak_classifier.weigh[1] = c;
			weak_classifier.threshold = 0;
			double reweigh = 0;
			for (j = 0; j < z.positives->rnum + z.negatives->rnum; j++)
			{
				z.example_state[j].weight *= (z.example_state[j].correct) ? alpha : beta;
				z.example_state[j].rate += weak_classifier.weigh[!((j < z.positives->rnum) ^ z.example_state[j].correct)];
				reweigh += z.example_state[j].weight;
			}
			reweigh = 1.0 / reweigh;
#ifdef USE_SANITY_ASSERTION
			PRINT(CCV_CLI_INFO, " - on all examples, best feature at rate %lf, confirm rate %lf\n", rate, confirm_rate);
#else
			PRINT(CCV_CLI_INFO, " - on all examples, best feature at rate %lf\n", rate);
#endif
			// balancing the weight to sum 1.0
			for (j = 0; j < z.positives->rnum + z.negatives->rnum; j++)
				z.example_state[j].weight *= reweigh;
			z.classifier->weak_classifiers[z.i] = weak_classifier;
			// compute the threshold at given acceptance
			float threshold = z.example_state[0].rate;
			for (j = 1; j < z.positives->rnum; j++)
				if (z.example_state[j].rate < threshold)
					threshold = z.example_state[j].rate;
			int true_positives = 0, false_positives = 0;
			for (j = 0; j < z.positives->rnum; j++)
				if (z.example_state[j].rate >= threshold)
					++true_positives;
			for (j = z.positives->rnum; j < z.positives->rnum + z.negatives->rnum; j++)
				if (z.example_state[j].rate >= threshold)
					++false_positives;
			PRINT(CCV_CLI_INFO, " - at threshold %f, true positive rate: %f%%, false positive rate: %f%% (%d)\n", threshold, (float)true_positives * 100 / z.positives->rnum, (float)false_positives * 100 / z.negatives->rnum, false_positives);
			PRINT(CCV_CLI_INFO, " - first feature :\n");
			for (j = 0; j < weak_classifier.features[0].count; j++)
				PRINT(CCV_CLI_INFO, " - %d - (%d, %d) - (%d, %d)\n", weak_classifier.features[0].channel[j], weak_classifier.features[0].sat[j * 2].x, weak_classifier.features[0].sat[j * 2].y, weak_classifier.features[0].sat[j * 2 + 1].x, weak_classifier.features[0].sat[j * 2 + 1].y);
			if (weak_classifier.pass & 0x2)
			{
				PRINT(CCV_CLI_INFO, " - second feature, on left :\n");
				for (j = 0; j < weak_classifier.features[1].count; j++)
					PRINT(CCV_CLI_INFO, " - | - %d - (%d, %d) - (%d, %d)\n", weak_classifier.features[1].channel[j], weak_classifier.features[1].sat[j * 2].x, weak_classifier.features[1].sat[j * 2].y, weak_classifier.features[1].sat[j * 2 + 1].x, weak_classifier.features[1].sat[j * 2 + 1].y);
			}
			if (weak_classifier.pass & 0x1)
			{
				PRINT(CCV_CLI_INFO, " - second feature, on right :\n");
				for (j = 0; j < weak_classifier.features[2].count; j++)
					PRINT(CCV_CLI_INFO, " - | - %d - (%d, %d) - (%d, %d)\n", weak_classifier.features[2].channel[j], weak_classifier.features[2].sat[j * 2].x, weak_classifier.features[2].sat[j * 2].y, weak_classifier.features[2].sat[j * 2 + 1].x, weak_classifier.features[2].sat[j * 2 + 1].y);
			}
			z.classifier->count = z.i + 1; // update count
			z.classifier->size = ccv_size(z.size.width + z.margin.left + z.margin.right, z.size.height + z.margin.top + z.margin.bottom);
			z.classifier->margin = z.margin;
			if (z.i + 1 < params.weak_classifier)
			{
				z.x.example_state = 0;
				z.x.classifier = 0;
				ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
			}
		}
		if (z.bootstrap < params.bootstrap) // collecting negatives, again
		{
			// free expensive memory
			ccfree(z.example_state);
			z.example_state = 0;
			ccfree(z.precomputed);
			z.precomputed = 0;
			_ccv_icf_classifier_cascade_soft_with_validates(z.positives, z.classifier, 1); // assuming perfect score, what's the soft cascading will be
			int exists = z.negatives->rnum;
			int spread_policy = z.bootstrap < 2; // we don't spread bootstrapping anymore after the first two bootstrappings
			// try to boostrap half negatives from perfect scoring
			_ccv_icf_bootstrap_negatives(z.classifier, z.negatives, rng, bgfiles, (negnum + 1) / 2, params.grayscale, spread_policy, params.detector);
			int leftover = negnum - (z.negatives->rnum - exists);
			if (leftover > 0)
			{
				// if we cannot get enough negative examples, now will use the validates data set to extract more
				ccv_array_t* validates = _ccv_icf_collect_validates(rng, z.size, z.margin, validatefiles, params.grayscale);
				_ccv_icf_classifier_cascade_soft_with_validates(validates, z.classifier, params.acceptance);
				ccv_array_free(validates);
				_ccv_icf_bootstrap_negatives(z.classifier, z.negatives, rng, bgfiles, leftover, params.grayscale, spread_policy, params.detector);
			}
			PRINT(CCV_CLI_INFO, " - after %d bootstrapping, learn with %d positives and %d negatives\n", z.bootstrap + 1, z.positives->rnum, z.negatives->rnum);
			z.classifier->count = 0; // reset everything
			z.x.negatives = 0;
		} else {
			z.x.example_state = 0;
			z.x.classifier = 0;
			ccv_function_state_resume(_ccv_icf_write_classifier_cascade_state, z, dir);
		}
	}
	if (z.precomputed)
		ccfree(z.precomputed);
	if (z.example_state)
		ccfree(z.example_state);
	ccfree(z.features);
	ccv_array_free(z.positives);
	ccv_array_free(z.negatives);
	gsl_rng_free(rng);
	ccv_function_state_finish();
	return z.classifier;
#else
	assert(0 && "ccv_icf_classifier_cascade_new requires GSL library support");
	return 0;
#endif
}

void ccv_icf_classifier_cascade_soft(ccv_icf_classifier_cascade_t* cascade, ccv_array_t* posfiles, double acceptance)
{
#ifdef HAVE_GSL
	PRINT(CCV_CLI_INFO, "with %d positive examples\n"
						"going to accept %.2lf%% positive examples\n",
		   posfiles->rnum, acceptance * 100);
	ccv_size_t size = ccv_size(cascade->size.width - cascade->margin.left - cascade->margin.right, cascade->size.height - cascade->margin.top - cascade->margin.bottom);
	PRINT(CCV_CLI_INFO, "use color? %s\n", cascade->grayscale ? "no" : "yes");
	PRINT(CCV_CLI_INFO, "compute soft cascading thresholds for ICF classifier cascade at size %dx%d with margin (%d,%d,%d,%d)\n"
						"------------------------\n",
		   size.width, size.height, cascade->margin.left, cascade->margin.top, cascade->margin.right, cascade->margin.bottom);
	gsl_rng_env_setup();
	gsl_rng* rng = gsl_rng_alloc(gsl_rng_default);
	/* collect positives */
	double weigh[2] = {
		0, 0
	};
	int i;
	for (i = 0; i < cascade->count; i++)
	{
		ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + i;
		weigh[0] += weak_classifier->weigh[0];
		weigh[1] += weak_classifier->weigh[1];
	}
	weigh[0] = 1 / fabs(weigh[0]), weigh[1] = 1 / fabs(weigh[1]);
	for (i = 0; i < cascade->count; i++)
	{
		ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + i;
		weak_classifier->weigh[0] = weak_classifier->weigh[0] * weigh[0];
		weak_classifier->weigh[1] = weak_classifier->weigh[1] * weigh[1];
	}
	ccv_array_t* validates = _ccv_icf_collect_validates(rng, size, cascade->margin, posfiles, cascade->grayscale);
	/* compute soft cascading thresholds */
	_ccv_icf_classifier_cascade_soft_with_validates(validates, cascade, acceptance);
	ccv_array_free(validates);
	gsl_rng_free(rng);
#else
	assert(0 && "ccv_icf_classifier_cascade_soft requires GSL library support");
#endif
}

static void _ccv_icf_read_classifier_cascade_with_fd(FILE* r, ccv_icf_classifier_cascade_t* cascade)
{
	cascade->type = CCV_ICF_CLASSIFIER_TYPE_A;
	fscanf(r, "%d %d %d %d", &cascade->count, &cascade->size.width, &cascade->size.height, &cascade->grayscale);
	fscanf(r, "%d %d %d %d", &cascade->margin.left, &cascade->margin.top, &cascade->margin.right, &cascade->margin.bottom);
	cascade->weak_classifiers = (ccv_icf_decision_tree_t*)ccmalloc(sizeof(ccv_icf_decision_tree_t) * cascade->count);
	int i, q;
	for (i = 0; i < cascade->count; i++)
	{
		ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + i;
		fscanf(r, "%u %a %a %a", &weak_classifier->pass, &weak_classifier->weigh[0], &weak_classifier->weigh[1], &weak_classifier->threshold);
		fscanf(r, "%d %a", &weak_classifier->features[0].count, &weak_classifier->features[0].beta);
		for (q = 0; q < weak_classifier->features[0].count; q++)
			fscanf(r, "%d %a %d %d %d %d", &weak_classifier->features[0].channel[q], &weak_classifier->features[0].alpha[q], &weak_classifier->features[0].sat[q * 2].x, &weak_classifier->features[0].sat[q * 2].y, &weak_classifier->features[0].sat[q * 2 + 1].x, &weak_classifier->features[0].sat[q * 2 + 1].y);
		if (weak_classifier->pass & 0x2)
		{
			fscanf(r, "%d %a", &weak_classifier->features[1].count, &weak_classifier->features[1].beta);
			for (q = 0; q < weak_classifier->features[1].count; q++)
				fscanf(r, "%d %a %d %d %d %d", &weak_classifier->features[1].channel[q], &weak_classifier->features[1].alpha[q], &weak_classifier->features[1].sat[q * 2].x, &weak_classifier->features[1].sat[q * 2].y, &weak_classifier->features[1].sat[q * 2 + 1].x, &weak_classifier->features[1].sat[q * 2 + 1].y);
		}
		if (weak_classifier->pass & 0x1)
		{
			fscanf(r, "%d %a", &weak_classifier->features[2].count, &weak_classifier->features[2].beta);
			for (q = 0; q < weak_classifier->features[2].count; q++)
				fscanf(r, "%d %a %d %d %d %d", &weak_classifier->features[2].channel[q], &weak_classifier->features[2].alpha[q], &weak_classifier->features[2].sat[q * 2].x, &weak_classifier->features[2].sat[q * 2].y, &weak_classifier->features[2].sat[q * 2 + 1].x, &weak_classifier->features[2].sat[q * 2 + 1].y);
		}
	}
}

static void _ccv_icf_write_classifier_cascade_with_fd(ccv_icf_classifier_cascade_t* cascade, FILE* w)
{
	int i, q;
	fprintf(w, "%d %d %d %d\n", cascade->count, cascade->size.width, cascade->size.height, cascade->grayscale);
	fprintf(w, "%d %d %d %d\n", cascade->margin.left, cascade->margin.top, cascade->margin.right, cascade->margin.bottom);
	for (i = 0; i < cascade->count; i++)
	{
		ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + i;
		fprintf(w, "%u %a %a %a\n", weak_classifier->pass, weak_classifier->weigh[0], weak_classifier->weigh[1], weak_classifier->threshold);
		fprintf(w, "%d %a\n", weak_classifier->features[0].count, weak_classifier->features[0].beta);
		for (q = 0; q < weak_classifier->features[0].count; q++)
			fprintf(w, "%d %a\n%d %d %d %d\n", weak_classifier->features[0].channel[q], weak_classifier->features[0].alpha[q], weak_classifier->features[0].sat[q * 2].x, weak_classifier->features[0].sat[q * 2].y, weak_classifier->features[0].sat[q * 2 + 1].x, weak_classifier->features[0].sat[q * 2 + 1].y);
		if (weak_classifier->pass & 0x2)
		{
			fprintf(w, "%d %a\n", weak_classifier->features[1].count, weak_classifier->features[1].beta);
			for (q = 0; q < weak_classifier->features[1].count; q++)
				fprintf(w, "%d %a\n%d %d %d %d\n", weak_classifier->features[1].channel[q], weak_classifier->features[1].alpha[q], weak_classifier->features[1].sat[q * 2].x, weak_classifier->features[1].sat[q * 2].y, weak_classifier->features[1].sat[q * 2 + 1].x, weak_classifier->features[1].sat[q * 2 + 1].y);
		}
		if (weak_classifier->pass & 0x1)
		{
			fprintf(w, "%d %a\n", weak_classifier->features[2].count, weak_classifier->features[2].beta);
			for (q = 0; q < weak_classifier->features[2].count; q++)
				fprintf(w, "%d %a\n%d %d %d %d\n", weak_classifier->features[2].channel[q], weak_classifier->features[2].alpha[q], weak_classifier->features[2].sat[q * 2].x, weak_classifier->features[2].sat[q * 2].y, weak_classifier->features[2].sat[q * 2 + 1].x, weak_classifier->features[2].sat[q * 2 + 1].y);
		}
	}
}

ccv_icf_classifier_cascade_t* ccv_icf_read_classifier_cascade(const char* filename)
{
	FILE* r = fopen(filename, "r");
	ccv_icf_classifier_cascade_t* cascade = 0;
	if (r)
	{
		cascade = (ccv_icf_classifier_cascade_t*)ccmalloc(sizeof(ccv_icf_classifier_cascade_t));
		_ccv_icf_read_classifier_cascade_with_fd(r, cascade);
		fclose(r);
	}
	return cascade;
}

void ccv_icf_write_classifier_cascade(ccv_icf_classifier_cascade_t* cascade, const char* filename)
{
	FILE* w = fopen(filename, "w+");
	if (w)
	{
		_ccv_icf_write_classifier_cascade_with_fd(cascade, w);
		fclose(w);
	}
}

void ccv_icf_classifier_cascade_free(ccv_icf_classifier_cascade_t* classifier)
{
	ccfree(classifier->weak_classifiers);
	ccfree(classifier);
}

ccv_icf_multiscale_classifier_cascade_t* ccv_icf_read_multiscale_classifier_cascade(const char* directory)
{
	char filename[1024];
	snprintf(filename, 1024, "%s/multiscale", directory);
	FILE* r = fopen(filename, "r");
	if (r)
	{
		int octave = 0, count = 0, grayscale = 0;
		fscanf(r, "%d %d %d", &octave, &count, &grayscale);
		fclose(r);
		ccv_icf_multiscale_classifier_cascade_t* classifier = (ccv_icf_multiscale_classifier_cascade_t*)ccmalloc(sizeof(ccv_icf_multiscale_classifier_cascade_t) + sizeof(ccv_icf_classifier_cascade_t) * count);
		classifier->type = CCV_ICF_CLASSIFIER_TYPE_B;
		classifier->octave = octave;
		classifier->count = count;
		classifier->grayscale = grayscale;
		classifier->cascade = (ccv_icf_classifier_cascade_t*)(classifier + 1);
		int i;
		for (i = 0; i < count; i++)
		{
			snprintf(filename, 1024, "%s/cascade-%d", directory, i + 1);
			r = fopen(filename, "r");
			if (r)
			{
				ccv_icf_classifier_cascade_t* cascade = classifier->cascade + i;
				_ccv_icf_read_classifier_cascade_with_fd(r, cascade);
				fclose(r);
			}
		}
		return classifier;
	}
	return 0;
}

void ccv_icf_write_multiscale_classifier_cascade(ccv_icf_multiscale_classifier_cascade_t* classifier, const char* directory)
{
	char filename[1024];
	snprintf(filename, 1024, "%s/multiscale", directory);
	FILE* w = fopen(filename, "w+");
	fprintf(w, "%d %d %d\n", classifier->octave, classifier->count, classifier->grayscale);
	fclose(w);
	int i;
	for (i = 0; i < classifier->count; i++)
	{
		snprintf(filename, 1024, "%s/cascade-%d", directory, i + 1);
		w = fopen(filename, "w+");
		_ccv_icf_write_classifier_cascade_with_fd(classifier->cascade + i, w);
		fclose(w);
	}
}

void ccv_icf_multiscale_classifier_cascade_free(ccv_icf_multiscale_classifier_cascade_t* classifier)
{
	int i;
	for (i = 0; i < classifier->count; i++)
		ccfree(classifier->cascade[i].weak_classifiers);
	ccfree(classifier);
}

static int _ccv_is_equal_same_class(const void* _r1, const void* _r2, void* data)
{
	const ccv_comp_t* r1 = (const ccv_comp_t*)_r1;
	const ccv_comp_t* r2 = (const ccv_comp_t*)_r2;
	int distance = (int)(ccv_min(r1->rect.width, r1->rect.height) * 0.25 + 0.5);

	return r2->classification.id == r1->classification.id &&
		r2->rect.x <= r1->rect.x + distance &&
		r2->rect.x >= r1->rect.x - distance &&
		r2->rect.y <= r1->rect.y + distance &&
		r2->rect.y >= r1->rect.y - distance &&
		r2->rect.width <= (int)(r1->rect.width * 1.5 + 0.5) &&
		(int)(r2->rect.width * 1.5 + 0.5) >= r1->rect.width &&
		r2->rect.height <= (int)(r1->rect.height * 1.5 + 0.5) &&
		(int)(r2->rect.height * 1.5 + 0.5) >= r1->rect.height;
}

static void _ccv_icf_detect_objects_with_classifier_cascade(ccv_dense_matrix_t* a, ccv_icf_classifier_cascade_t** cascades, int count, ccv_icf_param_t params, ccv_array_t* seq[])
{
	int i, j, k, q, x, y;
	int scale_upto = 1;
	for (i = 0; i < count; i++)
		scale_upto = ccv_max(scale_upto, (int)(log(ccv_min((double)a->rows / (cascades[i]->size.height - cascades[i]->margin.top - cascades[i]->margin.bottom), (double)a->cols / (cascades[i]->size.width - cascades[i]->margin.left - cascades[i]->margin.right))) / log(2.) - DBL_MIN) + 1);
	ccv_dense_matrix_t** pyr = (ccv_dense_matrix_t**)alloca(sizeof(ccv_dense_matrix_t*) * scale_upto);
	pyr[0] = a;
	for (i = 1; i < scale_upto; i++)
	{
		pyr[i] = 0;
		ccv_sample_down(pyr[i - 1], &pyr[i], 0, 0, 0);
	}
	for (i = 0; i < scale_upto; i++)
	{
		// run it
		for (j = 0; j < count; j++)
		{
			double scale_ratio = pow(2., 1. / (params.interval + 1));
			double scale = 1;
			ccv_icf_classifier_cascade_t* cascade = cascades[j];
			for (k = 0; k <= params.interval; k++)
			{
				int rows = (int)(pyr[i]->rows / scale + 0.5);
				int cols = (int)(pyr[i]->cols / scale + 0.5);
				if (rows < cascade->size.height || cols < cascade->size.width)
					break;
				ccv_dense_matrix_t* image = k == 0 ? pyr[i] : 0;
				if (k > 0)
					ccv_resample(pyr[i], &image, 0, rows, cols, CCV_INTER_AREA);
				ccv_dense_matrix_t* bordered = 0;
				ccv_border(image, (ccv_matrix_t**)&bordered, 0, cascade->margin);
				if (k > 0)
					ccv_matrix_free(image);
				rows = bordered->rows;
				cols = bordered->cols;
				ccv_dense_matrix_t* icf = 0;
				ccv_icf(bordered, &icf, 0);
				ccv_matrix_free(bordered);
				ccv_dense_matrix_t* sat = 0;
				ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
				ccv_matrix_free(icf);
				int ch = CCV_GET_CHANNEL(sat->type);
				float* ptr = sat->data.f32;
				for (y = 0; y < rows; y += params.step_through)
				{
					if (y >= sat->rows - cascade->size.height - 1)
						break;
					for (x = 0; x < cols; x += params.step_through)
					{
						if (x >= sat->cols - cascade->size.width - 1)
							break;
						int pass = 1;
						float sum = 0;
						for (q = 0; q < cascade->count; q++)
						{
							ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + q;
							int c = _ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, x, 0);
							sum += weak_classifier->weigh[c];
							if (sum < weak_classifier->threshold)
							{
								pass = 0;
								break;
							}
						}
						if (pass)
						{
							ccv_comp_t comp;
							comp.rect = ccv_rect((int)((x + 0.5) * scale * (1 << i) - 0.5), (int)((y + 0.5) * scale * (1 << i) - 0.5), (cascade->size.width - cascade->margin.left - cascade->margin.right) * scale * (1 << i), (cascade->size.height - cascade->margin.top - cascade->margin.bottom) * scale * (1 << i));
							comp.neighbors = 1;
							comp.classification.id = j + 1;
							comp.classification.confidence = sum;
							ccv_array_push(seq[j], &comp);
						}
					}
					ptr += sat->cols * ch * params.step_through;
				}
				ccv_matrix_free(sat);
				scale *= scale_ratio;
			}
		}
	}

	for (i = 1; i < scale_upto; i++)
		ccv_matrix_free(pyr[i]);
}

static void _ccv_icf_detect_objects_with_multiscale_classifier_cascade(ccv_dense_matrix_t* a, ccv_icf_multiscale_classifier_cascade_t** multiscale_cascade, int count, ccv_icf_param_t params, ccv_array_t* seq[])
{
	int i, j, k, q, x, y, ix, iy, py;
	assert(multiscale_cascade[0]->count % multiscale_cascade[0]->octave == 0);
	ccv_margin_t margin = multiscale_cascade[0]->cascade[multiscale_cascade[0]->count - 1].margin;
	for (i = 1; i < count; i++)
	{
		assert(multiscale_cascade[i]->count % multiscale_cascade[i]->octave == 0);
		assert(multiscale_cascade[i - 1]->grayscale == multiscale_cascade[i]->grayscale);
		assert(multiscale_cascade[i - 1]->count == multiscale_cascade[i]->count);
		assert(multiscale_cascade[i - 1]->octave == multiscale_cascade[i]->octave);
		ccv_icf_classifier_cascade_t* cascade = multiscale_cascade[i]->cascade + multiscale_cascade[i]->count - 1;
		margin.top = ccv_max(margin.top, cascade->margin.top);
		margin.right = ccv_max(margin.right, cascade->margin.right);
		margin.bottom = ccv_max(margin.bottom, cascade->margin.bottom);
		margin.left = ccv_max(margin.left, cascade->margin.left);
	}
	int scale_upto = 1;
	for (i = 0; i < count; i++)
		scale_upto = ccv_max(scale_upto, (int)(log(ccv_min((double)a->rows / (multiscale_cascade[i]->cascade[0].size.height - multiscale_cascade[i]->cascade[0].margin.top - multiscale_cascade[i]->cascade[0].margin.bottom), (double)a->cols / (multiscale_cascade[i]->cascade[0].size.width - multiscale_cascade[i]->cascade[0].margin.left - multiscale_cascade[i]->cascade[0].margin.right))) / log(2.) - DBL_MIN) + 2 - multiscale_cascade[i]->octave);
	ccv_dense_matrix_t** pyr = (ccv_dense_matrix_t**)alloca(sizeof(ccv_dense_matrix_t*) * scale_upto);
	pyr[0] = a;
	for (i = 1; i < scale_upto; i++)
	{
		pyr[i] = 0;
		ccv_sample_down(pyr[i - 1], &pyr[i], 0, 0, 0);
	}
	for (i = 0; i < scale_upto; i++)
	{
		ccv_dense_matrix_t* bordered = 0;
		ccv_border(pyr[i], (ccv_matrix_t**)&bordered, 0, margin);
		ccv_dense_matrix_t* icf = 0;
		ccv_icf(bordered, &icf, 0);
		ccv_matrix_free(bordered);
		ccv_dense_matrix_t* sat = 0;
		ccv_sat(icf, &sat, 0, CCV_PADDING_ZERO);
		ccv_matrix_free(icf);
		int ch = CCV_GET_CHANNEL(sat->type);
		assert(CCV_GET_DATA_TYPE(sat->type) == CCV_32F);
		// run it
		for (j = 0; j < count; j++)
		{
			double scale_ratio = pow(2., (double)multiscale_cascade[j]->octave / multiscale_cascade[j]->count);
			int starter = i > 0 ? multiscale_cascade[j]->count - (multiscale_cascade[j]->count / multiscale_cascade[j]->octave) : 0;
			double scale = pow(scale_ratio, starter);
			for (k = starter; k < multiscale_cascade[j]->count; k++)
			{
				ccv_icf_classifier_cascade_t* cascade = multiscale_cascade[j]->cascade + k;
				int rows = (int)(pyr[i]->rows / scale + cascade->margin.top + 0.5);
				int cols = (int)(pyr[i]->cols / scale + cascade->margin.left + 0.5);
				int top = margin.top - cascade->margin.top;
				int right = margin.right - cascade->margin.right;
				int bottom = margin.bottom - cascade->margin.bottom;
				int left = margin.left - cascade->margin.left;
				if (sat->rows - top - bottom <= cascade->size.height || sat->cols - left - right <= cascade->size.width)
					break;
				float* ptr = sat->data.f32 + top * sat->cols * ch;
				for (y = 0, iy = py = top; y < rows; y += params.step_through)
				{
					iy = (int)((y + 0.5) * scale + top);
					if (iy >= sat->rows - cascade->size.height - 1)
						break;
					if (iy > py)
					{
						ptr += sat->cols * ch * (iy - py);
						py = iy;
					}
					for (x = 0; x < cols; x += params.step_through)
					{
						ix = (int)((x + 0.5) * scale + left);
						if (ix >= sat->cols - cascade->size.width - 1)
							break;
						int pass = 1;
						float sum = 0;
						for (q = 0; q < cascade->count; q++)
						{
							ccv_icf_decision_tree_t* weak_classifier = cascade->weak_classifiers + q;
							int c = _ccv_icf_run_weak_classifier(weak_classifier, ptr, sat->cols, ch, ix, 0);
							sum += weak_classifier->weigh[c];
							if (sum < weak_classifier->threshold)
							{
								pass = 0;
								break;
							}
						}
						if (pass)
						{
							ccv_comp_t comp;
							comp.rect = ccv_rect((int)((x + 0.5) * scale * (1 << i)), (int)((y + 0.5) * scale * (1 << i)), (cascade->size.width - cascade->margin.left - cascade->margin.right) << i, (cascade->size.height - cascade->margin.top - cascade->margin.bottom) << i);
							comp.neighbors = 1;
							comp.classification.id = j + 1;
							comp.classification.confidence = sum;
							ccv_array_push(seq[j], &comp);
						}
					}
				}
				scale *= scale_ratio;
			}
		}
		ccv_matrix_free(sat);
	}

	for (i = 1; i < scale_upto; i++)
		ccv_matrix_free(pyr[i]);
}

ccv_array_t* ccv_icf_detect_objects(ccv_dense_matrix_t* a, void* cascade, int count, ccv_icf_param_t params)
{
	assert(count > 0);
	int i, j, k;
	int type = *(((int**)cascade)[0]);
	for (i = 1; i < count; i++)
	{
		// check all types to be the same
		assert(*(((int**)cascade)[i]) == type);
	}
	ccv_array_t** seq = (ccv_array_t**)alloca(sizeof(ccv_array_t*) * count);
	for (i = 0; i < count; i++)
		seq[i] = ccv_array_new(sizeof(ccv_comp_t), 64, 0);
	switch (type)
	{
		case CCV_ICF_CLASSIFIER_TYPE_A:
			_ccv_icf_detect_objects_with_classifier_cascade(a, (ccv_icf_classifier_cascade_t**)cascade, count, params, seq);
			break;
		case CCV_ICF_CLASSIFIER_TYPE_B:
			_ccv_icf_detect_objects_with_multiscale_classifier_cascade(a, (ccv_icf_multiscale_classifier_cascade_t**)cascade, count, params, seq);
			break;
	}
	ccv_array_t* result_seq = ccv_array_new(sizeof(ccv_comp_t), 64, 0);
	ccv_array_t* seq2 = ccv_array_new(sizeof(ccv_comp_t), 64, 0);
	for (k = 0; k < count; k++)
	{
		/* the following code from OpenCV's haar feature implementation */
		if(params.min_neighbors == 0)
		{
			for (i = 0; i < seq[k]->rnum; i++)
			{
				ccv_comp_t* comp = (ccv_comp_t*)ccv_array_get(seq[k], i);
				ccv_array_push(result_seq, comp);
			}
		} else {
			ccv_array_t* idx_seq = 0;
			ccv_array_clear(seq2);
			// group retrieved rectangles in order to filter out noise
			int ncomp = ccv_array_group(seq[k], &idx_seq, _ccv_is_equal_same_class, 0);
			ccv_comp_t* comps = (ccv_comp_t*)cccalloc(ncomp + 1, sizeof(ccv_comp_t));

			// count number of neighbors
			for (i = 0; i < seq[k]->rnum; i++)
			{
				ccv_comp_t r1 = *(ccv_comp_t*)ccv_array_get(seq[k], i);
				int idx = *(int*)ccv_array_get(idx_seq, i);

				comps[idx].classification.id = r1.classification.id;
				if (r1.classification.confidence > comps[idx].classification.confidence || comps[idx].neighbors == 0)
				{
					comps[idx].rect = r1.rect;
					comps[idx].classification.confidence = r1.classification.confidence;
				}

				++comps[idx].neighbors;
			}

			// calculate average bounding box
			for (i = 0; i < ncomp; i++)
			{
				int n = comps[i].neighbors;
				if (n >= params.min_neighbors)
					ccv_array_push(seq2, comps + i);
			}

			// filter out large object rectangles contains small object rectangles
			for (i = 0; i < seq2->rnum; i++)
			{
				ccv_comp_t* r2 = (ccv_comp_t*)ccv_array_get(seq2, i);
				int distance = (int)(ccv_min(r2->rect.width, r2->rect.height) * 0.25 + 0.5);
				for (j = 0; j < seq2->rnum; j++)
				{
					ccv_comp_t r1 = *(ccv_comp_t*)ccv_array_get(seq2, j);
					if (i != j &&
						abs(r1.classification.id) == r2->classification.id &&
						r1.rect.x >= r2->rect.x - distance &&
						r1.rect.y >= r2->rect.y - distance &&
						r1.rect.x + r1.rect.width <= r2->rect.x + r2->rect.width + distance &&
						r1.rect.y + r1.rect.height <= r2->rect.y + r2->rect.height + distance &&
						// if r1 (the smaller one) is better, mute r2
						(r2->classification.confidence <= r1.classification.confidence && r2->neighbors < r1.neighbors))
					{
						r2->classification.id = -r2->classification.id;
						break;
					}
				}
			}

			// filter out small object rectangles inside large object rectangles
			for (i = 0; i < seq2->rnum; i++)
			{
				ccv_comp_t r1 = *(ccv_comp_t*)ccv_array_get(seq2, i);
				if (r1.classification.id > 0)
				{
					int flag = 1;

					for (j = 0; j < seq2->rnum; j++)
					{
						ccv_comp_t r2 = *(ccv_comp_t*)ccv_array_get(seq2, j);
						int distance = (int)(ccv_min(r2.rect.width, r2.rect.height) * 0.25 + 0.5);

						if (i != j &&
							abs(r1.classification.id) == abs(r2.classification.id) &&
							r1.rect.x >= r2.rect.x - distance &&
							r1.rect.y >= r2.rect.y - distance &&
							r1.rect.x + r1.rect.width <= r2.rect.x + r2.rect.width + distance &&
							r1.rect.y + r1.rect.height <= r2.rect.y + r2.rect.height + distance &&
							// if r2 is better, we mute r1
							(r2.classification.confidence > r1.classification.confidence || r2.neighbors >= r1.neighbors))
						{
							flag = 0;
							break;
						}
					}

					if (flag)
						ccv_array_push(result_seq, &r1);
				}
			}
			ccv_array_free(idx_seq);
			ccfree(comps);
		}
		ccv_array_free(seq[k]);
	}
	ccv_array_free(seq2);

	return result_seq;
}
