/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryArithmeticCommand;
import org.couchbase.mock.memcached.protocol.BinaryArithmeticResponse;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class ArithmeticCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) {
        long value;
        CommandCode cc;
        Item item;
        BinaryArithmeticCommand cmd;
        block10: {
            block12: {
                block11: {
                    cmd = (BinaryArithmeticCommand)command;
                    item = server.getDatastore().get(server, cmd.getVBucketId(), cmd.getKey());
                    cc = cmd.getComCode();
                    if (item != null) break block10;
                    if (!cmd.create()) break block11;
                    item = new Item(cmd.getKey(), 0, cmd.getExpiration(), Long.toString(cmd.getInitial()).getBytes(), 0L);
                    ErrorCode err = server.getDatastore().add(server, cmd.getVBucketId(), item);
                    switch (err) {
                        case KEY_EEXISTS: {
                            this.execute(command, server, client);
                            break;
                        }
                        case SUCCESS: {
                            if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                                client.sendResponse(new BinaryArithmeticResponse(cmd, cmd.getInitial(), item.getCas()));
                                break;
                            }
                            break block12;
                        }
                        default: {
                            client.sendResponse(new BinaryResponse(command, err));
                            break;
                        }
                    }
                    break block12;
                }
                client.sendResponse(new BinaryResponse(command, ErrorCode.KEY_ENOENT));
            }
            return;
        }
        try {
            value = Long.parseLong(new String(item.getValue()));
        }
        catch (NumberFormatException ex) {
            client.sendResponse(new BinaryResponse(command, ErrorCode.DELTA_BADVAL));
            return;
        }
        value = cc == CommandCode.INCREMENT || cc == CommandCode.INCREMENTQ ? (value += cmd.getDelta()) : (value -= cmd.getDelta());
        int exp = cmd.getExpiration() > 0 ? cmd.getExpiration() : item.getExptime();
        Item nval = new Item(cmd.getKey(), item.getFlags(), exp, Long.toString(value).getBytes(), item.getCas());
        ErrorCode err = server.getDatastore().set(server, cmd.getVBucketId(), nval);
        if (err == ErrorCode.SUCCESS) {
            if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                client.sendResponse(new BinaryArithmeticResponse(cmd, value, nval.getCas()));
            }
        } else {
            client.sendResponse(new BinaryResponse(command, err));
        }
    }
}

