######################################################################
#
# make_JIPSJ.pl
#
# Copyright (c) 2018, 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib $FindBin::Bin;

# JIPS(J)
require 'JIPS/JIPSJ_by_CP932.pl';
require 'Unicode/Unicode_by_CP932.pl';
require 'JIS/JIS78GL_by_JIS83GL.pl';
require 'JIS/JISX0208GL_by_SJIS.pl';
require 'JIS/JISX0208GL_by_CP932.pl';
require 'JIPS/NEC_CP932_by_Unicode.pl';
require 'JIPS/JIPSJ_by_Unicode_CultiCoLtd.pl';
require 'CP932/CP932_by_Unicode.pl';

if ($0 eq __FILE__) {
    open(DUMP,">$0.dump") || die;
    binmode(DUMP);
}

# generate array to check for duplicate keys
my @JIPSJ_by_Unicode_OVERRIDE = (

    # added and removed mapping
    # Jacode4e 2.13.6.18 or newer
    # Jacode4e::RoundTrip 2.13.81.12 or newer

    '2000B' => 'B2A3', # 𠀋
    '201A2' => 'B2BE', # 𠆢
    '2044A' => 'B3E7', # 𠑊
    '2099D' => 'BDBE', # 𠦝
    '20B9F' => 'B5C0', # 𠮟 (JIS2004)
    '21274' => 'B6D7', # 𡉴 (国土地理協会住所辞書文字)
    '212E4' => 'B6E4', # 𡋤
    '2131B' => 'D1B5', # 𡌛
    '21336' => 'B6F0', # 𡌶
    '21344' => 'B6EF', # 𡍄
    '21D9C' => 'B9A1', # 𡶜
    '21DA1' => 'B9A2', # 𡶡
    '21DB7' => 'B9AE', # 𡶷
    '21E34' => 'B9B2', # 𡸴
    '21F76' => 'B9D6', # 𡽶
    '22C24' => 'BCD1', # 𢰤
    '231C3' => 'B7D2', # 𣇃
    '231C4' => 'BDDF', # 𣇄
    '23594' => 'BFC7', # 𣖔
    '235C4' => 'BFC6', # 𣗄
    '23638' => 'BFE3', # 𣘸
    '2363A' => 'BFDC', # 𣘺
    '23C7F' => 'C0DA', # 𣱿
    '23CFE' => 'C1B1', # 𣳾
    '24D14' => 'C5BA', # 𤴔
    '259C4' => 'C7E9', # 𥧄
    '25BB2' => 'C8BE', # 𥮲
    '25C4B' => 'C8CE', # 𥱋
    '25DA1' => 'C8D6', # 𥶡
    '25F23' => 'C8F2', # 𥼣
    '25F5C' => 'C8F4', # 𥽜
    '26270' => 'C9E5', # 𦉰
    '2667E' => 'CAB6', # 𦙾
    '26951' => 'CAD4', # 𦥑
    '2770E' => 'CEAF', # 𧜎
    '27FB7' => 'CFCD', # 𧾷
    '28455' => 'CFF8', # 𨑕
    '28A99' => 'D2D7', # 𨪙
    '28ACD' => 'D2D6', # 𨫍
    '28FF8' => 'D5C6', # 𨿸
    '2967F' => 'D4B0', # 𩙿
    '29E3D' => 'D5A7', # 𩸽
    '29E8A' => 'D5B2', # 𩺊
    '2A02F' => 'D5CB', # 𪀯
    '3402' => 'B2A8', # 㐂
    '342E' => 'CEA2', # 㐮
    '346A' => 'B3A9', # 㑪
    '34B5' => 'B3F3', # 㒵
    '34C1' => 'C9E2', # 㓁
    '34C7' => 'B3FC', # 㓇
    '34DB' => 'B4AF', # 㓛
    '351F' => 'B4D2', # 㔟
    '355D' => 'B5B9', # 㕝
    '3699' => 'B7C9', # 㚙
    '378D' => 'B8E6', # 㞍
    '37C1' => 'B8FC', # 㟁
    '37E2' => 'B9B7', # 㟢 (国土地理協会住所辞書文字)
    '37FD' => 'B9C8', # 㟽
    '3800' => 'B9C3', # 㠀
    '382F' => 'B2C1', # 㠯
    '38FA' => 'BAEF', # 㣺
    '3917' => 'BBA7', # 㤗
    '3AD6' => 'BDB0', # 㫖
    '3AEA' => 'BDCB', # 㫪
    '3B1A' => 'BEAD', # 㬚
    '3B1C' => 'BEA6', # 㬜
    '3B22' => 'BEAF', # 㬢
    '3B88' => 'BFB4', # 㮈
    '3C0F' => 'C0AD', # 㰏
    '3CC3' => 'C0EE', # 㳃
    '3D1E' => 'C1EC', # 㴞
    '3DC0' => 'C3AB', # 㷀
    '3DD4' => 'C3BF', # 㷔
    '4093' => 'C6A9', # 䂓
    '4105' => 'C6F9', # 䄅
    '4148' => 'C7C3', # 䅈
    '41B4' => 'C7ED', # 䆴
    '41EE' => 'C8AC', # 䇮
    '420E' => 'C8C3', # 䈎
    '4264' => 'C8D5', # 䉤
    '42C6' => 'C9A1', # 䋆
    '432B' => 'C9DA', # 䌫
    '43EE' => 'CAB9', # 䏮
    '4453' => 'B5F5', # 䑓
    '445B' => 'CAD8', # 䑛
    '447A' => 'CAE2', # 䑺
    '44B3' => 'CBCD', # 䒳
    '44D4' => 'CBDF', # 䓔
    '4508' => 'CCC8', # 䔈
    '4525' => 'CCD3', # 䔥
    '4543' => 'CCE2', # 䕃
    '4665' => 'CEB2', # 䙥
    '484E' => 'CFE2', # 䡎
    '4BC2' => 'D4D9', # 䯂
    '4BE8' => 'D4DD', # 䯨
    '4C17' => 'D4E8', # 䰗
    '4E0F' => 'B2A4', # 丏
    '4E2C' => 'C3DD', # 丬
    '4EBB' => 'B2BD', # 亻
    '4F03' => 'B2CE', # 伃 (国土地理協会住所辞書文字)
    '4F0B' => 'B2C6', # 伋 (国土地理協会住所辞書文字)
    '4F7D' => 'B2E4', # 佽
    '4FA0' => 'B2E2', # 侠 (JIS83)
    '4FE0' => '3622', # 俠 (JIS78)
    '4FE6' => 'B2F3', # 俦
    '4FF1' => '',     # 俱 (JIS2004)
    '5002' => 'B2FC', # 倂 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5010' => 'C3F2', # 倐
    '509C' => 'BAE4', # 傜
    '50D9' => 'B3D9', # 僙
    '5160' => 'B3EF', # 兠
    '517B' => 'C9F1', # 养
    '51C3' => 'B4A5', # 凃
    '5213' => 'B4B1', # 刓
    '5215' => 'B4B4', # 刕 (国土地理協会住所辞書文字)
    '525D' => '476D', # 剝 (JIS78)
    '5265' => 'B4BC', # 剥 (JIS2004) (JIS83)
    '52FB' => 'B4E7', # 勻
    '5367' => 'CACD', # 卧
    '537A' => 'B9DF', # 卺
    '537D' => 'B5A9', # 卽 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '541E' => '',     # 吞 (JIS2004)
    '5455' => 'B5C6', # 呕
    '5516' => 'D6A1', # 唖 (JIS83)
    '559D' => 'B5ED', # 喝 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5653' => 'B6AA', # 噓 (JIS2004) (JIS78)
    '565B' => 'D6AE', # 噛 (JIS83)
    '5699' => '337A', # 嚙 (JIS78)
    '56A2' => 'D6F2', # 嚢 (JIS83)
    '56F6' => 'B6C5', # 囶
    '5721' => 'B6CB', # 圡
    '57C7' => 'B6E6', # 埇 (国土地理協会住所辞書文字)
    '57DE' => 'B6EE', # 埞 (国土地理協会住所辞書文字)
    '57F6' => 'B6EA', # 埶
    '586B' => 'D6E6', # 填 (JIS83)
    '588A' => 'B7A1', # 墊
    '589D' => 'C6CA', # 墝
    '589E' => 'B7A8', # 增 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '58E0' => 'B7B5', # 壠
    '590D' => 'B7BB', # 复
    '595F' => 'B7D0', # 奟
    '597C' => 'B7D9', # 奼
    '59E3' => 'B7E8', # 姣
    '59F8' => '',     # 姸 (JIS2004)
    '5A84' => 'B7FC', # 媄
    '5AA2' => 'B7F9', # 媢
    '5AB5' => 'B8A3', # 媵
    '5ADA' => 'B8AA', # 嫚
    '5AF0' => 'B8A9', # 嫰
    '5BAC' => 'B8C3', # 宬
    '5BD6' => 'B8D1', # 寖
    '5BEC' => 'B8D4', # 寬 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5C23' => 'B8E4', # 尣
    '5C4F' => 'B8E7', # 屏 (JIS2004) (JIS83)
    '5C5B' => '5622', # 屛 (JIS78)
    '5C61' => 'B8E8', # 屡 (JIS83)
    '5C7C' => 'B8ED', # 屼
    '5CA7' => 'B8F6', # 岧
    '5CAD' => 'B8FA', # 岭
    '5CD0' => 'B9A6', # 峐
    '5D10' => 'B9AF', # 崐
    '5D20' => 'B9B3', # 崠
    '5D47' => 'B9BB', # 嵇
    '5D6D' => 'B9C0', # 嵭 (国土地理協会住所辞書文字)
    '5DB2' => 'D3C7', # 嶲
    '5DD1' => 'B9DB', # 巑
    '5DD7' => 'B9DC', # 巗
    '5DE2' => 'BEFA', # 巢 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5E77' => 'B9F9', # 幷 (JIS2004)
    '5EAC' => 'B5AF', # 庬
    '5EF9' => 'BAB5', # 廹
    '5EFD' => 'BAB6', # 廽
    '5F00' => 'B2B5', # 开
    '5F63' => 'BACE', # 彣
    '5FA4' => 'BAE7', # 徤
    '5FB5' => 'BAEB', # 徵 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5FB7' => 'BAEC', # 德 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '5FE2' => 'BAF8', # 忢
    '60BE' => 'BBBB', # 悾
    '60DD' => 'BBC0', # 惝
    '617C' => 'BBDF', # 慼
    '623E' => 'BCA2', # 戾 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '625A' => 'BCAA', # 扚 (国土地理協会住所辞書文字)
    '6285' => 'BCAB', # 抅
    '633C' => 'BCC1', # 挼
    '63B4' => 'D6E2', # 掴 (JIS83)
    '63BB' => 'D6D4', # 掻 (JIS83)
    '63EB' => 'BCCF', # 揫
    '63ED' => 'BCCB', # 揭 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6414' => '415F', # 搔 (JIS78)
    '64C4' => 'BCE3', # 擄
    '64CA' => 'BCDE', # 擊 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '64E4' => 'BCE7', # 擤
    '6505' => 'BCE9', # 攅 (JIS83)
    '6532' => 'BCED', # 攲
    '6585' => 'B8BA', # 斅
    '663A' => 'BDC5', # 昺
    '6648' => 'C5D4', # 晈
    '665A' => 'BDDA', # 晚 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6663' => 'BDD8', # 晣
    '66C6' => 'BEA7', # 曆 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '66EC' => 'BEB5', # 曬
    '66FB' => 'BDD0', # 曻
    '6719' => 'BDDB', # 朙
    '6748' => 'BEC4', # 杈
    '677B' => 'BECD', # 杻 (国土地理協会住所辞書文字)
    '6781' => 'BECA', # 极
    '67C0' => 'BEE8', # 柀 (国土地理協会住所辞書文字)
    '6849' => 'BEF3', # 桉
    '6875' => 'BFA8', # 桵
    '68A5' => 'BFA1', # 梥
    '6935' => 'BFC3', # 椵 (国土地理協会住所辞書文字)
    '6957' => 'BFBE', # 楗
    '6980' => 'BFC4', # 榀 (国土地理協会住所辞書文字)
    '6992' => 'BFD6', # 榒 (国土地理協会住所辞書文字)
    '69C0' => 'BFCB', # 槀
    '69E9' => 'BFDA', # 槩
    '69EA' => 'BFD9', # 槪 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '69F6' => 'BFDE', # 槶
    '6A6B' => 'BFE6', # 橫 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6A9E' => 'BFF3', # 檞 (国土地理協会住所辞書文字)
    '6AD4' => 'BFFD', # 櫔
    '6ADD' => 'C0A3', # 櫝
    '6B65' => 'C0C1', # 步 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6B77' => 'C0C4', # 歷 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6B7A' => 'C0C5', # 歺
    '6BBE' => 'C0CB', # 殾
    '6BCF' => 'C0CD', # 每 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6BD7' => 'C0CE', # 毗
    '6BEE' => 'BCC9', # 毮
    '6C3A' => 'C0D7', # 氺
    '6C6D' => 'C0E6', # 汭
    '6C74' => 'C0E9', # 汴
    '6C76' => 'C0E8', # 汶
    '6C84' => 'C0E3', # 沄
    '6C97' => 'C0F0', # 沗 (国土地理協会住所辞書文字)
    '6CFB' => 'C0F9', # 泻
    '6D34' => 'C1D2', # 洴
    '6D81' => 'C1C3', # 涁
    '6D89' => 'C1C0', # 涉 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6D8A' => 'C1B9', # 涊
    '6D9C' => 'D6EC', # 涜 (JIS83)
    '6DDA' => 'C1C9', # 淚 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6E1A' => 'C1E3', # 渚 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6E34' => 'C1E4', # 渴 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6E57' => 'C1EF', # 湗 (国土地理協会住所辞書文字)
    '6E8C' => 'C1ED', # 溌 (JIS83)
    '6E93' => 'C2A3', # 溓
    '6EAB' => 'C1FD', # 溫 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '6EBF' => 'C2A8', # 溿 (国土地理協会住所辞書文字)
    '6ED9' => 'B4F1', # 滙
    '6F25' => 'C2BA', # 漥
    '6F51' => '482E', # 潑 (JIS78)
    '6F5A' => 'C2D6', # 潚
    '6F8D' => 'C2C9', # 澍 (国土地理協会住所辞書文字)
    '6F98' => 'C2D7', # 澘
    '7028' => 'C2F1', # 瀨 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '7097' => 'B3EB', # 炗
    '710F' => 'C3A8', # 焏 (国土地理協会住所辞書文字)
    '7114' => 'D6A8', # 焔 (JIS83)
    '712E' => 'C3AD', # 焮
    '7130' => '316B', # 焰 (JIS78)
    '7168' => 'C3BE', # 煨
    '7196' => 'C3C5', # 熖
    '71B3' => 'C3CD', # 熳
    '7215' => 'B5BF', # 爕
    '722B' => 'C3D8', # 爫
    '7238' => 'C3DA', # 爸
    '7239' => 'C3DB', # 爹
    '7255' => 'C7EA', # 牕
    '72B0' => 'C3E9', # 犰
    '72BE' => 'C3EE', # 犾 (国土地理協会住所辞書文字)
    '72C0' => 'C3EC', # 狀 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '738A' => 'C4AB', # 玊
    '739F' => 'C4B1', # 玟
    '73A8' => 'C4B4', # 玨
    '7413' => 'C4CE', # 琓
    '7422' => 'C4C8', # 琢 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '74A3' => 'C4F8', # 璣
    '7501' => 'C5AC', # 甁 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '756C' => 'C5B5', # 畬
    '757E' => 'C5B8', # 畾 (国土地理協会住所辞書文字)
    '75E9' => 'D6D5', # 痩 (JIS2004) (JIS83)
    '7626' => '4169', # 瘦 (JIS78)
    '769B' => 'C5DB', # 皛
    '76A1' => 'C5DC', # 皡
    '76D4' => 'C5E8', # 盔
    '77A9' => 'C6A4', # 瞩
    '784F' => 'C6B3', # 硏 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '792E' => 'C6D8', # 礮
    '7977' => 'C6FB', # 祷 (JIS83)
    '79CC' => 'C7B9', # 秌
    '7A5D' => 'C7D7', # 穝 (国土地理協会住所辞書文字)
    '7A60' => 'CEB1', # 穠
    '7A8A' => 'C7E3', # 窊
    '7AB3' => 'C7EB', # 窳
    '7ABB' => 'C7EC', # 窻
    '7B3B' => 'C8A7', # 笻
    '7B72' => 'C8B1', # 筲
    '7B7F' => 'C8B2', # 筿
    '7BAA' => 'D6DB', # 箪 (JIS83)
    '7BF0' => 'C8D1', # 篰
    '7C1E' => '433D', # 簞 (JIS78)
    '7CA0' => 'C8E5', # 粠 (国土地理協会住所辞書文字)
    '7CA6' => 'C3B0', # 粦
    '7CD9' => 'C8F1', # 糙 (国土地理協会住所辞書文字)
    '7D86' => 'C9AF', # 綆
    '7DA0' => 'C9B6', # 綠 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '7DD6' => 'C9BD', # 緖 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '7DE3' => 'C9BF', # 緣 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '7E4B' => 'D6B6', # 繋 (JIS2004) (JIS83)
    '7E4D' => 'C9D3', # 繍 (JIS83)
    '7E6B' => '3752', # 繫 (JIS78)
    '8002' => 'CAA3', # 耂
    '800E' => 'B7CC', # 耎
    '80F5' => 'CABB', # 胵
    '8204' => 'CAD5', # 舄
    '8249' => 'CAE0', # 艉
    '8257' => 'CAE3', # 艗
    '827F' => 'CAE8', # 艿
    '828E' => 'CAEE', # 芎 (国土地理協会住所辞書文字)
    '82A8' => 'CAF2', # 芨
    '82AE' => 'CAF6', # 芮
    '82C6' => 'CAFB', # 苆
    '8307' => 'CBAC', # 茇
    '8308' => 'CBAB', # 茈
    '831B' => 'CBC7', # 茛
    '831D' => 'CBCF', # 茝
    '8322' => 'CBC0', # 茢
    '832D' => 'CBB9', # 茭
    '8330' => 'CBC4', # 茰 (国土地理協会住所辞書文字)
    '8343' => 'CBBB', # 荃
    '8347' => 'CBB8', # 荇
    '8351' => 'CBBE', # 荑
    '8354' => 'CBBF', # 荔
    '8357' => 'CBC1', # 荗
    '8392' => 'CBD6', # 莒
    '8398' => 'CBD8', # 莘
    '839B' => 'CBE2', # 莛
    '839D' => 'CBD7', # 莝
    '83A9' => 'CBD9', # 莩
    '83B1' => 'CBE3', # 莱 (JIS83)
    '83E1' => 'CBE5', # 菡
    '8401' => 'CBE6', # 萁
    '840A' => '4D69', # 萊 (JIS78)
    '845A' => 'CCB7', # 葚 (国土地理協会住所辞書文字)
    '845F' => 'CCAC', # 葟
    '8473' => 'CCA3', # 葳
    '8478' => 'CCA4', # 葸
    '848B' => 'CCC7', # 蒋 (JIS83)
    '849E' => 'C2B1', # 蒞
    '84C0' => 'CCBC', # 蓀
    '84C2' => 'CCBD', # 蓂
    '84CF' => 'CCBE', # 蓏
    '84E7' => 'CCCF', # 蓧
    '851E' => 'CCDA', # 蔞
    '8534' => 'CCD7', # 蔴
    '8551' => 'CCDE', # 蕑
    '8564' => 'CCE1', # 蕤
    '8586' => 'CCF0', # 薆
    '859D' => 'CCF2', # 薝
    '85AD' => 'CDA1', # 薭 (国土地理協会住所辞書文字)
    '85B0' => 'CDA9', # 薰 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '8653' => 'CDC5', # 虓
    '865B' => 'CDC9', # 虛 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '8689' => 'CDCF', # 蚉
    '8749' => 'CDDC', # 蝉 (JIS83)
    '874B' => 'D7B3', # 蝋 (JIS83)
    '87EC' => '4066', # 蟬 (JIS78)
    '87F5' => 'CDE1', # 蟵
    '8806' => 'CDE4', # 蠆
    '880B' => 'CDE3', # 蠋 (国土地理協会住所辞書文字)
    '88D2' => 'CDFA', # 裒
    '8932' => 'C9BC', # 褲
    '8980' => 'CEB4', # 覀
    '8990' => 'CEB9', # 覐
    '89D4' => 'C8A1', # 觔
    '8B9C' => 'CFA2', # 讜
    '8C93' => 'C4A2', # 貓
    '8CF1' => 'CFBD', # 賱
    '8CF4' => 'CFBB', # 賴 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '8CF8' => 'CFC0', # 賸
    '8D1B' => 'CFC3', # 贛
    '8DAF' => 'CFCC', # 趯
    '8EAF' => 'CFDC', # 躯 (JIS83)
    '8EB6' => 'CEAB', # 躶
    '8EC0' => '366D', # 軀 (JIS78)
    '90DE' => 'D0EC', # 郞 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '9115' => 'D0F3', # 鄕 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '9146' => 'D0FC', # 酆
    '9197' => 'D1AC', # 醗 (JIS83)
    '91A4' => 'D6C8', # 醤 (JIS83)
    '91AC' => '3E5F', # 醬 (JIS78)
    '91B1' => '4830', # 醱 (JIS78)
    '9217' => 'D1CF', # 鈗
    '9242' => 'D1D8', # 鉂
    '92CC' => 'D1F2', # 鋌
    '92D3' => 'D1F4', # 鋓 (国土地理協会住所辞書文字)
    '9304' => 'D2AD', # 錄 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '934A' => 'D2BA', # 鍊 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '936B' => 'D2BC', # 鍫
    '938B' => 'D2CC', # 鎋
    '93BA' => 'D2D1', # 鎺 (国土地理協会住所辞書文字)
    '9472' => 'D2F9', # 鑲
    '958D' => 'D3A1', # 閍 (国土地理協会住所辞書文字)
    '95AC' => 'D3A3', # 閬
    '96EF' => 'D3CF', # 雯
    '9733' => 'D3D4', # 霳 (国土地理協会住所辞書文字)
    '973B' => 'D3D5', # 霻 (国土地理協会住所辞書文字)
    '974F' => 'D3DB', # 靏 (国土地理協会住所辞書文字)
    '979A' => 'D3E5', # 鞚
    '982C' => 'D3F7', # 頬 (JIS83)
    '9830' => '4B4B', # 頰 (JIS78)
    '9832' => 'D3F9', # 頲
    '983B' => 'D3FB', # 頻 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '985B' => 'D4A3', # 顛 (JIS83)
    '98C7' => 'D4AC', # 飇
    '98E0' => 'D4AE', # 飠
    '98E1' => 'D4B1', # 飡
    '9958' => 'D4BF', # 饘
    '9A24' => 'D4CF', # 騤
    '9A28' => 'D4D1', # 騨 (JIS83)
    '9A52' => '424D', # 驒 (JIS78)
    '9B2D' => 'D4E9', # 鬭
    '9B66' => 'D4F1', # 魦 (国土地理協会住所辞書文字)
    '9B75' => 'D4F0', # 魵 (国土地理協会住所辞書文字)
    '9BC1' => 'D5A2', # 鯁
    '9C00' => 'D5AF', # 鰀 (国土地理協会住所辞書文字)
    '9C4F' => 'D5B8', # 鱏
    '9C63' => 'D5BB', # 鱣 (国土地理協会住所辞書文字)
    '9CE6' => 'D5C0', # 鳦
    '9D0E' => 'D5C3', # 鴎 (JIS83)
    '9D1E' => 'D5C4', # 鴞 (国土地理協会住所辞書文字)
    '9D52' => 'D5D0', # 鵒
    '9D62' => 'D5CF', # 鵢 (国土地理協会住所辞書文字)
    '9D70' => 'D3C9', # 鵰 (国土地理協会住所辞書文字)
    '9D96' => 'D5D7', # 鶖 (国土地理協会住所辞書文字)
    '9E78' => 'D5DF', # 鹸 (JIS83)
    '9EB5' => '4C4D', # 麵 (JIS78)
    '9EB9' => 'D6BB', # 麹 (JIS83)
    '9EBA' => 'D7A7', # 麺 (JIS83)
    '9EBD' => 'B9FC', # 麽
    '9EC3' => 'D5E8', # 黃 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    '9ED1' => 'D5EB', # 黑 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F91D' => 'C0AF', # 欄 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F928' => 'BAA9', # 廊 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F929' => 'BEBE', # 朗 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F936' => 'CDCA', # 虜 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F970' => 'C0CA', # 殺 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F9D0' => 'D3FE', # 類 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'F9DC' => 'D3B9', # 隆 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA10' => '444D', # 塚 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA16' => 'C3F8', # 猪 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA19' => 'C6EB', # 神 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA1A' => 'C6F7', # 祥 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA1B' => 'C7A6', # 福 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA22' => 'CEEA', # 諸 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA26' => 'D0F2', # 都 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA30' => 'B2ED', # 侮 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA31' => 'B3D0', # 僧 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA32' => 'B3EA', # 免 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA33' => 'B4CD', # 勉 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA34' => 'B4D9', # 勤 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA35' => 'B4F7', # 卑 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA36' => '3365', # 喝 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA37' => 'B5FD', # 嘆 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA38' => 'B6B1', # 器 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA39' => 'B7A7', # 塀 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA3A' => 'B7A9', # 墨 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA3B' => 'B8EA', # 層 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA3D' => 'BBB0', # 悔 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA3E' => 'BBE4', # 慨 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA3F' => 'BBE5', # 憎 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA40' => 'BBF2', # 懲 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA41' => 'BCEF', # 敏 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA42' => 'BDAE', # 既 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA43' => 'BDF0', # 暑 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA44' => 'BEF8', # 梅 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA45' => 'C1B5', # 海 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA46' => '3D6D', # 渚 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA47' => 'C2B2', # 漢 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA48' => 'C3B6', # 煮 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA49' => 'C3D9', # 爫
    'FA4A' => '4276', # 琢 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA4B' => 'C6BF', # 碑 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA4C' => 'C6E0', # 社 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA4D' => 'C6E4', # 祉 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA4E' => 'C6E3', # 祈 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA4F' => 'C6ED', # 祐 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA50' => 'C6EC', # 祖 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA51' => 'C6EA', # 祝 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA53' => 'C7A4', # 禎 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA54' => 'C7CF', # 穀 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA55' => 'C7E2', # 突 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA56' => 'C8BF', # 節 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA57' => 'C9BE', # 練 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA59' => 'C9CE', # 繁 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA5A' => 'C9EA', # 署 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA5B' => 'CAA4', # 者 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA5C' => 'CACF', # 臭 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA5F' => 'CCB1', # 著 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA60' => 'CEA5', # 褐 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA61' => 'CEBB', # 視 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA62' => 'CEE9', # 謁 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA63' => 'CEF2', # 謹 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA64' => 'CFB6', # 賓 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA65' => 'CFC1', # 贈 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA66' => 'CFEF', # 辶
    'FA67' => 'D0B3', # 逸 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA68' => 'D3CA', # 難 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA69' => 'D3F0', # 響 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)
    'FA6A' => '4951', # 頻 (戸籍法施行規則付則別表 "人名用漢字許容字体表" (昭和56年法務省令51) 常用漢字表(昭和56年内閣告示第1号)のかっこ書き内の漢字)

    # Jacode4e original mapping

    '00B6' => 'A5F0', # ¶
    '2014' => '',     # ―
    '2015' => '213D', # ―
    '2016' => '',     # ∥
    '2020' => 'A5EE', # †
    '2021' => 'A5EF', # ‡
    '2030' => 'A4FE', # ‰
    '212B' => 'A4DF', # Å
    '21D2' => 'A6F6', # ⇒
    '21D4' => 'A6F7', # ⇔
    '2200' => 'A5E7', # ∀
    '2202' => 'A5CA', # ∂
    '2203' => 'A5E8', # ∃
    '2207' => 'A6F9', # ∇
    '2208' => 'A5D4', # ∈
    '220B' => 'A5D5', # ∋
    '2211' => '2D74', # ∑
    '2212' => '',     # －
    '221A' => '2D75', # √
    '221D' => 'A5DC', # ∝
    '221F' => '2D78', # ∟
    '2220' => '2D77', # ∠
    '2225' => '2142', # ∥
    '2227' => 'A5D0', # ∧
    '2228' => 'A5D1', # ∨
    '2229' => '2D7B', # ∩
    '222A' => '2D7C', # ∪
    '222B' => '2D72', # ∫
    '222C' => 'A6FA', # ∬
    '222E' => '2D73', # ∮
    '2235' => '2D7A', # ∵
    '223D' => 'A5DD', # ∽
    '2252' => '2D70', # ≒
    '2261' => '2D71', # ≡
    '226A' => 'A5E1', # ≪
    '226B' => 'A5E2', # ≫
    '2282' => 'A5D2', # ⊂
    '2283' => 'A5D3', # ⊃
    '2286' => 'A6F4', # ⊆
    '2287' => 'A6F5', # ⊇
    '22A5' => '2D76', # ⊥
    '22BF' => '2D79', # ⊿
    '2312' => 'A6F8', # ⌒
    '2460' => '2D21', # ①
    '2461' => '2D22', # ②
    '2462' => '2D23', # ③
    '2463' => '2D24', # ④
    '2464' => '2D25', # ⑤
    '2465' => '2D26', # ⑥
    '2466' => '2D27', # ⑦
    '2467' => '2D28', # ⑧
    '2468' => '2D29', # ⑨
    '2469' => '2D2A', # ⑩
    '246A' => '2D2B', # ⑪
    '246B' => '2D2C', # ⑫
    '246C' => '2D2D', # ⑬
    '246D' => '2D2E', # ⑭
    '246E' => '2D2F', # ⑮
    '246F' => '2D30', # ⑯
    '2470' => '2D31', # ⑰
    '2471' => '2D32', # ⑱
    '2472' => '2D33', # ⑲
    '2473' => '2D34', # ⑳
    '25EF' => 'A6FE', # ◯
    '2642' => '2169', # ♂
    '266A' => 'A6FD', # ♪
    '266D' => 'A6FC', # ♭
    '266F' => 'A6FB', # ♯
    '3007' => '213B', # 〇
    '301C' => '2141', # ～
    '301D' => '2D60', # 〝
    '301F' => '2D61', # 〟
    '3232' => '2D6B', # ㈲
    '3239' => '2D6C', # ㈹
    '32A4' => '2D65', # ㊤
    '32A5' => '2D66', # ㊥
    '32A6' => '2D67', # ㊦
    '32A7' => '2D68', # ㊧
    '32A8' => '2D69', # ㊨
    '3303' => '2D46', # ㌃
    '330D' => '2D4A', # ㌍
    '3314' => '2D41', # ㌔
    '3318' => '2D44', # ㌘
    '3322' => '2D42', # ㌢
    '3323' => '2D4C', # ㌣
    '3326' => '2D4B', # ㌦
    '3327' => '2D45', # ㌧
    '332B' => '2D4D', # ㌫
    '3336' => '2D47', # ㌶
    '333B' => '2D4F', # ㌻
    '3349' => '2D40', # ㍉
    '334A' => '2D4E', # ㍊
    '334D' => '2D43', # ㍍
    '3351' => '2D48', # ㍑
    '3357' => '2D49', # ㍗
    '337B' => '2D5F', # ㍻
    '337C' => '2D6F', # ㍼
    '337D' => '2D6E', # ㍽
    '337E' => '2D6D', # ㍾
    '338E' => '2D53', # ㎎
    '338F' => '2D54', # ㎏
    '339C' => '2D50', # ㎜
    '339D' => '2D51', # ㎝
    '339E' => '2D52', # ㎞
    '33A1' => '2D56', # ㎡
    '33C4' => '2D55', # ㏄
    '33CD' => '2D63', # ㏍
    '51DC' => 'B4A8', # 凜
    '582F' => '3646', # 堯
    '5C2D' => 'B6DA', # 尭
    '69C7' => '4B6A', # 槇
    '69D9' => 'BFCE', # 槙
    '7199' => 'C3BA', # 熙
    '7464' => '6076', # 瑤
    '7476' => 'C4E8', # 瑶
    '9059' => '4D5A', # 遙
    '9065' => 'D0C4', # 遥
    'FF0D' => '215D', # －
    'FFE2' => '',     # ￢
);

my %JIPSJ_by_Unicode_OVERRIDE = @JIPSJ_by_Unicode_OVERRIDE;
if (scalar(keys %JIPSJ_by_Unicode_OVERRIDE) != (scalar(@JIPSJ_by_Unicode_OVERRIDE) / 2)) {
    my %key = ();
    while (my($key) = splice(@JIPSJ_by_Unicode_OVERRIDE,0,2)) {
        $key{$key}++;
    }
    for my $key (sort keys %key) {
        if ($key{$key} >= 2) {
            print STDERR "[$key], ";
        }
    }
    die "Duplicate hash key(must unique): %JIPSJ_by_Unicode_OVERRIDE\n";
}

my %unicode = map { $_ => 1 } (
    (map { Unicode_by_CP932($_) } keys_of_JIPSJ_by_CP932()),
    keys_of_NEC_CP932_by_Unicode(),
    keys_of_JIPSJ_by_Unicode_CultiCoLtd(),
    keys %JIPSJ_by_Unicode_OVERRIDE,
);

my %JIPSJ_by_Unicode = ();
my %done = ();

for my $unicode (sort { (length($a) <=> length($b)) || ($a cmp $b) } keys %unicode) {
    if (0) {
    }

    my $char = pack('H*',CP932_by_Unicode($unicode));

    if (0) {
    }

    # NEC Corporation Standard character set dictionary <BASIC>
    # Document number ZBB10-3
    # NEC Corporation Standard character set dictionary <EXTENSION>
    # Document number ZBB11-2
    elsif ((JIPSJ_by_CP932(CP932_by_Unicode($unicode)) ne '') and not $done{JIPSJ_by_CP932(CP932_by_Unicode($unicode))}) {
        $done{$JIPSJ_by_Unicode{$unicode} = JIPSJ_by_CP932(CP932_by_Unicode($unicode))} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", JIPSJ_by_CP932(CP932_by_Unicode($unicode)), $unicode, JIPSJ_by_CP932(CP932_by_Unicode($unicode)), '----', '----', '----', '----', '----', '----', '----', '----';
    }

    # override (not defined)
    elsif (exists($JIPSJ_by_Unicode_OVERRIDE{$unicode}) and ($JIPSJ_by_Unicode_OVERRIDE{$unicode} eq '')) {
        $done{$JIPSJ_by_Unicode_OVERRIDE{$unicode}} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", $JIPSJ_by_Unicode{$unicode}, $unicode, '----', $JIPSJ_by_Unicode_OVERRIDE{$unicode}, '----', '----', '----', '----', '----', '----', '----';
    }

    # override (defined)
    elsif (($JIPSJ_by_Unicode_OVERRIDE{$unicode} ne '') and not $done{$JIPSJ_by_Unicode_OVERRIDE{$unicode}}) {
        $done{$JIPSJ_by_Unicode{$unicode} = $JIPSJ_by_Unicode_OVERRIDE{$unicode}} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", $JIPSJ_by_Unicode{$unicode}, $unicode, '----', '----', $JIPSJ_by_Unicode_OVERRIDE{$unicode}, '----', '----', '----', '----', '----', '----';
    }

    # JIS78 <-> JIS83
    elsif ((JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))) ne '') and not $done{JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)))}) {
        $done{$JIPSJ_by_Unicode{$unicode} = JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)))} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", $JIPSJ_by_Unicode{$unicode}, $unicode, '----', '----', '----', JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))), JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)), JISX0208GL_by_CP932(NEC_CP932_by_Unicode($unicode)), JIPSJ_by_Unicode_CultiCoLtd($unicode), '----', '----';
    }

    # JIS C 6226-1978 by SJIS
    elsif ((JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)) ne '') and not $done{JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))}) {
        $done{$JIPSJ_by_Unicode{$unicode} = JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", $JIPSJ_by_Unicode{$unicode}, $unicode, '----', '----', '----', '----', JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))), JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)), JISX0208GL_by_CP932(NEC_CP932_by_Unicode($unicode)), JIPSJ_by_Unicode_CultiCoLtd($unicode), '----';
    }

    # JIS X 0213:2004
    elsif ((JIPSJ_by_Unicode_CultiCoLtd($unicode) ne '') and not $done{JIPSJ_by_Unicode_CultiCoLtd($unicode)}) {
        $done{$JIPSJ_by_Unicode{$unicode} = JIPSJ_by_Unicode_CultiCoLtd($unicode)} = 1;
printf DUMP "%-4s %-9s %-4s %-4s %-4s %-4s %-4s %-4s $char\n", $JIPSJ_by_Unicode{$unicode}, $unicode, '----', '----', '----', '----', '----', JIS78GL_by_JIS83GL(JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode))), JISX0208GL_by_SJIS(NEC_CP932_by_Unicode($unicode)), JISX0208GL_by_CP932(NEC_CP932_by_Unicode($unicode)), JIPSJ_by_Unicode_CultiCoLtd($unicode);
    }
}

close(DUMP);

# JIPS includes JIS83, JIS90, and JIS2004 fonts as extended character sets, but this software does not use them
for my $unicode (sort { (length($a) <=> length($b)) || ($a cmp $b) } keys %unicode) {

    # JIS83
    if (($unicode =~ /^(?:
 
        5C2D | # => B6DA 尭
        69D9 | # => BFCE 槙
        7476 | # => C4E8 瑶
        9065 | # => D0C4 遥

        4FA0 | # => B2E2 侠
        5516 | # => D6A1 唖
        565B | # => D6AE 噛
        56A2 | # => D6F2 嚢
        586B | # => D6E6 填
        5C61 | # => B8E8 屡
        63B4 | # => D6E2 掴
        63BB | # => D6D4 掻
        6505 | # => BCE9 攅
        6D9C | # => D6EC 涜
        6E8C | # => C1ED 溌
        7114 | # => D6A8 焔
        7977 | # => C6FB 祷
        7BAA | # => D6DB 箪
        7E4D | # => C9D3 繍
        83B1 | # => CBE3 莱
        848B | # => CCC7 蒋
        8749 | # => CDDC 蝉
        874B | # => D7B3 蝋
        8EAF | # => CFDC 躯
        9197 | # => D1AC 醗
        91A4 | # => D6C8 醤
        982C | # => D3F7 頬
        985B | # => D4A3 顛
        9A28 | # => D4D1 騨
        9D0E | # => D5C3 鴎
        9E78 | # => D5DF 鹸
        9EB9 | # => D6BB 麹
        9EBA   # => D7A7 麺

    )$/x) and ($JIPSJ_by_Unicode{$unicode} ne '')) {
        next;
    }

    # JIS2004
    if (($unicode =~ /^(?:

        4FF1  | # => '',  # 俱
        5265  | # => B4BC # 剥
        20B9F | # => B5C0 # 𠮟
        541E  | # => '',  # 吞
        5653  | # => B6AA # 噓
        59F8  | # => '',  # 姸
        5C4F  | # => B8E7 # 屏
        5E77  | # => B9F9 # 幷
        75E9  | # => D6D5 # 痩
        7E4B    # => D6B6 # 繋

    )$/x) and ($JIPSJ_by_Unicode{$unicode} ne '')) {
        next;
    }

    # JIS83 and JIS90
    if ($JIPSJ_by_Unicode{$unicode} =~ /^(?:D6|D7)[ABCDEF][0123456789ABCDEF]$/) {
        warn "Should not use JIS83 or JIS90 glyph to compatibility of information processing(Unicode=U+$unicode, JIPS(J)=$JIPSJ_by_Unicode{$unicode}).\n";
    }
}

sub JIPSJ_by_Unicode {
    my($unicode) = @_;
    return $JIPSJ_by_Unicode{$unicode};
}

sub keys_of_JIPSJ_by_Unicode {
    return keys %JIPSJ_by_Unicode;
}

sub values_of_JIPSJ_by_Unicode {
    return values %JIPSJ_by_Unicode;
}

1;

__END__
