
######################################################################
## $Id: TextArea.pm 12431 2009-01-13 18:29:49Z spadkins $
######################################################################

package App::Widget::TextArea;
$VERSION = (q$Revision: 12431 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget::Stylizable;
@ISA = ( "App::Widget::Stylizable" );

use strict;

=head1 NAME

App::Widget::TextArea - An HTML textarea field

=head1 SYNOPSIS

   $name = "first_name";
   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);
   # OR ...
   $w = $context->widget($name,
      class => "App::Widget::TextArea",
      size  => 8,                 # from HTML spec
      maxlength => 18,            # from HTML spec
      tabindex => 1,              # from HTML spec
      readonly => 1,              # from HTML spec
      style => "mystyle",         # from HTML to support CSS
      color => "#6666CC",         # from CSS spec
      font_size => "10px",        # from CSS spec
      border_style => "solid",    # from CSS spec
      border_width => "1px",      # from CSS spec
      border_color => "#6666CC",  # from CSS spec
      padding => "2px",           # from CSS spec
      background_color => "#ccffcc",           # from CSS spec
      font_family => "Verdana, Geneva, Arial", # from CSS spec
      override => 1,              # increase precedence of following options to "override" from "default"
      #validate => "date",         # not impl. yet ("date", "time", "datetime", "enum", "number", "integer", ":regexp")
      #autocomplete => \@previous_choices,  # not impl. yet
   );

   # internal way
   use App::Widget::TextArea;
   $w = App::Widget::TextArea->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class is a <textarea> HTML element.

=cut

######################################################################
# INITIALIZATION
######################################################################

# no special initialization

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub unstyled_html {
    my $self = shift;
    my ($html);
    my $name = $self->{name};
    my $value = $self->get_value();
    my $html_value = $self->html_escape($value);
    my $rows = $self->{rows} || 40;
    my $cols = $self->{cols} || 10;
    my $wrap_html = "";
    my $wrap = $self->{wrap};
    my $readonly = $self->get("readonly");
    my $readonly_html = "";
    my $enable_warn = $self->get("enable_warning");
    my $enable_warning_widget = $self->get("enable_warning_widget");

    if (defined $wrap) {
        if ($wrap =~ /^(hard|off|physical|soft|virtual)$/) {
            $wrap_html = " wrap=\"$wrap\"";
        }
        else {
            $wrap_html = " wrap";
        }
    }

    $readonly_html = " readonly" if (defined $readonly);

    my $tabindex = $self->{tabindex};
    if($enable_warn) {
        $html = "<textarea name=\"${name}\" rows=\"$rows\" cols=\"$cols\"$wrap_html $readonly_html";
        $html .= " onkeydown=\"javascript: var enable_warning = context.getElementByName('" . $enable_warning_widget . "'); ";
        $html .= " enable_warning.value = 'enabled';\">\n";
    }
    else {
        $html = "<textarea name=\"${name}\" rows=\"$rows\" cols=\"$cols\"$wrap_html $readonly_html>\n";
    }
    $html .= $html_value;
    $html .= "</textarea>";
    $html;
}

1;

