use strict;
use FindBin::libs;
use Data::Dumper;
use Algorithm::LSH;


# Sorry, this script has not coment by English. Japanese only.


#-----------------------------------------------------------
# 事前に流し込んでおいたデータフィルを読みこむ
my $lsh = Algorithm::LSH->new( d => 2, L => 5, k => 1 );
$lsh->load( $FindBin::Bin . '/map.bin' );

#-----------------------------------------------------------
# 検索したいポイントを設定
my $search_point = [ 42.983, 144.383 ]; # 北海道釧路市

#-----------------------------------------------------------
# Locality Sensitive Hashing で 近傍と思われるポイントをピックアップ 
# without_selfオプションを付けることで釧路市は対象外としている
my $neighbours = $lsh->neighbours( $search_point, ' without_self ' );
print scalar @$neighbours, "\n"; # 33個のポイントが近傍として選択される

# 近傍ポイントの中から最も近いものを抽出 
my $nearest = $lsh->nearest( $search_point, $neighbours );
print Dumper $nearest; # 北海道帯広市


#-----------------------------------------------------------
# 上記のことを一発で実施する
# without_selfを付けていないので釧路市も対象
my $nearest_neighbours = $lsh->nearest_neighbours($search_point);
print Dumper $nearest_neighbours; # 北海道釧路市

# 短縮形
my $nn = $lsh->nn($search_point);
print Dumper $nn;



__DATA__
北海道札幌市 43.067 141.350
北海道旭川市 43.767 142.367
北海道稚内市 45.417 141.667
北海道釧路市 42.983 144.383
北海道帯広市 42.917 143.200
北海道室蘭市 42.317 140.967
北海道函館市 41.767 140.733
北海道小樽市 43.183 141.000
青森県青森市 40.817 140.750
青森県八戸市 40.500 141.483
秋田県秋田市 39.717 140.100
岩手県盛岡市 39.700 141.150
山形県山形市 38.250 140.350
山形県酒田市 38.917 139.833
宮城県仙台市 38.267 140.867
宮城県塩竈市 38.317 141.017
福島県福島市 37.767 140.467
茨城県水戸市 36.367 140.467
栃木県宇都宮市 36.550 139.883
千葉県千葉市 35.633 140.117
千葉県館山市 35.000 139.867
群馬県前橋市 36.383 139.067
群馬県高崎市 36.333 139.000
東京都東京駅 35.667 139.767
東京都新宿駅 35.683 139.700
東京都八王子市 35.650 139.117
神奈川県横浜市 35.450 139.633
山梨県甲府市 35.667 138.567
新潟県新潟市 37.917 139.033
長野県長野市 36.650 138.200
長野県松本市 36.233 137.967
富山県富山市 36.700 137.217
石川県金沢市 36.567 136.650
福井県福井市 36.067 136.217
静岡県静岡市 34.967 138.383
愛知県名古屋市 35.183 136.900
岐阜県岐阜市 35.417 136.767
三重県津市 34.717 136.500
滋賀県大津市 35.017 135.850
奈良県奈良市 34.683 135.800
京都府京都駅 34.983 135.750
京都府舞鶴市 35.483 135.383
大阪府大阪市 34.683 135.500
大阪府大阪駅 34.700 135.483
大阪府堺市 34.583 135.483
和歌山県和歌山市 34.233 135.167
兵庫県神戸市 34.683 135.200
兵庫県姫路市 34.817 134.683
岡山県岡山市 34.650 133.917
岡山県倉敷市 34.583 133.767
岡山県玉野市 34.483 133.933
岡山県新見市 34.967 133.467
岡山県津山市 35.067 134.000
広島県広島市 34.383 132.450
広島県呉市 34.233 132.567
広島県福山市 34.483 133.350
広島県三次市 34.800 132.850
広島県安芸高田市 34.650 132.700
山口県山口市 34.183 131.467
山口県岩国市 34.167 132.217
山口県下関市 33.950 130.933
鳥取県鳥取市 35.500 134.233
島根県松江市 35.467 133.050
島根県益田市 34.667 131.833
徳島県徳島市 34.067 134.550
香川県高松市 34.350 134.050
香川県坂出市 34.300 133.850
香川県善通寺市 34.217 133.783
香川県東かがわ市 34.233 134.350
香川県丸亀市 34.283 133.783
高知県高知市 33.567 133.533
愛媛県松山市 33.833 132.767
愛媛県新居浜市 33.950 133.267
福岡県北九州市 33.883 130.867
福岡県福岡市 33.583 130.400
佐賀県佐賀市 33.267 130.300
大分県大分市 33.233 131.617
熊本県熊本市 32.800 130.700
長崎県長崎市 32.750 129.883
長崎県佐世保市 33.167 129.700
宮崎県延岡市 32.583 131.667
宮崎県宮崎市 31.900 131.417
鹿児島県鹿児島市 31.600 130.550
沖縄県那覇市 26.217 127.683
沖縄県石垣市 24.333 125.150
