use Mojo::Base '-strict';
use Mojolicious::Lite;

app->log->level('error');

get '/' => sub {
    my $self = shift;

    return $self->render(text => "It works");
};

get '/:name' => sub {
    my $self = shift;
    my $name = $self->param('name');
     
    return $self->respond_to(
        json => sub { $self->render(json => {name => $name}) },
        xml  => {text => "<name>${name}</name>"},
        any  => {data => '', status => 200 }
     );
};

app->start;

