package Google::Ads::AdWords::v201109_1::CampaignPage;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109_1::Page);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %totalNumEntries_of :ATTR(:get<totalNumEntries>);
my %Page__Type_of :ATTR(:get<Page__Type>);
my %totalBudget_of :ATTR(:get<totalBudget>);
my %entries_of :ATTR(:get<entries>);

__PACKAGE__->_factory(
    [ qw(        totalNumEntries
        Page__Type
        totalBudget
        entries

    ) ],
    {
        'totalNumEntries' => \%totalNumEntries_of,
        'Page__Type' => \%Page__Type_of,
        'totalBudget' => \%totalBudget_of,
        'entries' => \%entries_of,
    },
    {
        'totalNumEntries' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Page__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'totalBudget' => 'Google::Ads::AdWords::v201109_1::Budget',
        'entries' => 'Google::Ads::AdWords::v201109_1::Campaign',
    },
    {

        'totalNumEntries' => 'totalNumEntries',
        'Page__Type' => 'Page.Type',
        'totalBudget' => 'totalBudget',
        'entries' => 'entries',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::CampaignPage

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CampaignPage from the namespace https://adwords.google.com/api/adwords/cm/v201109_1.

Contains a subset of campaign resulting from the filtering and paging of the {@link com.google.ads.api.services.campaignmgmt.campaign.CampaignService#get} call. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * totalBudget


=item * entries




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::CampaignPage
   totalBudget =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Budget
   entries =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Campaign
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

