/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.util.List;
import org.openqa.grid.internal.cli.BrowserDesiredCapabilityConverter;
import org.openqa.grid.internal.cli.CommonGridCliOptions;
import org.openqa.grid.internal.cli.FileExistsValueValidator;
import org.openqa.grid.internal.cli.NoOpParameterSplitter;
import org.openqa.selenium.MutableCapabilities;

public class GridNodeCliOptions {
    @ParametersDelegate
    private CommonGridCliOptions commonGridOptions = new CommonGridCliOptions();
    @Parameter(names={"-nodeConfig"}, description="<String> filename : JSON configuration file for the node. Overrides default values", validateValueWith={FileExistsValueValidator.class})
    private String configFile;
    @Parameter(names={"-remoteHost"}, description="<String> URL: Address to report to the hub. Used to override default (http://<host>:<port>).")
    private String remoteHost;
    @Parameter(names={"-hubHost"}, description="<String> IP or hostname : the host address of the hub we're attempting to register with. If -hub is specified the -hubHost is determined from it.")
    private String hubHost;
    @Parameter(names={"-hubPort"}, description="<Integer> : the port of the hub we're attempting to register with. If -hub is specified the -hubPort is determined from it.")
    private Integer hubPort;
    @Parameter(names={"-id"}, description="<String> : optional unique identifier for the node. Defaults to the url of the remoteHost, when not specified.")
    private String id;
    @Parameter(names={"-capabilities", "-browser"}, description="<String> : comma separated Capability values. Example: -capabilities browserName=firefox,platform=linux -capabilities browserName=chrome,platform=linux", listConverter=BrowserDesiredCapabilityConverter.class, converter=BrowserDesiredCapabilityConverter.class, splitter=NoOpParameterSplitter.class)
    private List<MutableCapabilities> capabilities;
    @Parameter(names={"-downPollingLimit"}, description="<Integer> : node is marked as \"down\" if the node hasn't responded after the number of checks specified in [downPollingLimit].")
    private Integer downPollingLimit;
    @Parameter(names={"-hub"}, description="<String> : the url that will be used to post the registration request. This option takes precedence over -hubHost and -hubPort options.")
    private String hub;
    @Parameter(names={"-nodePolling"}, description="<Integer> in ms : specifies how often the hub will poll to see if the node is still responding.")
    private Integer nodePolling;
    @Parameter(names={"-nodeStatusCheckTimeout"}, description="<Integer> in ms : connection/socket timeout, used for node \"nodePolling\" check.")
    private Integer nodeStatusCheckTimeout;
    @Parameter(names={"-proxy"}, description="<String> : the class used to represent the node proxy. Default is [org.openqa.grid.selenium.proxy.DefaultRemoteProxy].")
    private String proxy;
    @Parameter(names={"-register"}, description="if specified, node will attempt to re-register itself automatically with its known grid hub if the hub becomes unavailable.", arity=1)
    private Boolean register;
    @Parameter(names={"-registerCycle"}, description="<Integer> in ms : specifies how often the node will try to register itself again. Allows administrator to restart the hub without restarting (or risk orphaning) registered nodes. Must be specified with the \"-register\" option.")
    private Integer registerCycle;
    @Parameter(names={"-unregisterIfStillDownAfter"}, description="<Integer> in ms : if the node remains down for more than [unregisterIfStillDownAfter] ms, it will stop attempting to re-register from the hub.")
    private Integer unregisterIfStillDownAfter;
    @Parameter(names={"-enablePlatformVerification"}, arity=1, description="<Boolean>: Whether or not to drop capabilities that does not belong to the current platform family. Defaults to true.")
    private Boolean enablePlatformVerification;

    public CommonGridCliOptions getCommonGridOptions() {
        return this.commonGridOptions;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getHubHost() {
        return this.hubHost;
    }

    public Integer getHubPort() {
        return this.hubPort;
    }

    public String getId() {
        return this.id;
    }

    public List<MutableCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public Integer getDownPollingLimit() {
        return this.downPollingLimit;
    }

    public String getHub() {
        return this.hub;
    }

    public Integer getNodePolling() {
        return this.nodePolling;
    }

    public Integer getNodeStatusCheckTimeout() {
        return this.nodeStatusCheckTimeout;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Boolean getRegister() {
        return this.register;
    }

    public Integer getRegisterCycle() {
        return this.registerCycle;
    }

    public Integer getUnregisterIfStillDownAfter() {
        return this.unregisterIfStillDownAfter;
    }

    public Boolean getEnablePlatformVerification() {
        return this.enablePlatformVerification;
    }
}

