# Generated by default/object.tt
package Paws::Proton::EnvironmentAccountConnection;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has EnvironmentAccountId => (is => 'ro', isa => 'Str', request_name => 'environmentAccountId', traits => ['NameInRequest'], required => 1);
  has EnvironmentName => (is => 'ro', isa => 'Str', request_name => 'environmentName', traits => ['NameInRequest'], required => 1);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has LastModifiedAt => (is => 'ro', isa => 'Str', request_name => 'lastModifiedAt', traits => ['NameInRequest'], required => 1);
  has ManagementAccountId => (is => 'ro', isa => 'Str', request_name => 'managementAccountId', traits => ['NameInRequest'], required => 1);
  has RequestedAt => (is => 'ro', isa => 'Str', request_name => 'requestedAt', traits => ['NameInRequest'], required => 1);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Proton::EnvironmentAccountConnection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Proton::EnvironmentAccountConnection object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Proton::EnvironmentAccountConnection object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The environment account connection detail data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the environment account connection.


=head2 B<REQUIRED> EnvironmentAccountId => Str

The environment account that's connected to the environment account
connection.


=head2 B<REQUIRED> EnvironmentName => Str

The name of the environment that's associated with the environment
account connection.


=head2 B<REQUIRED> Id => Str

The ID of the environment account connection.


=head2 B<REQUIRED> LastModifiedAt => Str

The time when the environment account connection was last modified.


=head2 B<REQUIRED> ManagementAccountId => Str

The ID of the management account that's connected to the environment
account connection.


=head2 B<REQUIRED> RequestedAt => Str

The time when the environment account connection request was made.


=head2 B<REQUIRED> RoleArn => Str

The IAM service role that's associated with the environment account
connection.


=head2 B<REQUIRED> Status => Str

The status of the environment account connection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Proton>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

