package MouseX::Getopt::Meta::Attribute;
BEGIN {
  $MouseX::Getopt::Meta::Attribute::AUTHORITY = 'cpan:STEVAN';
}
BEGIN {
  $MouseX::Getopt::Meta::Attribute::VERSION = '0.33';
}
# ABSTRACT: Optional meta attribute for custom option names

use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Mouse::Meta::Attribute'; # << Mouse extending Mouse :)
   with 'MouseX::Getopt::Meta::Attribute::Trait';

no Mouse;

# register this as a metaclass alias ...
package # stop confusing PAUSE
    Mouse::Meta::Attribute::Custom::Getopt;
BEGIN {
  $Mouse::Meta::Attribute::Custom::Getopt::AUTHORITY = 'cpan:STEVAN';
}
BEGIN {
  $Mouse::Meta::Attribute::Custom::Getopt::VERSION = '0.33';
}
sub register_implementation { 'MouseX::Getopt::Meta::Attribute' }

1;


__END__
=pod

=encoding utf-8

=head1 NAME

MouseX::Getopt::Meta::Attribute - Optional meta attribute for custom option names

=head1 SYNOPSIS

  package App;
  use Mouse;

  with 'MouseX::Getopt';

  has 'data' => (
      metaclass => 'MouseX::Getopt::Meta::Attribute',
      is        => 'ro',
      isa       => 'Str',
      default   => 'file.dat',

      # tells MouseX::Getopt to use --somedata as the
      # command line flag instead of the normal
      # autogenerated one (--data)
      cmd_flag  => 'somedata',

      # tells MouseX::Getopt to also allow --moosedata,
      # -m, and -d as aliases for this same option on
      # the commandline.
      cmd_aliases => [qw/ moosedata m d /],

      # Or, you can use a plain scalar for a single alias:
      cmd_aliases => 'm',
  );

=head1 DESCRIPTION

This is a custom attribute metaclass which can be used to specify a
the specific command line flag to use instead of the default one
which L<MouseX::Getopt> will create for you.

This is certainly not the prettiest way to go about this, but for
now it works for those who might need such a feature.

=head2 Custom Metaclass alias

This now takes advantage of the Moose 0.19 feature to support
custom attribute metaclass aliases. This means you can also
use this as the B<Getopt> alias, like so:

  has 'foo' => (metaclass => 'Getopt', cmd_flag => 'f');

=head1 METHODS

=head2 B<cmd_flag>

Changes the commandline flag to be this value, instead of the default,
which is the same as the attribute name.

=head2 B<cmd_aliases>

Adds more aliases for this commandline flag, useful for short options
and such.

=head2 B<has_cmd_flag>

=head2 B<has_cmd_aliases>

=head1 AUTHORS

=over 4

=item *

NAKAGAWA Masaki <masaki@cpan.org>

=item *

FUJI Goro <gfuji@cpan.org>

=item *

Tokuhiro Matsuno <tokuhirom@cpan.org>

=item *

Stevan Little <stevan@iinteractive.com>

=item *

Brandon L. Black <blblack@gmail.com>

=item *

Yuval Kogman <nothingmuch@woobling.org>

=item *

Ryan D Johnson <ryan@innerfence.com>

=item *

Drew Taylor <drew@drewtaylor.com>

=item *

Tomas Doran <bobtfish@bobtfish.net>

=item *

Florian Ragwitz <rafl@debian.org>

=item *

Dagfinn Ilmari Mannsaker <ilmari@ilmari.org>

=item *

Avar Arnfjord Bjarmason <avar@cpan.org>

=item *

Chris Prather <perigrin@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Infinity Interactive, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

