# Generated by default/object.tt
package Paws::SageMaker::OnlineStoreSecurityConfig;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OnlineStoreSecurityConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OnlineStoreSecurityConfig object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., KmsKeyId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OnlineStoreSecurityConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

The security configuration for C<OnlineStore>.

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

The ID of the Amazon Web Services Key Management Service (Amazon Web
Services KMS) key that SageMaker Feature Store uses to encrypt the
Amazon S3 objects at rest using Amazon S3 server-side encryption.

The caller (either IAM user or IAM role) of C<CreateFeatureGroup> must
have below permissions to the C<OnlineStore> C<KmsKeyId>:

=over

=item *

C<"kms:Encrypt">

=item *

C<"kms:Decrypt">

=item *

C<"kms:DescribeKey">

=item *

C<"kms:CreateGrant">

=item *

C<"kms:RetireGrant">

=item *

C<"kms:ReEncryptFrom">

=item *

C<"kms:ReEncryptTo">

=item *

C<"kms:GenerateDataKey">

=item *

C<"kms:ListAliases">

=item *

C<"kms:ListGrants">

=item *

C<"kms:RevokeGrant">

=back

The caller (either IAM user or IAM role) to all DataPlane operations
(C<PutRecord>, C<GetRecord>, C<DeleteRecord>) must have the following
permissions to the C<KmsKeyId>:

=over

=item *

C<"kms:Decrypt">

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

