# Generated by default/object.tt
package Paws::EMR::SessionMappingDetail;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has IdentityId => (is => 'ro', isa => 'Str');
  has IdentityName => (is => 'ro', isa => 'Str');
  has IdentityType => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has SessionPolicyArn => (is => 'ro', isa => 'Str');
  has StudioId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::SessionMappingDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::SessionMappingDetail object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., StudioId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::SessionMappingDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Details for an Amazon EMR Studio session mapping including creation
time, user or group ID, Studio ID, and so on.

=head1 ATTRIBUTES


=head2 CreationTime => Str

The time the session mapping was created.


=head2 IdentityId => Str

The globally unique identifier (GUID) of the user or group.


=head2 IdentityName => Str

The name of the user or group. For more information, see UserName
(https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
and DisplayName
(https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
in the I<AWS SSO Identity Store API Reference>.


=head2 IdentityType => Str

Specifies whether the identity mapped to the Amazon EMR Studio is a
user or a group.


=head2 LastModifiedTime => Str

The time the session mapping was last modified.


=head2 SessionPolicyArn => Str

The Amazon Resource Name (ARN) of the session policy associated with
the user or group.


=head2 StudioId => Str

The ID of the Amazon EMR Studio.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

