# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2VpcDetails;
  use Moose;
  has CidrBlockAssociationSet => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::CidrBlockAssociation]');
  has DhcpOptionsId => (is => 'ro', isa => 'Str');
  has Ipv6CidrBlockAssociationSet => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::Ipv6CidrBlockAssociation]');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2VpcDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2VpcDetails object:

  $service_obj->Method(Att1 => { CidrBlockAssociationSet => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2VpcDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CidrBlockAssociationSet

=head1 DESCRIPTION

Details about an EC2 VPC.

=head1 ATTRIBUTES


=head2 CidrBlockAssociationSet => ArrayRef[L<Paws::SecurityHub::CidrBlockAssociation>]

Information about the IPv4 CIDR blocks associated with the VPC.


=head2 DhcpOptionsId => Str

The identifier of the set of Dynamic Host Configuration Protocol (DHCP)
options that are associated with the VPC. If the default options are
associated with the VPC, then this is default.


=head2 Ipv6CidrBlockAssociationSet => ArrayRef[L<Paws::SecurityHub::Ipv6CidrBlockAssociation>]

Information about the IPv6 CIDR blocks associated with the VPC.


=head2 State => Str

The current state of the VPC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

