# Generated by default/object.tt
package Paws::SSOAdmin::InstanceAccessControlAttributeConfiguration;
  use Moose;
  has AccessControlAttributes => (is => 'ro', isa => 'ArrayRef[Paws::SSOAdmin::AccessControlAttribute]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOAdmin::InstanceAccessControlAttributeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOAdmin::InstanceAccessControlAttributeConfiguration object:

  $service_obj->Method(Att1 => { AccessControlAttributes => $value, ..., AccessControlAttributes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOAdmin::InstanceAccessControlAttributeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessControlAttributes

=head1 DESCRIPTION

Specifies the attributes to add to your attribute-based access control
(ABAC) configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AccessControlAttributes => ArrayRef[L<Paws::SSOAdmin::AccessControlAttribute>]

Lists the attributes that are configured for ABAC in the specified AWS
SSO instance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOAdmin>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

