# Generated by default/object.tt
package Paws::Kendra::DataSourceSyncJobMetricTarget;
  use Moose;
  has DataSourceId => (is => 'ro', isa => 'Str', required => 1);
  has DataSourceSyncJobId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::DataSourceSyncJobMetricTarget

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::DataSourceSyncJobMetricTarget object:

  $service_obj->Method(Att1 => { DataSourceId => $value, ..., DataSourceSyncJobId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::DataSourceSyncJobMetricTarget object:

  $result = $service_obj->Method(...);
  $result->Att1->DataSourceId

=head1 DESCRIPTION

Maps a particular data source sync job to a particular data source.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DataSourceId => Str

The ID of the data source that is running the sync job.


=head2 DataSourceSyncJobId => Str

The ID of the sync job that is running on the data source.

If the ID of a sync job is not provided and there is a sync job
running, then the ID of this sync job is used and metrics are generated
for this sync job.

If the ID of a sync job is not provided and there is no sync job
running, then no metrics are generated and documents are
indexed/deleted at the index level without sync job metrics included.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

