use lib "t";
use next::XS;

use strict;
use warnings;
use utf8;
use open qw( :utf8 :std );

require q(test.pl); plan(tests => 12);

=pod

This example is taken from: http://rt.cpan.org/Public/Bug/Display.html?id=20879

               ---     ---     ---
Level 5     8 | A | 9 | B | A | C |    (More General)
               ---     ---     ---       V
                  \     |     /          |
                   \    |    /           |
                    \   |   /            |
                     \  |  /             |
                       ---               |
Level 4             7 | D |              |
                       ---               |
                      /   \              |
                     /     \             |
                  ---       ---          |
Level 3        4 | G |   6 | E |         |
                  ---       ---          |
                   |         |           |
                   |         |           |
                  ---       ---          |
Level 2        3 | H |   5 | F |         |
                  ---       ---          |
                      \   /  |           |
                       \ /   |           |
                        \    |           |
                       / \   |           |
                      /   \  |           |
                  ---       ---          |
Level 1        1 | J |   2 | I |         |
                  ---       ---          |
                    \       /            |
                     \     /             |
                       ---               v
Level 0             0 | K |            (More Specialized)
                       ---


0123456789A
KJIHGFEDABC

=cut

{
    package 텟Ṱ::ᐊ; use mro 'c3';

    package 텟Ṱ::ḅ; use mro 'c3';

    package 텟Ṱ::ȼ; use mro 'c3';

    package 텟Ṱ::Ḏ; use mro 'c3';
    use base qw/텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ/;

    package 텟Ṱ::Ӭ; use mro 'c3';
    use base qw/텟Ṱ::Ḏ/;

    package 텟Ṱ::Ḟ; use mro 'c3';
    use base qw/텟Ṱ::Ӭ/;
    sub testmèth { "wrong" }

    package 텟Ṱ::ḡ; use mro 'c3';
    use base qw/텟Ṱ::Ḏ/;

    package 텟Ṱ::Ḣ; use mro 'c3';
    use base qw/텟Ṱ::ḡ/;

    package 텟Ṱ::ᶦ; use mro 'c3';
    use base qw/텟Ṱ::Ḣ 텟Ṱ::Ḟ/;
    sub testmèth { "right" }

    package 텟Ṱ::Ｊ; use mro 'c3';
    use base qw/텟Ṱ::Ḟ/;

    package 텟Ṱ::Ḵ; use mro 'c3';
    use base qw/텟Ṱ::Ｊ 텟Ṱ::ᶦ/;
    sub testmèth { shift->next::method }
}

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::ᐊ'),
    [ qw(텟Ṱ::ᐊ) ]
), '... got the right C3 merge order for 텟Ṱ::ᐊ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::ḅ'),
    [ qw(텟Ṱ::ḅ) ]
), '... got the right C3 merge order for 텟Ṱ::ḅ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::ȼ'),
    [ qw(텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::ȼ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ḏ'),
    [ qw(텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ḏ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ӭ'),
    [ qw(텟Ṱ::Ӭ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ӭ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ḟ'),
    [ qw(텟Ṱ::Ḟ 텟Ṱ::Ӭ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ḟ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::ḡ'),
    [ qw(텟Ṱ::ḡ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::ḡ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ḣ'),
    [ qw(텟Ṱ::Ḣ 텟Ṱ::ḡ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ḣ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::ᶦ'),
    [ qw(텟Ṱ::ᶦ 텟Ṱ::Ḣ 텟Ṱ::ḡ 텟Ṱ::Ḟ 텟Ṱ::Ӭ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::ᶦ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ｊ'),
    [ qw(텟Ṱ::Ｊ 텟Ṱ::Ḟ 텟Ṱ::Ӭ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ｊ');

ok(eq_array(
    mro::get_linear_isa('텟Ṱ::Ḵ'),
    [ qw(텟Ṱ::Ḵ 텟Ṱ::Ｊ 텟Ṱ::ᶦ 텟Ṱ::Ḣ 텟Ṱ::ḡ 텟Ṱ::Ḟ 텟Ṱ::Ӭ 텟Ṱ::Ḏ 텟Ṱ::ᐊ 텟Ṱ::ḅ 텟Ṱ::ȼ) ]
), '... got the right C3 merge order for 텟Ṱ::Ḵ');

is(텟Ṱ::Ḵ->testmèth(), "right", 'next::method working ok');
