#!perl

use strict;
use warnings;

my @conf = <DATA>;
chomp @conf;

use Test::Perl::Critic
  q{-profile} => \@conf,
;
all_critic_ok();
__DATA__
# Integer or named level
# SEVERITY NAME   ...is equivalent to...   SEVERITY NUMBER
# --------------------------------------------------------
# -severity => 'gentle'                     -severity => 5
# -severity => 'stern'                      -severity => 4
# -severity => 'harsh'                      -severity => 3
# -severity => 'cruel'                      -severity => 2
# -severity => 'brutal'                     -severity => 1
severity  = brutal

# Only choose from Policies that are mentioned in the user's profile. Zero or One. Default: 0
only      = 0

# Don't care for ## annotation. Zero or One
force     = 0

#Integer or format spec (1-11)
verbose   = 11

#Max number of violation. A positive integer
top       = 1000

#A theme expression
##theme     = (pbp || security) && bugs

#Space-delimited list
##include   = NamingConventions ClassHierarchies

#Space-delimited list
##exclude   = Variables  Modules::RequirePackage
##exclude = ControlStructures::ProhibitPostfixControls

# Zero or One
#color     = 1

# Allow the use of Policies that are marked as "unsafe" by the author. Zero or One
allow-unsafe = 0

exclude = Documentation CodeLayout::RequireTidyCode Modules::RequireVersionVar Miscellanea::RequireRcsKeywords Editor::RequireEmacsFileVariables ErrorHandling::RequireUseOfExceptions ValuesAndExpressions::RequireConstantOnLeftSideOfEquality
