#!/usr/bin/env perl
use warnings;
use strict;
use Math::Trig;
use Test::More;
use HackaMol;           
use HackaMol::AtomGroup;

my $bldr = HackaMol->new();

LSQ_SLOPE: {
    my %qa_case = (
        zero => {
            slope => 0.0,
            ar    => [0,0,0,0,0,0],
        },
        zero1 => {
            slope => 0.0,
            ar    => [1,1,1,1,1,1],
        },
        zerom1 => {
            slope => 0.0,
            ar    => [-1,-1,-1,-1,-1,-1],
        },
        m1p1a  => {
            slope => 0.095238,
            ar    => [-1,1,-1,1,-1,1,-1,1],
        },
        m1p1b  => {
            slope => 0.060606,
            ar    => [-1,1,-1,1,-1,1,-1,1,-1,1],
        }
    );
    foreach my $case (sort keys %qa_case ) {
        my $slope_expect = $qa_case{$case}{slope};
        my $ar = $qa_case{$case}{ar};
        my $slope_calc = HackaMol::AtomGroup::_lsq_slope($ar);
        cmp_ok( abs($slope_calc-$slope_expect), '<', 1E-5, "_lsq_slope for $case"); 
    }
}


my $alpha1_5umo =
'ATOM    412  N   TYR A  62       0.675  16.784  33.186  1.00 50.92           N
ATOM    413  CA  TYR A  62      -0.733  16.383  33.253  1.00 51.52           C
ATOM    414  C   TYR A  62      -0.979  15.126  32.427  1.00 46.57           C
ATOM    415  O   TYR A  62      -1.769  14.281  32.824  1.00 43.23           O
ATOM    424  N   CYS A  63      -0.313  15.033  31.276  1.00 44.73           N
ATOM    425  CA  CYS A  63      -0.299  13.830  30.444  1.00 44.16           C
ATOM    426  C   CYS A  63       0.126  12.590  31.204  1.00 44.92           C
ATOM    427  O   CYS A  63      -0.430  11.510  30.990  1.00 41.78           O
ATOM    430  N   GLN A  64       1.119  12.751  32.074  1.00 47.60           N
ATOM    431  CA  GLN A  64       1.716  11.633  32.803  1.00 49.34           C
ATOM    432  C   GLN A  64       0.791  11.141  33.910  1.00 44.92           C
ATOM    433  O   GLN A  64       0.628   9.940  34.075  1.00 40.47           O
ATOM    439  N   ARG A  65       0.193  12.073  34.653  1.00 41.63           N
ATOM    440  CA  ARG A  65      -0.755  11.733  35.714  1.00 43.05           C
ATOM    441  C   ARG A  65      -2.040  11.119  35.152  1.00 40.17           C
ATOM    442  O   ARG A  65      -2.643  10.252  35.784  1.00 39.03           O
ATOM    450  N   THR A  66      -2.443  11.577  33.965  1.00 36.52           N
ATOM    451  CA  THR A  66      -3.644  11.101  33.285  1.00 33.36           C
ATOM    452  C   THR A  66      -3.489   9.659  32.833  1.00 30.38           C
ATOM    453  O   THR A  66      -4.377   8.870  33.065  1.00 31.08           O
ATOM    457  N   LEU A  67      -2.378   9.324  32.190  1.00 29.62           N
ATOM    458  CA  LEU A  67      -2.137   7.958  31.705  1.00 31.55           C
ATOM    459  C   LEU A  67      -1.993   6.966  32.870  1.00 33.23           C
ATOM    460  O   LEU A  67      -2.577   5.873  32.871  1.00 32.17           O
ATOM    465  N   ARG A  68      -1.207   7.381  33.856  1.00 35.07           N
ATOM    466  CA  ARG A  68      -0.908   6.600  35.057  1.00 34.88           C
ATOM    467  C   ARG A  68      -2.217   6.178  35.706  1.00 32.59           C
ATOM    468  O   ARG A  68      -2.447   4.997  35.944  1.00 31.20           O
ATOM    476  N   GLU A  69      -3.087   7.158  35.912  1.00 30.08           N
ATOM    477  CA  GLU A  69      -4.381   6.930  36.492  1.00 30.35           C
ATOM    478  C   GLU A  69      -5.278   6.049  35.638  1.00 30.18           C
ATOM    479  O   GLU A  69      -5.910   5.161  36.165  1.00 30.36           O
ATOM    485  N   ILE A  70      -5.354   6.316  34.336  1.00 30.47           N
ATOM    486  CA  ILE A  70      -6.197   5.521  33.429  1.00 30.75           C
ATOM    487  C   ILE A  70      -5.801   4.037  33.442  1.00 27.34           C
ATOM    488  O   ILE A  70      -6.667   3.194  33.552  1.00 25.37           O
ATOM    493  N   LYS A  71      -4.508   3.736  33.354  1.00 27.53           N
ATOM    494  CA  LYS A  71      -4.014   2.345  33.367  1.00 29.73           C
ATOM    495  C   LYS A  71      -4.403   1.588  34.643  1.00 29.21           C
ATOM    496  O   LYS A  71      -4.888   0.466  34.575  1.00 30.05           O
ATOM    502  N   ILE A  72      -4.182   2.213  35.796  1.00 28.18           N
ATOM    503  CA  ILE A  72      -4.456   1.572  37.079  1.00 28.31           C
ATOM    504  C   ILE A  72      -5.946   1.324  37.268  1.00 26.91           C
ATOM    505  O   ILE A  72      -6.336   0.215  37.601  1.00 26.07           O
ATOM    510  N   LEU A  73      -6.765   2.355  37.068  1.00 26.41           N
ATOM    511  CA  LEU A  73      -8.211   2.238  37.303  1.00 27.73           C
ATOM    512  C   LEU A  73      -8.920   1.227  36.371  1.00 28.40           C
ATOM    513  O   LEU A  73      -9.905   0.603  36.757  1.00 28.16           O
ATOM    518  N   LEU A  74      -8.413   1.084  35.157  1.00 29.34           N
ATOM    519  CA  LEU A  74      -8.907   0.088  34.208  1.00 32.00           C
ATOM    520  C   LEU A  74      -8.608  -1.346  34.629  1.00 33.77           C
ATOM    521  O   LEU A  74      -9.398  -2.247  34.346  1.00 32.79           O
ATOM    526  N   ARG A  75      -7.468  -1.563  35.282  1.00 35.36           N
ATOM    527  CA  ARG A  75      -7.136  -2.899  35.752  1.00 37.58           C
ATOM    528  C   ARG A  75      -7.725  -3.277  37.129  1.00 32.93           C
ATOM    529  O   ARG A  75      -7.877  -4.449  37.432  1.00 33.26           O';

my $alpha2_5umo = 
'ATOM    912  N   ASN A 121     -18.843   7.173  66.517  1.00 31.36           N
ATOM    913  CA  ASN A 121     -17.853   6.096  66.531  1.00 32.95           C
ATOM    914  C   ASN A 121     -18.151   4.959  65.550  1.00 32.30           C
ATOM    915  O   ASN A 121     -17.235   4.337  65.043  1.00 31.18           O
ATOM    920  N   ASP A 122     -19.424   4.700  65.279  1.00 32.63           N
ATOM    921  CA  ASP A 122     -19.822   3.688  64.308  1.00 32.34           C
ATOM    922  C   ASP A 122     -19.480   4.111  62.876  1.00 29.27           C
ATOM    923  O   ASP A 122     -19.053   3.287  62.080  1.00 25.96           O
ATOM    928  N   HIS A 123     -19.666   5.393  62.563  1.00 27.74           N
ATOM    929  CA  HIS A 123     -19.281   5.939  61.267  1.00 28.83           C
ATOM    930  C   HIS A 123     -17.766   5.951  61.061  1.00 25.59           C
ATOM    931  O   HIS A 123     -17.317   5.729  59.949  1.00 23.52           O
ATOM    938  N   ILE A 124     -17.009   6.267  62.113  1.00 23.87           N
ATOM    939  CA  ILE A 124     -15.546   6.312  62.038  1.00 23.57           C
ATOM    940  C   ILE A 124     -15.019   4.893  61.732  1.00 22.82           C
ATOM    941  O   ILE A 124     -14.196   4.711  60.829  1.00 21.01           O
ATOM    946  N   CYS A 125     -15.564   3.906  62.441  1.00 21.85           N
ATOM    947  CA  CYS A 125     -15.149   2.509  62.351  1.00 22.20           C
ATOM    948  C   CYS A 125     -15.367   1.936  60.949  1.00 21.84           C
ATOM    949  O   CYS A 125     -14.490   1.297  60.367  1.00 21.13           O
ATOM    952  N   TYR A 126     -16.557   2.187  60.434  1.00 21.41           N
ATOM    953  CA  TYR A 126     -16.985   1.722  59.142  1.00 21.86           C
ATOM    954  C   TYR A 126     -16.236   2.419  57.990  1.00 20.66           C
ATOM    955  O   TYR A 126     -15.865   1.759  57.019  1.00 20.28           O
ATOM    964  N   PHE A 127     -16.011   3.728  58.093  1.00 21.03           N
ATOM    965  CA  PHE A 127     -15.158   4.457  57.123  1.00 21.57           C
ATOM    966  C   PHE A 127     -13.721   3.950  57.114  1.00 18.93           C
ATOM    967  O   PHE A 127     -13.170   3.707  56.054  1.00 17.16           O
ATOM    975  N   LEU A 128     -13.129   3.782  58.292  1.00 18.51           N
ATOM    976  CA  LEU A 128     -11.790   3.198  58.397  1.00 18.84           C
ATOM    977  C   LEU A 128     -11.735   1.779  57.812  1.00 18.10           C
ATOM    978  O   LEU A 128     -10.803   1.445  57.086  1.00 16.79           O
ATOM    983  N   TYR A 129     -12.734   0.949  58.119  1.00 17.78           N
ATOM    984  CA  TYR A 129     -12.814  -0.389  57.517  1.00 17.38           C
ATOM    985  C   TYR A 129     -12.735  -0.321  55.995  1.00 16.85           C
ATOM    986  O   TYR A 129     -11.901  -0.976  55.365  1.00 16.11           O
ATOM    995  N   GLN A 130     -13.587   0.494  55.397  1.00 17.51           N
ATOM    996  CA  GLN A 130     -13.619   0.580  53.932  1.00 17.06           C
ATOM    997  C   GLN A 130     -12.319   1.134  53.289  1.00 16.35           C
ATOM    998  O   GLN A 130     -11.924   0.681  52.200  1.00 15.84           O
ATOM   1004  N   ILE A 131     -11.680   2.098  53.945  1.00 14.59           N
ATOM   1005  CA  ILE A 131     -10.378   2.587  53.508  1.00 14.80           C
ATOM   1006  C   ILE A 131      -9.348   1.447  53.459  1.00 14.67           C
ATOM   1007  O   ILE A 131      -8.705   1.254  52.453  1.00 14.44           O
ATOM   1012  N   LEU A 132      -9.195   0.727  54.568  1.00 15.26           N
ATOM   1013  CA  LEU A 132      -8.252  -0.404  54.691  1.00 15.54           C
ATOM   1014  C   LEU A 132      -8.582  -1.593  53.767  1.00 15.69           C
ATOM   1015  O   LEU A 132      -7.685  -2.243  53.236  1.00 15.13           O
ATOM   1020  N   ARG A 133      -9.863  -1.857  53.558  1.00 16.31           N
ATOM   1021  CA  ARG A 133     -10.286  -2.920  52.637  1.00 16.99           C
ATOM   1022  C   ARG A 133      -9.869  -2.570  51.206  1.00 16.42           C
ATOM   1023  O   ARG A 133      -9.333  -3.418  50.485  1.00 16.24           O
ATOM   1031  N   GLY A 134     -10.102  -1.317  50.807  1.00 15.79           N
ATOM   1032  CA  GLY A 134      -9.609  -0.820  49.539  1.00 15.49           C
ATOM   1033  C   GLY A 134      -8.085  -0.851  49.454  1.00 15.41           C
ATOM   1034  O   GLY A 134      -7.512  -1.284  48.451  1.00 14.49           O
ATOM   1035  N   LEU A 135      -7.440  -0.403  50.519  1.00 15.52           N
ATOM   1036  CA  LEU A 135      -5.986  -0.325  50.565  1.00 16.49           C
ATOM   1037  C   LEU A 135      -5.321  -1.698  50.543  1.00 16.29           C
ATOM   1038  O   LEU A 135      -4.260  -1.840  49.980  1.00 16.79           O
ATOM   1043  N   LYS A 136      -5.940  -2.700  51.161  1.00 16.41           N
ATOM   1044  CA  LYS A 136      -5.452  -4.076  51.095  1.00 15.99           C
ATOM   1045  C   LYS A 136      -5.342  -4.539  49.644  1.00 15.62           C
ATOM   1046  O   LYS A 136      -4.368  -5.182  49.262  1.00 14.89           O
ATOM   1052  N   TYR A 137      -6.360  -4.238  48.851  1.00 15.26           N
ATOM   1053  CA  TYR A 137      -6.363  -4.643  47.459  1.00 15.73           C
ATOM   1054  C   TYR A 137      -5.250  -3.917  46.654  1.00 15.55           C
ATOM   1055  O   TYR A 137      -4.493  -4.554  45.942  1.00 14.99           O
ATOM   1064  N   ILE A 138      -5.170  -2.598  46.804  1.00 15.80           N
ATOM   1065  CA  ILE A 138      -4.134  -1.749  46.172  1.00 16.13           C
ATOM   1066  C   ILE A 138      -2.748  -2.281  46.519  1.00 16.22           C
ATOM   1067  O   ILE A 138      -1.941  -2.473  45.638  1.00 16.11           O
ATOM   1072  N   HIS A 139      -2.490  -2.546  47.800  1.00 16.79           N
ATOM   1073  CA  HIS A 139      -1.183  -3.038  48.228  1.00 16.64           C
ATOM   1074  C   HIS A 139      -0.885  -4.476  47.767  1.00 16.38           C
ATOM   1075  O   HIS A 139       0.274  -4.791  47.519  1.00 14.91           O
ATOM   1082  N   SER A 140      -1.909  -5.331  47.637  1.00 16.71           N
ATOM   1083  CA  SER A 140      -1.710  -6.706  47.139  1.00 17.74           C
ATOM   1084  C   SER A 140      -1.280  -6.750  45.662  1.00 19.05           C
ATOM   1085  O   SER A 140      -0.682  -7.723  45.233  1.00 20.34           O';

my $helix_a = $bldr->read_string_mol($alpha1_5umo,'pdb');
my $helix_b = $bldr->read_string_mol($alpha2_5umo,'pdb');

# use the center and centered_vector to measure the dihedral between the 

my $center_a = $helix_a->center;
my $vec_a = $helix_a->centered_vector;
my $center_b = $helix_b->center;
my $vec_b = $helix_b->centered_vector;

my $ang = rad2deg(atan2( $vec_a, $vec_b));
cmp_ok(abs($ang - 94.651648) ,'<', 1E-6, 'Angle between helices');

done_testing();
