/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.KeyManager;

public final class DocumentPool
implements Serializable {
    private Map<DocumentURI, DocumentInfo> documentNameMap = new HashMap<DocumentURI, DocumentInfo>(10);
    private Set<DocumentURI> unavailableDocuments = new HashSet<DocumentURI>(10);

    public void add(DocumentInfo doc, String uri) {
        if (uri != null) {
            this.documentNameMap.put(new DocumentURI(uri), doc);
        }
    }

    public void add(DocumentInfo doc, DocumentURI uri) {
        if (uri != null) {
            this.documentNameMap.put(uri, doc);
        }
    }

    public DocumentInfo find(String uri) {
        return this.documentNameMap.get(new DocumentURI(uri));
    }

    public DocumentInfo find(DocumentURI uri) {
        return this.documentNameMap.get(uri);
    }

    public String getDocumentURI(NodeInfo doc) {
        for (DocumentURI uri : this.documentNameMap.keySet()) {
            if (!this.find(uri).isSameNodeInfo(doc)) continue;
            return uri.toString();
        }
        return null;
    }

    public boolean contains(DocumentInfo doc) {
        return this.documentNameMap.values().contains(doc);
    }

    public DocumentInfo discard(DocumentInfo doc) {
        for (Map.Entry<DocumentURI, DocumentInfo> e : this.documentNameMap.entrySet()) {
            DocumentURI name = e.getKey();
            DocumentInfo entry = e.getValue();
            if (!entry.isSameNodeInfo(doc)) continue;
            this.documentNameMap.remove(name);
            return doc;
        }
        return doc;
    }

    public void discardIndexes(KeyManager keyManager) {
        for (DocumentInfo doc : this.documentNameMap.values()) {
            keyManager.clearDocumentIndexes(doc);
        }
    }

    public void markUnavailable(DocumentURI uri) {
        this.unavailableDocuments.add(uri);
    }

    public boolean isMarkedUnavailable(DocumentURI uri) {
        return this.unavailableDocuments.contains(uri);
    }
}

