package WARC::Collection;					# -*- CPerl -*-

use strict;
use warnings;

our @ISA = qw();

require WARC; *WARC::Collection::VERSION = \$WARC::VERSION;

require WARC::Volume;

=head1 NAME

WARC::Collection - Interface to a group of WARC files

=head1 SYNOPSIS

  use WARC::Collection;

  $collection = assemble WARC::Collection ($index_1, $index_2, ...);
  $collection = assemble WARC::Collection from => ($index_1, ...);

  $record = $collection->search(url => $url, time => $when);

=head1 DESCRIPTION

The C<WARC::Collection> class is the primary means by which user code is
expected to use the WARC library.  This class uses indexes to efficiently
search for records in one or more WARC files.

=head2 Search Keys

The C<search> method accepts a list of parameters as I<key> =E<gt> I<value>
pairs with each pair narrowing the search, sorting the results, or both,
indicated in the following list with "C<[N ]>", "C<[ S]>", or "C<[NS]>",
respectively.

The same search keys documented here are used for searching indexes, since
C<WARC::Collection> is a wrapper around one or more indexes.

The keys supported are:

=over

=item C<[N ]> url

An exact match for a URL.

=item C<[NS]> url_prefix

A prefix match for a URL.  Prefers records with shorter URLs.

=item C<[ S]> time

Prefer records collected nearer to the requested time.

=back

=head2 Methods

=over

=item $collection = assemble WARC::Collection ($index_1, $index_2, ...);

=item $collection = assemble WARC::Collection from =E<gt> ($index_1, ...);

Assemble a collection of WARC files from one index or multiple indexes,
specified either as objects derived from C<WARC::Index> or filenames.

While multiple indexes can be used in a collection, note that searching a
collection requires individually searching every index in the collection.

=cut

sub assemble {
}

=item $record = $collection-E<gt>search( ... )

=item @records = $collection-E<gt>search( ... )

Search the index for records matching the parameters and return the best
match in scalar context or a list of all matches in list context.  The
returned values are C<WARC::Record> objects.

See L</"Search Keys"> for more information about the parameters.

=cut

sub search {
}

=back

=cut

1;
__END__

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
