package Daje::Plugin::Workflow;
use Mojo::Base 'Mojolicious::Plugin', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Plugin::Workflow - It's new $module
#
# SYNOPSIS
# ========
#
#     use Daje::Plugin::Workflow;
#
#     Expected config data
#
#     workflow => {
#         loader => {
#             path => '/home/xxxx/Project/Workflows',
#             type => 'workflow'
#         }
#     }
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::Workflow is the Mojolicious plugin for Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.13";

use Daje::Workflow::Database;
use Daje::Workflow::Loader;
use Daje::Workflow;

sub register ($self, $app, $config) {

    $app->log->debug("Daje::Plugin::Workflow::register starts");
    my $loader;
    try { # '/home/jan/Project/Daje-Workflow-Workflows/Workflows'
        $loader = Daje::Workflow::Loader->new(
            path => $app->config('workflow')->{loader}->{path},
            type => $app->config('workflow')->{loader}->{type},
        );
        $loader->load();
    } catch ($e) {
        $app->log->error($e);
    };

    my $workflow;
    try {
        $workflow = Daje::Workflow->new(
            pg     => $app->pg,
            loader => $loader->loader,
        );
    } catch ($e) {
        $app->log->error($e);
    };

    $app->helper(workflow => sub {$workflow});

    my $r = $app->routes;
    $r->put('/workflow/api/execute')->to('Workflow#execute');

    $app->log->debug("Daje::Plugin::Workflow registered");
}





1;

__END__







#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Plugin::workflow - It's new $module



=head1 SYNOPSIS


    use Daje::Plugin::workflow;

    Expected config data

    workflow => {
        loader => {
            path => '/home/xxxx/Project/Workflows',
            type => 'workflow'
        }
    }



=head1 DESCRIPTION


Daje::Plugin::workflow is the Mojolicious plugin for Daje::Workflow



=head1 REQUIRES

L<Daje::Plugin::workflow> 

L<Daje::Workflow> 

L<Daje::Workflow::Loader> 

L<Daje::Workflow::Database> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 register

 register();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

