package Compiler::Lexer::TokenType;
use strict;
use warnings;
use constant {
    T_Return => 0,
    T_Add => 1,
    T_Sub => 2,
    T_Mul => 3,
    T_Div => 4,
    T_Mod => 5,
    T_ThreeTermOperator => 6,
    T_Greater => 7,
    T_Less => 8,
    T_StringAdd => 9,
    T_Ref => 10,
    T_Glob => 11,
    T_BitNot => 12,
    T_BitOr => 13,
    T_Or => 14,
    T_BitAnd => 15,
    T_And => 16,
    T_BitXOr => 17,
    T_XOr => 18,
    T_StringMul => 19,
    T_AddEqual => 20,
    T_SubEqual => 21,
    T_MulEqual => 22,
    T_DivEqual => 23,
    T_ModEqual => 24,
    T_GreaterEqual => 25,
    T_LessEqual => 26,
    T_EqualEqual => 27,
    T_Diamond => 28,
    T_Compare => 29,
    T_PolymorphicCompare => 30,
    T_RegOK => 31,
    T_RegNot => 32,
    T_NotEqual => 33,
    T_ArraySize => 34,
    T_StringLess => 35,
    T_StringLessEqual => 36,
    T_StringGreater => 37,
    T_StringGreaterEqual => 38,
    T_StringEqual => 39,
    T_StringNotEqual => 40,
    T_StringCompare => 41,
    T_Inc => 42,
    T_Dec => 43,
    T_Exp => 44,
    T_PowerEqual => 45,
    T_DefaultEqual => 46,
    T_LeftShift => 47,
    T_RightShift => 48,
    T_AndBitEqual => 49,
    T_OrBitEqual => 50,
    T_NotBitEqual => 51,
    T_OrEqual => 52,
    T_AndEqual => 53,
    T_Slice => 54,
    T_DefaultOperator => 55,
    T_ToDo => 56,
    T_VarDecl => 57,
    T_FunctionDecl => 58,
    T_Method => 59,
    T_Assign => 60,
    T_Is => 61,
    T_IsNot => 62,
    T_Not => 63,
    T_BuiltinFunc => 64,
    T_RequireDecl => 65,
    T_Import => 66,
    T_SpecificKeyword => 67,
    T_DataWord => 68,
    T_ModWord => 69,
    T_AUTOLOAD => 70,
    T_CORE => 71,
    T_DESTROY => 72,
    T_STDIN => 73,
    T_STDOUT => 74,
    T_STDERR => 75,
    T_Redo => 76,
    T_Next => 77,
    T_Last => 78,
    T_Goto => 79,
    T_Continue => 80,
    T_Do => 81,
    T_Break => 82,
    T_Handle => 83,
    T_LocalDecl => 84,
    T_OurDecl => 85,
    T_StateDecl => 86,
    T_UseDecl => 87,
    T_UsedName => 88,
    T_IfStmt => 89,
    T_ElseStmt => 90,
    T_ElsifStmt => 91,
    T_UnlessStmt => 92,
    T_UntilStmt => 93,
    T_WhenStmt => 94,
    T_GivenStmt => 95,
    T_DefaultStmt => 96,
    T_Comma => 97,
    T_Colon => 98,
    T_SemiColon => 99,
    T_LeftParenthesis => 100,
    T_RightParenthesis => 101,
    T_LeftBrace => 102,
    T_RightBrace => 103,
    T_LeftBracket => 104,
    T_RightBracket => 105,
    T_ArrayDereference => 106,
    T_HashDereference => 107,
    T_ScalarDereference => 108,
    T_ShortScalarDereference => 109,
    T_ShortArrayDereference => 110,
    T_ShortHashDereference => 111,
    T_ShortCodeDereference => 112,
    T_ArraySizeDereference => 113,
    T_Key => 114,
    T_BareWord => 115,
    T_Arrow => 116,
    T_Pointer => 117,
    T_NamespaceResolver => 118,
    T_Namespace => 119,
    T_Package => 120,
    T_Class => 121,
    T_CallDecl => 122,
    T_CodeRef => 123,
    T_WhileStmt => 124,
    T_ForStmt => 125,
    T_ForeachStmt => 126,
    T_Annotation => 127,
    T_ArgumentArray => 128,
    T_SpecificValue => 129,
    T_ConstValue => 130,
    T_ProgramArgument => 131,
    T_LibraryDirectories => 132,
    T_Environment => 133,
    T_Include => 134,
    T_Signal => 135,
    T_RegOpt => 136,
    T_RegQuote => 137,
    T_RegDoubleQuote => 138,
    T_RegList => 139,
    T_RegExec => 140,
    T_RegDecl => 141,
    T_RegMatch => 142,
    T_RegDelim => 143,
    T_RegMiddleDelim => 144,
    T_RegAllReplace => 145,
    T_RegReplace => 146,
    T_RegReplaceFrom => 147,
    T_RegReplaceTo => 148,
    T_FieldDecl => 149,
    T_TypeRef => 150,
    T_LabelRef => 151,
    T_LocalVarDecl => 152,
    T_GlobalVarDecl => 153,
    T_MultiLocalVarDecl => 154,
    T_MultiGlobalVarDecl => 155,
    T_Prototype => 156,
    T_Var => 157,
    T_CodeVar => 158,
    T_ArrayVar => 159,
    T_HashVar => 160,
    T_Int => 161,
    T_Double => 162,
    T_String => 163,
    T_RawString => 164,
    T_ExecString => 165,
    T_VersionString => 166,
    T_HereDocumentTag => 167,
    T_HereDocumentRawTag => 168,
    T_RawHereDocument => 169,
    T_HereDocument => 170,
    T_HereDocumentEnd => 171,
    T_FormatDecl => 172,
    T_Format => 173,
    T_FormatEnd => 174,
    T_Object => 175,
    T_RegExp => 176,
    T_Array => 177,
    T_Hash => 178,
    T_Operator => 179,
    T_LocalVar => 180,
    T_LocalArrayVar => 181,
    T_LocalHashVar => 182,
    T_GlobalVar => 183,
    T_GlobalArrayVar => 184,
    T_GlobalHashVar => 185,
    T_ArrayRef => 186,
    T_HashRef => 187,
    T_ArrayAt => 188,
    T_HashAt => 189,
    T_ArraySet => 190,
    T_HashSet => 191,
    T_Function => 192,
    T_Call => 193,
    T_Argument => 194,
    T_List => 195,
    T_Default => 196,
    T_Undefined => 197
};
1;

package Compiler::Lexer::SyntaxType;
use strict;
use warnings;
use constant {
    T_Value     => 0,
    T_Term      => 1,
    T_Expr      => 2,
    T_Stmt      => 3,
    T_BlockStmt => 4
};
1;

package Compiler::Lexer::Kind;
use strict;
use warnings;
use constant {
    T_Return => 0,
    T_Operator => 1,
    T_Assign => 2,
    T_Decl => 3,
    T_Function => 4,
    T_SingleTerm => 5,
    T_Import => 6,
    T_SpecificKeyword => 7,
    T_DataWord => 8,
    T_ModWord => 9,
    T_AUTOLOAD => 10,
    T_CORE => 11,
    T_DESTROY => 12,
    T_Handle => 13,
    T_Redo => 14,
    T_Next => 15,
    T_Last => 16,
    T_Goto => 17,
    T_Continue => 18,
    T_Do => 19,
    T_Break => 20,
    T_Term => 21,
    T_Stmt => 22,
    T_DefaultStmt => 23,
    T_Comma => 24,
    T_Colon => 25,
    T_StmtEnd => 26,
    T_Symbol => 27,
    T_Modifier => 28,
    T_Namespace => 29,
    T_Package => 30,
    T_Class => 31,
    T_Annotation => 32,
    T_RegOpt => 33,
    T_RegPrefix => 34,
    T_RegReplacePrefix => 35,
    T_Ref => 36,
    T_Get => 37,
    T_Set => 38,
    T_Undefined => 39
};
1;
