!ru:en
# NAME

liveman - «живое руководство». Утилита для конвертации файлов **lib/\*\*.md** в тестовые файлы (**t/\*\*.t**) и документацию (**POD**), которая размещается в соответствующем модуле (**lib/\*\*.pm**)

# SYNOPSIS

```sh
liveman [-h] [--man] [-A pkg [license]] [-w] [-o][-c][-f][-s][-a] [<files> ...]
```

# DESCRIPTION

Проблема современных проектов в том, что документация отделена от тестирования.
Это означает, что примеры в документации могут не работать, а сама документация может отставать от кода.

Метод одновременного документирования и тестирования решает эту проблему.

Для документации был выбран формат **md**, поскольку он наиболее прост для ввода и широко распространён.
Описанные в нем участки кода **perl** транслируются в тест. Документация переводится в **POD** и добавляется в раздел **\__END__** модуля perl.

Другими словами, **liveman** конвертирует **lib/\*\*.md**-файлы в тестовые файлы (**t/\*\*.t**) и документацию, которая помещается в соответствующую **lib/\*\*.pm** модуль. И сразу запускает тесты с покрытием.

Покрытие можно просмотреть в файле *cover_db/coverage.html*.

**Примечание:** лучше сразу поместить *cover_db/* в *.gitignore*.

# OPTIONS

**-h**, **--help**

Показать справку и выйти.

**-v**, **--version**

Показать версию и выйти.

```perl
`perl $ENV{PROJECT_DIR}/script/liveman -v` # ~> ^\d+\.\d+$
```

**--man**

Распечатать инструкцию и завершиться.

**-c**, **--compile**

Только компилировать (без запуска тестов).

**-f**, **--force**

Преобразовать файлы *lib/\*\*.md*, даже если они не изменились.

**-p**, **--prove**

Использовать для тестов утилиту `prove`, а не `yath`.

**-o**, **--open**

Открыть покрытие в браузере.

**-O**, **--options** OPTIONS

Передать строку с опциями `yath` или `prove`. Эти параметры будут добавлены к параметрам по умолчанию.

Параметры по умолчанию для `yath`:

    `yath test -j4 --cover`

Параметры по умолчанию для `prove`:

    `prove -Ilib -r t`

**-а**, **--append**

Добавить разделы функций в `*.md` из `*.pm` и завершиться.

**-A**, **--new** PACKAGE \[LICENSE]

Создать новый репозиторий.

* *PACKAGE* — это имя нового пакета, например, `Aion::View`.
* *LICENSE* — это имя лицензии, например, GPLv3 или perl_5.

**-D**, **--cpanfile**

Распечатать примерный cpanfile.

**-d**, **--diff-cpanfile** [meld]

Сравнить примерный cpanfile с существующим. Если параметр не указан – используется `meld`. В качестве альтернативы можно использовать `diff`, `colordiff`, `wdiff`, `kompare`, `kdiff3`, `tkdiff`, `diffuse` или любую другую утилиту, которая принимает два файла в качестве аргументов.

# INSTALL

Чтобы установить этот модуль в вашу систему, выполните следующую [команду](https://metacpan.org/pod/App::cpm):

```sh
sudo cpm install -gvv Liveman
```

# AUTHOR

Yaroslav O. Kosmina <mailto:dart@cpan.org>

# LICENSE

⚖ **GPLv3**

# COPYRIGHT

The App::liveman module is copyright © 2024 Yaroslav O. Kosmina. Rusland. All rights reserved.
