#!/usr/bin/perl -w

use strict;
use warnings;

use Lingua::DE::ASCII;
use Test::More tests => 1;

use strict;
use warnings;
use diagnostics;

my $non_ascii_chars = join("", map {chr} (128..255));

while (<DATA>) {
    chomp;
    print STDERR "." if ($. % 5_000) == 1;
    $_ eq to_latin1(to_ascii($_)) or diag("$_ => " . to_latin1(to_ascii($_))),fail,exit;
}

ok("Words with ae could be translated without errors");

1;

__DATA__
Aloe
Aloen
Apnoe
Ausdehnungskoeffizient
Ausdehnungskoeffizienten
Autoerotik
Benzoe
Benzoeharz
Benzoeharzes
Benzoesure
Binomialkoeffizient
Binomialkoeffizients
Binominalkoeffizienten
Bioethik
Bioethiker
Bioethikern
Bioethikers
Boeing
Boeings
Bruttoeinkommen
Bruttoeinkommens
Bruttoertrag
Bruttoertrags
Bruttoertrge
Bruttoertrgen
Coeur
Coeurs
Dr. oec. publ.
Dr. rer. oec.
Dr. rer. soc. oec.
Elektroenzephalogramm
Elektroenzephalogramme
Elektroenzephalogrammen
Elektroenzephalogramms
Fotoeffekt
Fotoeffekte
Fotoeffekten
Fotoeffektes
Fotoelektrizitt
Fotoelektrizitten
Fotoelektron
Fotoelektronen
Fotoelektrons
Fotoelement
Fotoelemente
Fotoelementen
Fotoelements
Gastroenterologe
Gastroenterologen
Gastroenterologie
Gastroenterologin
Gastroenterologinnen
Goethe
Goethe-Band
Goethe-Bandes
Goethe-Bnde
Goethe-Bnden
Goethe-Haus
Goethe-Hauses
Goethe-und-Schiller-Denkmal
Goethe-und-Schiller-Denkmales
Goetheanum
Goetheanums
Goetheband
Goethebandes
Goethebnde
Goethebnden
Goethefreundliche
Goethefreundlichem
Goethefreundlichen
Goethefreundlicher
Goethefreundliches
Goethehaus
Goethehauses
Goethes
Goethestadt
Goethestdte
Goethestdten
Haloeffekt
Haloeffekte
Haloeffekten
Haloeffekts
Heroe
Heroen
Heroenkult
Heroenkulte
Heroenkulten
Heroenkultes
Heroenkultus
Heroenkultusses
Hoek van Holland
Hoek van Hollands
Homoerotik
Homoerotische
Homoerotischem
Homoerotischen
Homoerotischer
Homoerotischere
Homoerotischerem
Homoerotischeren
Homoerotischerer
Homoerotischeres
Homoerotisches
Homoerotischste
Homoerotischstem
Homoerotischsten
Homoerotischster
Homoerotischstes
Hydrozoen
Hmatozoen
Indoeuroper
Indoeuropern
Indoeuropers
Itzehoe
Itzehoer
Itzehoern
Itzehoers
Itzehoes
Joel
Joels
Kairoer
Kairoerin
Kairoerinnen
Kairoern
Kairoers
Koedukation
Koeffizient
Koeffizienten
Koerzitivfeldstrke
Koexistente
Koexistentem
Koexistenten
Koexistenter
Koexistentes
Koexistenz
Koexistenzen
Koexistieren
Koexistierende
Koexistierendem
Koexistierenden
Koexistierender
Koexistierendes
Koexistierens
Koexistierte
Koexistiertem
Koexistierten
Koexistierter
Koexistiertes
Metazoen
Mikroelektronik
Nettoeinkommen
Nettoeinkommens
Nettoertrag
Nettoertrags
Nettoertrge
Nettoertrgen
Oboe
Oboen
Osloer
Osloern
Osloers
Photoeffekt
Photoeffekte
Photoeffekten
Photoeffekts
Photoelektrizitt
Photoelektron
Photoelektronen
Photoelektrons
Photoelement
Photoelemente
Photoelementen
Photoelements
Piezoelektrizitt
Poebene
Poem
Poeme
Poemen
Poems
Poesie
Poesiealben
Poesiealbum
Poesiealbums
Poesielose
Poesielosem
Poesielosen
Poesieloser
Poesielosere
Poesieloserem
Poesieloseren
Poesieloserer
Poesieloseres
Poesieloses
Poesieloseste
Poesielosestem
Poesielosesten
Poesielosester
Poesielosestes
Poesielosigkeit
Poesielosigkeiten
Poesien
Poet
Poetaster
Poetastern
Poetasters
Poeten
Poetik
Poetiken
Poetin
Poetinnen
Poetische
Poetischem
Poetischen
Poetischer
Poetischere
Poetischerem
Poetischeren
Poetischerer
Poetischeres
Poetisches
Poetischste
Poetischstem
Poetischsten
Poetischster
Poetischstes
Poetisieren
Poetisierende
Poetisierendem
Poetisierenden
Poetisierender
Poetisierendes
Poetisierens
Poetisierte
Poetisiertem
Poetisierten
Poetisierter
Poetisiertes
Proenzym
Proenzyme
Proenzymen
Proenzyms
Protoevangelium
Protoevangeliums
Protozoen
Radioelement
Radioelemente
Radioelementen
Radioelementes
Rhomboeder
Rhomboedern
Rhomboeders
Robinson Crusoe
Robinson Crusoes
Spannungskoeffizient
Spannungskoeffizienten
Spermatozoen
Spiroergometer
Spiroergometern
Spiroergometers
Sporozoen
Stereoempfang
Stereoempfangs
Streuungskoeffizient
Streuungskoeffizienten
Thermoelektrizitt
Thermoelement
Thermoelemente
Thermoelementen
Thermoelements
Togoer
Togoerin
Togoerinnen
Togoern
Togoers
Tokioer
Tokioern
Tokioers
Totoergebnis
Totoergebnisse
Totoergebnissen
Totoergebnisses
Trapezoeder
Trapezoedern
Trapezoeders
Unpoetische
Unpoetischem
Unpoetischen
Unpoetischer
Unpoetischere
Unpoetischerem
Unpoetischeren
Unpoetischerer
Unpoetischeres
Unpoetisches
Unpoetischste
Unpoetischstem
Unpoetischsten
Unpoetischster
Unpoetischstes
Zoe
autoerotisch
autoerotische
autoerotischem
autoerotischen
autoerotischer
autoerotisches
goethefreundlich
goethefreundliche
goethefreundlichem
goethefreundlichen
goethefreundlicher
goethefreundliches
goethesch
goethesche
goetheschem
goetheschen
goethescher
goethesches
goethisch
goethische
goethischem
goethischen
goethischer
goethisches
homoerotisch
homoerotische
homoerotischem
homoerotischen
homoerotischer
homoerotischere
homoerotischerem
homoerotischeren
homoerotischerer
homoerotischeres
homoerotisches
homoerotischste
homoerotischstem
homoerotischsten
homoerotischster
homoerotischstes
indoeuropisch
indoeuropische
indoeuropischem
indoeuropischen
indoeuropischer
indoeuropisches
koexistent
koexistente
koexistentem
koexistenten
koexistenter
koexistentes
koexistiere
koexistieren
koexistierend
koexistierende
koexistierendem
koexistierenden
koexistierender
koexistierendes
koexistierest
koexistieret
koexistierst
koexistiert
koexistierte
koexistiertem
koexistierten
koexistierter
koexistiertes
koexistiertest
koexistiertet
mikroelektronisch
mikroelektronische
mikroelektronischem
mikroelektronischen
mikroelektronischer
mikroelektronisches
piezoelektrisch
piezoelektrische
piezoelektrischem
piezoelektrischen
piezoelektrischer
piezoelektrisches
poesielos
poesielose
poesielosem
poesielosen
poesieloser
poesielosere
poesieloserem
poesieloseren
poesieloserer
poesieloseres
poesieloses
poesieloseste
poesielosestem
poesielosesten
poesielosester
poesielosestes
poetisch
poetische
poetischem
poetischen
poetischer
poetischere
poetischerem
poetischeren
poetischerer
poetischeres
poetisches
poetischste
poetischstem
poetischsten
poetischster
poetischstes
poetisiere
poetisieren
poetisierend
poetisierende
poetisierendem
poetisierenden
poetisierender
poetisierendes
poetisierest
poetisieret
poetisierst
poetisiert
poetisierte
poetisiertem
poetisierten
poetisierter
poetisiertes
poetisiertest
poetisiertet
soeben
thermoelektrisch
thermoelektrische
thermoelektrischem
thermoelektrischen
thermoelektrischer
thermoelektrisches
unpoetisch
unpoetische
unpoetischem
unpoetischen
unpoetischer
unpoetischere
unpoetischerem
unpoetischeren
unpoetischerer
unpoetischeres
unpoetisches
unpoetischste
unpoetischstem
unpoetischsten
unpoetischster
unpoetischstes
