=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::TextFrameFormat;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ParagraphFormat;
use AsposeSlidesCloud::Object::ThreeDFormat;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Contains the TextFrame&#39;s formatting properties.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut
#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# return perl hash
sub to_hash {
    return decode_json(JSON->new->convert_blessed->encode( shift ));
}

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use swagger_types to deserialize the data
    my $current_types = {};
    while ( my ($_key, $_type) = each %{$self->swagger_types} ) {
        $current_types->{$_key} = $_type;
    }
    while ( my ($_key, $_type) = each %{$current_types} ) {
    	my $_json_attribute = $self->attribute_map->{$_key}; 
        if ($_type =~ /^array\[/i) { # array
            my $_subclass = substr($_type, 6, -1);
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                if (defined $_element) {
                    push @_array, $self->_deserialize($_subclass, $_element);
                } else {
                    push @_array, undef;
                }
            }
            foreach my $_element (@{$hash->{lcfirst($_json_attribute)}}) {
                if (defined $_element) {
                    push @_array, $self->_deserialize(lcfirst($_subclass), $_element);
                } else {
                    push @_array, undef;
                }
            }
            $self->{$_key} = \@_array;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute});
        } elsif (exists $hash->{lcfirst($_json_attribute)}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{lcfirst($_json_attribute)});
        }
    }
  
    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data) = @_;
        
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $class = AsposeSlidesCloud::ClassRegistry->get_class_name(ucfirst($type), $data);
        my $_instance = use_module("AsposeSlidesCloud::Object::$class")->new();
        return $_instance->from_hash($data);
    }
}



__PACKAGE__->class_documentation({description => 'Contains the TextFrame&#39;s formatting properties.',
                                  class => 'TextFrameFormat',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'three_d_format' => {
    	datatype => 'ThreeDFormat',
    	base_name => 'ThreeDFormat',
    	description => 'Represents 3d effect properties for a text.',
    	format => '',
    	read_only => '',
    		},
    'transform' => {
    	datatype => 'string',
    	base_name => 'Transform',
    	description => 'Gets or sets text wrapping shape.',
    	format => '',
    	read_only => '',
    		},
    'margin_left' => {
    	datatype => 'double',
    	base_name => 'MarginLeft',
    	description => 'Left margin. Left margin.',
    	format => '',
    	read_only => '',
    		},
    'margin_right' => {
    	datatype => 'double',
    	base_name => 'MarginRight',
    	description => 'Right margin.',
    	format => '',
    	read_only => '',
    		},
    'margin_top' => {
    	datatype => 'double',
    	base_name => 'MarginTop',
    	description => 'Top margin.',
    	format => '',
    	read_only => '',
    		},
    'margin_bottom' => {
    	datatype => 'double',
    	base_name => 'MarginBottom',
    	description => 'Bottom margin.',
    	format => '',
    	read_only => '',
    		},
    'wrap_text' => {
    	datatype => 'string',
    	base_name => 'WrapText',
    	description => 'True if text is wrapped at TextFrame&#39;s margins.',
    	format => '',
    	read_only => '',
    		},
    'anchoring_type' => {
    	datatype => 'string',
    	base_name => 'AnchoringType',
    	description => 'Returns or sets vertical anchor text in a TextFrame.',
    	format => '',
    	read_only => '',
    		},
    'center_text' => {
    	datatype => 'string',
    	base_name => 'CenterText',
    	description => 'If True then text should be centered in box horizontally.',
    	format => '',
    	read_only => '',
    		},
    'text_vertical_type' => {
    	datatype => 'string',
    	base_name => 'TextVerticalType',
    	description => 'Determines text orientation. The resulted value of visual text rotation summarized from this property and custom angle in property RotationAngle.',
    	format => '',
    	read_only => '',
    		},
    'autofit_type' => {
    	datatype => 'string',
    	base_name => 'AutofitType',
    	description => 'Returns or sets text&#39;s auto-fit mode.',
    	format => '',
    	read_only => '',
    		},
    'column_count' => {
    	datatype => 'int',
    	base_name => 'ColumnCount',
    	description => 'Returns or sets number of columns in the text area. This value must be a positive number. Otherwise, the value will be set to zero.  Value 0 means undefined value.',
    	format => '',
    	read_only => '',
    		},
    'column_spacing' => {
    	datatype => 'double',
    	base_name => 'ColumnSpacing',
    	description => 'Returns or sets the space between text columns in the text area (in points). This should only apply  when there is more than 1 column present. This value must be a positive number. Otherwise, the value will be set to zero. ',
    	format => '',
    	read_only => '',
    		},
    'keep_text_flat' => {
    	datatype => 'boolean',
    	base_name => 'KeepTextFlat',
    	description => 'Returns or set keeping text out of 3D scene entirely.',
    	format => '',
    	read_only => '',
    		},
    'rotation_angle' => {
    	datatype => 'double',
    	base_name => 'RotationAngle',
    	description => 'Specifies the custom rotation that is being applied to the text within the bounding box.',
    	format => '',
    	read_only => '',
    		},
    'default_paragraph_format' => {
    	datatype => 'ParagraphFormat',
    	base_name => 'DefaultParagraphFormat',
    	description => 'Default portion format.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'three_d_format' => 'ThreeDFormat',
    'transform' => 'string',
    'margin_left' => 'double',
    'margin_right' => 'double',
    'margin_top' => 'double',
    'margin_bottom' => 'double',
    'wrap_text' => 'string',
    'anchoring_type' => 'string',
    'center_text' => 'string',
    'text_vertical_type' => 'string',
    'autofit_type' => 'string',
    'column_count' => 'int',
    'column_spacing' => 'double',
    'keep_text_flat' => 'boolean',
    'rotation_angle' => 'double',
    'default_paragraph_format' => 'ParagraphFormat'
} );

__PACKAGE__->attribute_map( {
    'three_d_format' => 'ThreeDFormat',
    'transform' => 'Transform',
    'margin_left' => 'MarginLeft',
    'margin_right' => 'MarginRight',
    'margin_top' => 'MarginTop',
    'margin_bottom' => 'MarginBottom',
    'wrap_text' => 'WrapText',
    'anchoring_type' => 'AnchoringType',
    'center_text' => 'CenterText',
    'text_vertical_type' => 'TextVerticalType',
    'autofit_type' => 'AutofitType',
    'column_count' => 'ColumnCount',
    'column_spacing' => 'ColumnSpacing',
    'keep_text_flat' => 'KeepTextFlat',
    'rotation_angle' => 'RotationAngle',
    'default_paragraph_format' => 'DefaultParagraphFormat'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
