import io
from _typeshed import ReadableBuffer
from typing import Any, Literal, NoReturn
from typing_extensions import TypeAlias

cERROR_PIPE_BUSY: int
cSECURITY_SQOS_PRESENT: int
cSECURITY_ANONYMOUS: int
MAXIMUM_RETRY_COUNT: int

def check_closed(f): ...

_PyHANDLE: TypeAlias = Any  # pywin32._win32typing.PyHANDLE

class NpipeSocket:
    def __init__(self, handle: _PyHANDLE | None = None) -> None: ...
    def accept(self) -> None: ...
    def bind(self, address) -> None: ...
    def close(self) -> None: ...
    flags: int
    def connect(self, address: str, retry_count: int = 0) -> None: ...
    def connect_ex(self, address: str) -> None: ...
    def detach(self) -> _PyHANDLE | None: ...
    def dup(self) -> NpipeSocket: ...
    def getpeername(self) -> str: ...
    def getsockname(self) -> str: ...
    # NotImplementedError
    def getsockopt(self, level, optname, buflen=None) -> NoReturn: ...
    # NotImplementedError
    def ioctl(self, control, option) -> NoReturn: ...
    # NotImplementedError
    def listen(self, backlog) -> NoReturn: ...
    def makefile(self, mode: str | None = None, bufsize: int | None = None) -> io.BufferedReader: ...
    def recv(self, bufsize: int, flags: int = 0) -> str: ...
    def recvfrom(self, bufsize: int, flags: int = 0) -> tuple[str, str]: ...
    def recvfrom_into(self, buf: memoryview | ReadableBuffer, nbytes: int = 0, flags: int = 0) -> tuple[int, str]: ...
    def recv_into(self, buf: memoryview | ReadableBuffer, nbytes: int = 0) -> int: ...
    def send(self, string: str, flags: int = 0) -> int: ...
    def sendall(self, string: str, flags: int = 0) -> int: ...
    def sendto(self, string: str, address: str) -> int: ...
    def setblocking(self, flag: bool) -> None: ...
    def settimeout(self, value: float | None) -> None: ...
    def gettimeout(self) -> int | None: ...
    # NotImplementedError
    def setsockopt(self, level, optname, value) -> NoReturn: ...
    def shutdown(self, how) -> None: ...

class NpipeFileIOBase(io.RawIOBase):
    sock: NpipeSocket
    def __init__(self, npipe_socket: NpipeSocket) -> None: ...
    def close(self) -> None: ...
    def fileno(self): ...
    def isatty(self) -> Literal[False]: ...
    def readable(self) -> Literal[True]: ...
    def readinto(self, buf: memoryview | ReadableBuffer) -> int: ...
    def seekable(self) -> Literal[False]: ...
    def writable(self) -> Literal[False]: ...
