/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.List;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.ISkinParam;

public class AreaRenderer {
    private final ISkinParam skinParam;
    private final double plotWidth;
    private final double plotHeight;
    private final int categoryCount;
    private final ChartAxis axis;

    public AreaRenderer(ISkinParam skinParam, double plotWidth, double plotHeight, int categoryCount, ChartAxis axis) {
        this.skinParam = skinParam;
        this.plotWidth = plotWidth;
        this.plotHeight = plotHeight;
        this.categoryCount = categoryCount;
        this.axis = axis;
    }

    public void draw(UGraphic ug, ChartSeries series, HColor color) {
        this.draw(ug, series, color, null);
    }

    public void draw(UGraphic ug, ChartSeries series, HColor color, List<Double> baselineValues) {
        double y;
        double x;
        double topValue;
        double value;
        int i;
        if (this.categoryCount == 0) {
            return;
        }
        List<Double> values = series.getValues();
        double categoryWidth = this.plotWidth / (double)this.categoryCount;
        UPolygon polygon = new UPolygon();
        for (i = 0; i < Math.min(values.size(), this.categoryCount); ++i) {
            topValue = value = values.get(i).doubleValue();
            if (baselineValues != null && i < baselineValues.size()) {
                topValue = baselineValues.get(i) + value;
            }
            x = ((double)i + 0.5) * categoryWidth;
            y = this.plotHeight - (topValue - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            polygon.addPoint(x, y);
        }
        for (i = Math.min(values.size(), this.categoryCount) - 1; i >= 0; --i) {
            double x2 = ((double)i + 0.5) * categoryWidth;
            double baselineValue = this.axis.getMin();
            if (baselineValues != null && i < baselineValues.size()) {
                baselineValue = baselineValues.get(i);
            }
            double y2 = this.plotHeight - (baselineValue - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            polygon.addPoint(x2, y2);
        }
        ug.apply(color).apply(color.bg()).draw(polygon);
        for (i = 0; i < Math.min(values.size() - 1, this.categoryCount - 1); ++i) {
            double value1 = values.get(i);
            double value2 = values.get(i + 1);
            double topValue1 = value1;
            double topValue2 = value2;
            if (baselineValues != null) {
                if (i < baselineValues.size()) {
                    topValue1 = baselineValues.get(i) + value1;
                }
                if (i + 1 < baselineValues.size()) {
                    topValue2 = baselineValues.get(i + 1) + value2;
                }
            }
            double x1 = ((double)i + 0.5) * categoryWidth;
            double y1 = this.plotHeight - (topValue1 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            double x2 = ((double)i + 1.5) * categoryWidth;
            double y2 = this.plotHeight - (topValue2 - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
            ULine line = new ULine(x2 - x1, y2 - y1);
            ug.apply(color).apply(UStroke.withThickness(2.0)).apply(UTranslate.dx(x1).compose(UTranslate.dy(y1))).draw(line);
        }
        if (series.isShowLabels()) {
            for (i = 0; i < Math.min(values.size(), this.categoryCount); ++i) {
                topValue = value = values.get(i).doubleValue();
                if (baselineValues != null && i < baselineValues.size()) {
                    topValue = baselineValues.get(i) + value;
                }
                x = ((double)i + 0.5) * categoryWidth;
                y = this.plotHeight - (topValue - this.axis.getMin()) / (this.axis.getMax() - this.axis.getMin()) * this.plotHeight;
                this.drawLabel(ug, value, x, y - 8.0);
            }
        }
    }

    private void drawLabel(UGraphic ug, double value, double x, double y) {
        try {
            String label = this.formatValue(value);
            UFont font = UFont.sansSerif(10).bold();
            HColor labelColor = this.skinParam.getIHtmlColorSet().getColor("#000000");
            FontConfiguration fontConfig = FontConfiguration.create(font, labelColor, labelColor, null);
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(ug.getStringBounder());
            double labelX = x - textDim.getWidth() / 2.0;
            double labelY = y - textDim.getHeight() - 2.0;
            textBlock.drawU(ug.apply(UTranslate.dx(labelX).compose(UTranslate.dy(labelY))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatValue(double value) {
        if (Math.abs(value) < 0.01 && value != 0.0) {
            return String.format("%.2e", value);
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%.2f", value);
    }
}

