/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

public class KTableAggregate<KIn, VIn, VAgg>
implements KTableProcessorSupplier<KIn, VIn, KIn, VAgg> {
    private final String storeName;
    private final StoreFactory storeFactory;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> add;
    private final Aggregator<? super KIn, ? super VIn, VAgg> remove;
    private boolean sendOldValues = false;

    KTableAggregate(MaterializedInternal<KIn, VAgg, KeyValueStore<Bytes, byte[]>> materialized, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> add, Aggregator<? super KIn, ? super VIn, VAgg> remove) {
        this.storeFactory = new KeyValueStoreMaterializer<KIn, VAgg>(materialized);
        this.storeName = materialized.storeName();
        this.initializer = initializer;
        this.add = add;
        this.remove = remove;
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        this.sendOldValues = true;
        return true;
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return Collections.singleton(new StoreFactory.FactoryWrappingStoreBuilder(this.storeFactory));
    }

    @Override
    public Processor<KIn, Change<VIn>, KIn, Change<VAgg>> get() {
        return new KTableAggregateProcessor();
    }

    @Override
    public KTableValueGetterSupplier<KIn, VAgg> view() {
        return new KTableMaterializedValueGetterSupplier(this.storeName);
    }

    private class KTableAggregateProcessor
    implements Processor<KIn, Change<VIn>, KIn, Change<VAgg>> {
        private KeyValueStoreWrapper<KIn, VAgg> store;
        private TimestampedTupleForwarder<KIn, VAgg> tupleForwarder;

        private KTableAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VAgg>> context) {
            this.store = new KeyValueStoreWrapper(context, KTableAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store.store(), context, new TimestampedCacheFlushListener(context), KTableAggregate.this.sendOldValues);
        }

        @Override
        public void process(Record<KIn, Change<VIn>> record) {
            Object newAgg;
            Object intermediateAgg;
            if (record.key() == null) {
                throw new StreamsException("Record key for KTable aggregate operator with state " + KTableAggregate.this.storeName + " should not be null.");
            }
            ValueAndTimestamp oldAggAndTimestamp = this.store.get(record.key());
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            long newTimestamp = record.timestamp();
            if (record.value().oldValue != null && oldAgg != null) {
                intermediateAgg = KTableAggregate.this.remove.apply(record.key(), record.value().oldValue, oldAgg);
                newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
            } else {
                intermediateAgg = oldAgg;
            }
            if (record.value().newValue != null) {
                Object initializedAgg = intermediateAgg == null ? KTableAggregate.this.initializer.apply() : intermediateAgg;
                newAgg = KTableAggregate.this.add.apply(record.key(), record.value().newValue, initializedAgg);
                if (oldAggAndTimestamp != null) {
                    newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
                }
            } else {
                newAgg = intermediateAgg;
            }
            long putReturnCode = this.store.put(record.key(), newAgg, newTimestamp);
            if (putReturnCode != Long.MIN_VALUE) {
                this.tupleForwarder.maybeForward(record.withValue(new Change(newAgg, KTableAggregate.this.sendOldValues ? oldAgg : null, putReturnCode == -1L)).withTimestamp(newTimestamp));
            }
        }
    }
}

