/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesStep;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Scenario;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class GherkinMessagesPickle
implements Pickle {
    private final io.cucumber.messages.types.Pickle pickle;
    private final List<Step> steps;
    private final URI uri;
    private final CucumberQuery cucumberQuery;

    GherkinMessagesPickle(io.cucumber.messages.types.Pickle pickle, URI uri, GherkinDialect dialect, CucumberQuery cucumberQuery) {
        this.pickle = pickle;
        this.uri = uri;
        this.cucumberQuery = cucumberQuery;
        this.steps = GherkinMessagesPickle.createCucumberSteps(pickle, dialect, this.cucumberQuery);
    }

    private static List<Step> createCucumberSteps(io.cucumber.messages.types.Pickle pickle, GherkinDialect dialect, CucumberQuery cucumberQuery) {
        ArrayList<Step> list = new ArrayList<Step>();
        String previousGivenWhenThen = dialect.getGivenKeywords().stream().filter(s -> !StepType.isAstrix((String)s)).findFirst().orElseThrow(() -> new IllegalStateException("No Given keyword for dialect: " + dialect.getName()));
        for (PickleStep pickleStep : pickle.getSteps()) {
            String keyword;
            String gherkinStepId;
            io.cucumber.messages.types.Step gherkinStep;
            io.cucumber.plugin.event.Location location;
            GherkinMessagesStep step = new GherkinMessagesStep(pickleStep, dialect, previousGivenWhenThen, location = GherkinMessagesLocation.from((gherkinStep = cucumberQuery.getGherkinStep(gherkinStepId = (String)pickleStep.getAstNodeIds().get(0))).getLocation()), keyword = gherkinStep.getKeyword());
            if (step.getType().isGivenWhenThen()) {
                previousGivenWhenThen = step.getKeyword();
            }
            list.add(step);
        }
        return list;
    }

    public String getKeyword() {
        return this.cucumberQuery.getGherkinScenario((String)this.pickle.getAstNodeIds().get(0)).getKeyword();
    }

    public String getLanguage() {
        return this.pickle.getLanguage();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public io.cucumber.plugin.event.Location getLocation() {
        List sourceIds = this.pickle.getAstNodeIds();
        String sourceId = (String)sourceIds.get(sourceIds.size() - 1);
        Location location = this.cucumberQuery.getLocation(sourceId);
        return GherkinMessagesLocation.from(location);
    }

    public io.cucumber.plugin.event.Location getScenarioLocation() {
        String sourceId = (String)this.pickle.getAstNodeIds().get(0);
        Scenario scenario = this.cucumberQuery.getGherkinScenario(sourceId);
        Location location = scenario.getLocation();
        return GherkinMessagesLocation.from(location);
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<String> getTags() {
        return this.pickle.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.pickle.getId();
    }
}

