/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.ClasspathSupport;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GluePath {
    private static final Logger log = LoggerFactory.getLogger(GluePath.class);
    private static final Pattern WELL_KNOWN_PROJECT_SOURCE_DIRECTORIES = Pattern.compile("src/(?:main|test)/(?:java|kotlin|scala|groovy)(|/|/.+)");

    private GluePath() {
    }

    public static URI parse(String gluePath) {
        Objects.requireNonNull(gluePath, "gluePath may not be null");
        if (gluePath.isEmpty()) {
            return ClasspathSupport.rootPackageUri();
        }
        if ("classpath:".equals(gluePath)) {
            return ClasspathSupport.rootPackageUri();
        }
        if (GluePath.nonStandardPathSeparatorInUse(gluePath)) {
            String standardized = GluePath.replaceNonStandardPathSeparator(gluePath);
            return GluePath.parseAssumeClasspathScheme(standardized);
        }
        if (GluePath.isProbablyPackage(gluePath)) {
            String path = ClasspathSupport.resourceNameOfPackageName(gluePath);
            return GluePath.parseAssumeClasspathScheme(path);
        }
        return GluePath.parseAssumeClasspathScheme(gluePath);
    }

    private static boolean nonStandardPathSeparatorInUse(String featureIdentifier) {
        return File.separatorChar != '/' && featureIdentifier.contains(File.separator);
    }

    private static String replaceNonStandardPathSeparator(String featureIdentifier) {
        return featureIdentifier.replace(File.separatorChar, '/');
    }

    private static URI parseAssumeClasspathScheme(String gluePath) {
        URI uri = URI.create(gluePath);
        GluePath.warnWhenWellKnownProjectSourceDirectory(gluePath);
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if (!GluePath.isValidIdentifier(schemeSpecificPart)) {
            throw new IllegalArgumentException("The glue path contained invalid identifiers " + uri);
        }
        if (uri.getScheme() == null) {
            try {
                return new URI("classpath", schemeSpecificPart.startsWith("/") ? schemeSpecificPart : "/" + schemeSpecificPart, uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if (!"classpath".equals(uri.getScheme())) {
            throw new IllegalArgumentException("The glue path must have a classpath scheme " + uri);
        }
        return uri;
    }

    private static void warnWhenWellKnownProjectSourceDirectory(String gluePath) {
        Matcher matcher = WELL_KNOWN_PROJECT_SOURCE_DIRECTORIES.matcher(gluePath);
        if (!matcher.matches()) {
            return;
        }
        log.warn(() -> {
            String classPathResource = matcher.group(1);
            if (classPathResource.startsWith("/")) {
                classPathResource = classPathResource.substring(1);
            }
            if (classPathResource.endsWith("/")) {
                classPathResource = classPathResource.substring(0, classPathResource.length() - 1);
            }
            String packageName = classPathResource.replaceAll("/", ".");
            String message = "Consider replacing glue path '%s' with '%s'.\n'\nThe current glue path points to a source directory in your project. However cucumber looks for glue (i.e. step definitions) on the classpath. By using a package name you can avoid this ambiguity.";
            return String.format(message, gluePath, packageName);
        });
    }

    private static boolean isProbablyPackage(String gluePath) {
        return gluePath.contains(ClasspathSupport.PACKAGE_SEPARATOR_STRING) && !gluePath.contains(ClasspathSupport.RESOURCE_SEPARATOR_STRING);
    }

    private static boolean isValidIdentifier(String schemeSpecificPart) {
        for (String part : schemeSpecificPart.split("/")) {
            for (int i = 0; i < part.length(); ++i) {
                if ((i != 0 || Character.isJavaIdentifierStart(part.charAt(i))) && (i == 0 || Character.isJavaIdentifierPart(part.charAt(i)))) continue;
                return false;
            }
        }
        return true;
    }
}

