/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseView;
import org.jkiss.dbeaver.ext.generic.edit.GenericViewManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ClickhouseViewManager
extends GenericViewManager {
    protected String getViewType(GenericTableBase object) {
        return "TABLE";
    }

    @NotNull
    protected GenericTableBase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @NotNull Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        GenericStructContainer structContainer = (GenericStructContainer)container;
        String tableName = this.getNewChildName(monitor, (DBSObject)structContainer, "NewView");
        GenericTableBase viewImpl = structContainer.getDataSource().getMetaModel().createTableOrViewImpl(structContainer, tableName, "VIEW", null);
        if (viewImpl instanceof GenericView) {
            ((GenericView)viewImpl).setObjectDefinitionText("CREATE OR REPLACE VIEW " + viewImpl.getFullyQualifiedName(DBPEvaluationContext.DDL) + " AS SELECT 1 as A\n");
        }
        return viewImpl;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        ClickhouseView view = (ClickhouseView)command.getObject();
        String sql = view.getDDL();
        if (sql.contains("CREATE") && !sql.contains("CREATE OR REPLACE")) {
            sql = sql.replaceFirst("CREATE", "CREATE OR REPLACE");
        }
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", sql));
    }
}

