/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.cluster.meta.ClusterMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMeta
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMeta.class);
    public static final String NODE_NAME = "NODE_NAME";
    public static final String SERVER_HOST = "SERVER_HOST";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String SERVER_START_TIME = "SERVER_START_TIME";
    public static final String INTP_PROCESS_NAME = "INTP_PROCESS_NAME";
    public static final String INTP_TSERVER_HOST = "INTP_TSERVER_HOST";
    public static final String INTP_TSERVER_PORT = "INTP_TSERVER_PORT";
    public static final String INTP_START_TIME = "INTP_START_TIME";
    public static final String CPU_CAPACITY = "CPU_CAPACITY";
    public static final String CPU_USED = "CPU_USED";
    public static final String MEMORY_CAPACITY = "MEMORY_CAPACITY";
    public static final String MEMORY_USED = "MEMORY_USED";
    public static final String LATEST_HEARTBEAT = "LATEST_HEARTBEAT";
    public static final String STATUS = "STATUS";
    public static final String ONLINE_STATUS = "ONLINE";
    public static final String OFFLINE_STATUS = "OFFLINE";
    public static final String INTP_PROCESS_COUNT = "INTP_PROCESS_COUNT";
    public static final String INTP_PROCESS_LIST = "INTP_PROCESS_LIST";
    private Map<String, Map<String, Object>> mapServerMeta = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> mapInterpreterMeta = new HashMap<String, Map<String, Object>>();

    public void put(ClusterMetaType type, String key, Object value) {
        Map mapValue = (Map)value;
        switch (type) {
            case SERVER_META: {
                if (this.mapServerMeta.containsKey(key)) {
                    Map<String, Object> values = this.mapServerMeta.get(key);
                    values.putAll(mapValue);
                    break;
                }
                this.mapServerMeta.put(key, mapValue);
                break;
            }
            case INTP_PROCESS_META: {
                if (this.mapInterpreterMeta.containsKey(key)) {
                    Map<String, Object> values = this.mapInterpreterMeta.get(key);
                    values.putAll(mapValue);
                    break;
                }
                this.mapInterpreterMeta.put(key, mapValue);
            }
        }
    }

    public Map<String, Map<String, Object>> get(ClusterMetaType type, String key) {
        Map<String, Object> values = null;
        switch (type) {
            case SERVER_META: {
                if (null == key || StringUtils.isEmpty((CharSequence)key)) {
                    return this.mapServerMeta;
                }
                if (this.mapServerMeta.containsKey(key)) {
                    values = this.mapServerMeta.get(key);
                    break;
                }
                LOGGER.warn("can not find key : {}", (Object)key);
                break;
            }
            case INTP_PROCESS_META: {
                if (null == key || StringUtils.isEmpty((CharSequence)key)) {
                    return this.mapInterpreterMeta;
                }
                if (this.mapInterpreterMeta.containsKey(key)) {
                    values = this.mapInterpreterMeta.get(key);
                    break;
                }
                LOGGER.warn("can not find key : {}", (Object)key);
            }
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put(key, values);
        return result;
    }

    public Map<String, Object> remove(ClusterMetaType type, String key) {
        switch (type) {
            case SERVER_META: {
                if (this.mapServerMeta.containsKey(key)) {
                    return this.mapServerMeta.remove(key);
                }
                LOGGER.warn("can not find key : {}", (Object)key);
                break;
            }
            case INTP_PROCESS_META: {
                if (this.mapInterpreterMeta.containsKey(key)) {
                    return this.mapInterpreterMeta.remove(key);
                }
                LOGGER.warn("can not find key : {}", (Object)key);
            }
        }
        return null;
    }
}

